///////////////////////////////////////////////////////////
// Sand.Pov:    Creates scene of "sands of time".
//              scene shows a dead world, a moon
//              of a ringed planet.
//              Numerous stopwatches signify the
//              passage of time.
//
//              Rex McDonald
//              rexm@xmission.com
//              1-801-974-3706
//
//              6-14-96
//
///////////////////////////////////////////////////////////

#max_trace_level 4
#version 3.0
global_settings {
        assumed_gamma 2.2
}

// Here are all of our external objects, designed in Moray.
//
#include "planetr.pov"
#include "ruins.pov"
#include "sundial.pov"
#include "clocks.pov"

//background { color rgb<1,1,1> }

camera {  //  Camera StdCam
  location  <0.000, -4.6000, 0.30>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, 0.000, 0.500>
}

// *******  L I G H T S *******
light_source {   // Light1
  <3.5, -9, 8.5>
  color rgb <0.9, 0.80, 0.75>
  fade_distance 14.0
  fade_power 2.75
}

light_source {  // Light2
  <45,38,8>
  color rgb <1,0.9,.8>
  atmosphere off
}

light_source {  // Light3
  <-40,120,0>
  color rgb <1,1,1>
  atmosphere off
}

// main light source
light_source {  // Light Sun
  <60,50,16>
  color rgb <.9,.7,.5>
  atmosphere off
}

light_source {  // Shadow Caster
  <-21.75, 59, 2.0>
  color rgb <.6,.5,1>
  atmosphere off
}

light_source { // Dim Star
  <18,55,4>
  color rgb <0.5,0.3,0.7>
  looks_like {
    sphere {
      <0, 0, 0> .10
      pigment {
        color rgb <1.0,0.5,1.0>
      }
      finish {
        ambient 1.0
        diffuse 1.0
      }
    }
  }
  fade_distance 16.0
  fade_power    2.50
}

light_source { // Dim Star 2
  <10,55,7>
  color rgb <0.7,0.3,0.5>
  looks_like {
    sphere {
      <0, 0, 0> .08
      pigment {
        color rgb <1.0,0.8,0.8>
      }
      finish {
        ambient 1.0
        diffuse 1.0
      }
    }
  }
  fade_distance 15
  fade_power    3.25
}

light_source { // Dim Star 3
  <13,54,9>
  color rgb <0.0,0.5,0.7>
  looks_like {
    sphere {
      <0, 0, 0> .08
      pigment {
        color rgb <1.0,0.8,0.8>
      }
      finish {
        ambient 1.0
        diffuse 1.0
      }
    }
  }
  fade_distance 15
  fade_power    3.25
}

light_source { // Bright Star
  <16,60,16>
  color rgb <0.80, 0.60, 0.45>
  looks_like {
    sphere {
      <0, 0, 0> .12
      pigment {
        color rgb <1,1,1>
      }
      finish {
        ambient 1.0
        diffuse 1.0
      }
    }
  }
  fade_distance 25.0
  fade_power    2.4
}

light_source { // Bright Star 2
  <-22, 60, 2.5>
  color rgb <0.5, 0.4, 1.0>
  looks_like {
    sphere {
      <0, 0, 0> .10
      pigment {
        color rgb <1,1,1>
      }
      finish {
        ambient 1.0
        diffuse 1.0
      }
    }
  }
  fade_distance 15.0
  fade_power    2.75
}

atmosphere {
  type 3	      // Mie (Nighttime lighthouse)
  samples 20          // Number of samples in first distance interval
  distance 60         // Atmosphere density, similar to fog
  scattering .035     // Reflectivity of atmosphere, determines brightness
//  aa_level 8        // Level of binary subdivision in case of aa
//  aa_threshold 0.1  // Threshold for aa to push in
//  jitter 0.2        // Amount of sample jittering
}

// Sky Sphere
sphere {
  <0,20,0>, 90.0
  texture {
   pigment {
     spotted
     //turbulence 0.15
     color_map {
        [0.0  color rgb <0,0,0> ]
        [0.98 color rgb <0,0,0> ]
        [0.98 color rgbt<1,1,1,0> ]
        [1.0  color rgb <1,1,1> ]
        [1.0  color rgbt<1,1,1,1> ]
     }
   }
   finish {
     ambient 1.0
     roughness 0.5
   }
   scale 0.20
  }
  no_shadow
  hollow
}

// ********  TEXTURES  *******
//

#include "sand.inc"


// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

object {   // SandFld
  height_field {
    tga "SHEIGHT.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Sand
  }
  scale <2.5, 2.5, 0.3>
  translate <0,-1.25,-.1>
}

object {   // SandFld2
  height_field {
    tga "SHEIGHT.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Sand
  }
  scale <4.0, 4.0, 0.4>
  rotate 45*z
  translate <0.0, 1.25, -0.05>
}

object {
  Ruins
  rotate <0,0,-10>
  scale <.07,.07,.07>
  translate <0.13,-3.15,0.17>
}

object {
  SunDial
  rotate <8,0,85>
  scale .06
  translate <-.34,-3.05,.022>
}

object {
  RPlanet
  scale 0.3
  rotate <12,10,0>
  translate <-7,45,6>
}

sphere {        // moon
  <5,50,14>, 1.85
  texture {
   pigment {
      bozo
      turbulence 0.75
      frequency 0.75
      colour_map {
         [0.0   color rgb<1.0,.6,.8>]
         [1.0   color rgb<.4,.2,.3>]
      }
      rotate <0, 15, -25>
   }
   finish {
     ambient 0.1
     diffuse 0.5
   }
  }
}

object {
  cylinder { <-35,0,0> <35,0,0> 5
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 0.45
      frequency  2.5
      eccentricity 0.25
      jitter 0.60
      color_map {
        [ 0  color rgbt <0,0,0,1> ]
        [ .65 color rgbt <0,.2,.4,1> ]
        [ 1  color rgbt <.5,.4, 1.0,.65> ]
      }
      scale <50,6,4>
      samples 10
    }
    hollow
    rotate 15*y
  }
  hollow
  translate <5,70,11>
}

object {
  sphere { 0, 20
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      spherical_mapping
      cubic
      turbulence .75
      eccentricity 0.25
      jitter 0.40
      color_map {
        [ 0 color rgbt <1, 0, .25,  1> ]
        [ 1 color rgbt <.6, .6, 1, -1> ]
      }
      samples 10
      scale 0.75
    }
    hollow
    scale <15, 10, 8>
  }
  hollow
  translate <10,60,9>
}
