
#declare	CurrentX = 0
#declare	CurrentY = 0
#declare	CurrentZ	= 0

#declare Pedestal = union {
	#declare counter = 0
	#while (counter < NSteps)
		union {
			box {
				<CurrentX, CurrentY, CurrentZ>, 
					<Width - CurrentX, CurrentY + StepHeight, Width - CurrentZ>
			}
			// bevels
			#declare	EdgeHeight	= CurrentY + StepHeight - RollSize
			cylinder {
				<CurrentX, EdgeHeight, CurrentZ>, <Width - CurrentX, EdgeHeight, CurrentZ>, RollSize
			}
			cylinder {
				<CurrentX, EdgeHeight, Width - CurrentZ>, < Width - CurrentX, EdgeHeight, Width - CurrentZ>, RollSize
			}
			cylinder {
				<Width - CurrentX, EdgeHeight, Width - CurrentZ>, <Width - CurrentX, EdgeHeight, CurrentZ>, RollSize
			}
			cylinder {
				<CurrentX, EdgeHeight, Width - CurrentZ>, <CurrentX, EdgeHeight, CurrentZ>, RollSize
			}
			// little balls to join the bevels
			sphere {
				<CurrentX, EdgeHeight, CurrentZ>, RollSize
			}
			sphere {
				<CurrentX, EdgeHeight, Width - CurrentZ>, RollSize
			}
			sphere {
				<Width - CurrentX, EdgeHeight, Width - CurrentZ>, RollSize
			}
			sphere {
				<Width - CurrentX, EdgeHeight, CurrentZ>, RollSize
			}
			texture {
#ifdef (TESTS)
				pigment {
					color White
				}
#else
				T_Stone17
				translate counter * 10		// make the texture not join across steps
				scale .4
#end
			}
		}
		#declare counter = counter + 1
		#declare CurrentX = CurrentX + XWidth
		#declare CurrentZ = CurrentZ + ZWidth
		#declare CurrentY = CurrentY + StepHeight
	#end
}	

