
#declare	CurrentHeight	= StepHeight
#declare	CurrentWidth	= StartWidth

#declare InnerStart = StartWidth
#declare InnerEnd = StepLength - InnerStart


#declare Steps = union {
	#declare counter = 0
	#while (counter < NSteps)
		union {
			box {
				<0, CurrentHeight - StepHeight, 0>, <StepLength, CurrentHeight, CurrentWidth>
			}
			#declare	RollSize = .03
			#declare	Mid = CurrentHeight - RollSize
			cylinder {
				<0, Mid, CurrentWidth>, <StepLength, Mid, CurrentWidth>,
					RollSize
			} 
			texture {
#ifdef (TESTS)
				pigment {
					color White
				}
#else
				T_Stone17
#end
				translate counter * 10		// make the texture not join across steps
				scale .4
			}
		}
		#declare counter = counter + 1
		#declare CurrentWidth = CurrentWidth - StepWidth
		#declare CurrentHeight = CurrentHeight + StepHeight
	#end
}	




#declare	OuterSteps = union {
	object {
		Steps
	}
	object {
		Steps
		rotate <0, 90, 0>
		translate <0, 0, StepLength>
	}
	object {
		Steps
		rotate <0, 180, 0>
		translate <StepLength, 0, StepLength>
	}
	object {
		Steps
		rotate <0, -90, 0>
		translate <StepLength, 0, 0>
	}
}

