//Preview_Start_Size=4 Preview_End_Size=4
// +AM2 +A0.3
#version 3.0
#include "colors.inc"
#include "shapes.inc"
#include "metals.inc"
#include "stones.inc"

//#declare TESTS = 1

#include "timetex.inc"
#include "urn.inc"
#include "sundial.inc"


light_source { 
	<50, 100, 20> 
	color White
}

camera {
	location <7, 2.5, 9> 
	look_at <4.5, 0, 0> 
}


#declare CP	= 0.001	// cutting precision

#declare StepWidth  = .3
#declare	StepHeight = .2
#declare	StepLength = 10		// X length
#declare StartWidth = 2			// deepest Z

#declare	NSteps	= 5

#include "steps.inc"

object {
	OuterSteps
}

#declare FromEdge = StepWidth

#declare	UrnScale = 1.3
object {
	Urn
	scale UrnScale
	translate <StepWidth, (NSteps - 1) * StepHeight, StepWidth>
} 

object {
	Urn
	scale UrnScale
	translate <StepWidth, (NSteps - 1) * StepHeight, StepLength - StepWidth>
} 

object {
	Urn
	scale UrnScale
	translate <StepLength - StepWidth, (NSteps - 1) * StepHeight, StepWidth>
} 

object {
	Urn
	scale UrnScale
	translate <StepLength - StepWidth, (NSteps - 1) * StepHeight, StepLength - StepWidth>
} 


#ifndef (TESTS)

box	{ 
	<InnerStart, 0, InnerStart>,	<InnerEnd, .01, InnerEnd>
	texture {
		tiles {
			texture {
				pigment {
					color rgb<1,1,1>
				}
			} 
			tile2 texture {
				pigment {
					color rgb<0,.5,1>
				}
			}
		}
		scale <.1,.1,.1>
	}
}
#end

#declare	WaterHeight	= .33
box	{ 
	<0 + CP, 0, 0 + CP>,	<StepLength - CP, WaterHeight, StepLength - CP>
	texture {
#ifdef (TESTS)
		pigment {
			color Blue
		}
#else
		RipplyWater
#end
	}
}

#declare	Width	= 4	// total square width

// step widths
#declare	XWidth = .2
#declare ZWidth = .2

#declare	StepHeight = .15

#declare	NSteps	= 6	// Width / 2
#declare	RollSize	= .02

#include	"pedestal.inc"

object {
	Pedestal
	texture { 
		pigment { color Yellow } 
 	}
 	translate <(StepLength / 2) - (Width / 2), 0, (StepLength / 2) - (Width / 2)>
}

object {
	SunDial
 	rotate <0, 90, 0>
 	scale 1.2
 	translate <StepLength / 2, StepHeight * NSteps, StepLength / 2>
}


#declare Grass2 = texture
{
pigment
  {
    image_map
    {
      gif "Stt022.gif"
    }
	scale .02
    turbulence 0.5

  }
 }

#declare Sea = texture
{
  pigment
  {
    colour rgb<0,.6,.8>
  }
  normal
  {
    waves 0.7
    turbulence 0.14  octaves 10  omega 0.01
    frequency 10
    translate <0.0, 0.0, 20.0>
    scale <5.0, 1.0, 5.0>
  }
  finish {
    phong 0.97    phong_size 65
    reflection 0.29
  }
}



plane {y,0
	texture { Sea } 
}


sky_sphere {
  pigment {
    color SkyBlue

  }
  pigment {
    bozo
    turbulence 0.6
    octaves 7
    omega .49876
    lambda 2.5432
    color_map {
      [0.0 color rgbf<.75, .75, .75, 0.1>]
      [0.4 color rgbf<.9, .9, .9, .9>]
      [0.7 color rgbf<1, 1, 1, 1>]
    }
    scale 6/10
    scale <1, 0.3, 0.3>
  } 
}

height_field {
	gif "hf.ghf"
	texture { 
		Grass2
	} 
	translate <-.5, 0, -.5>
	rotate y*(-40)
	scale <100,30,100>
#ifndef (TESTS)
	smooth
#end
}
