#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "stones.inc"
#include "chars.inc"
// Render time: 5h31m43s @640x480 antialiased (with tiles) R5000 27/6/96

#declare BrushedSteel=
texture{
   pigment { color White }
   normal { waves 0.35 frequency 2 scale 0.01 }
   finish {
       ambient 0.35
       diffuse 1.00
       brilliance 15
       phong 0.41
       phong_size 5
   }
}

#default {pigment{color White}}
camera {
  location<10,1.7,-12>     //<8,1.7,-10>
  look_at<1.5,0,0>
}

#declare Dirt = 
  pigment{marble
          color_map{
            [0 color Khaki filter 0.7]
            [0.2 color Khaki filter 0.7]
            [0.2 color Khaki filter 0.8]
            [0.5 color Khaki filter 0.8]
            [0.5 color Khaki filter 0.7]
            [0.7 color Khaki filter 0.7]
            [0.7 color Khaki filter 0.6]
            [0.9 color Khaki filter 0.6]
            [0.9 color Khaki filter 0.5]
            [1.0 color Khaki filter 0.5]
          }
    turbulence 2.3
  }

#declare LightSource=
union{
  box{<-0.5,-0.2,-0.5>,<0.5,0,0.5> texture{BrushedSteel}}
  box{<-0.5,-0.6,-0.5>,<0.5,-0.2,0.5> texture{pigment{color White} finish{Luminous}}}
  scale 0.5
}

light_source{<6,1,10> color White }  //station lighting
light_source{<6,1,4> color White}
light_source{<6,1,-2> color White}
light_source{<6,1,-8> color White}

#declare CurvedSquare=
union{
  box{<-1,-1,0>,<1,1,1>}
  cylinder{<1,1,0>,<1,1,1>,.2}
  cylinder{<1,-1,0>,<1,-1,1>,.2}
  cylinder{<-1,1,0>,<-1,1,1>,.2}
  cylinder{<-1,-1,0>,<-1,-1,1>,.2}
  box{<1,-1,0>,<1.2,1,1>}
  box{<-1,1,0>,<1,1.2,1>}
  box{<-1.2,-1,0>,<-1,1,1>}
  box{<-1,-1.2,0>,<1,-1,1>}
}

#include "traingrl.inc"

#include "back.inc"

#declare BaseArch=
union{
  box{<-4,-6,0>,<4,0,15>}
  cylinder{<0,0,0>,<0,0,15>,2 scale<2,1,1>}
}

#declare DestBoard=
union{
  object{char_1}
  object{char_7 translate<3,0,0>}
  object{char_9 translate<7.5,0,0>}
  object{char_2 translate<12,0,0>}
  pigment{color White}
  finish{Luminous}
  scale <0.13,0.08,0.1>
}

#declare TrainCar=
union{
  difference{
    union{ //base train shape
      box{<-4,-6,0>,<4,0,15>}
      cylinder{<0,0,0>,<0,0,15>,2 scale<2,1,1>}
      #include "lines.inc" //these are the corrigations on the train sides
      texture{pigment{color White} finish{Glossy}}
      texture{Dirt scale 0.2}   //add some dirt to the outside
    }
    union{  //  hollow it out
      box{<-3,-5,0.5>,<3,0,14.5>}
      cylinder{<0,0,0.5>,<0,0,14.5>,1.8 scale<2,1,1>}
      texture{pigment{color Orange} finish{ambient 0.85}}
    }
    object{CurvedSquare translate<0,-1,-0.01> scale<0.8,2.2,1>}  //front door
    box{<-1.2,0.8,-0.1>,<1.2,1.3,0.2> pigment{color Black}} // dest board
    box{<-3.5,-2.5,-0.1>,<-1.5,-0.5,1>}  //front windows
    box{<3.5,-2.5,-0.1>,<1.5,-0.5,1>}
    box{<-5,-3,2>,<5,-0.5,4>}  //window
    box{<1,-5,5>,<5,0,8>}  //side door
    box{<-5,-3,9>,<5,-0.5,11>}  //window
    box{<-5,-3,12>,<5,-0.5,14>}  //window
  }
  object{DestBoard translate<-0.9,0.85,0.19>}
  //doors and windows-----------------------------------v
  box{<-3.5,-2.5,0>,<-1.5,-0.5,0.2> texture{Glass}}  //front window
  box{<3.5,-2.5,0>,<1.5,-0.5,0.2> texture{Glass}}  //front window
  box{<3.8,-3,2>,<4,-0.5,4> texture{Glass}}  //window
  box{<3.8,-3,9>,<4,-0.5,11> texture{Glass}}  //window
  box{<3.8,-3,12>,<4,-0.5,14> texture{Glass}}  //window
  difference{
    box{<-1.5,-5,0.3>,<1.5,0.75,0.4>}  // front door
    box{<-0.5,-3,-0.1>,<0.5,0,0.5>}
    texture{pigment{color White} finish{Glossy}}
    texture{Dirt scale 0.2}
  }
  box{<-0.5,-3,0.3>,<0.5,0,0.4> texture{Glass}}
  box{<1.5,-4,-0.01>,<3.5,-3,0.2> pigment{     // Transit comission logo
      image_map{tga "\povray\scenes\ttc2.tga" filter 1,1.0} 
      scale<2,1,1>
      translate<-0.5,0,0>
    }
  }
  difference{
    box{<3.5,-5,5>,<3.7,0,6.5>}  //side door
    box{<1,-3,5.25>,<4,-0.5,6.25>}
  }
  box{<3.5,-3,5.25>,<3.7,-0.5,6.25> texture{Glass}} //side door window
  difference{
    box{<3.5,-5,6.5>,<3.7,0,8>}  //side door
    box{<1,-3,6.75>,<4,-0.5,7.75>}
  }
  box{<3.5,-3,6.75>,<3.7,-0.5,7.75> texture{Glass}} //side door window
}

#declare StationName=
union{
  object{char_1}
  object{char_9 translate<3,0,0>}
  object{char_8 translate<7.5,0,0>}
  object{char_2 translate<12,0,0>}
  pigment{color Black}
}

#declare Tracks=
union{
  union {
    cylinder{<-3.,-7.4,-12>,<-3.,-7.4,14>,0.15}
    box{<-3.1,-7.7,-12>,<-2.9,-7.4,14>}
    pigment{color Gray50} finish{Metal}
  }
  union {
    cylinder{<3.,-7.4,-12>,<3.,-7.4,14>,0.15}
    box{<3.1,-7.7,-12>,<2.9,-7.4,14>}
    pigment{color Gray50} finish{Metal}
  }
  box{<-4,-8.5,10.2>,<4,-7.5,10.7> texture {DMFWood3}}
  box{<-4,-8.5,7.2>,<4,-7.5,7.5> texture {DMFWood3}}
  box{<-4,-8.5,4.2>,<4,-7.5,4.7> texture {DMFWood3}}
  box{<-4,-8.5,1.2>,<4,-7.5,1.7> texture {DMFWood3}}
  box{<-4,-8.5,-2.2>,<4,-7.5,-2.7> texture {DMFWood3}}
  box{<-4,-8.5,-5.2>,<4,-7.5,-5.7> texture {DMFWood3}}
  box{<-4,-8.5,-8.2>,<4,-7.5,-8.7> texture {DMFWood3}}
  box{<-4,-8.5,-11.2>,<4,-7.5,-11.7> texture {DMFWood3}}
}

#declare TimesBox=
union{
  difference{  //body of the paperbox
    box{<6.25,-5,12>,<7.75,-2.5,14> }
    box{<6.35,-3.8,11.9>,<7.65,-2.6,13.8> pigment{color Black}}
  }
  box{<6.65,-2.5,12>,<7.35,-1.75,12.75>}  //part where you put the money in
  box{<6.75,-2.25,11.999>,<7.25,-1.85,12> texture{Polished_Chrome}} //coin plate
  box{<6.35,-3.8,12>,<7.65,-2.6,12.1> texture{Glass}} //glass front
  box{<6.35,-4.9,11.99>,<7.65,-3.9,12.01> pigment{ //name card
      image_map{tga "\povray\scenes\times.tga"} 
      scale<1.3,1,1>
      translate<-0.17,0.1,0>
    }
  }
  pigment{color Red} finish{Shiny}
} 

#declare Station=
union{
  difference{
    union{
      box{<-5,-8,-12>,<10,4,14> texture{pigment{color Yellow} finish{Shiny}}
        texture{pigment {gradient y    //these are textures for the tiles
          color_map{ 
            [0 0.93 color Clear color Clear]
            [0.93 1 color Gray40 color Gray40]
          }
        }}
        texture{pigment {gradient x
          color_map{ 
            [0 0.93 color Clear color Clear]
            [0.93 1 color Gray40 color Gray40]
          }
        }}
        texture{pigment {gradient z
          color_map{ 
            [0 0.93 color Clear color Clear]
            [0.93 1 color Gray40 color Gray40]
          }
        }}
      }
      box{<-5,-8,-12>,<5,-5,14> texture{Grnt7}}
    }
    object{BaseArch scale <1.2,1.2,10> pigment{color Clear}}
    object{BaseArch scale <1.2,1.2,1> translate<0,0,-13> pigment{color Clear}}
    box{<-4.5,-7,-11>,<9.5,3,13> pigment{color Clear}}
    //box{<-4.55,2.5,-11.05>,<9.55,2.52,12.05> pigment{color White}}
  }
  box{<-5,3.99,-12>,<10,7,14> pigment{color Yellow} finish{crand 0.05} } //celing
  box{<4.9,-7,-11>,<12.5,-5,14> texture{Grnt9}}  //platform
  object {StationName rotate y*-90 translate <-7,-2,-11.5> scale <0.7,0.5,0.4>}
  object {LineName rotate y*-90 translate<-24.5,-12.5,-25> scale .2}
  object {Tracks}
  object {TimesBox}
}

box{<5,1.5,13.99>,<8,3,13.9>   //line directory sign
  pigment{
    image_map{tga "\povray\scenes\back.tga"} 
    scale<3,1.5,1>
    translate<2,0,0>
  }
}
box{<6.3,0,13.99>,<9.3,1.5,13.9>   //line directory sign
  pigment{
    image_map{tga "\povray\scenes\fwdline.tga"} 
    scale<3,1.5,1>
    translate<0.3,0,0>
  }
}

object {TrainCar}

object {Station}
object {LightSource translate <6,4,10>}  //show a lamp
object {LightSource translate <6,4,4>}   //heck, show a few lamps
object {LightSource translate <6,4,-2>}
object {LightSource translate <6,4,-8>}

object{JuliaWatson translate <7,-2.7,3>}  //passenger on the platform

light_source {<1.6,-0.5,2> color White}  // light the inside of the car

object{SpikeJones   //passenger in the train
  finish {ambient 0.5} 
  translate <1,-2.5,3>
}  
