// Persistence Of Vision raytracer version 3.0 sample file
// File by Dan Farmer, 1995

#include "colors.inc"
#include "textures.inc"
#include "skies.inc"
#include "metals.inc"
#include "woodmaps.inc"
#include "tree.inc"


camera {
    location <0,  0.075, -0.45>
    up y
    right  <4/3, 0, 0>
    direction z   // normal
//    direction 9*z  // zoom in
    look_at <0, 0.075, 0>  // normal
//    look_at <-0.15, 0.055+0.01, 0.177>  // look at beacon
//    look_at <0.032, 0.03, -0.40>  // look at tree
//    look_at <-0.015, 0.04, -0.05-0.3>  // look at Post
//    look_at <-0.02,0.045,-0.32>   // look at warf
//      look_at <-0.15, 0.055, 0.177>  // look at land
}


/*
camera {   // look down
    location <0,  1, -0.45>
    up y
    right  <4/3, 0, 0>
    direction 0.4*z
    look_at <0, 0.075, 0>
//    look_at <0, 0.075, -0.45>  // look at looking from place
//    look_at <0, 0.075, -0.40>  // look at warf pos
}


object
{
	sphere { <0,0.075,-0.45>,0.01}
	pigment
	{
		colour Green
	}
}
*/

#declare WoodTexture = texture
{
	pigment
	{
		wood
		color_map
		{
			M_Wood6A
		}
//		turbulence <0.04, 0.04, 0.1>
		turbulence <0.06,0.06,0.15>
//		turbulence 0
		octaves 1
		omega 1.25
		scale <0.15, .15, 1>
		scale 0.2
	}
	finish
	{
                ambient 0.2
                diffuse 0.2
	}
        normal
        {
                wrinkles 1
		scale <0.1,0.1,1>
                scale 0.1
        }

	rotate <3,0,0>
	rotate <0,90,0>
}

#declare WarfTexture = texture
{
	pigment
	{
		wood
		color_map
		{
                        M_Wood7A
		}
//		turbulence <0.04, 0.04, 0.1>
		turbulence <0.06,0.06,0.15>
//		turbulence 0
		octaves 1
		omega 1.25
		scale <0.15, .15, 1>
		scale 0.2
	}
	finish
	{
                ambient 0.2
//                ambient 0.7
                diffuse 0.2
	}
        normal
        {
                wrinkles 1
		scale <0.1,0.1,1>
                scale 0.1
        }

	rotate <3,0,0>
	rotate <0,90,0>
}



object  // Warf
{
        union
        {
                object  // main deck surface
                {
                        box
                        {
                                <-0.5,0.1,-0.75>,
                                <0.5,0.15,0.75>
                        }
                        texture
                        {
                                WarfTexture
                        }
                        texture
                        {
                                pigment
                                {       
                                        gradient z
                                        color_map {
                                                    [0.0 color rgbf <1.0, 1.0,1.0,1.0>]
                                                    [0.80 color rgbf <1.0,1.0,1.0,1.0>]
                                                    [0.80 color rgbf <0.0,0.0,0.0,0.0>]
                                                    [1.00 color rgbf <0.0,0.0,0.0,0.0>]
                                        }
                                        scale 0.1
                                        translate <0,0,10>
                                }
                        }
                }
                object // support for main deck
                {
                        box  
                        {
                                <-0.45,0.0,-0.70>,
                                <0.45,0.10,0.70>
                        }
                        texture
                        {
                                WarfTexture
                        }
                }

                object  // metal support for diving board
                {
                        union
                        {
                                cylinder  // one of four verticle supports
                                {
                                        <-0.1,0,-0.1>,
                                        <-0.1,0.25,-0.1>,
                                        0.015
                                }
                                cylinder  // one of four verticle supports
                                {
                                        <0.1,0,-0.1>,
                                        <0.1,0.25,-0.1>,
                                        0.015
                                }
                                cylinder  // one of four verticle supports
                                {
                                        <0.1,0,0.1>,
                                        <0.1,0.25,0.1>,
                                        0.015
                                }
                                cylinder  // one of four verticle supports
                                {
                                        <-0.1,0,0.1>,
                                        <-0.1,0.25,0.1>,
                                        0.015
                                }
                                cylinder // one of two bars parallel to board
                                {
                                        <0.1,0.25,0.1>,
                                        <0.1,0.25,-0.1>,
                                        0.015
                                }
                                cylinder // one of two bars parallel to board
                                {
                                        <-0.1,0.25,0.1>,
                                        <-0.1,0.25,-0.1>,
                                        0.015
                                }
                                cylinder
                                {
                                        <-0.1,0.15,-0.1>,
                                        <0.1,0.15,-0.1>,
                                        0.015
                                }
                                cylinder
                                {
                                        <-0.1,0.15,0.1>,
                                        <0.1,0.15,0.1>,
                                        0.015
                                }
                                cylinder   // ladder rung
                                {
                                        <-0.1,0.075,-0.1>,
                                        <0.1,0.075,-0.1>,
                                        0.015
                                }
                        }
                        translate <0,0.15,0.55>
                        texture
                        {
                                T_Chrome_4A
                        }
                 }

                object  // metal ladder
                {
                        union
                        {
                                cylinder  // one of two verticle bars
                                {
                                        <-0.1,-0.3,0>,
                                        <-0.1,0.3,0>,
                                        0.015
                                }
                                cylinder  // one of two verticle bars
                                {
                                        <0.1,-0.3,0>,
                                        <0.1,0.3,0>,
                                        0.015
                                }
                                cylinder   // ladder rung
                                {
                                        <-0.1,0.075,0>,
                                        <0.1,0.075,0>,
                                        0.015
                                }
                                cylinder   // ladder rung
                                {
                                        <-0.1,0,0>,
                                        <0.1,0,0>,
                                        0.015
                                }
                                cylinder   // ladder rung
                                {
                                        <-0.1,0.15,0>,
                                        <0.1,0.15,0>,
                                        0.015
                                }
                                cylinder   // ladder rung
                                {
                                        <-0.1,0.225,0>,
                                        <0.1,0.225,0>,
                                        0.015
                                }
                        }
                        translate <-0.3,0,-0.75>
                        texture
                        {
                                T_Chrome_4A
                        }
                 }


                object  // diving board
                {
                        box 
                        {
                                <-0.1,0,-0.3>,
                                <0.1,0.03,0.6>
                                translate <0,0.3,0.75>
                        }
                        texture
                        {
                                WarfTexture
                                rotate <0,90,0>
                        }
                }

                object   // tires
                {
                        union
                        {
                                intersection
                                {
                                        cylinder
                                        {
                                                <0.5,0,0>,
                                                <0.56,0,0>,
                                                0.1
                                        }
                                        cylinder
                                        {
                                                <0.4,0,0>,
                                                <0.7,0,0>,
                                                0.05
                                                inverse
                                        }
                                        translate <0,0.08,0.65>
                                }
                                intersection
                                {
                                        cylinder
                                        {
                                                <0.5,0,0>,
                                                <0.56,0,0>,
                                                0.1
                                        }
                                        cylinder
                                        {
                                                <0.4,0,0>,
                                                <0.7,0,0>,
                                                0.05
                                                inverse
                                        }
                                        translate <0,0.02,0.325>
                                }
                                intersection
                                {
                                        cylinder
                                        {
                                                <0.5,0,0>,
                                                <0.56,0,0>,
                                                0.1
                                        }
                                        cylinder
                                        {
                                                <0.4,0,0>,
                                                <0.7,0,0>,
                                                0.05
                                                inverse
                                        }
                                        translate <0,0.06,0>
                                }
                                intersection
                                {
                                        cylinder
                                        {
                                                <0.5,0,0>,
                                                <0.56,0,0>,
                                                0.1
                                        }
                                        cylinder
                                        {
                                                <0.4,0,0>,
                                                <0.7,0,0>,
                                                0.05
                                                inverse
                                        }
                                        translate <0,0.09,-0.325>
                                }
                                intersection
                                {
                                        cylinder
                                        {
                                                <0.5,0,0>,
                                                <0.56,0,0>,
                                                0.1
                                        }
                                        cylinder
                                        {
                                                <0.4,0,0>,
                                                <0.7,0,0>,
                                                0.05
                                                inverse
                                        }
                                        translate <0,0.05,-0.65>
                                }
                        }
                        texture
                        {
                                pigment
                                {
                                        color rgb <0.1,0.1,0.1>
                                }
                        }
                }
        }
        scale 0.013
        rotate <0,30,0>
        translate <-0.023,0.045,-0.33>
}






#declare Rail = object
{
        union
        {
                box
                {
                        <0,0.8,0.025>,
                        <-1,0.7,-0.025>
                }
                box
                {
                        <0,0.2,0.025>,
                        <-1,0.3,-0.025>
                }
        }
	texture
	{
	 	WoodTexture
		rotate <0,0,0>
	}

}


#declare PostAndCap = object
{
	union
	{
		object
		{
                        box  // post
			{
		       	        <-0.1,0,-0.1>,
                		<0.1,1,0.1>
		        }
			texture
			{
				WoodTexture
				rotate <0,0,90>
			}
		}
		object
		{
                        intersection  // cap on post
		        {
		        	box
        		        {
                			<0.15,1,0.15>,
                                        <-0.15,1.5,-0.15>
		                }
				plane
				{
					y,0
                                        rotate <0,0,-35>
                                        translate <0.03,1.15,0>
				}
				plane
				{
					y,0
                                        rotate <0,0,35>
                                        translate <-0.03,1.15,0>
				}
				plane
				{
					y,0
                                        rotate <-35,0,0>
                                        translate <0,1.15,-0.03>
				}
				plane
				{
					y,0
                                        rotate <35,0,0>
                                        translate <0,1.15,0.03>
				}
				plane
				{
					y,0
                                        translate <0,1.11,0>
				}
			}
 			texture
			{
				WoodTexture
				rotate <0,0,0>
			}
	       }
	}
}

#declare Railing = object
{
        union
        {
                object  // post #1, corner
                {
			PostAndCap
                }
                object  // post #2, left 1
                {
			PostAndCap
                        rotate <0,90,0>
                        translate <-1,0,0>
                }
                object  // post #2, left 2
                {
			PostAndCap
                        rotate <0,180,0>
                        translate <-2,0,0>
                }
                object  // post #3, closer
                {
			PostAndCap
                        rotate <0,270,0>
                        translate <0,0,-1>
                }
                object  // rail #1-2
                {
			Rail
                }
                object  //rail #2-4
                {
			Rail
                        rotate <180,0,0>
                        translate <0,1,0>
			translate <-1,0,0>
                }
                object  //rail #4-?
                {
			Rail
//                        rotate <180,0,0>
//                        translate <0,1,0>
			translate <-2,0,0>
                }
                object  // rail #1-3
                {
			Rail
			rotate <0,-90,0>
                }
                object  // rail #3-?
                {
			Rail
			rotate <0,-90,0>
			translate <0,0,-1>
                }
        }
}

object
{
        Railing
        scale 0.015
        rotate <0,-13,0>
//        translate <0.011,0.045,-0.395>
        translate <0.011,0.047,-0.395>
}



#declare Beacon = object
{
	union
	{

                object  // make a basic cone for top
		{
                        cone
                        {
                                <0, 0, 0>,0.007
                                <0,  1, 0>, 0.0035
                        }
                        scale <1,0.015,1>
                        texture
		        {
		                pigment
		                {
                                        gradient y
                                        scale 1
                                        color_map {
                                                    [0.0 color rgb <0.5, 0.5,0.0>]
                                                    [0.15 color rgb <0.6, 0.3,0.0>]
                                                    [0.15 color rgb<0.7,0.75,0.65> ]
                                                    [0.3 color rgb <0.65,0.65,0.65> ]
                                                    [0.85 color rgb<0.65,0.65,0.65> ]
                                                    [0.85 color rgb <0.6, 0.2,0.0>]
                                                    [1.0 color rgb <0.6, 0.2,0.0>]
                                        }
                                        scale <1,0.015,1>
		                }
		                finish
		                {
                                        ambient 0.2
                                        diffuse 0.6
                		}
                                normal
                                {
                                        dents 1.5
                                        scale 0.0005
                                }
		        }
                }

		object  // make ladder
		{
                        union
			{
				cylinder
				{
					<0.0015,0,0>
					<0.0015,0.015,0>,0.0003
				}
				cylinder
				{
					<-0.0015,0,0>
					<-0.0015,0.015,0>,0.0003
				}
				cylinder
				{
					<-0.0015,0.012,0>
					<0.0015,0.012,0>,0.0003
				}
				cylinder
				{
					<-0.0015,0.009,0>
					<0.0015,0.009,0>,0.0003
				}
				cylinder
				{
					<-0.0015,0.006,0>
					<0.0015,0.006,0>,0.0003
				}
				cylinder
				{
					<-0.0015,0.003,0>
					<0.0015,0.003,0>,0.0003
				}
			}
			texture
			{
		                pigment
		                {
                                        color Gray70
		                }
		                finish
		                {
                                        ambient 0.3
                                        diffuse 0.7
                		}
                                normal
                                {
                                        dents 1.5
                                        scale 0.00005
                                }
			}
			rotate <0,90,0>
			rotate <0,0,-15>
			translate <-0.0075,0>
                        rotate <0,-70,0>
		}

                
                object  // make a cement pedistal for a base
		{
                        box
                        {
                                <-0.009,0,-0.009>
                                <0.009,-0.01,0.009>
                        }
		        texture
		        {
		                pigment
		                {
                                        gradient y
                                        color_map {
                                                    [0.0 color rgb <0.6, 0.6,0.6>]
                                                    [1.0 color rgb <0.25, 0.5,0.1>*0.7]
                                        }
                                        turbulence 0.4
                                        scale 0.012
                                        translate <0,0.002,0>
                                }
                                /*
		                pigment
		                {
                                        color red 0.45 green 0.6 blue 0.45
		                }
                                */
		                finish
		                {
                                        ambient 0.4
                                        diffuse 0.2
                		}

                                normal
                                {
                                        bumps 2.0
                                        scale 0.0004
                                }

		        }
		}
                object  // supports for lights
		{
			union
			{
				cylinder // bottom bar
				{
                                        <-0.003,0.017,0>
                                        <0.003,0.017,0>,0.0004
				}
				cylinder // main center bar
				{
					<0,0.015,0>
                                        <0,0.02-0.0015,0>,0.0004
				}

				sphere
				{
                                        <-0.003,0.017,0>,0.0004
				}
				sphere
				{
                                        <0.003,0.017,0>,0.0004
				}
			}
			texture
			{
                                T_Chrome_4A
			}
			rotate <0,30,0>
		}
                object  // light
		{
			union
			{
				sphere
				{
                                        <0,0.02,0>,0.0008
//                                        <0,0.02,0>,0.08
				}
				cylinder
				{
					<0,0.02,0>
					<0,0.02-0.0015,0>,0.0008
				}
			}
		        texture
		        {
		                pigment
		                {
                                        color rgbf <1,0,0,0.9>
		                }
		                finish
		                {
                		        ambient 0.6
		  			diffuse 0.3
                		}
		        }
		}
                
                
                object  // the shine from the light
                {
                        sphere
                        {
                                <0,0,0>,1
                                hollow
                                no_shadow
                        }

                        texture
                        {
                                pigment {Clear}
                                halo
                                {
                                      linear
                                      max_value 1.0
                                      spherical_mapping
                                      emitting

                                      colour_map
                                      {
                                         [0.0 color rgbt <1.0,0.0,0.0,1.0> ]
                                         [0.8 color rgbt <3.0,0.0,0.0,0.3> ]
                                         [1.0 color rgbt <4.0,0.0,0.0,0.0> ]
                                      }
/*
                                      colour_map
                                      {
                                         [0.0 color rgbt <0.3,0.0,0.0,1.0> ]
					 [0.7 color rgbt <0.8,0.0,0.0,1.0> ]
                                         [0.85 color rgbt <0.8,0.0,0.0,0.5> ]
                                         [1.0 color rgbt <1.0,0.0,0.0,0.5> ]
                                      }
*/
                                      samples 10
                                }
                        }
                        scale 0.08
                        translate <0,0.02,0>
                }
                
                
        }
}





object
{
	Beacon
        scale 1.15
//        translate <-0.12, 0.055, 0.177>
        translate <-0.11, 0.052, 0.3>
        translate <-0.05,0,0>
}




// LAND HO!
object
{
        height_field { tga "land4.tga" water_level 0.55 }
        translate <-0.5,-0.55,-0.5>
        scale 0.3333
        rotate <0,90,0>
        rotate <0,25,0>

//        scale <1,0.045,1>  
//        translate <-0.25,0.045,0.02>  
        scale <2,0.2,2>
//        scale <2,0.4,2>
        translate <-0.46,0.045,0.7>

	texture
	{
/*        
                pigment
                {
                        color red 0.3 blue 0.3 green 0.3
                }
*/
        
                                pigment
                               {
                                        gradient y
                                        color_map {
                                                    [0.0 color rgb <0.3, 0.3, 0.3>]
                                                    [0.255 color rgb <0.3, 0.2, 0.3>]
                                                    [0.28 color rgb <0.7, 0.7, 0.7>]
                                                    [0.32 color rgb <0.3, 1,0>]
                                                    [1.0 color rgb<0,1,0> ]
                                        }

                                        turbulence <0,0.022,0>

                                        scale 0.2
//                                        scale <0.02,1,0.02>
                                        scale <0.02,1.05,0.02>
//                                        scale <0.2,0.4,0.2>
//                                        scale 0.004
		                }

                finish
                {
//                        ambient 0.2  // normal
                        ambient 0.15
//                        diffuse 0.6  // normal
                        diffuse 0.5
                        crand 0.2
                        reflection 0
                }
                normal
                {
//                        wrinkles 0.7
//                        scale 0.5
                        wrinkles 2.0
                        scale 0.0001
                }
	}
        translate <0.15, -0.055, -0.177>
        scale <3.5,5,4>
        translate <-0.15, 0.055, 0.177>
        translate <-0.05,0,0>
        translate <0.75,0,-2.1>
}


// TREE

object
{
       tree
       scale 0.000007  // normal
//	scale 0.02  // use when sphere is put in TREE.INC
       translate <0.032,0.025,-0.40>  // normal
}



// First Star
sphere
{
        <0,0.075,1001>,1.4
        texture
        {
                pigment
                {
                        color red 0.6 green 0.6 blue 0.6
                }
                finish
                {
                        ambient 0.43
                        diffuse 0.3
                }
        }
        rotate <0,-25,0>
        rotate <-11,0,0>
}

// Second Star
sphere
{
        <0,0.075,1001>,1.4
        texture
        {
                pigment
                {
                        color red 0.6 green 0.6 blue 0.6
                }
                finish
                {
                        ambient 0.5
                        diffuse 0.3
                }
        }
        rotate <0,-22,0>
        rotate <-24,0,0>
}

// Third Star
sphere
{
        <0,0.075,1001>,1.4
        texture
        {
                pigment
                {
                        color red 0.6 green 0.6 blue 0.6
                }
                finish
                {
                        ambient 0.45
                        diffuse 0.3
                }
        }
        rotate <0,6,0>
        rotate <-25,0,0>
}

// Fourth Star
sphere
{
        <0,0.075,1001>,1.4
        texture
        {
                pigment
                {
                        color red 0.6 green 0.6 blue 0.6
                }
                finish
                {
                        ambient 0.3
                        diffuse 0.3
                }
        }
        rotate <0,14,0>
        rotate <-15,0,0>
}

// Fifth Star
sphere
{
        <0,0.075,1001>,1.4
        texture
        {
                pigment
                {
                        color red 0.6 green 0.6 blue 0.6
                }
                finish
                {
                        ambient 0.45
                        diffuse 0.3
                }
        }
        rotate <0,24,0>
        rotate <-17,0,0>
}




// Dark cloudy sky
sky_sphere {
    pigment {
//      color Orange

        wrinkles
        turbulence 0.3
        omega 0.707
        octaves 5

        color_map {
            [0.0 color DustyRose * 2.5]
            [0.2 color Orange ]
            [0.8 color SlateBlue * 0.25]
            [1.0 color SkyBlue]
        }

        scale <0.5, 0.1, 1000>


    }
}


// The Sun's halo
#declare SunGlow =
texture {
   pigment { colour Clear }
   halo {
      cubic
//      linear
      max_value 1.0
      spherical_mapping
      emitting

      colour_map { 
         [0.00 color rgbf <0.0, 0.0, 0.0, 1.0> ]
         [0.30 color rgbf <0.15, 0.015, 0.0, 1.0> ]
         [0.35 color rgbf <1.0, 0.0, 0.0, 1.0> ]
         [1.00 color rgbf <1.0, 1.0, 0.0, 1.0> ]
      }

      samples 10
      scale 1.5
   }
}

#declare Sun =
object {
    sphere { 0,1.53
//    sphere { 0,1.4
        hollow
        no_shadow
//        scale 0.75
        scale 0.85
	texture { SunGlow }
        scale <3, 3, 3>
        translate <0, 0.05, 0>
    }

    scale <1, 0.8, 1>
    translate <2.5, -0.25, 15>
}


light_source { <3000, 1000, -2000>  rgb <1, .95, .85> * 0.5 }
light_source { <0, 0.1, 4> DustyRose shadowless }
light_source { <0, 0.075, 4> Orange shadowless }


default { finish { diffuse 1 ambient 0.1 } }


#declare Sea =
plane { y, 0.045
/*
    texture
    {
        pigment
        {
                color red 0.5 green 0.5 blue 1.0
        }
    }
*/

    texture {
        T_Silver_1C
        normal {
            average
            normal_map {
                [ ripples 0.15 frequency 3 scale 0.008 translate <0, 0, 10> ]
                [ wrinkles 0.25 scale 0.01  ]
            }
        }
    }

}


/*
#declare Sea =
sphere
{
//    <0,0,0>,60
//    translate <0,-59.95,0>
    <0,0,0>,80
    translate <0,-80.045,0>


    texture {
        T_Silver_1C
        normal {
            average
            normal_map {
                [ ripples 0.15 frequency 3 scale 0.008 translate <0, 0, 10> ]
                [ wrinkles 0.25 scale 0.01  ]
            }
        }
    }

    texture
    {
        pigment
        {
                color red 1.0 green 1.0 blue 1.0
        }
    }

}
*/

object { Sun }
object { Sea }


