/* cro.inc  -  a cathode ray oscilloscope with cable and probe; */
/*             needs "cro.gif";  used in "timeresp.pov"         */
/* Scene designed by:  Martin Gonda,   Copyright July 1996      */

#declare 
My_Plastic_Black = texture {
  pigment { color rgb <0.2,0.2,0.2> }
  finish { phong 0.8 ambient 0.2 diffuse 0.7 }
}

#declare My_Plastic_Gray = texture {
  pigment { color rgb <0.8,0.8,0.8> }
  finish { phong 0.2 ambient 0.5 diffuse 0.8 }
}

#declare My_Plastic_Beige = texture {
  pigment { color rgb <1.0,0.92,0.84> }
  finish { phong 0.3 ambient 0.5 diffuse 0.8 }
}

#declare My_Plastic_Blue = texture {
  pigment { color rgb <0.3,0.3,0.6> }
  finish { phong 0.2 ambient 0.2 diffuse 0.2 }
}


#declare cro_box_1 = merge {
  cylinder { <-11,-5,0>, <-11,-5,1>, 1 }
  cylinder { < 11,-5,0>, < 11,-5,1>, 1 }
  cylinder { <-11, 5,0>, <-11, 5,1>, 1 }
  cylinder { < 11, 5,0>, < 11, 5,1>, 1 }
  box { <-12,-5,0>, <12, 5,1> }
  box { <-11,-6,0.000001>, <11, 6,1.000001> }
}

#declare cro_box = union {
  object { cro_box_1 scale <1.00,1.00,20> 
    texture { My_Plastic_Blue normal { bumps 0.6 scale 0.4 } }
  }
  difference {
    object { cro_box_1 scale <1.00,1.00,0.3> translate <0,0,-0.3> 
      texture { My_Chrome finish { reflection 0.05 } }
    }
    object { cro_box_1 scale <0.99,0.98,0.3> translate <0,0,-0.31> 
      texture { My_Chrome finish { reflection 0.05 }}
    }
  }
}

#declare cro_handle_1 = union {
  difference { 
    cone { <-14,0,0>, 2.3, <-12.1,0,0>, 2.5 }
    cone { <-14.01,0,0>, 2.1, <-13.8,0,0>, 2 }
  }
  difference {
    box { <-13,0,-1.5>, <-12.1,8,1.5> }
    box { <-13.01,-0.01,-1.3>, <-12.5,8.01,1.3> }
  }
  intersection {
    difference {
      union {
        cylinder { <-11,8,-1.3>, <-11,8, 1.3>, 1.5 }
        cylinder { <-11,8,-1.5>, <-11,8,-1.3>, 2 }
        cylinder { <-11,8, 1.3>, <-11,8, 1.5>, 2 }
      }
      cylinder { <-11,8,-1.51>, <-11,8,1.51>, 1.1 }
    }
    box { <-13.01,8,-1.52>, <-11,10.01,1.52> }
  }
}

#declare cro_handle = union {
  object { cro_handle_1 }
  object { cro_handle_1 rotate <0,180,0> }
  difference {
    box { <-11,9.1,-1.5>, <11,10,1.5> }
    box { <-11.01,9.5,-1.3>, <11.01,10.01,1.3> }
  }
  texture { My_Plastic_Beige }
}

#declare cro_screen = difference {
  box { <-5.0,-4.0,-0.6>, <5.0,4.0,0.01>  
    texture { My_Plastic_Gray }
  }
  box { <-4.5,-3.5,-0.61>, <4.5,3.5,-0.2> 
    texture { 
      pigment { image_map { gif "cro.gif" interpolate 4 } }
      scale <9,7,1> translate<-4.5,-3.5,0>
    } 
  }
}

#declare cro_knob_1 = difference {
  cone { <0,0,-1.5>, 0.45, <0,0, 0.0>, 0.55 
    texture { My_Plastic_Beige }
  }
  cone { <0,0,-1.51>, 0.35, <0,0,-1.4>, 0.3 
    pigment { color Red }
  }
}

#declare cro_knob_2 = union {
  difference {
    union {
      cone { <0,0,-0.9>, 0.9, <0,0, 0.0>, 1.0 }
      intersection {
        cone { <0,0,-0.9>, 1.2, <0,0, 0.0>, 1.3 }
        box { <-0.1,0,-0.91>, <0.1,1.5,0.01> }
      }
      texture { My_Plastic_Beige }
    }
    cone { <0,0,-0.91>, 0.8, <0,0,-0.8>, 0.75 
      pigment { color Blue }
    }
  }
  object { cro_knob_1 translate <0,0,-0.3> }
}

#declare cro_button = 
  box { <-0.5,-0.4,-0.4>, <0.5,0.4,0> 
    texture { My_Plastic_Beige }
  }

#declare cro_switch_1 = union {
  box { <0.35,-0.50,-1.00>, <0.75,0.50,-0.50> 
    texture { My_Plastic_Beige }
  }
  box { <0.40,-0.05,-0.50>, <0.70,0.05, 0.00> 
    texture { My_Plastic_Black }
  }
  difference {
    box { <-1.40,-0.3,-0.2>, <1.40,0.3,0.00> 
       texture { My_Plastic_Gray }
    }
    box { <-1.37,-0.1,-0.21>, <1.37,0.1,-0.01> 
      pigment { color Black }
    }
  }
}

#declare cro_socket = union {
  difference {
    union {
      cylinder { <0,0,-1.2>, <0,0,0>, 0.5 }
      cylinder { <-0.6,0,-0.7>, <0.6,0,-0.7>, 0.05}
    }
    cylinder { <0,0,-1.21>, <0,0,0.01>, 0.45 }
  }
  cylinder { <0,0,-1.2>, <0,0,0>, 0.05 }
  texture { My_Chrome }
}

#declare cro_plug = union {
  cylinder { <0,0,-0.7>, <0,0,0>, 0.65 }
  cylinder { <0,0,-0.2>, <0,0,0>, 0.55 }
  cylinder { <0,0,-0.8>, <0,0,-0.4>, 0.7 }
  cylinder { <0,0,-1.2>, <0,0,-0.8>, 0.28 }
  texture { My_Chrome }
}

#declare cro_cable = union {
  intersection {
    torus { 2,0.25 rotate <0,0,90> }
    box { <-0.3,0,-2.3>, <0.3,2.3,0> }
    translate <0,-2,0>
  }
  intersection {
    torus { 2,0.25 rotate <90,0,0> }
    box { <-2.3,-2.3,-0.3>, <0,0,0.3> }
    translate <2,-2,-2>
  }
  intersection {
    torus { 5,0.25 }
    box { <0,-0.3,-5.3>, <5.3,0.3,5.3> }
    translate <2,-4,-7>
  }
  union {
    cone { <-2.8284,0,2.8284>, 0.25, <-2*2.8284,0,0>, 0.35 }
    cone { <-2*2.8284,0,0>, 0.35, <-2.25*2.8284,0,-0.5*1.4142>, 0.15 }
    cone { <-2.25*2.8284,0,-0.5*1.4142>, 0.1, <-2.5*2.8284,0,-1.4142>, 0.07 
      texture { My_Chrome }
    }
    intersection {
      torus { 4,0.25 }
      plane { <1,0,0>, 0 }
      plane { <-1,0,-1>, 0 }
    }
    translate <2,-4,-16>
  }
  texture { My_Plastic_Black }
}

#declare CRO = union {
  union {
    object { cro_box }
    object { cro_handle rotate <-140,0,0> translate <0,0.2,5.5> }
    object { cro_screen translate <-6,1,0> }
    object { cro_knob_1 translate < 1,2.0,0> }
    object { cro_knob_1 translate < 5,2.0,0> }
    object { cro_knob_1 translate < 9,1.0,0> }
    object { cro_knob_1 translate < 1,4.5,0> }
    object { cro_knob_1 translate < 3,4.5,0> }
    object { cro_knob_1 translate < 5,4.5,0> }
    object { cro_knob_2 translate < 1,-0.5,0> }
    object { cro_knob_2 translate < 5,-0.5,0> }
    object { cro_knob_2 translate < 9,-1.5,0> }
    object { cro_switch_1 rotate <0,0,90>  translate <3,1.5,0> }
    object { cro_switch_1 translate <1.25,-3,0> }
    object { cro_switch_1 translate <4.75,-3,0> }
    object { cro_switch_1 translate <9.0,4.5,0> }
    object { cro_switch_1 rotate <0,0,180> translate <9, 3.0,0> }
    object { cro_socket translate <1,-4.5,0> }
    object { cro_socket translate <5,-4.5,0> }
    object { cro_socket translate <9,-4.5,0> }
    object { cro_button translate <-2,-4.5,0> }
    object { cro_button translate <-10,-4.5,0> }
    object { cro_button translate <-8.6,-4.5,0> }
    object { cro_button translate <-7.2,-4.5,0> }
    object { cro_button translate <-5.8,-4.5,0> }
    object { cro_button translate <-4.4,-4.5,0> }
    object { cro_plug translate <5,-4.5,-0.7> }
    rotate <5,0,0>  
  }
  object { cro_cable translate <5,-4.3,-1.55> }
}

