// Persistence of Vision Ray Tracer Scene Description File
// File: candle.inc
// Vers: 3
// Desc:This is a time candle.  It needs file, 'canmarks.tga' to map the candle markings
// Date:June 1996
// Auth:Stephen C. Baker


/*	This is the candle holder.  It is made with simple CSG using cones and a torus */

#declare CandleDish = union {
     torus {0.5, 0.1}					// outter lip of dish
     cone { <0, -0.1, 0>, 0.5, <0, 0, 0>, 0
            translate <0.0, 0.15, 0.0>			// shallow cone for plate
     }
     cone { <0, -0.1, 0>, 0.2, <0, 0, 0>, .17		// small cone to hold candle
     translate <0.0, 0.21, 0.0>
     }
}

/* 	This is the 'helo' around the candle flame.	*/

#declare FlameHelo = object {
	sphere { <0,0,0>, 0.8
		pigment { color rgbt <1, 1, 1, 1> }
		halo {
			emitting
			spherical_mapping
			linear
			color_map {
				[ 0 color rgbt <1, 0, 0, 1> ]
				[ 1 color rgbt <1, 1, 0, 0> ]
		      }
		      samples 10
		}
		hollow
	}
}


/*	The candle flame is an elongated sphere, placed inside the helo. 
	By placing the ambient value to 1 and using a bright yellow the 
	elongated sphere passas off as a small flame */

#declare Flame = object {
	sphere { <0,0,0>,.04}
	scale <1,3,1>
	texture {
		pigment { Yellow }
		finish {
			ambient 1.0
		}
	}
}



/*	This is the lighted candle inside the candle dish.  It is made of
	the union of the CandleDish, image map 'canmarks.tga', the Flame
	Helo and the Flame itself.  Note, the candle stick is part of the
	Candle Dish */

#declare LightedCandel = union {
	object {CandleDish
	        texture {Polished_Brass}
	}
	cone { < 0,0,0>,0.08,<0,1.5,0>,0.06 open
		pigment {image_map { tga "canmarks.tga" map_type 2 }
			rotate <0,-55,0>
		}
	}
	object { FlameHelo
		translate <0, 1.6, 0>
	}
	object { Flame
		translate <0, 1.7, 0 >
	}
}


/* ------------------------------------------------------------------------------ */
/*	These are spotlights that are placed at the candle's flame.  They cast an orange
	glow to nearby objects.  This simulates the 'local' lighting by the candle flame */

/*****  This feature is not implemented, yet ****/



/*

#declare CandleColor = rgb < 1, .59, 0>

light_source
{
  <0,2,-1>                // light's position (translated below)
  color CandleColor       // light's color
  spotlight               // this kind of light source
  point_at <0, -1, -1>    // direction of spotlight
  radius 30               // hotspot (inner, in degrees)
  tightness 1             // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 180             // intensity falloff radius (outer, in degrees)
  shadowless
}

light_source
{
  <0,2,-1>                    // light's position (translated below)
  color CandleColor       // light's color
  spotlight               // this kind of light source
  point_at <-4, 1, 3>      // direction of spotlight
  radius 5               // hotspot (inner, in degrees)
  tightness 1            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 13
 shadowless
               // intensity falloff radius (outer, in degrees)
}

light_source
{
  <0,2,-1>                    // light's position (translated below)
  color CandleColor       // light's color
  spotlight               // this kind of light source
  point_at <4, 1, 3>      // direction of spotlight
  radius 5               // hotspot (inner, in degrees)
  tightness 1            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 13
 shadowless
               // intensity falloff radius (outer, in degrees)
}

*/
/*
#declare CandleLight = texture
{
  pigment
  {
    colour rgbf<1.00,0.85,0.00,0.15>
  }
  finish {
    ambient 1.00
    diffuse 1.00
//    phong 1.00
  }
}

*/
