// Persistence of Vision Ray Tracer Scene Description File
// File: dwatch.inc
// Vers: 3
// Desc:The digital watch and/or clock.  HRGLASS.INC MUST PRECEED THIS FILE.  It
//	contains the 'Thin_Glass' texture
// Date:June 1996
// Auth:Stephen C. Baker

/*   The LED display was made by first creating an LED segment then creating the
     number '8'.  Since all numbers can be made from '8', the numbers 0 to 7 and
     9 are simply '8' with missing segments. Thus zero is.....
 _                                         _
| |                                       | |
 -    turn off middel segment to get =>       
| |                                       | |
 -                                         -
*/

/* Bright Red with ambient set to 1.0 simulates the color of an ON LED segment */
    
#declare DigitalRed = texture {
     pigment { colour rgb<1.00,0.00,0.00> }
     finish { ambient 1.00 }
}


/*   The LED segment is a simple 6 sided polygon aranged.....
      _______________
     <_______________> (sorry, these are hard to do in ASCII )
*/
      
#declare DigitalSegment = polygon { 7,
<-3.25,0,0>, <-2.5,0.75,0>, <2.5,0.75,0>,<3.25,0,0>,
<2.5,-0.75,0>,<-2.5,-0.75,0>,<-3.25,0,0>
}

/*	Digital '8'.  The only number to has ALL LED sigments lit.  All
	numbers are simply '8' with missing segments */

#declare DigitalEight = union {
     object { DigitalSegment }     //middle
     object { DigitalSegment       //top
          translate <0, 6.67, 0>
     }
     object { DigitalSegment       //bottom
          translate <0, -6.67, 0>
     }
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment       //upper left
          rotate < 0, 0, 90 >
          translate < -3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
     object { DigitalSegment       //lower left
          rotate < 0, 0, 90 >
          translate < -3.53,-3.35,0>
     }
}

#declare DigitalOne = union {
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
}

#declare DigitalTwo = union {
     object { DigitalSegment       //top
          translate <0, 6.67, 0>
     }
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment }     //middle
     object { DigitalSegment       //lower left
          rotate < 0, 0, 90 >
          translate < -3.53,-3.35,0>
     }
     object { DigitalSegment       //bottom
          translate <0, -6.67, 0>
     }
}

#declare DigitalThree = union {
     object { DigitalSegment }     //middle
     object { DigitalSegment       //top
          translate <0, 6.67, 0>
     }
     object { DigitalSegment       //bottom
          translate <0, -6.67, 0>
     }
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
}

#declare DigitalFour = union {
     object { DigitalSegment }     //middle
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment       //upper left
          rotate < 0, 0, 90 >
          translate < -3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
}

#declare DigitalFive = union {
     object { DigitalSegment }     //middle
     object { DigitalSegment       //top
          translate <0, 6.67, 0>
     }
     object { DigitalSegment       //bottom
          translate <0, -6.67, 0>
     }
     object { DigitalSegment       //upper left
          rotate < 0, 0, 90 >
          translate < -3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
}

#declare DigitalSix = union {
     object { DigitalSegment }     //middle
     object { DigitalSegment       //bottom
          translate <0, -6.67, 0>
     }
     object { DigitalSegment       //upper left
          rotate < 0, 0, 90 >
          translate < -3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
     object { DigitalSegment       //lower left
          rotate < 0, 0, 90 >
          translate < -3.53,-3.35,0>
     }
}

#declare DigitalSeven = union {
     object { DigitalSegment       //top
          translate <0, 6.67, 0>
     }
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
}

#declare DigitalNine = union {
     object { DigitalSegment }     //middle
     object { DigitalSegment       //top
          translate <0, 6.67, 0>
     }
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment       //upper left
          rotate < 0, 0, 90 >
          translate < -3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
}

#declare DigitalZero = union {
     object { DigitalSegment       //top
          translate <0, 6.67, 0>
     }
     object { DigitalSegment       //bottom
          translate <0, -6.67, 0>
     }
     object { DigitalSegment       //upper right
          rotate < 0, 0, 90 >
          translate < 3.53,3.35,0>
     }
     object { DigitalSegment       //upper left
          rotate < 0, 0, 90 >
          translate < -3.53,3.35,0>
     }
     object { DigitalSegment       //lower right
          rotate < 0, 0, 90 >
          translate < 3.53,-3.35,0>
     }
     object { DigitalSegment       //lower left
          rotate < 0, 0, 90 >
          translate < -3.53,-3.35,0>
     }
}

#declare Colon = union {	// The Colon for the time display
     disc {
          <0, 1, 0>  // center position
          z,         // normal vector
          0.75,       // outer radius
          translate <6,2,0>
     }

     disc {
          <0, 1, 0>  // center position
          z,         // normal vector
          0.75,       // outer radius
          translate <6,-4,0>
     }
}


/*	This is the time that gets places upon the clock/watch face.  It is declared
	here because it is a member of the union 'CompleteWatch' and thus must proceed it.
	The time set here is 10:45 38  with 38 scaled by 0.8 */

#declare DigitalClockFace = union {
     object { DigitalOne
          texture { DigitalRed }
          translate < -10,0,0>
     }
     object { DigitalZero
          texture { DigitalRed }
     }
     object { Colon
          texture { DigitalRed }
     }
     object { DigitalFour
          texture { DigitalRed }
          translate < 12,0,0>
     }
     object { DigitalFive
          texture { DigitalRed }
          translate < 22,0,0>
     }
     object { DigitalThree
          scale 0.8
          texture { DigitalRed }
          translate < 33,-1.4,0>
     }
     object { DigitalEight
          scale 0.8
          texture { DigitalRed }
          translate < 42,-1.4,0>
     }
}


/*	The basic shape for the watch/clock.  It is a box with rounded corners.  The 
	corners are rounded only on the sides; the front and back are flat.  I start
	here by subtracting round pieces from the sides of a box..... */

#declare BasicShape = difference {
     box { <-1, -1, -1>, <1, 1, 1>}
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.1, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <1.0, 1.0, 0.0>
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.1, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <-1.0, 1.0, 0.0>
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.1, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <-1.0, -1.0, 0.0>
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.1, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <1.0, -1.0, 0.0>
     }
}

/*	(continue)....then adding cylinders to the sides.  The cylinders in 'BasicShape'
	cut off the box corners.  While the cylinders here substitute a rounder corner. */

#declare WatchBody =
union {
     object { BasicShape }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.0, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <0.5, 0.5, 0.0>
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.0, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <0.5, -0.5, 0.0>
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.0, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <-0.5, -0.5, 0.0>
     }
     cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.5
          scale <1.0, 2.0, 1.0>
          rotate <90.0, 0.0, 0.0>
          translate <-0.5, 0.5, 0.0>
     }
     scale <1,1,0.15>
}

/* The frame around the watch is simply a watch body with a smaller watch body subtracted */

#declare BodyFrame = difference {
     object { WatchBody
          scale < 1, 1, 0.05 >
     }

     object { WatchBody
          scale < 0.9 0.9, 0.1 >
     }
}

/*	The completed watch body is simply the WatchBody with two BodyFrames and a
	super ellipsiod.  The first BodyFrame frames the clock, while the second
	BodyFrame (T_Silver_4A), frames the crystal.  The clock crystal is simply
	a super ellipsiod with a 'glass' texture  (see note above) */

#declare DigitalWatchBody = union {
     object { WatchBody			//the watch body proper
          texture {
               pigment { Black }
               finish { Metal }
          }
     }
     object { BodyFrame            // frame for crystal
          scale 0.98
          translate <0, 0, -0.16>
          texture { T_Silver_4A }
     }
     object { BodyFrame            // frame around body
          scale <1.05, 1.05, 6.0>
          texture {
               pigment { Black }
               finish { Metal }
          }
     }
     superellipsoid { <0.5, 0.5>   // watch crystal
          scale <.9, .9, 0.3 >
          texture { Thin_Glass }
     }
}


/*	The completed digital watch/clock is now simply a union of the
	DigitalClockFace and the DigitalWatchbody */

#declare CompleteWatch = union {
    object { DigitalClockFace
          scale <0.025, 0.035, 0.025>
          translate <-0.4,0,-0.21>
     }
     object { DigitalWatchBody }
}

