// Sundial.inc
// July, 1996
// Stephen C. Baker
// This include files contains all the essintial elements to create a
// sundial face to be rendered by Povray 3.0 Beta

#include "tms73.inc"          //Times Roman character I
#include "tms86.inc"          //Times Roman character V
#include "tms88.inc"          //Times Roman character X

#declare LetterScale = <0.6, 1.0, 0.6>  //scale factor for all characters

// here are all the Roman Numerels used on the Sundial Face

#declare RomanII = union {         //   Roman II
     object { ALPHA_73
          translate <.15, 0, 0>
          scale LetterScale
     }
     object { ALPHA_73
          translate <-.15, 0, 0>
          scale LetterScale
     }
}
#declare RomanIII = union {        //   Roman III
     object { ALPHA_73
          scale LetterScale
     }
     object { ALPHA_73
          translate <.3, 0, 0>
          scale LetterScale
     }
     object { ALPHA_73
          translate <-.3, 0, 0>
          scale LetterScale
     }
}
#declare RomanIV = union {         //   Roman IV
     object { ALPHA_73
          scale LetterScale
          translate <-.1, 0, 0>
     }
     object { ALPHA_86
          scale LetterScale
          translate < .1, 0, 0 >
     }
}
#declare RomanV = object {         //   Roamn V
     object { ALPHA_86
          scale LetterScale
     }
}
#declare RomanVI = union {         //   Roamn VI
     object { ALPHA_73
          scale LetterScale
          translate <.22, 0, 0>
     }
     object { ALPHA_86
          scale LetterScale
          translate < -.22, 0, 0 >
     }
}
#declare RomanVII = union {        //   Roman VII
     object { RomanVI }
     object { ALPHA_73
          scale LetterScale
          translate <0.45, 0, 0>
     }
}
#declare RomanVIII = union {       //   Roman VIII
     object { RomanVII }
     object { ALPHA_73
          scale LetterScale
          translate <0.7, 0, 0>
     }
}
#declare RomanIX = union {         //   Roman IX
     object { ALPHA_88
          scale LetterScale
      }
     object { ALPHA_73
          scale LetterScale
          translate <-0.25, 0, 0>
      }
}
#declare RomanX = object {         //   Roman X
     object { ALPHA_88
          scale LetterScale
     }
}
#declare RomanXI = object {        //   Roman XI
     object { RomanIX
          rotate <0, 0, 180 >
     }
}
#declare RomanXII = union {        //   Roman XII
     object { RomanIX
          rotate <0, 0, 180 >
     }
     object { ALPHA_73
          scale LetterScale
          translate < 0.3, -0.67, 0 >
     }
}


// these are all the elemants for the Sundial Face 

#declare SunDial_Face = union {
     disc { <0, 0, 0>, <0, 1, 0>, 3.0, 1.0 }                // main disc

     cylinder {<0, -0.05, 0>, <0, 0.05, 0>, 3.0 open }      // raised outter lip
     cylinder {<0, -0.05, 0>, <0, 0.05, 0>, 3.1 open }
     disc { <0, 0, 0>, <0, 1, 0>, 3.1, 3.0
           translate <0.0, 0.05, 0.0>
     }

     cylinder {<0, -0.05, 0>, <0, 0.05, 0>, 1.0 open }      // raised inner lip
     cylinder {<0, -0.05, 0>, <0, 0.05, 0>, 0.9 open }
     disc { <0, 0, 0>, <0, 1, 0>, 1.0, 0.9
          translate <0.0, 0.05, 0.0>
     }
     disc { <0, 0, 0>, <0, 1, 0>, 0.9, 0.05 }               // inner disc

     cone { <0, 0, 0>, 0.1, <0, 1.5, 1>, 0 }                // sundial pointer
	triangle { <0,0,0>,<0,1.5,1>,<0,0,2> }

//   These are the rays on the sun dial, every 30 degrees

     box { <-1, -1, -1>, <1, 1, 1>
               scale <0.025, 0.025, 0.5>
               translate <0.0, 0.025, 1.5> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 30.0, 0.0>
          translate <0.74977, 0.025, 1.299016> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 60.0, 0.0>
          translate <1.298597, 0.025, 0.750074> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 90.0, 0.0>
          translate <1.499425, 0.025, 0.000262> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 120.0, 0.0>
          translate <1.298441, 0.025, -0.749507> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 150.0, 0.0>
          translate <0.749499, 0.025, -1.298335> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 180.0, 0.0>
          translate <-0.000313, 0.025, -1.499162> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 210.0, 0.0>
          translate <-0.750082, 0.025, -1.298179> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 240.0, 0.0>
          translate <-1.29891, 0.025, -0.749237> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 270.0, 0.0>
          translate <-1.499738, 0.025, 0.000575> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 300.0, 0.0>
          translate <-1.298754, 0.025, 0.750345> }
     box { <-1, -1, -1>, <1, 1, 1>
          scale <0.025, 0.025, 0.5>
          rotate <0.0, 330.0, 0.0>
          translate <-0.749812, 0.025, 1.299172> }

//        these are the Roman Numerals on the sundial face

     object {
          ALPHA_73
          scale LetterScale
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.2>
          rotate < 0, 27, 0>
     }
     object { RomanII
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.2>
          rotate < 0, 56, 0>
     }
     object { RomanIII
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.2>
          rotate < 0, 86, 0>
     }
     object { RomanIV
          rotate <0, 0, 180 >
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.85>
          rotate < 0, 128, 0>
     }
     object { RomanV
          rotate <0, 0, 180 >
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.85>
          rotate < 0, 157, 0>
     }
     object { RomanVI
          rotate <0, 0, 180 >
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.85>
          rotate < 0, 183, 0>
     }
     object { RomanVII
          rotate <0, 0, 187 >
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.85>
          rotate < 0, -142.0, 0>
     }
     object { RomanVIII
          rotate <0, 0, 190 >
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.85>
          rotate < 0, -110.0, 0>
     }
     object { RomanIX
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.2>
          rotate < 0, -90.0, 0>
     }
     object { RomanX
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.2>
          rotate < 0, -65.0, 0>
     }

     object { RomanXI
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.85>
          rotate < 0, -30.0, 0>
     }
     object { RomanXII
          rotate <90, 0, 0 >
          translate <0, 0.025, 2.85>
     }
}


// The sundial texture, made to look like old weathered copper,
//   green with white streaks.  This was created with Texture Magic


#declare Old_Copper =
texture {
	pigment {
		gradient x
		turbulence 0.65  octaves 8
		color_map
		{
			[0.00 color rgb<0.46, 0.55, 0.50>]
			[0.20 color rgb<0.46, 0.55, 0.50>]
			[0.40 color rgb<0.16, 0.35, 0.24>]
			[0.50 color rgb<1.00, 1.00, 1.00>]
			[0.60 color rgb<0.16, 0.35, 0.24>]
			[0.80 color rgb<0.46, 0.55, 0.50>]
			[1.00 color rgb<0.46, 0.55, 0.50>]
		}
		scale <19.00,20.00,1.00>
		rotate <0.00,90.00,0.00>
	}
	normal {
		wrinkles 0.20
	}
	finish {
		specular 0.12
		roughness 0.43    metallic
		phong 0.80
		phong_size 10  metallic
	}
}

