//**********
// ***** Referenced Objects


// Watch Piece References

#declare Watch = sphere{ 0,1 scale <2.7, 0.8, 2.7> }

#declare Common = sphere{ 0, 12 hollow}

#declare GDome = object{ Common
   clipped_by{ plane { y, 11.8 inverse } }
   translate -11.75*y
 }

#declare Cover = union{
   sphere{ 0, 1 clipped_by{ plane{ y, 0 inverse} } texture{ MyGold } }
   torus{ 0.96, 0.02 clipped_by{ plane{ y, 0 } } texture{ MyGold } no_shadow }

   scale <2.55, 0.2, 2.55>
 }

#declare Face = difference{
   cylinder{ 0, z*0.2, 2.2 }
   cylinder{ -z, z*0.04, 0.65 translate -y*1.4 }
   cylinder{ -z, z*0.02, 1.55 }
   pigment{
     image_map{ tga "face.tga"
       once
       interpolate 2
     }
     scale <5.87, 4.4, 1.0>
     translate <-2.935, -2.2, 0.0>
   }
   finish {
     diffuse 0.200
     ambient 0.600
   }
   rotate x*90
   translate 0.014*y
 }

#declare Bevel = union{
   difference{
     object{ Common
       clipped_by{ plane{ y, 11.8 } }
       clipped_by{ plane{ y, 11.75 inverse } }
       translate -11.75*y
     }
     box{ -z*0.2, <0.5, 0.5, 0.2> translate x*2.3 }
   }
   cylinder{ 0, y*0.05, 2.47 open translate -y*0.05 }

   // Catch
   box{ -z*0.15, <0.2, 0.1, 0.15>
     clipped_by{ plane{ y, 0.1 rotate -z*16 translate x*0.03 } }
     translate x*2.28
   }

   texture{ MyGold }
 }



#declare Body = difference{
   object{ Watch }
   plane{  y,  0.2 inverse }
   plane{  y, -0.2 }
//   cylinder{ y, -y, 2.45 }

   texture{ MyGold }
   translate -y*0.25
 }


// Watch Movement References

#declare Hand = merge{
   cylinder{ <0.0, 0.0, 0.5>, z*6.5, 0.05 }
   cone{ 0, 0.05, z*2.5, 0 translate z*6.5 }
   disc{ 0, y, 0.5 scale <0.5, 1.0, 1.1> translate z*5.5 }
   pigment{ color Black }
 }


// Winder References

#declare Base = union{
   cone{ 0, 0, x*0.6, 0.4 }
   difference{
     sphere{ 0, 0.4 }
     plane{ x, 0 }

     translate x*0.6
   }
}

#declare StemPiece = difference{
   object{ Base }
   plane{ z, -0.03 }
   plane{ z, 0.03 inverse }

   translate x*0.2
 }

#declare Connector = difference{
   sphere{ 0, 1 }
   cylinder{ -z, z, 0.5 }

   scale 0.15
 }

#declare Ring = torus{ 1, 0.08
    scale <0.6, 1.0, 0.9>
    translate x*0.5
    rotate -z*19
  }

#declare Winder = union{

   #declare Count=0
   #while (Count < 12)
     object{ StemPiece rotate x*15*Count}
     #declare Count=Count+1
   #end

   union{
     difference{
       sphere{ 0, 1 }
       sphere{ 0, 1 translate x*0.7 }

       scale <0.3, 0.3, 0.4>
     }

     object{ Connector translate -z*0.42 }
     object{ Connector translate  z*0.42 }

      // Winder Neck
     cylinder{ 0, <0.5, 0.0, 0.0>, 0.27 translate -x*0.5}

     object{ Ring }

     translate 0.55*x
   }

   texture{ MyGold }
 }


// Chain Link References

#declare Link = torus{ 0.8, 0.15 scale <0.5, 0.4, 0.4> }

#declare CurvedChain = union{
   #declare Count=0
   #while (Count < 40)
     object{ Link
       texture{ T_Gold_5C }
       rotate x*Count*36
       translate z*2.8
       rotate y*Count*5
     }
     #declare Count=Count+1
   #end
}

#declare StraightChain = union{
   #declare Count=0
   #while (Count < 40)
     object{ Link
       texture{ T_Gold_5C }
       rotate x*Count*36
       translate x*Count*0.25

     }
     #declare Count=Count+1
   #end
}

#declare ChainLatch = union{
   sphere{ 0, 0.8 }
   cone{ 0, 0.5, z, 0.8 translate z*0.75 }
   torus{ 0.8, 0.2 rotate x*90 translate z*1.75 }
   cylinder{ 0, z*5.01, 0.3 rotate -y*15 }
   cylinder{ 0, z*5.01, 0.3 rotate  y*15 }
   difference{
     torus{ 1.34, 0.3 translate z*5.18 }
     plane{ z, 4.82 }
   }

   texture{ T_Gold_5C }
 }

 // Chain connector
#declare ButtonClip = union{
   difference{
     torus{ 1, 0.3 hollow }
     box{ <-0.3, -0.3, -0.3>, <-1.3, 0.3, -1.3> }
   }
   torus{ 1, 0.1 }
   sphere{ 0, 1 scale 0.25 translate <3.3, -0.45, -1.0> }
   cylinder{ 0, -z*0.4, 0.1 translate -z rotate y*80 }

   texture{ T_Gold_5C }
 }
