// Object definition file
// For "A Fine Day"
// Entry in the August 1996 POV Internet Ray Tracing Competition
// By the Butter-Fingered Juggler

// -------------------------------------------------------------
// colours
// -------------------------------------------------------------


#declare Clouds1 = texture {
   pigment {
   leopard
   turbulence 0.7
   color_map
   { [0.1 color Clear]
     [0.2 color Gray60]
     [0.3 color Gray50] }
   }
   scale 250
}

#declare Ocean = texture {
   pigment
   {marble
   color_map
    {[0, 0.4 color White filter 0.1 color Gray05 filter 0.3]
     [0.4, 1.01 color Aquamarine filter 0.4 color SeaGreen filter 0.7]}
   }
   rotate <0, 0, 90>
   scale 1.2
   finish
    {reflection 0.3
      refraction 0.5
      ior 1.33
     }
}

#declare Shell_Pink = texture {
  pigment
  {gradient x
  color_map
    {[0.0, 0.25 color White color Grey]
     [0.25, 0.6 color Khaki color Tan]
     [0.6, 1.01 color Pink color Coral]
    }
  }
  finish {Shiny}
}

#declare Sand = texture {
 pigment 
  {bozo
   turbulence 1
   color_map
    {[0.0, 0.75  color red 0.93 green 0.86 blue 0.39
                 color red 0.91 green 0.81 blue 0.35]
     [0.75, 1.01 color red 0.86 green 0.696 blue 0.16
                color red 0.849 green 0.78 blue 0.325]
    }
  }
  normal {wrinkles 0.5 scale 2}
  finish {crand 0.2 ambient 0.3}

}

#declare Faded_Wood = texture {
  pigment
    {wood
    turbulence 0.06
    color_map
      {[0.0, 0.75  color red 0.83 green 0.71 blue 0.632
                   color red 0.84 green 0.84 blue 0.8]
       [0.75, 1.01 color red 0.8 green 0.733 blue 0.6
                   color red 0.9 green 0.8 blue 0.533]
      }
    }
  finish {Dull}
}    

#declare Red_Stripe = texture {
   pigment
      {gradient x
         color_map
            {[0.0, 0.5  color Red
                        color Red]
             [0.5, 1.001  color White
                          color White]
            }
      }
   finish {Shiny}    //plastic seating
}

#declare Blue_Stripe = texture {
   pigment
      {gradient z
         color_map
            {[0.0, 0.5  color Blue
                        color Blue]
             [0.5, 1.001  color White
                          color White]
            }
      }
   finish {Shiny}    //plastic seating
}

// ------------------------------------------------------------
// Objects
// ------------------------------------------------------------


// ------------------------------------------------------------
// Raindrops
#declare Raindrop = object {
   Piriform
   sturm
   rotate <0, 0, -90>
   scale <2, 5, 2>
// curious, you cant rotate by -120 as it deforms shape
   rotate <0, 0, -28.6> // not quite 30 to get rid of lines in sky
   texture {Glass}
}

// ------------------------------------------------------------
// Spade
#declare Spade = union {
   union {
      torus {1, 0.25 translate <6, 0, 0>}
      cylinder { <6, 0, -1>, <6, 0, 1>, 0.25 }
      clipped_by {  plane { x, 6}}
      bounded_by {sphere {<6, 0, 0>, 1.5}}
   }
   box { <1, 0, -0.25>, <5, 0.25, 0.25>}
   intersection {
      difference {
         cone { <0, -0.25, 0>, 1
                <0, 0.25, 0>, 1.25}
         cone { <0, -0.1, 0>, 0.75
                <0, 0.252, 0>, 1}
      }
      plane { x, 0 inverse}
      bounded_by { sphere { <0, 0, 0>, 1.5}}
      scale <1.5, 1, 1>
      translate <-0.5, 0, 0>
   }
}

// ------------------------------------------------------------
// Bucket
#declare Buck_Star = union {
sphere { <0, 0, 0>, 0.2 }
cone { <0, 0, 0 > , 0.2
       <0, 1.2, 0>, 0 }
cone { <0, 0, 0 > , 0.2
       <0, 1.2, 0>, 0
       rotate <0, 0, 72>
       rotate <0, 15, 0> }
cone { <0, 0, 0 > , 0.2
       <0, 1.2, 0>, 0
       rotate <0, 0, 144> }
cone { <0, 0, 0 > , 0.2
       <0, 1.2, 0>, 0
       rotate <0, 0, 216> }
cone { <0, 0, 0 > , 0.2
       <0, 1.2, 0>, 0
       rotate <0, 0, 288>
       rotate <0, -15, 0> }
}

#declare Bucket = union {
   difference {  // main bucket
     cone { <0, 0, 0>, 1.3
            <0, 3, 0>, 1.8 }
     cone { <0, 0.5, 0> , 0.5
            <0, 3.1, 0> , 1.65 }
     texture {
       pigment {color SpicyPink}
       normal {bumps 0.1 scale 0.3}
     }
   }
   cone { <-0.2, 0.5,0>, 0.5    //sand in bucket
          <0.2, 2.6, 0>, 1.5
          texture {Sand} }
   difference {  // handle
     torus {1.85, 0.1
       rotate <90, 0, 0>
       translate <0, 3, 0>}
     plane { y, 2.6}
     pigment {color Plum}
   }
   object {Buck_Star
      pigment {color Yellow}
      rotate <-15, 0, 0>
      translate <0, 1.5, -1.5>}
   bounded_by {sphere {<0, 2, 0>, 3}}

}  // end bucket union

// ------------------------------------------------------------
// breaking wave

#declare Wave = union {
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 4
   v_steps 4
   <-10, 0, -1>, <-5, 0, 0>, <0, 0, 0>, <5, 0, -1>
   <-9, 0.5, 1>, <-5, 0.7, 1>, <-1, 0.7, 1>, <4, 0.3, 1>
   <-8, 1, 2>, <-5, 1.6, 1.5>, <-1, 1.7, 1.5>, <2, 0.8, 2>
   <-5, 1.4, 0>, <-4, 1.4, -1>, <-2, 1.5, -1>, <0, 1, 0>
}

bicubic_patch {
   type 1
   flatness 0.01
   u_steps 4
   v_steps 4
   <-10, 0, -1>, <-5, 0, 5>, <0, 0, 5>, <5, 0, -1>
   <-9, 0.5, 1>, <-5, 0.7, 3>, <-1, 0.7, 3>, <4, 0.3, 1>
   <-8, 1, 2>, <-5, 1.6, 2.5>, <-1, 1.7, 3.5>, <2, 0.8, 2>
   <-5, 1.4, 0>, <-4, 1.4, -1>, <-2, 1.5, -1>, <0, 1, 0>
}

}


// ------------------------------------------------------------
// Glass bottle
#declare Bottle = union {
   merge {
   torus { 1, 0.2
         translate <0, 14.6, 0>}
   difference {
      cylinder {<0, 15, 0>, <0, 10, 0>, 1}
      cylinder {<0, 15, 0>, <0, 10, 0>, 0.7}
   }
   difference {
      cone {<0, 10, 0>, 1
            <0, 7, 0>, 3}
      cone {<0, 10, 0>, 0.7
            <0, 7, 0>, 2.7}
  }
   difference {
      cylinder {<0, 7, 0>, <0, -2, 0>, 3}
      cylinder {<0, 7, 0>, <0, -1, 0>, 2.5}
   }
// horrible botch to cover up bug gap between cone/cylinder
// the cylinder above should sit on the cone exactly but it
// doesnt.This gap is very visible even from a far distance
   torus {2.95, 0.1
         translate <0, 6.95, 0> }

}     // end bottle merge

// drink
cylinder {<0, 6, 0>, <0, -1, 0>, 2.5
         texture
         {pigment {color Brown filter 0.9} }
         }
// straw
cylinder {<1, -1, 0>, <-0.7, 19, 0>, 0.3
         pigment {color Red}}
}     // end bottle union


// ------------------------------------------------------------
// Sea Shell
#declare Shell_Bit =
  blob {
    threshold 0.1
    component 2.5, 1.2, <0, 4, 0.5>
    component 2.0, 0.85, <0, 3, 0>
    component 3.0, 0.7, <0, 2, -0.5>
    component 5.0, 0.5, <0, 1.2, -0.3>
  texture {Shell_Pink}
  }
#declare Shell = union {
object {Shell_Bit}
object {Shell_Bit scale 0.97 rotate <0, 0, -15>}
object {Shell_Bit scale 0.93 rotate <0, 0, -30>}
object {Shell_Bit scale 0.97 rotate <0, 0, 15>}
object {Shell_Bit scale 0.93 rotate <0, 0, 30>}
}

// -------------------------------------------------------------
// SandCastle

#declare SandCastle = union {
  union {
  cone {<0, -1, 0>, 6  // base
       <-0.5, 4.04, 0>, 3
       }
  torus {2.63, 0.5      // to take away sharp edges
        rotate <0, 0, 5.7>
        translate <-0.45, 3.7, 0>
        }
  cylinder {<0, 3.7, 0>, <0, 4.2, 0>, 2.7 // to fill in hole in torus
           rotate <0, 0, 6>
           }
  texture {Sand}    // to give whole base same texture
  } // end union - base

  cone {<0, 4, 0>, 1.5  // top castle
      <0, 7, 0>, 1
      texture {Sand}
      }
// moat / wall
difference {
  torus {4.66, 1 scale <1.5, 1, 1.5>}
  torus {8.5, 1.8 translate <0, 1.8, 0>}
  torus {5.5, 1.8 translate <0, 1.8, 0>}
  texture {Sand}
}

// flag
  cylinder { <0, 7, 0>, <0, 8.5, 0>, 0.075
           texture {Faded_Wood}}
  bicubic_patch {
    type 1
    flatness 0.01
    u_steps 3
    v_steps 3
    <0, 8.5, 0>, <0, 8.3, 0>, <0, 8.1, 0>, <0, 7.9, 0>
    <1.4, 8.5, -0.5>, <1.4, 8.3, -0.5>, <1.4, 8.1, -0.5>, <1.4, 7.9, -0.5>
    <0.7, 8.2, 1>, <0.7, 8.1, 1>, <0.7, 7.9, 1>, <0.7, 7.7, 1>
    <2, 8.5, 0>, <1.7, 8.3, 0>, <1.7, 8.1, 0>, <2, 7.9, 0>
    pigment {
      gradient y
      color_map
        {[0, 0.3 color White color White]
         [0.3 0.66 color Red color Red]
         [0.66 1.01 color Blue color Blue]
        }
    }
  }
  object {Shell scale 0.35 translate <2, 1, -3.2>}
  object {Shell scale 0.35 translate <-1, 0.6, -4.2>}
  object {Shell scale 0.35  rotate <0, 60, 0> translate <-4, 1, -1.7>}
}

// -------------------------------------------------------------
// Deck Chair

#declare Chair_Side = union {
   cylinder {<12, 0.5, -0.3>, <12, 0.5, 0>, 0.5}
   box {<0, 0, 0>, <18, 1, -0.3>
       rotate <0, 0, -45>
       translate <-1.25, 13, 0>
       }
   cylinder {<-1, 13.5, -0.3>, <-1, 13.5, 0>, 0.5}
}

#declare Chair_Support = union {
   box {<-0.5, 0, -0.3>, <8.2, 1, -0.6>
       rotate <0, 0, 70>
       translate <1.43, 1.2, 0>
       }
   cylinder {<1, 1.2, -0.3>, <1, 1.2, -0.6>, 0.5}
}

#declare Chair_Base = union {
   cylinder {<-1, 0.5, 0>, <-1, 0.5, 0.3>, 0.5
            }
   cylinder {<13, 0.5, 0>, <13, 0.5,0.3>, 0.5
            }
   difference {
      box { <-1, 0, 0>, <13, 1, 0.3>
          }
// notches are slightly wider than base,to make them cut out
      box { <0, 0, -.1>, <1, 0.5, 0.4>
          rotate <0, 0, -30>
          translate <1, 1, 0>
          }
      box { <0, 0, -.1>, <1, 0.5, 0.4>
          rotate <0, 0, -30>
          translate <2, 1, 0>
          }
      box { <0, 0, -.1>, <1, 0.5, 0.4>
          rotate <0, 0, -30>
          translate <3, 1, 0>
          }
      box { <0, 0, -.1>, <1, 0.5, 0.4>
          rotate <0, 0, -30>
          translate <4, 1, 0>
          }
      }
}


// textures put on sides etc here to follow shape
// general texture would give appearance of being
// carved from a block of wood, not separate planks

#declare Chair = union {
   object {Chair_Base
          rotate <0, 0, 20>
          texture {Faded_Wood rotate <0, 80, 0> scale 0.25}}
   object {Chair_Side
          texture {Faded_Wood rotate <0, 60, 0> scale 0.25}}
   object {Chair_Support
          texture {Faded_Wood rotate <80, 0, 0> scale 0.25}}
   object {Chair_Base
          rotate <0, 0, 20>
          translate <0, 0, 6>
          texture {Faded_Wood rotate <0, 80, 0> scale 0.25}}
   object {Chair_Side
   translate <0, 0, 6.6>
     texture {Faded_Wood rotate <0, 60, 0> scale 0.25}}
   object {Chair_Support
   translate <0, 0, 7.2>
     texture {Faded_Wood rotate <80, 0, 0> scale 0.25}}
   cylinder { <1, 1.2, -0.7>, <1, 1.2, 7>, 0.2} // support
   cylinder { <12, 0.5, -0.4>, <12, 0.5, 6.7>, 0.2} // front bottom
   cylinder { <-1, 13.5, -0.4>, <-1, 13.5, 6.7>, 0.2} // front top
   cylinder { <-1, 0.2, -0.1>, <-1, 0.2, 6.4>, 0.2} // base back
   cylinder { <11.8, 4.8, -0.1>, <11.8, 4.8, 6.4>, 0.2} // base front (seat)
   cylinder { <3.6, 8.6, 0.1>, <3.6, 8.6, -0.7>, 0.2}  // peg support top l
   cylinder { <3.6, 8.6, 6.2>, <3.6, 8.6, 7>, 0.2}  // peg support top r
   cylinder { <8.6, 3.6, -0.4>, <8.6, 3.6, 0.4>, 0.2} // base\side peg l
   cylinder { <8.6, 3.6, 5.9>, <8.6, 3.6, 6.7>, 0.2} // base\side peg r
}

// ------------------------------------------------------------------
// Deck Chair material

#declare Chair_Material_1 = union {
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 4
   v_steps 4
   <-1, 13.5, 0.5>, <-1, 13.5, 2.2>, <-1, 13.5, 4.1>, <-1, 13.5, 5.8>
   <4, 15, 0.5>, <4, 14, 2>, <3.5, 14.5, 4>, <4, 15, 5.5>,
   <9, 12, 0>, <8, 12, 2.1>, <9, 13, 4.1>, <9, 11, 5.3>,
   <11.8, 4.8, 0.5>, <11.8, 4.8, 2.2>, <11.8, 4.8, 4.1>, <11.8, 4.8, 5.8>
   }
   cylinder { <11.8, 4.8, 0.5>, <11.8, 4.8, 5.8>, 0.2}
   cylinder { <-1, 13.5, 0.5>, <-1, 13.5, 5.8>, 0.2}
}
