// Persistance of Vision Script File - FISHING
// Created for IRTC "Summer" Contest - July/August 1996
// Sonya Roberts, July 22, 1996

// Include Files
#include "colors.inc"
#include "stones.inc"
#include "skies.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"
#include "woods.inc"
#include "glass.inc"

// Setup camera(s)
#declare Viewpoint=
camera {
	location	<0,5,-27.5>
	up		<0,1,0>
	right		<1.3,0,0>
	look_at		<0,5,0>
}


// Create Background
light_source {
	<30,200,-50>
	color White
}

sky_sphere{
	pigment{
		gradient y
		translate <0,1,0>
		color_map {
			[0 color MidnightBlue]
			[1 color LightBlue]
		}
		scale <1,2,1>
	}
}

object {
	plane {<0,1,0>,0}
	pigment {color Tan}
	finish {ambient .3}
	normal {ripples .8	scale <1,.25,.25>}
}

object {
	height_field {
		tga "water.tga"
		translate <-.5,0,-.5>
		scale <800,2,600>
		rotate y*-25
	}
	texture {T_Old_Glass}
	finish {
		refraction 1
		ior 1.33
	}
	translate <0,10,0>
}

object {
	height_field {
		tga "land.tga"
		translate <-.52,-.2,-.5>
		scale <800,150,900>
	}
	pigment {
		gradient y
		color_map {
			[0	color Tan]
			[.3	color Tan]
			[.4	color MediumForestGreen]
			[1	color HuntersGreen]
		}
		translate <0,-.2,0>
		scale <1,150,1>
	}
	finish {ambient .3}
}

fog {
	distance 80
	color rgbf <.3,.5,.2,.5>
	fog_type 2
	fog_offset .25
	fog_alt 5
}

// Create Image Elements
#include "fishlife.pov"

#declare Engine=
object {
	union {
		box{<-.5,-.25,-.5>,<1,1,.5>}
		cylinder {<.5,-2,0>,<.5,0,0>,.125}
		sphere {<0,0,0>,.25	scale <1.5,.75,.75>	translate <.615,-2,0>}
		box{<.93,-2.15,-.5>,<.931,-1.85,.5>}
		box{<.93,-2.5,-.15>,<.931,-1.5,.15>}
	}
	pigment {color Black}
	finish {reflection .2}
}

#declare Worm=
object {
	union {
		sphere {<-.055,.085,0>,.01}
		sphere {<-.05,.07,0>,.015}
		sphere {<-.045,.055,0>,.02}
		sphere {<-.045,.04,0>,.025}
		sphere {<-.045,.03,0>,.025}
		sphere {<-.03,.02,0>,.025}
		sphere {<-.015,.01,0>,.025}
		sphere {<0,0,0>,.025}
		sphere {<.015,0,0>,.025}
		sphere {<.03,0,0>,.025}
		sphere {<.04,-.01,0>,.025}
		sphere {<.05,-.02,0>,.025}
		sphere {<.055,-.03,.01>,.025}
		sphere {<.06,-.04,.02>,.025}
		sphere {<.065,-.04,.02>,.025}
		sphere {<.08,-.04,.02>,.025			pigment {color Red}}
		cylinder {<.08,-.04,.02>,<.125,-.05,.02>,.025	pigment {color Red}}
		sphere {<.125,-.05,.02>,.025			pigment {color Red}}
		sphere {<.14,-.05,.02>,.025}
		sphere {<.15,-.05,.03>,.025}
		sphere {<.16,-.05,.04>,.025}
		sphere {<.165,-.055,.035>,.025}
		sphere {<.17,-.06,.03>,.025}
		sphere {<.175,-.065,.03>,.025}
		sphere {<.185,-.065,.03>,.025}
		sphere {<.195,-.07,.025>,.025}
		sphere {<.2,-.07,.02>,.025}
		sphere {<.21,-.07,.015>,.025}
		sphere {<.22,-.065,.01>,.025}
		sphere {<.225,-.06,.005>,.025}
		sphere {<.23,-.055,0>,.025}
		sphere {<.23,-.05,-.01>,.025}
		sphere {<.23,-.045,-.02>,.025}
		sphere {<.235,-.04,-.03>,.025}
		sphere {<.24,-.04,-.04>,.025}
		sphere {<.245,-.035,-.05>,.025}
		sphere {<.25,-.035,-.06>,.025}
		sphere {<.255,-.03,-.06>,.025}
		sphere {<.26,-.025,-.055>,.025}
		sphere {<.27,-.02,-.05>,.025}
		sphere {<.28,-.02,-.045>,.025}
		sphere {<.29,-.02,-.04>,.025}
		sphere {<.3,-.015,-.035>,.02}
		sphere {<.31,-.015,-.03>,.02}
		sphere {<.32,-.015,-.025>,.015}
		sphere {<.33,-.015,-.0225>,.015}
	}
	pigment {color Firebrick}
	finish {ambient .3 phong .4}
	rotate y*180
}

#declare Hook=
union {
	object {
		union {
			torus {.01,.0075 translate <0,0,.01>}
			cylinder {<0,0,0>,<0,0,-.1>,.0075}
			intersection {
				torus {.05,.0075}
				box{<-.06,-.02,-.06>,<.06,.02,0>}
				translate <-.05,0,-.1>
			}
			cone {<-.1,0,-.1>,.0075,<-.1,0,-.075>,0}
			cone {<-.1,0,-.1>,.007,<-.075,0,-.13>,0	scale <1,.5,1>}
		}
		texture {T_Silver_3D}
		rotate x*-90
	}
	object{Worm	translate <-.05,-.15,0>}
	rotate x*80
}

#declare FishPole=
union {
	object {
		cylinder {<0,0,0>,<0,.75,0>,.1}
		pigment {color Brown}
	}
	object {
		cone {<0,.75,0>,.075,<0,6.75,0>,.02}
		pigment {color Orange}
	}
	object {
		union {
			torus {.025,.02	translate <0,6.75,-.025>}
			torus {.025,.02	translate <0,5.75,-.025>}
			torus {.025,.02	translate <0,4.75,-.025>}
			torus {.025,.02	translate <0,3.75,-.025>}
			torus {.025,.02	translate <0,2.75,-.025>}
			torus {.025,.02	translate <0,1.75,-.025>}
		}
		texture {T_Silver_4E}
	}
	object {
		union {
			cylinder {<-.15,.5,-.15>,<.15,.5,-.15>,.15}
			box {<-.16,.3,-.16>,<-.15,.5,-.14>}
			cylinder {<-.25,.325,-.15>,<-.16,.325,-.15>,.05}
		}
		pigment {color Black}
	}
	object {
		union {
			cylinder {<0,.5,-.1>,<0,1.75,-.05>,.005}
			cylinder {<0,1.75,-.05>,<0,6.75,-.05>,.005}
			intersection {
				torus {15,.005	rotate z*90	translate <0,21.75,0>}
				box {<-.1,6.75,-15>,<.1,21.75,0>}
			}
			sphere {<0,21.75,-14.985>,.015}
		}
		texture {T_Green_Glass}
	}
	object {Hook	translate <0,21.75,-15>}
	rotate x*-70
}

#declare Fisher1=
union {
	object {
		union {
			cone {<0,0,0>,.5,<0,1.5,0>,.7	scale <1,1,.5>}
			sphere {<0,1.5,0>,.7	scale <1,1,.5>}
			sphere {<-.75,1.5,0>,.35}
			sphere {<.75,1.5,0>,.35}
			cylinder {<-.75,1.5,0>,<-.85,0,0>,.35}
			cylinder {<.75,1.5,0>,<.85,0,0>,.35}
		}
		pigment {color Blue}
	}
	object {
		union {
			cylinder {<0,1.5,0>,<0,1.75,0>,.35}
			sphere {<0,1.95,0>,.5	scale <.8,1.25,1>}
			sphere {<0,1.95,0>,.5	scale <.8,1.25,1>	translate <0,.1,.1> pigment {color Brown}}
		}
		pigment {color Flesh}
	}
	object {
		union {
			cylinder {<0,2.45,0>,<0,2.5,0>,.75}
			cylinder {<0,2.45,0>,<0,2.75,0>,.5}
			cylinder {<0,2.45,0>,<0,2.55,0>,.51	pigment {color Red}}
			scale <.8,1,1>
		}
		pigment {color White}
	}
	rotate x*-10
}

#declare Fisher2=
union {
	object {
		union {
			cone {<0,0,0>,.5,<0,1.5,0>,.7	scale <1,1,.5>}
			sphere {<0,1.5,0>,.7	scale <1,1,.5>}
			sphere {<-.75,1.5,0>,.35}
			sphere {<.75,1.5,0>,.35}
			cylinder {<-.75,1.5,0>,<-.85,0,0>,.35}
			cylinder {<.75,1.5,0>,<.85,0,0>,.35}
		}
		pigment {color Violet}
	}
	object {
		union {
			cylinder {<0,1.5,0>,<0,1.75,0>,.35}
			sphere {<0,1.95,0>,.5	scale <.8,1.25,1>}
			sphere {<0,1.95,0>,.5	scale <.8,1.25,1>	translate <0,.1,.1> pigment {color Brown}}
		}
		pigment {color Flesh}
	}
	object {
		union {
			cylinder {<0,2.45,0>,<0,2.5,0>,.75}
			cylinder {<0,2.45,0>,<0,2.75,0>,.5}
			cylinder {<0,2.45,0>,<0,2.55,0>,.51	pigment {color Red}}
			scale <.8,1,1>
		}
		pigment {color White}
	}
	rotate x*7
	rotate y*-90
}

#declare Anchor=
union {
	union {
		object {
			difference {
				box {<-.75,-.75,-.5>,<.75,0,.5>}
				box {<-.76,-.76,-.4>,<-.65,.1,.4>}
				box {<.65,-.76,-.4>,<.76,.1,.4>}
				box {<-.55,-.76,-.4>,<-.05,.1,.4>}
				box {<.05,-.76,-.4>,<.55,.1,.4>}
			}
			pigment {color Gray60}
		}
		object {
			union {
				cylinder {<-.1,.05,0>,<.1,.05,0>,.05}
				cylinder {<-.1,-.8,0>,<.1,-.8,0>,.05}
				cylinder {<-.1,-.8,0>,<-.1,.05,0>,.05}
				cylinder {<.1,-.8,0>,<.1,.05,0>,.05}
				sphere {<-.1,.05,0>,.05}
				sphere {<.1,.05,0>,.05}
				sphere {<-.1,-.8,0>,.05}
				sphere {<.1,-.8,0>,.05}
				sphere {<0,.07,0>,.07}
				cylinder {<0,.07,0>,<.2,.25,-.3>,.05}
			}
			pigment {color Yellow}
			finish {ambient .3}
		}
		rotate x*-80
		rotate y*-15
	}
	object {
		cylinder {<0,.05,0>,<1,14,-3>,.05}
		pigment {color Yellow}
		finish {ambient .3}
	}
}

#declare BoatForm=
object {
	intersection {
		merge {
			sphere{<-2.5,0,0>,3	scale <1.5,1,1>}
			cylinder{<-3,0,0>,<3,0,0>,3}
		}
		box{<-8.1,-3.1,-3.1>,<3.1,0,3.1>}
	}
}

#declare PaintJob=
texture {
	pigment {
		gradient y
		color_map {
			[0	color Clear]
			[.65	color Clear]
			[.65	color Red]
			[1	color Red]
		}
		scale <1,3.5,1>
		translate <0,-3.5,0>
		rotate z*-3
	}
	finish {ambient .2}
}

#declare Boat=
union {
	object {
		union {
			intersection {
				object {BoatForm}
				box{<-8.1,-3.1,-3.1>,<3.1,0,-.5>}
				translate <0,0,.5>
			}
			intersection {
				object {BoatForm}
				box{<-8.1,-3.1,.5>,<3.1,0,3.1>}
				translate <0,0,-.5>
			}
		}
		texture {T_Chrome_3C}
		texture {PaintJob}
		scale <1,.75,1>
	}
	object {Engine				translate <3,0,0>}
	object {Fisher1				translate <1.5,0,-1>}
	object {FishPole	rotate y*29.5	translate <1.5,0,-1.5>}
	object {Fisher2				translate <-3,0,0>}
	object {FishPole	rotate x*30	rotate y*185	translate <-2,0,1>}
	object {Anchor				translate <-6,-11,5.5>}
}

#declare Popcan=
union {
	object {
		cylinder {<0,0,0>,<0,1,0>,.25}
		pigment {
			image_map {
				tga "popcan.tga"
				map_type 2
			}
		}
		finish {ambient .3}
	}
	object {
		union {
			cylinder {<0,-.025,0>,<0,1.025,0>,.249}
			torus {.209,.04	translate <0,1.025,0>}
		}
		texture {T_Silver_3D}
	}
	object {
		cylinder {<0,1.02,-.2>,<0,1.0251,-.2>,.04}
		pigment {color Black}
	}
	translate <0,.025,0>
	scale <.5,.5,.5>
}

#declare NoSign=
union {
	object {
		box {<0,0,-.1>,<2,1.5,0>}
		pigment {
			image_map {
				tga "sign.tga"
			}
			scale <2,1.5,1>
		}
		finish {ambient .2}
		translate <-1,1.6,0>
	}
	object {
		box {<-.1,0,0>,<.1,3.25,.2>}
		pigment {color White}
		finish {ambient .2}
	}
	rotate x*40
	rotate y*35
	rotate z*-10
	translate <0,-.5,0>
}

#declare TreeShadows=
object {
	box{<0,0,0>,<1,1,.01>}
	pigment {
		image_map {
			gif "trees.gif"
			transmit 0,1
		}
	}
	scale <36,12,1>
}

#declare Tire=
object {
	difference {
		union {
			torus {1.2,.4	scale <1,.75,1>}
			difference {
				cylinder {<0,-.41,0>,<0,.41,0>,1.2	pigment {color White}}
				cylinder {<0,-.42,0>,<0,.42,0>,1.1}
				scale <1,.75,1>
			}
		}
		torus {1.1,.4	scale <1,.7,1>}
	}
	pigment {color Black}
	rotate x*-32
	rotate y*-40
}

#declare NameTag=
object {
	text {
		ttf "banff.ttf"
		"Sonya Roberts '96"
		.1,0
	}
	pigment {color ForestGreen}
	finish {phong .3}
	scale <.1,.1,.1>	
}

// Assemble Image
camera	{Viewpoint}
object	{Boat	rotate y*-25		translate <0,11.5,0>}
object	{Fishes					translate <-2,0,0>}
object 	{Minnows	rotate y*85		translate <5,6,-22>}
object	{Popcan		rotate x*20		translate <10,-.15,-4>}
object	{Popcan		rotate <230,10,0>	translate <5,-.05,6>}
object	{Popcan		rotate <25,5,55>	translate <3,-.15,-5>}
object	{Popcan		rotate <15,5,15>	translate <.5,-.1,-13>}
object	{Popcan		rotate <75,80,0>	translate <1.5,-.1,-16>}
object	{Popcan		rotate <65,30,0>	translate <.5,-.15,-17>}
object	{Popcan		rotate y*5		translate <-.5,-.1,-17.25>}
object	{NoSign					translate <4,0,-17.5>}
object	{Tire					translate <-8,0,-9>}
object	{NameTag				translate <-2.85,2.8,-23>}
object	{TreeShadows	rotate x*60	rotate y*-40		translate <9,15,-27>}
object	{TreeShadows	scale <2,2,2>	rotate y*25		translate <40,9,50>}

// Create Duckweed
#declare Leaf=
object {
	union {
		cone {<0,0,0>,.005,<0,0,.25>,.025}
		sphere {<0,0,.25>,.025}
	}
	scale <1,.02,1.15>
}
#declare Count=0
#declare R1=seed(0)
#while (Count < 400)
	#declare Size=(.25+(rand(R1)*2))
	object	{
		union {
			cylinder {<0,0,0>,<0,.5,0>,.0125}
			object {Leaf
				rotate x*-(50+(rand(R1)*30))
				translate <0,.5,0>}
			object {Leaf
				rotate x*-(50+(rand(R1)*30))
				rotate y*120
				translate <0,.35,0>}
			object {Leaf
				rotate x*-(50+(rand(R1)*30))
				rotate y*240
				translate <0,.2,0>}
		}
		pigment {color Green}
		scale <Size,Size,Size>
		rotate <(rand(R1)*5),(rand(R1)*360),(rand(R1)*5)>
		translate <((rand(R1)*150)-75),0,(rand(R1)*80)-25>
	}
	#declare Count=Count+1
#end

