//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 2 lights, 23 textures and 212 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.0.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 08/18/1996    (18.08.1996)
//

#max_trace_level 5

global_settings { assumed_gamma 2.0 }

// Persistence Of Vision raytracer version 3.0 sample file.
// File by Dieter Bayer.

#version 3.0

sky_sphere {
  pigment {
    gradient z
    color_map {
      [0.5  color rgb <.6,.6,1.0> ]
      [1.0  color rgb <.4,.4,.7>  ]
    }
    scale 2
    translate -1
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 8
    omega 0.6
    lambda 2.6
    color_map {
      [0.0 color rgbf<.75, .75, .75, 0.1>]
      [0.4 color rgbf<.90, .90, .90, .90>]
      [0.7 color rgbf<1, 1, 1, 1>]
    }
    rotate 15.0*z
    scale .3
    scale <1, 0.45, 0.20>
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 7
    omega 0.55
    lambda 2.55
    color_map {
      [0.0 color rgbf<.55, .55, .55, 0.3>]
      [0.4 color rgbf<.60, .60, .60, 0.9>]
      [0.6 color rgbf<0.55, 0.55, 0.55, 1>]
    }
    rotate 15.0*z
    scale .3
    scale <1, 0.45, 0.20>
  }
  rotate <0,0,-45>
  scale 0.8*z
}

fog {
  fog_type 2
  distance 15
  colour rgbf<0.8, 0.8, 1.0, 0.4>
  turbulence 0.65
  fog_offset 0.00
  fog_alt 0.50
  up 1*z
}

camera {  //  Camera StdCam
  location  <-13.000, -10.000, 0.250>
  direction <0.0,     0.0,  1.4297>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <1.000, 0.000, 4.500>
}

// *******  L I G H T S *******
light_source {   // LightBack
  <40.000, 10, 40.000>
  color rgb <0.000, 0.000, 0.4>
}

light_source {   // LightSun
  <-80.000, 10.000, 5.000>
  color rgb <0.900, 1.000, 0.900>
}


// ********  TEXTURES  *******
//

#include "ballfest.inc"
#include "plant01.inc"

// *********** STOCK DEFINITIONS *************

#declare BallPatch = bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.015900, -2.647773, 0.001853>, <-0.000102, -2.647773, 0.001853>, <-0.001414, -2.647773, 0.001853>, <0.015205, -2.647773, 0.001853>,
      <-1.224754, -2.395682, 3.176443>, <-0.384533, -2.396010, 3.811586>, <0.398495, -2.395682, 3.811586>, <1.220169, -2.395682, 3.181874>,
      <-1.224754, -0.200000, 2.655579>, <-0.384533, -0.200000, 3.550723>, <0.398495, -0.200000, 3.550723>, <1.209955, -0.200000, 2.661010>,
      <-0.168862, 3.103207, 0.393786>, <-0.133692, 3.009823, 0.676133>, <0.137527, 3.011370, 0.674913>, <0.172203, 3.100000, 0.394983>
   }

#declare BzPtchSide = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.034675, 0.007855, -4.486213>, <-1.034675, -0.527059, -4.486213>, <-0.569828, -0.964716, -4.486213>, <-0.001682, -0.964716, -4.486213>,
      <-1.313219, 0.023881, -4.393575>, <-1.313219, -0.687132, -4.393575>, <-0.724789, -1.268870, -4.393575>, <-0.005597, -1.268870, -4.393575>,
      <-1.330116, 0.039908, -2.587189>, <-1.330116, -0.671105, -2.587189>, <-0.734681, -1.252843, -2.587189>, <-0.006927, -1.252843, -2.587189>,
      <-1.011578, 0.051849, -2.524979>, <-1.011578, -0.571322, -2.524979>, <-0.550553, -1.081188, -2.524979>, <0.012922, -1.081188, -2.524979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001682, -0.964716, -4.486213>, <0.566464, -0.964716, -4.486213>, <1.031311, -0.527059, -4.486213>, <1.031311, 0.007855, -4.486213>,
      <-0.005597, -1.268870, -4.393575>, <0.713596, -1.268870, -4.393575>, <1.302026, -0.687132, -4.393575>, <1.302026, 0.023881, -4.393575>,
      <-0.006927, -1.252843, -2.587189>, <0.720827, -1.252843, -2.587189>, <1.316262, -0.671105, -2.587189>, <1.316262, 0.039908, -2.587189>,
      <0.012922, -1.081188, -2.524979>, <0.576397, -1.081188, -2.524979>, <1.037422, -0.571322, -2.524979>, <1.037422, 0.051849, -2.524979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.031311, 0.007855, -4.486213>, <1.031311, 0.542768, -4.486213>, <0.566464, 0.980425, -4.486213>, <-0.001682, 0.980425, -4.486213>,
      <1.302026, 0.023881, -4.393575>, <1.302026, 0.734895, -4.393575>, <0.713596, 1.316633, -4.393575>, <-0.005597, 1.316633, -4.393575>,
      <1.316262, 0.039908, -2.587189>, <1.316262, 0.750921, -2.587189>, <0.720827, 1.332660, -2.587189>, <-0.006927, 1.332660, -2.587189>,
      <1.037422, 0.051849, -2.524979>, <1.037422, 0.675019, -2.524979>, <0.576397, 1.184886, -2.524979>, <0.012922, 1.184886, -2.524979>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.001682, 0.980425, -4.486213>, <-0.569828, 0.980425, -4.486213>, <-1.034675, 0.542768, -4.486213>, <-1.034675, 0.007855, -4.486213>,
      <-0.005597, 1.316633, -4.393575>, <-0.724789, 1.316633, -4.393575>, <-1.313219, 0.734895, -4.393575>, <-1.313219, 0.023881, -4.393575>,
      <-0.006927, 1.332660, -2.587189>, <-0.734681, 1.332660, -2.587189>, <-1.330116, 0.750921, -2.587189>, <-1.330116, 0.039908, -2.587189>,
      <0.012922, 1.184886, -2.524979>, <-0.550553, 1.184886, -2.524979>, <-1.011578, 0.675019, -2.524979>, <-1.011578, 0.051849, -2.524979>
    }
  }
  texture {
    TextureBasket
  }
}

#declare GroupBasket = union {
  cylinder { // CylndrFlameRo7
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureSteel
    }
    scale <0.1, 0.1, 1.0>
  }
  cone { // ConeFlame7
    <0,0,0>, 0.2, <0,0,1>, 0.4
    open
    texture {
      TextureSteel
    }
    scale <0.75, 0.75, 1.0>
    translate  1.0*z
  }
  disc { // DiscFlameBase7
    <0,0,0>, <0,0,1>, 1.0, 0.75
    texture {
      TextureSteel
    }
    scale <0.5, 0.5, 1.0>
    translate  1.25*z
  }
  cylinder { // CylndrRope57
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate <-15.0, 0.0, -315.0>
    translate  <-0.7778, 0.7778, -2.7>
  }
  cylinder { // CylndrRope58
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate <-15.0, 0.0, -270.0>
    translate  <-1.1, 0.0, -2.7>
  }
  object { BzPtchSide }
  disc { // DiscBase7
    <0,0,0>, <0,0,1>, 1.0
    texture {
      TextureBasket
    }
    scale <0.99, 0.99, 1.0>
    translate  -4.48*z
  }
  cylinder { // CylndrRope59
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate -15.0*x
    translate  <0.0, 1.1, -2.7>
  }
  cylinder { // CylndrRope60
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate <-15.0, 0.0, -90.0>
    translate  <1.1, 0.0, -2.7>
  }
  cylinder { // CylndrRope61
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate <-15.0, 0.0, -45.0>
    translate  <0.7778, 0.7778, -2.7>
  }
  cylinder { // CylndrRope62
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate <-15.0, 0.0, -135.0>
    translate  <0.7778, -0.7778, -2.7>
  }
  cylinder { // CylndrRope63
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate <-15.0, 0.0, -180.0>
    translate  <0.0, -1.1, -2.7>
  }
  cylinder { // CylndrRope64
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 5.0>
    rotate <-15.0, 0.0, -225.0>
    translate  <-0.7778, -0.7778, -2.7>
  }
  cylinder { // CylndrPullRop7
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureRope
    }
    scale <0.03, 0.03, 2.0>
    translate  -1.9*z
  }
  cylinder { // CylndrSideBar7
    <0,0,1>, <0,0,0>, 1
    texture {
      TextureSteel
    }
    scale <0.03, 0.03, 4.3>
    rotate -90.0*y
    translate  <2.15, 0.0, 1.25>
  }
  scale 0.23
  rotate -22.5*z
  translate  -1.4*z
}

// ***************** END OF STOCK OBJECTS

#declare BzPtch65 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch66 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch67 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch68 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch69 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch70 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch71 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch72 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloonS6
  object { BzPtch65 }
  object { BzPtch66 }
  object { BzPtch67 }
  object { BzPtch68 }
  object { BzPtch69 }
  object { BzPtch70 }
  object { BzPtch71 }
  object { BzPtch72 }
  object { GroupBasket }
  scale 0.2
  translate  <35.700001, 32.4, 30.0>
}


#declare BzPtch73 = object {   object {
    BallPatch
  }
  texture {
    Dav1
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch74 = object {   object {
    BallPatch
  }
  texture {
    Dav2
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch75 = object {   object {
    BallPatch
  }
  texture {
    Dav1
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch76 = object {   object {
    BallPatch
  }
  texture {
    Dav2
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch77 = object {   object {
    BallPatch
  }
  texture {
    Dav1
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch78 = object {   object {
    BallPatch
  }
  texture {
    Dav2
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch79 = object {   object {
    BallPatch
  }
  texture {
    Dav1
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch80 = object {   object {
    BallPatch
  }
  texture {
    Dav2
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloonS7
  object { BzPtch73 }
  object { BzPtch74 }
  object { BzPtch75 }
  object { BzPtch76 }
  object { BzPtch77 }
  object { BzPtch78 }
  object { BzPtch79 }
  object { BzPtch80 }
  object { GroupBasket }
  rotate 9*z
  scale 0.4
  translate  <-5.5,-2.0,2.1>
}

#declare BzPtch57 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch58 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch59 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch60 = object {   object {
    BallPatch
  }
  texture {
    SolidRed
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch61 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch62 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch63 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch64 = object {   object {
    BallPatch
  }
  texture {
    SolidRed
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}
union { // GroupBalloonS5
  object { BzPtch57 }
  object { BzPtch58 }
  object { BzPtch59 }
  object { BzPtch60 }
  object { BzPtch61 }
  object { BzPtch62 }
  object { BzPtch63 }
  object { BzPtch64 }
  object { GroupBasket }
  scale 0.2
  translate  <9.7, 27.8, 22.0>
}


#declare BzPtch49 = object {   object {
    BallPatch
  }
  texture {
    SolidRed
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch50 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch51 = object {   object {
    BallPatch
  }
  texture {
    SolidRed
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch52 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch53 = object {   object {
    BallPatch
  }
  texture {
    SolidRed
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch54 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch55 = object {   object {
    BallPatch
  }
  texture {
    SolidRed
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch56 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloonS4
  object { BzPtch49 }
  object { BzPtch50 }
  object { BzPtch51 }
  object { BzPtch52 }
  object { BzPtch53 }
  object { BzPtch54 }
  object { BzPtch55 }
  object { BzPtch56 }
  object { GroupBasket }
  scale 0.2
  translate  <24.2, 17.2, 17.7>
}


#declare BzPtch41 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch42 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch43 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch44 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch45 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch46 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch47 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch48 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck3
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloonS3
  object { BzPtch41 }
  object { BzPtch42 }
  object { BzPtch43 }
  object { BzPtch44 }
  object { BzPtch45 }
  object { BzPtch46 }
  object { BzPtch47 }
  object { BzPtch48 }
  object { GroupBasket }
  scale 0.3
  translate  <14.0, 16.6, 14.8>
}


#declare BzPtch33 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch34 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch35 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch36 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch37 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch38 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch39 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch40 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloonS2
  object { BzPtch33 }
  object { BzPtch34 }
  object { BzPtch35 }
  object { BzPtch36 }
  object { BzPtch37 }
  object { BzPtch38 }
  object { BzPtch39 }
  object { BzPtch40 }
  object { GroupBasket }
  scale 0.28
  translate  <1.5, -1.5, 5.6>
}


#declare BzPtch25 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch26 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch27 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch28 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch29 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch30 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch31 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch32 = object {   object {
    BallPatch
  }
  texture {
    Map9
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloon1
  object { BzPtch25 }
  object { BzPtch26 }
  object { BzPtch27 }
  object { BzPtch28 }
  object { BzPtch29 }
  object { BzPtch30 }
  object { BzPtch31 }
  object { BzPtch32 }
  object { GroupBasket }
  scale 0.3
  rotate -45.0*z
  translate  <12.6, 12.6, 5.0>
}


#declare BzPtch17 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck2
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch18 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck1
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch19 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck2
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch20 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck1
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch21 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck2
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch22 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck1
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch23 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck2
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch24 = object {   object {
    BallPatch
  }
  texture {
    TextureCheck1
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloonS1
  object { BzPtch17 }
  object { BzPtch18 }
  object { BzPtch19 }
  object { BzPtch20 }
  object { BzPtch21 }
  object { BzPtch22 }
  object { BzPtch23 }
  object { BzPtch24 }
  object { GroupBasket }
  scale 0.5
  translate  <-2.9, 7.0, 5.25>
}

plane { // PlaneWaterBase
  z,0
  texture {
    TexturePlain
  }
  translate  -0.5*z
  hollow
}


plane { // WaterPlane
  z,0
  texture {
    Water
  }
  translate  -0.25*z
  hollow
}


object {   // HgtFldGrass
  height_field {
    tga "GRASSY.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    TextureGrass
  }
  scale <10.0, 10.0, 1.0>
  rotate <4.25, -0.05, -3.0>
  translate  0.1*z
}




#declare BzPtch1 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch2 = object {   object {
    BallPatch
  }
  texture {
    Map2
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch3 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch4 = object {   object {
    BallPatch
  }
  texture {
    Map2
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch5 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch6 = object {   object {
    BallPatch
  }
  texture {
    Map2
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch7 = object {   object {
    BallPatch
  }
  texture {
    Map1
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch8 = object {   object {
    BallPatch
  }
  texture {
    Map2
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloon
  object { BzPtch1 }
  object { BzPtch2 }
  object { BzPtch3 }
  object { BzPtch4 }
  object { BzPtch5 }
  object { BzPtch6 }
  object { BzPtch7 }
  object { BzPtch8 }
  object { GroupBasket }
  scale 0.6
  rotate -10.0*z
  translate  <-5.6, -8.0, 2.30>
}


#declare BzPtch9 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate -90.0*x
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch10 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, 45.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch11 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch12 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, 135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch13 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -180.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch14 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, -135.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch15 = object {   object {
    BallPatch
  }
  texture {
    SolidWhite
  }
  rotate <-90.0, 0.0, -90.0>
  translate  <0.0, 0.0, 2.0>
}
#declare BzPtch16 = object {   object {
    BallPatch
  }
  texture {
    SolidBlue
  }
  rotate <-90.0, 0.0, -45.0>
  translate  <0.0, 0.0, 2.0>
}

union { // GroupBalloonS
  object { BzPtch9 }
  object { BzPtch10 }
  object { BzPtch11 }
  object { BzPtch12 }
  object { BzPtch13 }
  object { BzPtch14 }
  object { BzPtch15 }
  object { BzPtch16 }
  object { GroupBasket }
  scale 0.5
  translate  <7.0, 2.0, 12.0>
}

object {
  Plant01
  rotate <75,-38,0>
  scale 0.0004
  translate <-8.3, -9.4, -0.60>
}

object {
  Plant01
  rotate <45,-10,-25>
  scale 0.0003
  translate <-9.0, -9.4, -0.45>
}

object {
  Plant01
  rotate<45,-10,105>
  scale 0.0002
  translate <-11.5,-8.0,-0.25>
}

