// Persistence Of Vision raytracer version 3.0 sample file.
// File by Dieter Bayer.

#version 3.0

sky_sphere {
  pigment {
    gradient z
    color_map {
      [0.5  color rgb <.5,.5,1.0> ]
      [1.0  color rgb <.1,.1,.3>  ]
    }
    scale 2
    translate -1
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 8
    omega 0.6
    lambda 2.6
    color_map {
      [0.0 color rgbf<.75, .75, .75, 0.1>]
      [0.4 color rgbf<.90, .90, .90, .90>]
      [0.7 color rgbf<1, 1, 1, 1>]
    }
    rotate 15.5*z
    scale .3
    scale <1, 0.45, 0.20>
  }
  pigment {
    bozo
    turbulence 0.65
    octaves 7
    omega 0.5
    lambda 2.5
    color_map {
      [0.0 color rgbf<.375, .375, .375, 0.2>]
      [0.4 color rgbf<.45, .45, .45, .9>]
      [0.6 color rgbf<0.5, 0.5, 0.5, 1>]
    }
    rotate 15.0*z
    scale .3
    scale <1, 0.45, 0.20>
  }
  rotate <0,0,-45>
}

fog {
  fog_type 2
  distance 50
  color rgbt<1,1,1,.75>
  turbulence 0.15
  fog_offset 0.2
  fog_alt 0.25
  up 1*z
}
