#version 3
global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "shapes.inc"
#include "shapes2.inc"

#declare RenderCam =  //In the path of a shaft of light
camera {
location <2.75,-10,-49>
look_at <2.8,-10.3,0>
angle 45
}

#declare OtherCam =
camera {
location <0,550,1000>
look_at <0,5,0>
angle 2
}                       

camera {RenderCam}

//Ambient-o-Light

object {light_source {<1,-5,-55>colour Gray45 atmosphere off}}

//Sun - FFR Area-o-Light
/*
object {
light_source {
<0,550,1000>
colour rgb <.88,.85,.5>
//area_light <400,0,0><0,400,-150>10,10
//adaptive 1
//jitter 1
spotlight
point_at <0,5,1.75>
radius 2
falloff 10
tightness 10
}
}
*/

object {
light_source {
<0,640,1000>
colour rgb <.88,.85,.5>
//area_light <400,0,0><0,400,-150>10,10
//adaptive 1
//jitter 1
}
}

#declare Sky1 =
sky_sphere {
pigment {
gradient y
colour_map {
[0 .3 colour rgb <.77,.08,.92> colour rgb <.87,.56,.55>]
[.3 1 colour rgb <.87,.56,.55> colour rgb <.98,.97,.26>]}
scale 3
scale <3,1,1>
}
pigment {
bozo
turbulence .3
lambda 2.6
colour_map {
[.0, .1 colour rgbf <.8,.8,.8,0> colour rgbf <.8,.8,.8,0>]
[.1, .5 colour rgbf <.8,.8,.8,0> colour rgbf <1,1,1,1>] 
[.5, 1 colour rgbf <1,1,1,1> colour rgbf <1,1,1,1>]}
scale <.1,1/16,1/16>
scale <3,1,1>
}
}

//Cut-Out

#declare T =
union {
object {cone {<0,0,0>,.05<0,9,0>,1}scale <1,1,100>}
object {cylinder {<0,0,-1><0,0,3>,1}scale <1,.5,1> translate <0,9,0>}
}

#declare GoldWave =
texture {Gold_Texture
normal {ripples 2 frequency .05 rotate <-90,0,0>}
}

#declare Window =

union {
        difference {
                object {cylinder {<0,0,-.3><0,0,2.3>,10}}
                object {T}
                object {T rotate <0,0,22.5>}
                object {T rotate <0,0,45>}
                object {T rotate <0,0,67.5>}
                object {T rotate <0,0,90>}
                object {T rotate <0,0,112.5>}
                object {T rotate <0,0,135>}
                object {T rotate <0,0,157.5>}
                object {T rotate <0,0,180>}
                object {T rotate <0,0,202.5>}
                object {T rotate <0,0,225>}
                object {T rotate <0,0,247.5>}
                object {T rotate <0,0,270>}
                object {T rotate <0,0,292.5>}
                object {T rotate <0,0,315>}
                object {T rotate <0,0,337.5>} }

                object {cylinder {<0,0,-.31><0,0,2.31>,2}texture {GoldWave}}

texture {Gold_Texture}
}

#declare WallTex =
texture{T_Grnt24 scale <1, 1, 2> scale 5.5 rotate <0, 0, 50> rotate <20, 0, 30>}
texture{T_Grnt23a scale <2, 1, 2> scale 5.5 rotate <40, 0, 0> rotate <11, 0, -30>}
texture{pigment{color Gray filter 0.86}}
texture { 
pigment {image_map {gif "rocks.gif" interpolate 2 filter 1,1}}
normal {bump_map {gif "rocks.gif" bump_size 2 interpolate 2}}
finish{phong 1 phong_size 60} 
scale 10.75
}

//Walls
#declare Walls =
union {
difference {
object {box {<-100,50,.15><100,-15,2>}}
//Windows
object {cylinder {<0,0,-1><0,0,4>,10}scale <1.4,1.4,1> translate <0,5,0>}
object {cylinder {<0,0,-1><0,0,4>,10}scale <.4,.4,1> translate <21,5,0>}
object {cylinder {<0,0,-1><0,0,4>,10}scale <.4,.4,1> translate <-21,5,0>}
texture {WallTex translate <0,-5,0>}}

object {box {<-100,50,.15><-110,-15,-80>}texture {WallTex rotate <0,90,0>}}
object {box {<100,50,.15><110,-15,-80>}texture {WallTex rotate <0,-90,0>}}
object {box {<-100,50,-80><100,-15,-90>}texture {WallTex}}
}

//Floor & Ceiling
#declare FloorCeiling =
union {
intersection {
object {plane {<0,1,0>,-15}}
object {plane {<0,0,1>,1}}}
intersection {
object {plane {<0,-1,0>,-50}}
object {plane {<0,0,1>,1}}}

texture {T_Grnt20 scale <1, 2, 2> rotate <0, 0, -30>}
texture {T_Crack4 scale <1, 2, 1.4> rotate <10, 0, -20>
finish {crand .03 reflection .1 ambient 0.28 diffuse 0.75 phong 1.0 phong_size 90}
scale 4}
}


#declare Metal_Fin =
finish {
metallic
ambient 0.2
diffuse 0.7
brilliance 6
reflection 0.22
phong 0.75
phong_size 90
}

#declare Silver_Tex =
texture {
pigment {colour Brass}
finish {Metal_Fin}
}


#declare Gold1 =
texture {
pigment {colour Brass}
normal {dents .4 scale .4}
finish {Metal_Fin}
}

#declare BladeTex =
texture {
pigment {colour SteelBlue filter .9}
finish{metallic ambient .2 diffuse .7
brilliance 6
reflection .25
refraction 1
ior 1.8
specular .75
roughness .02}
}

#declare TableTex =
texture {
Sapphire_Agate scale .8}

texture {pigment {radial 
colour_map {[0 .5 colour White colour White]
[.5 1.001 colour Clear colour Clear]}frequency 6}}

texture {pigment {onion
colour_map {[0 .27 colour White colour White]
[.27 .28 colour Black colour Black]
[.28 .82 colour Clear colour Clear]
[.82 1 colour Black colour Black]}}

finish {specular .6 
roughness .1
reflection .2
}
scale 1.2
}


#declare Handle =
union {
difference {
object {sphere {<0,0,0>,1}scale <.8,4,.5> translate <0,3.85,0>}
object {box {<-1.65,0,-.33><1.65,1,.33>}}
texture {
pigment {colour Brass}
normal {ripples 1 scale .1666}
finish {Metal_Fin}
}
}
object {sphere {<0,7,0>,.95}}
texture {Silver_Tex}
}


#declare BBit =
object {cylinder {<0,0,0><.5,0,0>,.5} scale <1,1,.66>translate <0,1,0>}


#declare Swirl =
union {
object {BBit scale <1,1,1> rotate <0,0,0>}
object {BBit scale <.975,.975,.99> rotate <0,0,-10>}
object {BBit scale <.95,.95,.98> rotate <0,0,-20>}
object {BBit scale <.925,.925,.97> rotate <0,0,-30>}
object {BBit scale <.9,.9,.96> rotate <0,0,-40>}
object {BBit scale <.875,.875,.95> rotate <0,0,-50>}
object {BBit scale <.85,.85,.94> rotate <0,0,-60>}
object {BBit scale <.825,.825,.93> rotate <0,0,-70>}
object {BBit scale <.8,.8,.92> rotate <0,0,-80>}
object {BBit scale <.775,.775,.91> rotate <0,0,-90>}
object {BBit scale <.75,.75,.9> rotate <0,0,-100>}
object {BBit scale <.725,.725,.89> rotate <0,0,-110>}
object {BBit scale <.7,.7,.88> rotate <0,0,-120>}
object {BBit scale <.675,.675,.87> rotate <0,0,-130>}
object {BBit scale <.65,65,.86> rotate <0,0,-140>}
object {BBit scale <.625,.625,.85> rotate <0,0,-150>}
object {BBit scale <.6,.6,.84> rotate <0,0,-160>}
object {BBit scale <.575,.575,.83> rotate <0,0,-170>}
object {BBit scale <.55,.55,.82> rotate <0,0,-180>}
object {BBit scale <.525,.525,.80> rotate <0,0,-190>}
object {BBit scale <.5,.5,.775> rotate <0,0,-200>}
object {BBit scale <.475,.475,.745> rotate <0,0,-210>}
object {BBit scale <.45,.45,.71> rotate <0,0,-220>}
object {BBit scale <.425,.425,.67> rotate <0,0,-230>}
object {BBit scale <.4,.4,.625> rotate <0,0,-240>}
object {BBit scale <.375,.375,.575> rotate <0,0,-250>}
object {BBit scale <.35,.35,.52> rotate <0,0,-260>}
object {BBit scale <.325,.325,.46> rotate <0,0,-270>}
object {BBit scale <.3,.3,.395> rotate <0,0,-280>}
object {BBit scale <.275,.275,.325> rotate <0,0,-290>}
object {BBit scale <.25,.25,.25> rotate <0,0,-300>}
object {BBit scale <.225,.225,.17> rotate <0,0,-310>}
object {BBit scale <.2,.2,.14> rotate <0,0,-320>}
object {BBit scale <.175,.175,.11> rotate <0,0,-330>}
object {BBit scale <.15,.15,.08> rotate <0,0,-340>}
object {BBit scale <.125,.125,.05> rotate <0,0,-350>}
object {BBit scale <.1,.1,.01> rotate <0,0,-360>}
translate <1.35,-.5,0>
texture {Silver_Tex}
}

#declare Bridge =
difference {
object {box {<-1.65,0,-.33><1.65,1,.33>}}
object {Dodecahedron scale <.5,.48,.5> translate <0,.5,0>}
texture {Silver_Tex}
}

#declare Gem =
union {
object {light_source {<0,.5,.33> colour rgb <0,5,0> fade_distance .32 fade_power 2}}
object {light_source {<0,.5,-.33> colour rgb <0,5,0> fade_distance .32 fade_power 2}}
object {Dodecahedron scale <.5,.48,.2> translate <0,.5,-.33> no_shadow}
object {Dodecahedron scale <.5,.48,.2> translate <0,.5,.33> no_shadow}

pigment {colour rgbf <.5,.8,.45,1>}
finish {
reflection .24
refraction 1
ior 2
specular .9
roughness .000001
}
}

#declare Blade =
merge {
difference {
object {box {<-.45,0,-.45><.45,-10,.45>}texture {BladeTex}rotate <0,45,0>scale <1.5,1,.3>}
        object {box {<0,0,-.5><-1,-10,.5>}rotate <0,0,1> translate <-.675,0,0>}
        object {box {<0,0,-.5><1,-10,.5>}rotate <0,0,-1> translate <.675,0,0>}
         scale <1.08,1,1>
}
object {Pyramid2 rotate <0,45,0> rotate <0,0,180> scale <.3,1,.3> translate <0,-11,0> 
texture {BladeTex}}
}

#declare Sword =
union {
object {Blade}
object {Bridge}
object {Handle}
object {Gem}
object {Swirl}
object {Swirl rotate <0,180,0>}
}

//Table

#declare TableTop =
union {
object {cylinder {<0,0,0><0,0.3,0>,1}
texture {TableTex }}

object {torus {1,.15} pigment {colour White}
finish {specular .6 roughness .1 ambient .2
reflection .2
}
translate <0,.15,0>}
}

//Leg of table

#declare Leg =
intersection {
object {Hyperboloid_Y}
object {cylinder {<0,-5,0><0,0,0>,5}}
texture {
pigment {colour White}
finish {specular .6 roughness .1 ambient .2
reflection .2
}}
}

#declare Table =
union {
object {Leg translate <0,-9.5,0>}
object {TableTop scale <8,3,8>translate <0,-10,0>}
}


object {Window scale <1.4,1.4,1> translate <0,5,0>}
object {Window scale <.4,.4,1> translate <21,5,0>}
object {Window scale <.4,.4,1> translate <-21,5,0>}
object {Table translate <0,15,0> scale <.52,.65,.52> translate <0,-16,-42>}
object {Sword scale .235 translate <0,-10.25,-42>}
object {Walls}
object {FloorCeiling}
sky_sphere {Sky1}


#declare Atmosphere1 = 
atmosphere {
type 4
colour rgbt <0,0,0,.33>
samples 30
distance 50
scattering .015 //.0133
aa_level 6
aa_threshold 0.1
jitter 0.1
}

atmosphere {Atmosphere1}

//Anti-fog?
//box {<-100,50,2><100,-15,-90> pigment {colour Clear} hollow no}


