//  "Summer Breeze"      Scene Definition File for POV 3.0
//  (c) Copyright 1996 Nathan Kopp

//  This file was _originally_ generated for POV-Ray V2.2 by
//  MORAY.EXE V2.0.wat(c) 1991-1995 Lutz + Kretzschmar

//  Some modifications have since been made to the objects.

//  Date : 08/31/1996    (31.08.1996)


global_settings{
  #max_trace_level 5
}

camera {  //  Camera StdCam
  location  <-14.300, -51.750, 29.250>
  direction <0.0,     0.0,  4.1500>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-3.188, 1.139, 3.455>
}

// *******  L I G H T S *******
light_source { // InteriorLight
  <15.000, -19.900, 28.450>
  color  rgb<0.749, 0.749, 0.749>
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
}

light_source {   // RedBuoyLight
  <75.400, 726.400, -253.000>
  color rgb <1.000, 0.000, 0.000>
  fade_distance 20
  fade_power 2
}

light_source {   // RedBuoyLight1
  <115.400, 721.400, -253.000>
  color rgb <0.000, 1.000, 0.000>
  fade_distance 20
  fade_power 2
}

light_source {   // SunWhitePart
  <-405.850, 688.350, 273.900>
  color rgb <0.220, 0.220, 0.220>
}

light_source {   // SunPart1
  <-400.400, 672.250, 282.000>
  color rgb <0.871, 0.599, 0.000>
}

light_source {   // SunPart2
  <-412.500, 688.300, 276.200>
  color rgb <0.902, 0.599, 0.000>
}

light_source {   // SunPart3
  <-390.850, 668.200, 274.000>
  color rgb <1.000, 0.714, 0.000>
}


// ********  TEXTURES  *******
//

#include "breeze.inc"



// ********  REFERENCED OBJECTS  *******

#declare FanFrontHole = object {
  box { // FanFrontHole
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.0, 0.2>
  }
}
#declare GrillRail1 = difference {
  cylinder { // GrillRailOut
    <0,0,1>, <0,0,0>, 1 
    texture {
      Chrome_Metal1
    }
    scale <4.5, 4.5, 0.05>
  }
  cylinder { // GrillRailIn
    <0,0,1>, <0,0,0>, 1 
    scale <4.3, 4.3, 0.07>
    translate  -0.01*z
  }
  texture {
    Chrome_Metal1
  }
}
#declare GrillRingPart = intersection {
  torus { // GrillRing1
    1.9, 0.05  rotate -x*90
    scale 0.5
    translate  <3.5, -0.1, 0.0>
  }
  box { // GrillRing2
    <-1, -1, -1>, <1, 1, 1>
    scale 0.75
    translate  <4.25, -0.9, 0.0>
  }
}
#declare GrillPart1 = union {
  object { GrillRingPart }
  cylinder { // GrillCyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.025, 0.025, 3.5>
    rotate <180.0, 90.0, 0.0>
    translate  <3.5, -1.05, 0.0>
  }
  rotate <90.0, 0.0, -180.0>
  translate  <0.0, -0.05, 0.1>
}
#declare Grill_Front = merge {
  object { GrillPart1 }
  object { // GrillPart2->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -9.0>
    translate  <0.007822, -0.000616, 0.0>
  }
  object { // GrillPart3->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -18.0>
    translate  <0.015451, -0.002447, 0.0>
  }
  object { // GrillPart4->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -27.0>
    translate  <0.0227, -0.00545, 0.0>
  }
  object { // GrillPart5->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -36.0>
    translate  <0.029389, -0.009549, 0.0>
  }
  object { // GrillPart6->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -45.0>
    translate  <0.035355, -0.014645, 0.0>
  }
  object { // GrillPart7->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -54.0>
    translate  <0.040451, -0.020611, 0.0>
  }
  object { // GrillPart8->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -63.0>
    translate  <0.04455, -0.0273, 0.0>
  }
  object { // GrillPart9->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -72.0>
    translate  <0.047553, -0.034549, 0.0>
  }
  object { // GrillPart10->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -81.0>
    translate  <0.049384, -0.042178, 0.0>
  }
  object { // GrillPart11->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -90.0>
    translate  <0.05, -0.05, 0.0>
  }
  object { // GrillPart12->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -99.0>
    translate  <0.049384, -0.057822, 0.0>
  }
  object { // GrillPart13->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -108.0>
    translate  <0.047553, -0.065451, 0.0>
  }
  object { // GrillPart14->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -117.0>
    translate  <0.04455, -0.0727, 0.0>
  }
  object { // GrillPart15->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -126.0>
    translate  <0.040451, -0.079389, 0.0>
  }
  object { // GrillPart16->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -135.0>
    translate  <0.035355, -0.085355, 0.0>
  }
  object { // GrillPart17->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -144.0>
    translate  <0.029389, -0.090451, 0.0>
  }
  object { // GrillPart18->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -153.0>
    translate  <0.0227, -0.09455, 0.0>
  }
  object { // GrillPart19->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -162.0>
    translate  <0.015451, -0.097553, 0.0>
  }
  object { // GrillPart20->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, -171.0>
    translate  <0.007822, -0.099384, 0.0>
  }
  object { // GrillPart21->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 180.0>
    translate  <0.0, -0.1, 0.0>
  }
  object { // GrillPart22->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 171.0>
    translate  <-0.007822, -0.099384, 0.0>
  }
  object { // GrillPart23->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 162.0>
    translate  <-0.015451, -0.097553, 0.0>
  }
  object { // GrillPart24->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 153.0>
    translate  <-0.0227, -0.09455, 0.0>
  }
  object { // GrillPart25->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 144.0>
    translate  <-0.029389, -0.090451, 0.0>
  }
  object { // GrillPart26->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 135.0>
    translate  <-0.035355, -0.085355, 0.0>
  }
  object { // GrillPart27->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 126.0>
    translate  <-0.040451, -0.079389, 0.0>
  }
  object { // GrillPart28->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 117.0>
    translate  <-0.04455, -0.0727, 0.0>
  }
  object { // GrillPart29->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 108.0>
    translate  <-0.047553, -0.065451, 0.0>
  }
  object { // GrillPart30->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 99.0>
    translate  <-0.049384, -0.057822, 0.0>
  }
  object { // GrillPart31->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 90.0>
    translate  <-0.05, -0.05, 0.0>
  }
  object { // GrillPart32->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 81.0>
    translate  <-0.049384, -0.042178, 0.0>
  }
  object { // GrillPart33->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 72.0>
    translate  <-0.047553, -0.034549, 0.0>
  }
  object { // GrillPart34->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 63.0>
    translate  <-0.04455, -0.0273, 0.0>
  }
  object { // GrillPart35->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 54.0>
    translate  <-0.040451, -0.020611, 0.0>
  }
  object { // GrillPart36->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 45.0>
    translate  <-0.035355, -0.014645, 0.0>
  }
  object { // GrillPart37->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 36.0>
    translate  <-0.029389, -0.009549, 0.0>
  }
  object { // GrillPart38->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 27.0>
    translate  <-0.0227, -0.00545, 0.0>
  }
  object { // GrillPart39->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 18.0>
    translate  <-0.015451, -0.002447, 0.0>
  }
  object { // GrillPart40->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 9.0>
    translate  <-0.007822, -0.000616, 0.0>
  }
  object { // GrillPart41->GrillPart1
    GrillPart1
    rotate <0.0, 0.0, 0.0>
    translate  0.0*x
  }
  texture {
    Chrome_Metal1
  }
}


#declare PaperBottom = union { // PaperBottom
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.000000, -1.978439, 0.477155>, <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, 
      <-3.000000, -1.000000, 0.214397>, <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, 
      <-3.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, 
      <-2.154322, 0.262205, 1.019499>, <-2.000000, 1.000000, 0.000000>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <2.000000, -2.000000, 0.000000>, <3.000000, -2.000000, 0.000000>, 
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.000000, -1.000000, 0.000000>, <3.000000, -1.000000, 0.000000>, 
      <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, <2.000000, 0.000000, 0.000000>, <3.000000, 0.000000, 0.000000>, 
      <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>, <2.000000, 1.000000, 0.000000>, <3.000000, 1.000000, 0.000000>
    }
  }
  texture {
    PaperTex
    scale <3.0, 6.0, 1.0>
    rotate 90.0*z
  translate <3.000000, -2.000000, 0.000000>
  }
  scale <1.75, 2.1, 2.1>
  rotate -40.0*z
  translate  <4.3, -4.15, -1.3>
}




// ********  OBJECTS  *******



superellipsoid { // Outlet
  <.1,.1>
  texture {
    OffWhitePlastic
  }
  scale <0.8, 0.25, 1.45>
  translate  <-12.25, 13.05, 5.3>
}


#declare WindowFrame = union {
  box { // WindowFrame1
    <-1, -1, -1>, <1, 1, 1>
    scale <7.6, 1.0, 0.6>
    translate  <-1.55, 13.5, 19.8>
  }
  box { // WindowFrame2
    <-1, -1, -1>, <1, 1, 1>
    scale <7.6, 1.0, 0.6>
    translate  <-1.55, 13.5, 3.8>
  }
  box { // WindowFrame3
    <-1, -1, -1>, <1, 1, 1>
    scale <8.6, 1.0, 0.6>
    rotate <0.0, -90.0, 0.0>
    translate  <-8.55, 13.5, 11.8>
  }
  box { // WindowFrame4
    <-1, -1, -1>, <1, 1, 1>
    scale <8.6, 1.0, 0.6>
    rotate <0.0, -90.0, 0.0>
    translate  <5.45, 13.5, 11.8>
  }
}
difference { // WindowTrim
  object { WindowFrame }
  cylinder { // TrimMinus1
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.8>
    rotate -90.0*y
    translate  <4.85, 12.5, 19.2>
  }
  cylinder { // TrimMinus2
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 12.8>
    rotate -90.0*y
    translate  <4.85, 12.5, 4.4>
  }
  cylinder { // TrimMinus3
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 14.8>
    rotate <180.0, 0.0, 180.0>
    translate  <4.85, 12.5, 19.2>
  }
  cylinder { // TrimMinus4
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 14.8>
    rotate <180.0, 0.0, 180.0>
    translate  <-7.95, 12.5, 19.2>
  }
  sphere { // TrimMinus5
    <0,0,0>,1
    scale 0.3
    translate  <-7.95, 12.5, 4.4>
  }
  sphere { // TrimMinus6
    <0,0,0>,1
    scale 0.3
    translate  <4.85, 12.5, 4.4>
  }
  sphere { // TrimMinus7
    <0,0,0>,1
    scale 0.3
    translate  <4.85, 12.5, 19.2>
  }
  sphere { // TrimMinus8
    <0,0,0>,1
    scale 0.3
    translate  <-7.95, 12.5, 19.2>
  }
  box { // WindowGroove
    <-1, -1, -1>, <1, 1, 1>
    scale <6.75, 0.5, 7.399>
    translate  <-1.55, 13.55, 11.8>
  }
  texture {
    Cork1
  }
}


union { // PowerCord
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.140805, 0.264822, -3.021531>, <-31.959269, -0.070174, -3.453445>, <-32.367088, -0.321673, -2.483156>, <-32.223101, -0.653986, -2.825730>, 
      <-0.117440, -1.093860, 6.316958>, <0.351073, -1.421301, 6.246214>, <-0.701438, -1.667128, 6.193102>, <-0.329833, -1.991946, 6.122925>, 
      <-0.117440, 1.555133, 12.719007>, <0.351073, 1.221844, 12.752783>, <-0.701438, 0.971627, 12.778140>, <-0.329833, 0.641007, 12.811645>, 
      <-0.117440, 0.234496, 19.159661>, <0.351073, -0.099414, 19.167720>, <-0.701438, -0.350097, 19.173770>, <-0.329833, -0.681332, 19.181764>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.223101, -0.653986, -2.825730>, <-32.079115, -0.986299, -3.168305>, <-31.868259, -0.599819, -3.669977>, <-32.029135, -0.249584, -3.287218>, 
      <-0.329833, -1.991946, 6.122925>, <0.041771, -2.316765, 6.052747>, <0.585954, -1.939001, 6.134364>, <0.170760, -1.596665, 6.208326>, 
      <-0.329833, 0.641007, 12.811645>, <0.041771, 0.310387, 12.845150>, <0.585954, 0.694898, 12.806184>, <0.170760, 1.043348, 12.770871>, 
      <-0.329833, -0.681332, 19.181764>, <0.041771, -1.012568, 19.189758>, <0.585954, -0.627341, 19.180461>, <0.170760, -0.278242, 19.172036>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-32.029135, -0.249584, -3.287218>, <-32.190011, 0.100650, -2.904459>, <-31.823512, 0.321673, -3.776440>, <-31.967498, 0.653986, -3.433865>, 
      <0.170760, -1.596665, 6.208326>, <-0.244433, -1.254330, 6.282288>, <0.701438, -1.038292, 6.328964>, <0.329833, -0.713473, 6.399142>, 
      <0.170760, 1.043348, 12.770871>, <-0.244433, 1.391797, 12.735559>, <0.701438, 1.611694, 12.713275>, <0.329833, 1.942313, 12.679770>, 
      <0.170760, -0.278242, 19.172036>, <-0.244433, 0.070856, 19.163611>, <0.701438, 0.291162, 19.158294>, <0.329833, 0.622397, 19.150300>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-31.967498, 0.653986, -3.433865>, <-32.111485, 0.986299, -3.091290>, <-32.322341, 0.599819, -2.589618>, <-32.140805, 0.264822, -3.021531>, 
      <0.329833, -0.713473, 6.399142>, <-0.041771, -0.388655, 6.469319>, <-0.585954, -0.766419, 6.387703>, <-0.117440, -1.093860, 6.316958>, 
      <0.329833, 1.942313, 12.679770>, <-0.041771, 2.272933, 12.646264>, <-0.585954, 1.888422, 12.685231>, <-0.117440, 1.555133, 12.719007>, 
      <0.329833, 0.622397, 19.150300>, <-0.041771, 0.953633, 19.142306>, <-0.585954, 0.568406, 19.151603>, <-0.117440, 0.234496, 19.159661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.117440, 0.234496, 19.159661>, <0.351073, -0.099414, 19.167720>, <-0.701438, -0.350097, 19.173770>, <-0.329833, -0.681332, 19.181764>, 
      <-0.117440, -1.086141, 25.600316>, <0.351073, -1.420672, 25.582658>, <-0.701438, -1.671821, 25.569401>, <-0.329833, -2.003672, 25.551884>, 
      <-0.117440, -6.930466, 31.269758>, <0.351073, -7.256915, 31.194568>, <-0.701438, -7.501997, 31.138120>, <-0.329833, -7.825831, 31.063533>, 
      <-0.127259, -4.722963, 38.142393>, <0.341312, -5.055128, 38.099563>, <-0.711154, -5.304502, 38.065532>, <-0.339492, -5.634007, 38.022921>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.329833, -0.681332, 19.181764>, <0.041771, -1.012568, 19.189758>, <0.585954, -0.627341, 19.180461>, <0.170760, -0.278242, 19.172036>, 
      <-0.329833, -2.003672, 25.551884>, <0.041771, -2.335523, 25.534367>, <0.585954, -1.949580, 25.554739>, <0.170760, -1.599833, 25.573201>, 
      <-0.329833, -7.825831, 31.063533>, <0.041771, -8.149666, 30.988945>, <0.585954, -7.773046, 31.075690>, <0.170760, -7.431748, 31.154300>, 
      <-0.339492, -5.634007, 38.022921>, <0.032169, -5.963512, 37.980310>, <0.576285, -5.580298, 38.031171>, <0.161031, -5.233023, 38.076049>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.170760, -0.278242, 19.172036>, <-0.244433, 0.070856, 19.163611>, <0.701438, 0.291162, 19.158294>, <0.329833, 0.622397, 19.150300>, 
      <0.170760, -1.599833, 25.573201>, <-0.244433, -1.250085, 25.591662>, <0.701438, -1.029370, 25.603313>, <0.329833, -0.697519, 25.620830>, 
      <0.170760, -7.431748, 31.154300>, <-0.244433, -7.090450, 31.232910>, <0.701438, -6.875066, 31.282518>, <0.329833, -6.551232, 31.357105>, 
      <0.161031, -5.233023, 38.076049>, <-0.254223, -4.885748, 38.120927>, <0.691608, -4.666592, 38.150862>, <0.319947, -4.337087, 38.193473>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.329833, 0.622397, 19.150300>, <-0.041771, 0.953633, 19.142306>, <-0.585954, 0.568406, 19.151603>, <-0.117440, 0.234496, 19.159661>, 
      <0.329833, -0.697519, 25.620830>, <-0.041771, -0.365668, 25.638347>, <-0.585954, -0.751610, 25.617975>, <-0.117440, -1.086141, 25.600316>, 
      <0.329833, -6.551232, 31.357105>, <-0.041771, -6.227397, 31.431693>, <-0.585954, -6.604017, 31.344948>, <-0.117440, -6.930466, 31.269758>, 
      <0.319947, -4.337087, 38.193473>, <-0.051715, -4.007582, 38.236084>, <-0.595830, -4.390797, 38.185223>, <-0.127259, -4.722963, 38.142393>
    }
  }
  texture {
    PowerCordTex
  }
  scale <0.2, 0.3, 0.27>
  rotate <0.0, 90.0, 0.0>
  translate  <-13.85, 6.85, -1.2>
}


cylinder { // Straw
  <0,0,1>, <0,0,0>, 1 open
  texture {
    StrawTex
  }
  scale <0.1, 0.1, 8.0>
  rotate <16.9, 0.0, 0.0>
  translate  <2.25, -3.5, -0.95>
}


object { // PaperTop->PaperBottom
  PaperBottom
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, -0.01, 0.01>
}


union { // PopStick
  box { // PopStickMiddle
    <-1, -1, -1>, <1, 1, 1>
    scale <0.15, 1.75, 0.05>
  }
  cylinder { // PopStickEnd1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    translate  <0.0, -1.75, -0.05>
  }
  cylinder { // PopStickEnd2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.1>
    translate  <0.0, 1.75, -0.05>
  }
  scale <1.3, 1.3, 1.0>
  rotate 10.0*z
  translate  <-3.55, -1.4, -1.25>
  texture {
    Yellow_Pine_Stain
    scale <1.0, 1.0, 3.0>
    rotate <-90.0, 0.0, 10.0>
  translate <-14.250000, -1.050000, 0.100000>
  }
}


#declare Wall_W_Window = difference {
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    scale <50.0, 0.5, 50.0>
    translate  <0.0, 13.55, 9.65>
  }
  box { // Window_Opening
    <-1, -1, -1>, <1, 1, 1>
    scale <7.25, 0.85, 8.25>
    translate  <-1.6, 13.55, 11.8>
  }
  texture {
    DMFWood4
  translate <-9.950000, 4.200000, 2.900000>
  }
}
union { // Room
  box { // Wall1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood4
    }
    scale <50.0, 0.5, 50.0>
    translate  <0.0, -85.700001, 11.2>
  }
  box { // Wall5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood4
    }
    scale <50.0, 0.5, 50.0>
    rotate <90.0, -90.0, 0.0>
    translate  <-49.250001, -36.450001, 10.8>
  }
  box { // Wall4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood4
    }
    scale <50.0, 0.5, 50.0>
    rotate <90.0, -90.0, 0.0>
    translate  <50.500001, -36.450001, 11.35>
  }
  box { // Wall3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood4
    }
    scale <50.0, 0.5, 50.0>
    rotate 90.0*x
    translate  <0.0, -36.450001, -38.700001>
  }
  box { // Wall2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DMFWood4
    }
    scale <50.0, 0.5, 50.0>
    rotate 90.0*x
    translate  <0.0, -36.450001, 59.800001>
  }
  object { Wall_W_Window }
}


#declare FanBase = difference {
  sphere { // FanBasePlus
    <0,0,0>,1
    scale <4.0, 4.0, 0.6>
    translate  <0.0, 5.4, -1.3>
  }
  box { // FanBaseMinus
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 4.2, 0.45>
    translate  <0.0, 5.4, -1.75>
  }
  torus { // FanStandTorus1
    1.75, 0.75  rotate -x*90
    scale <1.4, 1.4, 0.4>
    translate  <0.0, 5.55, -0.65>
  }
  scale 0.666667
  translate  -0.4*z
}
union { // FanStand
  cylinder { // Stand1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 4.5>
    translate  <0.0, 3.6, -1.25>
  }
  object { FanBase }
  texture {
    WrinklyBlackTex
  }
  scale 1.5
  translate  0.6*z
}


#declare BladeAssembly = union {
  cylinder { // BladeCenter1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver2
    }
    scale <0.6, 0.6, 0.7>
    rotate -90.0*x
    translate  <0.0, -0.45, 4.4>
  }
  sphere { // BladeCenter2
    <0,0,0>,1
    texture {
      Silver2
    }
    scale <0.6, 0.2, 0.6>
    translate  <0.0, -0.45, 4.4>
  }
  cylinder { // Axel
    <0,0,1>, <0,0,0>, 1 
    texture {
      Silver2
    }
    scale <0.1, 0.1, 2.85>
    rotate -90.0*x
    translate  <0.0, -0.05, 4.4>
  }
  cylinder { // Blade
    <0,0,1>, <0,0,0>, 1 
    texture {
      BladeSilverTex
    }
    no_shadow
    scale <3.95, 3.95, 0.05>
    rotate -90.0*x
    translate  <0.0, -0.15, 4.3>
  }
}
#declare Fan_Cyl_Cube = intersection {
  box { // Fan_Cube
    <-1, -1, -1>, <1, 1, 1>
    scale <1.75, 2.6, 0.95>
    translate  2.45*y
  }
  cylinder { // Fan_Cyl
    <0,0,1>, <0,0,0>, 1 
    scale <1.6, 1.15, 5.0>
    rotate -90.0*x
  }
}
#declare FanFrontHoles = union {
  object { FanFrontHole }
  object { // FanFrontHole1->FanFrontHole
    FanFrontHole
    translate  0.8*x
  }
  object { // FanFrontHole2->FanFrontHole
    FanFrontHole
    translate  1.6*x
  }
  object { // FanFrontHole3->FanFrontHole
    FanFrontHole
    translate  2.4*x
  }
  object { // FanFrontHole4->FanFrontHole
    FanFrontHole
    translate  3.2*x
  }
  scale 0.5
  translate  <-0.8, 0.35, -0.7>
}
#declare FanBody = difference {
  object { Fan_Cyl_Cube }
  box { // Fan_Back_Minus
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 2.15, 1.2>
    rotate -55.0*x
    translate  <0.0, 4.6, 0.6>
  }
  cylinder { // FrontCenter
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.4, 2.0>
    rotate -90.0*x
    translate  -0.1*y
  }
  box { // FanInside
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.8>
    translate  1.2*y
  }
  object { FanFrontHoles }
  texture {
    Impure_Plastic
  }
  translate  <0.0, 1.55, 4.35>
}
#declare Grill_Cap = difference {
  cylinder { // Grill_Cap2
    <0,0,1>, <0,0,0>, 1 
    scale <0.8, 0.8, 0.2>
    translate  1.3*z
  }
  cylinder { // Grill_Cap1
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.11>
    translate  1.4*z
  }
  texture {
    White_Plastic_Words
    scale 1.6
  translate <-0.800000, -0.800000, 1.600000>
  }
  translate  -0.35*z
}
#declare Fan_Grill = union {
  object { GrillRail1 }
  object { // GrillRail2->GrillRail1
    GrillRail1
    translate  -0.07*z
  }
  object { Grill_Cap }
  object { Grill_Front }
  object { // Grill_Back->Grill Front
    Grill_Front
    rotate <180.0, 0.0, 180.0>
  }
  rotate <90.0, 0.0, 0.0>
  translate  <0.0, -0.1, 4.35>
}
union { // FanMainPart
  object { BladeAssembly }
  object { FanBody }
  object { Fan_Grill }
  scale 1.5
  rotate -10.0*x
  translate  <0.0, 1.2, 1.2>
}


box { // CounterBack
  <-1, -1, -1>, <1, 1, 1>
  scale <53.600002, 2.0, 0.3>
  rotate -90.0*x
  translate  <0.25, 12.75, 0.1>
  texture {
    CounterBackTex
  }
}


sphere { // SkySphere
  <0,0,0>,1
  texture {
    EveningSkyTex
  }
  scale 900.0
  rotate -30.0*z
}


box { // Counter
  <-1, -1, -1>, <1, 1, 1>
  scale <53.600002, 12.5, 0.3>
  translate  <0.25, 0.0, -1.6>
  texture {
    CounterTopTex
  }
}


#declare Tube_A = intersection {
  torus { // Tube_A_Torus
    1.9175, 0.0925  rotate -x*90
    scale <0.86, 0.8, 0.75>
    translate  <-10.85, 3.35, 0.0>
  }
  box { // Tube_A_Cube
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 0.2>
    translate  <-9.8, 4.34, 0.0>
  }
  texture {
    DarkWhiteTex
  }
}
#declare SquirtGunOutsid = merge {
  cylinder { // Rail1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.0>
    rotate 90.0*x
    translate  <-9.2, 6.55, -0.6>
  }
  cylinder { // Rail
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 6.0>
    rotate 90.0*x
    translate  <-9.2, 6.55, 0.6>
  }
  cylinder { // Nozzle1
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.7>
    rotate 90.0*x
    translate  <-9.2, 0.85, 0.0>
  }
  superellipsoid { // GunBody
    <.1,.1>
    scale <3.0, 1.0, 0.6>
    rotate -90.0*z
    translate  <-9.7, 3.55, 0.0>
  }
  superellipsoid { // Handle
    <.1,.1>
    scale <2.25, 1.0, 0.4>
    rotate -25.0*z
    translate  <-12.05, 5.45, 0.0>
  }
  superellipsoid { // BumpyHandle1
    <.1,.1>
    texture {
      BumpyGreen
    }
    scale <1.55, 0.7, 0.02>
    rotate -25.0*z
    translate  <-12.5, 5.7, 0.41>
  }
  superellipsoid { // BumpyHandle2
    <.1,.1>
    texture {
      BumpyGreen
    }
    scale <1.55, 0.7, 0.02>
    rotate -25.0*z
    translate  <-12.5, 5.7, -0.41>
  }
}
#declare SquirtGun_Minus = difference {
  object { SquirtGunOutsid }
  superellipsoid { // GunBodyInside
    <.1,.1>
    no_shadow
    scale <2.75, 0.8, 0.4>
    rotate -90.0*z
    translate  <-9.7, 3.6, 0.0>
  }
  superellipsoid { // HandleInside
    <.1,.1>
    no_shadow
    scale <2.3, 0.8, 0.2>
    rotate -25.0*z
    translate  <-11.8, 5.3, 0.0>
  }
  texture {
    ClearGreenPlastic
  }
}
#declare Nozzle = difference {
  cylinder { // Nozzle2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.9>
    rotate 90.0*x
    translate  <-9.2, 1.0, 0.0>
  }
  cylinder { // Nozzle3
    <0,0,1>, <0,0,0>, 1 
    scale <0.02, 0.02, 0.95>
    rotate 90.0*x
    translate  <-9.2, 1.0, 0.0>
  }
  texture {
    Impure_Plastic
  }
}
union { // SquirtGun
  cone { // Plug
    <0,0,0>, 0.2, <0,0,1>, 0.5
    texture {
      DarkWhiteTex
    }
    scale 0.6
    rotate <-90.0, 0.0, -5.0>
    translate  <-9.35, 6.25, 0.0>
  }
  object { Tube_A }
  object { SquirtGun_Minus }
  cylinder { // Trigger1
    <0,0,1>, <0,0,0>, 1 
    texture {
      DarkWhiteTex
    }
    scale <0.1, 0.1, 1.3>
    rotate 90.0*x
    translate  <-11.3, 4.25, 0.0>
  }
  cylinder { // Pump1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Impure_Plastic
    }
    scale <0.2, 0.2, 1.0>
    rotate 90.0*x
    translate  <-11.3, 4.75, 0.0>
  }
  object { Nozzle }
  box { // Trigger2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DarkWhiteTex
    }
    scale <0.45, 0.08, 0.15>
    translate  <-11.3, 2.9, 0.0>
  }
  cylinder { // Pump2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Impure_Plastic
    }
    scale <0.2, 0.2, 1.0>
    rotate <90.0, 0.0, 90.0>
    translate  <-11.8, 4.85, 0.0>
  }
  cylinder { // Tube_C
    <0,0,1>, <0,0,0>, 1 open
    texture {
      DarkWhiteTex
    }
    scale <0.08, 0.08, 2.0>
    rotate <90.0, 0.0, -115.0>
    translate  <-11.75, 4.85, 0.0>
  }
  cylinder { // Tube_B
    <0,0,1>, <0,0,0>, 1 
    texture {
      DarkWhiteTex
    }
    scale <0.08, 0.08, 2.45>
    rotate 90.0*x
    translate  <-9.2, 3.35, 0.0>
  }
  scale 0.75
  rotate -3.0*y
  translate  <-0.7, -2.0, -0.4>
}


//
// Include file contains 'Glass'
//
#include "breeze.in1"
object {   // Glass
  Glass_Raw
  texture {
    GlassWithText
    scale <1.0, 1.0, 8.0>
    rotate -30.0*z
  translate <-0.100000, 0.000000, -1.150000>
  }
  bounded_by { // GlassBound
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <2.194078, 2.194078, 3.663528>
      rotate 70.0*z
      translate  2.759628*z
    }
  }
  scale 0.85
  rotate -85.0*z
  translate  <2.05, -3.75, -0.59>
}


blob {   // Spill
  threshold 0.6
  component 1.0, 0.945655, <-0.83613, 0.0, 0.053232>

  component 1.0, 0.615937, <0.212833, 0.0, 0.007605>

  component 1.0, 0.302179, <-0.348335, 0.227273, 0.022814>

  component 1.0, 0.302179, <-0.06058, -0.30303, 0.022814>

  component 1.0, 0.487082, <-0.6058, -0.5, 0.0>

  texture {
    RedSpillTex
  }
  scale <1.0, 1.0, 0.2>
  rotate 105.0*z
  translate  <-4.05, 0.9, -1.3>
}



sphere { // WaterSphere
  <0,0,0>,1
  scale <855.0, 855.0, 88.0>
  translate  <0.0, 4.5, -300.0>
  texture {
    EveningWaterTex
  }
}


union { // Buoys
  sphere { // RedBuoy
    <0,0,0>,1
    texture {
      RedBuoyTex
    }
    no_shadow
    scale 0.4
    translate  5.0*y
  }
  sphere { // GreenBuoy
    <0,0,0>,1
    texture {
      GreenBuoyTex
    }
    no_shadow
    scale 0.4
    translate  40.0*x
  }
  cylinder { // Buoy1
    <0,0,1>, <0,0,0>, 1 
    texture {
      PowerCordTex
    }
    scale <0.7, 0.7, 10.0>
    rotate 0.0*y
    translate  <0.05, 5.0, -11.150004>
  }
  cylinder { // Buoy2
    <0,0,1>, <0,0,0>, 1 
    texture {
      PowerCordTex
    }
    scale <0.7, 0.7, 10.0>
    rotate 0.0*y
    translate  <40.000001, 0.0, -11.15>
  }
  translate  <75.400001, 721.400011, -251.1>
}




object { PaperBottom }


//
// Include file contains 'StuffInGlass'
//
#include "breeze.in2"
object {   // StuffInGlass
  StuffInGlass_Raw
  texture {
    LemonadeTex
    scale <1.0, 1.0, 8.0>
    rotate -30.0*z
  translate <-0.100000, 0.000000, -1.150000>
  }
  bounded_by { // LemBound
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <1.366714, 1.366714, 1.670054>
      rotate 70.0*z
      translate  1.085248*z
    }
  }
  scale 0.85
  rotate -85.0*z
  translate  <2.05, -3.75, -0.59>
}


