
//poolstuff.inc is used by cgspool.pov scene
//created by Craig G. Smith 1996

// The following 4 images are from Corel Web Gallery
#declare CushionTex0 =
pigment {image_map {gif "cushion0.gif" } }
#declare CushionTex1 =
pigment {image_map {gif "cushion1.gif" } }
#declare CushionTex3 =
pigment {image_map {gif "cushion3.gif" } }
#declare GrassTex1 =
pigment {image_map {gif "grassl.gif" } }
#declare DMFDarkOak = texture
{
  pigment
  {
    wood
    turbulence 0.04  octaves 3
    color_map
    {
      [0.00 color rgb<0.600, 0.298, 0.176>]
      [0.10 color rgb<0.600, 0.298, 0.176>]
      [0.10 color rgb<0.600, 0.298, 0.176>]
      [0.10 color rgb<0.600, 0.298, 0.176>]
      [0.90 color rgb<0.298, 0.149, 0.086>]
      [0.90 color rgb<0.298, 0.149, 0.086>]
      [1.00 color rgb<0.298, 0.149, 0.086>]
    }
  }
}

// Glass textures contributed by Norm Bowler, of Richland WA
#declare NBglass =
texture {
    pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
    finish {
        ambient 0.1
        diffuse 0.1
        reflection .25
        refraction 1
        ior 1.5
        specular 1
        roughness .001
    }
}
#declare NBwinebottle=
texture {
    NBglass
    pigment { color rgbf <0.4, 0.72, 0.4, 0.6> }
}
#declare Glass3 = texture
{
  pigment
  {
    colour rgbf<0.976,0.976,0.976,0.898>
  }
  finish {
    diffuse 0.4  //.1
    specular 0.8    roughness 0.01
    phong 1.0    phong_size 400
    reflection 0.2  //.2
    refraction 1.0    ior 1.45
  }
}
#declare ChromeTex =
texture {
  //  pigment { color LightGray }
    pigment { color Gray55 }
    finish {
        ambient 0.3
        diffuse 0.7
        reflection 0.85  //.15
        brilliance 8
        specular 0.8
        roughness 0.1
    }
}

// Small puffs of white clouds.
#declare Blue_Sky3 = texture
{
  pigment
  {
    granite
    turbulence 0.1
    color_map
    {
      [0.00 color rgb<0.000, 0.000, 1.000>]
      [0.30 color rgb<0.000, 0.000, 1.000>]
      [0.30 color rgb<0.000, 0.000, 1.000>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
    scale <0.75, 0.75, 0.75>
  }
   // scale <6000, 1400, 4000>
 }
#declare SlateTex =
texture {
  pigment {
    marble
    turbulence 0.8 rotate 60*y
    color_map {
      [0.10 rgb 0.01]
      [0.12 rgb 0.70]
      [0.15 rgb 0.01]
      [0.20 rgb 0.01]
      [0.30 rgb <0.9,0.7,0.6>]
      [0.50 rgb 0.01]
    }
    scale 0.4
  }
  finish {reflection 0.2}
}
// Medium gray blue marble.
#declare Gray_Blue =
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgb<0.886, 0.882, 0.882>]
      [0.15 color rgb<0.741, 0.741, 0.753>]
      [0.31 color rgb<0.902, 0.902, 0.859>]
      [0.44 color rgb<0.725, 0.706, 0.690>]
      [0.62 color rgb<0.584, 0.588, 0.631>]
      [0.80 color rgb<0.608, 0.616, 0.659>]
      [1.00 color rgb<0.890, 0.882, 0.882>]
    }
  }
  finish {
    ambient 0.2
    crand 0.03
  }
  rotate <0.0, 0.0, 50.0>
  scale <2.0, 5.0, 2.0>
}
texture {
  pigment
  {
    granite
    turbulence 0.6
    color_map
    {
      [0.00 color rgbf<0.310, 0.380, 0.420, 0.627>]
      [0.12 color rgbf<0.322, 0.369, 0.416, 0.843>]
      [0.32 color rgbf<0.424, 0.369, 0.420, 0.545>]
      [0.45 color rgbf<0.373, 0.424, 0.518, 0.965>]
      [0.73 color rgbf<0.478, 0.573, 0.529, 0.737>]
      [1.00 color rgbf<0.310, 0.380, 0.420, 0.627>]
    }
  }
  finish {
    phong 1.0    phong_size 90
  }
  rotate <0.0, 0.0, -30.0>
  scale <1.0, 3.0, 2.0>
}




#declare ladder =
union
{

#declare _box1 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { ChromeTex }
 scale  < 8.25, 1.5, 4.25 >
 rotate  < 90, 0, 0 >
 translate  < 0, -0.125, 0 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.5, 8, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < 3.5, -6, 0 >
 }

#declare _torus0 =
torus { 3.5, 0.5
 texture { ChromeTex }
 rotate  < 90, 0, 0 >
 translate  < 0, 2, 0 >
 }


#declare _torus1 =
torus { 3.5, 0.5
 texture { ChromeTex }
 rotate  < 90, 0, 0 >
 translate  < 0, 2, -6 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.5, 8, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < 3.5, -6, -6 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.5, 4, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < -3.5, -2, -6 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.5, 4, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < -3.5, -2, 0 >
 }

#declare step =
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.5, 3, 0.5 >
 rotate  < 90, 0, 0 >
 translate  < 3.5, 2, -3 >
 }

object {step translate - 4*y}
object {step translate -7*y}
object {step translate -10*y}
object {step translate -13*y}


cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.5, 2.5, 0.5 >
 rotate  < 0, 0, 90 >
 translate  < 0.75, -6, 0 >
 }


cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.5, 2.5, 0.5 >
 rotate  < 0, 0, 90 >
 translate  < 0.75, -6, -6 >
 }


#declare _box2 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { ChromeTex }
 scale  < 8.25, 1.5, 4.25 >
 rotate  < 90, 0, 0 >
 translate  < 0, -0.125, -6 >
 }

difference {object { _torus0 } object { _box1 }}
difference {object { _torus1 } object { _box2 }}

} //ladder union

#declare Leg0 =
union
{

#declare _box1 =
// BOX _box1
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { ChromeTex }
 scale  < 13, 1.75, 6.5 >
 rotate  < 90, 0, 0 >
 translate  < 0, -1.25, 0 >
 }




// CYLINDER _cylinder0
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.75, 6.5, 0.75 >
 rotate  < 0, 90, 0 >
 translate  < 5.5, -4.5, 0 >
 }

#declare _torus0 =
// TORUS _torus0
torus { 5.5, 0.75
 texture { ChromeTex }
 rotate  < 90, 0, 0 >
 translate  < 0, 2, 0 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.75, 8, 0.75 >
 rotate  < 90, 90, 0 >
 translate  < -8, 7.5, 0 >
 }

#declare _box2 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 pigment { White }
 scale  < 6.75, 1.75, 6.75 >
 rotate  < 90, 0, 0 >
 translate  < -3.375, 5.25, 0 >
 }

#declare _box1_0 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { ChromeTex }
 scale  < 13, 1.75, 6.5 >
 rotate  < 90, 0, 0 >
 translate  < 0, -7.75, 0 >
 }
#declare _torus0_0 =
torus { 5.5, 0.75
 texture { ChromeTex }
 rotate  < 90, 0, 0 >
 translate  < 0, -11, 0 >
 }

#declare _box2_0 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { ChromeTex }
 scale  < 6.75, 1.75, 6.75 >
 rotate  < 90, 0, 0 >
 translate  < -3.25, -14.25, 0 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { ChromeTex }
 scale  < 0.75, 6, 0.75 >
 rotate  < 90, 90, 0 >
 translate  < -5.875, -16.5, 0 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 0.875
 texture { pigment { color Black } }
 rotate  < 0, 90, 90 >
 translate  < -15.25, 7.5, 0 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 0.875
 texture { pigment { color Black } }
 rotate  < 0, 90, 90 >
 translate  < -11, -16.5, 0 >
 }

difference {
  object { _torus0 }
  object { _box1 }
  object { _box2 }
}
difference {
  object { _torus0_0 }
  object { _box1_0 }
  object { _box2_0 }
}
} // Leg union

#declare Leg = object {Leg0 translate <-6,0,0> scale <0.5, 0.5, 0.5>}

#declare Table_Base=
union {
object {Leg}
object {Leg rotate <0,90,0>}
object {Leg rotate <0,180,0>}
object {Leg rotate <0,270,0>}
}

#declare Table1 =
union
{
object {Table_Base }

cylinder { < 0, -0.25, 0>, < 0, 0.5, 0>,13  //.375
 texture {  NBwinebottle}                    //Blue_Glass2
 translate  < 0., 4.375, 0 > }
difference
 {
 cylinder { < 0, -0.25, 0>, < 0, 0.5, 0>,13.05
 texture { SlateTex }
 translate  < 0., 4.375, 0 > }   //4.375

 cylinder { < 0, -0.251, 0>, < 0, 0.51, 0>,13
 texture { SlateTex }
 translate  < 0., 4.375, 0 > }
}

} //Table1

#declare Frame_Tex =  texture { pigment { color White } }
#declare CushionTex = texture { CushionTex1 }

#declare HalfCushion =

  intersection  {
    box { -1, 1 }  // square tile
    cylinder { -2*x, +2*x, 0.975 } // rounded edges along X axis
    cylinder { -2*z, +2*z, 0.975 } // rounded edges along Z axis
    sphere { 0, 1.1 } // rounded corners
    sphere { 0, 2.0 translate 2.6*y inverse }  // concave top surface
    scale <0.5,0.3,0.5>  // flatten the tile down on Y axis
      }

#declare CushionShape =
union
{
   object {HalfCushion texture {CushionTex} translate 0.05*y }
   object {HalfCushion texture {CushionTex}
          rotate <180,0,0> translate -.05*y }
}


#declare _torus0 =
torus { 1.5, 0.25
 texture { Frame_Tex}
 rotate  < 90, 0, 0 >
 translate  < 0, 1, 0 >
 }

#declare _box1 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 2, 0.75, 2.1 >
 rotate  < 90, 0, 0 >
 translate  < 1, 2, 0 >
 }

#declare _torus1 =
torus { 1.5, 0.25
 texture { Frame_Tex}
 rotate  < 90, 0, 0 >
 translate  < 5, 1, 0 >
 }

#declare _box3 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 2, 0.75, 2.1 >
 rotate  < 90, 0, 0 >
 translate  < 4, 2, 0 >
 }

#declare _box2 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 4, 0.75, 2 >
 rotate  < 90, 0, 0 >
 translate  < 5, 0, 0 >
 }

#declare _box0 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 4, 0.75, 2 >
 rotate  < 90, 0, 0 >
 }

#declare _torus3 =
torus { 1.5, 0.25
 texture { Frame_Tex}
 rotate  < 90, 90, 0 >
 translate  < 6.5, -2, 4 >
 }

#declare _box6 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 2.0, 0.75, 2.1 >
 rotate  < 90, 90, 0 >
 translate  < 6.5, -1, 3 >
 }

#declare _box7 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 4, 0.75, 2 >
 rotate  < 90, 90, 0 >
 translate  < 6.5, -3, 4 >
 }


#declare _torus4 =
torus { 1.5, 0.25
 texture { Frame_Tex}
 rotate  < 90, 90, 0 >
 translate  < -1.5, -2, 4 >
 }

#declare _box6_7 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 2.0, 0.75, 2.1 >
 rotate  < 90, 90, 0 >
 translate  < -1.5, -1, 3 >
 }

#declare _box7_7 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Frame_Tex}
 scale  < 4, 0.75, 2 >
 rotate  < 90, 90, 0 >
 translate  < -1.5, -3, 4 >
 }

#declare Chair1_Frame =
union
{
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 4.5, 0.25 >
 rotate  < 0, 90, 0 >
 translate  < -1.5, -3.5, 0 >
 }
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 4.5, 0.25 >
 rotate  < 0, 90, 0 >
 translate  < 6.5, -3.5, 0 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 2.5, 0.25 >
 rotate  < 0, 90, 90 >
 translate  < 2.5, 2.5, 0 >
 }
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 3, 0.25 >
 rotate  < 0, 90, 0 >
 translate  < 6.5, -5, 5.5 >
 }
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 3, 0.25 >
 rotate  < 0, 90, 0 >
 translate  < -1.5, -5, 5.5 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 2, 0.25 >
 rotate  < 90, 0, 90 >
 translate  < 6.5, -0.5, 2 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 2, 0.25 >
 rotate  < 90, 0, 90 >
 translate  < -1.5, -0.5, 2 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 2.75, 0.25 >
 rotate  < 90, 0, 90 >
 translate  < 6.5, -4, 2.75 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 2.75, 0.25 >
 rotate  < 90, 0, 90 >
 translate  < -1.5, -4, 2.75 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 4, 0.25 >
 rotate  < 0, 0, 90 >
 translate  < 2.5, -4, 5.5 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Frame_Tex}
 scale  < 0.25, 4, 0.25 >
 rotate  < 0, 0, 90 >
 translate  < 2.5, -4, 0 >
 }

difference {
  object { _torus1 }
  object { _box3 }
  object { _box2 }
}
difference {
  object { _torus0 }
  object { _box1 }
  object { _box0 }
}
difference {
  object { _torus3 }
  object { _box6 }
  object { _box7 }
}
difference {
  object { _torus4 }
  object { _box6_7 }
  object { _box7_7 }
}
} // union Chair1_Frame

#declare Chair1_0 =
union
{
object {Chair1_Frame}
object {CushionShape scale <8,2.5,5.5> translate <2.5,-3.375,3> }
object {CushionShape scale <7.5,2.5,7>
  rotate <90,0,0> translate <2.5,-0.5,0.4> }
}
#declare Chair1= object {Chair1_0 translate <-2.5,8,-2.75>}
#declare Chair2Tex = texture { DMFDarkOak }
#declare Cushion2Tex = texture { CushionTex3 }
#declare HalfCushion2 =
  intersection  {
    box { -1, 1 }  // square tile
    cylinder { -2*x, +2*x, 0.975 } // rounded edges along X axis
    cylinder { -2*z, +2*z, 0.975 } // rounded edges along Z axis
  //  sphere { 0, 1.1 } // rounded corners
    sphere { 0, 2.0 translate 2.6*y inverse }  // concave top surface
    scale <0.5,0.3,0.5>  // flatten the tile down on Y axis
      }
#declare CushionShape2 =
union
{
   object {HalfCushion2 texture {Cushion2Tex} translate 0.05*y }
   object {HalfCushion2 texture {Cushion2Tex}
          rotate <180,0,0> translate -.05*y }
}
#declare Chair2_Frame =
union
{

#declare _box11 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 2.5, 0.25, 0.0825 >
 rotate  < 0, 0, -60 >
 translate  < 2, -1.05, -0.0825 >
 }
#declare _box12 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 2.5, 0.25, 0.0825 >
 rotate  < 0, 0, -60 >
 translate  < 2, -1.05, -2.8775 >
 }
#declare _box13 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 0.5, 0.5, 0.125 >
 translate  < 2.55, -2.25, -0.0825 >
 }
#declare _box14 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 0.5, 0.5, 0.125 >
 translate  < 2.55, -2.25, -2.8775 >
 }
#declare _box15 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.75, 0.25, 0.0825 >
 rotate  < 0, 0, -60 >
 translate  < -0.875, -0.5, 0.0825 >
 }
#declare _box16 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.75, 0.25, 0.0825 >
 rotate  < 0, 0, 60 >
 translate  < -2.75, -0.5, 0.0825 >
 }
#declare _box18 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.75, 0.25, 0.0825 >
 rotate  < 0, 0, 60 >
 translate  < -2.75, -0.5, -3.0825 >
 }
#declare _box17 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.75, 0.25, 0.0825 >
 rotate  < 0, 0, -60 >
 translate  < -0.875, -0.5, -3.0825 >
 }
#declare _box20 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 0.5, 0.5, 0.125 >
 translate  < 0, -2.25, 0.0825 >
 }
#declare _box21 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 0.5, 0.5, 0.125 >
 translate  < 0, -2.25, -3.0825 >
 }
#declare _box22 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 0.5, 0.5, 0.125 >
 translate  < -3.65, -2.25, -3.0825 >
 }
#declare _box23 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 0.5, 0.5, 0.125 >
 translate  < -3.65, -2.25, 0.0825 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 5, 0.25, 0.0825 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 5, 0.25, 0.0825 >
 translate  < 0, 0, -3 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3, 0.25, 0.0825 >
 rotate  < 0, 90, 0 >
 translate  < 2.5, 0, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3, 0.25, 0.0825 >
 rotate  < 0, 90, 0 >
 translate  < -2.5, 0, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3, 0.25, 0.0825 >
 rotate  < 90, 90, 0 >
 translate  < -1, 0, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3, 0.25, 0.0825 >
 rotate  < 90, 90, 0 >
 translate  < 1, 0, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.5, 0.25, 0.0825 >
 rotate  < 0, 0, -45 >
 translate  < -3.675, 1.25, -0.0825 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.5, 0.25, 0.0825 >
 rotate  < 0, 0, -45 >
 translate  < -3.675, 1.25, -2.9175 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 2.67, 0.25, 0.0825 >
 rotate  < 0, 90, -45 >
 translate  < -4.875, 2.5, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 2.67, 0.25, 0.0825 >
 rotate  < 90, 90, -45 >
 translate  < -3.675, 1.25, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 2.67, 0.25, 0.0825 >
 rotate  < 90, 90, -60 >
 translate  < 2.125, -1.25, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.165, 0.25, 0.0825 >
 rotate  < 90, 90, -60 >
 translate  < -0.425, -1.25, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.165, 0.25, 0.0825 >
 rotate  < 90, 90, 60 >
 translate  < -3.2, -1.25, -1.5 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.5, 0.25, 0.0825 >
 rotate  < 90, 0, 0 >
 translate  < -2.25, 1.25, 0.25 >
 }
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Chair2Tex }
 scale  < 3.5, 0.25, 0.0825 >
 rotate  < 90, 0, 0 >
 translate  < -2.25, 1.25, -3.25 >
 }

difference { object { _box12 }  object { _box14 }}
difference {  object { _box11 } object { _box13 }}
difference {  object { _box15 } object { _box20 } }
difference {  object { _box16 }  object { _box23 }  }
difference { object { _box18 }  object { _box22 } }
difference {  object { _box17 }  object { _box21 } }
} //Chair2_Frame Union

#declare Chair2 = union
{
object {Chair2_Frame}
object {CushionShape2 scale <5,1,2.95> translate <0,0.2,-1.5> }
object {CushionShape2 scale <3.5,1,2.95>
  rotate <0,0,-45> translate <-3.625,1.25,-1.5> }
}

#declare Table2_FrameTex = texture {ChromeTex}
#declare Table2_Frame=
union
{
#declare _torus0 =
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 0, 0, 90 >
 translate  < 7.5, -0.5, -2 >
 }

#declare _box0 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < 7.5, 0.75, -3.375 >
 }

#declare _box1 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < 7.5, -1.6875, -3.375 >
 }

#declare _box2 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < 7.5, 0.75, -0.875 >
 }

#declare _torus3 =
// TORUS _torus3
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 90, 0, 0 >
 translate  < -11.5, 7.5, 0 >
 }

#declare _torus1 =
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 90, 0, 0 >
 translate  < 5.5, 7.5, 0 >
 }

#declare _box6 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < -12.75, 6.25,0 >
 }

#declare _box7 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.5, 1, 2.5 >
 rotate  < 90, 0, 0 >
 translate  < -10.25, 6.25, 0 >
 }

#declare _box8 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < -10.25, 8.75, 0 >
 }

#declare _box3 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.5, 1, 2.5 >
 rotate  < 90, 0, 0 >
 translate  < 4.25, 8.75, 0 >
 }

#declare _box4 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < 4.25, 6.25,0 >
 }

#declare _box5 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < 6.75, 6.25,0 >
 }

#declare _torus0_18 =
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 0, 0, 90 >
 translate  < 7.5, -0.5, -8 >
 }

#declare _box0_18 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < 7.5, 0.75, -6.75 >
 }

#declare _box1_18 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < 7.5, 0.75, -9.25 >
 }

#declare _box2_18 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < 7.5, -1.75, -6.75 >
 }

#declare _torus7 =
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 90, 0, 0 >
 translate  < -11.5, 7.5, -10 >
 }

#declare _torus6 =
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 90, 0, 0 >
 translate  < 5.5, 7.5, -10 >
 }

#declare _box6_19 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < -12.75, 6.25, -10 >
 }

#declare _box7_19 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < -10.25, 6.25, -10 >
 }

#declare _box8_19 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < -10.25, 8.75, -10 >
 }

#declare _box3_19 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < 4.25, 8.75, -10 >
 }

#declare _box4_19 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.5 >
 rotate  < 90, 0, 0 >
 translate  < 4.25, 6.25, -10 >
 }

#declare _box5_19 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.5, 1, 2.55 >
 rotate  < 90, 0, 0 >
 translate  < 6.75, 6.25, -10 >
 }

#declare _torus5 =
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 0, 0, 90 >
 translate  < -13.5, -0.50, -2.0 >
 }

#declare _box0_20 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < -13.5, 0.85, -3.375 >
 }

#declare _box1_20 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < -13.5, -1.59535, -3.375 >
 }

#declare _box2_20 =
box { < -0.5, -0.5, -0.5>,
 < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < -13.5, 0.833224, -0.82619 >
 }

#declare _torus2 =
torus { 2, 0.5
 texture { Table2_FrameTex }
 rotate  < 0, 0, 90 >
 translate  < -13.5, -0.5, -8 >
 }

#declare _box0_18_20 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < -13.5, 0.85, -6.75 >
 }

#declare _box1_18_20 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < -13.5, 0.85, -9.25 >
 }

#declare _box2_18_20 =
box { < -0.5, -0.5, -0.5>, < 0.5, 0.5, 0.5>
 texture { Table2_FrameTex }
 scale  < 2.55, 1, 2.55 >
 rotate  < 0, 0, 90 >
 translate  < -13.5, -1.66678, -6.75 >
 }


cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 3, 0.5 >
 rotate  < 90, 0, 0 >
 translate  < 7.5, -2.5, -5 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 8.55, 0.5 >
 rotate  < 90, 90, 0 >
 translate  < -3, 9.5, 0 >
 }
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 4.05, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < -13.5, 3.66667, 0 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 4, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < 7.5, 3.5, 0 >
 }
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 8.55, 0.5 >
 rotate  < 90, 90, 0 >
 translate  < -3, 9.5, -10 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 4.05, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < -13.5, 3.66667, -10 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 4, 0.5 >
 rotate  < 0, 90, 0 >
 translate  < 7.4861, 3.5, -10 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 3, 0.5 >
 rotate  < 90, 0, 0 >
 translate  < -13.5, -2.5, -5 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 10.5, 0.5 >
 rotate  < 90, 90, 0 >
 translate  < -2.75, -2.5, -2 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 10.5, 0.5 >
 rotate  < 90, 90, 0 >
 translate  < -2.75, -2.5, -8 >
 }

cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 5, 0.5 >
 rotate  < 90, 0, 0 >
 translate  < 6, 9.5, -5 >
 }
cylinder { < 0, -1, 0>, < 0, 1, 0>, 1
 texture { Table2_FrameTex }
 scale  < 0.5, 5, 0.5 >
 rotate  < 90, 0, 0 >
 translate  < -12, 9.5, -5 >
 }

difference {
  object { _torus0 }
  object { _box0 }
  object { _box1 }
  object { _box2 }
}
difference {
  object { _torus0_18 }
  object { _box0_18 }
  object { _box1_18 }
  object { _box2_18 }
}
difference {
  object { _torus3 }
  object { _box6 }
  object { _box7 }
  object { _box8 }
}
difference {
  object { _torus1 }
  object { _box3 }
  object { _box4 }
  object { _box5 }
}
difference {
  object { _torus7 }
  object { _box6_19 }
  object { _box7_19 }
  object { _box8_19 }
}
difference {
  object { _torus6 }
  object { _box3_19 }
  object { _box4_19 }
  object { _box5_19 }
}
difference {
  object { _torus2 }
  object { _box0_18_20 }
  object { _box1_18_20 }
  object { _box2_18_20 }
}
difference {
  object { _torus5 }
  object { _box0_20 }
  object { _box1_20 }
  object { _box2_20 }
}
 } //frame union

#declare Table2_Top_Edge =
   difference
   {
   object {box { < -13.025, -0.5, -7.025>, < 13.025, 0.5, 7.025>
          texture { SlateTex } } }
   object {box { < -13, -0.55, -7>, < 13, 0.55, 7>
          texture { SlateTex } } }

   }

#declare Table2_Top =
union
{
   box { < -13, -0.5, -7>, < 13, 0.5, 7>
      texture { Glass3 }
      translate  < -3, 10.5, -5 > }
   object {Table2_Top_Edge  translate <-3,10.5,-5>}
} //union Table2_Top

#declare Table2_0 =
union{
object {Table2_Frame}
object {Table2_Top}
}

#declare Table2 = object {Table2_0 translate <3,3,5> }

