// cgspool.pov  source file created by Craig G. Smith 1996

#version 3.0
global_settings { assumed_gamma 1.0 }
#include "colors.inc"

// ------------------------------------------------------------------
#declare Plants = 1  //1 to include plants in scene
#declare Hills = 1  //1 to use heightfield for grass plain

#declare ViewScene = 7  // select different camera positions
#switch (ViewScene)
  #case (2)      //  View for Final Result
  camera {
     location  <30, 20.0,42> // viewing scene2
     direction 2.0*z    // which way are we looking <X Y Z>
     up        y        // which way is +up <X Y Z>
     right     4/3*x    // which way is +right <X Y Z> and aspect ratio
     look_at   <-25, 6, -5>
          }
  #break
  #case (7)     // View for Final Result
  camera {
    location  <-35,18.0,-20> // viewing scene7
    direction 2.0*z  up y  right 4/3*x
    look_at   <-14, 7, 24>
         }
  #break
  #case (0)
  camera {
   location  <-5,150.0,50> // viewing scene0
   direction 2.0*z up y  right 4/3*x
   look_at   <-35, 15, -35>
   // look_at   <-5, 15, -25>
         }
  #break
  #case (1)
  camera {
   location  <-5, 70.0,50> // viewing scene1
   direction 2.0*z  up y right 4/3*x
   look_at   <-5, 5, -5>
          }
  #break
  #case (6)    // Birds eye view in +z direction
  camera {
   location  <-5,250.0,-20> // viewing scene6
   direction 2.0*z up y right 4/3*x
   look_at   <-5, 15, 80>
          }
  #break
  #else
  camera {
   location  <-21, 20.0, -4.5> // locating tiles
   direction 2.0*z up y right 4/3*x
   look_at   <-21.5,18, -6.0> // locating tiles
          }
  #end  // switch for camera
 // ------------------------------------------------------------------

#if (ViewScene < 6)  //< 6 for viewing in -z direction
light_source { 0*x color rgb 1 translate <-15, 50, 60> }
#else
light_source { 0*x color rgb 1 translate <10, 50, -60> }
#end

#declare Objects = 1 // non 1 allows placing objects above for testing
#if (Objects=1)
#include "pooltile.inc"
#include "poolstuf.inc"

#declare Pool_Water =
texture {
    pigment{ color rgbf <0.0, 0.0, 1.0, 0.9> }
    normal {
        ripples 0.40   //0.75
        frequency 3           //10;3
    }
    finish {
        reflection 0.20  //.3
        refraction 0.5
        ior 1.33
    }
    scale <7,7,7>  //5,1,5
}  // Pool_water

#declare grass1 =box { < -66.25, 0, 0>, < 66.25, 0.25,10>
                      texture { GrassTex1 rotate 90*y } }
#declare grass2 =box { < -75, 0, 0>, < 75, 0.25,10>
                      texture { GrassTex1 } }
#declare grass3 =box { < -66.25, 0, 0>, < 66.25, 0.25,25>
                      texture { GrassTex1 } }

#declare GrassPlane =
difference
{
#if (Hills = 1)
 object   {height_field {gif "hills1.ghf"
                         smooth
                         texture {GrassTex2}
                         scale <300,20,300>
                        }
            translate <-102,5,-100>
            bounded_by { box { <-200,0,-300>, <200,20,300>} }
          }
#else
 object {plane { <0, 1, 0>, 0
                 texture {GrassTex1}
                 translate <0,10,0> }
         bounded_by { box { <-200,9.5,-300>, <200,10.5,300>} }
        }
#end
 object { box {<-72.25,-30.0,-62.25>, <62.25,30.0,124.75> } }
} //GrassPlane


#declare wall1 = box {<-67.25,0,0>,<67.25,5,1> texture { Gray_Blue }}
#declare wall2 = box { < -90, 0, 0>, < 90,5,1> texture { Gray_Blue }}
#declare wall3 = box { < -25, 0, 0>, < 25,5,1> texture { Gray_Blue }}
#declare wall4 = box { < -33, 0, 0>, < 33,5,1> texture { Gray_Blue }}

#if (ViewScene < 6)
 #declare Sky1=
  object {plane { <0, 1, 0>, 0 texture { Blue_Sky3 //Blue_Sky3
                                         scale <150,120,150>  }
                  rotate < 45, 45, 0 > }
          clipped_by {plane {y, 40} } }
#else
#declare Sky1=
  object {plane { <0,1,0>,0 texture { Blue_Sky3 scale <170,140,170>}
                  rotate < 90, 0, 0 > }
          clipped_by {plane {y,40} } }
#end

#declare PoolWater=
object {plane { <0, 1, 0>, 0 texture { Pool_Water }}
bounded_by {box { <27.5,-.1,65>, <-27.5,.1,-27.5> } }
translate <-5,8,5>
}


object { Tile_Set0 scale 2.5 translate <-5,-0.7,5>}
object { Tile_Set0 scale 2.5 translate <-5,-0.7,42.5>}
object { Tile_Set4 scale 2.5 rotate <90,0,90> translate <-5,-9.125,-14.>}
object { Tile_Set4 scale 2.5 rotate <0,0,-90> translate <13.5, -9.125, 5>}
object { Tile_Set4 scale 2.5 rotate <0,0,90> translate <-23.5, -9.125, 5>}
object { Tile_Set10 scale 2.5 translate <32.5,9,-32.5>} //top
object { Tile_Set11 scale 2.5 translate <-42.5,9,-32.5>} //top
object { Tile_Set20 scale 2.5 translate <-5, 9, -32.5>} //top
object { Tile_Set21 scale 2.5 translate <32.5, 9, 5>}  //top
object { Tile_Set22 scale 2.5 translate <-42.5, 9, 5>}  //top
#declare Long = 1
#if (Long=1)
object { Tile_Set4 scale 2.5 rotate <0,0,-90> translate <13.5, -9.125, 42.5>}
object { Tile_Set4 scale 2.5 rotate <0,0,90> translate <-23.5, -9.125, 42.5>}
object { Tile_Set4 scale 2.5 rotate <90,0,-90> translate <-5,-9.125,60.875>}   //61.5
object { Tile_Set11 scale 2.5 translate <32.5,9,80>} //top
object { Tile_Set10 scale 2.5 translate <-42.5,9,80>} //top
object { Tile_Set23 scale 2.5 translate <-5, 9, 80>} //top
object { Tile_Set21 scale 2.5 translate <32.5, 9, 42.5>}  //top
object { Tile_Set22 scale 2.5 translate <-42.5, 9, 42.5>}  //top
#end //if Long

object {grass1  translate  < -5, 9.75, -61.25 >}
object {grass3  translate  < -5, 9.75, 98.75 >}
object {grass2  rotate <0,90,0> translate  < 51.25, 9.75, 23.75 >}
object {grass2  rotate <0,-90,0> translate  < -61.25, 9.75, 23.75 >}
object {wall1  translate  < -5, 10, -61.25 >}
object {wall2  rotate <0,90,0> translate  < 61.25, 10,28.75 >}
object {wall2  rotate <0,-90,0> translate  < -71.25, 10, 28.75 >}
object {wall3  translate  < 37, 10, 118.75 >}
object {wall4  translate  < -39, 10, 118.75 >}
object {GrassPlane }
object {PoolWater}

#if (ViewScene < 6)
object {Sky1 translate  < -172, 0, -165 > }
#else
object {Sky1 translate  < 55, 28, 200 > }
#end

object {ladder scale <0.4, 0.4, 0.4> translate <-24,10.5,15>}
object {Table1 scale <0.4, 0.3, 0.4> translate <-35,12.5,-3>}
object {Chair1 scale <0.5, 0.5, 0.5>
        rotate <0,25,0> translate <-34.5,10.0,-11>}  //r 15
object {Chair1 scale <0.5, 0.5, 0.5>
        rotate <0,90,0> translate <-45,10.0,-8>}
object {Chair1 scale <0.5, 0.5, 0.5>
        rotate <0,120,0> translate <-34.5,10.0,5>}
object {Chair2 scale <1.375, 1.375, 1.375>
        rotate <0,-90,0> translate <-18,12.5,-22>}
object {Table2 scale <0.25,0.25,0.25>
        rotate <0,90,0> translate <-21, 9.75, -22>}
object {Drink1 scale <0.2,0.2,0.2> translate <-33,15,-9.325> }
object {Drink1 scale <0.2,0.2,0.2>
               rotate <0,90,0> translate <-33,15,-6.0> }

object {Table1 scale <0.4, 0.3, 0.4> translate <26,12.5,56.25>}
object {Chair1 scale <0.5, 0.5, 0.5>
        rotate <0,-165,0> translate <26,10.0,64.25>}
object {Chair1 scale <0.5, 0.5, 0.5>
        rotate <0,-90,0> translate <36,10.0,63>}
object {Chair1 scale <0.5, 0.5, 0.5>
        rotate <0,-60,0> translate <26,10.0,48.25>}
object {Chair2 scale <1.375, 1.375, 1.375>
        rotate <0,90,0> translate <-18,12.5,70>}
object {Table2 scale <0.25,0.20,0.25>
        rotate <0,90,0> translate <-15, 9.75,70>}
object {Diving_Board scale <0.4,0.4,0.4>
        rotate <0,-90,0> translate <-5, 14,73>}

#if (Plants = 1)
#declare leaves = texture { pigment { ForestGreen}
                         finish { ambient 0.1 diffuse 0.7 phong 1 } }
#declare bark = texture {DMFDarkOak}
#include "tree1.inc"
object { tree1 scale <.004, .004, .004>
        translate <18,10,103> }
object { tree1 scale <.004, .004, .004>
         rotate <0,45,0> translate <30,10,103> }
object { tree1 scale <.004, .004, .004>
         rotate <0,90,0> translate <42,10,103> }
#end  //if Plants
#end  //if Object
