// pooltile.inc includes various tile sets used in the cgspool.pov sceme
// created by Craig G. Smith 1996


#version 3.0
#include "colors.inc"
// ------------------------------------------------------------------
#declare Red_Glass2 = texture
{
  pigment
  {
    colour rgbf<0.729,0.141,0.090,0.898>
  }
  finish {
    diffuse 0.3
    specular 0.6    roughness 0.01
    phong 1.0    phong_size 400
    reflection 0.3
    refraction 1.0    ior 1.45
  }
}
#declare PurpleTex = texture
{
  pigment
  {
    radial
    color_map
    {
      [0.00 color rgb<0.400, 0.000, 0.000>]
      [1.00 color rgb<1.000, 0.600, 0.988>]
    }
    frequency 16
  }
  normal
  {
    wrinkles 0.0
    turbulence 0.4
    frequency 5
    scale <.5, .5, .5>
  }
  finish {
    ambient 0.3
  }
}
// marble3.gif from Corel Web Gallery
#declare Marble2 = texture{
                      pigment {image_map {gif "marble3.gif" } }
                      scale <0.5,0.5,0.5>
                      }
#declare Gold_Viens =
texture {
  pigment
  {
    granite
    color_map
    {
      [0.00 color rgb<0.592, 0.737, 0.576>]
      [1.00 color rgb<1.000, 1.000, 1.000>]
    }
  }
}
texture {
  pigment
  {
    marble
    turbulence 0.85
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.71 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.81 color rgbf<0.710, 0.604, 0.345, 0.478>]
      [0.90 color rgb<0.949, 0.820, 0.467>]
      [1.00 color rgb<0.949, 0.820, 0.467>]
    }
  }
  finish {
    ambient 0.15
    diffuse 0.75
    phong 1.0    phong_size 90
    reflection 0.1
  }
  scale <0.25, 0.25, 0.25>
}


// ------------------------------------------------------------------
#declare TileShape =
  intersection  {
    box { -1, 1 }  // square tile
    cylinder { -2*x, +2*x, 0.975 } // rounded edges along X axis
    cylinder { -2*z, +2*z, 0.975 } // rounded edges along Z axis
    sphere { 0, 2.0 translate 2.6*y inverse }  // concave top surface
    scale <0.5,0.2,0.5>  // flatten the tile down on Y axis
    translate 0.2*y  // move it up so its bottom is on origin
  }

#declare Pool_Top = texture{Marble2}

// ------------------------------------------------------------------
#declare Max  = 14    // # of tiles across and down (16)
#declare XMax = Max/2
#declare ZMax = Max/2
#declare ZCount = -ZMax

#declare Max1  = 14    // # of tiles across and down (16)
#declare XMax1 = Max1/2
#declare ZMax1 = Max1/2
#declare ZCount1 = -ZMax1

#declare Tile_Set0 =
union {
    #while (ZCount <= ZMax)

      #declare XCount = -XMax
      #while (XCount <= XMax)


      #if (abs(XCount) = abs(ZCount))
            // An "X" pattern of tiles, diagonal through origin
            object {TileShape
            texture { Red_Glass2 }
            translate <XCount, 0, ZCount>
            }
      #else #if (XCount=0)
            object {TileShape
            texture { Red_Glass2}
            translate <XCount, 0, ZCount>
            }
      #else #if (ZCount=0)
            object {TileShape
            texture { Red_Glass2}
            translate <XCount, 0, ZCount>
            }
      #else
            object {TileShape
            texture { PurpleTex}
            translate <XCount, 0, ZCount>
            }
      #end
      #end
      #end

      #declare XCount = XCount+1
      #end  // Inner X loop

    #declare ZCount = ZCount+1
    #end  // Outer Z loop
}// TileSet0

#declare ZCount1 = -ZMax1
#declare Tile_Set4 =
union {
    #while (ZCount1 <= ZMax1)

      #declare XCount1 = -XMax1
      #while (XCount1 <= XMax1)

      object {TileShape
          texture { Gold_Viens }   // Blue Agate
          translate <XCount1, 0, ZCount1>
      }

      #declare XCount1 = XCount1+1
      #end  // Inner X loop

    #declare ZCount1 = ZCount1+1
    #end  // Outer Z loop
}


#declare ZCount1 = -ZMax1
#declare ZCount = -ZMax
#declare Tile_Set10 =
union {
    #while (ZCount <= ZMax)

      #declare XCount = -XMax
      #while (XCount <= XMax)


      #if (XCount = -ZCount)
            // An "X" pattern of tiles, diagonal through origin
            object {TileShape
            texture { Red_Glass2 }
            translate <XCount, 0, ZCount>
            }
      #else
            object {TileShape
            texture { Pool_Top}
            translate <XCount, 0, ZCount>
            }
      #end

      #declare XCount = XCount+1
      #end  // Inner X loop

    #declare ZCount = ZCount+1
    #end  // Outer Z loop
}

#declare ZCount1 = -ZMax1
#declare ZCount = -ZMax
#declare Tile_Set11 =
union {
    #while (ZCount <= ZMax)

      #declare XCount = -XMax
      #while (XCount <= XMax)


      #if (XCount = ZCount)
            // An "X" pattern of tiles, diagonal through origin
            object {TileShape
            texture { Red_Glass2 }
            translate <XCount, 0, ZCount>
            }
      #else
            object {TileShape
            texture { Pool_Top}
            translate <XCount, 0, ZCount>
            }
      #end

      #declare XCount = XCount+1
      #end  // Inner X loop

    #declare ZCount = ZCount+1
    #end  // Outer Z loop
}

#declare ZCount1 = -ZMax1
#declare Tile_Set20 =
union {
    #while (ZCount1 <= ZMax1)

      #declare XCount1 = -XMax1
      #while (XCount1 <= XMax1)

      #if (ZCount1 = ZMax1)
            object {TileShape
            texture { Red_Glass2 }
            translate <XCount1, 0, ZCount1>
            }
      #else #if (XCount1=0)
            object {TileShape
            texture { Red_Glass2}
            translate <XCount1, 0, ZCount1>
            }
      #else
            object {TileShape
            texture { Pool_Top}
            translate <XCount1, 0, ZCount1>
            }
      #end
      #end

      #declare XCount1 = XCount1+1
      #end  // Inner X loop

    #declare ZCount1 = ZCount1+1
    #end  // Outer Z loop
}

#declare ZCount1 = -ZMax1
#declare Tile_Set23 =
union {
    #while (ZCount1 <= ZMax1)

      #declare XCount1 = -XMax1
      #while (XCount1 <= XMax1)

      #if (ZCount1 = -ZMax1)
            object {TileShape
            texture { Red_Glass2 }
            translate <XCount1, 0, ZCount1>
            }
      #else #if (XCount1=0)
            object {TileShape
            texture { Red_Glass2}
            translate <XCount1, 0, ZCount1>
            }
      #else
            object {TileShape
            texture { Pool_Top}
            translate <XCount1, 0, ZCount1>
            }
      #end
      #end

      #declare XCount1 = XCount1+1
      #end  // Inner X loop

    #declare ZCount1 = ZCount1+1
    #end  // Outer Z loop
}



#declare ZCount1 = -ZMax1
#declare Tile_Set21 =
union {
    #while (ZCount1 <= ZMax1)

      #declare XCount1 = -XMax1
      #while (XCount1 <= XMax1)

      #if (XCount1 = -XMax1)
            object {TileShape
            texture { Red_Glass2 }
            translate <XCount1,0, ZCount1>
            }
      #else #if (ZCount1=0)
            object {TileShape
            texture { Red_Glass2}
            translate <XCount1, 0, ZCount1>
            }
      #else
            object {TileShape
            texture { Pool_Top}
            translate <XCount1, 0, ZCount1>
            }
      #end
      #end

      #declare XCount1 = XCount1+1
      #end  // Inner X loop

    #declare ZCount1 = ZCount1+1
    #end  // Outer Z loop
}

#declare ZCount1 = -ZMax1
#declare Tile_Set22 =
union {
    #while (ZCount1 <= ZMax1)

      #declare XCount1 = -XMax1
      #while (XCount1 <= XMax1)

      #if (XCount1 = XMax1)
            object {TileShape
            texture { Red_Glass2 }
            translate <XCount1,0, ZCount1>
            }
      #else #if (ZCount1=0)
            object {TileShape
            texture { Red_Glass2}
            translate <XCount1, 0, ZCount1>
            }
      #else
            object {TileShape
            texture { Pool_Top}
            translate <XCount1, 0, ZCount1>
            }
      #end
      #end

      #declare XCount1 = XCount1+1
      #end  // Inner X loop

    #declare ZCount1 = ZCount1+1
    #end  // Outer Z loop
}




















