// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth:
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

//LIGHTS AND CAMERA
camera {
       location  <-1, 4, -2>
       look_at   <1, 1, 2>
       }
light_source {
             0*x // light's position (translated below)
             color red 1.0  green 1.0  blue 1.0  // light's color
             translate <0, 200, -50>
             }




//TEXTURES
#declare d1 =
texture {
        pigment {
                color White
                }
         finish {
                ambient 0.4
                specular 0.3
                }
      }
#declare d2 =
texture {
        pigment {
                color Green
                }
         finish {
                ambient 0.4
                specular 0.3
                }
      }

#declare d3 =
texture {
        pigment {
                color Silver
                }
         finish {
                ambient 0.4
                specular 0.3
                }
      }

#declare d4 =
texture {
        pigment {
                color Black
                }
         finish {
                ambient 0.4
                specular 0.3
                }
      }

#declare cone_tan =
texture {
        pigment {
                spotted
                turbulence 0.8  octaves 7  omega 0.69
                color_map {
                               [0.00 color rgb<0.945, 0.925, 0.451>]
      [0.20 color rgb<0.682, 0.608, 0.392>]
      [0.39 color rgb<0.965, 0.925, 0.424>]
      [0.59 color rgb<0.682, 0.608, 0.392>]
      [1.00 color rgb<0.953, 0.886, 0.608>]
                          }
                phase 0.2
                }
         normal {
                bumps 0.2
                }
         finish {
                ambient 0.5
                brilliance 2.8
                specular 0.2    roughness 0.43
                phong 0.2
                }
}

#declare cream1 =
texture {
        pigment {
                gradient x
                turbulence 0.4
                color_map {
                          [0.00 color rgb<0.341, 0.212, 0.012>]
                          [0.45 color rgb<0.341, 0.212, 0.012>]
                          [0.55 color rgb<1.000, 1.000, 1.000>]
                          [1.00 color rgb<1.000, 1.000, 1.000>]
                          }
                scale 4
                }
        normal {
               bumps 0.6
               }
        finish {
               ambient 0.3
               phong 0.2
               }
}

#declare cream2 =
texture {
        pigment {
                gradient x
                turbulence 0.6
                color_map {
                          [0.00 color rgb<0.341, 0.212, 0.012>]
                          [0.45 color rgb<0.341, 0.212, 0.012>]
                          [0.55 color rgb<1.000, 1.000, 1.000>]
                          [1.00 color rgb<1.000, 1.000, 1.000>]
                          }
                scale 3
                }
        normal {
               bumps 0.6
               }
        finish {
               ambient 0.3
               phong 0.2
               }
}

#declare asphalt =
texture {
        pigment {
                granite
                turbulence 1.1  octaves 7
                color_map {
                          [0.00 color rgb<0.098, 0.098, 0.098>]
                          [0.35 color rgb<0.071, 0.071, 0.071>]
                          [0.35 color rgb<0.068, 0.068, 0.068>]
                          [0.54 color rgb<0.071, 0.071, 0.071>]
                          [0.54 color rgb<0.063, 0.039, 0.027>]
                          [1.00 color rgb<0.169, 0.173, 0.169>]
                          }
                scale <5.0, 5.0, 5.0>
                }
       normal {
              bumps 0.4
              }
       finish {
              ambient 0.5
              diffuse 1.0
              crand 0.25
              }
}



#declare sidewalk =
texture {
        pigment {
                colour rgb<1.000,1.000,1.000>
                }
         finish {
                ambient 0.4
                diffuse 0.7
                crand 0.06
                }
        }
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                          [0.00 color rgbf<0.729, 0.498, 0.447, 0.306>]
                          [0.15 color rgbf<0.769, 0.682, 0.588, 0.788>]
                          [0.40 color rgbf<0.839, 0.753, 0.718, 0.392>]
                          [0.56 color rgbf<0.776, 0.667, 0.561, 0.973>]
                          [0.73 color rgbf<0.737, 0.659, 0.573, 0.820>]
                          [1.00 color rgbf<0.725, 0.502, 0.451, 0.306>]
                          }
                }
        rotate <0.0, 0.0, -30.0>
        scale <2.0, 3.0, 2.0>
        }
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                          [0.00 color rgbf<0.808, 0.812, 0.812, 0.831>]
                          [0.22 color rgbf<0.741, 0.839, 0.831, 0.843>]
                          [0.24 color rgbf<0.404, 0.333, 0.333, 0.463>]
                          [0.62 color rgbf<0.584, 0.588, 0.631, 0.651>]
                          [0.76 color rgbf<0.914, 0.839, 0.722, 0.620>]
                          [0.78 color rgbf<0.153, 0.129, 0.208, 0.435>]
                          [0.81 color rgbf<0.812, 0.812, 0.812, 0.831>]
                          [1.00 color rgbf<0.812, 0.812, 0.812, 0.831>]
                          }
                }
         finish {
                ambient 0.2
                diffuse 0.5
                }
         rotate <0.0, 0.0, 40.0>
         scale <5.0, 3.0, 4.0>
}

#declare dirt =
texture {
        pigment {
                colour rgb<0.431,0.259,0.259>
                }
        }
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                          [0.00 color rgbf<0.537, 0.376, 0.341, 0.729>]
                          [0.15 color rgbf<0.584, 0.475, 0.329, 0.737>]
                          [0.40 color rgbf<0.675, 0.475, 0.404, 0.541>]
                          [0.56 color rgbf<0.757, 0.631, 0.522, 0.380>]
                          [0.73 color rgbf<0.659, 0.545, 0.439, 0.675>]
                          [1.00 color rgbf<0.541, 0.376, 0.341, 0.729>]
                          }
                }
         rotate <0.0, 0.0, 40.0>
         scale <1.0, 3.0, 2.0>
         }
texture {
        pigment {
                granite
                turbulence 0.6
                color_map {
                          [0.00 color rgbf<0.808, 0.812, 0.812, 0.831>]
                          [0.22 color rgbf<0.741, 0.839, 0.831, 0.843>]
                          [0.24 color rgbf<0.404, 0.333, 0.333, 0.463>]
                          [0.62 color rgbf<0.584, 0.588, 0.631, 0.651>]
                          [0.76 color rgbf<0.914, 0.839, 0.722, 0.620>]
                          [0.78 color rgbf<0.153, 0.129, 0.208, 0.435>]
                          [0.81 color rgbf<0.812, 0.812, 0.812, 0.831>]
                          [1.00 color rgbf<0.812, 0.812, 0.812, 0.831>]
                          }
                }
                rotate <0.0, 0.0, 60.0>
                scale <3.5, 5.0, 4.0>
}


//INFINITES



//OBJEX

//START OF CONE
#declare cream =
union {
torus {
      4.0, 0.9
      texture { cream1 }
      translate <0, 8, 0>
      }
torus {
      3.1, 0.8
      texture { cream1 }
      translate <0, 8.9, 0>
      }
torus {
      2.3, 0.6
      texture { cream1 }
      translate <0, 9.7, 0>
      }
torus {
      1.7, 0.4
      texture { cream1 }
      translate <0, 10.3, 0>
      }
torus {
      1.3, 0.2
      texture { cream1 }
      translate <0, 10.7, 0>
      }
}

#declare out_grid =
union {
cylinder {
         <0, 0, -3>, <0, 5, -4>, 0.2
         texture { cone_tan }
         }
cylinder {
         <0, 0, 3>, <0, 5, 4>, 0.2
         texture { cone_tan }
         }
cylinder {
         <-3, 0, 0>, <-4, 5, 0>, 0.2
         texture { cone_tan }
         }
cylinder {
         <3, 0, 0>, <4, 5, 0>, 0.2
         texture { cone_tan }
         }
cylinder {
         <-2.1375, 0, -2.1375>, <-2.85, 5, -2.85>, 0.2
         texture { cone_tan }
         }
cylinder {
         <2.1375, 0, -2.1375>, <2.85, 5, -2.85>, 0.2
         texture { cone_tan }
         }
cylinder {
         <-2.1375, 0, 2.1375>, <-2.85, 5, 2.85>, 0.2
         texture { cone_tan }
         }
cylinder {
         <2.1375, 0, 2.1375>, <2.85, 5, 2.85>, 0.2
         texture { cone_tan }
         }
torus {
      3.25, 0.2
      texture { cone_tan }
      translate <0, 1.25, 0>
      }
torus {
      3.75, 0.2
      texture { cone_tan }
      translate <0, 3.75, 0>
      }
}

#declare cone1 =
union {
cone {
     <0, 0, 0>, 3, <0, 5, 0>, 4
     texture { cone_tan }
     }
cone {
     <0, 5, 0>, 4, <0, 5.5, 0>, 4.6
     texture { cone_tan }
     }
cone {
     <0, 5.5, 0>, 4.5, <0, 8, 0>, 5
     texture { cone_tan }
     }
torus {
      4, 0.2
      texture { cone_tan }
      translate <0, 5, 0>
      }
torus {
      3, 0.2
      texture { cone_tan }
      translate <0, 0, 0>
      }
torus {
      4.5, 0.2
      texture { cone_tan }
      translate <0, 5.6, 0>
      }
torus {
      5, 0.3
      texture { cone_tan }
      translate <0, 8, 0>
      }
cylinder {
         <0, 5.6, -4.5>, <0, 8.1, -5>, 0.2
         texture { cone_tan }
         }
cylinder {
         <0, 5.6, 4.5>, <0, 8.1, 5>, 0.2
         texture { cone_tan }
         }
cylinder {
         <-4.5, 5.6, 0>, <-5, 8.1, 0>, 0.2
         texture { cone_tan }
         }
cylinder {
         <4.5, 5.6, 0>, <5, 8.1, 0>, 0.2
         texture { cone_tan }
         }
cylinder {
         <-3.20625, 5.6, -3.20625>, <-3.5625, 8.1, -3.5625>, 0.2
         texture { cone_tan }
         }
cylinder {
         <-3.20625, 5.6, 3.20625>, <-3.5625, 8.1, 3.5625>, 0.2
         texture { cone_tan }
         }
cylinder {
         <3.20625, 5.6, -3.20625>, <3.5625, 8.1, -3.5625>, 0.2
         texture { cone_tan }
         }
cylinder {
         <3.20625, 5.6, 3.20625>, <3.5625, 8.1, 3.5625>, 0.2
         texture { cone_tan }
         }
object {
       out_grid
       rotate <0, 30, 0>
       }
object {
       cream
       scale <0.9, 3, 0.9>
       translate <0, -16, 0>
       }
}
//END OF CONE

//START OF SPILL
#declare spill =
blob {
     threshold 0.6
     sphere { <0, 1, 0>, 1, 1 }
     sphere { <1, 0, 0>, 1, 1 }
     sphere { <-1, 0, 0>, 1, 1 }
     sphere { <0, 0, 0>, 1, 1 }
     cylinder { <0, 0, 0>, <1.5, 1.5, 0>, 0.5, 1 }
     sphere { <1.5, 1.5, 0>, 0.75, 1 }
     scale <7, 6, 0.5>
     texture { cream2 }
     }

#declare complete_cone =
union {
cone {
     <0, 0, 0>, 6, <0, 1, 0>, 5
     texture { cream1 }
     }
object {
       cone1
       scale <1, 1.35, 1>
       rotate <200, 0, 0>
       translate <0, 12, 3>
       }
object {
       spill
       rotate <90, 180, 0>
       translate <0, 0.1, -1.5>
       }
}

#declare street =
union {
//Sidewalk Base
box {
    <-5, 0, -5>, <5, 0.5, 40>
    texture { d4 }
    }
cylinder {
         <-4.75, 0.5, -5>, <-4.75, 0.5, 40>,0.25
         texture { dirt }
         }
cylinder {
         <4.75, 0.5, -5>, <4.75, 0.5, 40>, 0.25
         texture { dirt }
         }
//Sidewalk Squares
box {
    <-4.5, 0, -5>, <4.5, 0.75, 5>
    texture {
            sidewalk
            scale 0.1
            }
    }
cylinder {
         <-4.5, 0.5, 5.25>, <4.5, 0.5, 5.25>, 0.25
         texture { dirt }
         }
box {
    <-4.5, 0, 5.5>, <4.5, 0.75, 15.5>
    texture {
            sidewalk
            scale 0.1
            }
    }
cylinder {
         <-4.5, 0.5, 15.75>, <4.5, 0.5, 15.75>, 0.25
         texture { dirt }
         }
box {
    <-4.5, 0, 16>, <4.5, 0.75, 26>
    texture {
            sidewalk
            scale 0.1
            }
    }
box {
    <-4.5, 0, 26.5>, <4.5, 0.75, 36.5>
    texture { sidewalk }
    }
//GRASS
box {
    <-40, 0, -5>, <-5, 1, 40>
    texture { d2 }
    }
//CURB
box {
    <5, 0, -5>, <6, 0.75, 40>
    texture { sidewalk }
    }
cylinder {
         <6, 0.25, -5>, <6, 0.25, 40>, 0.5
         texture { sidewalk }
         }
box {
    <5.5, 0, -5>, <6.5, 0.25, 40>
    texture { sidewalk }
    }
//STREET
box {
    <6.5, -0.5, -5>, <40, 0, 40>
    texture { asphalt }
    }
}

object { street }
object {
       complete_cone
       scale 0.15
       translate <1, 0.75, 3>
       }
