
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "car-1.inc" - Build a little car.
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make some fenders.

        #declare Back_Fender = difference {
                        torus { 14, 2 scale <1,2.5,1> rotate z*90 }
                        box { < -7, -21, -21 > < 7, 0, 21 > }
                        pigment { DarkBrown }
                } // End of difference.

                #declare Front_Fender = difference {
                        torus { 14, 2 scale<1,2,1> rotate z*90 }
                        box { < -5, -21, -21 > < 5,  0, 21 > }
                        box { < -5, -21,   5 > < 5, 21, 21 > }
                        pigment { DarkBrown }
                } // End of difference.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Make some tires.

                #declare One_Tire = union {

                        torus { 10, 3 rotate z*90
                                pigment { Black } }

                        sphere { 0, 11 scale < 0.1, 1, 1 >
                                pigment { Silver } }

                } // End of union.


//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Put everything together.

        #declare One_Mysterious_Car = union {

                // Body (not at all realistic!).
                        superellipsoid{ <0.25, 0.25>
                        scale <18,6,54>
                        translate < 30, 12, 54+12 >
                        pigment{Tan} }


                // Headlights.
                cone { <18,21,9*12>,3<18,21,10*12>,4 pigment{Silver} }
                cone { <42,21,9*12>,3<42,21,10*12>,4 pigment{Silver} }
                sphere { <18,21,9*12>,3 pigment{Silver}}
                sphere { <42,21,9*12>,3 pigment{Silver}}

                // Taillights.
                cylinder { <10,16, 3><10,16,5>,2 pigment{Red} }
                cylinder { <50,16, 3><50,16,5>,2 pigment{Red} }
                cylinder { <10,16, 3.1><10,16,5>,2.2 pigment{Silver} }
                cylinder { <50,16, 3.1><50,16,5>,2.2 pigment{Silver} }

                // Windshield.
                box { < 14, 0, 0 > < 46, 10, 1 > pigment { Silver }
                        rotate x * -30 translate < 0, 18, 56 > }

                // Tires.
                object { One_Tire translate <  8, 13, 20   > }
                object { One_Tire translate < 52, 13, 20   > }
                object { One_Tire translate <  8, 13, 9*12 > }
                object { One_Tire translate < 52, 13, 9*12 > }

                // Fenders.
                object { Back_Fender  translate < 10, 13, 20 > }
                object { Back_Fender  translate < 50, 13, 20 > }
                object { Front_Fender translate <  8, 13, 9*12 > }
                object { Front_Fender translate < 52, 13, 9*12 > }

                // Back part of body.
                superellipsoid{ <0.25, 0.25>
                        scale <18,6,12>
                        translate < 30, 18, 24 >
                        pigment{Tan} }

                // Back bumper.
                box { < 10, 12, 6 > < 50, 18, 16 > pigment { Gray30 } }

                // License plate.
                box { < 0,0,0> < 1, 1, 1 >
                        pigment {
                                image_map { gif "license.gif"
                                        interpolate 2
                                } // end of image_map
                        } // end of pigment
                        scale < 20, 4, 1 >
                        translate < 20, 13, 5.9 >
                        } // End of box.

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

