
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// "flowers.inc" - build a flowerpot full of flowers.
//
// Created by: Paul T. Dawson
//             ptdawson@voicenet.com
//             http://www.voicenet.com/~ptdawson
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Build the very fancy flowerpot, with flowers. This was originally on
// the mailbox, but that was too far away from the camera. The flowers
// just turned into a little blur! So, I moved this flowerpot a lot closer
// to the camera. Oh, and I put a copy back on the mailbox, too!
//
//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// The flower base is at 0,0,0 and the nice part of the flower is
// over to the right.

        #declare Flower = union {

                // Red petals.
                #declare A = 0
                #while ( A < 360 )

                        sphere { 0, 3
                        pigment { color rgb < 1, rand(R)*0.5, rand(R)*0.5 > }
                        scale < 1, 0.1, 0.3 >
                        translate x * 3
                        rotate z * ( (rand(R)*120) - 60 )
                        translate y * 0.5
                        rotate x * A
                        } // End of sphere.


                #declare A = A + 5
                #end

                // Green leaves.
                #declare A = 0
                #while ( A < 360 )

                        sphere { 0, 1.5
                        pigment { Jade }
                        scale < 1, 0.1, 0.3 >
                        translate x * 1.5
                        rotate z * ( 70 + (rand(R)*10) )
                        translate y * 0.01
                        rotate x * A
                        } // End of sphere.


                #declare A = A + 36
                #end

                } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// Now build the flowerpot, some stalks, and add the flowers.

        #declare Fancy_Flowerpot = union {

                // The orange clay part.
                difference{
                union{
                cone { <0,0,0>,3 <0,12,0>,5 pigment{color rgb<0.7,0,0>} }
                cone { <0,10,0>,5.2 <0,12,0>,5.5 pigment{color rgb<0.7,0,0>} }
                } // End of union.
                cone { <0,1,0>,2 <0,13,0>,5.0 pigment{color rgb<0.7,0,0>} }
                } // End of difference.

                // The dirt (oops, I mean "soil").
                cylinder{<0,10.9,0><0,11,0>,5 pigment{Brown}
                normal{crackle 4 scale 0.2} }

                // Some random leaves at soil level.
                union {
                        #declare A = 0
                        #while ( A < 360 )
                                sphere { 0,4 scale < 0.1, 1, 0.3 >
                                        rotate z * ( rand(R)*-30 )
                                        translate x * ( (rand(R)*2)+1 )
                                        rotate y * A
                                        translate y * 11
                                        } // End of sphere.
                        #declare A = A + 30
                        #end
                        pigment{Jade scale 0.1 }
                } // End of union.

                // Start loop for stalks and flowers.
                #declare A = 0
                #while ( A < 360 )

                union {

                // The stalks.
                difference{
                        torus { 12,1 rotate x*90
                                scale < 0.2, 1, 0.5 >
                                translate y * -12 }

                        box { <0,5,5><-5,-12,-5> inverse }
                        pigment{Green}
                        }

                // Tilt the flower up a little.
                object { Flower rotate z * 40 }

                #declare HEIGHT = 22 - (A/90)

                translate < 4, HEIGHT, 0 >
                rotate y*A

                } // End of union.

                #declare A = A + 72
                #end

        } // End of union.

//------------------------------------------------------------------->
//------------------------------------------------------------------->
//
// End of this file.

