#declare Sky = sphere {
	0, 100
	scale <1, 0.15, 1>

	pigment {color rgb <0, 0.03, 0.032>}
	finish {ambient 1}

	hollow
}

#declare Moon = sphere {
	0, 0.5
	pigment {
		granite
		color_map {
			[0.0 0.3 color rgb 0.7 color rgb 0.7]
			[0.3 0.6 color rgb 0.7 color rgb 0.55]
			[0.6 1.0 color rgb 0.55 color rgb 0.55]
		}
		translate -x*1
	}
	finish {ambient 0.7}
	no_shadow

	scale 3
	translate <-12, 10, 40>
}

#declare Lake = plane {
	y, 0
	pigment {color rgb <0, 0.2, 0.24>}
	normal {bumps 0.05 scale <0.003, 1, 0.001>}
	finish {ambient 0.1 phong 1
		reflection 0.65
	}
}

#declare Mount = object {
	height_field {
		tga "mount.tga"
	}
	texture {
		pigment {
			gradient y
			turbulence 0.12
			color_map {
				[0 0.145 color rgb 0.4 color rgb 0.4]
				[0.145 0.18 color rgb 0.4 color rgb 1]
				[0.18 1 color rgb 1 color rgb 1]
			}
		}
		finish {ambient 0.2 phong 0.4 phong_size 90}
	}
	scale <140, 80, 110>
	translate <-64, -7.5, 30>
}
