#declare Leaf_txt1 = texture {
	pigment {
		gradient y
		color_map {
			[0.0 0.2 color rgb 1 color rgb <0, 0.7, 0.5>]
			[0.2 1.0 color rgb <0, 0.7, 0.5> color rgb <0, 0.7, 0.5>]
		}
	}
	finish {ambient 0.12 diffuse 0.75 phong 0.4}
}

#declare Leaf_txt2 = texture {
	pigment {color rgb <0, 0.65, 0.45>}
	normal {crackle	0.013 scale 0.0004}
	finish {ambient 0.12 diffuse 0.8 phong 0.4}
}

#declare Leaf1 = union {
	cylinder {
		<-0.5, 0, 0.5>, <0.5, 0, 0.5>, 0.5 rotate -y*10
		clipped_by {plane {-x, 0 rotate y*10 translate -x*0.1}}
		clipped_by {plane {x, 0}}
		clipped_by {plane {-y, 0}}
	}
	cylinder {
		<-0.5, 0, 0.5>, <0.5, 0, 0.5>, 0.5 rotate y*10
		clipped_by {plane {x, 0 rotate -y*10 translate x*0.1}}
		clipped_by {plane {-x, 0}}
		clipped_by {plane {-y, 0}}
	}
	texture {Leaf_txt1 scale <1, 0.6, 1>}

	scale <0.3, 2, 0.8>
	scale 0.02
}

#declare Leaf2 = union {
	cylinder {
		<-0.5, 0, 0.5>, <0.5, 0, 0.5>, 0.5 rotate -y*10
		clipped_by {plane {-x, 0 rotate y*6.5 translate -x*0.1}}
		clipped_by {plane {x, 0}}
		clipped_by {plane {-y, 0}}
	}
	cylinder {
		<-0.5, 0, 0.5>, <0.5, 0, 0.5>, 0.5 rotate y*10
		clipped_by {plane {x, 0 rotate -y*6.5 translate x*0.1}}
		clipped_by {plane {-x, 0}}
		clipped_by {plane {-y, 0}}
	}
	texture {Leaf_txt1 scale <1, 0.6, 1>}

	scale <0.3, 2, 0.5>
	scale 0.02
}

#declare Leaf3 = union {
	sphere {0, 0.5 scale <0.5, 1, 1> translate -y*0.5 rotate -z*15}
	sphere {0, 0.5 scale <0.5, 1, 1> translate -y*0.5 rotate z*15}

	translate y*1
	scale <1, 1, 0.01>
	rotate x*90
	scale 0.0045

	texture {Leaf_txt2}
}

#declare Petal = union {
	sphere {0, 0.5
		clipped_by {plane {-z, 0}}
		clipped_by {plane {x, 0 translate -x*0.1}}
		translate x*0.1
	}
	sphere {0, 0.5
		clipped_by {plane {-z, 0}}
		clipped_by {plane {-x, 0 translate x*0.1}}
		translate -x*0.1
	}
	translate y*0.5
	rotate -x*5
	scale <0.7, 1.5, 0.05>

	pigment {color rgb 1}
	finish {ambient 0.2 diffuse 0.8 phong 0.3}
}

#declare Flower = union {
	#declare Count = 0
	#while (Count < 8)
		object {Petal translate y*0.3 rotate z*45*Count}
		object {Petal rotate -x*45 translate <0, 0.1, -0> rotate z*(45*Count)+45/2}
		object {Petal scale <0.8, 0.8, 1> rotate y*10 rotate -x*60 translate <0, 0.15, 0.15> rotate z*45*Count}
		#declare Count = Count + 1
	#end
	rotate x*90
	translate y*0.1
	scale 0.001
}

#declare Front_plants = union {
	// left side
	object {Leaf1 rotate y*45 translate <-0.014, 0, -0.677>}
	object {Leaf1 rotate <-10, 40, 0> translate <-0.013, -0.01, -0.675>}
	object {Leaf1 scale <1, 1, 0.3> rotate y*30 translate <-0.015, 0, -0.674>}
	object {Leaf1 scale <1, 1.2, 1> rotate y*30 translate <-0.019, 0, -0.673>}
	object {Leaf1 scale <0.8, 1, 1> rotate <10, 25, 0> translate <-0.018, -0.004, -0.675>}
	object {Leaf2 rotate y*80 translate <-0.018, -0.002, -0.673>}

	object {Leaf1 rotate y*40 translate <-0.02, 0, -0.677>}
	object {Leaf1 rotate <0, 45, 0> translate <-0.019, -0.01, -0.675>}
	object {Leaf1 scale <1, 1, 0.3> rotate y*20 translate <-0.021, 0, -0.674>}
	object {Leaf1 scale <1, 1.2, 1> rotate y*40 translate <-0.025, 0, -0.673>}
	object {Leaf1 scale <0.8, 1, 1> rotate <10, 25, 0> translate <-0.024, -0.004, -0.675>}
	object {Leaf2 rotate y*30 translate <-0.024, -0.002, -0.673>}

	object {Leaf1 rotate y*45 translate <-0.026, 0, -0.677>}
	object {Leaf1 rotate <-10, 40, 0> translate <-0.025, -0.01, -0.675>}
	object {Leaf1 scale <1, 1, 0.3> rotate y*30 translate <-0.027, 0, -0.674>}
	object {Leaf1 scale <1, 1.2, 1> rotate y*30 translate <-0.031, 0, -0.673>}
	object {Leaf1 scale <0.8, 1, 1> rotate <10, 25, 0> translate <-0.030, -0.004, -0.675>}
	object {Leaf2 rotate y*80 translate <-0.030, -0.002, -0.673>}

	object {Leaf3 rotate y*90 translate <-0.014, 0, -0.679>}
	object {Leaf3 rotate y*70 translate <-0.012, 0, -0.676>}
	object {Leaf3 rotate y*80 translate <-0.015, 0, -0.671>}

	// right side
	object {Leaf2 rotate -y*60 translate <0.016, -0.007, -0.676>}
	object {Leaf2 scale <0.5, 1, 1> rotate -y*100 translate <0.017, -0.003, -0.677>}
	object {Leaf1 rotate -y*40 translate <0.014, -0.004, -0.677>}
	object {Leaf1 rotate -y*70 translate <0.014, -0.009, -0.678>}

	object {Leaf2 rotate -y*40 translate <0.02, -0.008, -0.676>}
	object {Leaf2 scale <0.5, 1, 1> rotate -y*60 translate <0.021, -0.004, -0.677>}
	object {Leaf1 rotate -y*30 translate <0.018, -0.006, -0.677>}
	object {Leaf1 rotate -y*50 translate <0.018, -0.005, -0.678>}

	object {Leaf2 rotate -y*60 translate <0.022, -0.007, -0.676>}
	object {Leaf2 scale <0.5, 1, 1> rotate -y*100 translate <0.023, -0.003, -0.677>}
	object {Leaf1 rotate -y*40 translate <0.024, -0.004, -0.677>}
	object {Leaf1 rotate -y*70 translate <0.024, -0.009, -0.678>}

	object {Leaf2 rotate -y*40 translate <0.025, -0.008, -0.676>}
	object {Leaf2 scale <0.5, 1, 1> rotate -y*60 translate <0.026, -0.004, -0.677>}
	object {Leaf1 rotate -y*30 translate <0.027, -0.006, -0.677>}
	object {Leaf1 rotate -y*50 translate <0.028, -0.005, -0.678>}

	object {Leaf3 rotate -y*80 translate <0.014, 0, -0.68>}
	object {Leaf3 scale 1.1	rotate -y*60 translate <0.011 0, -0.675>}

	object {Flower translate <0.01, 0, -0.674>}

	object {Leaf3 rotate -y*80 translate <0.009, 0, -0.679>}
	object {Leaf3 rotate -y*30 translate <0.015, 0, -0.674>}
}

#declare Leaves = union {
	polygon {
		36,
		<-0.05, 0.05>, <0, 0.12>, <0.04, 0.01>, <0.06, 0.01>, <0.07, 0.3>,
		<0.08, 0.01>, <0.12, 0.01>, <0.13, 0.2>, <0.14, 0.01>, <0.16, 0.01>,
		<0.2, 0.25>, <0.18, 0.01>, <0.21, 0.01>, <0.22, 0.1>, <0.23, 0.1>,
		<0.27, 0.03>, <0.23, 0.08>, <0.23, 0.01>, <0.3, 0.01>, <0.25, 0.31>,
		<0.32, 0.01>, <0.34, 0.01>, <0.35, 0.25>, <0.36, 0.01>, <0.38, 0.01>,
		<0.39, 0.16>, <0.398, 0.01>, <0.43, 0.01>, <0.42, 0.28>, <0.45, 0.01>,
		<0.47, 0.01>, <0.48, 0.2>, <0.5, 0>, <0.02, 0>, <0, 0.1>, <-0.05, 0.05>

		texture {Leaf_txt1 scale <1, 0.31, 1>}

		translate -y*0.011
		scale <0.5, 1, 1>
	}
	object {Leaf1 scale 10 rotate -y*120 translate <0.1, 0, -0.05>}
	object {Leaf1 scale 11 rotate -y*190 translate <0.17, 0, 0.05>}
	object {Leaf2 scale 9 rotate -y*130 translate <0.07, -0.05, 0.05>}
	object {Leaf2 scale 9 rotate -y*110 translate <0.21, 0, 0.05>}
}

#declare Section = union {
	union {
		object {Leaves}
		object {Leaves scale 0.9 translate <-0.1, 0, 0.2>}
		object {Leaves rotate y*180 translate <0.4, 0, 0.4>}
	}
	union {
		object {Leaves}
		object {Leaves scale 0.9 translate <-0.1, 0, 0.2>}
		object {Leaves rotate y*180 translate <0.4, 0, 0.4>}
		translate <0.3, 0, 0.6>
	}
}

#declare Back_plants = union {
	#declare Count = 0
	#while (Count < 5)
		object {Section translate x*0.48*Count}
		object {Section translate <0.52*Count, 0, 0.9>}
		#declare Count = Count + 1
	#end
}


