#include "metals.inc"


#declare JBrad =0.12
#declare JDia =0.075

#declare Jack=
union {
superellipsoid { < 1, 0.8> scale <JDia,JDia,1>
                           rotate <90,0,0> }
superellipsoid { < 1, 0.8> scale <JDia,JDia,1>
                           rotate <0,90,0> }
superellipsoid { < 1, 0.8> scale <JDia,JDia,1> }

sphere { <0, 1-JBrad, 0> JBrad }
sphere { <0, -1+JBrad, 0> JBrad }

translate <0,1+JBrad/3,0>
rotate <0,0,49>
rotate <37,0,0>// 38.75,0,0>
texture {
pigment { color rgb <0.5,0,0.5>}
finish { F_MetalA }
 }
 scale 0.09
}

#declare Ballt = texture {
           pigment { bozo
          color_map {
		[0 color rgb <1,0.17,0>]
		[1 color rgb <1,0,0>] }scale 0.7}
      finish {specular .15 roughness 0.15} // .2 .1
	}

#declare RibSize =0.05
#declare JackBall =
union{
sphere { 0,1 }
torus { 1, RibSize scale <1,0.5,1> }

texture{ crackle
         texture_map {
        [0 pigment {color rgb <0.40,0.05,0>}]
		[0.1 Ballt] } scale 0.30}

rotate <30,90,50>
translate<0,1,0>
scale 0.11
}



object { Jack
pigment { color rgb <0.5,0,0.5>}
rotate <0,10,0>
translate <-1.4,0.154,0.47> }


object { Jack
pigment { color rgb <0.0,0.5,0.5>}
rotate <0,30,0>
translate <-1.56,0.154,0.25> }


object { Jack
pigment { color rgb <0.5,0.5,0.0>}
rotate <0,80,0>
translate <-1.2,0.154,0.3> }


object { Jack
pigment { color rgb <0.0,0,0.5>}
rotate <0,-10,0>
translate <-1.15,0.154,0.45> }


object { Jack
pigment { color rgb <0.0,0.5,0.0>}
rotate <0,190,0>
translate <-1.1,0.154,0.3> }

object { Jack
pigment { color rgb <0.5,0.0,0.0>}
rotate <0,150,0>
translate <-1.55,0.154,0.25> }


object { JackBall
translate <-1.4,0.154,0.85>}




//one more in the grass
object { Jack
pigment { color rgb <0.5,0,0.5>}
rotate <0,10,0>
translate <-0.3,-0.16,1.4> }


//one more in the grass
object { Jack
pigment { color rgb <0.5,0.0,0.0>}
rotate <0,10,0>
translate <-0.7,-0.17,1.6> }


//one more in the grass
object { Jack
pigment { color rgb <0.0,0,0.5>}
rotate <0,10,0>
translate <-0.1,-0.22,1.6> } //down 0.02



