// sidewalk slab

#include "colors.inc"
#include "letters.inc"

//make this 0 for quick grey sidewalk, 1 for cracks, rocks, ...
#declare Detail = 1



#declare SSize =1.2

//Single hunk of sidewalk
#declare Slab =
union {
box {   <-0.42, -0.1, -0.42>
        < 0.42,  0.1,  0.42> }
/*box {
  <-0.5, 0.07, -0.5>
  < 0.5,  -0.1,  0.5> } */
  superellipsoid { <0.015, 0.015> scale <0.5, 0.07, 0.5> }
superellipsoid { <0.15, 0.15> scale <0.49,0.097,0.49>}
scale <SSize,1,SSize>
}

//slab with letters
#declare Slab2 =
difference {
union {
object { Slab }
object { OutLetters rotate <90,0,0> scale <0.015,0.03,0.015>
        translate <-0.47,0.1-0.022,-0.47> }   //020
}

object { InLetters rotate <90,0,0> scale <0.015,0.03,0.015>
         translate <-0.47,0.1-0.022,-0.47> }

}



#declare SWColorA1 = pigment {
                      bumps scale 0.01 translate 1
                      pigment_map { [0 color rgb 0.6]
                                    [1 color rgb 0.25] }
		            }

#declare SWColorA2 = pigment {
                      bumps scale 0.01 translate 1
                      pigment_map { [0 color rgb 0.99]
                                    [1 color rgb 0.50] }
		            }
#declare SWColorA1A = pigment {
                      bumps scale 0.01 translate 1
                      pigment_map { [0 color rgb 0.3]
                                    [1 color rgb 0.0] }
		            }

#declare SWColorA2A = pigment {
                      bumps scale 0.01 translate 1
                      pigment_map { [0 color rgb 0.5]
                                    [1 color rgb 0.10] }
		            }

#declare SWColorA = pigment {
                      bozo  scale 100 translate 1
                      pigment_map { [0 SWColorA1]
                                    [1 SWColorA2] }
		            }

#declare SWColorB = pigment {
                      agate scale 10
                      pigment_map { [0 color rgb <0.5,0.25,0>]
                                    [0.2 color rgb <0.5,0,0>]
                                    [0.4 color rgb <0.7,0.64,0.48>]
                                    [0.6 color rgb <0.78,0.56,0.16>]
                                    [0.7 color rgb 1]
                                    [0.8 color rgb 0]
                                    [1 color rgb <0.4,0.4,0.51>]
                                     }
		            }

#declare SWColor = pigment {
                      bumps scale 0.0025
                      pigment_map { [0.8 SWColorA]
                                    [1.0 SWColorB] }
		            }


#declare SWColor2 = pigment {
                      bozo
                      scale 0.3
                      pigment_map { [0 SWColorA2A]
                                    [1 SWColorA1A] }
		            }

#declare SP1=
   pigment { agate
      pigment_map {
         [0.50 SWColor ]
         [0.50 SWColor2] //cracks
         [0.51 SWColor2]
         [0.51 SWColor ]
           }
         scale 3/2   //*SSize
         rotate <0,30,0>
         translate <0,0.8,0>
           }

#declare SP2=
   pigment { agate
      pigment_map {
         [0.50 SWColor ]
         [0.50 SWColor2] //cracks
         [0.51 SWColor2]
         [0.51 SWColor ]
           }
         scale 3/2   //*SSize
         rotate <0,40,0>
         translate <0,0.9,-0.30>
           }



//sidewalk corner
union {
object {Slab2}
object {Slab translate <0,0,1*SSize>  //}
clipped_by {  height_field {
    tga "bacon.tga"
    scale 0.2 scale <1,-0.05,1> rotate -y*45 rotate x*-45 rotate -y*45
          translate <0.6,-0.05,0.51> inverse}
  }}
object {Slab translate <0,0,2*SSize>}
object {Slab translate <-1*SSize,0,0>
clipped_by {box {-.2,.2 rotate y*45 rotate -z*60 scale <1,1,0.5> translate <-0.35,-0.05,0.25>
inverse
//pigment {color Green}
}}}
//object {Slab translate <-2*SSize,0,0>}
 #if (Detail)
pigment { gradient x scale 2*SSize triangle_wave
  pigment_map {
  [0.495  gradient z  triangle_wave
     pigment_map {
        [0.45  SP1]
        [0.55  SP2 ]} ]
  [0.505  SP2 ]}

}
#else
  pigment{ color Grey }
#end

rotate 30*y
scale 1.5
translate -0.3*z
}

#declare XSlab = object {
box {
  <-0.505, 5, -0.5>
  < 0.5,  -2,  0.505> }
scale <SSize,1,SSize>
}

#declare XSidewalk =
union{
union {
object {XSlab}
object {XSlab translate <0,0,1*SSize>}
object {XSlab translate <0,0,2*SSize>}
object {XSlab translate <-1*SSize,0,0>}
object {XSlab translate <-2*SSize,0,0>}

rotate 30*y
scale 1.5
translate -0.3*z
}
union{
sphere { 0.0, 1*0.825 }
cylinder { 0, 8*y,  1*0.825 }
scale 0.054
translate <1.3,0.0,-0.5>
}
}
