// Summer Night at the Ocean.
// Rendered in POV-Ray beta 3.0 for Windows.
//
// by Mike Norton manorton@tcnet.net  (C) 1996
//
// The scene was set up by hand.  The model of the light house was modeled using
// PoVSB modeler for Windows.  The hight field was created by Terrain Maker Version 1.1
// by Eric Jorgensen & the submarine model is from the 3DCafe site on the web.


global_settings { assumed_gamma 2.2  ambient_light 1 }
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "stones.inc"
#include "skies.inc"
#include "glass.inc"
#include "lh.inc"
#include "sub.inc"

// Rock texture for hieghtfileds.
#declare rock =
	texture{pigment{color Black}}
	texture{T_Grnt15  scale <1.2, 3, 1.5> rotate <70, 0, 30>
       		finish {crand 0.03}
	}
	texture{T_Grnt2 scale <3, 3, 4> rotate <0, 0, 40>}
	texture{T_Grnt1 scale <1, 2, 1.4> rotate <10, 0, -20>
      		finish {specular .1 roughness .01 diffuse 1}
	}

// Light Source
light_source { <500, 500, -500> rgb <.5,.5,.5> }
light_source { <-20, 15, -25> rgb <.2,.2,.2> }
light_source {
    <-20, 15, -15.6>
    colour rgb <8, 8, 8>
    spotlight
    point_at <-250, 10, 700>
    radius 10
    falloff 15
    tightness 1
  }

// Camera Setting
camera { location <0, 10, -50>
       up y
       right x*1.33
       direction z
       look_at <-30 0 0>
       angle 57}

//OBJECT Sky.
sky_sphere { S_Cloud4 }    // Standard sky sphere from Pov3 include

//OBJECT Water
object {
       plane {y,0}
       pigment { color rgb<0.313725, 0.611765, 0.686275> }
       normal { bumps .5 scale <1,1.5,2.5> }
       finish { reflection 0.5 } 
}

//OBJECT Mountains
height_field {gif "mnts.gif"
	texture {rock scale .03
		finish {crand .15 ambient .25}
	}
	translate <-.5, 0, -.5>
	rotate 260*y
	scale <100, 20, -100>
	translate <0, -10, 0>
}


//OBJECT LightHouse   --- Right Hand Coodinate system so Z is up and down and Y is in and out.
 object { lighthouse
       translate <-10, 8, 1.5>
       rotate -90*x
       scale <2, 2, 2>
}


  fog {
   distance 150
    colour rgb<0.5, 0.5, 0.5>
   fog_type 2
    fog_offset 10
    fog_alt 1
  }

object { _USS_LA
       translate <-250, 10, 700>
       rotate <0, 0, 0>
       scale <.15, .15, .15>
}

