#ifdef(Stars)
#if (Stars > 0.0)

sky_sphere{
    pigment {
        granite
        color_map {
            [ 0.00  0.72 color Black  color Black ]  // No Stars in this area
            [ 0.72  0.75 color Gray20*Stars color Gray40*Stars ] // Very Very Faint Stars
            [ 0.75  0.78 color Gray40*Stars color Gray60*Stars ] // Very Faint Stars
            [ 0.81  0.85 color Gray80*Stars color Gray95*Stars ] // Medium White Stars
            [ 0.85  0.91 color Gray95*Stars color White*Stars  ] // White Stars
            [ 0.91  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .015
    }
}
#end
#end

#declare Crator=normal{
	leopard
	slope_map{
		[0.775  <0,0>]
		[0.8  <40,10>]
		[0.8  <38,-10>]
		[0.825  <0,0>]
	}
	scale 1/13
}

#declare Ridges=normal{
	bozo
	slope_map{
		[0    <0,0>]
		[0.475  <0,0>]
		[0.4875 <5,0.7>]
		[0.5  <22,1>]
		[0.5  <12,-1>]
		[0.5125 <4,-0.7>]
		[0.525  <0,0>]
	}
	scale 1/5
}

#declare N_Moon=normal{
	average
	normal_map{
		[1.5 Crator]
		[1 Crator scale 1/2]
		[2 Crator scale 2 translate -2]
		[1 Ridges scale 2/3 translate 1/2]
	}
}

#declare P_GrayMoon=pigment{
	bozo
	color_map{
		[0.0  Gray75]
		[0.15 Gray65]
		[0.5  Gray75]
		[0.85 Gray85]
		[1    Gray75]
	}
	scale 1/5
	turbulence 0.3
}

#declare T_Moon1=texture{
	normal{N_Moon}
	pigment{P_GrayMoon}
}

