// Persistence of Vision Ray Tracer Scene Description File
// File: mjfseam.pov
// Vers: 3
// Desc: Summer = Sea, Sea = Sea monster
// Date: 08-26-96
// Auth: Gregor Rudolf
//       gregor.rudolf@irts.si, PCGNet 9:538/100, Fidonet 2:380/100
//----------------------------------------------------------------------

//Define what to render
#declare DoMonster=1
#declare DoBubbles=1
#declare DoPlant=1
#declare DoHalo=1

#include "colors.inc"
#include "textures.inc"
//#include "shapes.inc"

//setup envirnoment, camera and lights
camera {
 location  < 47.2845 ,-2.75138 , 59.1055 >
 direction <0.0 , 0.0 , 1.45 >
 up        <0 , 1 , 0>
 sky       <-.0388191 , .998067 ,-.0485235 >
 right     <1.3333333 , 0.0  , 0.0>
 look_at   < 0 ,-7.46403 ,0 >
}

object { light_source { < 0 , 40 ,  0  > color White fade_distance 50}}
object { light_source { <  47.2845 ,-3.026518 ,  59.1055  > color Gray60  fade_distance 40}}


sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color blue 0.3] }
  }
}

// sea surface
plane { y, 10
    hollow
    pigment { red 0.7 green 0.7 blue 1.0 filter 0.9 }
    finish { reflection 0.7 caustics 1.0 }
    translate <5, 0, -10>
    normal { bumps 0.5 }
}

// sea 'contents'
sphere
{
  <0,0,0>
  1
  hollow
  texture {
          pigment {color Clear}
          finish { caustics 3  } scale .1
#if (DoHalo)
          halo
          {
            dust
            dust_type 2
            constant
            spherical_mapping
            max_value 0.5    //1.0
            colour_map
            {
             [ 0 color rgbf <0, 0, 1, 0.0> ]
             [ 1 color rgbf <.5, .5, 1, 0.9> ]
            }
            samples 11           //test=2
            aa_level 3           //test=2
            aa_threshold 0.3     
            jitter 0.8
            turbulence 0.2
          }
#end
       }
  scale  90 
}



//the monster
#declare tex_2 =
texture {
  pigment
  {
    bozo
    turbulence 0.86
    color_map
    {
      [0.00 color rgbf<1.000, 0.310, 0.329, 0.94>]
      [0.30 color rgbf<1.000, 0.498, 0.447, 0.94>]
      [0.50 color rgbf<0.627, 0.310, 0.227, 0.94>]
      [1.00 color rgbf<1.000, 0.624, 0.498, 0.94>]
    }
  }
  normal
  {
    bumps 0.39
    scale <0.1, 0.1, 0.1>
  }
  finish {
    ambient 0.26
    specular 0.26    roughness 0.2
    phong 0.43
  }
}
texture {
  pigment
  {
    bozo
    turbulence 0.49  octaves 5  omega 0.3
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.25 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.27 color rgbf<0.827, 1.000, 0.000, 0.498>]
      [0.30 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.58 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.60 color rgbf<0.859, 0.796, 1.000, 0.498>]
      [0.62 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    scale <3.0, 6.0, 3.0>
  }
  finish {
    ambient 0.85
  }
}


#declare tex_3 = texture {
  pigment
  {
    leopard
    turbulence 0.84
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 0.812, 0.922>]
      [0.23 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.33 color rgb<0.961, 0.059, 0.259>]
      [0.41 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 0.812, 0.863>]
    }
  }
  normal
  {
    bumps 0.1
    scale <0.1, 0.1, 0.1>
  }
  finish {
    ambient 0.7
    specular 0.16    roughness 0.1
    phong 0.41
  }
}
texture {
  pigment
  {
    spotted
    turbulence 0.49
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.36 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.40 color rgb<0.969, 0.098, 1.000>]
      [0.44 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
  }
  finish {
    ambient 0.3
  }
}


#declare tex_4 =
texture {
  pigment
  {
    gradient x+y
    turbulence 0.22
    color_map
    {
      [0.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.17 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.22 color rgb<1.000, 1.000, 0.000>]
      [0.28 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.50 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.56 color rgb<0.000, 1.000, 0.000>]
      [0.61 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.79 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [0.82 color rgbf<1.000, 0.200, 1.000, 0.051>]
      [0.85 color rgbf<1.000, 1.000, 1.000, 1.000>]
      [1.00 color rgbf<1.000, 1.000, 1.000, 1.000>]
    }
    scale <0.5, 0.5, 0.5>
  }
  finish {
    ambient 0.62
  }
}

#declare tex_5 = texture {Lightening2}

#if (DoMonster)
   #include "g-jelly.inc"
   object { Lsystem }
#else
   sphere { < 0,  0,  0> 4 texture {tex_2}}
   sphere { < 6,  6,  0> 4 texture {tex_3}}
   sphere { <-6, -6,  0> 4 texture {tex_4}}
   sphere { < 8,  3, -5> 4 texture {tex_5}}
#end


//air bubbles
#if (DoBubbles)
       #declare NumObj=50
       #declare MaxStr=5

       //size of box "containing" bubbles
       #declare x_size=10
       #declare y_size=30
       #declare z_size=10

       #declare bub_scale=2
       #declare x_scale=1.3
       #declare y_scale=.5
       #declare z_scale=.5

       #declare x_dist=1
       #declare y_dist=3
       #declare z_dist=1

       #declare R=seed(0)

       //#declare t_bubble = texture { pigment { color White }}
       #declare t_bubble = texture
       {
         pigment
         {
             colour rgbf<0.937,0.961,0.988,0.9>
         }
         finish {
             ambient 1
             diffuse 0.9
             specular 0.23
             phong 0.45
             refraction 1.0    ior 1.1
         }
       }


       #declare UnitSphere = sphere { <0, 0, 0> 0.5 }
       #declare Bubbles = union {
       #while (NumObj > 0)
            #declare NumStr = 1 + int(MaxStr * rand(R))
            #declare NumObj = NumObj-NumStr // increment our counter
            #declare x_pos=rand(R)*x_size
            #declare y_pos=rand(R)*y_size
            #declare z_pos=rand(R)*z_size
            #while (NumStr > 0)
               object {
                  UnitSphere
                  translate <x_pos+rand(R)*x_dist, y_pos, z_pos+rand(R)*z_dist>
                  translate <x_size/2 * (-1), (y_size/2 * (-1)), z_size/2 * (-1)>
                  scale <rand(R)/2+x_scale, rand(R)/2+y_scale, rand(R)/2+z_scale>
               }
               #declare y_pos=y_pos+(rand(R)*y_dist)    //-(y_dist/2)
               #declare NumStr = NumStr-1 // decrement our counter
            #end
       #end
       }

       object { Bubbles
              translate <-5, -5, 20>
              texture { t_bubble }
       }

#end


//sea plants
#if (DoPlant)
    #declare l_base = object { sphere { <0, 0.75 0> 0.75 } }

    #declare tex_pl_base = texture {
         pigment { color rgb <.2, .5, .25> }
         normal { bumps 0.1 }
         finish { ambient 0.1 diffuse 0.5 phong 1 }
         }

    #declare tex_pl_leaf = texture {
         pigment { color rgb <.3, .7, .3> }
         normal { bumps 0.1 }
         finish { ambient 0.1 diffuse 0.5 phong 1 }
         }
        
    #include "plant.inc"
    object { LPlant rotate <0,  0, 0> scale <1,1.5,1> translate < 18, -40, -20>}
    object { LPlant rotate <0, 45, 0> scale <1,1.5,1> translate <-30, -60, -50>}
    object { LPlant rotate <0, 75, 0> scale <1,1.5,1> translate <-30, -70,  20>}
#end
