/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996
 */

#declare ConeCol=
pigment{red 1.2 green .7 blue .4}

#declare Cone1=
union {

difference {
    union {
        cone {<0,0,0>,28,<25,0,0>,14 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
        torus {25,5 sturm rotate<0,0,90> pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
    }
    union {
        cone {<-6,0,0>,29,<30,0,0>,9 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
        box {<0,100,-100><-100,-100,100> pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
    }
 }

difference {
     cone {<0,0,0>,18,<115,0,0>,2 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
     cone {<-6,0,0>,16,<115,0,0>,0 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
 }

sphere {<115,0,0>,1 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}

 #declare ribs=
 union {
     box {<1,1000,1000><-1,-1000,-1000> rotate<0,0,45> pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
     box {<1,1000,1000><-1,-1000,-1000> rotate<0,0,-45> pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
 }

intersection {
     union {
         object {ribs translate<39,0,0>}
         object {ribs translate<49,0,0>}
         object {ribs translate<59,0,0>}
         object {ribs translate<69,0,0>}
         object {ribs translate<79,0,0>}
         object {ribs translate<89,0,0>}
         object {ribs translate<99,0,0>}
         object {ribs translate<109,0,0>}
     }
    cone {<0,0,0>,18,<120,0,0>,2 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
 }

#declare rib2=
intersection {
    box {<1,30,.5><25,-30,-.5> pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
    cone {<0,0,0>,25,<30,0,0>,9 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
 }

difference {
     union {
     object {rib2}
     object {rib2 rotate<30,0,0>}
     object {rib2 rotate<60,0,0>}
     object {rib2 rotate<90,0,0>}
     object {rib2 rotate<120,0,0>}
     object {rib2 rotate<150,0,0>}
     }
cone {<-6,0,0>,16,<24,0,0>,12 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
 }

#declare rib3=
difference {
cylinder {<0,-28.5,0><0,28.5,0>,3 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
box {<0,100,100><100,-100,-100> pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
}

difference {
     union {
     object {rib3}
     object {rib3 rotate<15,0,0>}
     object {rib3 rotate<30,0,0>}
     object {rib3 rotate<45,0,0>}
     object {rib3 rotate<60,0,0>}
     object {rib3 rotate<75,0,0>}
     object {rib3 rotate<90,0,0>}
     object {rib3 rotate<105,0,0>}
     object {rib3 rotate<120,0,0>}
     object {rib3 rotate<135,0,0>}
     object {rib3 rotate<150,0,0>}
     object {rib3 rotate<165,0,0>}
     }
cone {<-6,0,0>,29,<30,0,0>,9 pigment{ConeCol}finish{ambient .4 phong 0.5 phong_size 10}}
}

}

#declare Tooth=
cylinder {<100,30,0><-100,30,0>,4 pigment{ConeCol}finish{ambient .4 phong 0.5}normal{bumps 1 scale .2}}

#declare Mouth=
union {
#declare Count=1
#while (Count<21)
object {Tooth rotate<Count*18,0,0>}
#declare Count=Count+1
#end
cylinder {<100,0,0><-100,0,0>,30 pigment{ConeCol}finish{ambient .4 phong 0.5}normal{bumps 1 scale .2}}
}


#declare Cone2=
difference {
object {Cone1 rotate<0,0,-13.74> translate<5.94,29.28,0.00>}
object {Mouth translate<0,72,0> rotate<-25,0,0>}
}
