#include "colors.inc"
#include "skies.inc"
#include "cone1.pov"
#include "blob.inc"
#include "foot.inc"
#include "straw2.pov"


camera {
        location <0,150,-100>
        look_at  <0,0,0>
}

light_source {<5,500,5> color White}
light_source {<10,150,-100> color Gray50}

#declare NOBbump1=
texture{pigment{
wood
color_map {
          [0.0 rgb <.8,.63,.2>]
          [0.1 rgb <.8,.53,.2>]
          [0.2 rgb <.7,.53,.2>]
          [0.4 rgb <.7,.43,.15>]
          [0.5 rgb <.6,.43,.2>]
          [0.6 rgb <.9,.63,.3>]
          [0.8 rgb <.8,.53,.15>]
          [0.9 rgb <.7,.53,.15>]
          [1.0 rgb <.5,.38,.15>]
}
turbulence .02
scale 10
rotate<5,0,0>
}
normal {wood 2 scale 10 rotate <5,0,0>}
}

#declare NOBbump2=
texture{pigment{
wood
color_map {
          [0.0 rgb <.8,.63,.2>]
          [0.1 rgb <.8,.53,.2>]
          [0.2 rgb <.7,.53,.2>]
          [0.4 rgb <.7,.43,.15>]
          [0.5 rgb <.6,.43,.2>]
          [0.6 rgb <.9,.63,.3>]
          [0.8 rgb <.8,.53,.15>]
          [0.9 rgb <.7,.53,.15>]
          [1.0 rgb <.5,.38,.15>]
}
turbulence .02
scale 8
rotate<5,2,0>
}
normal {wood 2 scale 8 rotate <5,2,0>}
}

#declare NOBbump3=
texture{pigment{
wood
color_map {
          [0.0 rgb <.8,.63,.2>]
          [0.1 rgb <.8,.53,.2>]
          [0.2 rgb <.7,.53,.2>]
          [0.4 rgb <.7,.43,.15>]
          [0.5 rgb <.6,.43,.2>]
          [0.6 rgb <.9,.63,.3>]
          [0.8 rgb <.8,.53,.15>]
          [0.9 rgb <.7,.53,.15>]
          [1.0 rgb <.5,.38,.15>]
}
turbulence .02
scale 12
rotate<5,-1,0>
}
normal {wood 2 scale 12 rotate <5,-1,0>}
}

#declare NOBbump4=
texture{pigment{
wood
color_map {
          [0.0 rgb <.8,.63,.2>]
          [0.1 rgb <.8,.53,.2>]
          [0.2 rgb <.7,.53,.2>]
          [0.4 rgb <.7,.43,.15>]
          [0.5 rgb <.6,.43,.2>]
          [0.6 rgb <.9,.63,.3>]
          [0.8 rgb <.8,.53,.15>]
          [0.9 rgb <.7,.53,.15>]
          [1.0 rgb <.5,.38,.15>]
}
turbulence .02
scale 6
rotate<5,3,0>
}
normal {wood 2 scale 6 rotate <5,3,0>}
}

#declare NOBbump5=
texture{pigment{
wood
color_map {
          [0.0 rgb <.8,.63,.2>]
          [0.1 rgb <.8,.53,.2>]
          [0.2 rgb <.7,.53,.2>]
          [0.4 rgb <.7,.43,.15>]
          [0.5 rgb <.6,.43,.2>]
          [0.6 rgb <.9,.63,.3>]
          [0.8 rgb <.8,.53,.15>]
          [0.9 rgb <.7,.53,.15>]
          [1.0 rgb <.5,.38,.15>]
}
turbulence .02
scale 12
rotate<5,-2,0>
}
normal {wood 2 scale 12 rotate <5,-2,0>}
}

#declare Plank1=
superellipsoid {<.1,.1> translate<0,-1,0> scale<49,12,499> texture{NOBbump1}}

#declare Plank2=
superellipsoid {<.1,.1> translate<0,-1,0> scale<49,12,499> texture{NOBbump2}}

#declare Plank3=
superellipsoid {<.1,.1> translate<0,-1,0> scale<49,12,499> texture{NOBbump3}}

#declare Plank4=
superellipsoid {<.1,.1> translate<0,-1,0> scale<49,12,499> texture{NOBbump4}}

#declare Plank5=
superellipsoid {<.1,.1> translate<0,-1,0> scale<49,12,499> texture{NOBbump5}}

object {Cone2 scale 1.5 translate<-30,0,20> rotate<0,-45,0>}
object {Ice scale 60 translate<-51,0,9>}

#declare Floor=
union {
      difference{
                 object {Plank1 finish {ambient .3}translate<0,5,460>}
                 cylinder {<35,100,0><35,-100,0>,2.5 texture{NOBbump3}}
      }
      difference{
                 object {Plank2 translate<0,0,-540>}
                 cylinder {<30,100,-60><30,-100,-60>,2.5 texture{NOBbump3}}
      }
object {Plank3 finish {ambient .2}translate<100,-1,100>}
object {Plank4 finish {ambient .2}translate<-100,-2,-50>}
object {Plank5 finish {ambient .3}translate<-200,1,40>}
object {Plank1 rotate<0,90,0> translate<0,-12,0>}
}

object {Floor rotate<0,30,0>}

#declare NailHead=
union {
      cylinder {<0,-5,0><0,0,0>,1.5 pigment{Gray50} finish{phong .7 metallic}}
      superellipsoid {<.2,1> scale 1.5 pigment{Gray50} finish{phong .7 metallic}}
}

#declare Nail=
union {
      object {NailHead rotate<-35,0,0> translate<0,10,0>}
      sphere {<0,5,0>,1.5 pigment{Gray50} finish{phong .7 metallic}}
      cylinder {<0,-10,0><0,5,0>,1.5 pigment{Gray50} finish{phong .7 metallic}}
}

object {Nail translate<35,0,0> rotate<0,30,0>}
object {Nail rotate<0,90,0> translate<30,0,-60> rotate<0,30,0>}

object {Foot scale<60,1,60> translate<35,0,0>}

sky_sphere{S_Cloud1}

object {Drinking_straw rotate<90,0,0> rotate<0,45,0> translate<100,2,0>}
