// Created with Quick Pov v0.1
// Persistence of Vision Ray Tracer Scene Description File
// File:
// Vers: 3
// Desc:
// Date:
// Auth:
// ==== POV-Ray Includes ====
#include "COLORS.INC"
#include "TEXTURES.INC"
#include "CHARS.INC"
#include "CONSTS.INC"
#include "METALS.INC"
#include "SHAPES.INC"
#include "SHAPES2.INC"
#include "SHAPESQ.INC"
#include "SKIES.INC"
#include "STONES.INC"
#include "STONES2.INC"
#include "WOODMAPS.INC"
#include "WOODS.INC"
#include "ATMOS.INC"
#include "FINISH.INC"
#include "GLASS.INC"
#include "STONES1.INC"
#include "GOLDS.INC"

#declare Glass_Grass = mesh {
  // This mesh makes 1 piece of 'Glass Grass'
  // Side 1
  triangle {<0,0,1>, <1,0,0>, <1,5,0>}
  triangle {<1,5,0>, <0,5,1>, <0,0,1>}
  // Side 2
  triangle {<1,0,0>, <.5,0,-1>, <.5,5,-1>}
  triangle {<.5,5,-1>, <1,5,0>, <1,0,0>}
  // Side 3
  triangle {<.5,0,-1>, <-.5,0,-1>, <-.5,5,-1>}
  triangle {<-.5,5,-1>, <.5,5,-1>, <.5,0,-1>}
  // Side 4
  triangle {<-.5,0,-1>, <-1,0,0>, <-1,5,0>}
  triangle {<-1,5,0>, <-.5,5,-1>, <-.5,0,-1>}
  // Side 5
  triangle {<-1,0,0>, <0,0,1>, <0,5,1>}
  triangle {<0,5,1>, <-1,5,0>, <-1,0,0>}
  // Top
  triangle {<0,5,1>, <1,5,0>, <0,6,0>}
  triangle {<1,5,0>, <.5,5,-1>, <0,6,0>}
  triangle {<.5,5,-1>, <-.5,5,-1>, <0,6,0>}
  triangle {<-.5,5,-1>, <-1,5,0>, <0,6,0>}
  triangle {<-1,5,0>, <0,5,1>, <0,6,0>}
//  // Bottom
//  triangle {<0,0,1>, <1,0,0>, <0,-1,0>}
//  triangle {<1,0,0>, <.5,0,-1>, <0,-1,0>}
//  triangle {<.5,0,-1>, <-.5,0,-1>, <0,-1,0>}
//  triangle {<-.5,0,-1>, <-1,0,0>, <0,-1,0>}
//  triangle {<-1,0,0>, <0,0,1>, <0,-1,0>}
  texture {
    pigment {
      Candy_Cane
      color_map {[0, 1  color Green filter 0 color Green filter 1] }
      scale <.5, .5, .5> // original = <2,2,1>
    }
    finish {
      ambient 0.5
      diffuse 0.5
      refraction 0.75
      reflection 0.15
      specular 0.25 roughness 0.001
      fade_distance 6
      fade_power 2
    }
  }
  hollow
}

#declare Patch_Glass_Grass_1 = union {
  object {
    Glass_Grass
    translate <-10,-.25,0>
  }
  object {
    Glass_Grass
    translate <-8,-.5,0>
  }
  object {
    Glass_Grass
    translate <-6,-.75,0>
  }
  object {
    Glass_Grass
    translate <-4,-.5,0>
  }
  object {
    Glass_Grass
    translate <-2,-.25,0>
  }

  object {Glass_Grass}

  object {
    Glass_Grass
    translate <2,-.25,0>
  }
  object {
    Glass_Grass
    translate <4,-.5,0>
  }
  object {
    Glass_Grass
    translate <6,-.75,0>
  }
  object {
    Glass_Grass
    translate <8,-.5,0>
  }
  object {
    Glass_Grass
    translate <10,-.25,0>
  }
}

#declare Patch_Glass_Grass_2 = union {
  object {
    Patch_Glass_Grass_1
    translate z*-4
  }
  object {
    Patch_Glass_Grass_1
    translate z*-2
  }

  object {Patch_Glass_Grass_1}

  object {
    Patch_Glass_Grass_1
    translate z*2
  }
  object {
    Patch_Glass_Grass_1
    translate z*4
  }
}

//CAMERA
camera {
  //[ perspective | orthographic | fisheye | ultra_wide_angle | omnimax | panoramic | cylinder FLOAT ] // Different camera views
  location <0,4.5,-15> // Where the camera is located in the 3D world
  look_at <0,6.5,0> // What 3D coordinate the camera is looking at
  //right <VECTOR> // Determine orientation of the camera in the scene
  //up <VECTOR> // Determine orientation of the camera in the scene
  //direction <VECTOR> // Tells PovRay the initial direction of the camera (default is <0,0,1>)
  //sky <VECTOR> // Tilts the camera on its side
  //angle FLOAT // WHAT DOES THIS DO?
  //blur_samples FLOAT // Maximum rays to use for each pixel
  //aperture FLOAT // Not related to f-stops but acts the same as a real camera
  //focal_point <VECTOR> // Point where picture is focused most (default is <0,0,0>)
  //normal { NORMAL } // Assigns a 'normal' pattern (used for special effects)
  // Include transformations here (Rotate and Translate)
}


//POINT LIGHT
light_source {
  <0,4.6,-15> // The center point where the light originates
  color rgb <1,1,1> // The color of the light source
  //[ looks_like { OBJECT } ] // Makes the light source look like another object, like a sphere
  //[ fade_distance FADE_DISTANCE ] // how far the light will reach before fading
  //[ fade_power FADE_POWER ] // Use 'fade_power 1' for linear falloffs and 'fade_power 2' for quadratic falloffs
  //[ atmospheric_attenuation BOOL ] // Use this to create realistic effects in fog
  shadowless // Use this to create shadowless light sources
  //[ atmosphere off ] // Use this option to make the light source not react with the atmosphere
}


object {
  Patch_Glass_Grass_2
  hollow
}


sphere {
  <0,0,0>
  100
  texture {
    pigment {
      Bright_Blue_Sky
      scale <10, 10, 10>
    }
  }
  hollow
}


sphere {
  0, 1
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    emitting
    spherical_mapping
    linear
    turbulence .25
    color_map {[ 0.0 color rgbt <1, 0, 0, 1> ]
               [ 0.5 color rgbt <1, 1, 0, -1> ]
               [ 1.0 color rgbt <1, 0, 0, 1> ]}
    samples 40
    scale 0.5
  }
  hollow
  scale 15.5
  translate <30,50,80>
}

#declare chain_link_1 = torus {
  .6, .2
  scale <1, 1, 1.5>
  rotate 90*x
}

#declare chain_link_2 = torus {
  .6, .2
  scale <1, 1, 1.5>
  rotate <90, 90, 0>
}

union {
  union { // This creates golden spheres for the swing set
    sphere {
      <-3,2.5,-4>
      1
    }
    sphere {
      <-11,2.5,-4>
      1
    }
    sphere {
      <-3,2.5,5>
      1
    }
    sphere {
      <-11,2.5,5>
      1
    }
    sphere {
      <-6,15,-4>
      1
    }
    sphere {
      <-6,15,5>
      1
    }
    texture {
      Gold_Texture
      finish {Shiny}
    }
  }
  union { // This creates the childish shiny edges (candy cane)
    cylinder {<-3,2.5,-4>, <-6,15,-4>, .75}
    cylinder {<-11,2.5,-4>, <-6,15,-4>, .75}
    cylinder {<-3,2.5,5>, <-6,15,5>, .75}
    cylinder {<-11,2.5,5>, <-6,15,5>, .75}
    cylinder {
      <-6,15,-4>, <-6,15,5>, .75
      texture {
        pigment {
          Candy_Cane
          rotate 90*x
        }
      }
    }
    texture {
      pigment {Candy_Cane}
    }
  }
  union { // This creates the chain for the swing set
    cylinder {<-6,15,2.5>, <-6,15,3.5>, 1}
    object {
      chain_link_1
      translate <-6, 14, 3>
    }
    object {
      chain_link_2
      translate <-6, 12.4, 3>
    }
    object {
      chain_link_1
      translate <-6, 10.8, 3>
    }
    object {
      chain_link_2
      translate <-6, 9.2, 3>
    }
    object {
      chain_link_1
      translate <-6, 7.6, 3>
    }

    cylinder {<-6,15,-1.5>, <-6,15,-2.5>, 1}
    object {
      chain_link_1
      translate <-6, 14, -2>
    }
    object {
      chain_link_2
      translate <-6, 12.4, -2>
    }
    object {
      chain_link_1
      translate <-6, 10.8, -2>
    }
    object {
      chain_link_2
      translate <-6, 9.2, -2>
    }
    object {
      chain_link_1
      translate <-6, 7.6, -2>
    }
    texture {
      Brushed_Aluminum
    }
  }
  prism {
    linear_sweep
    quadratic_spline
    -2.2,
    3.2,
    15,
    <-7, 10>, <-7,7.2>, <-5,7.2>, <-4.2,6.4>, <-4.2,5.6>, <-5,5.2>, <-5,6.4>, <-7,6.1>, <-7.8,7.2>, <-7.8,9.6>, <-8.6,8.8>, <-8.6,9.6>, <-7.8,10.4>, <-7,9.6>, <-7,7.2>
    texture {
      pigment {Cherry_Wood}
      finish {
        Shiny
        reflection .25
      }
    }
    rotate -90*x
  }
}

#declare Jungle_1 = blob {
  threshold 0.6
  cylinder {<-1,-1,-1>, <-1,-1, 1>, .4, 1}
  cylinder {<-1,-1, 1>, <-1, 1, 1>, .4, 1}
  cylinder {<-1, 1, 1>, <-1, 1,-1>, .4, 1}
  cylinder {<-1, 1,-1>, <-1,-1,-1>, .4, 1}

  cylinder {< 1,-1,-1>, < 1,-1, 1>, .4, 1}
  cylinder {< 1,-1, 1>, < 1, 1, 1>, .4, 1}
  cylinder {< 1, 1, 1>, < 1, 1,-1>, .4, 1}
  cylinder {< 1, 1,-1>, < 1,-1,-1>, .4, 1}

  cylinder {<-1,-1,-1>, < 1,-1,-1>, .4, 1}
  cylinder {<-1,-1, 1>, < 1,-1, 1>, .4, 1}
  cylinder {<-1, 1, 1>, < 1, 1, 1>, .4, 1}
  cylinder {<-1, 1,-1>, < 1, 1,-1>, .4, 1}
}

#declare Jungle_Gym_X = union {
  object {Jungle_1}
  object {
    Jungle_1
    translate 2*x
  }
  object {
    Jungle_1
    translate 4*x
  }
}

#declare Jungle_Gym_XY = union {
  object {Jungle_Gym_X}
  object {
    Jungle_Gym_X
    translate 2*y
  }
  object {
    Jungle_Gym_X
    translate 4*y
  }
}

#declare Jungle_Gym = union {
  object {Jungle_Gym_XY}
  object {
    Jungle_Gym_XY
    translate 2*z
  }
  object {
    Jungle_Gym_XY
    translate 4*z
  }
  texture {
    pigment {
      Candy_Cane
      turbulence .5
      color_map {[0.0 color rgb <1,0,0>]
                 [0.5 color rgb <0,0,1>]
                 [1.0 color rgb <1,0,1>]}
    }
    finish {Shiny}
  }
}

object {
  Jungle_Gym
  translate <-2, -2, -2>
  scale <1.5, 1.5, 1.5>
  translate < 6,  5,  6>
}


//FINISH
//finish {
//  FINISH_IDENTIFIER
//  [ ambient COLOR ]
//  [ diffuse FLOAT ]  //default float is 0.6 (limit:  0.0-1.0, diffuse reflection)
//  [ brilliance FLOAT ]  //default float is 1.0 (no limit, makes object more metallic)
//  [ phong FLOAT ]  //default float is 0.0 (limit:  0.0-1.0, shininess)
//  [ phong_size FLOAT ]  //default float is 40 (typical limit:  0.0-250.0, how shiny the phong is)
//  [ specular FLOAT ]  //default float is 0.0 (limit:  0.0-1.0, see description below)
//  [ roughness FLOAT ]  //default float is 0.05 (typical limit:  1.0-0.0005, self explanitory)
//  [ metallic [ FLOAT ] ]  //default float is 1.0 (limit:  0.0-1.0, used with phong or specular)
//  [ reflection COLOR ]  //default float (color) is 0.0 (limit:  0.0-1.0, mirrored finish)
//  [ refraction FLOAT ]  //default float is 0.0 (limit:  0.0-1.0, refracts light)
//  [ ior FLOAT ]  //default float is 1.0 (no limit, density of object)
//  [ caustics FLOAT ]  //N/A
//  [ fade_distance FLOAT ]  //N/A
//  [ fade_power FLOAT ]  //N/A
//  [ irid {  //iridescence (i.e. oil slick on a puddle of water or rainbow hues of a soap bubble)
//    AMOUNT  //see below
//    thickness FLOAT  //see below
//    turbulence VECTOR  //see below
//    } ]
//  [ crand FLOAT ]  //default float is 0.0 (no limit, graininess)
//}

//ABMBIENT
//However we can use a trick called "ambient lighting" to simulate the light
//inside a shadowed area.

//Ambient light is light that is scattered everywhere in the room. It bounces
//all over the place and manages to light objects up a bit even where no light
//is directly shining. Computing real ambient light would take far too much
//time, so we simulate ambient light by adding a small amount of white light to
//each texture whether or not a light is actually shining on that texture.

//This means that the portions of a shape that are completely in shadow will
//still have a little bit of their surface color. It's almost as if the texture
//glows, though the ambient light in a texture only affects the shape it is
//used on.

//CRAND
//NOTE: This should not be used when rendering animations. This is the one of a
//few truly random features in POV-Ray, and will produce an annoying flicker of
//flying pixels on any textures animated with a "crand" value.

//SPECULAR HIGHLIGHT
//A specular highlight is very similar to Phong highlighting, but uses slightly
//different model. The specular model more closely resembles real specular
//reflection and provides a more credible spreading of the highlights occur
//near the object horizons.

//REFRACTION
//Note: It is recommended that you only use "refraction 0" or "refraction 1".
//Values in between will darken the refracted light in ways that do not
//correspond to any physical property. Many POV-Ray scenes were created with
//intermediate refraction values before this "bug" was discovered so the
//"feature" has been maintained. A more appropriate way to reduce the
//brightness of refracted light is to change the "filter" value in the colors
//specified in the pigment statement. Note also that "refraction" does not
//cause the object to be transparent. Transparency is only occurs if there is a
//non-zero "filter" value in the color.

//IOR (INDEX OF REFRACTION)
//The amount of bending or refracting of light depends upon the density of the
//material. Air, water, crystal, diamonds all have different density and thus
//refract differently. The "index of refraction" or "ior" value is used by
//scientists to describe the relative density of substances. The "ior" keyword
//is used in POV-Ray to specify the value.

//The default ior value of 1.0 will give no refraction. The index of refraction
//for air is 1.0, water is 1.33, glass is 1.5, and diamond is 2.4. The file
//CONSTS.INC pre-defines several useful values for ior.

//NOTE: If a texture has a filter component and no value for refraction and ior
//are supplied, the renderer will simply transmit the ray through the surface
//with no bending. In layered textures, the refraction and ior keywords MUST be
//in the last texture, otherwise they will not take effect.

//IRIDESCENCE
//The "amount" parameter is the contribution of the iridescence effect to the
//overall surface color. As a rule of thumb, keep to around 0.25 (25%
//contribution) or less, but experiment. If the surface is coming out too
//"white", try lowering the diffuse and possibly the ambient values of the
//surface.

//The "thickness" parameter represents the film's thickness. This is an awkward
//parameter to set, since the thickness value has no relationship to the
//object's scale. Changing it affects the scale, or "busy-ness" of the effect.
//A very thin film will have a high frequency of color changes, where a thick
//film will have large areas of color.

//The thickness of the film can be varied with the special turbulence
//parameter. You can only specify turbulence amount with iridescence. The
//octaves, lambda, and omega values are internally set and are not adjustable
//by the user at this time.

//In addition, perturbing the object's surface-normal through the use of bump
//patterns will affect iridescence.


//           ================= TEXTURES ===================
// 320 pre-defined textures alphabetically ordered

//Aluminum
//Apocalypse
//Atmosphere1
//Atmosphere2
//Atmosphere3
//Atmosphere4
//Blood_Marble
//Blood_Sky
//Blue_Agate
//Blue_Sky
//Blue_Sky2
//Blue_Sky3
//Brass_Metal
//Brass_Texture
//Brass_Valley
//Bright_Blue_Sky
//Bright_Bronze
//Bronze_Metal
//Bronze_Metal
//Bronze_Texture
//Brown_Agate
//Brushed_Aluminum
//Candy_Cane
//Cherry_Wood
//Chrome_Metal
//Chrome_Texture
//Clouds
//Copper_Metal
//Copper_Texture
//Cork
//Dark_Green_Glass
//Dark_Wood
//DMFDarkOak
//DMFLightOak
//DMFWood1
//DMFWood2
//DMFWood3
//DMFWood4
//DMFWood5
//DMFWood6
//Dull
//EMBWood1
//FBM_Clouds
//Glass
//Glass2
//Glass3
//Glossy
//Gold_Metal
//Gold_Nugget
//Gold_Texture
//Green_Glass
//Jade
//Lightening1
//Lightening2
//Luminous
//Mirror
//NBbeerbottle
//NBglass
//NBoldglass
//NBwinebottle
//New_Brass
//New_Penny
//Orange_Glass
//Peel
//Phong_Dull
//Phong_Glossy
//Phong_Shiny
//Pine_Wood
//PinkAlabaster
//Pink_Granite
//Polished_Brass
//Polished_Chrome
//Red_Marble
//Rosewood
//Ruby_Glass
//Rust
//Rusty_Iron
//Sandalwood
//Sapphire_Agate
//Shadow_Clouds
//Shiny
//Silver1
//Silver2
//Silver3
//SilverFinish
//Silver_Texture
//Soft_Silver
//Spun_Brass
//Starfield
//Tan_Wood
//Tinny_Brass
//Tom_Wood
//T_Beerbottle_Glass
//T_Brass_1A
//T_Brass_1B
//T_Brass_1C
//T_Brass_1D
//T_Brass_1E
//T_Brass_2A
//T_Brass_2B
//T_Brass_2C
//T_Brass_2D
//T_Brass_2E
//T_Brass_3A
//T_Brass_3B
//T_Brass_3C
//T_Brass_3D
//T_Brass_3E
//T_Brass_4A
//T_Brass_4B
//T_Brass_4C
//T_Brass_4D
//T_Brass_4E
//T_Brass_5A
//T_Brass_5B
//T_Brass_5C
//T_Brass_5D
//T_Brass_5E
//T_Chrome_1A
//T_Chrome_1B
//T_Chrome_1C
//T_Chrome_1D
//T_Chrome_1E
//T_Chrome_2A
//T_Chrome_2B
//T_Chrome_2C
//T_Chrome_2D
//T_Chrome_2E
//T_Chrome_3A
//T_Chrome_3B
//T_Chrome_3C
//T_Chrome_3D
//T_Chrome_3E
//T_Chrome_4A
//T_Chrome_4B
//T_Chrome_4C
//T_Chrome_4D
//T_Chrome_4E
//T_Chrome_5A
//T_Chrome_5B
//T_Chrome_5C
//T_Chrome_5D
//T_Chrome_5E
//T_Cloud1
//T_Cloud2
//T_Cloud3
//T_Copper_1A
//T_Copper_1B
//T_Copper_1C
//T_Copper_1D
//T_Copper_1E
//T_Copper_2A
//T_Copper_2B
//T_Copper_2C
//T_Copper_2D
//T_Copper_2E
//T_Copper_3A
//T_Copper_3B
//T_Copper_3C
//T_Copper_3D
//T_Copper_3E
//T_Copper_4A
//T_Copper_4B
//T_Copper_4C
//T_Copper_4D
//T_Copper_4E
//T_Copper_5A
//T_Copper_5B
//T_Copper_5C
//T_Copper_5D
//T_Copper_5E
//T_Dark_Green_Glass
//T_Glass1
//T_Glass2
//T_Glass3
//T_Glass4
//T_Gold_1A
//T_Gold_1B
//T_Gold_1C
//T_Gold_1D
//T_Gold_1E
//T_Gold_2A
//T_Gold_2B
//T_Gold_2C
//T_Gold_2D
//T_Gold_2E
//T_Gold_3A
//T_Gold_3B
//T_Gold_3C
//T_Gold_3D
//T_Gold_3E
//T_Gold_4A
//T_Gold_4B
//T_Gold_4C
//T_Gold_4D
//T_Gold_4E
//T_Gold_5A
//T_Gold_5B
//T_Gold_5C
//T_Gold_5D
//T_Gold_5E
//T_Green_Glass
//T_Old_Glass
//T_Orange_Glass
//T_Ruby_Glass
//T_Silver_1A
//T_Silver_1B
//T_Silver_1C
//T_Silver_1D
//T_Silver_1E
//T_Silver_2A
//T_Silver_2B
//T_Silver_2C
//T_Silver_2D
//T_Silver_2E
//T_Silver_3A
//T_Silver_3B
//T_Silver_3C
//T_Silver_3D
//T_Silver_3E
//T_Silver_4A
//T_Silver_4B
//T_Silver_4C
//T_Silver_4D
//T_Silver_4E
//T_Silver_5A
//T_Silver_5B
//T_Silver_5C
//T_Silver_5D
//T_Silver_5E
//T_Stone1
//T_Stone10
//T_Stone11
//T_Stone12
//T_Stone13
//T_Stone14
//T_Stone15
//T_Stone16
//T_Stone17
//T_Stone18
//T_Stone19
//T_Stone2
//T_Stone20
//T_Stone21
//T_Stone22
//T_Stone23
//T_Stone24
//T_Stone25
//T_Stone26
//T_Stone27
//T_Stone28
//T_Stone29
//T_Stone3
//T_Stone30
//T_Stone31
//T_Stone32
//T_Stone33
//T_Stone34
//T_Stone35
//T_Stone36
//T_Stone37
//T_Stone38
//T_Stone39
//T_Stone4
//T_Stone40
//T_Stone41
//T_Stone42
//T_Stone43
//T_Stone44
//T_Stone5
//T_Stone6
//T_Stone7
//T_Stone8
//T_Stone9
//T_Vicksbottle_Glass
//T_Winebottle_Glass
//T_Wood1
//T_Wood10
//T_Wood11
//T_Wood12
//T_Wood13
//T_Wood14
//T_Wood15
//T_Wood16
//T_Wood17
//T_Wood18
//T_Wood19
//T_Wood2
//T_Wood20
//T_Wood21
//T_Wood22
//T_Wood23
//T_Wood24
//T_Wood25
//T_Wood26
//T_Wood27
//T_Wood28
//T_Wood29
//T_Wood3
//T_Wood30
//T_Wood31
//T_Wood32
//T_Wood33
//T_Wood34
//T_Wood35
//T_Wood4
//T_Wood5
//T_Wood6
//T_Wood7
//T_Wood8
//T_Wood9
//T_Yellow_Glass
//Vicks_Bottle_Glass
//Water
//White_Marble
//White_Wood
//X_Gradient
//Yellow_Glass
//Yellow_Pine
//Y_Gradient


//            ================== COLORS =====================
// 126 pre-defined colors alphabetically ordered

//Aquamarine
//BakersChoc
//Black
//Blue
//BlueViolet
//Brass
//BrightGold
//Bronze
//Bronze2
//Brown
//CadetBlue
//Clear
//CoolCopper
//Copper
//Coral
//CornflowerBlue
//Cyan
//DarkBrown
//DarkGreen
//DarkOliveGreen
//DarkOrchid
//DarkPurple
//DarkSlateBlue
//DarkSlateGray
//DarkSlateGrey
//DarkTan
//DarkTurquoise
//DarkWood
//DimGrey
//DkGreenCopper
//DustyRose
//Feldspar
//Firebrick
//Flesh
//ForestGreen
//Gold
//Goldenrod
//Gray05
//Gray10
//Gray15
//Gray20
//Gray25
//Gray30
//Gray35
//Gray40
//Gray45
//Gray50
//Gray55
//Gray60
//Gray65
//Gray70
//Gray75
//Gray80
//Gray85
//Gray90
//Gray95
//Green
//GreenCopper
//GreenYellow
//Grey
//HuntersGreen
//IndianRed
//Khaki
//LightBlue
//LightGrey
//LightSteelBlue
//LightWood
//Light_Purple
//LimeGreen
//Magenta
//MandarinOrange
//Maroon
//MediumAquamarine
//MediumBlue
//MediumForestGreen
//MediumGoldenrod
//MediumOrchid
//MediumSeaGreen
//MediumSlateBlue
//MediumSpringGreen
//MediumTurquoise
//MediumVioletRed
//MediumWood
//Med_Purple
//Mica
//MidnightBlue
//Navy
//NavyBlue
//NeonBlue
//NeonPink
//NewMidnightBlue
//NewTan
//OldGold
//Orange
//OrangeRed
//Orchid
//PaleGreen
//Pink
//Plum
//Quartz
//Red
//RichBlue
//Salmon
//Scarlet
//SeaGreen
//SemiSweetChoc
//Sienna
//Silver
//SkyBlue
//SlateBlue
//SpicyPink
//SpringGreen
//SteelBlue
//SummerSky
//Tan
//Thistle
//Turquoise
//VeryDarkBrown
//Very_Light_Purple
//Violet
//VioletRed
//VLightGrey
//Wheat
//White
//Yellow
//YellowGreen
