/***************************************************************************/
//		bench.inc
/***************************************************************************/
#declare Bench_Texture =
texture{
  pigment{
    wood
    ramp_wave
    color_map{
      [0.0 (LightWood+Gold*2.25+White*1.5+Tan)/4.5]
      [0.4 (LightWood+Gold*2.25+White*1.5+Tan)/4.5]
      [0.9 (LightWood+Gold*2.25+White*1.5+Tan)/5.5]
      [1.0 (LightWood+Gold*2.25+White*1.5+Tan)/4.5]
    }
    turbulence 0.2
    warp{
      black_hole
      0, 0.5
      strength 3.5
      repeat <1.5,1.5,2>
      turbulence 0.5
      inverse
    }
    scale <0.15,0.15,1>
  }
  finish{
    ambient 0.05
    diffuse 0.65
    //specular 0.3
    //roughness 0.01
  }
}
#declare Rope_Texture =
texture{
  pigment{ color MediumWood/*0.75*/ }
  finish{ ambient 0.15 diffuse 0.85 }
  normal{ bumps 1 turbulence 1 }
}
#declare Steel_Texture =
texture{
  pigment{ color Gray65 }
  finish{
    metallic
    ambient 0.15
    diffuse 0.85
    specular 0.2
    roughness 0.1
  }
  normal{ wrinkles 0.1 turbulence 1 }
}
/***************************************************************************/
#declare Bench_Seat =
union{
  box{ <0,3,0.1>, <1,2.75,0.9> }
  box{ <0,3,1.1>, <1,2.75,1.9> }
  box{ <0,3,2.1>, <1,2.75,2.9> }
  box{ <0,0,0.1>, <1,-0.25,0.9> rotate <45,0,0> translate <0,3,3.1> }
  scale <15,1,1>
  texture{ Bench_Texture rotate <0,90,0> }
}
/***************************************************************************/
#declare Bench_Back =
union{
  box{ <0,3.1,0>, <1,3.9,-0.25> }
  box{ <0,4.1,0>, <1,4.9,-0.25> }
  box{ <0,5.1,0>, <1,5.9,-0.25> }
  box{ <0,6.1,0>, <1,6.9,-0.25> }
  scale <15,1,1>
  texture{ Bench_Texture rotate <0,90,0> }
}
/***************************************************************************/
#declare Bench_Frame =
union{
  union{					//supports back
    box{ <0.5,7,-0.25>, <1.25,2.75,-0.5> }
    box{ <14.5,7,-0.25>, <13.75,2.75,-0.5> }
    texture{ Bench_Texture rotate <90,0,0> }
  }
  union{					//supports seat
    box{ <0.5,2.75,-0.25>, <1.25,2.5,3> }
    box{ <14.5,2.75,-0.25>, <13.75,2.5,3> }
    texture{ Bench_Texture }
  }
}
/***************************************************************************/
//				The Arms
#declare Arms =
union{
  union{				//left arm
    box{ <0.5,5,0>, <1.25,4.75,3> }
    difference{
      cylinder{ <0.5,3,3>,<1.25,3,3>, 2 }
      cylinder{ <0,3,3>,<16,3,3>, 1.75 }
      box{ <0,4.75,-10>, <16,-10,3> }
      box{ <0,0,-10>, <16,-10,5> rotate <-45,0,0> translate <0,3,3> }
    }
    box{ <0.5,4.75,3>, <1.25,3,2.75>
      texture{ Bench_Texture rotate <90,0,0> }
    }
  }
  union{				//right arm
    box{ <0.5,5,0>, <1.25,4.75,3> }
    difference{
      cylinder{ <0.5,3,3>,<1.25,3,3>, 2 }
      cylinder{ <0,3,3>,<16,3,3>, 1.75 }
      box{ <0,4.75,-10>, <16,-10,3> }
      box{ <0,0,-10>, <16,-10,5> rotate <-45,0,0> translate <0,3,3> }
    }
    box{ <0.5,4.75,3>, <1.25,3,2.75>
      texture{ Bench_Texture rotate <90,0,0> }
    }
    translate <13.25,0,0>
  }
  texture{ Bench_Texture }
  translate <0,-0.1,0>
}
/***************************************************************************/
//				The Ropes
#declare T = 0.15
#declare Rope_1 =
union{
  sphere{ <0,0,0>, T }
  sphere{ <0,T*01,0>, T }
  sphere{ <0,T*02,0>, T }
  sphere{ <0,T*03,0>, T }
  sphere{ <0,T*04,0>, T }
  sphere{ <0,T*05,0>, T }
  sphere{ <0,T*06,0>, T }
  sphere{ <0,T*07,0>, T }
  sphere{ <0,T*08,0>, T }
  sphere{ <0,T*09,0>, T }
  sphere{ <0,T*10,0>, T }
  sphere{ <0,T*11,0>, T }
  sphere{ <0,T*12,0>, T }
  sphere{ <0,T*13,0>, T }
  sphere{ <0,T*14,0>, T }
  sphere{ <0,T*15,0>, T }
  sphere{ <0,T*16,0>, T }
  sphere{ <0,T*17,0>, T }
  sphere{ <0,T*18,0>, T }
  sphere{ <0,T*19,0>, T }
  sphere{ <0,T*20,0>, T }
  sphere{ <0,T*21,0>, T }
  sphere{ <0,T*22,0>, T }
  sphere{ <0,T*23,0>, T }
  sphere{ <0,T*24,0>, T }
  sphere{ <0,T*25,0>, T }
  sphere{ <0,T*26,0>, T }
  sphere{ <0,T*27,0>, T }
  sphere{ <0,T*28,0>, T }
  sphere{ <0,T*29,0>, T }
  scale <1,1/(T*29),1>
}  
#declare R_Rope =
union{
  torus{ 0.2, 0.05 rotate <90,0,0> translate <0.875,5.25,2.875>
    texture{ Steel_Texture }
  }
  torus{ 0.2, 0.05 rotate <90,0,0> translate <0.875,7.25,-0.375>
    texture{ Steel_Texture }
  }
  //cylinder{ <0.875,5.5,2.875>,<0.875,9,1>, 0.15 }
  object{ Rope_1		//front
    scale <1,4.0721,1>
    rotate <-26.565,0,0>
    translate <0.875,5.5,2.875>
  }
  object{ Rope_1		//back
    scale <1,2.0284,1>
    rotate <45,0,0>
    translate <0.875,7.5,-0.375>
  }
  object{ Rope_1		//straight down
    scale <1,6,1>
    translate <0.875,9,1>
  }
  texture{ Rope_Texture }
  translate <13.25,0,0>
}
/***************************************************************************/
#declare Bench =
union{
  object{ Bench_Seat }
  object{ Bench_Back }
  object{ Bench_Frame }
  object{ Arms }
  object{ R_Rope }
}
/***************************************************************************/
