/***************************************************************************/
//		chair.inc
/***************************************************************************/
#declare Wicker_Texture =
texture{
  pigment{ color (Flesh+Wheat)/2 }
  finish{
    ambient 0.125
    diffuse 0.75
    specular 0.2
    roughness 0.04
  }
}
#declare Chair_Texture =
texture{
  pigment{
    wood
    ramp_wave
    color_map{
      [0.0 (LightWood+Gold*2.25+White*1.5+Tan)/4.5]
      [0.4 (LightWood+Gold*2.25+White*1.5+Tan)/4.5]
      [0.9 (LightWood+Gold*2.25+White*1.5+Tan)/5.5]
      [1.0 (LightWood+Gold*2.25+White*1.5+Tan)/4.5]
//      [0.0 (LightWood+Gold*1.5+White*1.5+Tan)/4.5]
//      [0.4 (LightWood+Gold*1.5+White*1.5+Tan)/4.5]
//      [0.9 (LightWood+Gold*1.5+White*1.5+Tan)/5.5]
//      [1.0 (LightWood+Gold*1.5+White*1.5+Tan)/4.5]
    }
    turbulence 0.2
    warp{
      black_hole
      0, 0.5
      strength 3.5
      repeat <1.5,1.5,2>
      turbulence 0.5
      inverse
    }
    scale <0.15,0.15,1>
  }
  finish{
    ambient 0.05
    diffuse 0.65
    //specular 0.3
    //roughness 0.01
  }
}
/***************************************************************************/
//				The Seat
#declare Seat =
union{
  union{
    box{ <2,3,2>, <1.75,2.5,-1.75> }	//right side
    box{ <-2,3,2>, <-1.75,2.5,-1.75> }	//left side
    texture{ Chair_Texture }
  }
  union{
    box{ <2,3,2>, <-2,2.5,1.75> }	//front side
    box{ <1.75,3,-2>, <-1.75,2.5,-1.75> }	//back side
    texture{ Chair_Texture rotate <0,90,0> }
  }
  height_field{ gif "weave04.gif"
    water_level 0.25
    translate <-0.5,0,-0.5>
    scale <3.5,0.01,3.5>
    texture{ Wicker_Texture }
    translate <0,2.99,0>
  }
}
/***************************************************************************/
//				The Backing
//			(ordered from top -> bottom)
#declare Back =
union{
  union{					//curved top section
    cylinder{ <1.75,7.5,-1.875>,<-1.75,7.5,-1.875>, 0.125 }
    box{ <1.75,7.5,-2>, <-1.75,7.25,-1.75> }
    texture{ Chair_Texture rotate <0,90,0> }
  }
  height_field{ gif "weave02.gif"	//the weave backing
    water_level 0.25
    translate <-0.5,0,0>
    rotate <90,0,0>
    scale <3.5,2.75,0.01>
    texture{ Wicker_Texture }
    translate <0,7.25,-1.76>
  }
  difference{				//weave "casing"
    box{ <1.75,7.25,-2>, <-1.75,4.25,-1.75> }
    box{ <1.5,7.5,-3>, <-1.5,4.5,1> }	//cuts vertically
    box{ <2,7,-3>, <-2,4.75,1> }	//cuts horizontally
    cylinder{ <1.5,7,-3>,<1.5,7,1>, 0.25 }	//right set
    cylinder{ <1.5,4.75,-3>,<1.5,4.75,1>, 0.25 }
    cylinder{ <-1.5,7,-3>,<-1.5,7,1>, 0.25 }	//left
    cylinder{ <-1.5,4.75,-3>,<-1.5,4.75,1>, 0.25 }
    texture{ Chair_Texture rotate <0,90,0> }
  }
  union{					//right leg
    cylinder{ <2,7.5,-1.875>,<1.75,7.5,-1.875>, 0.125 }
    box{ <2,7.5,-2>, <1.75,0/*2.5*/,-1.75> }
    texture{ Chair_Texture rotate <90,0,0> }
  }
  union{					//left leg
    cylinder{ <-2,7.5,-1.875>,<-1.75,7.5,-1.875>, 0.125 }
    box{ <-2,7.5,-2>, <-1.75,0/*2.5*/,-1.75> }
    texture{ Chair_Texture rotate <90,0,0> }
  }
}
/***************************************************************************/
//				The Front Legs
#declare Front_Leg =
union{
  box{ <0.3,3.1,0.3>, <-0.3,2.4,-0.3> }
  lathe{
    cubic_spline
    8,
    <0.275,2.5>,
    <0.275,2.4>,
    <0.275,2.2>,
    <0.15,2.0>,
    <0.15,2.0>,
    <0.25,1.6>,
    <0.125,0>,
    <0,0>
  }
  texture{ Chair_Texture rotate <90,0,0> }
  scale <0.75,1,0.75>
}
#declare Front_Legs =
union{
  object{ Front_Leg translate <1.75+0.1,0,1.75+0.1> }
  object{ Front_Leg translate <-1.75-0.1,0,1.75+0.1> }
}
/***************************************************************************/
//			The Arms
#declare R_Arm =
union{
  box{ <2,5,-2>, <1.75,4.75,1> }
  difference{
    cylinder{ <2,4,1>,<1.75,4,1>, 1 }
    cylinder{ <3,4,1>,<1,4,1>, 0.75 }
    box{ <5,4,5>, <-5,0,-5> }
    box{ <5,5,1>, <-5,0,-5> }
  }
  difference{
    sphere{ <1.875,4,1.875>, 0.125*1.4142 }
    box{ <2,5,5>, <3,0,-5> }
    box{ <-2,5,5>, <-3,0,-5> }
    box{ <3,5,1.75>, <-3,0,1> }
    box{ <3,5,2>, <-3,0,3> }
  }
  union{
    sphere{ <1.875,0,1.875>, 0.125 }
    sphere{ <1.875,-0.25,1.875>, 0.125 }
    sphere{ <1.875,-0.5,1.875>, 0.125 }
    sphere{ <1.875,-0.75,1.875>, 0.125 }
    translate <0,3.875,0>
    texture{ Chair_Texture rotate <90,0,0> }
  }
  texture{ Chair_Texture }
}
#declare L_Arm =
object{ R_Arm scale <-1,1,1> }
/***************************************************************************/
//			Bar Things Under The Chair
#declare Bars =
union{
  sphere{ <0,0,0>, 1 scale <1.875,0.125,0.125> translate <0,1,0>
    texture{ Chair_Texture rotate <0,90,0> }
  }
  sphere{ <0,0,0>, 1 scale <0.125,0.125,1.875> translate <1.875,1,0> }
  sphere{ <0,0,0>, 1 scale <0.125,0.125,1.875> translate <-1.875,1,0> }
  texture{ Chair_Texture }
}  
/***************************************************************************/
#declare Chair =
union{
  //box{ <2,7.25,-1.75>, <-2,4.25,-2> }	//chair backing
  //box{ <2,3,2>, <-2,2.5,-2> }		//seat
  //box{ <2,2.5,2>, <1.75,0,1.75> rotate <0,90,0> }	//back leg
  //box{ <2,2.5,2>, <1.75,0,1.75> rotate <0,180,0> }	//back leg
  //box{ <2,2.5,2>, <1.75,0,1.75> rotate <0,270,0> }	//front leg
  //box{ <2,2.5,2>, <1.75,0,1.75> rotate <0,360,0> }	//front leg
  object{ Back }
  object{ Seat }
  object{ Front_Legs }
  object{ R_Arm }
  object{ L_Arm }
  object{ Bars }
  //texture{ Chair_Texture rotate <90,0,0> }
}
/***************************************************************************/
