/***************************************************************************/
//		porch.inc
/***************************************************************************/
//			The Textures
#declare White_Paint =
texture{
  pigment{
    bozo
    color_map{
      [0.0 rgb 1]
      [0.5 rgb 1]
      [0.5 rgb 0.97]
      [1.0 rgb 0.97]
    }
    turbulence 1
    omega 0.65
    lambda 2
    scale <10,10,10>
  }
  finish{ ambient 0.05 diffuse 0.8 crand 0.015 }
  /*normal{
    dents 0.15
    turbulence 1.25
    omega 0.75
    octaves 6
    lambda 2
    scale <1,3,1>/2
  }*/
  normal{
    bumps 0.1
    turbulence 1.25
    omega 0.5
    octaves 3
    lambda 2
    scale <0.1,0.4,0.1>
  }
}
#declare Floor_Texture =
texture{
  pigment{
    bozo
    color_map{
      [0.0 Red]
      [0.5 Red]
      [1.0 Red*0.9]
    }
    turbulence 1
    omega 0.75
    lambda 3
  }
  normal{ wrinkles 0.15 turbulence 1 }
}
#declare Wood_Texture =
texture{
  pigment{
    wood
    ramp_wave
    color_map{
      [0.0 LightWood*0.85]
      [0.3 LightWood*0.85]
      [0.7 MediumWood*1.15]
      [0.9 DarkWood*1.15]
      [1.0 LightWood*0.85]
    }
    scale <0.1,0.1,1>
    turbulence 0.1
    octaves 4
    omega 0.35
    warp{
      black_hole
      <0,0.5,0>, 1
      strength 4
      repeat <3,3,3>
      turbulence 1
      inverse
    }
    warp{
      black_hole
      <0,0.5,0>, 1
      strength 4
      repeat <4,4,4>
      turbulence 1
      inverse
    }
  }
  finish{ ambient 0.05 diffuse 0.6 }
  normal{
    bumps 0.2
    turbulence 0.35
    omega 0.65
    lambda 3
    scale <0.1,0.1,0.75>
  }
}
/***************************************************************************/
//				The Floor
#declare Floor =
height_field{ gif "floor3.gif"
  translate <0,-1,0>
  scale <35,0.5,20>
  translate <0,0,-5>
  texture{ Wood_Texture }
}
#declare Metal_Railing_Texture =
texture{
  pigment{ Gray25 }
  finish{ ambient 0.15 diffuse 0.85 }
  normal{ bumps 0.1 scale 0.1 }
}
/***************************************************************************/
//				The Ceiling
#declare Ceiling =
//union{
  height_field{ gif "floor3.gif"
    //water_level 0.75
    scale <37,0.5,-20>
    rotate <180,0,0>
    translate <-1,16,-4>
/*  }
  box{ <0,15.6,0>, <35,15.6,16>
    pigment{ White filter 0.4 }
  }*/
  texture{ White_Paint }
}
/***************************************************************************/
//				The Steps
#declare Step =
union{
  box{ <10,0,15>, <25,-1.5,15.9> }
  box{ <10,0,16>, <25,-1.5,17.25> }
}
#declare Steps =
union{
  object{ Step translate <0,0,0> }
  object{ Step translate <0,-2,2> }
  object{ Step translate <0,-4,4> }
  object{ Step translate <0,-6,6> }
  texture{ Wood_Texture rotate <0,90,0> }
}
/***************************************************************************/
//				The Step Railing
#declare Step_Railing =
union{
  union{
    box{ <0.5,0.1,0>, <0,-0.15,8*1.4142> translate <10,0,0> }
    box{ <-0.5,0.1,0>, <0,-0.15,8*1.4142> translate <25,0,0> }
    rotate <45,0,0>
    translate <0,5,15>
  }
  union{
    box{ <0.3,0,0.1>, <0,4,-0.1> translate <10.1,-0,16> }
    box{ <0.3,0,0.1>, <0,4,-0.1> translate <10.1,-2,18> }
    box{ <0.3,0,0.1>, <0,4,-0.1> translate <10.1,-4,20> }
    box{ <0.3,0,0.1>, <0,4,-0.1> translate <10.1,-6,22> }
  }
  union{
    box{ <-0.3,0,0.1>, <0,4,-0.1> translate <24.9,-0,16> }
    box{ <-0.3,0,0.1>, <0,4,-0.1> translate <24.9,-2,18> }
    box{ <-0.3,0,0.1>, <0,4,-0.1> translate <24.9,-4,20> }
    box{ <-0.3,0,0.1>, <0,4,-0.1> translate <24.9,-6,22> }
  }
  texture{ Metal_Railing_Texture }  
}  
/***************************************************************************/
//				The Column
//		(parts are ordered from top -> down )
#declare Column =
union{
  box{ <1,25,1>, <-1,20,-1> }
  difference{
    sphere{ 0, 1 scale <1.4142,0.5,1.4142> translate <0,20,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,90,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,180,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,270,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,360,0> }
  }
  torus{ 0.5, 0.1 translate <0,19.5,0> }
  cylinder{ <0,20,0>,<0,18,0>, 0.5 }
  sphere{ <0,18,0>, 1 }
  torus{ 0.5, 0.15 translate <0,17,0> }
  difference{
    sphere{ 0, 1 scale <1.4142,1.4142,1.4142> translate <0,16,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,90,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,180,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,270,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,360,0> }
  }
  difference{
    box{ <1,16,1>, <-1,10,-1> }
    cylinder{ <1,0,1.4142>,<-1,0,1.4142>, 0.35 scale <1,3,1> rotate <0,45,0> translate <0,10,0> }
    cylinder{ <1,0,1.4142>,<-1,0,1.4142>, 0.35 scale <1,3,1> rotate <0,135,0> translate <0,10,0> }
    cylinder{ <1,0,1.4142>,<-1,0,1.4142>, 0.35 scale <1,3,1> rotate <0,225,0> translate <0,10,0> }
    cylinder{ <1,0,1.4142>,<-1,0,1.4142>, 0.35 scale <1,3,1> rotate <0,315,0> translate <0,10,0> }
  }
  //box{ <0.5,10,0.5>, <-0.5,8,-0.5> }
  sphere{ 0, 1 scale <0.65,2,0.65> translate <0,9,0> }
  sphere{ <0,8,0>, 1 }
  difference{
    sphere{ 0, 1 scale <1.4142,1.4142,1.4142> translate <0,6,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,90,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,180,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,270,0> }
    box{ <2.001,25,1>, <-2.001,0,2> rotate <0,360,0> }
  }
  box{ <1,6,1>, <-1,-10,-1> }
  texture{ White_Paint }
  scale <0.5,0.5,0.5>
  translate <0,3,0>
}
/***************************************************************************/
//			The Curved Support Thing
#declare Curve =
union{
  difference{
    box{ <1,0,0>, <-1,-2,4> }
    cylinder{ <1.5,-2,4>,<-1.5,-2,4>, 2 }
  }
  cylinder{ <1,-2,0>,<-1,-2,0>, 2 }
  cylinder{ <1,0,0>,<-1,0,0>, 0.5 scale <1,2,1> translate <0,-4,0> }
  scale <0.35,0.5,0.5>
  translate <0,15.5,0>
  texture{ White_Paint }
}
/***************************************************************************/
//				The Railing
#declare Railing =
union{
  cylinder{ <0,0,0>,<0,0,1>, 0.5 scale <1,0.5,1> translate <0,5.75,0> }
  box{ <0.5,5.75,0>, <-0.5,5.5,1> }
  cylinder{ <0,0,0>,<0,0,1>, 0.5 scale <1,0.5,1> translate <0,5.5,0> }
  box{ <0.25,5.5,0>, <-0.25,5,1> }
}
/***************************************************************************/
//				The Posts
#declare Post =
box{ <0.25,5,0.25>, <-0.25,0,-0.25> }
#declare Front_Posts =
union{
  object{ Post translate <1+1.41,0,14.5> }	//left set
  object{ Post translate <1+2.83,0,14.5> }
  object{ Post translate <1+4.25,0,14.5> }
  object{ Post translate <1+5.66,0,14.5> }
  object{ Post translate <1+7.08,0,14.5> }

  object{ Post translate <25.5+1.41,0,14.5> }	//right set
  object{ Post translate <25.5+2.83,0,14.5> }
  object{ Post translate <25.5+4.25,0,14.5> }
  object{ Post translate <25.5+5.66,0,14.5> }
  object{ Post translate <25.5+7.08,0,14.5> }
  
  texture{ White_Paint }
}
#declare Side_Posts =
union{
  union{
    object{ Post translate <0,0,1+1.41> }
    object{ Post translate <0,0,1+2.83> }
    object{ Post translate <0,0,1+4.25> }
    object{ Post translate <0,0,1+5.66> }
    object{ Post translate <0,0,1+7.08> }
    object{ Post translate <0,0,1+8.50> }
    object{ Post translate <0,0,1+9.91> }
    object{ Post translate <0,0,1+11.33> }
    object{ Post translate <0,0,1+12.75> }
    object{ Post translate <0,0,1+14.16> }
    object{ Post translate <0,0,1+15.58> }
    object{ Post translate <0,0,1+17.00> }
    object{ Post translate <0,0,1+18.41> }
    rotate <0,180,0>
    translate <0.5,0,15>
  }
  union{
    object{ Post translate <0,0,1+1.41> }
    object{ Post translate <0,0,1+2.83> }
    object{ Post translate <0,0,1+4.25> }
    object{ Post translate <0,0,1+5.66> }
    object{ Post translate <0,0,1+7.08> }
    object{ Post translate <0,0,1+8.50> }
    object{ Post translate <0,0,1+9.91> }
    object{ Post translate <0,0,1+11.33> }
    object{ Post translate <0,0,1+12.75> }
    object{ Post translate <0,0,1+14.16> }
    object{ Post translate <0,0,1+15.58> }
    object{ Post translate <0,0,1+17.00> }
    object{ Post translate <0,0,1+18.41> }
    rotate <0,180,0>
    translate <34.5,0,15>
  }

  texture{ White_Paint }
  translate <0,0,-0.16>
}
/***************************************************************************/
#declare Porch =
union{
  object{ Floor }
  object{ Ceiling }
  object{ Steps }
  //object{ Step_Railing }
  object{ Column translate <0.5,0,14.5> }
  object{ Column translate <10,0,14.5> }
  object{ Column translate <25,0,14.5> }
  object{ Column translate <34.5,0,14.5> }
  object{ Curve rotate <0,180,0> translate <0.5,0,14> }
  object{ Curve rotate <0,90,0> translate <1,0,14.5> }
  object{ Curve rotate <0,-90,0> translate <9.5,0,14.5> }
  object{ Curve rotate <0,90,0> translate <10.5,0,14.5> }
  object{ Curve rotate <0,-90,0> translate <24.5,0,14.5> }
  object{ Curve rotate <0,90,0> translate <25.5,0,14.5> }
  object{ Curve rotate <0,-90,0> translate <34,0,14.5> }
  object{ Curve rotate <0,180,0> translate <34.5,0,14> }
  union{
    object{ Railing scale <1,1,24> translate <0.5,0,-10> }
    object{ Railing scale <1,1,9.5> rotate <0,90,0> translate <0.5,0,14.5> }
    object{ Railing scale <1,1,9.5> rotate <0,90,0> translate <25,0,14.5> }
    object{ Railing scale <1,1,24> translate <34.5,0,-10> }
    texture{ White_Paint }
  }
  object{ Front_Posts }
  object{ Side_Posts }
  translate <-35/2,0,0>
}
