/***************************************************************************/
//		table.inc
/***************************************************************************/
#declare Glass_Texture =
texture{
  pigment{ SeaGreen filter 0.1 transmit 0.8 quick_color White }
  finish{
    ambient 0.05
    diffuse 0.75
    specular 0.5
    roughness 0.02
    reflection 0.065
    refraction 1
    ior 2.5
  }
}
#declare Leg_Texture =
texture{
  pigment{ color (White+Silver)/2 }
  finish{
    metallic
    ambient 0.15
    diffuse 0.85
    reflection 0.5
    brilliance 1.5
  }
}
/***************************************************************************/
//				The Table Top
#declare Table_Top =
merge{
  cylinder{ <0,5,0>,<0,4.75,0>, 3.75 }
  torus{ 3.75, 0.125 translate <0,4.875,0> }
  texture{ Glass_Texture }
}
/***************************************************************************/
//				The Legs
#declare Leg =
difference{
  torus{ 2.25, 0.125 rotate <90,0,0> }
  box{ <0,10,10>, <10,-10,-10> }
  translate <2.5,2.375,0>
}
#declare Legs =
union{
  object{ Leg rotate <0,120,0> }
  object{ Leg rotate <0,240,0> }
  object{ Leg rotate <0,360,0> }
  torus{ 0.375, 0.125 translate <0,2.375,0> }
  texture{ Leg_Texture }
}
/***************************************************************************/
//				The Table
#declare Table =
union{
  object{ Table_Top }
  object{ Legs }
}
