/****************************************************************************
**                                                                         **
**  Title:  "Scilly Sunset"                                                **
**  Artist: Robert Oxspring (fc60@cityscapy.co.uk)                         **
**                                                                         **
**  Notes:  The scene was based on a photo taken in the Scilly Islands     **
**          (SW England).  The sky is heavily inspired by the SUNSET3.POV  **
**          sample file given away with povray 3.0.                        **
**                                                                         **
****************************************************************************/

#include "colors.inc"
#include "textures.inc"
#include "glass.inc"

camera{
  location <0,1,-15>
  look_at <0,1,0>
  rotate y*25
  }

// Light from the sun

light_source{<0,0,1000> color rgb<1,.6,.2>}

// Sea, just a trial and error thing

plane{y,-2  
  texture{
    pigment{
      rgbf<.5,.5,.8,.7>
      } 
    finish{
      refraction 1 
      ior 1.33 
      reflection .3
      } 
    normal{
      average
      normal_map {
        [ripples 0.2 frequency 5]
        [wrinkles 0.2]
        }
      }
    }
  }

// Sky, inspired heavily by SUUNSET3.POV
sky_sphere{
  pigment {
    wrinkles
    color_map {
      [0.0 color Orange]
      [0.1 color Orange ]
      [0.6 color SlateBlue * 0.25]
      [1.0 color SkyBlue]
      }
    scale <0.5, 0.1, 500>
    }
  pigment{
    wood
    color_map{
      [0.05 Yellow]
      [0.10 Orange]
      [0.15 Orange filter 1]
      [0.20 White filter 1]
      }
    scale <2,1.5,2>
    }
  }

// Boat, main shape
#declare BOAT=union{
  difference{
    merge{
      intersection{
        cylinder{<-2,0,0> <-2,0,10> 5}
        cylinder{< 2,0,-1> < 2,0,11> 5}
        }
     intersection{
        sphere{<-2,0,0> 5}
        sphere{< 2,0,0> 5}
        }
      }
    merge{
      intersection{
        cylinder{<-2,0,0> <-2,0,9.8> 4.8}
       cylinder{< 2,0,-1> < 2,0,11> 4.8}
        }
      intersection{
        sphere{<-2,0,0> 4.8}
        sphere{< 2,0,0> 4.8}
        }
      }
    plane{-y,0 rotate x*2}
    cylinder{<-5,-.8,-4> <5,-.8,-4> .2}
    cylinder{<-5,-.8,-2> <5,-.8,-2> .2}
    cylinder{<-5,-.8, 0> <5,-.8, 0> .2}
    cylinder{<-5,-.8, 2> <5,-.8, 2> .2}
    cylinder{<-5,-.8, 4> <5,-.8, 4> .2}
    cylinder{<-5,-.8, 6> <5,-.8, 6> .2}
    cylinder{<-5,-.8, 8> <5,-.8, 8> .2}
    pigment{
      gradient y 
      color_map{
        [0.1 White]
        [0.1 Red]
        [1.0 Red*.5]
        }
      scale 3
      rotate x*2
      }
    }
  intersection{
    merge{
      intersection{
        cylinder{<-2,0,0> <-2,0,10> 4.8}
        cylinder{< 2,0,-1> < 2,0,11> 4.8}
        }
      intersection{
        sphere{<-2,0,0> 4.8}
        sphere{< 2,0,0> 4.8}
        }
      }
    plane{y,-1 texture{DMFLightOak}}
    }
  }

// Boats Cabin, with radar on top.
#declare CABIN=union{
  box{<-1.7,1.5,-1.4> <1.7,1.6,2.2> pigment{color Red}}
  difference{
    box{<-1.5,-1,-1> <1.5,1.5,2>}
    box{<-1.4,-.8,-.9> <1.4,1.4,1.9>}
    box{<-1.6,-.8,-.9> <1.6,1.4,-.1>}
    box{<-1.3,0,-2.9> <-.1,1.2,1>}
    box{< .1,0,-2.9>  <1.3,1.2,1>}
    pigment{White}
    }
  box{<-1.48,-1,-.98> <1.48,1.5,-.92> texture{T_Glass1}}
  
  light_source{<-1.3,1.3,-.8> color White*.3}
  light_source{<   0,1.3,-.8> color White*.3}
  light_source{< 1.3,1.3,-.8> color White*.3}

  union{
    cylinder{<0,1.5,0> <0,2,0> .1}
    cylinder{<0,2,0> <0,2.2,0> .5}
    torus{.5,.1 translate <0,2.1,0>}
    pigment{White}
    }
  }

// Island, couldn't model the islands, so I used a fractint plasma instead.
height_field{
  gif "land.gif"
  water_level .7
  translate y*-.7
  smooth
  scale <100,25,100>
  translate -y*2
  rotate 90
  translate <0,0,100>
  texture{
    gradient y
    texture_map{
      [0.00 pigment{granite color_map{[0 Yellow] [1 .5*Yellow]}}]
      [0.05 pigment{granite color_map{[0 DarkTan] [1 .5*Yellow]}}]
      [0.10 pigment{DarkTan}]
      [0.5 pigment{Green*.5}]
      [1.0 pigment{Green}]
      }
    scale 10
    translate y*-2
    }
  }

// Complete Boat, mini life raft + rubber tyre floats.
union{
  object{ BOAT }
  object{ CABIN translate <0,0,-1> }
  union{
    torus{.25,.1 rotate z*90 translate <-3,-1, 8>}torus{.25,.1 rotate z*90 translate < 3,-1, 8>}
    torus{.25,.1 rotate z*90 translate <-3,-1, 6>}torus{.25,.1 rotate z*90 translate < 3,-1, 6>}
    torus{.25,.1 rotate z*90 translate <-3,-1, 4>}torus{.25,.1 rotate z*90 translate < 3,-1, 4>}
    torus{.25,.1 rotate z*90 translate <-3,-1, 2>}torus{.25,.1 rotate z*90 translate < 3,-1, 2>}
    torus{.25,.1 rotate z*90 translate <-3,-1, 0>}torus{.25,.1 rotate z*90 translate < 3,-1, 0>}
    pigment{Gray20}
    }
  cylinder{<-1,-.4,9> <1,-.4,9> .4 pigment{Gray80}}
  translate y*-.5
  }
