// "Summer Night"
// (c) 1996 by Edward Wedig
// Created August 1996

#include "shapes.inc"

camera {
        location <0,0.2,0>
        up <0,1.33,0>
        right <1,0,0>
        look_at <2,4,5>
        }

// Mountains
height_field {gif "bumpmap_.gif"
                        texture {
                        pigment
                                {granite
                                turbulence 0.5
                                color_map
                                {[0.000, 0.153  color rgbf <0.439, 0.310, 0.282, 0.000>
                                                color rgbf <0.463, 0.369, 0.259, 0.000>]
                                [0.153, 0.398   color rgbf <0.463, 0.369, 0.259, 0.000>
                                                color rgbf <0.541, 0.369, 0.298, 0.000>]
                                [0.398, 0.559   color rgbf <0.541, 0.369, 0.298, 0.000>
                                                color rgbf <0.573, 0.424, 0.286, 0.000>]
                                [0.559, 0.729   color rgbf <0.573, 0.424, 0.286, 0.000>
                                                color rgbf <0.494, 0.396, 0.306, 0.000>]
                                [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.000>
                                                color rgbf <0.439, 0.310, 0.282, 0.000>]
                                }
                                }
                                }
                finish {ambient 0.05}
                scale <10,1,10>
                translate <-5,0,0>
                }

// Sky
sphere{
        <0,0,0>, 100
        pigment {
        radial
        color_map {
        [ 0.15 color red 0.117 green 0.082 blue 0.243 filter 0.99]
        [ 0.25 color red 0.448 green 0.246 blue 0.448 filter 0.0]
        [ 0.35 color red 0.855 green 0.503 blue 0.445]
        [ 0.75 color red 0.855 green 0.503 blue 0.445]
        [ 0.85 color red 0.448 green 0.246 blue 0.448 filter 0.0]
        [ 0.95 color red 0.117 green 0.082 blue 0.243 filter 0.99]
        }
        turbulence 0.4
        }
        finish {ambient 1.0}
        rotate <0,0,90>
        rotate <0,25,0>
        }

plane { y, -0.5
        pigment {color red 0 green 0 blue 0}
        }
// Moon
sphere {
        <0,250,150>, 15
        pigment {
                bozo
                turbulence 1.0
                colour_map {
                [0.0 0.4 colour red 0.5 green 0.5 blue 0.5
                        colour red 1.0 green 1.0 blue 1.0 ]
                [0.4 0.9 colour red 1.0 green 1.0 blue 1.0
                        colour red 0.2 green 0.2 blue 0.1]
                [0.9 1.0 colour red 0.2 green 0.2 blue 0.1
                        colour red 1.0 green 1.0 blue 1.0]
                        }
                scale <6.0, 6.0, 6.0>
                rotate <30.0, 0.0, -45.0>
                }
        finish {
                reflection 0.1
                diffuse 1.0
                }
        }

light_source {
        <200,10,400>
        color red 1.0 green 0.65 blue 0.2
        spotlight
        point_at <0,250,150>
        radius 20
        falloff 20
        tightness 50
        }

light_source {
        <200,10,400>
        color red 0.25 green 0.85 blue 0.2
        spotlight
        point_at <0,250,150>
        radius 20
        falloff 20
        tightness 50
        }

light_source {
        <200,10,400>
        color red 0.25 green 0.85 blue 0.2
        spotlight
        point_at <0,250,150>
        radius 20
        falloff 20
        tightness 50
        }

