// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "METALS.INC"
#include "golds.inc"

#include "caller.pov"
#include "module.pov"
#include "worm.pov"


camera {
        location <0,2000,-7000>
        look_at  <0,500,0>
}

#declare Sun= red 1.1 green 1.0 blue 1.0

light_source {<100000,20000,-10000> color Sun}
light_source {<0,4000,-7000> color Gray20}

#declare Dune=
height_field {tga "dune.tga" smooth water_level .1 translate<-.5,0,-.5>}

#declare Dunes=
height_field {tga "dunes.tga" smooth translate <-.5,0,-.5>}

#declare Mount=
height_field {tga "mount.tga" smooth translate <-.5,0,-.5>}

object {Dune scale<8000,800,8000> translate<0,0,-4500>
texture{pigment{
granite
color_map {
[0.0 rgb <1.0,0.7,0.2>]
[0.2 rgb <1.0,0.75,0.1>]
[0.5 rgb <1.0,0.8,0.2>]
[0.8 rgb <1.0,0.75,0.1>]
[1.0 rgb <1.0,0.7,0.15>]
}
scale 500
turbulence .5
}}
finish {phong .1 crand .3}
}

object {Dunes scale<26000,800,16000> translate<0,-300,4500>
texture{pigment{
bozo
color_map {
[0.0 rgb <1.0,0.7,0.2>]
[0.2 rgb <1.0,0.75,0.1>]
[0.5 rgb <1.0,0.8,0.2>]
[0.8 rgb <1.0,0.75,0.1>]
[1.0 rgb <1.0,0.7,0.15>]
}
scale 4000
turbulence .5
}}
normal {bumps .5 scale <200,1,200>}
finish {phong .1}
}

object {Mount scale<40000,3500,20000> translate<0,-600,12000>
texture{pigment{
granite
color_map {
[0.0 rgb <.8,.6,.2>]
[0.4 rgb <.6,.3,.1>]
[0.8 rgb <1,.9,.3>]
[1.0 rgb <.9,.6,.1>]
}
scale <30,10,10>
}}
finish {phong .1}
normal {wrinkles .75 scale <30,10,10> rotate<0,45,0>}
}

sky_sphere {pigment{gradient y
    color_map {
    [0.0 rgb <1,1,.6>]
    [1.0 rgb <.2,.2,1>]
    }
    }
}

object {Caller scale .6 translate <-1000,500,-4800>}
object {Caller scale .6 rotate <0,0,-20> translate <-800,500,-4400>}
object {Caller scale .6 rotate <0,0,-10> translate <-900,500,-5100>}
object {Caller scale .6 rotate <0,0,5> translate <-1300,500,-4400>}
object {Caller scale .6 rotate <0,0,-25> translate <-1500,500,-5100>}

object {Module translate <-700,600,-5000>}

object {Worm scale 240 rotate <0,-30,0> translate <200,-250,-2000>}
