
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

camera {
       location <0,0,-100>
       look_at  <0,0,0>
}

light_source {<0,0,-100>
    color White
    spotlight
    point_at <0,0,0>
    radius 80
    falloff 20
    tightness 50
    }
light_source {<-30,-10,-100>
    color White
    spotlight
    point_at <-30,-10,0>
    radius 80
    falloff 20
    tightness 50
    }
light_source {<30,0,-100>
    color White
    spotlight
    point_at <30,0,0>
    radius 80
    falloff 20
    tightness 50
    }

box {<1000,1000,0><-1000,-1000,10>
    texture{pigment{
        marble
        color_map {
            [0.0 rgb <1,1,1>]
            [1.0 rgb <.85,.85,.85>]
        }
        scale 2
        rotate <0,0,90>
        turbulence .75
        octaves 1
        lambda 6
        omega .75
    }}
no_shadow
}

#declare Walk=
merge {
    cylinder {<0,0,1><0,0,0>,10}
    cylinder {<10,0,1><10,0,0>,7.5}
    cylinder {<6,-10,1><6,-10,0>,8}
    cylinder {<-5,12,1><-5,12,0>,12}
}

object {Walk
    scale 1.2
    texture{pigment{
        bozo
        color_map {
            [0.0 rgbf <1,1,1,.5>]
            [1.0 rgbf <.85,.85,.85,.5>]
        }
        scale 2
        rotate <0,0,45>
        turbulence .75
        octaves 1
        lambda 6
        omega .75
    }}
translate <-15,-15,0>
no_shadow
}
