
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions


camera {
    location <0,0,-6>
    look_at  <0,0,0>
}


// create a point "spotlight" (conical directed) light source
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <0, 0, -5> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  radius 8                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 16               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <1.75, 0, -5> // <x y z> position of light
  point_at <1.75, 0, 0>      // direction of spotlight
  radius 8                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 16               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-1.75, 0, -5> // <x y z> position of light
  point_at <-1.75, 0, 0>      // direction of spotlight
  radius 8                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 16               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <3.5, 0, -5> // <x y z> position of light
  point_at <3.5, 0, 0>      // direction of spotlight
  radius 8                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 16               // intensity falloff radius (outer, in degrees)
}
light_source
{
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-3.5, 0, -5> // <x y z> position of light
  point_at <-3.5, 0, 0>      // direction of spotlight
  radius 8                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 16               // intensity falloff radius (outer, in degrees)
}

box {<10,10,0><-10,-10,1>
texture{pigment{
bozo
color_map {
[0.0 rgb <1,1,1>]
[1.0 rgb <.8,.8,.8>]
}
scale .25
turbulence .3
}}
normal {wrinkles .7 scale<1,.25,.25> rotate<0,0,45>}
}   
