/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996


#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#include "typew.col"

background {color <1,1,1>}

camera {
   location <400,200,0>
   look_at <0,0,0>
}

light_source {<200,500,500> color White}
*/

#include "typew.col"

#declare Typewriter =
union {

#declare Proto1 =
union{
difference {
box {<-140,0,-150><140,80,150> }

box {<-150,-10,-160><-118.1738,90,-130>  }
box {<150,-10,-160><118.1738,90,-130>  }
box {<-150,-10,160><-95.4268,90,131.7431> }
box {<150,-10,160><95.4268,90,131.7431> }

box {<0,100,500><500,-100,-500>  rotate<0,-5,0>
    translate<138.0977,0,-128.2569>}
box {<0,100,500><-500,-100,-500>  rotate<0,5,0>
    translate<-138.0977,0,-128.2569>}
}
cylinder {<-118.1738,0,-130><-118.1738,80,-130>,20  }
cylinder {<118.1738,0,-130><118.1738,80,-130>,20  }
cylinder {<-95.4268,0,130><-95.4268,80,130>,20  }
cylinder {<95.4268,0,130><95.4268,80,130>,20  }
}

#declare Proto2 =
union{
difference {
box {<-127.1846,-20,-140><127.1846,100,130> }

box {<-140,-30,-140><-107.2607,110,-120> }
box {<140,-30,-140><107.2607,110,-120> }
box {<-140.1846,-30,140><-87.1384,110,110> }
box {<140.1846,-30,140><87.1384,110,110> }

box {<0,100,500><500,-100,-500>  rotate<0,-5,0>
    translate<127.1846,0,-118.2569>}
box {<0,100,500><-500,-100,-500>  rotate<0,5,0>
    translate<-127.1846,0,-118.2569>}
}
cylinder {<-107.2607,-20,-120><-107.2607,100,-120>,20  }
cylinder {<107.2607,-20,-120><107.2607,100,-120>,20  }
cylinder {<-87.1384,-20,110><-87.1384,100,110>,20  }
cylinder {<87.1384,-20,110><87.1384,100,110>,20  }
}

#declare Tbase =
union {
difference {
object {Proto1 pigment{Basec}finish{Basef}normal{Basen}}
object {Proto2 pigment{Basec}finish{Basef}normal{Basen}}
box {<500,30,500><-500,500,130> pigment{Basec}finish{Basef}normal{Basen}}
box {<-70.4268,15,0><70.4268,500,500> pigment{Basec}finish{Basef}normal{Basen}}
box {<500,0,0><-500,500,-500> rotate<32.0054,0,0> translate<0,30,130>
    pigment{Basec}finish{Basef}normal{Basen}}
box {<-150,500,-130><150,50,-50> pigment{Basec}finish{Basef}normal{Basen}}
box {<-150,500,-180><150,60,-130> pigment{Basec}finish{Basef}normal{Basen}}
}
box {<110,10,50><-110,80,40> pigment{Basec}finish{Basef}normal{Basen}}
difference {
object {Proto1 scale 1.01 texture{T_Chrome_3C}}
box {<500,6,500><-500,500,-500> texture{T_Chrome_3C}}
}
}

object {Tbase}

#declare Keyp =
superellipsoid {<0.3,0.1>}

#declare Key =
union {
object {Keyp scale<7.5,8.5,7.5>
texture{pigment{
granite
color_map {
    [0.0 color Gray50]
    [0.35 color Gray60]
    [0.6 color Gray50]
    [0.75 color Gray40]
    [1.0 color Gray75]
}
}}
finish{phong 1}}
box {<1,-6,-3.50><1,-34.27,3.50> pigment{Black}}
}

object {Keyp scale<65,5,10> translate<0,22.5,140>
texture{pigment{
granite
color_map {
    [0.0 color Gray50]
    [0.35 color Gray60]
    [0.6 color Gray50]
    [0.75 color Gray40]
    [1.0 color Gray75]
}
}}
finish{phong 1}
}

#declare Keygroup =
union{
object {Key translate <51.00,38.00,120.00>}
object {Key translate <0.00,38.00,120.00>}
object {Key translate <17.00,38.00,120.00>}
object {Key translate <34.00,38.00,120.00>}
object {Key translate <68.00,38.00,120.00>}
object {Key translate <85.00,38.00,120.00>}
object {Key translate <-68.00,38.00,120.00>}
object {Key translate <-85.00,38.00,120.00>}
object {Key translate <-51.00,38.00,120.00>}
object {Key translate <-34.00,38.00,120.00>}
object {Key translate <-17.00,38.00,120.00>}
object {Key translate <-93.50,50.00,100.00>}
object {Key translate <-76.50,50.00,100.00>}
object {Key translate <-8.50,50.00,100.00>}
object {Key translate <-42.50,50.00,100.00>}
object {Key translate <-59.50,50.00,100.00>}
object {Key translate <-25.50,50.00,100.00>}
object {Key translate <-17.00,62.00,80.00>}
object {Key translate <-34.00,62.00,80.00>}
object {Key translate <-51.00,62.00,80.00>}
object {Key translate <-68.00,62.00,80.00>}
object {Key translate <-85.00,62.00,80.00>}
object {Key translate <-102.00,62.00,80.00>}
object {Key translate <0.00,62.00,80.00>}
object {Key translate <-59.50,74.00,60.00>}
object {Key translate <-42.50,74.00,60.00>}
object {Key translate <-25.50,74.00,60.00>}
object {Key translate <-8.50,74.00,60.00>}
object {Key translate <-93.50,74.00,60.00>}
object {Key translate <-76.50,74.00,60.00>}
object {Key translate <25.50,50.00,100.00>}
object {Key translate <8.50,50.00,100.00>}
object {Key translate <42.50,50.00,100.00>}
object {Key translate <76.50,50.00,100.00>}
object {Key translate <59.50,50.00,100.00>}
object {Key translate <93.50,50.00,100.00>}
object {Key translate <68.00,62.00,80.00>}
object {Key translate <85.00,62.00,80.00>}
object {Key translate <102.00,62.00,80.00>}
object {Key translate <17.00,62.00,80.00>}
object {Key translate <34.00,62.00,80.00>}
object {Key translate <51.00,62.00,80.00>}
object {Key translate <93.50,74.00,60.00>}
object {Key translate <76.50,74.00,60.00>}
object {Key translate <59.50,74.00,60.00>}
object {Key translate <42.50,74.00,60.00>}
object {Key translate <25.50,74.00,60.00>}
object {Key translate <8.50,74.00,60.00>}
}

object {Keygroup}

#declare Tname =
text {ttf "quill.ttf" , "OLYMPIA werke", 2, 0 pigment{Black} finish {phong 1 reflection .4}
scale 15 rotate<0,180,0>}

#declare Base2 =
union {
    box {<-131.2511,88,-50><131.2511,115,23>}
    cylinder {<-131.2511,88,23><131.2511,88,23>,27}
    box {<-131.2511,88,-50><131.2511,80,50> texture{T_Chrome_3C}}
	object {Tname translate<90,90,50>}
}

#declare Basecut2 =
union {
    difference {
        box {<-80,0,-70><80,500,23>}
        cylinder {<75,-10,-27><75,500,-27>,35}
        cylinder {<-75,-10,-27><-75,500,-27>,35}
        cylinder {<50,-10,-40><50,600,-40>,10}
        cylinder {<-50,-10,-40><-50,600,-40>,10}
    }
    cylinder {<80,0,15.5><80,500,15.5>,7.5}
    cylinder {<-80,0,15.5><-80,500,15.5>,7.5}
}

#declare Base2a =
difference {
    object {Base2 pigment{Basec}finish{Basef}normal{Basen}}
    object {Basecut2 pigment{Basec}finish{Basef}normal{Basen}}
    box {<500,80,500><-500,-500,-500> pigment{Basec}finish{Basef}normal{Basen}}
    box {<0,500,500><-500,-500,-500> rotate <0,5,0> translate <-138.0977,0,-128.2569>
	pigment{Basec}finish{Basef}normal{Basen}}
    box {<0,500,500><500,-500,-500> rotate <0,-5,0> translate <138.0977,0,-128.2569>
	pigment{Basec}finish{Basef}normal{Basen}}
}

object {Base2a}

#declare Knob =
union {
difference {

cylinder {<0,0,0><10,0,0>,20 pigment {Gray30} finish {phong 1}}

#declare Count = 0
#while (Count < 36)
    cylinder {<-10,20,0><20,20,0>,1 pigment {Gray50} finish{phong 1} rotate <Count*10,0,0>}
    #declare Count = Count + 1
#end
}

cylinder {<-1,0,0><11,0,0>,17 pigment {Gray30} finish {phong 1} normal{bumps .5 scale .5}}
cylinder {<-1,0,0><-9,0,0>,5 pigment {Gray30} finish {phong 1}}
}

#declare Headp =
superellipsoid {<.1,.1>}

#declare Head2 =
union {
object {Headp scale<6,32.5,37.5>texture{T_Chrome_3C}}
object {Headp scale<8,27.5,15> translate<0,5,-42.5>texture{T_Chrome_3D}}
object {Knob translate<16,7.5,12.5>}
}

#declare Protop =
difference {
	cylinder {<-50,0,0><50,0,0>,30}
	cylinder {<-55,0,0><55,0,0>,29}
	box {<-60,0,100><50,-100,-100>}
	box {<-100,-100,0><100,100,100>}
}

#declare Paper =
union {
    difference {
        box {<-90,0,0><90,150,1>}
        box {<100,0,-10><-100,100,10> rotate<0,0,-45> translate<65,125,0>}
        box {<100,0,-10><-100,100,10> rotate<0,0,45> translate<-65,125,0>}
    }
    difference {
        object {Protop rotate<0,0,-45> translate<65,125,30>}
        box {<500,0,-100><90,500,100>}
        box {<-500,150,-100><500,500,100>}
    }
    difference {
        object {Protop rotate<0,0,45> translate<-65,125,30>}
        box {<-500,0,-100><-90,500,100>}
        box {<-500,150,-100><500,500,100>}
    }
	cylinder {<-90,0,0><90,0,0>,21 translate<0,0,21>}
}

#declare Page =
object {Paper pigment{White}
texture{pigment{
image_map {gif "page.gif"}
translate <-.5,0,0>
scale <180,150,1>
}}
finish {phong .2 ambient .3}
}

#declare Cariage =
union {
object {Head2 translate<124,0,-92.50>}
object {Head2 scale<-1,1,1> translate<-124,0,-92.50>}
cylinder {<-118,7.5,-80><118,7.5,-80>,20 pigment{Gray20}}
object {Page rotate<20,180,0> translate<0,7.5,-60>}
}

object {Cariage translate<40,87.5,-92.5>}

}
