/* IMPORTANT INFORMATION !
 * This file was created using an interactive text editor created specifically
 * for POVRAY and AUTOCAD. It allows the direct input of AUTOCAD information,
 * while inside the drawing construct, into the text file. It also supports a
 * series of macro add-on functions such as versions of WORM, CTDS, LATHE objects
 * SOR objects.
 * (C) Nathan G B O'Brien 1996
 */


#declare Leatherc = red .8 green .2 blue .05

#declare Leathern = normal {crackle 1 scale 10}

#declare Leatherf = finish {phong .75}

#declare Superq = superellipsoid {<0.1,0.1> scale .5 translate<.5,.5,.5>}

#declare Spine =
union {
object {Superq scale <5,36,210>
pigment{Leatherc}
finish {Leatherf}
normal {Leathern}
}
text{ttf "antqua.ttf", "ASIMOV    FOUNDATION AND EMPIRE",2,0
pigment {Yellow}
finish {phong 1}
scale <10,10,1>
rotate <0,90,0>
translate <-.5,15,195>
}
}

#declare Page1 =
difference {
    object {Superq scale<140,3,210> texture{pigment{
    marble
    color_map {
        [0.0 rgb <1,1,1> 0.1 rgb <1,1,1>]
        [0.1 rgb <1,.6,.1> 0.15 rgb <1,.6,.1>]
        [0.15 rgb <.6,.9,.1> 0.3 rgb <.6,.9,.1>]
        [0.3 rgb <.6,.5,.1> 0.4 rgb <.6,.5,.1>]
        [0.4 rgb <.9,.9,.5> 0.6 rgb <.9,.9,.5>]
        [0.6 rgb <.5,.6,.1> 0.75 rgb <.5,.6,.1>]
        [0.8 rgb <1,1,1>]
        [0.9 rgb <.8,.4,.1> 1.0 rgb <.8,.4,.1>]
    }
    scale 30
    turbulence .5
    octaves 2
    lambda 10
    }}
    finish {phong .2}
    }
    box {<25,100,1000><-100,-100,-1000>}
    box {<1000,100,0><-1000,-100,-1000> rotate <0,-45,0> translate <70,0,0>}
    box {<1000,100,0><-1000,-100,1000> rotate <0,45,0> translate <70,0,210>}
}

#declare Page2 =
intersection {
    object {Superq scale<140.01,3,210.01>
    pigment{Leatherc}
    finish {Leatherf}
    normal {Leathern}
    }
    union {
    box {<25,100,1000><-100,-100,-1000>
    pigment{Leatherc}
    finish {Leatherf}
    normal {Leathern}
    }
    box {<1000,100,0><-1000,-100,-1000> rotate <0,-45,0> translate <70,0,0>
    pigment{Leatherc}
    finish {Leatherf}
    normal {Leathern}
    }
    box {<1000,100,0><-1000,-100,1000> rotate <0,45,0> translate <70,0,210>
    pigment{Leatherc}
    finish {Leatherf}
    normal {Leathern}
    }
    }
}

#declare Cover =
union {
object {Page1}
object {Page2}
}

#declare Book =
union {

object {Cover translate<0,15,0>}
object {Cover translate<0,-18,0>}
object {Spine translate<-1,-18,0>}

box {<0,-15,5><135,15,205> pigment{White}
texture{pigment{
gradient y
color_map {
    [0.0 rgb <1,1,1> 0.25 rgb <1,1,1>]
    [0.25 rgb <.5,.5,.5> 0.5 rgb <.5,.5,.5>]
    [0.5 rgb <1,1,1> 0.75 rgb <1,1,1>]
    [0.75 rgb <.8,.8,.8> 1.0 rgb <.8,.8,.8>]
}
scale 5
}}
normal {gradient y 1}
}
}




