/* POVRAY DESCRIPTION FILE
   THANKS TO : Gennadiy Obukhov for his Head object (see head.inc)
*/


#include "colors.inc"
#include "trans1.inc"

camera {
        location <400,0,-2500>
        look_at  <-100,0,0>
}

light_source {<400,0,-2500> color red .05 green .05 blue .05}

light_source {<-2000,2000,-8000> color red 1.1 green 1.1 blue 1.1
        spotlight
        point_at<0,0,0>
        radius 5
        falloff 6
        tightness 100
}

light_source {<-2000,2000,-8000> color White
        spotlight
        point_at<0,0,0>
        radius 5
        falloff 13
        tightness 10
}

object {transformer1 scale<2.2,2.2,2.2> rotate<-10,-40,-5> translate<-200,-600,-1200>}

#declare Bang =
sphere { 0, 1
    pigment { color rgbt <1, 1, 1, 1> }
   halo {      emitting
     spherical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.5 color rgbt <1, 1, 0, -1> ]
        [ 1.0 color rgbt <1, 0, 0,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
    }
    hollow
    scale 1.5
  }

object {Bang scale 2000 translate<-200,0,-1200>}
