// The 'Discovery' P.O.V. file
// Version 1.1
//
// This file built by Nick Stevens of Starbase One BBS.
// starbase1@cix.compulink.co.uk
//
// It is for a model of the spaceship 'Discovery' from the film 2001
//

/* Some Notes!
For realistic lighting your really out to have a single bright
lightsource almost directly behind the ship thats a large -ve
Z value. However, if Stanley Kubrik can use a little light to
show detail in the shadows, so can I!

Note hat this scene is very sensitive to the Gamma setting, as
it has large areas in shade.

The major limitation in this model is that I have not managed to
do the engine structure on the rear well. It's really complicated
sort of row of hexagonal cones, that is somewhat beyond me at the
moment. If anyone can add them I'd love to see them!
*/

/* What's new in this version:
! More detailed bump map used on the cabin
! More detail added to the 'neck' conection
! Airlock lowered to match the film better
! Alternate spine segments are now rotated 180 degrees for more variety.
! The engine block at the back totally rebuilt as a block with shaved sides
! Knobbley bits added on the back of the antennae
*/

// First off some flags to control the scene, for detail: 1=on
// This makes test renderings go faster

#declare skyon=1
#declare finestuff=1

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "shapes.inc"
#include "shapes2.inc"

global_settings { assumed_gamma 2.1 }
//global_settings { assumed_gamma 1.6 }

// Declare textures - skin1 is default

#declare skin1 = texture { pigment {White}
                            finish {ambient 0.05
                                    brilliance 0.37}}
#declare skin2 = texture { pigment {White}
                            finish {ambient 0.05
                                    brilliance 0.30}}
#declare skin3 = texture { pigment {White}
                            finish {ambient 0.05
                                    brilliance 0.23}}
#declare skin4 = texture { pigment {White}
                            finish {ambient 0.05
                                    brilliance 0.16}}

// A shiny metal
#declare Tank_Texture =
texture {
    pigment { color LightGray }
    finish {
        ambient 0.02
        diffuse 0.7
        reflection 0.15
        brilliance 8
        specular 0.8
        roughness 0.1
    }
}

// Glass textures contributed by Norm Bowler, of Richland WA
#declare NBglass =
texture {
    pigment { color rgbf <0.98, 1.0, 0.99, 0.75> }
    finish {
        ambient 0.1
        diffuse 0.1
        reflection .25
        refraction 1
        ior 1.5
        specular 1
        roughness .001
    }
}

#declare NBoldglass=
texture {
    NBglass
    pigment { color rgbf <0.8, 0.9, 0.85, 0.85> }
}

// Start the starry background

#declare Starz1 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
            [ 0.88  0.85 color Gray20 color Gray40 ] // Very Very Faint Stars
            [ 0.91  0.88 color Gray40 color Gray60 ] // Very Faint Stars                [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.93  0.93 color Gray80 color Gray95 ] // Medium White Stars
            [ 0.95  0.95 color Gray95 color White  ] // White Stars
            [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .015
    }
    finish { ambient 1 }
}
// Starz2, by Nick Stevens, (fainter)
#declare Starz2 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
            [ 0.88  0.85 color Gray20 color Gray30 ] // Very Very Faint Stars
            [ 0.91  0.88 color Gray40 color Gray50 ] // Very Faint Stars                [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.93  0.93 color Gray80 color Gray85 ] // Medium White Stars
            [ 0.95  0.95 color Gray95 color Gray90  ] // White Stars
            [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .015
    }
    finish { ambient 1 }
}

#declare supersky=union {

// Ball of stars for even coverage
sphere { <0,0,0> 1
         texture {Starz1 scale 1}
         scale 2000000
         }

// Extra band of stars around the horizon, more distant
cylinder { <0,-0.1, 0> , <0, 0.1, 0> 1.2 open
         texture {Starz2 scale 1}
         scale 2000000
}
// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.07, 0> , <0, 0.07, 0> 1.4 open
         texture {Starz2 scale 1}
         rotate <0, 90, 0>
         scale 2000000
}
// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.05, 0> , <0, 0.05, 0> 1.5 open
         texture {Starz2 scale 1}
         rotate <0, 180, 0>
         scale 2000000
}
// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.04, 0> , <0, 0.04, 0> 1.6 open
         texture {Starz2 scale 1}
         rotate <0, 270, 0>
         scale 2000000
 }
} // end union

// Add the starry sky, and position it.

#if (skyon=1)
object {supersky
        rotate < 45, 0, 0 > // set inclination to horizon
        rotate < 0, 270, 0>  // spin about the zenith
 hollow}
#else
#end

#default {texture {skin1}}

/* Start the components of the spaceship proper:
cabin is the ball at the front
neck connects it to the long bit down the middle
spine is the long bit down the middle
subvert is the smal knobbly lump along the spine
three subvert make up a vertib (vertebra and sub)
the comination of spine and vertib make the backbone
engine is the box at the back
*/

#declare spine=union{
  cylinder{<0,0.00,0>,<0,0.00,-38> 0.2 texture {skin3}}

  cylinder{<0,0.3,0>,<0,0.3,-38> 0.05 rotate <0,0,0>  texture {skin1}}
  cylinder{<0,0.3,0>,<0,0.3,-38> 0.05 rotate <0,0,90> texture {skin1}}
  cylinder{<0,0.3,0>,<0,0.3,-38> 0.05 rotate <0,0,180>texture {skin1}}
  cylinder{<0,0.3,0>,<0,0.3,-38> 0.05 rotate <0,0,270>texture {skin1}}
}

#declare neck=
lathe {
    linear_spline
    10,
    <0, 3.6>
    <0.5, 3.6>
    <0.6, 3.3>
    <0.8, 2.8>
    <0.9, 3.0>
    <1.2, 2.6>
    <1.0, 2.3>
    <1.6, 1.6>
    <0, 1.6>
    <0, 3.6>
   texture {skin2}
   rotate <-90,0,0>
}

// Used to shave bits off blocks
#declare shaver=
  box {<-100,0,-100> <100,-100,100> normal {quilted 0.3 scale <0.4,1,0.4>}}

// Main chunk of the engine assembley:
#declare eblock =
difference {
    box {<-2.5,-1.1,-34.5> <+2.5,1.1,-42.5>}
// Shave the corners off of the sides:
    object {shaver  rotate <0,0,45>  translate < 2.3, -0.7 , 0>}
    object {shaver  rotate <0,0,135> translate < 2.3,  0.7 , 0>}
    object {shaver  rotate <0,0,225> translate <-2.3,  0.7 , 0>}
    object {shaver  rotate <0,0,315> translate <-2.3, -0.7 , 0>}
// Shave the sides in at the back:
    object {shaver  rotate <0,0,090> rotate <0, 30,0> translate < 2, 0 , -41.2> }
    object {shaver  rotate <0,0,090> rotate <0,150,0> translate <-2, 0 , -41.2> }
// Shave the top and bottom in at the rear:
    object {shaver  rotate <0,0,090> rotate <0, 20,0> rotate <0,0,90> translate < 1.8, 0 , -43.7> }
    object {shaver  rotate <0,0,090> rotate <0,160,0> rotate <0,0,90> translate <-1.8, 0 , -43.7> }
}

#declare nozzlea=intersection{
  cone   {<0,0,-42.0> 0.2 <0,0,-44> 1}
  box    {<0.65,5,0> <-0.65,-5,-60>}
}

#declare nozzle=difference{
  object {nozzlea}
  sphere {<0, 0.45,-44> 0.4 texture {pigment{Gray20}}}
  sphere {<0,-0.45,-44> 0.4 texture {pigment{Gray20}}}
}

#declare engine=union{
// Main engine block assembley
  object {eblock}
// Connection to the spine:
  cylinder {<0,0,-33.8><0,0,-38> 0.7 texture {skin2}}
  cylinder {<0,0,-34.1><0,0,-38> 0.8 texture {skin1}}
  cylinder {<0,0,-34.3><0,0,-38> 0.9 texture {skin3}}
// Side cylinders on the front
  cylinder {< 1.5,0,-34.35>< 1.5,0,-38> 0.45 texture {skin3}}
  cylinder {<-1.5,0,-34.35><-1.5,0,-38> 0.45 texture {skin3}}
  cylinder {< 1.2,0.75,-34.30>< 1.2,0.75,-38> 0.2 texture {skin3}}
  cylinder {<-1.2,0.75,-34.30><-1.2,0.75,-38> 0.2 texture {skin3}}
  cylinder {< 1.2,-.75,-34.30>< 1.2,-.75,-38> 0.2 texture {skin3}}
  cylinder {<-1.2,-.75,-34.30><-1.2,-.75,-38> 0.2 texture {skin3}}
  cylinder {<-2.2,0,-34.30><-2.2,0,-38> 0.2 texture {skin3}}
  cylinder {< 2.2,0,-34.30>< 2.2,0,-38> 0.2 texture {skin3}}
  sphere {< 1.5,0,-34.45> 0.25}
  sphere {<-1.5,0,-34.45> 0.25}
  // Raised block at top and bottom
  box {<-1.7,-1.15,-35>   <+1.7,1.15,-39.5>}
  box {<-1.5,-1.2, -35.5> <+1.5,1.2, -39> normal {brick 3.3 scale <0.2,1,0.2>}}
// Row of knobs behind block:
  sphere {< 0.0,1.05,-40> 0.1}
  sphere {<+0.5,1.05,-40> 0.1}
  sphere {<-0.5,1.05,-40> 0.1}
  sphere {<+1.5,1.05,-40> 0.1}
  sphere {<-1.5,1.05,-40> 0.1}
  sphere {<+1.0,1.05,-40> 0.1}
  sphere {<-1.0,1.05,-40> 0.1}
  sphere {< 0.0,-1.05,-40> 0.1}
  sphere {<+0.5,-1.05,-40> 0.1}
  sphere {<-0.5,-1.05,-40> 0.1}
  sphere {<+1.5,-1.05,-40> 0.1}
  sphere {<-1.5,-1.05,-40> 0.1}
  sphere {<+1.0,-1.05,-40> 0.1}
  sphere {<-1.0,-1.05,-40> 0.1}
// Cylinder lies along the backslope:
  cylinder {<-1,0.8,-41.3><+1,0.8,-41.3> 0.4 }
// Two more cylinders on the rear side slopes:
  cylinder {< 1.8,0,-41.7>< 1.8,0,-38> 0.5 texture {skin3}}
  cylinder {<-1.8,0,-41.7><-1.8,0,-38> 0.5 texture {skin3}}
// Cylinders sticking out the top back slope:
  cylinder {<0,0.5,-40>    <0,0.5,-43.6>    0.35 texture {skin3}}
  cylinder {<1.1,0.5,-40>  <1.1,0.5,-43.6>  0.35 texture {skin3}}
  cylinder {<-1.1,0.5,-40> <-1.1,0.5,-43.6> 0.35 texture {skin3}}
  cylinder {<0,-0.5,-40>    <0,-0.5,-43.6>    0.35 texture {skin3}}
  cylinder {<1.1,-0.5,-40>  <1.1,-0.5,-43.6>  0.35 texture {skin3}}
  cylinder {<-1.1,-0.5,-40> <-1.1,-0.5,-43.6> 0.35 texture {skin3}}
// Cylinders for round knobs on the side:
cylinder{<2.58,0,-35><-2.58,0,-35> 0.3 texture {skin1}}
cylinder{<2.58,0,-36><-2.58,0,-36> 0.3 texture {skin3}}
cylinder{<2.58,0,-39><-2.58,0,-39> 0.3 texture {skin3}}
cylinder{<2.58,0,-40><-2.58,0,-40> 0.3 texture {skin1}}
sphere {<2.48,0,-35> 0.15 texture {skin2}}
sphere {<2.48,0,-36> 0.15 texture {skin2}}
sphere {<2.48,0,-39> 0.15 texture {skin2}}
sphere {<2.48,0,-40> 0.15 texture {skin2}}
sphere {<-2.48,0,-35> 0.15 texture {skin2}}
sphere {<-2.48,0,-36> 0.15 texture {skin2}}
sphere {<-2.48,0,-39> 0.15 texture {skin2}}
sphere {<-2.48,0,-40> 0.15 texture {skin2}}

box {<2.58,0.1,-39><-2.58,0.3,-36> texture {skin3}}
box {<2.58,-0.1,-38.5><-2.58,-0.6,-37.5> texture {skin1}}
box {<2.58,-0.1,-37.3><-2.58,-0.6,-37.0> texture {skin1}}
box {<2.58,-0.1,-36.8><-2.58,-0.6,-36.6> texture {skin1}}
// Engine nozzles
  object {nozzle}
  object {nozzle translate < 1.1,0,0>}
  object {nozzle translate <-1.1,0,0>}
// Ridges on the bevelled sides:
  cylinder {<2.1,0.9,-40> <2.1,0.9,-35.5> 0.05 texture {skin2} }
  cylinder {<2.3,0.7,-39> <2.3,0.7,-36.5> 0.05 texture {skin3} }
  cylinder {<2.1,-0.9,-40> <2.1,-0.9,-35.5> 0.05 texture {skin2} }
  cylinder {<2.3,-0.7,-39> <2.3,-0.7,-36.5> 0.05 texture {skin3} }
  cylinder {<-2.1,0.9,-40> <-2.1,0.9,-35.5> 0.05 texture {skin2} }
  cylinder {<-2.3,0.7,-39> <-2.3,0.7,-36.5> 0.05 texture {skin3} }
  cylinder {<-2.1,-0.9,-40> <-2.1,-0.9,-35.5> 0.05 texture {skin2} }
  cylinder {<-2.3,-0.7,-39> <-2.3,-0.7,-36.5> 0.05 texture {skin3} }
    }


#declare naut=union{
   box{<-1,0,0><1,4,-1>}
   sphere {<0,3.7,-0.5> 1 scale <1,1.4,1>}
   cylinder {<-0.7,3.5,-0.5><-2.2,1,-0.5> 0.4}
   cylinder {< 0.7,3.5,-0.5>< 2.2,1,-0.5> 0.4}
 pigment {Gray20}
 scale 0.03
}
#declare radeg=1/360*2*3.14159265

#declare cabina = difference {
   sphere {<0,0,0> 2.3}
   torus  {2.3, 0.02 scale <1,2,1> }
   torus  {2.3*cos(60*radeg), 0.02 translate <0,2.3*sin(60*radeg),0>}
   torus  {2.3*cos(60*radeg), 0.02 translate <0,-2.3*sin(60*radeg),0>}
   torus  {2.3*cos(32*radeg), 0.02 translate <0,2.3*sin(32*radeg),0>}
   torus  {2.3*cos(38*radeg), 0.02 translate <0,-2.3*sin(38*radeg),0>}
   cylinder {<0,-0.8,0> <0,-0.8,3> 0.5}
   cylinder {<0,-0.8,0> <0,-0.8,3> 0.5  rotate <0, 40,0>}
   cylinder {<0,-0.8,0> <0,-0.8,3> 0.5  rotate <0,-40,0>}
   box{<20,-0.6,0.2><-20,-1.2,-0.2>}
   normal { bump_map {gif "ridges4b.gif" bump_size 1.2 map_type 1 interpolate 2 }}
}

#declare cabinb=union
{  object {cabina}
   sphere {<0,0,0> 2.25 texture {skin2}}
}

#declare cabinc=difference
{ object {cabinb}
  box {<+1.5,0.7,0> <-1.5,0.95,4> pigment {rgb <0.7,0,0>} finish {ambient 0.05}}
}

#declare cabin=union
{object {cabinc}
 sphere {<0,0,0> 2.24 texture {NBoldglass}}
 light_source {<-0.7, 0.82, 1.3> colour rgb <0.5,0,0> fade_distance 1 fade_power 2}
 light_source {< 0.7, 0.82, 1.3> colour rgb <0.5,0,0> fade_distance 2 fade_power 2}
 object {naut translate <-0.3,0.65,1.9>}
 object {naut translate < 0.3,0.65,1.9>}
}

#declare subverta=difference
{box {<-4,-4,0>,<4,+4,-14> rotate <0,0,45> translate <0,-6,0>}
 box {<100,-7,100><-100,-32,-100>}
 box {<100,-3,100><-100, 32,-100>}
 box {<99,99,-9><-99,-99,-11> }
 scale 0.1
}

#declare subvert=union{
 object {subverta}

#if (finestuff=1)
// some 'bolts' along the bottom
 sphere {<+0.4,-0.65,-.2> 0.07 texture {skin3}}
 sphere {<+0.4,-0.65,-.5> 0.07 texture {skin3}}
 sphere {<+0.4,-0.65,-.8> 0.07 texture {skin3}}
 sphere {<-0.4,-0.65,-.2> 0.07 texture {skin3}}
 sphere {<-0.4,-0.65,-.5> 0.07 texture {skin3}}
 sphere {<-0.4,-0.65,-.8> 0.07 texture {skin3}}
// disc on the thin bit
 cylinder {<0.3,-0.6,-1.2> <0.3,-0.73,-1.2> 0.07 texture {skin4}}
 cylinder {<-.3,-0.6,-1.2> <-.3,-0.73,-1.2> 0.07 texture {skin4}}
 cylinder {<0.3,-0.7,-1.2> <-.3,-0.7, -1.2> 0.02 texture {skin1}}
// two block/panels
 box { <0.25,-0.6,-0.2> <-0.1, -0.72,-0.55> texture {skin2}}
 box { <-.15,-0.6,-0.2> <-0.25,-0.72,-0.8 > texture {skin3}}
// Lumps on the ends!
 cylinder {<0,-0.5,0.05> <0,-0.5,-1.45> 0.1 texture {skin4}}
 cylinder {<0.25,-0.55,0.05> <0.25,-0.55,-1.45> 0.06  texture {skin4}}
 cylinder {<-.25,-0.55,0.05> <-.25,-0.55,-1.45> 0.06 texture {skin1}}
// ridges on slope
 cylinder {<0.22,-0.45,-0.1><0.22,-0.45,-0.8> 0.15 texture {skin4}}
 cylinder {<-.22,-0.45,-0.1><-.22,-0.45,-0.8> 0.15 texture {skin4}}
// Fixing rods
 cylinder {<0,0,-0.1> <0,-0.5,-0.1> 0.07 texture {skin1}}
 cylinder {<0,0,-0.6> <0,-0.5,-0.6> 0.07 texture {skin1}}
 cylinder {<0,0,-1.3> <0,-0.5,-1.3> 0.07 texture {skin1}}
// intersection knobbly lump
 cylinder {<0,0,-2.2> <0,0,-2.3> 0.4}
 cylinder {<0,0, 0.1> <0,0, 0.3> 0.5}
#end
}

#declare vertib=union{
  object {subvert}
  object {subvert rotate <0,0,120> }
  object {subvert rotate <0,0,240> }
 translate <0,0,-4>
}
#declare vertib2=union{
   object {subvert}
   object {subvert rotate <0,0,120> }
   object {subvert rotate <0,0,240> }
 rotate <0,180,0>
 translate <0,0,-5.4>
}

#declare backbone = union {
   object {vertib}
   object {vertib2 translate <0,0, -2.5>}
   object {vertib translate <0,0, -5.0>}
   object {vertib2 translate <0,0, -7.5>}
   object {vertib translate <0,0,-10.0>}
   object {vertib2 translate <0,0,-12.5>}
   object {vertib translate <0,0,-15.0> rotate <0,0,180> scale <1.5,1,1>}
   object {vertib translate <0,0,-17.5>}
   object {vertib2 translate <0,0,-20.0>}
   object {vertib translate <0,0,-22.5>}
   object {vertib2 translate <0,0,-25.0>}
   object {vertib translate <0,0,-27.5>}
}

#declare disha=
lathe {
    linear_spline
    8,
    <0.0, 0.7>
    <0.4, 0.7>
    <0.3, 0.9>
    <0.3, 1.0>
    <0.15, 1.0>
    <0.15, 1.2>
    <0.0, 2.3>
    <0.0, 0.7>
   texture {skin3}
}

// The actual dish part, with a knob on the back
#declare dishb=
lathe {
    quadratic_spline
    22,
    <0.2, 0.2>
    <0.5, 0.1>
    <0.8, 0.3>
    <0.8, 0.3>
    <0.3, 0.0>
    <0.02, 0.1>
    <0.02, 0.1>
    <0.02, 0.42>
    <0.04, 0.4>
    <0.02, 0.46>
    <0.02, 0.58>
    <0.05, 0.6>
    <0.00, 0.6>
    <0.00, 0.0>
    <0.10,-0.02>
    <0.25,-0.1>
    <0.25,-0.3>
    <0.25,-0.3>
    <0.10,-0.3>
    <0.10,-0.3>
    <0.10,-0.35>
    <0.00,-0.40>
   texture {skin3}
   rotate <90,0,0>
   translate <0,2.3,0>
}

#declare dishc=union
{ cylinder {<0.65,0.2,0> <-0.65,0.2,0> 0.01 texture {skin1}}
  cylinder {<0,0.2,0.65> <0,0.2,-0.65> 0.01 texture {skin1}}
  rotate <90,0,0>
  translate <0,2.3,0>
}

#declare dishd = union {
  object {dishb}
  object {dishc}
}

#declare dish=union
{
 object {disha}
 object {dishd}
 cylinder {<1.2,1.8,0> <-1.2,1.8,0> 0.065}
 sphere {<+1.2, 1.8 0> 0.065 }
 sphere {<-1.2, 1.8 0> 0.065 }
 object {dishd scale 0.5 translate <+1.2,0.75,0.2>}
 object {dishd scale 0.5 translate <-1.2,0.75,0.2>}
 rotate <0,155,0> // Angle the dish assembly points at - 180 is backward
}

#declare ship2001=union{
  object {cabin}
  object {spine}
  object {backbone}
  object {neck}
  object {engine}
  object {dish translate <0,0,-19.25>}
}


object {ship2001 translate <0,0,clock>}

light_source {<-1000, 500,   3000> colour Gray30}
light_source {< 2000, 500,  -3000> colour White}
light_source {< 2000, 500,  -3000> colour Gray50}

camera {
   location  <9, -4.0, 18>
   direction <0,0,2.7>
   look_at   <0,0.5,-7>
}

/*
camera {
   location  <4, -1.4, 8>
   direction <0,1,2.0>
   look_at   <0,0,-10>
}
*/

#declare Metal2 =
texture {
    pigment { color Gray95 }
    finish {
        ambient 0.02
        diffuse 0.85
        reflection 0.15
        brilliance 5
        specular 0.8
        roughness 0.1
    }
}
// Metal3 has a very slight blue tint to avoid a monochrome image.
#declare Metal3 =
texture {
    pigment { color rgb <0.88, 0.90, 0.93> }
    finish {
        ambient 0.02
        diffuse 0.85
        reflection 0.15
        brilliance 5
        specular 0.8
        roughness 0.1
    }
}

#declare pod01=
difference{
  sphere {<0,0,0> 5.6}
  cone {<0,2,2> 1 <0,1.5,7> 3.0 scale <0.7,1,1> pigment {Gray10}}
}

#declare pod02=union
{
  object {pod01}
  cone {<0,-3.6,0> 4.29 <0,-5,0> 3.5}
  sphere {<0,0,0> 4.8 texture {Polished_Chrome}}
}

#declare pod03=difference
{
 object {pod02}
 plane {x, -4.29}
 plane {-x,-4.29}
// Cut out some dimples, as in the real one...
 sphere {<0,5.8,0> 0.65  rotate <0,0, 30> rotate < 30,0,0>}
 sphere {<0,5.8,0> 0.65  rotate <0,0,-30> rotate < 30,0,0>}
 sphere {<0,5.8,0> 0.65  rotate <0,0, 30> rotate <-30,0,0>}
 sphere {<0,5.8,0> 0.65  rotate <0,0,-30> rotate <-30,0,0>}
 sphere {<0,5.8,0> 0.4  rotate <0,0, 37> rotate < 63,0,0>}
 sphere {<0,5.8,0> 0.4  rotate <0,0,-37> rotate < 63,0,0>}
 sphere {<0,5.8,0> 0.4  rotate <0,0, 37> rotate < 75,0,0>}
 sphere {<0,5.8,0> 0.4  rotate <0,0,-37> rotate < 75,0,0>}

 sphere {<0,5.9,0> 0.5  rotate <120,0,0> rotate < 0, 00,0>}
 sphere {<0,5.9,0> 0.5  rotate <120,0,0> rotate < 0, 15,0>}
 sphere {<0,5.9,0> 0.5  rotate <120,0,0> rotate < 0,-15,0>}

 plane {y,-5}
}

// This should really be a Maltese cross, but I'm being lazy...

#declare crossbit=
difference {
 cylinder {<4.29,0,0> <5.49,0,0> 2.6 }
 box {<4.28,0.5,0.5> <5.5,3.5,2.7> rotate <000,0,0>}
 box {<4.28,0.5,0.5> <5.5,3.5,2.7> rotate <090,0,0>}
 box {<4.28,0.5,0.5> <5.5,3.5,2.7> rotate <180,0,0>}
 box {<4.28,0.5,0.5> <5.5,3.5,2.7> rotate <270,0,0>}
pigment {Gray10}
}

#declare sidelump=
union {
 cone {<4.29,0,0> 3.4 <5.40,0,0> 2.7}
 sphere {<0,0,0> 1.5 scale <0.65,1,1> translate < 5.4, 0, 0>}
 cylinder {<5.45,1.5,1.5> <5.35,1.5,1.5> 0.2 pigment {Gray10} rotate <000,0,0>}
 cylinder {<5.45,1.5,1.5> <5.35,1.5,1.5> 0.2 pigment {Gray10} rotate <090,0,0>}
 cylinder {<5.45,1.5,1.5> <5.35,1.5,1.5> 0.2 pigment {Gray10} rotate <180,0,0>}
 cylinder {<5.45,1.5,1.5> <5.35,1.5,1.5> 0.2 pigment {Gray10} rotate <270,0,0>}
 crossbit
}

#declare notch=0.2

// This next step cuts out the notches in the side of the side truncated cones.

#declare sl=difference{
 object {sidelump}
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <000,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <010,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <020,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <030,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <040,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <050,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <120,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <130,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <140,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <150,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <160,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <170,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <240,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <250,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <260,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <270,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <280,0,0> }
 cylinder { <4.29,3.4,0> <5.45,2.7,0> notch   rotate <290,0,0> }
}

#declare sl2=difference
{
  object {sl}
  sphere {<6.4,0,0> 0.5 pigment {Gray10}}
  sphere {<6.2,1.3,0> 0.5 pigment {Gray10} rotate <000,0,0>}
  sphere {<6.2,1.3,0> 0.5 pigment {Gray10} rotate <090,0,0>}
  sphere {<6.2,1.3,0> 0.5 pigment {Gray10} rotate <180,0,0>}
  sphere {<6.2,1.3,0> 0.5 pigment {Gray10} rotate <270,0,0>}
}

#declare hlight=
difference {
  cylinder {<-3,-3.5,0><-3,-3.5,5> 0.7}
  sphere {<-3, -3.5 6.1> 1.4 texture {Polished_Chrome pigment {White}}}
}

#declare bulb=sphere{<0,0,0> 0.2  pigment {White} finish {ambient 1}}

#declare headlight=union {
 object {hlight}
 light_source
 {
  <-3,-3.5,5.1>           // light's position (translated below)
  color rgb <1, 1, 1>     // light's color
  fade_distance 1.1
  fade_power 3
  looks_like { object {bulb}}
 }

}

#declare haleye=union{
 sphere {<0,0,5.6> 0.29 texture {NBglass pigment {rgbf <1,0.75,0.5,1>}}}
// sphere {<0,0,5.6> 0.23 pigment {Red} finish {ambient 1}}
// sphere {<0,0,5.6> 0.23 pigment {Yellow} finish {ambient 1} scale <1.07,1.07,0.995> }
 sphere {<0,0,5.6> 0.23 texture {Ruby_Glass}   finish {ambient 1}}
 sphere {<0,0,5.6> 0.23 texture {Yellow_Glass} finish {ambient 1} scale <1.07,1.07,0.995> }
 rotate <13,0,0>
}

// In the real one each arm had 4 hands -  have simplified to 2...

#declare arm=union{
// Square initial stage
 box{<0.2,-1.9,4> <-0.2,-1.6,7>   texture {Metal2}}
 box{<0.3,-2.0,4> <-0.3,-1.5,5.6> texture {Metal3}}
// Joint
 cylinder {<0.25,-1.75,7> <-0.25,-1.75,7> 0.3}
 cylinder {<0.27,-1.75,7> <-0.27,-1.75,7> 0.15 texture {Metal2} }
 cylinder {<0.28,-1.75,7> <-0.28,-1.75,7> 0.05 }
// Forearms
 cylinder {<0,-1.75,7> <0,-0.25,8.5> 0.15  texture {Metal2}}
 cylinder {<0,-1.75,7> <0,-3.25,8.5> 0.15  texture {Metal2}}
// Wrists
 cylinder {<-0.25,-0.25,8.5><+0.25,-0.25,8.5> 0.22}
 cylinder {<-0.27,-0.25,8.5><+0.27,-0.25,8.5> 0.11  texture {Metal3}}
 cylinder {<-0.25,-3.25,8.5><+0.25,-3.25,8.5> 0.22}
 cylinder {<-0.27,-3.25,8.5><+0.27,-3.25,8.5> 0.11  texture {Metal3}}

// Now the simplified fingers...
// bottom fingers on each hand
 cylinder {<0,-0.25,8.5> <0,-0.75,9.5> 0.1 texture {Metal2}}  sphere {<0,-0.75,9.5> 0.1 texture {Metal2}}
 cylinder {<0,-3.25,8.5> <0,-3.75,9.5> 0.1 texture {Metal2}}  sphere {<0,-3.75,9.5> 0.1 texture {Metal2}}
 cylinder {<0,-0.50,10.25> <0,-0.75,9.5> 0.1 texture {Metal2}}  sphere {<0,-0.50,10.25> 0.15 pigment {Black}}
 cylinder {<0,-3.50,10.25> <0,-3.75,9.5> 0.1 texture {Metal2}}  sphere {<0,-3.50,10.25> 0.15 pigment {Black}}

// Top fingers on each hand...
 cylinder {<0.15,-3.25,8.5>   <0.15,-2.75,9.5> 0.1 texture {Metal2}}  sphere {<0.15,-2.75,9.5> 0.1 texture {Metal2}}
 cylinder {<0.15,-0.25,8.5>   <0.15,0.25,9.5>  0.1 texture {Metal2}}  sphere {<0.15,0.25,9.5>  0.1 texture {Metal2}}
 cylinder {<0.15,-0.00,10.25> <0.15,0.25,9.5>  0.1 texture {Metal2}}  sphere {<0.15,-0.00,10.25> 0.15 pigment {Black}}
 cylinder {<0.15,-3.00,10.25> <0.15,-2.75,9.5> 0.1 texture {Metal2}}  sphere {<0.15,-3.00,10.25> 0.15 pigment {Black}}

 cylinder {<-0.15,-3.25,8.5>   <-0.15,-2.75,9.5> 0.1 texture {Metal2}}  sphere {<-0.15,-2.75,9.5> 0.1 texture {Metal2}}
 cylinder {<-0.15,-0.25,8.5>   <-0.15,0.25,9.5>  0.1 texture {Metal2}}  sphere {<-0.15,0.25,9.5>  0.1 texture {Metal2}}
 cylinder {<-0.15,-0.00,10.25> <-0.15,0.25,9.5>  0.1 texture {Metal2}}  sphere {<-0.15,-0.00,10.25> 0.15 pigment {Black}}
 cylinder {<-0.15,-3.00,10.25> <-0.15,-2.75,9.5> 0.1 texture {Metal2}}  sphere {<-0.15,-3.00,10.25> 0.15 pigment {Black}}

}

#declare pod04=union
{
object {pod03}
object {sl2}
object {sl2 rotate <0,180,0>}
object {headlight}
object {headlight translate <6,0,0>}
object {headlight translate <6.5,3,0>}
object {headlight translate <-0.3,3,0>}
object {arm translate <+3.0,0,0>}
object {arm translate <-3.0,0,0>}
box {<-4,-3.5,0> <+4,-1,4.5>}
object {haleye}
}

object {pod04
  scale 0.15
  rotate <0,-30,0>
  translate <6, 0.5, 0>
}


