// The 2001 Space Station P.O.V. file
// This file built by Nick Stevens of Starbase One BBS.
// god@starbase.org
//
// All done entirely by hand, with the help of close examination
// of the book '2001 filming the future' by Piers Bizony

/* This is the source code for a Povray model of a partially built space
station, based closely on the one featured in the film 2001, A Space Odyssey
You will find that several sections are included but commented out where
I tried things but was not happy with the results. These include extra
knobbly bits on the side (Which I felt spoilt the sense of scale) and some
pulsing red lights which were an attempt to add some colour.

Also note that you can rotate the station by adjusting the clock value
Sweeping from 0-1 will move it through a quarter turn - and owing to the 
symetry this is enough for a good looping animation.

Render time is 2 days at 1024x768 on a 486-66
*/

global_settings { assumed_gamma 1}

// ==== Standard POV-Ray Includes ====
#include "colors.inc"   // Standard Color definitions
#include "textures.inc" // Standard Texture definitions

#default { texture {pigment {White}} }

// Starz1, by Nick Stevens
#declare Starz1 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
            [ 0.88  0.85 color Gray20 color Gray40 ] // Very Very Faint Stars
            [ 0.91  0.88 color Gray40 color Gray60 ] // Very Faint Stars
            [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.93  0.93 color Gray80 color Gray95 ] // Medium White Stars
            [ 0.95  0.95 color Gray95 color White  ] // White Stars
            [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .025
    }
    finish { ambient 1 }
}

// Starz2, by Nick Stevens, (fainter)
#declare Starz2 =
texture {
    pigment {
        granite
        color_map {
            [ 0.00  0.82 color Clear  color Clear ]  // No Stars in this area
            [ 0.88  0.85 color Gray20 color Gray30 ] // Very Very Faint Stars
            [ 0.91  0.88 color Gray40 color Gray50 ] // Very Faint Stars
            [ 0.78  0.81 color Gray60 color Gray80 ] // Faint Stars
            [ 0.93  0.93 color Gray80 color Gray85 ] // Medium White Stars
            [ 0.95  0.95 color Gray95 color Gray90  ] // White Stars
            [ 0.98  1.00 color Black  color Black ]  // No Stars in this area
        }
    scale .02
    }
    finish { ambient 1 }
}

// The Starry Background

#declare supersky=union {

// Ball of stars for even coverage
sphere { <0,0,0> 1
         texture {Starz1 scale 1}
         scale 2000000
         }

// Extra cylindrical bits give a Milky Way, and add visual interest

// Extra band of stars around the horizon, more distant
cylinder { <0,-0.1, 0> , <0, 0.1, 0> 1.2 open
         texture {Starz2 scale 1}
         scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.07, 0> , <0, 0.07, 0> 1.4 open
         texture {Starz2 scale 1}
         rotate <0, 90, 0>
         scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.05, 0> , <0, 0.05, 0> 1.5 open
         texture {Starz2 scale 1}
         rotate <0, 180, 0>
         scale 2000000
}

// Extra band of stars around the horizon, more distant and narrower still
cylinder { <0,-0.04, 0> , <0, 0.04, 0> 1.6 open
         texture {Starz2 scale 1}
         rotate <0, 270, 0>
         scale 2000000
}

} // end union

object {supersky
        rotate < 35, 0, 0 > // set inclination to horizon
        rotate < 0, -175, 0>  // spin about the zenith
 hollow
}

// We are in space so not much ambient light...

#default {texture {finish {reflection 0.02 specular 0.1 ambient 0.02}}}

#declare Metallic =
texture {
    pigment { color LightGray }
    finish {
        ambient 0.02
        diffuse 0.7
        reflection 0.15
        brilliance 8
        specular 0.8
        roughness 0.1
    }
}

#declare Metal2 =
texture {
    pigment { color Gray95 }
    finish {
        ambient 0.02
        diffuse 0.85
        reflection 0.15
        brilliance 5
        specular 0.8
        roughness 0.1
    }
}

// Metal3 has a very slight blue tint to avoid a 100% monochrome image.
#declare Metal3 =
texture {
    pigment { color rgb <0.88, 0.90, 0.93> }
    finish {
        ambient 0.02
        diffuse 0.85
        reflection 0.15
        brilliance 5
        specular 0.8
        roughness 0.1
    }
}


camera {
   location  <74, 3, 15>
   direction <0, 0, 1.0>
   sky <0,1,0.2>
   look_at   <0, 0,  0>
}

light_source {<2000, 3000, 7000> colour White}
light_source {<2000, 3000, 7000> colour Gray50}

// Boosted light source for extreme lighting

// These values flash the red lights (if they are included)
#declare pulse1=cos(clock*360*3)*cos(clock*360*3)
#declare pulse2=sin(clock*360*3)*sin(clock*360*3)

#declare donut1=
// rotate a 2-D outline of points around the Y axis to create a 3-D shape
// This is the main body of the station 'rings'
// Note the dimensions:
// Inside radius 26
// Outside radius 35.1
// Top & bottom, plus or minus 2.5 ridges 2.8

lathe {
  linear_spline
  20, // number of points
  <26,0>
  <26,2>
  <26.5,2.5>
  <30,2.5>
  <30.5,2.8>
  <31,2.5>
  <34.5,2.5>
  <35,2>
  <35,1.2>
  <35.1, 1.05>
  <35.1,1-0.05>
  <35,1-0.2>
  <35,-2.0>
  <34.5,-2.5>
  <31,-2.5>
  <30.5,-2.8>
  <30,-2.5>
  <26.5,-2.5>
  <26,-2>
  <26,0>
}

// Add bumps and  ridges and stuff to the inhabited bits...
#declare habitat= union {
 object {donut1}
#declare tcount=0
#declare segs=36
#while (tcount < segs)
    cylinder {<0,-1.5,26> <0,1.5,26> 0.15  rotate <0,10*tcount,0>}
    sphere {<0,0,26> 0.2  rotate <0,5+10*tcount,0>}
    sphere {<0, 2.4,27.3> 0.2  rotate <0,5+10*tcount,0> pigment {Gray50}}
    sphere {<0,-2.4,27.3> 0.2  rotate <0,5+10*tcount,0> pigment {Gray50}}
    sphere {<0, 2.4,34.1> 0.2  rotate <0,5+10*tcount,0> pigment {Gray50}}
    sphere {<0,-2.4,34.1> 0.2  rotate <0,5+10*tcount,0> pigment {Gray50}}

   #declare tcount=tcount + 1
#end
torus {26.1,0.2 translate <0, 1.5,0>}
torus {26.1,0.2 translate <0,-1.5,0>}
torus {26.1,0.2 translate <0, 1.8,0> texture {Metal2}}
torus {26.1,0.2 translate <0,-1.8,0>texture {Metal2}}

torus {27,0.2 translate <0,-2.5,0>}
torus {27,0.2 translate <0, 2.5,0>}

torus {34.2 ,0.2 translate <0, 2.5,0>}
torus {34.2 ,0.2 translate <0,-2.5,0>}

// outer nobbly bits
#declare tcount=0
#declare segs=72
#while (tcount < segs)
    sphere   {<0,1,35> 0.20  rotate <0,5*tcount,0> pigment {Gray40}}
    cylinder {<0,2.8,30.5> <0,-2.8,30.5> 0.35 rotate <0,5*tcount,0> pigment
{Gray50}}
   #declare tcount=tcount + 1
#end

// outer railing supports
#declare tcount=0
#declare segs=120
#while (tcount < segs)
    cylinder {<0, 2,34.8> <0, 2,35.8> 0.2 rotate <0,5*tcount,0> texture
{Metal2}}
    cylinder {<0,-2,34.8> <0,-2,35.8> 0.2 rotate <0,5*tcount,0> texture
{Metal2}}
   #declare tcount=tcount + 1
#end
// Add the outer railings
torus {35.8 0.2 translate <0, 2,0>  texture {Metal2}}
torus {35.8 0.2 translate <0,-2,0>  texture {Metal2}}

#declare tcount=0
#declare segs=20
#while (tcount < segs)
    cylinder {<0, 2.45,27> <0, 2.45,34> 0.2  rotate <0,9+18*tcount,0>}
    cylinder {<0,-2.45,27> <0,-2.45,34> 0.2  rotate <0,9+18*tcount,0>}
    cylinder {<0,-2,34.9> <0,2,34.9>    0.2  rotate <0,9+18*tcount,0>}

// This adds some nobbly bits on the outside rings - I don't like it!
/*
    cylinder {<0,  -0.3,34> <0,   -0.3,35.1> 0.7 rotate <0,14+18*tcount,0>
texture {Metal2}}
    cylinder {<0,  -0.3,34> <0,   -0.3,35.1> 0.7 rotate <0,   18*tcount,0>
texture {Metal2}}
    box      {<0.7,-0.3,34> <-0.7,-0.8,35.1>     rotate <0, 6+18*tcount,0>
texture {Metal2}}
*/
   #declare tcount=tcount + 1
#end


#declare tcount=0
#declare segs=72
#while (tcount < segs)
//  sphere   {<0,0,35> 0.15  rotate <0,5*tcount,0>}
    cylinder {<0,2.8,30.5> <0,-2.8,30.5> 0.35 rotate <0,5*tcount,0> pigment {Gray50}}
   #declare tcount=tcount + 1
#end

// This section adds some pulsing lights at the arm ends
// Removed because I didnt like the effect..
/*
// create a regular point light source
light_source
 {
  <0,0,0>                           // light's position (translated below)
  color rgb <pulse1 0 0>  // light's color
  translate <0, 0, 35.4>
  fade_distance 1.3
  fade_power 2
  looks_like { sphere { 0*x, 0.2 pigment { color rgb <pulse1 0 0> } finish
{ambient 1}} }
 }
// create a regular point light source
light_source
 {
  <0,0,0>                           // light's position (translated below)
  color rgb <pulse1 0 0>  // light's color
  translate <0, 0, -35.4>
  fade_distance 1.3
  fade_power 2
  looks_like { sphere { 0*x, 0.2 pigment { color rgb <pulse1 0 0> } finish
{ambient 1}} }
 }
// create a regular point light source
light_source
 {
  <0,0,0>                           // light's position (translated below)
  color rgb <pulse1 0 0>  // light's color
  translate <35.4,0,0>
  fade_distance 1.3
  fade_power 2
  looks_like { sphere { 0*x, 0.2 pigment { color rgb <pulse1 0 0> } finish
{ambient 1}} }
 }
// create a regular point light source
light_source
 {
  <0,0,0>                           // light's position (translated below)
  color rgb <pulse1 0 0>  // light's color
  translate <-35.4,0,0>
  fade_distance 1.3
  fade_power 2
  looks_like { sphere { 0*x, 0.2 pigment { color rgb <pulse1 0 0> } finish
{ambient 1}} }
 }
*/
} // end ring structure

// Start on the radial 'arms'connecting the core to the outer rings

#declare support =union{
  cylinder {<0,-1.7,0> <0,1.7,0> 0.2}
  cylinder {<-1.7,0,0> <1.7,0,0> 0.2}
}

// This bit adds pylons along the station 'arms'
#declare strut=union {
  cylinder{<27,0,0> <-27,0,0> 1 }
  box {<-1.2,-0.2,27> <1.2, 0.2,-27> }
  box {<-0.2,-1.2,27> <0.2, 1.2,-27> }
#declare tcount=0
#declare segs=27
#while (tcount < segs)
   object {support translate <0,0,-26+2*tcount> }
   #declare tcount=tcount + 1
#end

// Here are the cables along the station arms
cylinder {<0, 1.7,27> <0, 1.7,-27> 0.2 texture {Metal3} }
cylinder {<0,-1.7,27> <0,-1.7,-27> 0.2 texture {Metal3} }
cylinder {< 1.7,0,27> < 1.7,0,-27> 0.2 texture {Metal3} }
cylinder {<-1.7,0,27> <-1.7,0,-27> 0.2 texture {Metal3} }

// Add a couple of extra cylinders at arm attachment points:
cylinder {<0,0, 26.3> <0,0, 25.4> 2 pigment {Gray55} }
cylinder {<0,0,-26.3> <0,0,-25.4> 2 pigment {Gray55} }
cylinder {<0,0, 5> <0,0, 6> 2 pigment {Gray55} }
cylinder {<0,0,-5> <0,0,-6> 2 pigment {Gray55} }

} // end arm assembly...

// Here's the central module...
#declare core=union{
lathe {
  linear_spline
  17, // number of points
  <0,  10>
  <3,  10>
  <3,  16>
  <5.5,16>
  <5.5,8>
  <3,  5>
  <3,  1>
  <3.5,1>
  <3.5,-1>
  <3,  -1>
  <3,  -5>
  <5.5,-8>
  <5.5,-16>
  <3,  -16>
  <3,  -10>
  <0,  -10>
  <0,   10>
}  // end lathe

// Rings at top and bottom of the core, for circular ridges

torus {5.4 0.2   translate <0,-15>}
torus {5.4 0.2   translate <0, 15>}

torus {5.4 0.2   translate <0, 8.5>texture {Metal3}}
torus {5.4 0.2   translate <0, 9.5>texture {Metal3}}
torus {5.4 0.2   translate <0,-8.5>texture {Metal3}}
torus {5.4 0.2   translate <0,-9.5>texture {Metal3}}

torus {5.3, 0.2   translate <0, 15.95>texture {Metal3}}
torus {3.2, 0.2   translate <0, 15.95>texture {Metal3}}
torus {5.3, 0.2   translate <0,-15.95>texture {Metal3}}
torus {3.2, 0.2   translate <0,-15.95>texture {Metal3}}

#declare tcount=0
#declare segs=12
#while (tcount < segs)
    cylinder {<3, 15.95, 0> <5.4, 15.95, 0> 0.2  rotate
<0,30*tcount,0>texture
{Metal2}}
    cylinder {<3,-15.95, 0> <5.4,-15.95, 0> 0.2  rotate
<0,30*tcount,0>texture
{Metal2}}
   #declare tcount=tcount + 1
#end

pigment {White}
}  // end union


// Join the outer ring to the spokes:

#declare ring=union {
  object {habitat }
  object {strut   }
  object {strut rotate <0,90,0>}
}


// Note! If you don't mind losing the part constructed bit, just duplicate
// the ring defined above for MUCH faster rendering! It's the extensive 
// use of DIFFERENCE that seems to slow it down.


// Hollow out the second ring, ready for clipping
// This gives a hollow interior to the part built sections

#declare ringa=difference {
    object {ring}
  lathe {
  linear_spline
  4, // number of points
  <26.2,  -2.3>
  <34.9, -2.3>
  <34.9,  2.3>
  <26.2, 2.3>
 }
}

// Clip out the missing sections
// This means there's just a short solid section on the end of each arm.
#declare ringb=difference {
    object {ringa}
    box {<7.5,-3,7><59,+3,59> rotate <0,000,0> }
    box {<7.5,-3,7><59,+3,59> rotate <0,090,0> }
    box {<7.5,-3,7><59,+3,59> rotate <0,180,0> }
    box {<7.5,-3,7><59,+3,59> rotate <0,270,0> }
}

// Now add the hoops that the new builts are being built on
// These are 'ring' girders in effect

#declare ringc=union{

object {ringb}
 lathe {
  linear_spline
  4, // number of points
  <34.7,  -2.1>
  <34.7, -2.3>
  <34.5,- 2.3>
  <34.5,-2.1>
texture {Metal3}
 }
 lathe {
  linear_spline
  4, // number of points
  <34.7, 2.1>
  <34.7, 2.3>
  <34.5, 2.3>
  <34.5,2.1>
texture {Metal3}
 }
 lathe {
  linear_spline
  4, // number of points
  <26.4, 2.1>
  <26.4, 2.3>
  <26.2, 2.3>
  <26.2,2.1>
texture {Metal3}
 }
 lathe {
  linear_spline
  4, // number of points
  <26.4, -2.1>
  <26.4, -2.3>
  <26.2, -2.3>
  <26.2,-2.1>
texture {Metal3}
 }
 lathe {
  linear_spline
  4, // number of points
  <30.4, 2.1>
  <30.4, 2.3>
  <30.2, 2.3>
  <30.2,2.1>
texture {Metal3}
 }
 lathe {
  linear_spline
  4, // number of points
  <30.4, 2.1>
  <30.4, 2.3>
  <30.2, 2.3>
  <30.2,2.1>
texture {Metal3}
  }
}

#declare ringd=union{


// Here come the radial and verticval girders
object {ringc}
#declare tcount=0
#declare segs=36
#while (tcount < segs)
   #declare tcount=tcount + 1
   box {<-0.1,-2.1,26.2><+0.1,+2.1,26.4> texture {Metal2} rotate <0,10*tcount,0>}
   box {<-0.1,-2.1,30.2><+0.1,+2.1,30.4> texture {Metal2} rotate <0,10*tcount,0>}
   box {<-0.1,-2.1,34.5><+0.1,+2.1,34.7> texture {Metal2} rotate <0,10*tcount,0>}
   box {<-0.1,+2.1,26.2><+0.1,+2.3,34.7> texture {Metal2} rotate <0,10*tcount,0>}
   box {<-0.1,-2.1,26.2><+0.1,-2.3,34.7> texture {Metal2} rotate <0,10*tcount,0>}
   #end
}

#declare shebang=union{

object {ring  translate <0,-12.5,0> }
object {ringd translate <0, 12.5,0>}
object {core}
}


And finally, add in the object we have defined
object {shebang rotate <0,90*clock,0>}
// tail end edit buffer
