//  Persistance of Vision Raytracer V2.2
//  World definition file.
//
//  Contains 1 lights, 95 textures and 283 primitives.
//
//  This file was generated for POV-Ray V2.2 by
//  MORAY.EXE V2.02.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 09/17/1996    (17.09.1996)
//
//  atmosphere {
 //   type 1
//    samples 50
//    distance 40
  //  scattering 0.2
 //   aa_level 4
 //   aa_threshold 0.1
//    jitter 0.2
 // }
#max_trace_level 5


//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//


/*
camera {  //  Camera StdCam
  location  <11.141, -15.616, -4.042>
  direction <0.0,     0.0,  1.8316>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.310, 9.091, -1.988>
}
*/

//    Other cameras are commented out.
//door in the way? Maybe kill door?

camera {  //  Camera Camera01
  location  <-4.564, 15.232, -2.370>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <1.956, 8.010, -2.103>
}



//pretty good one the alien working on the other alien
/*
camera {  //  Camera Camera02
  location  <-2.952, -25.412, 2.091>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.912, -10.252, -1.327>
}
*/


//not very good, view of monsters back...
/*
camera {  //  Camera Camera03
  location  <-21.496, -3.849, -0.237>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <8.816, -1.682, -3.655>
}
*/

//pretty good shot of human quite low to ground
/*
camera {  //  Camera Camera04
  location  <1.304, 20.990, -5.473>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-1.824, -0.854, -2.297>
}
*/


//real good one shows man scene is hard to understand :(
/*
camera {  //  Camera Camera05
  location  <-17.544, -24.112, 5.000>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <0.000, -0.388, -3.849>
}
*/





// *******  L I G H T S *******
light_source {   // Spotlight SpotL001
  <-0.369, -10.056, 4.525>
  color  rgb <1.000, 1.000, 0.000>
  spotlight
    point_at  <-0.369, -10.056, 3.525>
    falloff   50.0  // outer radius (in deg)
      radius    36.0  // inner radius
}

#declare ALight= box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    pigment { color rgbt <1,1,1,1> }
    scale <24.0, 24.0, 1.0>
    //translate  <0.0, -25.0, 11.464154>
  }
light_source { // AreaL001
  <0.000, 0.000, 0.000>
  color  rgb<1.000, 1.000, 1.000>
  area_light <48.000, 0.000, 0.000>, <0.000, 48.000, 0.000>, 5, 5
  //adaptive 1
  //jitter
  translate  <0.0, -25.0, 11.464154>
}


// ********  TEXTURES  *******
//

#include "irtc2.inc"

sky_sphere {  pigment {
     bozo
     color_map {
       [ 0.000  color rgb<0.250, 0.250, 0.500> ]
       [ 0.500  color rgb<0.250, 0.250, 0.500> ]
       [ 0.600  color rgb<0.700, 0.700, 0.700> ]
       [ 1.000  color rgb<0.300, 0.300, 0.300> ]
     }
     turbulence 0.300
   }
}

// ********  REFERENCED OBJECTS  *******


//
// Include file contains 'RotSwp001'
//
#include "irtc2.in1"
#declare RotSwp001 = object {
  RotSwp001_Raw
  scale 1.640131
  translate  <7.564305, 4.374355, -4.433505>
}
#declare OilDrums = union { // OilDrums
  object { // RotSwp8->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 0.0>
    translate  <8.728045, -11.055523, 0.0>
  }
  object { // RotSwp7->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 0.0>
    translate  <-34.126053, -11.58998, 0.0>
  }
  object { // RotSwp6->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 0.0>
    translate  <-38.633267, -23.17996, 0.0>
  }
  object { // RotSwp5->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 0.0>
    translate  <-39.277155, -5.151102, 0.0>
  }
  object { // RotSwp4->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 0.0>
    translate  <16.097195, -2.575551, 0.0>
  }
  object { // RotSwp3->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 0.0>
    translate  <7.082766, -20.604409, 0.0>
  }
  object { // RotSwp2->RotSwp001
    RotSwp001
    rotate <0.0, 0.0, 0.0>
    translate  <-22.111046, -2.618413, 0.0>
  }
  object { RotSwp001 }
  texture {
    OilDrum
  }
}


#declare Barrel1 = difference {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*x
    translate  <0.0, 1.086938, 2.875126>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.7, 0.7, 1.1>
    rotate 90.0*x
    translate  <0.0, 1.180892, 2.865055>
  }
  texture {
    Chrome_Textur2
  }
  scale <0.1, 3.0, 0.1>
  translate  <-0.006384, -5.414695, -0.936624>
}


#declare Mouth = blob {
  threshold 0.6
  component 1.0, 0.259251, <0.0, 0.19011, -0.487372>

  component 1.0, 0.216465, <0.0, 0.120979, -0.618721>

  component 1.0, 0.182006, <0.0, -0.015928, -0.720288>

  component 1.0, 0.170169, <0.0, -0.07256, -0.84417>

  component 1.0, 0.147982, <0.0, -0.044244, -0.91496>

  component 1.0, 0.121362, <0.0, 0.054862, -0.978671>

  component 1.0, 0.099465, <0.0, 0.157508, -0.971592>

  component 1.0, 0.070333, <0.0, 0.242456, -0.953895>

  component 1.0, 0.182006, <0.125652, -0.026546, -0.720288>

  component 1.0, 0.170169, <0.228298, -0.054862, -0.84417>

  component 1.0, 0.147982, <0.309706, -0.093797, -0.91496>

  component 1.0, 0.121362, <0.35572, -0.012388, -0.978671>

  component 1.0, 0.121362, <0.348641, 0.040704, -0.978671>

  component 1.0, 0.099465, <0.359259, 0.118573, -0.971592>

  component 1.0, 0.070333, <0.373417, 0.189363, -0.953895>

  component 1.0, 0.182006, <-0.125652, -0.026546, -0.720288>

  component 1.0, 0.121362, <-0.348641, 0.040704, -0.978671>

  component 1.0, 0.099465, <-0.359259, 0.118573, -0.971592>

  component 1.0, 0.070333, <-0.373417, 0.189363, -0.953895>

  component 1.0, 0.121362, <-0.35572, -0.012388, -0.978671>

  component 1.0, 0.147982, <-0.309706, -0.093797, -0.91496>

  component 1.0, 0.170169, <-0.228298, -0.054862, -0.84417>

  texture {
    Texture3
  }
  scale 2.0
  rotate -85.820084*x
  translate  <0.0, -0.135032, -0.415095>
}

#declare Horn = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.804274, 0.000000, -0.762032>, <3.804274, -1.000000, -0.762032>, <3.810547, -1.000000, 1.237958>, <3.810547, 0.000000, 1.237958>,
      <1.804284, 0.000000, -0.755759>, <1.804284, -1.000000, -0.755759>, <1.810556, -1.000000, 1.244231>, <1.810556, 0.000000, 1.244231>,
      <-3.800457, 0.000000, 1.598913>, <-3.800457, -1.000000, 1.598913>, <-2.600915, -1.000000, 3.199256>, <-2.600915, 0.000000, 3.199256>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.810547, 0.000000, 1.237958>, <3.810547, 1.000000, 1.237958>, <3.804274, 1.000000, -0.762032>, <3.804274, 0.000000, -0.762032>,
      <1.810556, 0.000000, 1.244231>, <1.810556, 1.000000, 1.244231>, <1.804284, 1.000000, -0.755759>, <1.804284, 0.000000, -0.755759>,
      <-2.600915, 0.000000, 3.199256>, <-2.600915, 1.000000, 3.199256>, <-3.800457, 1.000000, 1.598913>, <-3.800457, 0.000000, 1.598913>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  texture {
    Mskin3
  }
  scale 0.2
  rotate <-102.8181, 28.257862, 55.896023>
  translate  <-0.877629, -0.081346, 1.414243>
}
#declare Horn4 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.804274, 0.000000, -0.762032>, <3.804274, -1.000000, -0.762032>, <3.810547, -1.000000, 1.237958>, <3.810547, 0.000000, 1.237958>,
      <1.804284, 0.000000, -0.755759>, <1.804284, -1.000000, -0.755759>, <1.810556, -1.000000, 1.244231>, <1.810556, 0.000000, 1.244231>,
      <-0.980622, 0.000000, 2.726847>, <-0.980622, -1.000000, 2.726847>, <0.218920, -1.000000, 4.327190>, <0.218920, 0.000000, 4.327190>,
      <2.690157, 0.000000, 7.761705>, <2.690157, 0.000000, 7.761705>, <2.690156, 0.000000, 7.761705>, <2.690156, 0.000000, 7.761705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.810547, 0.000000, 1.237958>, <3.810547, 1.000000, 1.237958>, <3.804274, 1.000000, -0.762032>, <3.804274, 0.000000, -0.762032>,
      <1.810556, 0.000000, 1.244231>, <1.810556, 1.000000, 1.244231>, <1.804284, 1.000000, -0.755759>, <1.804284, 0.000000, -0.755759>,
      <0.218920, 0.000000, 4.327190>, <0.218920, 1.000000, 4.327190>, <-0.980622, 1.000000, 2.726847>, <-0.980622, 0.000000, 2.726847>,
      <2.690156, 0.000000, 7.761705>, <2.690156, 0.000000, 7.761705>, <2.690157, 0.000000, 7.761705>, <2.690157, 0.000000, 7.761705>
    }
  }
  texture {
    Mskin3
  }
  scale 0.15
  rotate <-111.299995, 0.422729, -172.103149>
  translate  <0.952332, -0.325152, -1.112168>
}
#declare ConeHorn6 = object {
  cone { // ConeHorn6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Mskin3
    }
    scale <0.2, 0.2, 1.0>
    rotate -128.386551*x
    translate  <0.0, -1.365102, 1.365102>
  }
}
#declare tent1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.322683, 0.000000, -0.660190>, <-3.322683, -1.000000, -0.660190>, <-1.548354, -1.000000, -1.583098>, <-1.548354, 0.000000, -1.583098>,
      <-0.939898, 0.000000, 7.054405>, <-0.939898, -1.000000, 7.054405>, <-1.041831, -1.000000, 5.057004>, <-1.041831, 0.000000, 5.057004>,
      <9.602128, 0.000000, -2.431546>, <9.602128, -1.000000, -2.431546>, <11.602124, -1.000000, -2.435408>, <11.602124, 0.000000, -2.435408>,
      <13.444336, 0.000000, 2.348920>, <13.444336, -0.039474, 2.348920>, <13.398336, -0.039474, 2.355794>, <13.398336, 0.000000, 2.355794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.548354, 0.000000, -1.583098>, <-1.548354, 1.000000, -1.583098>, <-3.322683, 1.000000, -0.660190>, <-3.322683, 0.000000, -0.660190>,
      <-1.041831, 0.000000, 5.057004>, <-1.041831, 1.000000, 5.057004>, <-0.939898, 1.000000, 7.054405>, <-0.939898, 0.000000, 7.054405>,
      <11.602124, 0.000000, -2.435408>, <11.602124, 1.000000, -2.435408>, <9.602128, 1.000000, -2.431546>, <9.602128, 0.000000, -2.431546>,
      <13.398336, 0.000000, 2.355794>, <13.398336, 0.039474, 2.355794>, <13.444336, 0.039474, 2.348920>, <13.444336, 0.000000, 2.348920>
    }
  }
  scale 0.5
  rotate <11.711938, 67.919121, 130.126602>
  translate  <-0.919191, 1.462037, -0.507539>
}
#declare Fingers2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.609673, 0.000000, 4.084341>, <5.609673, -0.010724, 4.084341>, <5.610074, -0.019497, 4.092551>, <5.610565, -0.019497, 4.102585>,
      <2.375984, 0.000000, -3.266339>, <2.375984, -0.550000, -3.266339>, <2.343677, -1.000000, -2.817501>, <2.304190, -1.000000, -2.268920>,
      <-1.607547, 0.000000, 1.814970>, <-1.607547, -0.550000, 1.814970>, <-1.226156, -1.000000, 1.576137>, <-0.760012, -1.000000, 1.284230>,
      <1.919528, -0.002125, 5.131287>, <1.919528, 0.006066, 5.131287>, <1.926927, 0.012767, 5.126654>, <1.935969, 0.012767, 5.120991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.610565, -0.019497, 4.102585>, <5.611055, -0.019497, 4.112619>, <5.611456, -0.010724, 4.120829>, <5.611456, 0.000000, 4.120829>,
      <2.304190, -1.000000, -2.268920>, <2.264704, -1.000000, -1.720339>, <2.232396, -0.550000, -1.271500>, <2.232396, 0.000000, -1.271500>,
      <-0.760012, -1.000000, 1.284230>, <-0.293868, -1.000000, 0.992323>, <0.087523, -0.550000, 0.753490>, <0.087523, 0.000000, 0.753490>,
      <1.935969, 0.012767, 5.120991>, <1.945011, 0.012767, 5.115329>, <1.952410, 0.006066, 5.110696>, <1.952410, -0.002125, 5.110696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.611456, 0.000000, 4.120829>, <5.611456, 0.010724, 4.120829>, <5.611055, 0.019497, 4.112619>, <5.610565, 0.019497, 4.102585>,
      <2.232396, 0.000000, -1.271500>, <2.232396, 0.550000, -1.271500>, <2.264704, 1.000000, -1.720339>, <2.304190, 1.000000, -2.268920>,
      <0.087523, 0.000000, 0.753490>, <0.087523, 0.550000, 0.753490>, <-0.293868, 1.000000, 0.992323>, <-0.760012, 1.000000, 1.284230>,
      <1.952410, -0.002125, 5.110696>, <1.952410, -0.010315, 5.110696>, <1.945011, -0.017016, 5.115329>, <1.935969, -0.017016, 5.120991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.610565, 0.019497, 4.102585>, <5.610074, 0.019497, 4.092551>, <5.609673, 0.010724, 4.084341>, <5.609673, 0.000000, 4.084341>,
      <2.304190, 1.000000, -2.268920>, <2.343677, 1.000000, -2.817501>, <2.375984, 0.550000, -3.266339>, <2.375984, 0.000000, -3.266339>,
      <-0.760012, 1.000000, 1.284230>, <-1.226156, 1.000000, 1.576137>, <-1.607547, 0.550000, 1.814970>, <-1.607547, 0.000000, 1.814970>,
      <1.935969, -0.017016, 5.120991>, <1.926927, -0.017016, 5.126654>, <1.919528, -0.010315, 5.131287>, <1.919528, -0.002125, 5.131287>
    }
  }
  texture {
    Mskin3
  }
  scale 0.171023
  rotate <23.709785, 57.765511, 20.37924>
  translate  <-2.846859, -1.577309, -1.151177>
}
#declare Arms = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.284189, 0.000000, -5.931815>, <5.284189, -1.000000, -5.931815>, <7.095379, -1.000000, -5.083529>, <7.095379, 0.000000, -5.083529>,
      <0.646171, 0.000000, 0.718696>, <0.646171, -1.000000, 0.718696>, <2.155666, -1.000000, -0.593334>, <2.155666, 0.000000, -0.593334>,
      <7.030238, 0.000000, 3.301731>, <7.030238, -1.000000, 3.301731>, <8.962018, -1.000000, 2.783826>, <8.962018, 0.000000, 2.783826>,
      <15.271366, 0.000000, 2.754927>, <15.271366, -0.039474, 2.754927>, <15.225366, -0.039474, 2.761800>, <15.225366, 0.000000, 2.761800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.095379, 0.000000, -5.083529>, <7.095379, 1.000000, -5.083529>, <5.284189, 1.000000, -5.931815>, <5.284189, 0.000000, -5.931815>,
      <2.155666, 0.000000, -0.593334>, <2.155666, 1.000000, -0.593334>, <0.646171, 1.000000, 0.718696>, <0.646171, 0.000000, 0.718696>,
      <8.962018, 0.000000, 2.783826>, <8.962018, 1.000000, 2.783826>, <7.030238, 1.000000, 3.301731>, <7.030238, 0.000000, 3.301731>,
      <15.225366, 0.000000, 2.761800>, <15.225366, 0.039474, 2.761800>, <15.271366, 0.039474, 2.754927>, <15.271366, 0.000000, 2.754927>
    }
  }
  texture {
    MSkin1
  }
  scale <0.5, 0.4, 0.5>
  rotate <-119.607353, 62.058563, -132.962631>
  translate  <4.512716, 1.513863, 0.857027>
}




// ********  OBJECTS  *******



// Include contains 'TraSwp002'
#include "irtc2.in2"

#declare TraSwp002 = object {
  TraSwp002_Raw
  texture {
    Walkway
  }
  scale <3.906248, 5.779809, 2.886785>
  rotate 90.0*x
  translate  <0.430803, 9.629318, -2.150914>
}
union { // Buidling
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <45.455513, 1.0, 34.300735>
    rotate -90.0*x
    translate  <3.920771, -25.099458, 47.774732>
  }
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <48.71846, 1.0, 34.300735>
    translate  <6.500431, -58.507689, 13.621021>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <33.705284, 1.0, 34.300735>
    rotate -90.0*z
    translate  <47.95394, -24.592602, 13.621021>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <33.705284, 1.0, 34.300735>
    rotate -90.0*z
    translate  <-40.826202, -24.406683, 13.621021>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <45.455513, 1.0, 34.300735>
    rotate -90.0*x
    translate  <3.920771, -24.979882, 13.621021>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    scale <16.858856, 1.0, 10.554482>
    translate  <30.265281, 8.2, 2.823161>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <18.640203, 1.0, 10.598856>
    translate  <-22.14056, 8.2, 3.491327>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <16.858856, 1.0, 5.254815>
    translate  <2.442027, 8.2, 8.122829>
  }
  object { TraSwp002 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 21.553806>
    rotate 25.372349*z
    translate  <12.503552, 1.606789, 5.110746>
  }
  texture {
    Rusty_Iron4
  }
}



#declare SUN = sphere { // Sun
  <0,0,0>,1
  //texture {
  //  Generic
  //}
  pigment { color rgbt <1,1,1,1>}
  halo {emitting
       spherical_mapping
       linear
       color_map {[ 0 rgbt <1,.5,0,1>]
                   [ 1 rgbt <1,1,0,-1>]
                  }
       samples 10
       }

  scale 221.43161
  //translate  <0.0, 2908.225826, 949.568945>
  hollow
}

light_source { <0.0, 2908.225826, 949.568945>
               color rgb <1,1,1>
               area_light <2,0,0>,<0,0,2>,2,2
               adaptive 1
               jitter
               looks_like {SUN}
               }
sphere { // Sphere63
  <0,0,0>,1
  texture {
    Blood
  }
  rotate <-164.464828, 6.279124, 151.087234>
  translate  <10.92901, -6.111543, -1.533716>
}


sphere { // Sphere013
  <0,0,0>,1
  texture {
    Blood
  }
  translate  <9.453703, -4.653995, -1.667083>
}


sphere { // EXP
  <0,0,0>,1
  //texture {
  //  Generic
  //}
  pigment {color rgbt <1,1,1,1>}
   halo {
      emitting
      spherical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, 0> ]
      }
      samples 10
    }
  hollow
  scale 0.4
  translate  <0.988607, 5.971081, -1.572384>
}


cylinder { // Shot
  <0,0,1>, <0,0,0>, 1
  pigment { color rgbt <1,1,1,1>}
  //texture {
   // Generic
  //}
   halo {
      emitting
      cylindrical_mapping
      linear
      color_map {
        [ 0 color rgbt <1, 0, 0, 1> ]
        [ 1 color rgbt <1, 1, 0, 0> ]
      }
      samples 10
    }
    hollow

  scale <0.1, 0.1, 70.0>
  rotate <-90.0, 0.0, -141.082214>
  translate  <0.852124, 6.125474, -1.605431>
  hollow
}


#declare CSG002 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.506088, 2.058383>
    rotate 30.838072*x
    translate  <0.0, 3.034032, -1.693413>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <0.752358, 0.741431, 0.429513>
    translate  <0.0, 3.901728, -3.41746>
  }
  texture {
    Rusty_Iron3
  }
}
// Include contains 'TraSwp001'
#include "irtc2.in3"

#declare TraSwp001 = object {
  TraSwp001_Raw
  texture {
    Trigger2
  }
  scale <0.3, 0.3, 0.25>
  rotate <-90.0, 0.0, 90.0>
  translate  <0.125, 1.761053, -1.2>
}
#declare CSG2 = merge {
  sphere { // Sphere30
    <0,0,0>,1
    texture {
      Copper_Metal3
    }
    scale <1.0, 3.0, 1.0>
  }
  sphere { // Sphere31
    <0,0,0>,1
    texture {
      Barrels2
    }
    scale <0.5, 3.0, 0.5>
    translate  -0.976934*x
  }
  sphere { // Sphere32
    <0,0,0>,1
    texture {
      Barrels2
    }
    scale <0.5, 3.0, 0.5>
    rotate -90.0*y
    translate  <0.0, 0.0, -0.976934>
  }
  sphere { // Sphere33
    <0,0,0>,1
    texture {
      Barrels2
    }
    scale <0.5, 3.0, 0.5>
    rotate <180.0, 0.0, 180.0>
    translate  <0.976934, 0.0, 0.0>
  }
  sphere { // Sphere34
    <0,0,0>,1
    texture {
      Barrels2
    }
    scale <0.5, 3.0, 0.5>
    rotate 90.0*y
    translate  <0.0, 0.0, 0.976934>
  }
}
#declare Barrel24 = difference {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*x
    translate  <0.0, 1.086938, 2.875126>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.7, 0.7, 1.1>
    rotate 90.0*x
    translate  <0.0, 1.180892, 2.865055>
  }
  texture {
    Chrome_Textur3
  }
  scale <0.1, 3.0, 0.1>
  translate  <-0.006384, -5.414695, -0.936624>
}
#declare Barrel25 = difference {
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*x
    translate  <0.0, 1.086938, 2.875126>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.7, 0.7, 1.1>
    rotate 90.0*x
    translate  <0.0, 1.180892, 2.865055>
  }
  texture {
    Copper_Metal3
  }
  scale <0.5, 3.0, 0.5>
  translate  <0.0, -5.414695, -1.496166>
}
#declare Gun1 = union {
  box { // ube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Barrels2
    }
    scale <0.2, 0.4, 0.7>
    rotate -44.732174*x
    translate  <0.0, 3.49753, 0.174876>
  }
  object { CSG002 }
  object { TraSwp001 }
  torus { // Torus001
    1.75, 0.25  rotate -x*90
    texture {
      Trigger2
    }
    scale <0.275809, 0.6, 0.334009>
    rotate <-90.0, -77.130638, 90.0>
    translate  <0.0, 1.81634, -1.3>
  }
  sphere { // Sphere29
    <0,0,0>,1
    texture {
      Rusty_Iron3
    }
    translate  2.7*y
  }
  object { CSG2 }
  object { // Barrel13->Barrel1
    Barrel1
    rotate 30.0*y
    translate  0.0*x
  }
  object { // Barrel14->Barrel1
    Barrel1
    rotate 60.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel15->Barrel1
    Barrel1
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel16->Barrel1
    Barrel1
    rotate <-180.0, 60.0, -180.0>
    translate  0.0*x
  }
  object { // Barrel17->Barrel1
    Barrel1
    rotate <-180.0, 30.0, -180.0>
    translate  0.0*x
  }
  object { // Barrel18->Barrel1
    Barrel1
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel19->Barrel1
    Barrel1
    rotate <180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel20->Barrel1
    Barrel1
    rotate <180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel21->Barrel1
    Barrel1
    rotate -90.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel22->Barrel1
    Barrel1
    rotate -60.0*y
    translate  0.0*z
  }
  object { // Barrel23->Barrel1
    Barrel1
    rotate <0.0, -30.0, 0.0>
  }
  object { Barrel24 }
  object { Barrel25 }
  scale 0.2
  rotate <0.0, 14.322882, -106.352013>
  translate  <-33.476023, 37.294966, -1.056972>
}
// The following include file contains the definition for TapSwp2
#include "irtc2.in4"
#declare TapSwp2 = object {
  TapSwp2_Raw
  texture {
    Brown_Leather
  }
  scale <3.38, 2.446577, 2.446577>
  rotate <-91.782211, 0.0, 0.0>
  translate  <9.010299, 19.962613, -17.863093>
}
#declare Leg10 = union {
  sphere { // Sphere46
    <0,0,0>,1
    texture {
      Smokey
    }
    scale <1.69, 1.95, 5.2>
    rotate <35.0, 0.0, 0.0>
    translate  <9.010299, 8.886878, -12.146608>
  }
  sphere { // Sphere47
    <0,0,0>,1
    texture {
      Camo
    }
    scale 1.3
    rotate 0.0*y
    translate  <9.010299, 12.006878, -16.826608>
  }
  sphere { // Sphere48
    <0,0,0>,1
    texture {
      Brown_Leather
    }
    scale <1.3, 1.69, 4.55>
    rotate <80.41658, 0.0, 0.0>
    translate  <9.010299, 16.505463, -17.603683>
  }
  object { TapSwp2 }
  scale 0.769231
  rotate <-92.050156, 0.0, 0.0>
  translate  <-8.36147, 6.07573, -7.686947>
}
// The following include file contains the definition for TapSwp001
#include "irtc2.in5"
#declare TapSwp001 = object {
  TapSwp001_Raw
  texture {
    Brown_Leather
  }
  scale <3.38, 2.446577, 2.446577>
  rotate <147.353531, 0.0, 0.0>
  translate  <19.662716, -0.873635, -24.02479>
}
#declare Leg11 = union {
  sphere { // Sphere49
    <0,0,0>,1
    texture {
      Smokey
    }
    scale <1.69, 1.95, 5.2>
    rotate <-35.851624, -14.231372, 6.814073>
    translate  <16.516771, 2.516878, -12.009902>
  }
  sphere { // Sphere50
    <0,0,0>,1
    texture {
      Camo
    }
    scale 1.3
    rotate 0.0*y
    translate  <18.036537, -0.863122, -16.176608>
  }
  sphere { // Sphere51
    <0,0,0>,1
    texture {
      Brown_Leather
    }
    scale <1.3, 1.69, 4.55>
    rotate <0.0, -11.016294, 0.0>
    translate  <19.049715, -1.123122, -20.849902>
  }
  object { TapSwp001 }
  scale 0.769231
  rotate <13.073331, 0.0, 0.0>
  translate  <-10.42172, -5.419014, -7.163868>
}
#declare Legs1 = union {
  object { Leg10 }
  object { Leg11 }
  scale 1.3
  translate  <0.0, 3.16977, 4.551604>
}
#declare Blob3 = blob {
  threshold 0.6
  component 1.0, 0.573216, <0.0, 0.017283, 0.024196>

  component 1.0, 0.428071, <0.0, -0.464135, -0.008439>

  component 1.0, 0.588446, <0.0, -0.16937, 0.210849>

  component 1.0, 0.100549, <0.0, -0.224675, -0.307632>

  component 1.0, 0.100549, <0.0, -0.176284, -0.217762>

  texture {
    Skin5
  }
  scale 3.4
  rotate <90.0, 0.0, 180.0>
}

#declare Mike = union {
  sphere { // Sphere012
    <0,0,0>,1
    texture {
      Texture01
    }
    scale 0.15
    translate  <13.547811, 2.759682, 5.550384>
  }
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture01
    }
    scale <0.1, 0.1, 1.4>
    rotate 90.0*y
    translate  <12.168371, 2.763311, 5.559225>
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    texture {
      Texture01
    }
    scale <0.1, 0.1, 3.0>
    rotate <-44.10096, 18.517778, -1.737649>
    translate  <13.556143, 2.727317, 5.534647>
  }
  scale 0.666667
  rotate 0.0*z
  translate  <-8.086866, -2.733333, -5.255241>
}
#declare Head6 = union {
  cone { // Cone7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Skin5
    }
    scale <1.0, 1.0, 3.0>
    rotate -160.0*x
    translate  <0.0, 0.1, -0.1>
  }
  disc { // Disc2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Sandalwood1
    }
    scale 0.4
    rotate 90.0*x
    translate  <-0.5, -1.0, 0.0>
  }
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Sandalwood1
    }
    scale 0.4
    rotate 90.0*x
    translate  <0.5, -1.0, 0.0>
  }
  sphere { // Sphere52
    <0,0,0>,1
    texture {
      EYe
    }
    scale 0.3
    rotate -90.0*x
    translate  <0.5, -0.7, 0.0>
  }
  sphere { // Sphere53
    <0,0,0>,1
    texture {
      EYe
    }
    scale 0.3
    translate  <-0.5, -0.7, 0.0>
  }
  object { Blob3 }
  sphere { // Sphere54
    <0,0,0>,1
    texture {
      Smokey
    }
    scale 1.318556
    translate  <-0.666667, 1.382267, -0.510998>
  }
  sphere { // Sphere55
    <0,0,0>,1
    texture {
      Smokey
    }
    scale 1.318556
    translate  <0.666667, 1.382267, -0.510998>
  }
  sphere { // Sphere56
    <0,0,0>,1
    texture {
      Smokey
    }
    scale 1.318556
    translate  <0.0, 0.6, 0.271269>
  }
  object { Mike }
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    texture {
      Silver4
    }
    scale <0.022222, 0.022222, 0.7>
    rotate <90.0, 20.794542, 90.0>
    translate  <-0.35, -0.975583, 0.255099>
  }
  scale 1.5
  translate  <0.0, -0.9, 3.7>
}
#declare Hand = blob {
  threshold 0.6
  component 1.0, 1.50823, <-0.413502, 0.025316, 0.0>

  component 1.0, 1.59972, <0.43038, -0.008439, 0.0>

  component 1.0, 1.45752, <-0.548523, -1.18987, 0.0>

  component 1.0, 1.4348, <0.700422, -1.20675, 0.0>

  component 1.0, 0.983246, <1.49367, -0.548523, 0.0>

  component 1.0, 0.747382, <1.72996, 0.109705, 0.0>

  component 1.0, 0.683805, <1.79747, 0.683544, 0.0>

  component 1.0, 0.676372, <1.82278, 1.21519, 0.0>

  component 1.0, 0.714533, <0.759494, 0.911392, 0.0>

  component 1.0, 0.676372, <0.742616, 1.50211, 0.0>

  component 1.0, 0.749914, <0.691983, 2.16034, 0.0>

  component 1.0, 0.708316, <0.599156, 2.79325, 0.0>

  component 1.0, 0.718941, <0.43038, 3.50211, 0.0>

  component 1.0, 0.679169, <-0.21097, 1.08861, 0.0>

  component 1.0, 0.714533, <-0.312236, 1.74684, 0.0>

  component 1.0, 0.629936, <-0.464135, 2.42194, 0.0>

  component 1.0, 0.698434, <-0.666667, 3.09705, 0.0>

  component 1.0, 0.715417, <-0.919831, 3.80591, 0.0>

  component 1.0, 0.640875, <-1.0211, 1.0211, 0.0>

  component 1.0, 0.621859, <-1.30802, 1.64557, 0.0>

  component 1.0, 0.670744, <-1.57806, 2.23629, 0.0>

  component 1.0, 0.620842, <-1.86498, 2.84388, 0.0>

  component 1.0, 1.21077, <-1.4346, -0.151899, 0.0>

  component 1.0, 1.24168, <-1.33333, -1.26582, 0.0>

  component 1.0, 0.670743, <-2.04219, 0.691983, 0.0>

  component 1.0, 0.674501, <-2.4135, 1.29958, 0.0>

  component 1.0, 0.78531, <1.80591, 1.90717, 0.0>

  component 1.0, 0.555298, <-2.75105, 1.77215, 0.0>

  texture {
    Bloody
  }
  scale 0.6
  rotate <29.657995, -68.259796, 117.45076>
  translate  <17.665246, -4.407007, 3.734686>
}

#declare Arm_2 = union {
  sphere { // Sphere57
    <0,0,0>,1
    texture {
      Jade1
    }
    scale <1.0, 1.0, 3.0>
    rotate <98.477005, -11.02941, -1.039989>
    translate  <19.430299, 4.0, 0.982862>
  }
  sphere { // Sphere58
    <0,0,0>,1
    texture {
      Bloody
    }
    scale <1.0, 1.0, 2.7>
    rotate <26.412161, -54.182297, 34.366825>
    translate  <18.360332, -1.801849, 1.929148>
  }
  sphere { // Sphere59
    <0,0,0>,1
    texture {
      Jade1
    }
    translate  <19.467142, 0.638521, 0.699891>
  }
  object { Hand }
  rotate <0.052429, -1.509344, -3.978632>
  translate  <-14.942141, -4.015808, -4.315602>
}
#declare Body2 = blob {
  threshold 0.6
  component 1.0, 0.455254, <0.0, -0.025316, 0.042194>

  component 1.0, 0.405325, <0.0, 0.413502, -0.008439>

  component 1.0, 0.449667, <-0.177215, 0.599156, 0.0>

  component 1.0, 0.449667, <0.177215, 0.599156, 0.0>

  component 1.0, 0.286608, <-0.177215, 0.194093, 0.0>

  component 1.0, 0.286608, <0.177215, 0.194093, 0.0>

  component 1.0, 0.286608, <0.379747, 0.700422, 0.0>

  component 1.0, 0.286608, <-0.379747, 0.700422, 0.0>

  component 1.0, 0.362534, <-0.008439, 0.616034, -0.14346>

  component 1.0, 0.355493, <-0.008439, -0.160338, 0.0>

  component 1.0, 0.25635, <0.244726, -0.177215, 0.0>

  component 1.0, 0.25635, <-0.244726, -0.177215, 0.0>

  texture {
    Smokey
  }
  scale 11.0
  rotate <90.0, 0.0, 180.0>
  translate  <0.000941, 1.976858, -9.98892>
}

#declare Hand1 = blob {
  threshold 0.6
  component 1.0, 1.50823, <-0.413502, 0.025316, 0.0>

  component 1.0, 1.59972, <0.43038, -0.008439, 0.0>

  component 1.0, 1.45752, <-0.548523, -1.18987, 0.0>

  component 1.0, 1.4348, <0.700422, -1.20675, 0.0>

  component 1.0, 0.983246, <1.49367, -0.548523, 0.0>

  component 1.0, 0.747382, <1.72996, 0.109705, 0.0>

  component 1.0, 0.683805, <1.79747, 0.683544, 0.0>

  component 1.0, 0.676372, <1.82278, 1.21519, 0.0>

  component 1.0, 0.714533, <0.759494, 0.911392, 0.0>

  component 1.0, 0.676372, <0.742616, 1.50211, 0.0>

  component 1.0, 0.749914, <0.691983, 2.16034, 0.0>

  component 1.0, 0.708316, <0.599156, 2.79325, 0.0>

  component 1.0, 0.718941, <0.43038, 3.50211, 0.0>

  component 1.0, 0.679169, <-0.21097, 1.08861, 0.0>

  component 1.0, 0.714533, <-0.312236, 1.74684, 0.0>

  component 1.0, 0.629936, <-0.464135, 2.42194, 0.0>

  component 1.0, 0.698434, <-0.666667, 3.09705, 0.0>

  component 1.0, 0.715417, <-0.919831, 3.80591, 0.0>

  component 1.0, 0.640875, <-1.0211, 1.0211, 0.0>

  component 1.0, 0.621859, <-1.30802, 1.64557, 0.0>

  component 1.0, 0.670744, <-1.57806, 2.23629, 0.0>

  component 1.0, 0.620842, <-1.86498, 2.84388, 0.0>

  component 1.0, 1.21077, <-1.4346, -0.151899, 0.0>

  component 1.0, 1.24168, <-1.33333, -1.26582, 0.0>

  component 1.0, 0.670743, <-2.04219, 0.691983, 0.0>

  component 1.0, 0.674501, <-2.4135, 1.29958, 0.0>

  component 1.0, 0.78531, <1.80591, 1.90717, 0.0>

  component 1.0, 0.555298, <-2.75105, 1.77215, 0.0>

  texture {
    Bloody
  }
  scale 0.6
  rotate <-103.597725, 44.888031, -138.057526>
  translate  <9.535453, 14.108048, -8.639318>
}

#declare Arm_1 = union {
  object { Hand1 }
  sphere { // Sphere60
    <0,0,0>,1
    texture {
      Jade1
    }
    rotate <169.899734, 0.0, 0.0>
    translate  <8.133707, 11.15251, -2.940046>
  }
  sphere { // Sphere61
    <0,0,0>,1
    texture {
      Bloody
    }
    scale <1.0, 1.0, 2.7>
    rotate <26.468693, -9.709358, -3.463074>
    translate  <8.748236, 12.568402, -5.68056>
  }
  sphere { // Sphere62
    <0,0,0>,1
    texture {
      Jade1
    }
    scale <1.0, 1.0, 3.0>
    rotate <37.292847, -4.2823, -12.507914>
    translate  <7.640762, 9.405862, -0.452273>
  }
  rotate <-143.083572, 3.539283, 9.373528>
  translate  <-12.061783, 5.17273, 3.570136>
}
#declare Man = union {
  object { Legs1 }
  object { Head6 }
  object { Arm_2 }
  object { Body2 }
  object { Arm_1 }
  scale 0.15
  rotate <20.794542, 0.0, -106.352013>
  translate  <-31.504434, 36.947254, -0.985853>
}
union { // ManGun
  object { Gun1 }
  object { Man }
  rotate 145.029678*z
  translate  <-5.857538, 56.684146, -0.554586>
}


object { // OilDrums3->OilDrums
  OilDrums
  rotate 162.883957*z
  translate  <-16.395922, -38.400974, 0.0>
}


object { // OilDrums1->OilDrums
  OilDrums
  rotate -162.308853*z
  translate  <7.156891, -26.838343, 0.0>
}


object { OilDrums }


union { // Tool
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blood_Marble1
    }
    scale <0.157491, 0.048136, 1.124416>
    rotate -77.517723*y
    translate  <-16.644898, 0.000295, 1.242255>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1
    texture {
      Blood_Marble1
    }
    scale <0.05, 0.05, 1.067239>
    translate  <-17.680873, 0.0, 0.398817>
  }
  rotate <-16.832314, 0.0, -22.900732>
  translate  <13.729483, -16.091648, -1.245085>
}


box { // Cube004
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Walkway
  }
  scale <1.0, 1.523499, 0.476501>
  translate  <0.0, -6.157892, -5.356114>
}


#declare Sling = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.034451, -0.565496, 1.647825>, <-1.648702, -1.415144, -0.371371>, <1.518305, -1.415144, -0.371371>, <0.002044, -0.567917, 1.647825>,
      <-0.034451, -0.555307, 1.647825>, <-1.565231, -0.401966, -0.441003>, <1.601777, -0.401966, -0.441003>, <0.002044, -0.557532, 1.647825>,
      <-0.034451, -0.545118, 1.647825>, <-1.565231, 0.598034, -0.441003>, <1.601777, 0.598034, -0.441003>, <0.002044, -0.547148, 1.647825>,
      <-0.034451, -0.534929, 1.647825>, <-1.648702, 1.571678, -0.265944>, <1.518305, 1.571678, -0.265944>, <0.002044, -0.536764, 1.647825>
    }
  }
  texture {
    slingtxt
  }
  rotate <-18.438145, 0.0, 0.0>
  translate  <30.049597, -26.363442, 3.949962>
}
#declare tail = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.897001, 1.124017, 0.365737>, <-0.897001, 1.463514, -0.280485>, <0.774541, 1.463514, -0.280485>, <0.774541, 1.124017, 0.365737>,
      <-0.897001, -1.020434, 0.116282>, <-0.897001, -0.910900, -0.680243>, <0.774541, -0.910900, -0.680243>, <0.774541, -1.020434, 0.116282>,
      <0.594816, -3.878148, -0.144532>, <0.594816, -3.937283, -0.835351>, <2.266358, -3.937283, -0.835351>, <2.266358, -3.878148, -0.144532>,
      <-0.876326, -5.521120, -0.146955>, <-0.876326, -5.464215, -0.843540>, <0.795215, -5.464215, -0.843540>, <0.795215, -5.521120, -0.146955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.774541, 1.124017, 0.365737>, <0.774541, 0.784520, 1.011960>, <-0.897001, 0.784520, 1.011960>, <-0.897001, 1.124017, 0.365737>,
      <0.774541, -1.020434, 0.116282>, <0.774541, -1.129967, 0.912808>, <-0.897001, -1.129967, 0.912808>, <-0.897001, -1.020434, 0.116282>,
      <2.266358, -3.878148, -0.144532>, <2.266358, -3.819013, 0.546287>, <0.594816, -3.819013, 0.546287>, <0.594816, -3.878148, -0.144532>,
      <0.795215, -5.521120, -0.146955>, <0.795215, -5.578025, 0.549629>, <-0.876326, -5.578025, 0.549629>, <-0.876326, -5.521120, -0.146955>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.876326, -5.521120, -0.146955>, <-0.876326, -5.464215, -0.843540>, <0.795215, -5.464215, -0.843540>, <0.795215, -5.521120, -0.146955>,
      <-2.347469, -7.164093, -0.149379>, <-2.347469, -6.991147, -0.851729>, <-0.675927, -6.991147, -0.851729>, <-0.675927, -7.164093, -0.149379>,
      <2.994120, -9.615676, -0.434523>, <2.994120, -9.512041, -0.961634>, <5.180791, -9.512041, -0.961634>, <5.180791, -9.615676, -0.434523>,
      <-1.012194, -14.172989, 0.376292>, <-1.012194, -14.172212, 0.367287>, <-0.965511, -14.172212, 0.367287>, <-0.965511, -14.172989, 0.376292>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.795215, -5.521120, -0.146955>, <0.795215, -5.578025, 0.549629>, <-0.876326, -5.578025, 0.549629>, <-0.876326, -5.521120, -0.146955>,
      <-0.675927, -7.164093, -0.149379>, <-0.675927, -7.337038, 0.552971>, <-2.347469, -7.337038, 0.552971>, <-2.347469, -7.164093, -0.149379>,
      <5.180791, -9.615676, -0.434523>, <5.180791, -9.719310, 0.092587>, <2.994120, -9.719310, 0.092587>, <2.994120, -9.615676, -0.434523>,
      <-0.965511, -14.172989, 0.376292>, <-0.965511, -14.173765, 0.385297>, <-1.012194, -14.173765, 0.385297>, <-1.012194, -14.172989, 0.376292>
    }
  }
  texture {
    Monster_Skin3
  }
  scale <0.65, 0.65, 0.7>
  rotate <-8.543337, 0.010305, -179.872406>
  translate  <-0.009084, -0.317664, -3.681616>
}
#declare torso = blob {
  threshold 0.6
  component 1.0, 0.755789, <0.464135, -0.025316, 0.0>

  component 1.0, 0.755789, <-0.464135, -0.025316, 0.0>

  component 1.0, 0.35192, <-0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.392405, 0.0>

  component 1.0, 0.35192, <0.21097, -1.392405, 0.0>

  component 1.0, 0.655497, <0.0, -0.481013, 0.413502>

  component 1.0, 0.227627, <0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <-0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <-0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <0.616034, -0.751055, 0.0>

  component 1.0, 0.227627, <-0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.751055, 0.0>

  component 1.0, 0.640875, <0.0, 0.261603, 0.514768>

  component 1.0, 0.648714, <0.0, -1.07173, 0.481013>

  component 1.0, 0.653567, <0.700422, 0.126582, 0.582278>

  component 1.0, 0.653567, <-0.700422, 0.126582, 0.582278>

  component 1.0, 0.648714, <0.43038, -1.156118, 0.481013>

  component 1.0, 0.648714, <-0.43038, -1.156118, 0.481013>

  component 1.0, 0.655497, <0.548523, -0.565401, 0.413502>

  component 1.0, 0.655497, <-0.548523, -0.565401, 0.413502>

  component 1.0, 0.478267, <0.869198, -0.177215, 0.481013>

  component 1.0, 0.478267, <-0.869198, -0.177215, 0.481013>

  component 1.0, 0.462961, <-0.405063, -1.627004, 0.38481>

  component 1.0, 0.458573, <0.0, -1.437975, 0.357806>

  component 1.0, 0.50635, <0.0, -1.802532, 0.303797>

  component 1.0, 0.462961, <0.405063, -1.627004, 0.38481>

  component 1.0, 0.506656, <-0.031646, -2.162447, 0.28481>

  component 1.0, 0.480656, <0.0, -0.495781, 0.706751>

  component 1.0, 0.444367, <0.0, -0.094937, 0.727848>

  component 1.0, 0.480656, <0.0, -0.896624, 0.706751>

  component 1.0, 0.480656, <0.0, -1.297468, 0.727848>

  component 1.0, 0.480656, <0.0, -1.635021, 0.64346>

  component 1.0, 0.480656, <0.0, -1.93038, 0.453586>

  texture {
    Monster_Skin3
  }
  rotate <71.65741, 0.0, -180.0>
  translate  <31.79239, -21.546235, -0.846961>
}

#declare Blob003 = blob {
  threshold 0.6
  component 1.0, 1.50823, <-0.413502, 0.025316, 0.0>

  component 1.0, 1.59972, <0.43038, -0.008439, 0.0>

  component 1.0, 1.45752, <-0.548523, -1.18987, 0.0>

  component 1.0, 1.4348, <0.700422, -1.20675, 0.0>

  component 1.0, 0.983246, <1.49367, -0.548523, 0.0>

  component 1.0, 0.747382, <1.72996, 0.109705, 0.0>

  component 1.0, 0.683805, <1.79747, 0.683544, 0.0>

  component 1.0, 0.676372, <1.82278, 1.21519, 0.0>

  component 1.0, 0.714533, <0.759494, 0.911392, 0.0>

  component 1.0, 0.676372, <0.742616, 1.50211, 0.0>

  component 1.0, 0.749914, <0.691983, 2.16034, 0.0>

  component 1.0, 0.708316, <0.599156, 2.79325, 0.0>

  component 1.0, 0.718941, <0.43038, 3.50211, 0.0>

  component 1.0, 0.679169, <-0.21097, 1.08861, 0.0>

  component 1.0, 0.714533, <-0.312236, 1.74684, 0.0>

  component 1.0, 0.629936, <-0.464135, 2.42194, 0.0>

  component 1.0, 0.698434, <-0.666667, 3.09705, 0.0>

  component 1.0, 0.715417, <-0.919831, 3.80591, 0.0>

  component 1.0, 0.640875, <-1.0211, 1.0211, 0.0>

  component 1.0, 0.621859, <-1.30802, 1.64557, 0.0>

  component 1.0, 0.670744, <-1.57806, 2.23629, 0.0>

  component 1.0, 0.620842, <-1.86498, 2.84388, 0.0>

  component 1.0, 1.21077, <-1.4346, -0.151899, 0.0>

  component 1.0, 1.24168, <-1.33333, -1.26582, 0.0>

  component 1.0, 0.670743, <-2.04219, 0.691983, 0.0>

  component 1.0, 0.674501, <-2.4135, 1.29958, 0.0>

  component 1.0, 0.78531, <1.80591, 1.90717, 0.0>

  component 1.0, 0.555298, <-2.75105, 1.77215, 0.0>

  texture {
    Monster_Skin3
  }
  scale 0.110643
  rotate <-97.754265, -47.977207, -31.497839>
  translate  <-1.049588, -0.332317, -3.220098>
}

#declare arm1 = union {
  sphere { // Sphere18
    <0,0,0>,1
    texture {
      Monster_Skin3
    }
    scale <0.3, 0.35, 1.0>
    rotate <0.0, 41.913845, 0.0>
    translate  <-1.211815, 0.109641, -1.285505>
  }
  sphere { // Sphere19
    <0,0,0>,1
    texture {
      Monster_Skin3
    }
    scale <0.2, 0.2, 0.8>
    rotate <-14.043919, -24.918688, -0.320958>
    translate  <-1.423485, -0.076043, -2.573267>
  }
  sphere { // Sphere20
    <0,0,0>,1
    texture {
      Monster_Skin3
    }
    scale 0.2
    rotate <0.0, 0.0, 0.0>
    translate  <-1.701202, 0.130571, -1.940499>
  }
  object { Blob003 }
  rotate <33.478722, 0.383057, 0.370881>
  translate  <-0.410267, -0.417936, -0.157686>
}
#declare CSG001 = merge {
  sphere { // Sphere22
    <0,0,0>,1
    texture {
      Copper_Metal2
    }
    scale <1.0, 3.0, 1.0>
  }
  sphere { // Sphere23
    <0,0,0>,1
    texture {
      Barrels1
    }
    scale <0.5, 3.0, 0.5>
    translate  -0.976934*x
  }
  sphere { // Sphere24
    <0,0,0>,1
    texture {
      Barrels1
    }
    scale <0.5, 3.0, 0.5>
    rotate -90.0*y
    translate  <0.0, 0.0, -0.976934>
  }
  sphere { // Sphere25
    <0,0,0>,1
    texture {
      Barrels1
    }
    scale <0.5, 3.0, 0.5>
    rotate <180.0, 0.0, 180.0>
    translate  <0.976934, 0.0, 0.0>
  }
  sphere { // Sphere26
    <0,0,0>,1
    texture {
      Barrels1
    }
    scale <0.5, 3.0, 0.5>
    rotate 90.0*y
    translate  <0.0, 0.0, 0.976934>
  }
}
#declare Barrel = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*x
    translate  <0.0, 1.086938, 2.875126>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <0.7, 0.7, 1.1>
    rotate 90.0*x
    translate  <0.0, 1.180892, 2.865055>
  }
  texture {
    Copper_Metal2
  }
  scale <0.5, 3.0, 0.5>
  translate  <0.0, -5.414695, -1.496166>
}
#declare Gun = union {
  sphere { // Sphere21
    <0,0,0>,1
    texture {
      Rusty_Iron2
    }
    translate  2.7*y
  }
  object { CSG001 }
  object { // Barrel12->Barrel1
    Barrel1
    rotate 30.0*y
    translate  0.0*x
  }
  object { // Barrel11->Barrel1
    Barrel1
    rotate 60.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel10->Barrel1
    Barrel1
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel9->Barrel1
    Barrel1
    rotate <-180.0, 60.0, -180.0>
    translate  0.0*x
  }
  object { // Barrel8->Barrel1
    Barrel1
    rotate <-180.0, 30.0, -180.0>
    translate  0.0*x
  }
  object { // Barrel7->Barrel1
    Barrel1
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel6->Barrel1
    Barrel1
    rotate <180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel5->Barrel1
    Barrel1
    rotate <180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel4->Barrel1
    Barrel1
    rotate -90.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel3->Barrel1
    Barrel1
    rotate -60.0*y
    translate  0.0*z
  }
  object { // Barrel2->Barrel1
    Barrel1
    rotate <0.0, -30.0, 0.0>
  }
  object { Barrel1 }
  object { Barrel }
  scale 0.3
  rotate -45.0*y
  translate  <1.724625, -2.679524, -1.026646>
}
#declare arm2 = union {
  object { Gun }
  sphere { // Sphere27
    <0,0,0>,1
    texture {
      Monster_Skin3
    }
    scale <0.3, 0.35, 1.0>
    rotate <-75.075417, -35.701168, 19.575592>
    translate  <1.211815, -0.655484, -0.80813>
  }
  sphere { // Sphere28
    <0,0,0>,1
    texture {
      Monster_Skin3
    }
    scale 0.2
    rotate <0.0, 0.0, 0.0>
    translate  <1.754594, -1.598363, -1.048292>
  }
  rotate <-44.905434, -0.704478, -0.060181>
  translate  <0.154175, 0.61302, -0.247563>
}
#declare Arms1 = union {
  object { arm1 }
  object { arm2 }
  translate  <31.79239, -21.203975, -0.040716>
}
#declare Blob001 = blob {
  threshold 0.6
  component 1.0, 0.335372, <0.0, -0.075949, -0.548523>

  component 1.0, 0.452469, <0.0, -0.025316, -0.227848>

  component 1.0, 0.842752, <0.0, 0.109705, 0.244726>

  component 1.0, 0.177747, <0.0, -0.464135, -0.43038>

  component 1.0, 0.207286, <0.0, -0.481013, -0.278481>

  component 1.0, 0.251372, <0.0, -0.447257, -0.109705>

  component 1.0, 0.301646, <0.0, -0.379747, 0.109705>

  component 1.0, 0.355493, <0.0, -0.312236, 0.312236>

  component 1.0, 0.207286, <0.109705, -0.531646, -0.329114>

  component 1.0, 0.207286, <-0.109705, -0.531646, -0.329114>

  component 1.0, 0.150823, <0.194093, -0.396624, -0.49789>

  component 1.0, 0.150823, <-0.194093, -0.396624, -0.49789>

  component 1.0, 0.158981, <0.345992, 0.278481, 0.278481>

  component 1.0, 0.158981, <0.413502, 0.396624, 0.312236>

  component 1.0, 0.158981, <0.481013, 0.531646, 0.379747>

  component 1.0, 0.158981, <-0.481013, 0.531646, 0.379747>

  component 1.0, 0.158981, <-0.413502, 0.396624, 0.312236>

  component 1.0, 0.158981, <-0.345992, 0.278481, 0.278481>

  component 1.0, 0.591659, <0.0, -0.261603, 0.582278>

  component -3.279262, 0.190625, <0.177215, 0.227848, -0.075949>

  component -3.279262, 0.190625, <-0.177215, 0.227848, -0.075949>

  texture {
    Monster_Skin3
  }
  rotate <90.0, 0.0, 180.0>
  translate  <0.0, -0.625815, -0.135311>
}

#declare Head3 = union {
  sphere { // EyeBall
    <0,0,0>,1
    texture {
      EyeQ2
    }
    scale 0.1
    translate  <0.173513, -0.696754, 0.095961>
  }
  object { Blob001 }
  sphere { // EyeBall1
    <0,0,0>,1
    texture {
      EyeQ2
    }
    scale 0.1
    translate  <-0.173513, -0.696754, 0.095961>
  }
  rotate <-38.073704, -0.597526, -0.087155>
  translate  <31.79239, -21.353499, -0.08395>
}
#declare RestofBod = union {
  object { torso }
  object { Arms1 }
  object { Head3 }
  rotate 62.664604*x
  translate  <-31.79239, 6.522252, 15.857709>
}
#declare MOnster3 = union {
  object { tail }
  object { RestofBod }
  rotate <180.0, -0.925565, 180.0>
  translate  <31.79239, -21.194927, 0.0>
}
union { // BednMon3
  cone { // Cone003
    <0,0,0>, 0.7, <0,0,1>, 1.0
    texture {
      Walkway
    }
    scale <1.69395, 3.857457, 3.0>
    rotate -180.0*x
    translate  <32.303954, -21.820514, 2.249128>
  }
  sphere { // Sphere011
    <0,0,0>,1
    texture {
      Copper_Metal2
    }
    scale 0.07
    translate  <32.930936, -26.364893, 5.716579>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Textur2
    }
    scale <0.02, 0.02, 2.0>
    rotate 52.050243*y
    translate  <32.9, -26.362183, 5.693877>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Copper_Metal3
    }
    scale <2.6, 5.0, 0.3>
    translate  <32.158501, -22.209013, 2.49588>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Textur3
    }
    scale <0.1, 0.1, 5.0>
    translate  <34.579729, -26.367335, 2.330124>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Textur2
    }
    scale <0.03, 0.03, 4.590671>
    rotate <0.0, 90.0, 0.0>
    translate  <29.995368, -26.36545, 5.721029>
  }
  sphere { // Sphere010
    <0,0,0>,1
    texture {
      Chrome_Textur2
    }
    scale 0.087877
    translate  <30.015245, -26.368018, 5.722861>
  }
  object { Sling }
  object { MOnster3 }
  rotate -90.0*z
  translate  <21.536101, 21.980765, -5.113106>
}


#declare Feet1 = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.375899, 0.289485>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  rotate -54.167839*x
  translate  <-0.928728, -0.171726, -5.657114>
}

#declare Leg1 = union {
  object { Feet1 }
  sphere { // Leg
    <0,0,0>,1
    scale <0.3, 1.5, 0.6>
    rotate 47.286095*x
    translate  <-0.92146, 0.608708, -3.979479>
  }
  texture {
    MSkin1
  }
  rotate 30.878572*x
  translate  <0.0, -0.883301, -1.230312>
}
#declare Feet4 = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.375899, 0.289485>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  rotate -54.167839*x
  translate  <0.928728, -0.171726, -5.657114>
}

#declare Leg2 = union {
  object { Feet4 }
  sphere { // LegM2
    <0,0,0>,1
    scale <0.3, 1.5, 0.6>
    rotate 47.286095*x
    translate  <0.92146, 0.608708, -3.979479>
  }
  texture {
    MSkin1
  }
  rotate 53.495422*x
  translate  <0.0, -1.419591, -2.239798>
}
#declare Mhead = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.011470, -1.992924, -0.001520>, <-0.178451, -1.992924, 0.004200>, <-0.089226, -1.992924, 0.004200>, <-0.082352, -1.992924, 0.002294>,
      <0.005771, -1.819005, -0.733862>, <-1.962963, -1.819005, 0.000000>, <-0.981481, -1.606346, 0.582262>, <0.000000, -1.606346, 0.582262>,
      <0.005771, -0.909502, -0.733862>, <-1.962963, -0.909502, 0.000000>, <-0.981481, -0.852793, 0.568084>, <0.000000, -0.852793, 0.568084>,
      <0.026780, -0.144925, -0.733862>, <-2.867371, -0.144925, 0.000000>, <-1.424537, -0.107430, 0.976426>, <0.018296, -0.107430, 0.976426>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.026780, -0.144925, -0.733862>, <-2.867371, -0.144925, 0.000000>, <-1.424537, -0.107430, 0.976426>, <0.018296, -0.107430, 0.976426>,
      <0.047789, 0.619652, -0.733862>, <-3.771778, 0.619652, 0.000000>, <-1.867593, 0.637933, 1.384768>, <0.036592, 0.637933, 1.384768>,
      <0.047789, 1.564553, -0.733862>, <-3.771778, 1.564553, 0.000000>, <-1.867593, 1.582834, 1.384768>, <0.036592, 1.582834, 1.384768>,
      <-0.015669, 1.763764, 0.000000>, <-0.012664, 1.763764, 0.000000>, <-0.009658, 1.763764, 0.000000>, <-0.006652, 1.763764, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.082352, -1.992924, 0.002294>, <-0.075479, -1.992924, 0.000387>, <0.013747, -1.992924, 0.000387>, <0.102973, -1.992924, 0.000387>,
      <0.000000, -1.606346, 0.582262>, <0.981481, -1.606346, 0.582262>, <1.962963, -1.819005, 0.000000>, <-0.030496, -1.797164, -0.721591>,
      <0.000000, -0.852793, 0.568084>, <0.981481, -0.852793, 0.568084>, <1.962963, -0.909502, 0.000000>, <-0.030496, -0.921649, -0.721591>,
      <0.018296, -0.107430, 0.976426>, <1.461129, -0.107430, 0.976426>, <2.903962, -0.144925, 0.000000>, <-0.026534, -0.157308, -0.721591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.018296, -0.107430, 0.976426>, <1.461129, -0.107430, 0.976426>, <2.903962, -0.144925, 0.000000>, <-0.026534, -0.157308, -0.721591>,
      <0.036592, 0.637933, 1.384768>, <1.940777, 0.637933, 1.384768>, <3.844962, 0.619652, 0.000000>, <-0.022573, 0.607033, -0.721591>,
      <0.036592, 1.582834, 1.384768>, <1.940777, 1.582834, 1.384768>, <3.844962, 1.564553, 0.000000>, <-0.022573, 1.587243, -0.721591>,
      <-0.006652, 1.763764, 0.000000>, <-0.003647, 1.763764, 0.000000>, <-0.008627, 1.763764, -0.037292>, <-0.005622, 1.763764, -0.037292>
    }
  }
  scale <0.572929, 1.050353, 1.03445>
  rotate 55.621639*x
}
#declare Horn3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.804274, 0.000000, -0.762032>, <3.804274, -1.000000, -0.762032>, <3.810547, -1.000000, 1.237958>, <3.810547, 0.000000, 1.237958>,
      <1.804284, 0.000000, -0.755759>, <1.804284, -1.000000, -0.755759>, <1.810556, -1.000000, 1.244231>, <1.810556, 0.000000, 1.244231>,
      <-3.800457, 0.000000, 1.598913>, <-3.800457, -1.000000, 1.598913>, <-2.600915, -1.000000, 3.199256>, <-2.600915, 0.000000, 3.199256>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.810547, 0.000000, 1.237958>, <3.810547, 1.000000, 1.237958>, <3.804274, 1.000000, -0.762032>, <3.804274, 0.000000, -0.762032>,
      <1.810556, 0.000000, 1.244231>, <1.810556, 1.000000, 1.244231>, <1.804284, 1.000000, -0.755759>, <1.804284, 0.000000, -0.755759>,
      <-2.600915, 0.000000, 3.199256>, <-2.600915, 1.000000, 3.199256>, <-3.800457, 1.000000, 1.598913>, <-3.800457, 0.000000, 1.598913>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  texture {
    Mskin3
  }
  scale 0.2
  rotate <174.643326, 85.196686, 84.996429>
  translate  <0.04311, -0.577944, 0.462122>
}
#declare Head = union {
  object { Mhead }
  sphere { // Eye1
    <0,0,0>,1
    texture {
      Eye_Balls1
    }
    scale <0.3, 0.25, 0.4>
    rotate <-9.469096, 1.449308, -15.625997>
    translate  <-0.584356, -0.806818, -0.139947>
  }
  sphere { // Eye2
    <0,0,0>,1
    texture {
      Eye_Balls1
    }
    scale <0.3, 0.25, 0.4>
    rotate <-6.824969, -2.491854, 15.744681>
    translate  <0.584356, -0.806818, -0.139947>
  }
  object { Mouth }
  object { // Mouth2->Mouth
    Mouth
    texture {
      Texture3
    }
    rotate <173.604279, 0.0, 180.0>
    translate  <0.0, 0.108115, -2.038958>
  }
  object { Horn }
  object { // Horn2->Horn
    Horn
    rotate <-119.979485, 0.0, -180.0>
    translate  <0.178181, 1.22817, 2.085966>
  }
  object { Horn3 }
  object { Horn4 }
  object { // Horn5->Horn4
    Horn4
    rotate <147.252396, 3.52487, 177.735565>
    translate  <0.050937, 0.514308, -1.82984>
  }
  object { ConeHorn6 }
  object { // ConeHorn7->ConeHorn6
    ConeHorn6
    texture {
      Mskin3
    }
    rotate -26.242691*x
    translate  <0.0, 0.431085, 0.57478>
  }
  object { // ConeHorn8->ConeHorn6
    ConeHorn6
    texture {
      Mskin3
    }
    rotate -25.438396*x
    translate  <0.0, -0.107771, 0.359237>
  }
  texture {
    MSkin1
  }
}
#declare Tentacles = union {
  object { tent1 }
  object { // tent2->tent1
    tent1
    rotate <0.0, 0.0, -10.0>
    translate  0.0*x
  }
  object { // tent3->tent1
    tent1
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tent4->tent1
    tent1
    rotate <0.0, 0.0, -30.0>
    translate  0.0*x
  }
  object { // tent5->tent1
    tent1
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tent6->tent1
    tent1
    rotate <0.0, 0.0, -50.0>
    translate  0.0*y
  }
  object { // tent7->tent1
    tent1
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tent8->tent1
    tent1
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    Cape1
  }
}
#declare Arm1 = union {
  object { Fingers2 }
  object { // Arm->Arms
    Arms
    texture {
      MSkin1
    }
    scale <0.7, 0.8, 0.8>
    rotate <101.921432, -11.193434, -168.122757>
    translate  <-0.49246, 1.945845, -2.116412>
  }
}
#declare Arm2 = union {
  object { // Fingers->Fingers2
    Fingers2
    texture {
      Mskin3
    }
    rotate <-70.707932, -23.631657, 172.01268>
    translate  <1.013114, -1.967217, -4.099781>
  }
  object { Arms }
  rotate <-46.882172, 3.929057, -29.83844>
  translate  <-0.069631, 1.626458, 0.872499>
}
#declare Torso = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.123126, -2.294035, -0.542257>, <-0.090876, -2.315323, -0.531075>, <-0.109960, -2.294035, -0.348373>, <-0.125344, -2.294035, -0.348373>,
      <-0.144153, -2.000000, -1.375656>, <-2.122797, -2.076845, -1.296317>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>,
      <-0.144153, -1.000000, -1.375656>, <-2.240416, -1.021288, -1.296317>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>,
      <-0.185928, -0.113692, -1.375656>, <-2.889680, -0.159356, -0.956799>, <-1.785742, 0.088764, 0.406552>, <0.000000, 0.088764, 0.406552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.185928, -0.113692, -1.375656>, <-2.889680, -0.159356, -0.956799>, <-1.785742, 0.088764, 0.406552>, <0.000000, 0.088764, 0.406552>,
      <-0.227703, 0.772616, -1.375656>, <-3.538944, 0.702576, -0.617281>, <-2.571484, 1.177527, 0.813104>, <0.000000, 1.177527, 0.813104>,
      <-0.144153, 2.000000, -1.375656>, <-2.240416, 1.909347, -0.617281>, <-1.000000, 2.000000, 1.526023>, <0.000000, 2.000000, 1.526023>,
      <-0.047799, 2.401352, -0.196545>, <-0.046295, 2.382211, -0.128533>, <-0.047185, 2.420973, -0.131028>, <-0.047902, 2.420973, -0.131028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.125344, -2.294035, -0.348373>, <-0.140729, -2.294035, -0.348373>, <-0.160905, -2.315323, -0.531075>, <-0.124976, -2.294035, -0.542257>,
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <1.019426, -2.055728, -1.296317>, <-0.023931, -2.000000, -1.375656>,
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.311437, -1.021288, -1.296317>, <-0.023931, -1.000000, -1.375656>,
      <0.000000, 0.088764, 0.406552>, <1.785742, 0.088764, 0.406552>, <2.981283, -0.159356, -0.956799>, <-0.030867, -0.113692, -1.375656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.088764, 0.406552>, <1.785742, 0.088764, 0.406552>, <2.981283, -0.159356, -0.956799>, <-0.030867, -0.113692, -1.375656>,
      <0.000000, 1.177527, 0.813104>, <2.571484, 1.177527, 0.813104>, <3.651130, 0.702576, -0.617281>, <-0.037802, 0.772616, -1.375656>,
      <0.000000, 2.000000, 1.526023>, <1.000000, 2.000000, 1.526023>, <2.311437, 1.909347, -0.617281>, <-0.023931, 2.000000, -1.375656>,
      <-0.047902, 2.420973, -0.131028>, <-0.048620, 2.420973, -0.131028>, <-0.049560, 2.382211, -0.128533>, <-0.047885, 2.401352, -0.196545>
    }
  }
  texture {
    MSkin1
  }
  rotate 100.093857*x
  translate  <0.0, 1.113817, -2.053548>
}
union { // Alien
  object { Leg1 }
  object { Leg2 }
  object { Head }
  object { Tentacles }
  object { Arm1 }
  object { Arm2 }
  object { Torso }
  scale 0.9
  translate  <-0.292494, -7.627389, 1.046999>
}


#declare Lleg1 = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.227848, 0.126582>

  component 1.0, 0.588446, <0.0, 0.244726, 0.109705>

  component 1.0, 0.779658, <0.0, 0.78481, 0.092827>

  component 1.0, 0.25635, <0.0, 0.835443, -0.379747>

  component 1.0, 0.25635, <0.0, 0.987342, -0.514768>

  component 1.0, 0.142197, <0.0, 1.105485, -0.632911>

  component 1.0, 0.317963, <0.0, 0.700422, -0.244726>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  texture {
    Feet3
  }
  scale 0.9
  rotate <18.019438, -4.629893, 8.740527>
  translate  <-0.470992, -3.00884, -4.655362>
}

#declare Leg3 = union {
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale <0.3, 0.4, 1.3>
    rotate <-41.371567, 0.0, 0.0>
    translate  <-0.56477, -1.546932, -3.371936>
  }
  object { Lleg1 }
  rotate <69.887695, 1.186459, -7.071713>
  translate  <-0.177312, -3.000877, -0.668826>
}
#declare Lleg2 = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.227848, 0.126582>

  component 1.0, 0.588446, <0.0, 0.244726, 0.109705>

  component 1.0, 0.779658, <0.0, 0.78481, 0.092827>

  component 1.0, 0.25635, <0.0, 0.835443, -0.379747>

  component 1.0, 0.25635, <0.0, 0.987342, -0.514768>

  component 1.0, 0.142197, <0.0, 1.105485, -0.632911>

  component 1.0, 0.317963, <0.0, 0.700422, -0.244726>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  texture {
    Feet3
  }
  scale 0.9
  rotate <89.636795, -15.300739, -3.460338>
  translate  <0.857891, 0.399043, -5.100762>
}

#declare Leg4 = union {
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale <0.3, 0.4, 1.3>
    rotate <37.176491, 0.0, 0.0>
    translate  <0.458247, -0.367473, -3.478753>
  }
  object { Lleg2 }
}
#declare Legs = union {
  object { Leg3 }
  object { Leg4 }
}
#declare Claw1 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw3
  }
  rotate <147.495895, -11.676928, 5.476303>
  translate  <1.348874, -0.086434, 1.638768>
}

#declare Arm3 = union {
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale <0.4, 0.3, 1.0>
    rotate <-157.712463, -68.060593, -144.551132>
    translate  <1.379682, -0.006541, -0.673681>
  }
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale 0.3
    translate  <1.800889, 0.74811, -0.335632>
  }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale <0.2, 0.3, 1.0>
    rotate <26.928513, -8.422236, -13.494572>
    translate  <1.60793, 0.445475, 0.486222>
  }
  object { Claw1 }
  cone { // Cone2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blood_Marble1
    }
    scale <0.1, 0.2, 1.0>
    rotate <29.837257, 1.803776, -14.636334>
    translate  <1.920992, 1.323746, -1.264083>
  }
  rotate <172.44075, -4.805476, -29.096601>
  translate  <-0.372697, -1.097189, -1.755747>
}
#declare Claw2 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw3
  }
  rotate <12.259566, 33.262436, -70.475708>
  translate  <-0.673389, 1.364901, -3.308768>
}

#declare Arm4 = union {
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale <0.3, 0.4, 1.0>
    rotate <23.37171, 37.140678, 3.985606>
    translate  <-1.423841, -0.329328, -1.576253>
  }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale 0.3
    translate  <-1.851007, 0.021841, -2.262451>
  }
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      Monster_Skin1
    }
    scale <0.3, 0.2, 1.0>
    rotate <45.279999, -42.07, 0.0>
    translate  <-1.421265, 0.630899, -2.771894>
  }
  object { Claw2 }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blood_Marble1
    }
    scale <0.2, 0.1, 1.0>
    rotate <-133.130981, 22.468321, -105.933968>
    translate  <-2.744805, 0.005517, -1.615199>
  }
}
#declare Ams = union {
  object { Arm3 }
  object { Arm4 }
}
#declare Body1 = blob {
  threshold 0.6
  component 1.0, 0.755789, <0.464135, -0.025316, 0.0>

  component 1.0, 0.755789, <-0.464135, -0.025316, 0.0>

  component 1.0, 0.35192, <-0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.392405, 0.0>

  component 1.0, 0.35192, <0.21097, -1.392405, 0.0>

  component 1.0, 0.655497, <0.0, -0.481013, 0.413502>

  component 1.0, 0.227627, <0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <-0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <-0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <0.616034, -0.751055, 0.0>

  component 1.0, 0.227627, <-0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.751055, 0.0>

  component 1.0, 0.640875, <0.0, 0.261603, 0.514768>

  component 1.0, 0.562084, <0.0, -0.329114, 0.835443>

  component 1.0, 0.648714, <0.0, -1.07173, 0.481013>

  component 1.0, 0.653567, <0.700422, 0.126582, 0.582278>

  component 1.0, 0.653567, <-0.700422, 0.126582, 0.582278>

  component 1.0, 0.648714, <0.43038, -1.156118, 0.481013>

  component 1.0, 0.648714, <-0.43038, -1.156118, 0.481013>

  component 1.0, 0.655497, <0.548523, -0.565401, 0.413502>

  component 1.0, 0.655497, <-0.548523, -0.565401, 0.413502>

  component 1.0, 0.478267, <0.869198, -0.177215, 0.481013>

  component 1.0, 0.478267, <-0.869198, -0.177215, 0.481013>

  component 1.0, 0.439128, <0.0, -1.071334, 0.840585>

  component 1.0, 0.555458, <0.0, 0.543908, 0.939478>

  component 1.0, 0.462961, <-0.405063, -1.627004, 0.38481>

  component 1.0, 0.458573, <0.0, -1.437975, 0.357806>

  component 1.0, 0.50635, <0.0, -1.802532, 0.303797>

  component 1.0, 0.462961, <0.405063, -1.627004, 0.38481>

  component 1.0, 0.506656, <-0.031646, -2.162447, 0.28481>

  texture {
    Monster_Skin1
  }
  rotate 82.995842*x
  translate  <0.0, -0.301584, -1.003153>
}

#declare Head1 = blob {
  threshold 0.6
  component 1.0, 0.856141, <0.0, 0.042194, -0.042194>

  component 1.0, 0.317963, <0.0, 0.227848, -0.531646>

  component 1.0, 0.277649, <0.0, 0.261603, -0.767932>

  component 1.0, 0.227627, <0.0, 0.278481, -1.004219>

  component 1.0, 0.181267, <0.0, 0.295359, -1.189873>

  component 1.0, 0.177747, <0.0, 0.312236, -1.35865>

  component 1.0, 0.112417, <0.0, 0.345992, -1.544304>

  component 1.0, 0.100549, <0.0, 0.362869, -1.493671>

  component 1.0, 0.528479, <0.0, -0.43038, -0.059072>

  component 1.0, 0.445432, <0.0, -0.14346, 0.362869>

  component 1.0, 0.207286, <0.194093, -0.278481, -0.396624>

  component 1.0, 0.207286, <-0.194093, -0.278481, -0.396624>

  component 1.0, 0.238472, <0.312236, -0.362869, -0.531646>

  component 1.0, 0.238472, <-0.312236, -0.362869, -0.531646>

  component 1.0, 0.251372, <0.379747, -0.464135, -0.683544>

  component 1.0, 0.251372, <-0.379747, -0.464135, -0.683544>

  component 1.0, 0.201097, <0.379747, -0.599156, -0.852321>

  component 1.0, 0.201097, <-0.379747, -0.599156, -0.852321>

  component 1.0, 0.812207, <0.0, -0.616034, 0.565401>

  texture {
    Monster_Skin1
  }
  scale <1.0, 0.8, 0.8>
  rotate <80.658699, 0.0, 122.58078>
  translate  <11.148101, 0.721194, -0.125754>
}

#declare mon1head = union {
  disc { // Pupil2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Black
    }
    scale 0.07
    rotate <-122.58078, -90.0, 0.0>
    translate  <10.934466, 0.962081, -0.167683>
  }
  disc { // Pupil1
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Black
    }
    scale 0.07
    rotate <-122.58078, -90.0, 0.0>
    translate  <11.276965, 0.426134, -0.167683>
  }
  sphere { // Eye4
    <0,0,0>,1
    texture {
      Red_Eye
    }
    scale <0.1, 0.2, 0.1>
    rotate 122.58078*z
    translate  <11.243681, 0.394472, -0.170448>
  }
  sphere { // Eye3
    <0,0,0>,1
    texture {
      Red_Eye
    }
    scale <0.1, 0.2, 0.1>
    rotate 122.58078*z
    translate  <10.891752, 0.945175, -0.170448>
  }
  object { Head1 }
  rotate -150.100128*z
  translate  <9.918272, 6.51611, -0.091754>
}
union { // Mon1
  object { Legs }
  object { Ams }
  cone { // Cone4
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blood_Marble1
    }
    scale <0.2, 0.2, 1.0>
    rotate -85.987572*x
    translate  <0.0, -1.930412, -2.010708>
  }
  cone { // Cone3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blood_Marble1
    }
    scale <0.2, 0.2, 1.0>
    rotate -95.757286*x
    translate  <0.0, -2.006811, -1.087286>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blood_Marble1
    }
    scale <0.2, 0.2, 1.0>
    rotate -117.700691*x
    translate  <0.0, -1.98184, 0.06138>
  }
  object { Body1 }
  object { mon1head }
  rotate 122.58078*z
  translate  <9.95057, 0.694107, 0.385048>
}


#declare Head2 = blob {
  threshold 0.6
  component 1.0, 0.780468, <0.0, 0.261603, -0.059072>

  component 1.0, 0.701142, <0.0, 0.126582, 0.464135>

  component 1.0, 0.286608, <0.362869, 0.548523, -0.160338>

  component 1.0, 0.286608, <-0.362869, 0.548523, -0.160338>

  component 1.0, 0.238472, <0.481013, 0.734177, -0.261603>

  component 1.0, 0.238472, <-0.481013, 0.734177, -0.261603>

  component 1.0, 0.207286, <-0.531646, 0.902954, -0.379747>

  component 1.0, 0.207286, <0.531646, 0.902954, -0.379747>

  component 1.0, 0.191439, <-0.43038, 1.037975, -0.481013>

  component 1.0, 0.191439, <0.43038, 1.037975, -0.481013>

  component 1.0, 0.286608, <0.0, -0.278481, 0.244726>

  component 1.0, 0.258803, <0.0, -0.548523, 0.227848>

  component 1.0, 0.251372, <0.0, -0.751055, 0.059072>

  component 1.0, 0.201097, <0.177215, -0.227848, 0.177215>

  component 1.0, 0.201097, <0.14346, -0.43038, 0.109705>

  component 1.0, 0.201097, <-0.177215, -0.227848, 0.177215>

  component 1.0, 0.201097, <-0.14346, -0.43038, 0.109705>

  component 1.0, 0.201097, <0.109705, -0.649789, 0.042194>

  component 1.0, 0.201097, <-0.109705, -0.649789, 0.042194>

  component 1.0, 0.224834, <0.0, -0.919831, -0.278481>

  component 1.0, 0.207286, <0.14346, -0.869198, -0.447257>

  component 1.0, 0.224834, <0.0, -0.886076, -0.075949>

  component 1.0, 0.177747, <0.0, -0.869198, -0.362869>

  component 1.0, 0.207286, <-0.14346, -0.869198, -0.447257>

  component 1.0, 0.177747, <0.160338, -0.7173, -0.464135>

  component 1.0, 0.177747, <-0.160338, -0.7173, -0.464135>

  component 1.0, 0.177747, <0.194093, -0.582278, -0.514768>

  component 1.0, 0.177747, <-0.194093, -0.582278, -0.514768>

  component 1.0, 0.128175, <0.21097, -0.447257, -0.565401>

  component 1.0, 0.128175, <-0.21097, -0.447257, -0.565401>

  component 1.0, 0.277649, <0.160338, 0.025316, -0.481013>

  component 1.0, 0.277649, <-0.160338, 0.025316, -0.481013>

  component 1.0, 0.270736, <0.0, 0.025316, -0.514768>

  component 1.0, 0.224834, <0.0, -0.042194, -0.751055>

  component 1.0, 0.132663, <-0.340253, 1.117975, -0.567089>

  component 1.0, 0.132663, <0.340253, 1.117975, -0.567089>

  component 1.0, 0.096527, <0.286245, 1.182785, -0.621097>

  component 1.0, 0.096527, <-0.286245, 1.182785, -0.621097>

  component 1.0, 0.050874, <-0.25384, 1.225992, -0.664304>

  component 1.0, 0.050874, <0.25384, 1.225992, -0.664304>

  component 1.0, 0.145681, <0.372658, 0.135021, 0.0>

  component 1.0, 0.093807, <0.459072, 0.199831, 0.070211>

  component 1.0, 0.050874, <0.523882, 0.25384, 0.113418>

  component 1.0, 0.145681, <-0.372658, 0.135021, 0.0>

  component 1.0, 0.093807, <-0.459072, 0.199831, 0.070211>

  component 1.0, 0.050874, <-0.523882, 0.25384, 0.113418>

  component 1.0, 0.132507, <0.0, 0.462312, -0.393182>

  component 1.0, 0.110714, <0.0, 0.505519, -0.44503>

  component 1.0, 0.091006, <0.0, 0.540085, -0.479595>

  component 1.0, 0.077222, <0.0, 0.57465, -0.522802>

  component 1.0, 0.051481, <0.0, 0.600574, -0.566009>

  component 1.0, 0.040699, <0.0, 0.635139, -0.591933>

  texture {
    MonSkin2
  }
  rotate <90.0, 0.0, 180.0>
  translate  <0.0, 0.859363, -0.441958>
}

#declare HeadGrp = union {
  object { Head2 }
  sphere { // Sphere10
    <0,0,0>,1
    texture {
      EyeQ1
    }
    scale 0.1
    translate  <0.240136, 0.432702, -0.127229>
  }
  sphere { // Sphere009
    <0,0,0>,1
    texture {
      EyeQ1
    }
    scale 0.1
    translate  <-0.240136, 0.432702, -0.127229>
  }
  cone { // Cone5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Claw
    }
    scale <0.07, 0.07, 0.456893>
    translate  <0.114719, 0.315445, -0.946831>
  }
  cone { // Cone6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Claw
    }
    scale <0.07, 0.07, 0.456893>
    translate  <-0.114719, 0.315445, -0.946831>
  }
  rotate 58.967979*z
  translate  <1.235216, 0.589026, 0.0>
}
#declare Foot = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.375899, 0.289485>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  texture {
    Feet2
  }
  scale 0.673072
  rotate 180.0*z
  translate  <1.447854, 6.13586, -2.358038>
}

#declare Leg5 = union {
  object { Foot }
  sphere { // Sphere9
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.2, 0.161418, 0.290025>
    rotate <90.813103, 0.087352, -13.837151>
    translate  <1.112276, 4.799455, -2.940703>
  }
  sphere { // Sphere007
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.35, 0.9>
    rotate <112.907227, 2.294805, -9.475863>
    translate  <1.27085, 5.54144, -2.511343>
  }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.4, 1.0>
    rotate <118.855469, -23.17149, 132.973923>
    translate  <0.644622, 4.112639, -2.406815>
  }
  rotate -97.743683*x
  translate  <0.082506, 5.971992, 1.241372>
}
#declare Foot1 = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.375899, 0.289485>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  texture {
    Feet2
  }
  scale 0.673072
  rotate <69.88073, -29.307919, 171.268967>
  translate  <-1.800766, 1.85624, -4.324368>
}

#declare Leg6 = union {
  sphere { // Sphere006
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.4, 1.0>
    rotate <-59.39547, 27.595198, -35.003075>
    translate  <-0.719355, 3.005155, -2.439251>
  }
  sphere { // Sphere8
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.35, 0.9>
    rotate <-14.387856, 20.876011, -3.205825>
    translate  <-1.506831, 2.290956, -3.674119>
  }
  object { Foot1 }
  sphere { // Sphere008
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.2, 0.161418, 0.290025>
    rotate <-12.277086, 20.312622, -1.93916>
    translate  <-1.287504, 2.314221, -2.890339>
  }
}
#declare Finger7 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate 180.0*z
  translate  <2.164012, -0.156422, -2.62601>
}

#declare Finger6 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate <-94.664795, 0.0, 30.345383>
  translate  <2.018149, 0.273051, -2.748814>
}

#declare Finger5 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate <-38.875149, -19.891369, 157.1185>
  translate  <1.880423, -0.042541, -2.69599>
}

#declare Finger4 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate <-61.320484, 22.243258, 168.301208>
  translate  <2.401142, -0.058779, -2.676714>
}

#declare Arm5 = union {
  object { Finger7 }
  object { Finger6 }
  object { Finger5 }
  object { Finger4 }
  sphere { // Sphere11
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.416793, 0.2>
    translate  <2.148042, 0.272516, -2.529674>
  }
  sphere { // Sphere12
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.2, 0.2, 1.0>
    rotate -44.0*y
    translate  <1.603305, 1.820323, -1.087326>
  }
  sphere { // Sphere13
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.4, 1.0>
    rotate <0.0, -43.895737, 0.0>
    translate  <1.425605, 1.900312, -1.025246>
  }
  sphere { // Sphere14
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.2, 0.3, 0.9>
    rotate <-58.829998, 0.0, 0.0>
    translate  <2.129303, 1.218839, -2.076445>
  }
  sphere { // Sphere15
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale 0.3
    translate  <2.123848, 1.843259, -1.642626>
  }
}
#declare Finger = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate <-61.320484, -22.243258, 168.301208>
  translate  <-2.401142, -0.058779, -2.676714>
}

#declare Finger1 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate <9.005053, 19.205616, -163.693832>
  translate  <-1.893007, -0.156422, -2.558259>
}

#declare Finger2 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate 180.0*z
  translate  <-2.164012, -0.156422, -2.62601>
}

#declare Finger3 = blob {
  threshold 0.6
  component 1.0, 0.578701, <0.0, -0.345992, 0.261603>

  component 1.0, 0.382878, <0.0, 0.227848, 0.329114>

  component 1.0, 0.317963, <0.0, 0.616034, -0.042194>

  component 1.0, 0.25635, <0.0, 0.548523, -0.413502>

  component 1.0, 0.177747, <0.0, 0.362869, -0.599156>

  component 1.0, 0.112417, <0.0, 0.278481, -0.7173>

  component 1.0, 0.366003, <0.0, 0.481013, 0.14346>

  component 1.0, 0.305807, <0.0, 0.582278, -0.227848>

  component 1.0, 0.224834, <0.0, 0.43038, -0.531646>

  component 1.0, 0.397454, <0.0, -0.025316, 0.531646>

  texture {
    Claw
  }
  scale 0.296546
  rotate <-94.664795, 0.0, -30.345383>
  translate  <-1.974448, 0.277164, -2.748814>
}

#declare Arm6 = union {
  sphere { // Sphere16
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.4, 1.0>
    rotate <0.0, 43.895737, 0.0>
    translate  <-1.425605, 1.900312, -1.025246>
  }
  sphere { // Sphere17
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.2, 0.2, 1.0>
    rotate 44.0*y
    translate  <-1.603305, 1.820323, -1.087326>
  }
  sphere { // Sphere004
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.2, 0.3, 0.9>
    rotate <-58.829998, 0.0, 0.0>
    translate  <-2.129303, 1.218839, -2.076445>
  }
  sphere { // Sphere005
    <0,0,0>,1
    texture {
      MonSkin2
    }
    scale <0.3, 0.416793, 0.2>
    translate  <-2.148042, 0.272516, -2.529674>
  }
  object { Finger }
  object { Finger1 }
  object { Finger2 }
  object { Finger3 }
}
#declare Torso1 = blob {
  threshold 0.6
  component 1.0, 0.755789, <0.464135, -0.025316, 0.0>

  component 1.0, 0.755789, <-0.464135, -0.025316, 0.0>

  component 1.0, 0.35192, <-0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.392405, 0.0>

  component 1.0, 0.35192, <0.21097, -1.392405, 0.0>

  component 1.0, 0.655497, <0.0, -0.481013, 0.413502>

  component 1.0, 0.227627, <0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <-0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <-0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <0.616034, -0.751055, 0.0>

  component 1.0, 0.227627, <-0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.751055, 0.0>

  component 1.0, 0.640875, <0.0, 0.261603, 0.514768>

  component 1.0, 0.562084, <0.0, -0.329114, 0.835443>

  component 1.0, 0.648714, <0.0, -1.07173, 0.481013>

  component 1.0, 0.653567, <0.700422, 0.126582, 0.582278>

  component 1.0, 0.653567, <-0.700422, 0.126582, 0.582278>

  component 1.0, 0.648714, <0.43038, -1.156118, 0.481013>

  component 1.0, 0.648714, <-0.43038, -1.156118, 0.481013>

  component 1.0, 0.655497, <0.548523, -0.565401, 0.413502>

  component 1.0, 0.655497, <-0.548523, -0.565401, 0.413502>

  component 1.0, 0.478267, <0.869198, -0.177215, 0.481013>

  component 1.0, 0.478267, <-0.869198, -0.177215, 0.481013>

  component 1.0, 0.439128, <0.0, -1.071334, 0.840585>

  component 1.0, 0.555458, <0.0, 0.543908, 0.939478>

  component 1.0, 0.462961, <-0.405063, -1.627004, 0.38481>

  component 1.0, 0.458573, <0.0, -1.437975, 0.357806>

  component 1.0, 0.50635, <0.0, -1.802532, 0.303797>

  component 1.0, 0.462961, <0.405063, -1.627004, 0.38481>

  component 1.0, 0.506656, <-0.031646, -2.162447, 0.28481>

  texture {
    MonSkin2
  }
  rotate <42.653431, 0.0, 180.0>
  translate  <0.0, 1.624448, -0.854973>
}

#declare BzPtch001 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.000000, 0.000000, -4.839393>, <-1.000000, -1.000000, -4.839393>, <1.000000, -1.000000, -4.839393>, <1.000000, 0.000000, -4.839393>,
      <-3.103447, -1.593073, -0.507743>, <-3.103447, -2.593073, -0.507743>, <-1.103447, -2.593073, -0.507743>, <-1.103447, -1.593073, -0.507743>,
      <1.704432, 3.471297, 2.906021>, <1.704432, 2.471297, 2.906021>, <3.704432, 2.471297, 2.906021>, <3.704432, 3.471297, 2.906021>,
      <0.000000, 0.000000, 5.259071>, <0.000000, -0.000265, 5.259071>, <0.000000, -0.000265, 5.259071>, <0.000000, 0.000000, 5.259071>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 0.000000, -4.839393>, <1.000000, 1.000000, -4.839393>, <-1.000000, 1.000000, -4.839393>, <-1.000000, 0.000000, -4.839393>,
      <-1.103447, -1.593073, -0.507743>, <-1.103447, -0.593073, -0.507743>, <-3.103447, -0.593073, -0.507743>, <-3.103447, -1.593073, -0.507743>,
      <3.704432, 3.471297, 2.906021>, <3.704432, 4.471297, 2.906021>, <1.704432, 4.471297, 2.906021>, <1.704432, 3.471297, 2.906021>,
      <0.000000, 0.000000, 5.259071>, <0.000000, 0.000265, 5.259071>, <0.000000, 0.000265, 5.259071>, <0.000000, 0.000000, 5.259071>
    }
  }
  texture {
    MonSkin2
  }
  scale 0.295191
  rotate <74.812119, 0.0, -180.0>
  translate  <0.010655, 4.633704, -1.353688>
}
union { // Body
  object { HeadGrp }
  object { Leg5 }
  object { Leg6 }
  object { Arm5 }
  object { Arm6 }
  object { Torso1 }
  object { BzPtch001 }
  rotate 97.410614*z
  translate  <-4.305806, -1.173634, -0.563839>
}


#declare Feet5 = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.375899, 0.289485>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  rotate -54.167839*x
  translate  <-0.928728, -0.171726, -5.657114>
}

#declare Leg8 = union {
  object { Feet5 }
  sphere { // Leg7
    <0,0,0>,1
    scale <0.3, 1.5, 0.6>
    rotate 47.286095*x
    translate  <-0.92146, 0.608708, -3.979479>
  }
  texture {
    MSkin
  }
  rotate 30.878572*x
  translate  <0.0, -0.883301, -1.230312>
}
#declare Feet6 = blob {
  threshold 0.6
  component 1.0, 0.377895, <0.0, -0.734177, -0.447257>

  component 1.0, 0.416094, <0.0, -0.700422, -0.109705>

  component 1.0, 0.476944, <0.0, -0.700422, 0.244726>

  component 1.0, 0.478267, <0.0, -0.78481, 0.582278>

  component 1.0, 0.52488, <0.227848, -0.818565, 0.295359>

  component 1.0, 0.52488, <-0.227848, -0.818565, 0.295359>

  component 1.0, 0.416094, <0.244726, -0.902954, -0.261603>

  component 1.0, 0.416094, <-0.244726, -0.902954, -0.261603>

  component 1.0, 0.286608, <0.14346, -0.987342, -0.632911>

  component 1.0, 0.286608, <-0.14346, -0.987342, -0.632911>

  component 1.0, 0.493867, <0.0, -0.375899, 0.289485>

  component 1.0, 0.213296, <0.14346, -1.172996, -0.78481>

  component 1.0, 0.213296, <-0.14346, -1.172996, -0.78481>

  rotate -54.167839*x
  translate  <0.928728, -0.171726, -5.657114>
}

#declare Leg9 = union {
  object { Feet6 }
  sphere { // LegM3
    <0,0,0>,1
    scale <0.3, 1.5, 0.6>
    rotate 47.286095*x
    translate  <0.92146, 0.608708, -3.979479>
  }
  texture {
    MSkin
  }
  rotate 53.495422*x
  translate  <0.0, -1.419591, -2.239798>
}
#declare Mhead1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.011470, -1.992924, -0.001520>, <-0.178451, -1.992924, 0.004200>, <-0.089226, -1.992924, 0.004200>, <-0.082352, -1.992924, 0.002294>,
      <0.005771, -1.819005, -0.733862>, <-1.962963, -1.819005, 0.000000>, <-0.981481, -1.606346, 0.582262>, <0.000000, -1.606346, 0.582262>,
      <0.005771, -0.909502, -0.733862>, <-1.962963, -0.909502, 0.000000>, <-0.981481, -0.852793, 0.568084>, <0.000000, -0.852793, 0.568084>,
      <0.026780, -0.144925, -0.733862>, <-2.867371, -0.144925, 0.000000>, <-1.424537, -0.107430, 0.976426>, <0.018296, -0.107430, 0.976426>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.026780, -0.144925, -0.733862>, <-2.867371, -0.144925, 0.000000>, <-1.424537, -0.107430, 0.976426>, <0.018296, -0.107430, 0.976426>,
      <0.047789, 0.619652, -0.733862>, <-3.771778, 0.619652, 0.000000>, <-1.867593, 0.637933, 1.384768>, <0.036592, 0.637933, 1.384768>,
      <0.047789, 1.564553, -0.733862>, <-3.771778, 1.564553, 0.000000>, <-1.867593, 1.582834, 1.384768>, <0.036592, 1.582834, 1.384768>,
      <-0.015669, 1.763764, 0.000000>, <-0.012664, 1.763764, 0.000000>, <-0.009658, 1.763764, 0.000000>, <-0.006652, 1.763764, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.082352, -1.992924, 0.002294>, <-0.075479, -1.992924, 0.000387>, <0.013747, -1.992924, 0.000387>, <0.102973, -1.992924, 0.000387>,
      <0.000000, -1.606346, 0.582262>, <0.981481, -1.606346, 0.582262>, <1.962963, -1.819005, 0.000000>, <-0.030496, -1.797164, -0.721591>,
      <0.000000, -0.852793, 0.568084>, <0.981481, -0.852793, 0.568084>, <1.962963, -0.909502, 0.000000>, <-0.030496, -0.921649, -0.721591>,
      <0.018296, -0.107430, 0.976426>, <1.461129, -0.107430, 0.976426>, <2.903962, -0.144925, 0.000000>, <-0.026534, -0.157308, -0.721591>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.018296, -0.107430, 0.976426>, <1.461129, -0.107430, 0.976426>, <2.903962, -0.144925, 0.000000>, <-0.026534, -0.157308, -0.721591>,
      <0.036592, 0.637933, 1.384768>, <1.940777, 0.637933, 1.384768>, <3.844962, 0.619652, 0.000000>, <-0.022573, 0.607033, -0.721591>,
      <0.036592, 1.582834, 1.384768>, <1.940777, 1.582834, 1.384768>, <3.844962, 1.564553, 0.000000>, <-0.022573, 1.587243, -0.721591>,
      <-0.006652, 1.763764, 0.000000>, <-0.003647, 1.763764, 0.000000>, <-0.008627, 1.763764, -0.037292>, <-0.005622, 1.763764, -0.037292>
    }
  }
  scale <0.572929, 1.050353, 1.03445>
  rotate 55.621639*x
}
#declare Mouth1 = blob {
  threshold 0.6
  component 1.0, 0.259251, <0.0, 0.19011, -0.487372>

  component 1.0, 0.216465, <0.0, 0.120979, -0.618721>

  component 1.0, 0.182006, <0.0, -0.015928, -0.720288>

  component 1.0, 0.170169, <0.0, -0.07256, -0.84417>

  component 1.0, 0.147982, <0.0, -0.044244, -0.91496>

  component 1.0, 0.121362, <0.0, 0.054862, -0.978671>

  component 1.0, 0.099465, <0.0, 0.157508, -0.971592>

  component 1.0, 0.070333, <0.0, 0.242456, -0.953895>

  component 1.0, 0.182006, <0.125652, -0.026546, -0.720288>

  component 1.0, 0.170169, <0.228298, -0.054862, -0.84417>

  component 1.0, 0.147982, <0.309706, -0.093797, -0.91496>

  component 1.0, 0.121362, <0.35572, -0.012388, -0.978671>

  component 1.0, 0.121362, <0.348641, 0.040704, -0.978671>

  component 1.0, 0.099465, <0.359259, 0.118573, -0.971592>

  component 1.0, 0.070333, <0.373417, 0.189363, -0.953895>

  component 1.0, 0.182006, <-0.125652, -0.026546, -0.720288>

  component 1.0, 0.121362, <-0.348641, 0.040704, -0.978671>

  component 1.0, 0.099465, <-0.359259, 0.118573, -0.971592>

  component 1.0, 0.070333, <-0.373417, 0.189363, -0.953895>

  component 1.0, 0.121362, <-0.35572, -0.012388, -0.978671>

  component 1.0, 0.147982, <-0.309706, -0.093797, -0.91496>

  component 1.0, 0.170169, <-0.228298, -0.054862, -0.84417>

  texture {
    Texture01
  }
  scale 2.0
  rotate -85.820084*x
  translate  <0.0, -0.135032, -0.415095>
}

#declare Horn1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.804274, 0.000000, -0.762032>, <3.804274, -1.000000, -0.762032>, <3.810547, -1.000000, 1.237958>, <3.810547, 0.000000, 1.237958>,
      <1.804284, 0.000000, -0.755759>, <1.804284, -1.000000, -0.755759>, <1.810556, -1.000000, 1.244231>, <1.810556, 0.000000, 1.244231>,
      <-3.800457, 0.000000, 1.598913>, <-3.800457, -1.000000, 1.598913>, <-2.600915, -1.000000, 3.199256>, <-2.600915, 0.000000, 3.199256>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.810547, 0.000000, 1.237958>, <3.810547, 1.000000, 1.237958>, <3.804274, 1.000000, -0.762032>, <3.804274, 0.000000, -0.762032>,
      <1.810556, 0.000000, 1.244231>, <1.810556, 1.000000, 1.244231>, <1.804284, 1.000000, -0.755759>, <1.804284, 0.000000, -0.755759>,
      <-2.600915, 0.000000, 3.199256>, <-2.600915, 1.000000, 3.199256>, <-3.800457, 1.000000, 1.598913>, <-3.800457, 0.000000, 1.598913>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  texture {
    Mskin2
  }
  scale 0.2
  rotate <-102.8181, 28.257862, 55.896023>
  translate  <-0.877629, -0.081346, 1.414243>
}
#declare Horn7 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.804274, 0.000000, -0.762032>, <3.804274, -1.000000, -0.762032>, <3.810547, -1.000000, 1.237958>, <3.810547, 0.000000, 1.237958>,
      <1.804284, 0.000000, -0.755759>, <1.804284, -1.000000, -0.755759>, <1.810556, -1.000000, 1.244231>, <1.810556, 0.000000, 1.244231>,
      <-3.800457, 0.000000, 1.598913>, <-3.800457, -1.000000, 1.598913>, <-2.600915, -1.000000, 3.199256>, <-2.600915, 0.000000, 3.199256>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.810547, 0.000000, 1.237958>, <3.810547, 1.000000, 1.237958>, <3.804274, 1.000000, -0.762032>, <3.804274, 0.000000, -0.762032>,
      <1.810556, 0.000000, 1.244231>, <1.810556, 1.000000, 1.244231>, <1.804284, 1.000000, -0.755759>, <1.804284, 0.000000, -0.755759>,
      <-2.600915, 0.000000, 3.199256>, <-2.600915, 1.000000, 3.199256>, <-3.800457, 1.000000, 1.598913>, <-3.800457, 0.000000, 1.598913>,
      <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>, <0.293296, 0.000000, 11.145507>
    }
  }
  texture {
    Mskin2
  }
  scale 0.2
  rotate <174.643326, 85.196686, 84.996429>
  translate  <0.04311, -0.577944, 0.462122>
}
#declare Horn8 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.804274, 0.000000, -0.762032>, <3.804274, -1.000000, -0.762032>, <3.810547, -1.000000, 1.237958>, <3.810547, 0.000000, 1.237958>,
      <1.804284, 0.000000, -0.755759>, <1.804284, -1.000000, -0.755759>, <1.810556, -1.000000, 1.244231>, <1.810556, 0.000000, 1.244231>,
      <-0.980622, 0.000000, 2.726847>, <-0.980622, -1.000000, 2.726847>, <0.218920, -1.000000, 4.327190>, <0.218920, 0.000000, 4.327190>,
      <2.690157, 0.000000, 7.761705>, <2.690157, 0.000000, 7.761705>, <2.690156, 0.000000, 7.761705>, <2.690156, 0.000000, 7.761705>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.810547, 0.000000, 1.237958>, <3.810547, 1.000000, 1.237958>, <3.804274, 1.000000, -0.762032>, <3.804274, 0.000000, -0.762032>,
      <1.810556, 0.000000, 1.244231>, <1.810556, 1.000000, 1.244231>, <1.804284, 1.000000, -0.755759>, <1.804284, 0.000000, -0.755759>,
      <0.218920, 0.000000, 4.327190>, <0.218920, 1.000000, 4.327190>, <-0.980622, 1.000000, 2.726847>, <-0.980622, 0.000000, 2.726847>,
      <2.690156, 0.000000, 7.761705>, <2.690156, 0.000000, 7.761705>, <2.690157, 0.000000, 7.761705>, <2.690157, 0.000000, 7.761705>
    }
  }
  texture {
    Mskin2
  }
  scale 0.15
  rotate <-111.299995, 0.422729, -172.103149>
  translate  <0.952332, -0.325152, -1.112168>
}
#declare Head4 = union {
  object { Mhead1 }
  sphere { // Eye5
    <0,0,0>,1
    texture {
      Eye_Balls
    }
    scale <0.3, 0.25, 0.4>
    rotate <-9.469096, 1.449308, -15.625997>
    translate  <-0.584356, -0.806818, -0.139947>
  }
  sphere { // Eye6
    <0,0,0>,1
    texture {
      Eye_Balls
    }
    scale <0.3, 0.25, 0.4>
    rotate <-6.824969, -2.491854, 15.744681>
    translate  <0.584356, -0.806818, -0.139947>
  }
  object { Mouth1 }
  object { // Mouth3->Mouth
    Mouth
    texture {
      Texture01
    }
    rotate <173.604279, 0.0, 180.0>
    translate  <0.0, 0.108115, -2.038958>
  }
  object { Horn1 }
  object { // Horn6->Horn
    Horn
    rotate <-119.979485, 0.0, -180.0>
    translate  <0.178181, 1.22817, 2.085966>
  }
  object { Horn7 }
  object { Horn8 }
  object { // Horn9->Horn4
    Horn4
    rotate <147.252396, 3.52487, 177.735565>
    translate  <0.050937, 0.514308, -1.82984>
  }
  cone { // ConeHorn9
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Mskin2
    }
    scale <0.2, 0.2, 1.0>
    rotate -128.386551*x
    translate  <0.0, -1.365102, 1.365102>
  }
  object { // ConeHorn10->ConeHorn6
    ConeHorn6
    texture {
      Mskin2
    }
    rotate -26.242691*x
    translate  <0.0, 0.431085, 0.57478>
  }
  object { // ConeHorn11->ConeHorn6
    ConeHorn6
    texture {
      Mskin2
    }
    rotate -25.438396*x
    translate  <0.0, -0.107771, 0.359237>
  }
  texture {
    MSkin
  }
}
#declare tent9 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.322683, 0.000000, -0.660190>, <-3.322683, -1.000000, -0.660190>, <-1.548354, -1.000000, -1.583098>, <-1.548354, 0.000000, -1.583098>,
      <-0.939898, 0.000000, 7.054405>, <-0.939898, -1.000000, 7.054405>, <-1.041831, -1.000000, 5.057004>, <-1.041831, 0.000000, 5.057004>,
      <9.602128, 0.000000, -2.431546>, <9.602128, -1.000000, -2.431546>, <11.602124, -1.000000, -2.435408>, <11.602124, 0.000000, -2.435408>,
      <13.444336, 0.000000, 2.348920>, <13.444336, -0.039474, 2.348920>, <13.398336, -0.039474, 2.355794>, <13.398336, 0.000000, 2.355794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.548354, 0.000000, -1.583098>, <-1.548354, 1.000000, -1.583098>, <-3.322683, 1.000000, -0.660190>, <-3.322683, 0.000000, -0.660190>,
      <-1.041831, 0.000000, 5.057004>, <-1.041831, 1.000000, 5.057004>, <-0.939898, 1.000000, 7.054405>, <-0.939898, 0.000000, 7.054405>,
      <11.602124, 0.000000, -2.435408>, <11.602124, 1.000000, -2.435408>, <9.602128, 1.000000, -2.431546>, <9.602128, 0.000000, -2.431546>,
      <13.398336, 0.000000, 2.355794>, <13.398336, 0.039474, 2.355794>, <13.444336, 0.039474, 2.348920>, <13.444336, 0.000000, 2.348920>
    }
  }
  scale 0.5
  rotate <11.711938, 67.919121, 130.126602>
  translate  <-0.919191, 1.462037, -0.507539>
}
#declare Tentacles1 = union {
  object { tent9 }
  object { // tent10->tent1
    tent1
    rotate <0.0, 0.0, -10.0>
    translate  0.0*x
  }
  object { // tent11->tent1
    tent1
    rotate <0.0, 0.0, -20.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tent12->tent1
    tent1
    rotate <0.0, 0.0, -30.0>
    translate  0.0*x
  }
  object { // tent13->tent1
    tent1
    rotate <0.0, 0.0, -40.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tent14->tent1
    tent1
    rotate <0.0, 0.0, -50.0>
    translate  0.0*y
  }
  object { // tent15->tent1
    tent1
    rotate <0.0, 0.0, -60.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // tent16->tent1
    tent1
    rotate <0.0, 0.0, -70.0>
    translate  <0.0, 0.0, 0.0>
  }
  texture {
    Cape
  }
}
#declare Fingers3 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.609673, 0.000000, 4.084341>, <5.609673, -0.010724, 4.084341>, <5.610074, -0.019497, 4.092551>, <5.610565, -0.019497, 4.102585>,
      <2.375984, 0.000000, -3.266339>, <2.375984, -0.550000, -3.266339>, <2.343677, -1.000000, -2.817501>, <2.304190, -1.000000, -2.268920>,
      <-1.607547, 0.000000, 1.814970>, <-1.607547, -0.550000, 1.814970>, <-1.226156, -1.000000, 1.576137>, <-0.760012, -1.000000, 1.284230>,
      <1.919528, -0.002125, 5.131287>, <1.919528, 0.006066, 5.131287>, <1.926927, 0.012767, 5.126654>, <1.935969, 0.012767, 5.120991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.610565, -0.019497, 4.102585>, <5.611055, -0.019497, 4.112619>, <5.611456, -0.010724, 4.120829>, <5.611456, 0.000000, 4.120829>,
      <2.304190, -1.000000, -2.268920>, <2.264704, -1.000000, -1.720339>, <2.232396, -0.550000, -1.271500>, <2.232396, 0.000000, -1.271500>,
      <-0.760012, -1.000000, 1.284230>, <-0.293868, -1.000000, 0.992323>, <0.087523, -0.550000, 0.753490>, <0.087523, 0.000000, 0.753490>,
      <1.935969, 0.012767, 5.120991>, <1.945011, 0.012767, 5.115329>, <1.952410, 0.006066, 5.110696>, <1.952410, -0.002125, 5.110696>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.611456, 0.000000, 4.120829>, <5.611456, 0.010724, 4.120829>, <5.611055, 0.019497, 4.112619>, <5.610565, 0.019497, 4.102585>,
      <2.232396, 0.000000, -1.271500>, <2.232396, 0.550000, -1.271500>, <2.264704, 1.000000, -1.720339>, <2.304190, 1.000000, -2.268920>,
      <0.087523, 0.000000, 0.753490>, <0.087523, 0.550000, 0.753490>, <-0.293868, 1.000000, 0.992323>, <-0.760012, 1.000000, 1.284230>,
      <1.952410, -0.002125, 5.110696>, <1.952410, -0.010315, 5.110696>, <1.945011, -0.017016, 5.115329>, <1.935969, -0.017016, 5.120991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.610565, 0.019497, 4.102585>, <5.610074, 0.019497, 4.092551>, <5.609673, 0.010724, 4.084341>, <5.609673, 0.000000, 4.084341>,
      <2.304190, 1.000000, -2.268920>, <2.343677, 1.000000, -2.817501>, <2.375984, 0.550000, -3.266339>, <2.375984, 0.000000, -3.266339>,
      <-0.760012, 1.000000, 1.284230>, <-1.226156, 1.000000, 1.576137>, <-1.607547, 0.550000, 1.814970>, <-1.607547, 0.000000, 1.814970>,
      <1.935969, -0.017016, 5.120991>, <1.926927, -0.017016, 5.126654>, <1.919528, -0.010315, 5.131287>, <1.919528, -0.002125, 5.131287>
    }
  }
  texture {
    Mskin2
  }
  scale 0.171023
  rotate <23.709785, 57.765511, 20.37924>
  translate  <-2.846859, -1.577309, -1.151177>
}
#declare Arm8 = union {
  object { Fingers3 }
  object { // Arm7->Arms
    Arms
    texture {
      MSkin
    }
    scale <0.7, 0.8, 0.8>
    rotate <101.921432, -11.193434, -168.122757>
    translate  <-0.49246, 1.945845, -2.116412>
  }
}
#declare Arms2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <5.284189, 0.000000, -5.931815>, <5.284189, -1.000000, -5.931815>, <7.095379, -1.000000, -5.083529>, <7.095379, 0.000000, -5.083529>,
      <0.646171, 0.000000, 0.718696>, <0.646171, -1.000000, 0.718696>, <2.155666, -1.000000, -0.593334>, <2.155666, 0.000000, -0.593334>,
      <7.030238, 0.000000, 3.301731>, <7.030238, -1.000000, 3.301731>, <8.962018, -1.000000, 2.783826>, <8.962018, 0.000000, 2.783826>,
      <15.271366, 0.000000, 2.754927>, <15.271366, -0.039474, 2.754927>, <15.225366, -0.039474, 2.761800>, <15.225366, 0.000000, 2.761800>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <7.095379, 0.000000, -5.083529>, <7.095379, 1.000000, -5.083529>, <5.284189, 1.000000, -5.931815>, <5.284189, 0.000000, -5.931815>,
      <2.155666, 0.000000, -0.593334>, <2.155666, 1.000000, -0.593334>, <0.646171, 1.000000, 0.718696>, <0.646171, 0.000000, 0.718696>,
      <8.962018, 0.000000, 2.783826>, <8.962018, 1.000000, 2.783826>, <7.030238, 1.000000, 3.301731>, <7.030238, 0.000000, 3.301731>,
      <15.225366, 0.000000, 2.761800>, <15.225366, 0.039474, 2.761800>, <15.271366, 0.039474, 2.754927>, <15.271366, 0.000000, 2.754927>
    }
  }
  texture {
    MSkin
  }
  scale <0.5, 0.4, 0.5>
  rotate <-119.607353, 62.058563, -132.962631>
  translate  <4.512716, 1.513863, 0.857027>
}
#declare Arm9 = union {
  object { // Fingers1->Fingers2
    Fingers2
    texture {
      Mskin2
    }
    rotate <-70.707932, -23.631657, 172.01268>
    translate  <1.013114, -1.967217, -4.099781>
  }
  object { Arms2 }
}
#declare Torso2 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.123126, -2.294035, -0.542257>, <-0.090876, -2.315323, -0.531075>, <-0.109960, -2.294035, -0.348373>, <-0.125344, -2.294035, -0.348373>,
      <-0.144153, -2.000000, -1.375656>, <-2.122797, -2.076845, -1.296317>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>,
      <-0.144153, -1.000000, -1.375656>, <-2.240416, -1.021288, -1.296317>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>,
      <-0.185928, -0.113692, -1.375656>, <-2.889680, -0.159356, -0.956799>, <-1.785742, 0.088764, 0.406552>, <0.000000, 0.088764, 0.406552>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.185928, -0.113692, -1.375656>, <-2.889680, -0.159356, -0.956799>, <-1.785742, 0.088764, 0.406552>, <0.000000, 0.088764, 0.406552>,
      <-0.227703, 0.772616, -1.375656>, <-3.538944, 0.702576, -0.617281>, <-2.571484, 1.177527, 0.813104>, <0.000000, 1.177527, 0.813104>,
      <-0.144153, 2.000000, -1.375656>, <-2.240416, 1.909347, -0.617281>, <-1.000000, 2.000000, 1.526023>, <0.000000, 2.000000, 1.526023>,
      <-0.047799, 2.401352, -0.196545>, <-0.046295, 2.382211, -0.128533>, <-0.047185, 2.420973, -0.131028>, <-0.047902, 2.420973, -0.131028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.125344, -2.294035, -0.348373>, <-0.140729, -2.294035, -0.348373>, <-0.160905, -2.315323, -0.531075>, <-0.124976, -2.294035, -0.542257>,
      <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, <1.019426, -2.055728, -1.296317>, <-0.023931, -2.000000, -1.375656>,
      <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, <2.311437, -1.021288, -1.296317>, <-0.023931, -1.000000, -1.375656>,
      <0.000000, 0.088764, 0.406552>, <1.785742, 0.088764, 0.406552>, <2.981283, -0.159356, -0.956799>, <-0.030867, -0.113692, -1.375656>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.088764, 0.406552>, <1.785742, 0.088764, 0.406552>, <2.981283, -0.159356, -0.956799>, <-0.030867, -0.113692, -1.375656>,
      <0.000000, 1.177527, 0.813104>, <2.571484, 1.177527, 0.813104>, <3.651130, 0.702576, -0.617281>, <-0.037802, 0.772616, -1.375656>,
      <0.000000, 2.000000, 1.526023>, <1.000000, 2.000000, 1.526023>, <2.311437, 1.909347, -0.617281>, <-0.023931, 2.000000, -1.375656>,
      <-0.047902, 2.420973, -0.131028>, <-0.048620, 2.420973, -0.131028>, <-0.049560, 2.382211, -0.128533>, <-0.047885, 2.401352, -0.196545>
    }
  }
  texture {
    MSkin
  }
  rotate 100.093857*x
  translate  <0.0, 1.113817, -2.053548>
}
union { // alien2
  object { Leg8 }
  object { Leg9 }
  object { Head4 }
  object { Tentacles1 }
  object { Arm8 }
  object { Arm9 }
  object { Torso2 }
  rotate -109.989067*z
  translate  <8.851451, -4.978941, 0.0>
}


#declare Blob2 = blob {
  threshold 0.6
  component 1.0, 0.335372, <0.0, -0.075949, -0.548523>

  component 1.0, 0.452469, <0.0, -0.025316, -0.227848>

  component 1.0, 0.842752, <0.0, 0.109705, 0.244726>

  component 1.0, 0.177747, <0.0, -0.464135, -0.43038>

  component 1.0, 0.207286, <0.0, -0.481013, -0.278481>

  component 1.0, 0.251372, <0.0, -0.447257, -0.109705>

  component 1.0, 0.301646, <0.0, -0.379747, 0.109705>

  component 1.0, 0.355493, <0.0, -0.312236, 0.312236>

  component 1.0, 0.207286, <0.109705, -0.531646, -0.329114>

  component 1.0, 0.207286, <-0.109705, -0.531646, -0.329114>

  component 1.0, 0.150823, <0.194093, -0.396624, -0.49789>

  component 1.0, 0.150823, <-0.194093, -0.396624, -0.49789>

  component 1.0, 0.158981, <0.345992, 0.278481, 0.278481>

  component 1.0, 0.158981, <0.413502, 0.396624, 0.312236>

  component 1.0, 0.158981, <0.481013, 0.531646, 0.379747>

  component 1.0, 0.158981, <-0.481013, 0.531646, 0.379747>

  component 1.0, 0.158981, <-0.413502, 0.396624, 0.312236>

  component 1.0, 0.158981, <-0.345992, 0.278481, 0.278481>

  component 1.0, 0.591659, <0.0, -0.261603, 0.582278>

  component -3.279262, 0.190625, <0.177215, 0.227848, -0.075949>

  component -3.279262, 0.190625, <-0.177215, 0.227848, -0.075949>

  texture {
    Monster_Skin
  }
  rotate <90.0, 0.0, 180.0>
  translate  <0.0, -0.625815, -0.135311>
}

#declare Head5 = union {
  sphere { // EyeBall2
    <0,0,0>,1
    texture {
      EyeQ
    }
    scale 0.1
    translate  <0.173513, -0.696754, 0.095961>
  }
  object { Blob2 }
  sphere { // EyeBall3
    <0,0,0>,1
    texture {
      EyeQ
    }
    scale 0.1
    translate  <-0.173513, -0.696754, 0.095961>
  }
  translate  <0.0, -0.158573, -0.08395>
}
#declare Blob4 = blob {
  threshold 0.6
  component 1.0, 1.50823, <-0.413502, 0.025316, 0.0>

  component 1.0, 1.59972, <0.43038, -0.008439, 0.0>

  component 1.0, 1.45752, <-0.548523, -1.18987, 0.0>

  component 1.0, 1.4348, <0.700422, -1.20675, 0.0>

  component 1.0, 0.983246, <1.49367, -0.548523, 0.0>

  component 1.0, 0.747382, <1.72996, 0.109705, 0.0>

  component 1.0, 0.683805, <1.79747, 0.683544, 0.0>

  component 1.0, 0.676372, <1.82278, 1.21519, 0.0>

  component 1.0, 0.714533, <0.759494, 0.911392, 0.0>

  component 1.0, 0.676372, <0.742616, 1.50211, 0.0>

  component 1.0, 0.749914, <0.691983, 2.16034, 0.0>

  component 1.0, 0.708316, <0.599156, 2.79325, 0.0>

  component 1.0, 0.718941, <0.43038, 3.50211, 0.0>

  component 1.0, 0.679169, <-0.21097, 1.08861, 0.0>

  component 1.0, 0.714533, <-0.312236, 1.74684, 0.0>

  component 1.0, 0.629936, <-0.464135, 2.42194, 0.0>

  component 1.0, 0.698434, <-0.666667, 3.09705, 0.0>

  component 1.0, 0.715417, <-0.919831, 3.80591, 0.0>

  component 1.0, 0.640875, <-1.0211, 1.0211, 0.0>

  component 1.0, 0.621859, <-1.30802, 1.64557, 0.0>

  component 1.0, 0.670744, <-1.57806, 2.23629, 0.0>

  component 1.0, 0.620842, <-1.86498, 2.84388, 0.0>

  component 1.0, 1.21077, <-1.4346, -0.151899, 0.0>

  component 1.0, 1.24168, <-1.33333, -1.26582, 0.0>

  component 1.0, 0.670743, <-2.04219, 0.691983, 0.0>

  component 1.0, 0.674501, <-2.4135, 1.29958, 0.0>

  component 1.0, 0.78531, <1.80591, 1.90717, 0.0>

  component 1.0, 0.555298, <-2.75105, 1.77215, 0.0>

  texture {
    Monster_Skin
  }
  scale 0.110643
  rotate <-97.754265, -47.977207, -31.497839>
  translate  <-1.044082, -0.839313, -2.98157>
}

#declare arm3 = union {
  sphere { // Sphere35
    <0,0,0>,1
    texture {
      Monster_Skin
    }
    scale <0.3, 0.35, 1.0>
    rotate <0.0, 41.913845, 0.0>
    translate  <-1.211815, 0.109641, -1.285505>
  }
  sphere { // Sphere36
    <0,0,0>,1
    texture {
      Monster_Skin
    }
    scale <0.2, 0.2, 0.8>
    rotate <-41.562195, -29.737352, 6.339617>
    translate  <-1.421553, -0.304788, -2.391292>
  }
  sphere { // Sphere37
    <0,0,0>,1
    texture {
      Monster_Skin
    }
    scale 0.2
    rotate <0.0, 0.0, 0.0>
    translate  <-1.701202, 0.130571, -1.940499>
  }
  object { Blob4 }
  translate  <-0.41723, -0.002082, -0.023594>
}
#declare CSG3 = merge {
  sphere { // Sphere39
    <0,0,0>,1
    texture {
      Copper_Metal1
    }
    scale <1.0, 3.0, 1.0>
  }
  sphere { // Sphere40
    <0,0,0>,1
    texture {
      Barrels
    }
    scale <0.5, 3.0, 0.5>
    translate  -0.976934*x
  }
  sphere { // Sphere41
    <0,0,0>,1
    texture {
      Barrels
    }
    scale <0.5, 3.0, 0.5>
    rotate -90.0*y
    translate  <0.0, 0.0, -0.976934>
  }
  sphere { // Sphere42
    <0,0,0>,1
    texture {
      Barrels
    }
    scale <0.5, 3.0, 0.5>
    rotate <180.0, 0.0, 180.0>
    translate  <0.976934, 0.0, 0.0>
  }
  sphere { // Sphere43
    <0,0,0>,1
    texture {
      Barrels
    }
    scale <0.5, 3.0, 0.5>
    rotate 90.0*y
    translate  <0.0, 0.0, 0.976934>
  }
}
#declare Barrel37 = difference {
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*x
    translate  <0.0, 1.086938, 2.875126>
  }
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    scale <0.7, 0.7, 1.1>
    rotate 90.0*x
    translate  <0.0, 1.180892, 2.865055>
  }
  texture {
    Chrome_Textur1
  }
  scale <0.1, 3.0, 0.1>
  translate  <-0.006384, -5.414695, -0.936624>
}
#declare Barrel38 = difference {
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*x
    translate  <0.0, 1.086938, 2.875126>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <0.7, 0.7, 1.1>
    rotate 90.0*x
    translate  <0.0, 1.180892, 2.865055>
  }
  texture {
    Copper_Metal1
  }
  scale <0.5, 3.0, 0.5>
  translate  <0.0, -5.414695, -1.496166>
}
#declare Gun2 = union {
  sphere { // Sphere38
    <0,0,0>,1
    texture {
      Rusty_Iron1
    }
    translate  2.7*y
  }
  object { CSG3 }
  object { // Barrel26->Barrel1
    Barrel1
    rotate 30.0*y
    translate  0.0*x
  }
  object { // Barrel27->Barrel1
    Barrel1
    rotate 60.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel28->Barrel1
    Barrel1
    rotate <0.0, 90.0, 0.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel29->Barrel1
    Barrel1
    rotate <-180.0, 60.0, -180.0>
    translate  0.0*x
  }
  object { // Barrel30->Barrel1
    Barrel1
    rotate <-180.0, 30.0, -180.0>
    translate  0.0*x
  }
  object { // Barrel31->Barrel1
    Barrel1
    rotate <-180.0, 0.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel32->Barrel1
    Barrel1
    rotate <180.0, -30.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel33->Barrel1
    Barrel1
    rotate <180.0, -60.0, -180.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel34->Barrel1
    Barrel1
    rotate -90.0*y
    translate  <0.0, 0.0, 0.0>
  }
  object { // Barrel35->Barrel1
    Barrel1
    rotate -60.0*y
    translate  0.0*z
  }
  object { // Barrel36->Barrel1
    Barrel1
    rotate <0.0, -30.0, 0.0>
  }
  object { Barrel37 }
  object { Barrel38 }
  scale 0.3
  rotate <-90.0, 27.978672, -112.599953>
  translate  <1.642486, -2.21522, -1.026646>
}
#declare arm4 = union {
  object { Gun2 }
  sphere { // Sphere44
    <0,0,0>,1
    texture {
      Monster_Skin
    }
    scale <0.3, 0.35, 1.0>
    rotate <-75.075417, -35.701168, 19.575592>
    translate  <1.211815, -0.655484, -0.80813>
  }
  sphere { // Sphere45
    <0,0,0>,1
    texture {
      Monster_Skin
    }
    scale 0.2
    rotate <0.0, 0.0, 0.0>
    translate  <1.754594, -1.598363, -1.048292>
  }
  translate  0.204225*x
}
#declare Arms3 = union {
  object { arm3 }
  object { arm4 }
  translate  <0.0, -0.009048, -0.040716>
}
#declare tail1 = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.897001, -0.979530, 2.888163>, <-0.897001, 0.050198, 2.700215>, <0.774541, 0.050198, 2.700215>, <0.774541, -0.979530, 2.888163>,
      <-0.897001, -1.496180, 1.113217>, <-0.897001, -0.310191, 0.732948>, <0.774541, -0.310191, 0.732948>, <0.774541, -1.496180, 1.113217>,
      <0.594816, -3.941875, 0.174103>, <0.594816, -3.937283, -0.835351>, <2.266358, -3.937283, -0.835351>, <2.266358, -3.941875, 0.174103>,
      <-0.876326, -5.556904, 0.079718>, <-0.876326, -5.558323, -0.786654>, <0.795215, -5.558323, -0.786654>, <0.795215, -5.556904, 0.079718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.774541, -0.979530, 2.888163>, <0.774541, -2.009258, 3.076110>, <-0.897001, -2.009258, 3.076110>, <-0.897001, -0.979530, 2.888163>,
      <0.774541, -1.496180, 1.113217>, <0.774541, -2.682170, 1.493486>, <-0.897001, -2.682170, 1.493486>, <-0.897001, -1.496180, 1.113217>,
      <2.266358, -3.941875, 0.174103>, <2.266358, -3.946467, 1.183557>, <0.594816, -3.946467, 1.183557>, <0.594816, -3.941875, 0.174103>,
      <0.795215, -5.556904, 0.079718>, <0.795215, -5.555486, 0.946091>, <-0.876326, -5.555486, 0.946091>, <-0.876326, -5.556904, 0.079718>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.876326, -5.556904, 0.079718>, <-0.876326, -5.558323, -0.786654>, <0.795215, -5.558323, -0.786654>, <0.795215, -5.556904, 0.079718>,
      <-2.347469, -7.171933, -0.014666>, <-2.347469, -7.179362, -0.737958>, <-0.675927, -7.179362, -0.737958>, <-0.675927, -7.171933, -0.014666>,
      <2.994120, -9.824352, -0.067842>, <2.994120, -9.832490, -0.604982>, <5.180791, -9.832490, -0.604982>, <5.180791, -9.824352, -0.067842>,
      <-1.012194, -14.451480, 0.033314>, <-1.012194, -14.451534, 0.024276>, <-0.965511, -14.451534, 0.024276>, <-0.965511, -14.451480, 0.033314>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.795215, -5.556904, 0.079718>, <0.795215, -5.555486, 0.946091>, <-0.876326, -5.555486, 0.946091>, <-0.876326, -5.556904, 0.079718>,
      <-0.675927, -7.171933, -0.014666>, <-0.675927, -7.164505, 0.708625>, <-2.347469, -7.164505, 0.708625>, <-2.347469, -7.171933, -0.014666>,
      <5.180791, -9.824352, -0.067842>, <5.180791, -9.816214, 0.469298>, <2.994120, -9.816214, 0.469298>, <2.994120, -9.824352, -0.067842>,
      <-0.965511, -14.451480, 0.033314>, <-0.965511, -14.451427, 0.042352>, <-1.012194, -14.451427, 0.042352>, <-1.012194, -14.451480, 0.033314>
    }
  }
  texture {
    Monster_Skin
  }
  scale <0.65, 0.65, 0.7>
  rotate 180.0*z
  translate  <0.0, -0.186319, -3.967027>
}
#declare torso1 = blob {
  threshold 0.6
  component 1.0, 0.755789, <0.464135, -0.025316, 0.0>

  component 1.0, 0.755789, <-0.464135, -0.025316, 0.0>

  component 1.0, 0.35192, <-0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <0.21097, -0.700422, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <0.21097, -1.037975, 0.0>

  component 1.0, 0.35192, <-0.21097, -1.392405, 0.0>

  component 1.0, 0.35192, <0.21097, -1.392405, 0.0>

  component 1.0, 0.655497, <0.0, -0.481013, 0.413502>

  component 1.0, 0.227627, <0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.447257, -0.49789, 0.0>

  component 1.0, 0.227627, <0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <-0.49789, -0.734177, 0.0>

  component 1.0, 0.227627, <-0.481013, -0.953587, 0.0>

  component 1.0, 0.227627, <0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <0.616034, -0.751055, 0.0>

  component 1.0, 0.227627, <-0.78481, -0.447257, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.49789, 0.0>

  component 1.0, 0.227627, <-0.616034, -0.751055, 0.0>

  component 1.0, 0.640875, <0.0, 0.261603, 0.514768>

  component 1.0, 0.648714, <0.0, -1.07173, 0.481013>

  component 1.0, 0.653567, <0.700422, 0.126582, 0.582278>

  component 1.0, 0.653567, <-0.700422, 0.126582, 0.582278>

  component 1.0, 0.648714, <0.43038, -1.156118, 0.481013>

  component 1.0, 0.648714, <-0.43038, -1.156118, 0.481013>

  component 1.0, 0.655497, <0.548523, -0.565401, 0.413502>

  component 1.0, 0.655497, <-0.548523, -0.565401, 0.413502>

  component 1.0, 0.478267, <0.869198, -0.177215, 0.481013>

  component 1.0, 0.478267, <-0.869198, -0.177215, 0.481013>

  component 1.0, 0.462961, <-0.405063, -1.627004, 0.38481>

  component 1.0, 0.458573, <0.0, -1.437975, 0.357806>

  component 1.0, 0.50635, <0.0, -1.802532, 0.303797>

  component 1.0, 0.462961, <0.405063, -1.627004, 0.38481>

  component 1.0, 0.506656, <-0.031646, -2.162447, 0.28481>

  component 1.0, 0.480656, <0.0, -0.495781, 0.706751>

  component 1.0, 0.444367, <0.0, -0.094937, 0.727848>

  component 1.0, 0.480656, <0.0, -0.896624, 0.706751>

  component 1.0, 0.480656, <0.0, -1.297468, 0.727848>

  component 1.0, 0.480656, <0.0, -1.635021, 0.64346>

  component 1.0, 0.480656, <0.0, -1.93038, 0.453586>

  texture {
    Monster_Skin
  }
  rotate <71.65741, 0.0, 180.0>
  translate  <0.0, -0.351308, -0.846961>
}

union { // MOnster4
  object { Head5 }
  object { Arms3 }
  object { tail1 }
  object { torso1 }
  scale 1.3
  rotate 120.068611*z
  translate  <-10.804033, -8.905301, -0.257592>
}


object {   // HgtFld001
  height_field {
    gif "D:\MORAY2\IMAGE3.GIF"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Grnd
  }
  normal {
     bumps 2.0000
     turbulence 1.000
     scale     0.5000
   }
  scale <1000.0, 1000.0, 25.0>
  translate  <63.52479, 767.325252, 19.104322>
}


#include "ir2tree.inc"
