// This file is for use with the PoV-Ray raytracer.
// al_hand.pov: Converted from AutoCad DXF File: al_hand.dxf 

// This is a composite object description for use with the PoV-Ray
// raytracer. It does not include viewpoint or light source descriptions
// It uses the Dull texture from textures.inc and it may use Cylinder_Z
// from shapes.inc. 
// To use this file as an include file uncomment the #declare line and
// change DxfObject to an appropriate name.

#include "shapes.inc"
#include "colors.inc"
#include "stones.inc"
#include "textures.inc"
#include "glass.inc"

// Put camera {} here...
camera {
  location <0, 2, -2>
  look_at <0, 1, 10>
}

// Put light_source {} here...
light_source { <0, 2, -1> 
		color White
		}

light_source { <0, 2, 3> 
		color White
		}

// This part taken from "Two dolphins by night" in the Povray CDROM
object {
  sphere {<0 0 0> 1000}
  texture {
   pigment {
    image_map {gif "starfld1.gif" map_type 0 interpolate 2}
    translate <-0.5 -0.65 0>
    scale <700 700 700>
    }
  }
}
                 


// These textures taken from Povray tutorial
  #declare LandArea = texture {
      pigment {
        agate
        turbulence 1
        lambda 1.5
        omega.8
        octaves 8
        color_map {
          [0.00 color rgb <.5,.25,.15>]
          [0.33 color rgb <.1,.5,.4>]
          [0.86 color rgb <.6,.3,.1>]
          [1.00 color rgb <.5,.25,.15>]
        }
      }
    }
                                                        
  #declare OceanArea = texture {
    pigment {
      bozo
        turbulence.5
        lambda 2
        color_map {
          [0.00, 0.33 color rgb <0, 0, 1>
                      color rgb <0, 0, 1>]
          [0.33, 0.66 color rgbf <1, 1, 1, 1>
                      color rgbf <1, 1, 1, 1>]
          [0.66, 1.00 color rgb <0, 0, 1>
                      color rgb <0, 0, 1>]
        }
      }
    }


  #declare Clouds1 = pigment {
      bozo
      turbulence 1
      color_map {
        [0.0 color White filter 1]
        [0.5 color White]
        [1.0 color White filter 1]
      }
    }
  #declare Clouds2 = pigment {
    agate
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
      }
    }
  #declare Clouds3 = pigment {
    marble
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
    }
  }
  #declare Clouds4 = pigment {
    granite
    turbulence 1
    color_map {
      [0.0 color White filter 1]
      [0.5 color White]
      [1.0 color White filter 1]
    }
  }                                                      

  #declare CloudArea = texture {
    pigment {
      gradient y
      pigment_map {
        [0.00 Clouds1]
        [0.25 Clouds2]
        [0.50 Clouds3]
        [0.75 Clouds4]
        [1.00 Clouds1]
      }
    }
  }
                                                  

// The skull was a dxf object taken from the internet, and 
// translanted into povray format using dxf2pov
#include "skull.inc"


// This is a union of the alien hand and the earth.
// The hand was a dxf object taken off the internet, and
// translated into povray format using dxf2pov.
union {

  object {
    triangle { <7.711400, 0.458789, 31.735500>, <7.563810, 0.572009, 31.392600>, <7.581540, 0.665429, 31.377300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.584650, 0.761784, 31.376000>, <7.670240, 0.811579, 31.745100>, <7.684470, 0.705365, 31.742200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.670240, 0.811579, 31.745100>, <7.565250, 0.890038, 31.408400>, <7.513980, 0.998538, 31.420500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.484760, 1.188810, 31.500000>, <7.498990, 1.277150, 31.758100>, <7.572580, 1.132590, 31.754000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.305140, 1.368190, 31.620900>, <7.263240, 1.367630, 31.761300>, <7.399400, 1.342750, 31.760200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.305140, 1.368190, 31.620900>, <7.498990, 1.277150, 31.758100>, <7.414920, 1.299870, 31.563600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998660, 1.297170, 31.607400>, <7.089070, 1.276880, 31.759500>, <7.180710, 1.342840, 31.760900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.102220, 1.363540, 31.618000>, <7.263240, 1.367630, 31.761300>, <7.196170, 1.388570, 31.606100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.089070, 1.276880, 31.759500>, <6.998660, 1.297170, 31.607400>, <6.994920, 1.210420, 31.580700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.000770, 0.905924, 31.473200>, <7.124120, 0.763191, 31.745700>, <7.111780, 0.891358, 31.749100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.124120, 0.763191, 31.745700>, <7.000130, 0.794590, 31.478000>, <7.021250, 0.689850, 31.457100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068390, 0.621843, 31.382800>, <7.068340, 0.445756, 31.737400>, <7.108020, 0.577637, 31.740800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068340, 0.445756, 31.737400>, <7.040840, 0.522212, 31.433900>, <7.020880, 0.438807, 31.456400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996910, 0.330444, 31.459600>, <6.993430, 0.103619, 31.728500>, <7.020510, 0.269863, 31.732800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.993430, 0.103619, 31.728500>, <7.008610, 0.158372, 31.397100>, <6.953560, 0.066749, 31.458400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.900650, -0.034189, 31.501800>, <6.947440, -0.180761, 31.721000>, <6.953630, -0.040559, 31.724800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.972080, -0.262937, 31.718800>, <6.871720, -0.149587, 31.537100>, <6.899850, -0.245890, 31.536700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.097710, -0.333099, 31.536300>, <7.166260, -0.340892, 31.716000>, <7.090550, -0.337036, 31.716400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.166260, -0.340892, 31.716000>, <7.194570, -0.322464, 31.506700>, <7.271710, -0.297257, 31.489600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.339250, -0.252566, 31.465900>, <7.483960, -0.194224, 31.718900>, <7.415180, -0.297707, 31.711500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519220, 0.061950, 31.398900>, <7.594830, 0.194042, 31.353000>, <7.645230, 0.071263, 31.725400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.483960, -0.194224, 31.718900>, <7.436230, -0.162736, 31.432600>, <7.497060, -0.054357, 31.410900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.645230, 0.071263, 31.725400>, <7.594830, 0.194042, 31.353000>, <7.613600, 0.314318, 31.341800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.570400, 0.478752, 31.357500>, <7.711400, 0.458789, 31.735500>, <7.706720, 0.352299, 31.732700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.791440, 0.332931, 31.931300>, <7.711400, 0.458789, 31.735500>, <7.697740, 0.611212, 31.739700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.684470, 0.705365, 31.742200>, <7.775780, 0.812825, 31.944200>, <7.798140, 0.598565, 31.938400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.775780, 0.812825, 31.944200>, <7.670240, 0.811579, 31.745100>, <7.651230, 0.902266, 31.747600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.572580, 1.132590, 31.754000>, <7.619960, 1.242830, 31.956200>, <7.716290, 1.040270, 31.950500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.500100, 1.320840, 31.958700>, <7.498990, 1.277150, 31.758100>, <7.399400, 1.342750, 31.760200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.399400, 1.342750, 31.760200>, <7.380240, 1.339240, 31.959600>, <7.500100, 1.320840, 31.958700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.291520, 1.312710, 31.959200>, <7.263240, 1.367630, 31.761300>, <7.180710, 1.342840, 31.760900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.180710, 1.342840, 31.760900>, <7.217330, 1.245160, 31.957700>, <7.291520, 1.312710, 31.959200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.217330, 1.245160, 31.957700>, <7.089070, 1.276880, 31.759500>, <7.074500, 1.183260, 31.757000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.111780, 0.891358, 31.749100>, <7.178690, 0.741060, 31.944300>, <7.187600, 0.988996, 31.950900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.178690, 0.741060, 31.944300>, <7.124120, 0.763191, 31.745700>, <7.108020, 0.577637, 31.740800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.108020, 0.577637, 31.740800>, <7.092980, 0.407297, 31.935700>, <7.178690, 0.741060, 31.944300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.092980, 0.407297, 31.935700>, <7.068340, 0.445756, 31.737400>, <7.020510, 0.269863, 31.732800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.020510, 0.269863, 31.732800>, <6.989870, -0.041059, 31.924100>, <7.092980, 0.407297, 31.935700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.989870, -0.041059, 31.924100>, <6.993430, 0.103619, 31.728500>, <6.953630, -0.040559, 31.724800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.953630, -0.040559, 31.724800>, <6.942130, -0.198271, 31.921400>, <6.989870, -0.041059, 31.924100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.942130, -0.198271, 31.921400>, <6.947440, -0.180761, 31.721000>, <6.972080, -0.262937, 31.718800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.090550, -0.337036, 31.716400>, <7.118620, -0.337528, 31.915700>, <7.001490, -0.318646, 31.916600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.166260, -0.340892, 31.716000>, <7.294230, -0.317083, 31.716200>, <7.256950, -0.348216, 31.915000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.166260, -0.340892, 31.716000>, <7.256950, -0.348216, 31.915000>, <7.118620, -0.337528, 31.915700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.415180, -0.297707, 31.711500>, <7.483960, -0.194224, 31.718900>, <7.435930, -0.332463, 31.910000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.610160, -0.028230, 31.722900>, <7.676770, -0.074234, 31.920900>, <7.550280, -0.193904, 31.915700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.676770, -0.074234, 31.920900>, <7.645230, 0.071263, 31.725400>, <7.700300, 0.217722, 31.729100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.706720, 0.352299, 31.732700>, <7.791440, 0.332931, 31.931300>, <7.772240, 0.157185, 31.926700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.852740, 0.247550, 32.128400>, <7.791440, 0.332931, 31.931300>, <7.798140, 0.598565, 31.938400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.798140, 0.598565, 31.938400>, <7.835540, 0.778393, 32.130000>, <7.852740, 0.247550, 32.128400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.835540, 0.778393, 32.130000>, <7.775780, 0.812825, 31.944200>, <7.716290, 1.040270, 31.950500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.716290, 1.040270, 31.950500>, <7.702340, 1.210650, 32.117600>, <7.835540, 0.778393, 32.130000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.605540, 1.286210, 32.131100>, <7.619960, 1.242830, 31.956200>, <7.500100, 1.320840, 31.958700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.500100, 1.320840, 31.958700>, <7.482330, 1.322910, 32.134700>, <7.605540, 1.286210, 32.131100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.393120, 1.287240, 32.139900>, <7.380240, 1.339240, 31.959600>, <7.291520, 1.312710, 31.959200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.291520, 1.312710, 31.959200>, <7.314700, 1.216910, 32.136400>, <7.393120, 1.287240, 32.139900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.217330, 1.245160, 31.957700>, <7.187600, 0.988996, 31.950900>, <7.230350, 0.719945, 32.137300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.217330, 1.245160, 31.957700>, <7.230350, 0.719945, 32.137300>, <7.314700, 1.216910, 32.136400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.178690, 0.741060, 31.944300>, <7.092980, 0.407297, 31.935700>, <7.075480, 0.319815, 32.126900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.178690, 0.741060, 31.944300>, <7.075480, 0.319815, 32.126900>, <7.230350, 0.719945, 32.137300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.092980, 0.407297, 31.935700>, <6.989870, -0.041059, 31.924100>, <6.912680, -0.109410, 32.130400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.092980, 0.407297, 31.935700>, <6.912680, -0.109410, 32.130400>, <7.075480, 0.319815, 32.126900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.715870, -0.210837, 32.071600>, <6.442860, -0.238370, 32.191300>, <6.912680, -0.109410, 32.130400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.912680, -0.109410, 32.130400>, <6.989870, -0.041059, 31.924100>, <6.715870, -0.210837, 32.071600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.810090, -0.296895, 32.054900>, <6.576010, -0.297796, 32.150500>, <6.715870, -0.210837, 32.071600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.810090, -0.296895, 32.054900>, <7.001490, -0.318646, 31.916600>, <6.900150, -0.348307, 32.057000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.995910, -0.397674, 32.070700>, <6.643540, -0.481859, 32.164200>, <6.900150, -0.348307, 32.057000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.900150, -0.348307, 32.057000>, <7.118620, -0.337528, 31.915700>, <6.995910, -0.397674, 32.070700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.379080, -0.445754, 32.132400>, <7.256950, -0.348216, 31.915000>, <7.435930, -0.332463, 31.910000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.550280, -0.193904, 31.915700>, <7.663330, -0.213513, 32.136700>, <7.379080, -0.445754, 32.132400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.663330, -0.213513, 32.136700>, <7.676770, -0.074234, 31.920900>, <7.772240, 0.157185, 31.926700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.772240, 0.157185, 31.926700>, <7.852740, 0.247550, 32.128400>, <7.663330, -0.213513, 32.136700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.852740, 0.247550, 32.128400>, <7.835540, 0.778393, 32.130000>, <7.865810, 0.763272, 32.248700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.852740, 0.247550, 32.128400>, <7.865810, 0.763272, 32.248700>, <7.861920, 0.222957, 32.249500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.835540, 0.778393, 32.130000>, <7.702340, 1.210650, 32.117600>, <7.769770, 1.174630, 32.246600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.835540, 0.778393, 32.130000>, <7.769770, 1.174630, 32.246600>, <7.865810, 0.763272, 32.248700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.769770, 1.174630, 32.246600>, <7.702340, 1.210650, 32.117600>, <7.605540, 1.286210, 32.131100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.605540, 1.286210, 32.131100>, <7.549390, 1.300810, 32.250300>, <7.769770, 1.174630, 32.246600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.467050, 1.282190, 32.249700>, <7.482330, 1.322910, 32.134700>, <7.393120, 1.287240, 32.139900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.393120, 1.287240, 32.139900>, <7.387920, 1.195840, 32.251800>, <7.467050, 1.282190, 32.249700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.314700, 1.216910, 32.136400>, <7.230350, 0.719945, 32.137300>, <7.263140, 0.706075, 32.258400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.314700, 1.216910, 32.136400>, <7.263140, 0.706075, 32.258400>, <7.387920, 1.195840, 32.251800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.230350, 0.719945, 32.137300>, <7.075480, 0.319815, 32.126900>, <7.051820, 0.280500, 32.255400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.230350, 0.719945, 32.137300>, <7.051820, 0.280500, 32.255400>, <7.263140, 0.706075, 32.258400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.075480, 0.319815, 32.126900>, <6.912680, -0.109410, 32.130400>, <6.818150, -0.162400, 32.249300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.075480, 0.319815, 32.126900>, <6.818150, -0.162400, 32.249300>, <7.051820, 0.280500, 32.255400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.442860, -0.238370, 32.191300>, <6.291740, -0.204459, 32.278200>, <6.818150, -0.162400, 32.249300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.818150, -0.162400, 32.249300>, <6.912680, -0.109410, 32.130400>, <6.442860, -0.238370, 32.191300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.379080, -0.445754, 32.132400>, <7.648880, -0.267516, 32.249100>, <7.350330, -0.498313, 32.225200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.350330, -0.498313, 32.225200>, <6.643540, -0.481859, 32.164200>, <7.379080, -0.445754, 32.132400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.663330, -0.213513, 32.136700>, <7.852740, 0.247550, 32.128400>, <7.861920, 0.222957, 32.249500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.663330, -0.213513, 32.136700>, <7.861920, 0.222957, 32.249500>, <7.648880, -0.267516, 32.249100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.861920, 0.222957, 32.249500>, <7.865810, 0.763272, 32.248700>, <7.888620, 0.754713, 32.376700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.861920, 0.222957, 32.249500>, <7.888620, 0.754713, 32.376700>, <7.865630, 0.202307, 32.356600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.865810, 0.763272, 32.248700>, <7.769770, 1.174630, 32.246600>, <7.804560, 1.152830, 32.380800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.865810, 0.763272, 32.248700>, <7.804560, 1.152830, 32.380800>, <7.888620, 0.754713, 32.376700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.769770, 1.174630, 32.246600>, <7.549390, 1.300810, 32.250300>, <7.580470, 1.275310, 32.379800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.769770, 1.174630, 32.246600>, <7.580470, 1.275310, 32.379800>, <7.804560, 1.152830, 32.380800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.580470, 1.275310, 32.379800>, <7.549390, 1.300810, 32.250300>, <7.467050, 1.282190, 32.249700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.467050, 1.282190, 32.249700>, <7.428980, 1.181140, 32.379800>, <7.580470, 1.275310, 32.379800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387920, 1.195840, 32.251800>, <7.263140, 0.706075, 32.258400>, <7.285310, 0.698109, 32.384500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387920, 1.195840, 32.251800>, <7.285310, 0.698109, 32.384500>, <7.428980, 1.181140, 32.379800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.263140, 0.706075, 32.258400>, <7.051820, 0.280500, 32.255400>, <7.030420, 0.243551, 32.390300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.263140, 0.706075, 32.258400>, <7.030420, 0.243551, 32.390300>, <7.285310, 0.698109, 32.384500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.051820, 0.280500, 32.255400>, <6.818150, -0.162400, 32.249300>, <6.659030, -0.163003, 32.376900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.051820, 0.280500, 32.255400>, <6.659030, -0.163003, 32.376900>, <7.030420, 0.243551, 32.390300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.291740, -0.204459, 32.278200>, <6.187790, -0.263766, 32.374500>, <6.659030, -0.163003, 32.376900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.659030, -0.163003, 32.376900>, <6.818150, -0.162400, 32.249300>, <6.291740, -0.204459, 32.278200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.319560, -0.538367, 32.312800>, <6.645660, -0.609538, 32.221700>, <7.350330, -0.498313, 32.225200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.350330, -0.498313, 32.225200>, <7.651560, -0.288753, 32.344100>, <7.319560, -0.538367, 32.312800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.648880, -0.267516, 32.249100>, <7.861920, 0.222957, 32.249500>, <7.865630, 0.202307, 32.356600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.648880, -0.267516, 32.249100>, <7.865630, 0.202307, 32.356600>, <7.651560, -0.288753, 32.344100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.865630, 0.202307, 32.356600>, <7.888620, 0.754713, 32.376700>, <7.890550, 0.742356, 32.516500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.865630, 0.202307, 32.356600>, <7.890550, 0.742356, 32.516500>, <7.865070, 0.202719, 32.504000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.888620, 0.754713, 32.376700>, <7.804560, 1.152830, 32.380800>, <7.813400, 1.128380, 32.504000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.888620, 0.754713, 32.376700>, <7.813400, 1.128380, 32.504000>, <7.890550, 0.742356, 32.516500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.804560, 1.152830, 32.380800>, <7.580470, 1.275310, 32.379800>, <7.574170, 1.250660, 32.509000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.804560, 1.152830, 32.380800>, <7.574170, 1.250660, 32.509000>, <7.813400, 1.128380, 32.504000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.580470, 1.275310, 32.379800>, <7.428980, 1.181140, 32.379800>, <7.425540, 1.166200, 32.502600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.580470, 1.275310, 32.379800>, <7.425540, 1.166200, 32.502600>, <7.574170, 1.250660, 32.509000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.428980, 1.181140, 32.379800>, <7.285310, 0.698109, 32.384500>, <7.258430, 0.682039, 32.503900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.428980, 1.181140, 32.379800>, <7.258430, 0.682039, 32.503900>, <7.425540, 1.166200, 32.502600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.285310, 0.698109, 32.384500>, <7.030420, 0.243551, 32.390300>, <7.001630, 0.239044, 32.508500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.285310, 0.698109, 32.384500>, <7.001630, 0.239044, 32.508500>, <7.258430, 0.682039, 32.503900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.030420, 0.243551, 32.390300>, <6.659030, -0.163003, 32.376900>, <6.583190, -0.160847, 32.498300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.030420, 0.243551, 32.390300>, <6.583190, -0.160847, 32.498300>, <7.001630, 0.239044, 32.508500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.187790, -0.263766, 32.374500>, <6.095040, -0.359291, 32.465800>, <6.583190, -0.160847, 32.498300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.583190, -0.160847, 32.498300>, <6.659030, -0.163003, 32.376900>, <6.187790, -0.263766, 32.374500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.283940, -0.563802, 32.411500>, <6.621720, -0.663209, 32.259500>, <7.319560, -0.538367, 32.312800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.319560, -0.538367, 32.312800>, <7.650730, -0.295018, 32.476500>, <7.283940, -0.563802, 32.411500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.651560, -0.288753, 32.344100>, <7.865630, 0.202307, 32.356600>, <7.865070, 0.202719, 32.504000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.651560, -0.288753, 32.344100>, <7.865070, 0.202719, 32.504000>, <7.650730, -0.295018, 32.476500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.865070, 0.202719, 32.504000>, <7.890550, 0.742356, 32.516500>, <7.856380, 0.729807, 32.893900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.865070, 0.202719, 32.504000>, <7.856380, 0.729807, 32.893900>, <7.857960, 0.218669, 32.880300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.890550, 0.742356, 32.516500>, <7.813400, 1.128380, 32.504000>, <7.765760, 1.066170, 32.903200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.890550, 0.742356, 32.516500>, <7.765760, 1.066170, 32.903200>, <7.856380, 0.729807, 32.893900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.813400, 1.128380, 32.504000>, <7.574170, 1.250660, 32.509000>, <7.503680, 1.168350, 32.906800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.813400, 1.128380, 32.504000>, <7.503680, 1.168350, 32.906800>, <7.765760, 1.066170, 32.903200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.574170, 1.250660, 32.509000>, <7.425540, 1.166200, 32.502600>, <7.299350, 1.094810, 32.905600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.574170, 1.250660, 32.509000>, <7.299350, 1.094810, 32.905600>, <7.503680, 1.168350, 32.906800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.425540, 1.166200, 32.502600>, <7.258430, 0.682039, 32.503900>, <7.054550, 0.678883, 32.895300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.425540, 1.166200, 32.502600>, <7.054550, 0.678883, 32.895300>, <7.299350, 1.094810, 32.905600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.258430, 0.682039, 32.503900>, <7.001630, 0.239044, 32.508500>, <6.768030, 0.294846, 32.886000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.258430, 0.682039, 32.503900>, <6.768030, 0.294846, 32.886000>, <7.054550, 0.678883, 32.895300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.001630, 0.239044, 32.508500>, <6.583190, -0.160847, 32.498300>, <6.321590, -0.189921, 32.869100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.001630, 0.239044, 32.508500>, <6.321590, -0.189921, 32.869100>, <6.768030, 0.294846, 32.886000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.095040, -0.359291, 32.465800>, <6.086430, -0.499302, 32.523800>, <6.321590, -0.189921, 32.869100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.086430, -0.499302, 32.523800>, <6.415650, -0.461226, 32.861500>, <6.321590, -0.189921, 32.869100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.415650, -0.461226, 32.861500>, <6.086430, -0.499302, 32.523800>, <6.164420, -0.625082, 32.536000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.164420, -0.625082, 32.536000>, <6.640030, -0.591853, 32.862700>, <6.415650, -0.461226, 32.861500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277910, -0.716482, 32.496200>, <6.435070, -0.750460, 32.412500>, <7.205260, -0.527780, 32.862500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277910, -0.716482, 32.496200>, <7.205260, -0.527780, 32.862500>, <6.640030, -0.591853, 32.862700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205260, -0.527780, 32.862500>, <6.435070, -0.750460, 32.412500>, <6.681660, -0.673516, 32.357600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.283940, -0.563802, 32.411500>, <7.661300, -0.240073, 32.868700>, <7.205260, -0.527780, 32.862500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.650730, -0.295018, 32.476500>, <7.865070, 0.202719, 32.504000>, <7.857960, 0.218669, 32.880300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.650730, -0.295018, 32.476500>, <7.857960, 0.218669, 32.880300>, <7.661300, -0.240073, 32.868700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.857960, 0.218669, 32.880300>, <7.856380, 0.729807, 32.893900>, <7.809490, 0.705618, 33.322200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.857960, 0.218669, 32.880300>, <7.809490, 0.705618, 33.322200>, <7.834770, 0.321530, 33.311900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.856380, 0.729807, 32.893900>, <7.765760, 1.066170, 32.903200>, <7.652840, 0.964451, 33.329700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.856380, 0.729807, 32.893900>, <7.652840, 0.964451, 33.329700>, <7.809490, 0.705618, 33.322200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.765760, 1.066170, 32.903200>, <7.503680, 1.168350, 32.906800>, <7.421440, 1.061470, 33.333000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.765760, 1.066170, 32.903200>, <7.421440, 1.061470, 33.333000>, <7.652840, 0.964451, 33.329700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.503680, 1.168350, 32.906800>, <7.299350, 1.094810, 32.905600>, <7.143120, 0.996336, 33.332300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.503680, 1.168350, 32.906800>, <7.143120, 0.996336, 33.332300>, <7.421440, 1.061470, 33.333000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.299350, 1.094810, 32.905600>, <7.054550, 0.678883, 32.895300>, <6.966090, 0.685071, 33.324500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.299350, 1.094810, 32.905600>, <6.966090, 0.685071, 33.324500>, <7.143120, 0.996336, 33.332300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.054550, 0.678883, 32.895300>, <6.768030, 0.294846, 32.886000>, <6.758980, 0.339170, 33.316000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.054550, 0.678883, 32.895300>, <6.758980, 0.339170, 33.316000>, <6.966090, 0.685071, 33.324500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.768030, 0.294846, 32.886000>, <6.321590, -0.189921, 32.869100>, <6.617830, -0.024826, 33.304400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.768030, 0.294846, 32.886000>, <6.617830, -0.024826, 33.304400>, <6.758980, 0.339170, 33.316000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.321590, -0.189921, 32.869100>, <6.415650, -0.461226, 32.861500>, <6.778960, -0.277540, 33.297100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.321590, -0.189921, 32.869100>, <6.778960, -0.277540, 33.297100>, <6.617830, -0.024826, 33.304400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.415650, -0.461226, 32.861500>, <6.640030, -0.591853, 32.862700>, <7.060330, -0.382422, 33.293300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.415650, -0.461226, 32.861500>, <7.060330, -0.382422, 33.293300>, <6.778960, -0.277540, 33.297100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.640030, -0.591853, 32.862700>, <7.205260, -0.527780, 32.862500>, <7.383160, -0.332782, 33.291100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.640030, -0.591853, 32.862700>, <7.383160, -0.332782, 33.291100>, <7.060330, -0.382422, 33.293300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205260, -0.527780, 32.862500>, <7.661300, -0.240073, 32.868700>, <7.701450, -0.090517, 33.301300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205260, -0.527780, 32.862500>, <7.701450, -0.090517, 33.301300>, <7.383160, -0.332782, 33.291100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.661300, -0.240073, 32.868700>, <7.857960, 0.218669, 32.880300>, <7.834770, 0.321530, 33.311900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.661300, -0.240073, 32.868700>, <7.834770, 0.321530, 33.311900>, <7.701450, -0.090517, 33.301300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.834770, 0.321530, 33.311900>, <7.809490, 0.705618, 33.322200>, <7.757390, 0.719250, 33.729400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.834770, 0.321530, 33.311900>, <7.757390, 0.719250, 33.729400>, <7.849710, 0.432076, 33.728400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.809490, 0.705618, 33.322200>, <7.652840, 0.964451, 33.329700>, <7.553200, 0.922554, 33.729100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.809490, 0.705618, 33.322200>, <7.553200, 0.922554, 33.729100>, <7.757390, 0.719250, 33.729400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.652840, 0.964451, 33.329700>, <7.421440, 1.061470, 33.333000>, <7.263940, 0.999399, 33.728600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.652840, 0.964451, 33.329700>, <7.263940, 0.999399, 33.728600>, <7.553200, 0.922554, 33.729100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.421440, 1.061470, 33.333000>, <7.143120, 0.996336, 33.332300>, <6.973040, 0.920985, 33.727300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.421440, 1.061470, 33.333000>, <6.973040, 0.920985, 33.727300>, <7.263940, 0.999399, 33.728600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143120, 0.996336, 33.332300>, <6.966090, 0.685071, 33.324500>, <6.764540, 0.716569, 33.725700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143120, 0.996336, 33.332300>, <6.764540, 0.716569, 33.725700>, <6.973040, 0.920985, 33.727300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.966090, 0.685071, 33.324500>, <6.758980, 0.339170, 33.316000>, <6.699720, 0.428963, 33.724700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.966090, 0.685071, 33.324500>, <6.699720, 0.428963, 33.724700>, <6.764540, 0.716569, 33.725700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.758980, 0.339170, 33.316000>, <6.617830, -0.024826, 33.304400>, <6.758450, 0.143373, 33.723700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.758980, 0.339170, 33.316000>, <6.758450, 0.143373, 33.723700>, <6.699720, 0.428963, 33.724700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.617830, -0.024826, 33.304400>, <6.778960, -0.277540, 33.297100>, <6.962640, -0.059930, 33.722800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.617830, -0.024826, 33.304400>, <6.962640, -0.059930, 33.722800>, <6.758450, 0.143373, 33.723700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.778960, -0.277540, 33.297100>, <7.060330, -0.382422, 33.293300>, <7.251900, -0.136769, 33.723400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.778960, -0.277540, 33.297100>, <7.251900, -0.136769, 33.723400>, <6.962640, -0.059930, 33.722800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.060330, -0.382422, 33.293300>, <7.383160, -0.332782, 33.291100>, <7.542810, -0.058357, 33.724500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.060330, -0.382422, 33.293300>, <7.542810, -0.058357, 33.724500>, <7.251900, -0.136769, 33.723400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.383160, -0.332782, 33.291100>, <7.701450, -0.090517, 33.301300>, <7.751310, 0.146061, 33.726600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.383160, -0.332782, 33.291100>, <7.751310, 0.146061, 33.726600>, <7.542810, -0.058357, 33.724500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.701450, -0.090517, 33.301300>, <7.834770, 0.321530, 33.311900>, <7.849710, 0.432076, 33.728400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.701450, -0.090517, 33.301300>, <7.849710, 0.432076, 33.728400>, <7.751310, 0.146061, 33.726600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.230440, 1.373680, 31.485000>, <7.126460, 1.401590, 31.530800>, <7.196170, 1.388570, 31.606100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.414920, 1.299870, 31.563600>, <7.296230, 1.317610, 31.428100>, <7.230440, 1.373680, 31.485000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.301700, 1.235750, 31.366100>, <7.296230, 1.317610, 31.428100>, <7.414920, 1.299870, 31.563600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.301700, 1.235750, 31.366100>, <7.414920, 1.299870, 31.563600>, <7.484760, 1.188810, 31.500000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.002980, 1.081070, 31.354000>, <7.077080, 1.064720, 31.313000>, <7.195090, 0.997560, 31.281900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.195090, 0.997560, 31.281900>, <7.076290, 0.971064, 31.316200>, <7.002980, 1.081070, 31.354000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.484760, 1.188810, 31.500000>, <7.519400, 1.087910, 31.456100>, <7.262950, 1.148730, 31.316900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.513980, 0.998538, 31.420500>, <7.565250, 0.890038, 31.408400>, <7.077080, 1.064720, 31.313000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.405160, 0.891644, 31.224500>, <7.316140, 0.963003, 31.255200>, <7.565250, 0.890038, 31.408400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.442800, 0.794255, 31.203400>, <7.405160, 0.891644, 31.224500>, <7.565250, 0.890038, 31.408400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.584650, 0.761784, 31.376000>, <7.415350, 0.699053, 31.198800>, <7.442800, 0.794255, 31.203400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.316140, 0.963003, 31.255200>, <7.195090, 0.997560, 31.281900>, <7.565250, 0.890038, 31.408400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.077080, 1.064720, 31.313000>, <7.187100, 1.083210, 31.290500>, <7.513980, 0.998538, 31.420500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.565250, 0.890038, 31.408400>, <7.195090, 0.997560, 31.281900>, <7.077080, 1.064720, 31.313000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.581540, 0.665429, 31.377300>, <7.332930, 0.625190, 31.224900>, <7.415350, 0.699053, 31.198800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.563810, 0.572009, 31.392600>, <7.376190, 0.541693, 31.216000>, <7.332930, 0.625190, 31.224900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.442800, 0.794255, 31.203400>, <7.565250, 0.890038, 31.408400>, <7.584650, 0.761784, 31.376000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.602530, 0.407447, 31.351300>, <7.468690, 0.465303, 31.191600>, <7.376190, 0.541693, 31.216000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.602530, 0.407447, 31.351300>, <7.503670, 0.358584, 31.183300>, <7.468690, 0.465303, 31.191600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.376190, 0.541693, 31.216000>, <7.563810, 0.572009, 31.392600>, <7.570400, 0.478752, 31.357500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.467980, 0.252367, 31.194500>, <7.503670, 0.358584, 31.183300>, <7.594830, 0.194042, 31.353000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.374960, 0.177292, 31.221000>, <7.467980, 0.252367, 31.194500>, <7.594830, 0.194042, 31.353000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519220, 0.061950, 31.398900>, <7.244570, 0.149387, 31.257200>, <7.374960, 0.177292, 31.221000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519220, 0.061950, 31.398900>, <7.296200, -0.038617, 31.260200>, <7.209320, 0.039283, 31.254700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.297940, -0.249982, 31.345000>, <7.329890, -0.145334, 31.293200>, <7.436230, -0.162736, 31.432600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.297940, -0.249982, 31.345000>, <7.436230, -0.162736, 31.432600>, <7.339250, -0.252566, 31.465900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.101240, -0.338709, 31.446400>, <7.212550, -0.322441, 31.399700>, <7.194570, -0.322464, 31.506700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.097710, -0.333099, 31.536300>, <6.970980, -0.314819, 31.469000>, <7.101240, -0.338709, 31.446400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.101240, -0.338709, 31.446400>, <7.194570, -0.322464, 31.506700>, <7.097710, -0.333099, 31.536300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519220, 0.061950, 31.398900>, <7.209320, 0.039283, 31.254700>, <7.244570, 0.149387, 31.257200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.374960, 0.177292, 31.221000>, <7.594830, 0.194042, 31.353000>, <7.519220, 0.061950, 31.398900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.329890, -0.145334, 31.293200>, <7.296200, -0.038617, 31.260200>, <7.436230, -0.162736, 31.432600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.899850, -0.245890, 31.536700>, <6.871720, -0.149587, 31.537100>, <6.884320, -0.236925, 31.463400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.850400, -0.130200, 31.430400>, <6.884320, -0.236925, 31.463400>, <6.871720, -0.149587, 31.537100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.881890, -0.025539, 31.378700>, <6.850400, -0.130200, 31.430400>, <6.871720, -0.149587, 31.537100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.881890, -0.025539, 31.378700>, <6.871720, -0.149587, 31.537100>, <6.900650, -0.034189, 31.501800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.209320, 0.039283, 31.254700>, <6.953560, 0.066749, 31.458400>, <7.008610, 0.158372, 31.397100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.114480, 0.179148, 31.292600>, <7.244570, 0.149387, 31.257200>, <7.008610, 0.158372, 31.397100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994020, 0.212187, 31.435500>, <7.022200, 0.255539, 31.317000>, <7.114480, 0.179148, 31.292600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.114480, 0.179148, 31.292600>, <7.008610, 0.158372, 31.397100>, <6.994020, 0.212187, 31.435500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996910, 0.330444, 31.459600>, <7.020880, 0.438807, 31.456400>, <6.987340, 0.362251, 31.325200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.020880, 0.438807, 31.456400>, <7.040840, 0.522212, 31.433900>, <7.022910, 0.468468, 31.314100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.115700, 0.543548, 31.287600>, <7.022910, 0.468468, 31.314100>, <7.040840, 0.522212, 31.433900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068390, 0.621843, 31.382800>, <7.245990, 0.571458, 31.251400>, <7.115700, 0.543548, 31.287600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068390, 0.621843, 31.382800>, <7.093190, 0.641470, 31.272300>, <7.245990, 0.571458, 31.251400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.115700, 0.543548, 31.287600>, <7.040840, 0.522212, 31.433900>, <7.068390, 0.621843, 31.382800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.021250, 0.689850, 31.457100>, <7.000130, 0.794590, 31.478000>, <7.004370, 0.712844, 31.303100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.967000, 0.810232, 31.324100>, <7.004370, 0.712844, 31.303100>, <7.000130, 0.794590, 31.478000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994560, 0.905443, 31.328700>, <6.967000, 0.810232, 31.324100>, <7.000130, 0.794590, 31.478000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.000770, 0.905924, 31.473200>, <7.076290, 0.971064, 31.316200>, <6.994560, 0.905443, 31.328700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994560, 0.905443, 31.328700>, <7.000130, 0.794590, 31.478000>, <7.000770, 0.905924, 31.473200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.026530, 1.014050, 31.437300>, <6.931990, 1.133200, 31.407100>, <7.002980, 1.081070, 31.354000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996190, 1.113340, 31.534400>, <6.913910, 1.228740, 31.464900>, <6.931990, 1.133200, 31.407100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.944600, 1.311000, 31.513600>, <6.913910, 1.228740, 31.464900>, <6.998660, 1.297170, 31.607400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.196170, 1.388570, 31.606100>, <7.028660, 1.377210, 31.542700>, <7.102220, 1.363540, 31.618000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998660, 1.297170, 31.607400>, <7.180710, 1.342840, 31.760900>, <7.102220, 1.363540, 31.618000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.900650, -0.034189, 31.501800>, <6.967090, 0.046931, 31.324000>, <6.881890, -0.025539, 31.378700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.332930, 0.625190, 31.224900>, <7.376190, 0.541693, 31.216000>, <7.245990, 0.571458, 31.251400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.093190, 0.641470, 31.272300>, <7.332930, 0.625190, 31.224900>, <7.245990, 0.571458, 31.251400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.008610, 0.158372, 31.397100>, <7.244570, 0.149387, 31.257200>, <7.209320, 0.039283, 31.254700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.026530, 1.014050, 31.437300>, <7.002980, 1.081070, 31.354000>, <7.076290, 0.971064, 31.316200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.547980, 0.433247, 34.130200>, <7.507820, 0.572212, 34.130800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.507820, 0.572212, 34.130800>, <7.398350, 0.672916, 34.130900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.398350, 0.672916, 34.130900>, <7.248930, 0.708380, 34.130700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.248930, 0.708380, 34.130700>, <7.099570, 0.669089, 34.130100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.099570, 0.669089, 34.130100>, <6.990320, 0.565578, 34.129300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <6.990320, 0.565578, 34.129300>, <6.950430, 0.425590, 34.128500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <6.950430, 0.425590, 34.128500>, <6.990600, 0.286617, 34.127900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <6.990600, 0.286617, 34.127900>, <7.100060, 0.185913, 34.127800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.100060, 0.185913, 34.127800>, <7.249490, 0.150455, 34.128000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.249490, 0.150455, 34.128000>, <7.398840, 0.189743, 34.128600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.398840, 0.189743, 34.128600>, <7.508100, 0.293250, 34.129400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249120, 0.429115, 34.191700>, <7.508100, 0.293250, 34.129400>, <7.547980, 0.433247, 34.130200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.547980, 0.433247, 34.130200>, <7.766940, 0.436880, 33.960400>, <7.697370, 0.677576, 33.961400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.547980, 0.433247, 34.130200>, <7.697370, 0.677576, 33.961400>, <7.507820, 0.572212, 34.130800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.507820, 0.572212, 34.130800>, <7.697370, 0.677576, 33.961400>, <7.507780, 0.852005, 33.961700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.507820, 0.572212, 34.130800>, <7.507780, 0.852005, 33.961700>, <7.398350, 0.672916, 34.130900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.398350, 0.672916, 34.130900>, <7.507780, 0.852005, 33.961700>, <7.248960, 0.913423, 33.961200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.398350, 0.672916, 34.130900>, <7.248960, 0.913423, 33.961200>, <7.248930, 0.708380, 34.130700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.248930, 0.708380, 34.130700>, <7.248960, 0.913423, 33.961200>, <7.004510, 0.844699, 33.960200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.248930, 0.708380, 34.130700>, <7.004510, 0.844699, 33.960200>, <7.099570, 0.669089, 34.130100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.099570, 0.669089, 34.130100>, <7.004510, 0.844699, 33.960200>, <6.824760, 0.664966, 33.958900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.099570, 0.669089, 34.130100>, <6.824760, 0.664966, 33.958900>, <6.990320, 0.565578, 34.129300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.990320, 0.565578, 34.129300>, <6.824760, 0.664966, 33.958900>, <6.760420, 0.422266, 33.957500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.990320, 0.565578, 34.129300>, <6.760420, 0.422266, 33.957500>, <6.950430, 0.425590, 34.128500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.950430, 0.425590, 34.128500>, <6.760420, 0.422266, 33.957500>, <6.848980, 0.180662, 33.956600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.950430, 0.425590, 34.128500>, <6.848980, 0.180662, 33.956600>, <6.990600, 0.286617, 34.127900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.990600, 0.286617, 34.127900>, <6.848980, 0.180662, 33.956600>, <6.991120, 0.008485, 33.956200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.990600, 0.286617, 34.127900>, <6.991120, 0.008485, 33.956200>, <7.100060, 0.185913, 34.127800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.100060, 0.185913, 34.127800>, <6.991120, 0.008485, 33.956200>, <7.249930, -0.052927, 33.956600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.100060, 0.185913, 34.127800>, <7.249930, -0.052927, 33.956600>, <7.249490, 0.150455, 34.128000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249490, 0.150455, 34.128000>, <7.249930, -0.052927, 33.956600>, <7.508610, 0.015121, 33.957700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249490, 0.150455, 34.128000>, <7.508610, 0.015121, 33.957700>, <7.398840, 0.189743, 34.128600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.398840, 0.189743, 34.128600>, <7.508610, 0.015121, 33.957700>, <7.697870, 0.194404, 33.959100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.398840, 0.189743, 34.128600>, <7.697870, 0.194404, 33.959100>, <7.508100, 0.293250, 34.129400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.508100, 0.293250, 34.129400>, <7.697870, 0.194404, 33.959100>, <7.766940, 0.436880, 33.960400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.508100, 0.293250, 34.129400>, <7.766940, 0.436880, 33.960400>, <7.547980, 0.433247, 34.130200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.766940, 0.436880, 33.960400>, <7.849680, 0.432058, 33.727800>, <7.757400, 0.719258, 33.728900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.766940, 0.436880, 33.960400>, <7.757400, 0.719258, 33.728900>, <7.697370, 0.677576, 33.961400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.697370, 0.677576, 33.961400>, <7.757400, 0.719258, 33.728900>, <7.548070, 0.918387, 33.729300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.697370, 0.677576, 33.961400>, <7.548070, 0.918387, 33.729300>, <7.507780, 0.852005, 33.961700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.507780, 0.852005, 33.961700>, <7.548070, 0.918387, 33.729300>, <7.263930, 0.999436, 33.728900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.507780, 0.852005, 33.961700>, <7.263930, 0.999436, 33.728900>, <7.248960, 0.913423, 33.961200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.248960, 0.913423, 33.961200>, <7.263930, 0.999436, 33.728900>, <6.972930, 0.920910, 33.727700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.248960, 0.913423, 33.961200>, <6.972930, 0.920910, 33.727700>, <7.004510, 0.844699, 33.960200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.004510, 0.844699, 33.960200>, <6.972930, 0.920910, 33.727700>, <6.764250, 0.716952, 33.726100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.004510, 0.844699, 33.960200>, <6.764250, 0.716952, 33.726100>, <6.824760, 0.664966, 33.958900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.824760, 0.664966, 33.958900>, <6.764250, 0.716952, 33.726100>, <6.699710, 0.428965, 33.724600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.824760, 0.664966, 33.958900>, <6.699710, 0.428965, 33.724600>, <6.760420, 0.422266, 33.957500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.760420, 0.422266, 33.957500>, <6.699710, 0.428965, 33.724600>, <6.758440, 0.143382, 33.723400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.760420, 0.422266, 33.957500>, <6.758440, 0.143382, 33.723400>, <6.848980, 0.180662, 33.956600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.848980, 0.180662, 33.956600>, <6.758440, 0.143382, 33.723400>, <6.962640, -0.059929, 33.723000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.848980, 0.180662, 33.956600>, <6.962640, -0.059929, 33.723000>, <6.991120, 0.008485, 33.956200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.991120, 0.008485, 33.956200>, <6.962640, -0.059929, 33.723000>, <7.251700, -0.136764, 33.723400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.991120, 0.008485, 33.956200>, <7.251700, -0.136764, 33.723400>, <7.249930, -0.052927, 33.956600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249930, -0.052927, 33.956600>, <7.251700, -0.136764, 33.723400>, <7.542780, -0.058385, 33.724600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249930, -0.052927, 33.956600>, <7.542780, -0.058385, 33.724600>, <7.508610, 0.015121, 33.957700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.508610, 0.015121, 33.957700>, <7.542780, -0.058385, 33.724600>, <7.751550, 0.146096, 33.726200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.508610, 0.015121, 33.957700>, <7.751550, 0.146096, 33.726200>, <7.697870, 0.194404, 33.959100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.697870, 0.194404, 33.959100>, <7.751550, 0.146096, 33.726200>, <7.849680, 0.432058, 33.727800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.697870, 0.194404, 33.959100>, <7.849680, 0.432058, 33.727800>, <7.766940, 0.436880, 33.960400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.706720, 0.352299, 31.732700>, <7.700300, 0.217722, 31.729100>, <7.602530, 0.407447, 31.351300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.503670, 0.358584, 31.183300>, <7.602530, 0.407447, 31.351300>, <7.613600, 0.314318, 31.341800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.700300, 0.217722, 31.729100>, <7.613600, 0.314318, 31.341800>, <7.602530, 0.407447, 31.351300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.503670, 0.358584, 31.183300>, <7.613600, 0.314318, 31.341800>, <7.594830, 0.194042, 31.353000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.376190, 0.541693, 31.216000>, <7.570400, 0.478752, 31.357500>, <7.602530, 0.407447, 31.351300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.570400, 0.478752, 31.357500>, <7.563810, 0.572009, 31.392600>, <7.711400, 0.458789, 31.735500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519220, 0.061950, 31.398900>, <7.645230, 0.071263, 31.725400>, <7.610160, -0.028230, 31.722900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.436230, -0.162736, 31.432600>, <7.296200, -0.038617, 31.260200>, <7.497060, -0.054357, 31.410900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.497060, -0.054357, 31.410900>, <7.296200, -0.038617, 31.260200>, <7.519220, 0.061950, 31.398900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.552250, -0.120623, 31.720600>, <7.497060, -0.054357, 31.410900>, <7.519220, 0.061950, 31.398900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.339250, -0.252566, 31.465900>, <7.436230, -0.162736, 31.432600>, <7.483960, -0.194224, 31.718900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.697740, 0.611212, 31.739700>, <7.581540, 0.665429, 31.377300>, <7.584650, 0.761784, 31.376000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.332930, 0.625190, 31.224900>, <7.581540, 0.665429, 31.377300>, <7.563810, 0.572009, 31.392600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.415350, 0.699053, 31.198800>, <7.584650, 0.761784, 31.376000>, <7.581540, 0.665429, 31.377300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.584650, 0.761784, 31.376000>, <7.565250, 0.890038, 31.408400>, <7.670240, 0.811579, 31.745100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.613600, 0.314318, 31.341800>, <7.700300, 0.217722, 31.729100>, <7.645230, 0.071263, 31.725400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.772240, 0.157185, 31.926700>, <7.700300, 0.217722, 31.729100>, <7.706720, 0.352299, 31.732700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.581540, 0.665429, 31.377300>, <7.697740, 0.611212, 31.739700>, <7.711400, 0.458789, 31.735500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.798140, 0.598565, 31.938400>, <7.697740, 0.611212, 31.739700>, <7.684470, 0.705365, 31.742200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.550280, -0.193904, 31.915700>, <7.552250, -0.120623, 31.720600>, <7.610160, -0.028230, 31.722900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.552250, -0.120623, 31.720600>, <7.483960, -0.194224, 31.718900>, <7.497060, -0.054357, 31.410900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.484760, 1.188810, 31.500000>, <7.414920, 1.299870, 31.563600>, <7.498990, 1.277150, 31.758100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.262950, 1.148730, 31.316900>, <7.301700, 1.235750, 31.366100>, <7.484760, 1.188810, 31.500000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.572580, 1.132590, 31.754000>, <7.620690, 1.011140, 31.750600>, <7.519400, 1.087910, 31.456100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519400, 1.087910, 31.456100>, <7.513980, 0.998538, 31.420500>, <7.262950, 1.148730, 31.316900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519400, 1.087910, 31.456100>, <7.484760, 1.188810, 31.500000>, <7.572580, 1.132590, 31.754000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.572580, 1.132590, 31.754000>, <7.498990, 1.277150, 31.758100>, <7.619960, 1.242830, 31.956200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.620690, 1.011140, 31.750600>, <7.651230, 0.902266, 31.747600>, <7.513980, 0.998538, 31.420500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.187100, 1.083210, 31.290500>, <7.262950, 1.148730, 31.316900>, <7.513980, 0.998538, 31.420500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.716290, 1.040270, 31.950500>, <7.775780, 0.812825, 31.944200>, <7.620690, 1.011140, 31.750600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.513980, 0.998538, 31.420500>, <7.519400, 1.087910, 31.456100>, <7.620690, 1.011140, 31.750600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.775780, 0.812825, 31.944200>, <7.651230, 0.902266, 31.747600>, <7.620690, 1.011140, 31.750600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.651230, 0.902266, 31.747600>, <7.670240, 0.811579, 31.745100>, <7.513980, 0.998538, 31.420500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.584650, 0.761784, 31.376000>, <7.684470, 0.705365, 31.742200>, <7.697740, 0.611212, 31.739700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.684470, 0.705365, 31.742200>, <7.670240, 0.811579, 31.745100>, <7.775780, 0.812825, 31.944200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.602530, 0.407447, 31.351300>, <7.570400, 0.478752, 31.357500>, <7.706720, 0.352299, 31.732700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.706720, 0.352299, 31.732700>, <7.711400, 0.458789, 31.735500>, <7.791440, 0.332931, 31.931300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.519220, 0.061950, 31.398900>, <7.610160, -0.028230, 31.722900>, <7.552250, -0.120623, 31.720600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.610160, -0.028230, 31.722900>, <7.645230, 0.071263, 31.725400>, <7.676770, -0.074234, 31.920900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.028660, 1.377210, 31.542700>, <6.944600, 1.311000, 31.513600>, <6.998660, 1.297170, 31.607400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.180710, 1.342840, 31.760900>, <7.089070, 1.276880, 31.759500>, <7.217330, 1.245160, 31.957700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.263240, 1.367630, 31.761300>, <7.291520, 1.312710, 31.959200>, <7.380240, 1.339240, 31.959600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.291520, 1.312710, 31.959200>, <7.217330, 1.245160, 31.957700>, <7.314700, 1.216910, 32.136400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.380240, 1.339240, 31.959600>, <7.393120, 1.287240, 32.139900>, <7.482330, 1.322910, 32.134700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.393120, 1.287240, 32.139900>, <7.314700, 1.216910, 32.136400>, <7.387920, 1.195840, 32.251800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.482330, 1.322910, 32.134700>, <7.467050, 1.282190, 32.249700>, <7.549390, 1.300810, 32.250300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.467050, 1.282190, 32.249700>, <7.387920, 1.195840, 32.251800>, <7.428980, 1.181140, 32.379800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.414920, 1.299870, 31.563600>, <7.230440, 1.373680, 31.485000>, <7.305140, 1.368190, 31.620900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.399400, 1.342750, 31.760200>, <7.263240, 1.367630, 31.761300>, <7.380240, 1.339240, 31.959600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.498990, 1.277150, 31.758100>, <7.500100, 1.320840, 31.958700>, <7.619960, 1.242830, 31.956200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.500100, 1.320840, 31.958700>, <7.380240, 1.339240, 31.959600>, <7.482330, 1.322910, 32.134700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.619960, 1.242830, 31.956200>, <7.605540, 1.286210, 32.131100>, <7.702340, 1.210650, 32.117600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.605540, 1.286210, 32.131100>, <7.482330, 1.322910, 32.134700>, <7.549390, 1.300810, 32.250300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.196170, 1.388570, 31.606100>, <7.263240, 1.367630, 31.761300>, <7.305140, 1.368190, 31.620900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.305140, 1.368190, 31.620900>, <7.399400, 1.342750, 31.760200>, <7.498990, 1.277150, 31.758100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.196170, 1.388570, 31.606100>, <7.126460, 1.401590, 31.530800>, <7.028660, 1.377210, 31.542700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.305140, 1.368190, 31.620900>, <7.230440, 1.373680, 31.485000>, <7.196170, 1.388570, 31.606100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.180710, 1.342840, 31.760900>, <7.263240, 1.367630, 31.761300>, <7.102220, 1.363540, 31.618000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998660, 1.297170, 31.607400>, <7.102220, 1.363540, 31.618000>, <7.028660, 1.377210, 31.542700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.339250, -0.252566, 31.465900>, <7.415180, -0.297707, 31.711500>, <7.294230, -0.317083, 31.716200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.435930, -0.332463, 31.910000>, <7.256950, -0.348216, 31.915000>, <7.415180, -0.297707, 31.711500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.090550, -0.337036, 31.716400>, <6.985750, -0.327161, 31.534700>, <7.097710, -0.333099, 31.536300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.899850, -0.245890, 31.536700>, <6.970980, -0.314819, 31.469000>, <6.985750, -0.327161, 31.534700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.899850, -0.245890, 31.536700>, <7.015000, -0.325267, 31.716900>, <6.972080, -0.262937, 31.718800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.001490, -0.318646, 31.916600>, <7.015000, -0.325267, 31.716900>, <7.090550, -0.337036, 31.716400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.972080, -0.262937, 31.718800>, <7.001490, -0.318646, 31.916600>, <6.942130, -0.198271, 31.921400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.900150, -0.348307, 32.057000>, <6.621850, -0.355454, 32.152000>, <6.810090, -0.296895, 32.054900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.715870, -0.210837, 32.071600>, <6.942130, -0.198271, 31.921400>, <6.810090, -0.296895, 32.054900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.985750, -0.327161, 31.534700>, <6.970980, -0.314819, 31.469000>, <7.097710, -0.333099, 31.536300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.097710, -0.333099, 31.536300>, <7.194570, -0.322464, 31.506700>, <7.166260, -0.340892, 31.716000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.985750, -0.327161, 31.534700>, <7.090550, -0.337036, 31.716400>, <7.015000, -0.325267, 31.716900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.090550, -0.337036, 31.716400>, <7.166260, -0.340892, 31.716000>, <7.118620, -0.337528, 31.915700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.015000, -0.325267, 31.716900>, <6.899850, -0.245890, 31.536700>, <6.985750, -0.327161, 31.534700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.884320, -0.236925, 31.463400>, <6.970980, -0.314819, 31.469000>, <6.899850, -0.245890, 31.536700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.001490, -0.318646, 31.916600>, <6.972080, -0.262937, 31.718800>, <7.015000, -0.325267, 31.716900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.871720, -0.149587, 31.537100>, <6.972080, -0.262937, 31.718800>, <6.947440, -0.180761, 31.721000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.900650, -0.034189, 31.501800>, <6.871720, -0.149587, 31.537100>, <6.947440, -0.180761, 31.721000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.953560, 0.066749, 31.458400>, <6.967090, 0.046931, 31.324000>, <6.900650, -0.034189, 31.501800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.953560, 0.066749, 31.458400>, <6.953630, -0.040559, 31.724800>, <6.993430, 0.103619, 31.728500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.953630, -0.040559, 31.724800>, <6.947440, -0.180761, 31.721000>, <6.942130, -0.198271, 31.921400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.953630, -0.040559, 31.724800>, <6.953560, 0.066749, 31.458400>, <6.900650, -0.034189, 31.501800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.209320, 0.039283, 31.254700>, <6.967090, 0.046931, 31.324000>, <6.953560, 0.066749, 31.458400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996910, 0.330444, 31.459600>, <6.994020, 0.212187, 31.435500>, <6.993430, 0.103619, 31.728500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.987340, 0.362251, 31.325200>, <7.022200, 0.255539, 31.317000>, <6.996910, 0.330444, 31.459600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.020510, 0.269863, 31.732800>, <7.068340, 0.445756, 31.737400>, <7.020880, 0.438807, 31.456400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.022910, 0.468468, 31.314100>, <6.987340, 0.362251, 31.325200>, <7.020880, 0.438807, 31.456400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.020880, 0.438807, 31.456400>, <6.996910, 0.330444, 31.459600>, <7.020510, 0.269863, 31.732800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.020510, 0.269863, 31.732800>, <6.993430, 0.103619, 31.728500>, <6.989870, -0.041059, 31.924100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068390, 0.621843, 31.382800>, <7.040840, 0.522212, 31.433900>, <7.068340, 0.445756, 31.737400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068390, 0.621843, 31.382800>, <7.021250, 0.689850, 31.457100>, <7.093190, 0.641470, 31.272300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.108020, 0.577637, 31.740800>, <7.124120, 0.763191, 31.745700>, <7.021250, 0.689850, 31.457100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.004370, 0.712844, 31.303100>, <7.093190, 0.641470, 31.272300>, <7.021250, 0.689850, 31.457100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.108120, 0.995543, 31.751900>, <6.996190, 1.113340, 31.534400>, <7.026530, 1.014050, 31.437300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996190, 1.113340, 31.534400>, <6.994920, 1.210420, 31.580700>, <6.913910, 1.228740, 31.464900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.931990, 1.133200, 31.407100>, <7.026530, 1.014050, 31.437300>, <6.996190, 1.113340, 31.534400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.111780, 0.891358, 31.749100>, <7.026530, 1.014050, 31.437300>, <7.000770, 0.905924, 31.473200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.021250, 0.689850, 31.457100>, <7.068390, 0.621843, 31.382800>, <7.108020, 0.577637, 31.740800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.108020, 0.577637, 31.740800>, <7.068340, 0.445756, 31.737400>, <7.092980, 0.407297, 31.935700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996190, 1.113340, 31.534400>, <7.108120, 0.995543, 31.751900>, <7.098210, 1.071160, 31.754000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.187600, 0.988996, 31.950900>, <7.108120, 0.995543, 31.751900>, <7.111780, 0.891358, 31.749100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996910, 0.330444, 31.459600>, <7.022200, 0.255539, 31.317000>, <6.994020, 0.212187, 31.435500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994020, 0.212187, 31.435500>, <7.008610, 0.158372, 31.397100>, <6.993430, 0.103619, 31.728500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.076290, 0.971064, 31.316200>, <7.000770, 0.905924, 31.473200>, <7.026530, 1.014050, 31.437300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.000770, 0.905924, 31.473200>, <7.000130, 0.794590, 31.478000>, <7.124120, 0.763191, 31.745700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.026530, 1.014050, 31.437300>, <7.111780, 0.891358, 31.749100>, <7.108120, 0.995543, 31.751900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.111780, 0.891358, 31.749100>, <7.124120, 0.763191, 31.745700>, <7.178690, 0.741060, 31.944300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.620690, 1.011140, 31.750600>, <7.572580, 1.132590, 31.754000>, <7.716290, 1.040270, 31.950500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.716290, 1.040270, 31.950500>, <7.619960, 1.242830, 31.956200>, <7.702340, 1.210650, 32.117600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.697740, 0.611212, 31.739700>, <7.798140, 0.598565, 31.938400>, <7.791440, 0.332931, 31.931300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.798140, 0.598565, 31.938400>, <7.775780, 0.812825, 31.944200>, <7.835540, 0.778393, 32.130000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.700300, 0.217722, 31.729100>, <7.772240, 0.157185, 31.926700>, <7.676770, -0.074234, 31.920900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.772240, 0.157185, 31.926700>, <7.791440, 0.332931, 31.931300>, <7.852740, 0.247550, 32.128400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.483960, -0.194224, 31.718900>, <7.552250, -0.120623, 31.720600>, <7.550280, -0.193904, 31.915700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.550280, -0.193904, 31.915700>, <7.676770, -0.074234, 31.920900>, <7.663330, -0.213513, 32.136700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.256950, -0.348216, 31.915000>, <7.379080, -0.445754, 32.132400>, <6.995910, -0.397674, 32.070700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.379080, -0.445754, 32.132400>, <7.663330, -0.213513, 32.136700>, <7.648880, -0.267516, 32.249100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.379080, -0.445754, 32.132400>, <7.435930, -0.332463, 31.910000>, <7.550280, -0.193904, 31.915700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.550280, -0.193904, 31.915700>, <7.435930, -0.332463, 31.910000>, <7.483960, -0.194224, 31.718900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.643540, -0.481859, 32.164200>, <7.350330, -0.498313, 32.225200>, <6.645660, -0.609538, 32.221700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.350330, -0.498313, 32.225200>, <7.648880, -0.267516, 32.249100>, <7.651560, -0.288753, 32.344100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.645660, -0.609538, 32.221700>, <7.319560, -0.538367, 32.312800>, <6.621720, -0.663209, 32.259500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.319560, -0.538367, 32.312800>, <7.651560, -0.288753, 32.344100>, <7.650730, -0.295018, 32.476500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.621720, -0.663209, 32.259500>, <7.283940, -0.563802, 32.411500>, <6.681660, -0.673516, 32.357600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.283940, -0.563802, 32.411500>, <7.650730, -0.295018, 32.476500>, <7.661300, -0.240073, 32.868700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.294230, -0.317083, 31.716200>, <7.415180, -0.297707, 31.711500>, <7.256950, -0.348216, 31.915000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.271710, -0.297257, 31.489600>, <7.339250, -0.252566, 31.465900>, <7.294230, -0.317083, 31.716200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.294230, -0.317083, 31.716200>, <7.166260, -0.340892, 31.716000>, <7.271710, -0.297257, 31.489600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.271710, -0.297257, 31.489600>, <7.194570, -0.322464, 31.506700>, <7.212550, -0.322441, 31.399700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.271710, -0.297257, 31.489600>, <7.212550, -0.322441, 31.399700>, <7.297940, -0.249982, 31.345000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.339250, -0.252566, 31.465900>, <7.271710, -0.297257, 31.489600>, <7.297940, -0.249982, 31.345000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.074500, 1.183260, 31.757000>, <7.089070, 1.276880, 31.759500>, <6.994920, 1.210420, 31.580700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994920, 1.210420, 31.580700>, <6.998660, 1.297170, 31.607400>, <6.913910, 1.228740, 31.464900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.187600, 0.988996, 31.950900>, <7.217330, 1.245160, 31.957700>, <7.074500, 1.183260, 31.757000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994920, 1.210420, 31.580700>, <6.996190, 1.113340, 31.534400>, <7.074500, 1.183260, 31.757000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.074500, 1.183260, 31.757000>, <7.098210, 1.071160, 31.754000>, <7.187600, 0.988996, 31.950900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.187600, 0.988996, 31.950900>, <7.178690, 0.741060, 31.944300>, <7.230350, 0.719945, 32.137300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.996190, 1.113340, 31.534400>, <7.098210, 1.071160, 31.754000>, <7.074500, 1.183260, 31.757000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.098210, 1.071160, 31.754000>, <7.108120, 0.995543, 31.751900>, <7.187600, 0.988996, 31.950900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.164420, -0.625082, 32.536000>, <6.277910, -0.716482, 32.496200>, <6.640030, -0.591853, 32.862700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.321590, -0.189921, 32.869100>, <6.583190, -0.160847, 32.498300>, <6.095040, -0.359291, 32.465800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.681660, -0.673516, 32.357600>, <6.568410, -0.711339, 32.313000>, <6.621720, -0.663209, 32.259500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205260, -0.527780, 32.862500>, <6.681660, -0.673516, 32.357600>, <7.283940, -0.563802, 32.411500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.568410, -0.711339, 32.313000>, <6.681660, -0.673516, 32.357600>, <6.435070, -0.750460, 32.412500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.989870, -0.041059, 31.924100>, <6.942130, -0.198271, 31.921400>, <6.715870, -0.210837, 32.071600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.715870, -0.210837, 32.071600>, <6.576010, -0.297796, 32.150500>, <6.442860, -0.238370, 32.191300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.810090, -0.296895, 32.054900>, <6.942130, -0.198271, 31.921400>, <7.001490, -0.318646, 31.916600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.810090, -0.296895, 32.054900>, <6.621850, -0.355454, 32.152000>, <6.576010, -0.297796, 32.150500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.900150, -0.348307, 32.057000>, <6.643540, -0.481859, 32.164200>, <6.621850, -0.355454, 32.152000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.001490, -0.318646, 31.916600>, <7.118620, -0.337528, 31.915700>, <6.900150, -0.348307, 32.057000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.118620, -0.337528, 31.915700>, <7.256950, -0.348216, 31.915000>, <6.995910, -0.397674, 32.070700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.995910, -0.397674, 32.070700>, <7.379080, -0.445754, 32.132400>, <6.643540, -0.481859, 32.164200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.396771, 33.627400>, <7.220400, 0.457650, 33.688300>, <7.220400, 0.457650, 33.627400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.396771, 33.627400>, <7.220400, 0.396771, 33.688300>, <7.220400, 0.457650, 33.688300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.396771, 33.627400>, <7.281280, 0.457650, 33.627400>, <7.281280, 0.396771, 33.627400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.396771, 33.627400>, <7.220400, 0.457650, 33.627400>, <7.281280, 0.457650, 33.627400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.457650, 33.627400>, <7.281280, 0.457650, 33.688300>, <7.281280, 0.457650, 33.627400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.457650, 33.627400>, <7.220400, 0.457650, 33.688300>, <7.281280, 0.457650, 33.688300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.457650, 33.688300>, <7.281280, 0.396771, 33.688300>, <7.281280, 0.457650, 33.688300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.457650, 33.688300>, <7.220400, 0.396771, 33.688300>, <7.281280, 0.396771, 33.688300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.396771, 33.688300>, <7.281280, 0.396771, 33.627400>, <7.281280, 0.396771, 33.688300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.220400, 0.396771, 33.688300>, <7.220400, 0.396771, 33.627400>, <7.281280, 0.396771, 33.627400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.281280, 0.396771, 33.627400>, <7.281280, 0.457650, 33.688300>, <7.281280, 0.396771, 33.688300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.281280, 0.396771, 33.627400>, <7.281280, 0.457650, 33.627400>, <7.281280, 0.457650, 33.688300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.958190, -0.902325, 30.575400>, <6.076790, -0.925858, 30.612000>, <6.063460, -0.980272, 30.632000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.076790, -0.925858, 30.612000>, <5.958190, -0.902325, 30.575400>, <5.982680, -0.884613, 30.563500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.016400, -0.857556, 30.558900>, <6.071180, -0.875337, 30.595100>, <6.076790, -0.925858, 30.612000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.999200, -0.790678, 30.595700>, <6.055670, -0.823665, 30.585400>, <6.016400, -0.857556, 30.558900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.942170, -0.782591, 30.620800>, <5.999200, -0.790678, 30.595700>, <5.982680, -0.884613, 30.563500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.958190, -0.902325, 30.575400>, <5.881340, -0.792700, 30.648200>, <5.942170, -0.782591, 30.620800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.958190, -0.902325, 30.575400>, <5.856880, -0.828982, 30.659700>, <5.881340, -0.792700, 30.648200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.958190, -0.902325, 30.575400>, <6.063460, -0.980272, 30.632000>, <6.030310, -1.026010, 30.652600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.930310, -0.923272, 30.587800>, <6.030310, -1.026010, 30.652600>, <5.891090, -0.958463, 30.644600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.950690, -1.017590, 30.673500>, <5.885920, -0.963616, 30.674600>, <5.891090, -0.958463, 30.644600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.891090, -0.958463, 30.644600>, <5.829720, -0.882574, 30.672900>, <5.930310, -0.923272, 30.587800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.930310, -0.923272, 30.587800>, <5.856880, -0.828982, 30.659700>, <5.958190, -0.902325, 30.575400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.063460, -0.980272, 30.632000>, <6.076790, -0.925858, 30.612000>, <6.130700, -0.929763, 30.752400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.063460, -0.980272, 30.632000>, <6.130700, -0.929763, 30.752400>, <6.098780, -0.997485, 30.788200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.076790, -0.925858, 30.612000>, <6.071180, -0.875337, 30.595100>, <6.146680, -0.852507, 30.717700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.076790, -0.925858, 30.612000>, <6.146680, -0.852507, 30.717700>, <6.130700, -0.929763, 30.752400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.071180, -0.875337, 30.595100>, <6.055670, -0.823665, 30.585400>, <6.122760, -0.768264, 30.694000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.071180, -0.875337, 30.595100>, <6.122760, -0.768264, 30.694000>, <6.146680, -0.852507, 30.717700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.055670, -0.823665, 30.585400>, <5.999200, -0.790678, 30.595700>, <6.026290, -0.730065, 30.714200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.055670, -0.823665, 30.585400>, <6.026290, -0.730065, 30.714200>, <6.122760, -0.768264, 30.694000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.999200, -0.790678, 30.595700>, <5.942170, -0.782591, 30.620800>, <5.940930, -0.712753, 30.741900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.999200, -0.790678, 30.595700>, <5.940930, -0.712753, 30.741900>, <6.026290, -0.730065, 30.714200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.942170, -0.782591, 30.620800>, <5.881340, -0.792700, 30.648200>, <5.863010, -0.741419, 30.781900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.942170, -0.782591, 30.620800>, <5.863010, -0.741419, 30.781900>, <5.940930, -0.712753, 30.741900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.881340, -0.792700, 30.648200>, <5.856880, -0.828982, 30.659700>, <5.811710, -0.776886, 30.812700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.881340, -0.792700, 30.648200>, <5.811710, -0.776886, 30.812700>, <5.863010, -0.741419, 30.781900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.856880, -0.828982, 30.659700>, <5.829720, -0.882574, 30.672900>, <5.773620, -0.845672, 30.862700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.856880, -0.828982, 30.659700>, <5.773620, -0.845672, 30.862700>, <5.811710, -0.776886, 30.812700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.842190, -0.951575, 30.586100>, <5.866620, -0.989838, 30.581200>, <5.871650, -0.974801, 30.872600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.832160, -0.916301, 30.621300>, <5.821070, -0.905164, 30.878800>, <5.794000, -0.842587, 30.862200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.946970, -1.029410, 30.869700>, <5.871650, -0.974801, 30.872600>, <5.926890, -1.024380, 30.597700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.926890, -1.024380, 30.597700>, <5.958940, -1.046930, 30.624800>, <5.946970, -1.029410, 30.869700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.984170, -1.045050, 30.675700>, <6.030310, -1.026010, 30.652600>, <6.053410, -1.045550, 30.825200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.984170, -1.045050, 30.675700>, <6.053410, -1.045550, 30.825200>, <6.005540, -1.085630, 30.855400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.030310, -1.026010, 30.652600>, <6.063460, -0.980272, 30.632000>, <6.098780, -0.997485, 30.788200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.030310, -1.026010, 30.652600>, <6.098780, -0.997485, 30.788200>, <6.053410, -1.045550, 30.825200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.182910, -0.918088, 30.959500>, <6.201300, -0.909544, 31.161200>, <6.130200, -0.993078, 31.010500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.130200, -0.993078, 31.010500>, <6.098780, -0.997485, 30.788200>, <6.182910, -0.918088, 30.959500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.201860, -0.825147, 30.912300>, <6.221290, -0.801141, 31.112100>, <6.182910, -0.918088, 30.959500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.182910, -0.918088, 30.959500>, <6.130700, -0.929763, 30.752400>, <6.201860, -0.825147, 30.912300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.173900, -0.719091, 30.882300>, <6.200760, -0.676906, 31.083600>, <6.201860, -0.825147, 30.912300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.201860, -0.825147, 30.912300>, <6.146680, -0.852507, 30.717700>, <6.173900, -0.719091, 30.882300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.057490, -0.679009, 30.903900>, <6.075980, -0.632821, 31.104600>, <6.173900, -0.719091, 30.882300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.173900, -0.719091, 30.882300>, <6.122760, -0.768264, 30.694000>, <6.057490, -0.679009, 30.903900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.956520, -0.656515, 30.944500>, <5.973700, -0.624984, 31.140200>, <6.057490, -0.679009, 30.903900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.057490, -0.679009, 30.903900>, <6.026290, -0.730065, 30.714200>, <5.956520, -0.656515, 30.944500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.849390, -0.681889, 30.996900>, <5.857760, -0.656793, 31.197200>, <5.956520, -0.656515, 30.944500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.956520, -0.656515, 30.944500>, <5.940930, -0.712753, 30.741900>, <5.849390, -0.681889, 30.996900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.800140, -0.735285, 31.043600>, <5.800450, -0.724689, 31.253000>, <5.849390, -0.681889, 30.996900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.849390, -0.681889, 30.996900>, <5.863010, -0.741419, 30.781900>, <5.800140, -0.735285, 31.043600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.754770, -0.816685, 31.086200>, <5.767110, -0.811328, 31.300700>, <5.800140, -0.735285, 31.043600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.800140, -0.735285, 31.043600>, <5.811710, -0.776886, 30.812700>, <5.754770, -0.816685, 31.086200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.860830, -0.968220, 31.207600>, <5.858840, -0.962871, 31.326300>, <5.798680, -0.889225, 31.174000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.776840, -0.814977, 31.085700>, <5.794000, -0.842587, 30.862200>, <5.816540, -0.883154, 31.173500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.017130, -1.086090, 31.088200>, <5.968470, -1.036400, 31.325200>, <5.953390, -1.042640, 31.175200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.873620, -0.957013, 31.207000>, <5.871650, -0.974801, 30.872600>, <5.960240, -1.025530, 31.174600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.070220, -1.050420, 31.056200>, <6.069110, -1.045500, 31.264500>, <6.017130, -1.086090, 31.088200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.017130, -1.086090, 31.088200>, <6.005540, -1.085630, 30.855400>, <6.070220, -1.050420, 31.056200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.130200, -0.993078, 31.010500>, <6.151620, -0.974724, 31.214300>, <6.070220, -1.050420, 31.056200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.070220, -1.050420, 31.056200>, <6.053410, -1.045550, 30.825200>, <6.130200, -0.993078, 31.010500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229430, -0.867959, 31.439100>, <6.285650, -0.845757, 31.507300>, <6.166190, -0.954960, 31.511400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.148800, -0.963962, 31.418100>, <6.151620, -0.974724, 31.214300>, <6.197880, -0.884500, 31.367300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.240720, -0.763663, 31.375600>, <6.280310, -0.740150, 31.441100>, <6.229430, -0.867959, 31.439100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.197880, -0.884500, 31.367300>, <6.201300, -0.909544, 31.161200>, <6.231800, -0.771088, 31.302000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.202940, -0.671626, 31.349000>, <6.242860, -0.635320, 31.405900>, <6.240720, -0.763663, 31.375600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231800, -0.771088, 31.302000>, <6.221290, -0.801141, 31.112100>, <6.214260, -0.663411, 31.271000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.096410, -0.623736, 31.375400>, <6.141110, -0.572516, 31.436100>, <6.202940, -0.671626, 31.349000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.214260, -0.663411, 31.271000>, <6.200760, -0.676906, 31.083600>, <6.090400, -0.616288, 31.294000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.996550, -0.611842, 31.425100>, <6.036900, -0.561258, 31.492000>, <6.096410, -0.623736, 31.375400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.090400, -0.616288, 31.294000>, <6.075980, -0.632821, 31.104600>, <5.975520, -0.615105, 31.356300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.901010, -0.633492, 31.491000>, <5.932930, -0.582332, 31.567100>, <5.996550, -0.611842, 31.425100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.975520, -0.615105, 31.356300>, <5.973700, -0.624984, 31.140200>, <5.875920, -0.646138, 31.418700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.832710, -0.695725, 31.571000>, <5.867840, -0.667850, 31.655800>, <5.901010, -0.633492, 31.491000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.875920, -0.646138, 31.418700>, <5.857760, -0.656793, 31.197200>, <5.806540, -0.722687, 31.478100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.827470, -0.798541, 31.616500>, <5.863640, -0.750962, 31.713400>, <5.832710, -0.695725, 31.571000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.806540, -0.722687, 31.478100>, <5.800450, -0.724689, 31.253000>, <5.802080, -0.813116, 31.520500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.878820, -0.933309, 31.647200>, <5.928530, -0.889962, 31.751300>, <5.827470, -0.798541, 31.616500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.802080, -0.813116, 31.520500>, <5.767110, -0.811328, 31.300700>, <5.868730, -0.950672, 31.544400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.972230, -0.994034, 31.629400>, <6.015410, -0.959303, 31.738400>, <5.878820, -0.933309, 31.647200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.868730, -0.950672, 31.544400>, <5.858840, -0.962871, 31.326300>, <5.961590, -1.005470, 31.519100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.084950, -1.009120, 31.577600>, <6.119790, -0.970525, 31.675600>, <5.972230, -0.994034, 31.629400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.961590, -1.005470, 31.519100>, <5.968470, -1.036400, 31.325200>, <6.066720, -1.025290, 31.473000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.166190, -0.954960, 31.511400>, <6.212220, -0.943574, 31.604000>, <6.084950, -1.009120, 31.577600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.066720, -1.025290, 31.473000>, <6.069110, -1.045500, 31.264500>, <6.148800, -0.963962, 31.418100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212220, -0.943574, 31.604000>, <6.285650, -0.845757, 31.507300>, <6.509700, -0.717548, 31.759200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212220, -0.943574, 31.604000>, <6.509700, -0.717548, 31.759200>, <6.455550, -0.807407, 31.867100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285650, -0.845757, 31.507300>, <6.280310, -0.740150, 31.441100>, <6.493190, -0.605476, 31.682800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285650, -0.845757, 31.507300>, <6.493190, -0.605476, 31.682800>, <6.509700, -0.717548, 31.759200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280310, -0.740150, 31.441100>, <6.242860, -0.635320, 31.405900>, <6.425060, -0.483212, 31.639800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280310, -0.740150, 31.441100>, <6.425060, -0.483212, 31.639800>, <6.493190, -0.605476, 31.682800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.242860, -0.635320, 31.405900>, <6.141110, -0.572516, 31.436100>, <6.292660, -0.385115, 31.671600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.242860, -0.635320, 31.405900>, <6.292660, -0.385115, 31.671600>, <6.425060, -0.483212, 31.639800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.141110, -0.572516, 31.436100>, <6.036900, -0.561258, 31.492000>, <6.183260, -0.348428, 31.747400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.141110, -0.572516, 31.436100>, <6.183260, -0.348428, 31.747400>, <6.292660, -0.385115, 31.671600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.036900, -0.561258, 31.492000>, <5.932930, -0.582332, 31.567100>, <6.079990, -0.381335, 31.860000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.036900, -0.561258, 31.492000>, <6.079990, -0.381335, 31.860000>, <6.183260, -0.348428, 31.747400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.932930, -0.582332, 31.567100>, <5.867840, -0.667850, 31.655800>, <6.013420, -0.485317, 31.989100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.932930, -0.582332, 31.567100>, <6.013420, -0.485317, 31.989100>, <6.079990, -0.381335, 31.860000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.867840, -0.667850, 31.655800>, <5.863640, -0.750962, 31.713400>, <6.033470, -0.609964, 32.058400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.867840, -0.667850, 31.655800>, <6.033470, -0.609964, 32.058400>, <6.013420, -0.485317, 31.989100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.863640, -0.750962, 31.713400>, <5.928530, -0.889962, 31.751300>, <6.112320, -0.724347, 32.087100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.863640, -0.750962, 31.713400>, <6.112320, -0.724347, 32.087100>, <6.033470, -0.609964, 32.058400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.928530, -0.889962, 31.751300>, <6.015410, -0.959303, 31.738400>, <6.227680, -0.811893, 32.060300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.928530, -0.889962, 31.751300>, <6.227680, -0.811893, 32.060300>, <6.112320, -0.724347, 32.087100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.015410, -0.959303, 31.738400>, <6.119790, -0.970525, 31.675600>, <6.351070, -0.841439, 31.981200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.015410, -0.959303, 31.738400>, <6.351070, -0.841439, 31.981200>, <6.227680, -0.811893, 32.060300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.119790, -0.970525, 31.675600>, <6.212220, -0.943574, 31.604000>, <6.455550, -0.807407, 31.867100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.119790, -0.970525, 31.675600>, <6.455550, -0.807407, 31.867100>, <6.351070, -0.841439, 31.981200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.455550, -0.807407, 31.867100>, <6.509700, -0.717548, 31.759200>, <6.633730, -0.646414, 31.871800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.455550, -0.807407, 31.867100>, <6.633730, -0.646414, 31.871800>, <6.577950, -0.743003, 31.984500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.509700, -0.717548, 31.759200>, <6.493190, -0.605476, 31.682800>, <6.617260, -0.520572, 31.788200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.509700, -0.717548, 31.759200>, <6.617260, -0.520572, 31.788200>, <6.633730, -0.646414, 31.871800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.493190, -0.605476, 31.682800>, <6.425060, -0.483212, 31.639800>, <6.533560, -0.398391, 31.755900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.493190, -0.605476, 31.682800>, <6.533560, -0.398391, 31.755900>, <6.617260, -0.520572, 31.788200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.425060, -0.483212, 31.639800>, <6.292660, -0.385115, 31.671600>, <6.393570, -0.294338, 31.783600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.425060, -0.483212, 31.639800>, <6.393570, -0.294338, 31.783600>, <6.533560, -0.398391, 31.755900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.292660, -0.385115, 31.671600>, <6.183260, -0.348428, 31.747400>, <6.253300, -0.262456, 31.868200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.292660, -0.385115, 31.671600>, <6.253300, -0.262456, 31.868200>, <6.393570, -0.294338, 31.783600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.183260, -0.348428, 31.747400>, <6.079990, -0.381335, 31.860000>, <6.156590, -0.310225, 31.975500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.183260, -0.348428, 31.747400>, <6.156590, -0.310225, 31.975500>, <6.253300, -0.262456, 31.868200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.079990, -0.381335, 31.860000>, <6.013420, -0.485317, 31.989100>, <6.091100, -0.414474, 32.092400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.079990, -0.381335, 31.860000>, <6.091100, -0.414474, 32.092400>, <6.156590, -0.310225, 31.975500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.013420, -0.485317, 31.989100>, <6.033470, -0.609964, 32.058400>, <6.103390, -0.544909, 32.171500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.013420, -0.485317, 31.989100>, <6.103390, -0.544909, 32.171500>, <6.091100, -0.414474, 32.092400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.033470, -0.609964, 32.058400>, <6.112320, -0.724347, 32.087100>, <6.188600, -0.670054, 32.204100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.033470, -0.609964, 32.058400>, <6.188600, -0.670054, 32.204100>, <6.103390, -0.544909, 32.171500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.112320, -0.724347, 32.087100>, <6.227680, -0.811893, 32.060300>, <6.320910, -0.757739, 32.176500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.112320, -0.724347, 32.087100>, <6.320910, -0.757739, 32.176500>, <6.188600, -0.670054, 32.204100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.227680, -0.811893, 32.060300>, <6.351070, -0.841439, 31.981200>, <6.463650, -0.784151, 32.096100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.227680, -0.811893, 32.060300>, <6.463650, -0.784151, 32.096100>, <6.320910, -0.757739, 32.176500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.351070, -0.841439, 31.981200>, <6.455550, -0.807407, 31.867100>, <6.577950, -0.743003, 31.984500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.351070, -0.841439, 31.981200>, <6.577950, -0.743003, 31.984500>, <6.463650, -0.784151, 32.096100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.430380, -0.314094, 32.101300>, <6.401500, -0.362278, 32.157600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.401500, -0.362278, 32.157600>, <6.409490, -0.426404, 32.199600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.409490, -0.426404, 32.199600>, <6.452370, -0.489083, 32.216000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.452370, -0.489083, 32.216000>, <6.518470, -0.533277, 32.202200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.518470, -0.533277, 32.202200>, <6.589810, -0.547015, 32.162100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.589810, -0.547015, 32.162100>, <6.647110, -0.526889, 32.106300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.647110, -0.526889, 32.106300>, <6.675160, -0.478479, 32.050000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.675160, -0.478479, 32.050000>, <6.666720, -0.414917, 32.008100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.666720, -0.414917, 32.008100>, <6.624250, -0.352966, 31.991800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.624250, -0.352966, 31.991800>, <6.558970, -0.309001, 32.005600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.558970, -0.309001, 32.005600>, <6.488060, -0.294717, 32.045600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.566260, -0.403116, 32.123000>, <6.488060, -0.294717, 32.045600>, <6.430380, -0.314094, 32.101300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.430380, -0.314094, 32.101300>, <6.276890, -0.284215, 32.047100>, <6.226170, -0.367384, 32.144700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.430380, -0.314094, 32.101300>, <6.226170, -0.367384, 32.144700>, <6.401500, -0.362278, 32.157600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.401500, -0.362278, 32.157600>, <6.226170, -0.367384, 32.144700>, <6.239440, -0.478502, 32.217400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.401500, -0.362278, 32.157600>, <6.239440, -0.478502, 32.217400>, <6.409490, -0.426404, 32.199600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.409490, -0.426404, 32.199600>, <6.239440, -0.478502, 32.217400>, <6.313580, -0.587166, 32.245700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.409490, -0.426404, 32.199600>, <6.313580, -0.587166, 32.245700>, <6.452370, -0.489083, 32.216000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.452370, -0.489083, 32.216000>, <6.313580, -0.587166, 32.245700>, <6.428330, -0.663512, 32.221900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.452370, -0.489083, 32.216000>, <6.428330, -0.663512, 32.221900>, <6.518470, -0.533277, 32.202200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.518470, -0.533277, 32.202200>, <6.428330, -0.663512, 32.221900>, <6.552050, -0.686800, 32.152300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.518470, -0.533277, 32.202200>, <6.552050, -0.686800, 32.152300>, <6.589810, -0.547015, 32.162100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.589810, -0.547015, 32.162100>, <6.552050, -0.686800, 32.152300>, <6.651090, -0.651388, 32.055700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.589810, -0.547015, 32.162100>, <6.651090, -0.651388, 32.055700>, <6.647110, -0.526889, 32.106300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.647110, -0.526889, 32.106300>, <6.651090, -0.651388, 32.055700>, <6.699340, -0.567585, 31.958000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.647110, -0.526889, 32.106300>, <6.699340, -0.567585, 31.958000>, <6.675160, -0.478479, 32.050000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.675160, -0.478479, 32.050000>, <6.699340, -0.567585, 31.958000>, <6.684750, -0.458085, 31.885600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.675160, -0.478479, 32.050000>, <6.684750, -0.458085, 31.885600>, <6.666720, -0.414917, 32.008100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.666720, -0.414917, 32.008100>, <6.684750, -0.458085, 31.885600>, <6.611730, -0.351626, 31.857600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.666720, -0.414917, 32.008100>, <6.611730, -0.351626, 31.857600>, <6.624250, -0.352966, 31.991800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.624250, -0.352966, 31.991800>, <6.611730, -0.351626, 31.857600>, <6.499440, -0.275924, 31.881400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.624250, -0.352966, 31.991800>, <6.499440, -0.275924, 31.881400>, <6.558970, -0.309001, 32.005600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.558970, -0.309001, 32.005600>, <6.499440, -0.275924, 31.881400>, <6.377040, -0.251035, 31.950800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.558970, -0.309001, 32.005600>, <6.377040, -0.251035, 31.950800>, <6.488060, -0.294717, 32.045600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.488060, -0.294717, 32.045600>, <6.377040, -0.251035, 31.950800>, <6.276890, -0.284215, 32.047100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.488060, -0.294717, 32.045600>, <6.276890, -0.284215, 32.047100>, <6.430380, -0.314094, 32.101300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.276890, -0.284215, 32.047100>, <6.156590, -0.310225, 31.975500>, <6.091100, -0.414474, 32.092400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.276890, -0.284215, 32.047100>, <6.091100, -0.414474, 32.092400>, <6.226170, -0.367384, 32.144700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.226170, -0.367384, 32.144700>, <6.091100, -0.414474, 32.092400>, <6.103390, -0.544909, 32.171500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.226170, -0.367384, 32.144700>, <6.103390, -0.544909, 32.171500>, <6.239440, -0.478502, 32.217400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.239440, -0.478502, 32.217400>, <6.103390, -0.544909, 32.171500>, <6.188600, -0.670054, 32.204100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.239440, -0.478502, 32.217400>, <6.188600, -0.670054, 32.204100>, <6.313580, -0.587166, 32.245700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.313580, -0.587166, 32.245700>, <6.188600, -0.670054, 32.204100>, <6.320910, -0.757739, 32.176500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.313580, -0.587166, 32.245700>, <6.320910, -0.757739, 32.176500>, <6.428330, -0.663512, 32.221900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.428330, -0.663512, 32.221900>, <6.320910, -0.757739, 32.176500>, <6.463650, -0.784151, 32.096100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.428330, -0.663512, 32.221900>, <6.463650, -0.784151, 32.096100>, <6.552050, -0.686800, 32.152300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.552050, -0.686800, 32.152300>, <6.463650, -0.784151, 32.096100>, <6.577950, -0.743003, 31.984500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.552050, -0.686800, 32.152300>, <6.577950, -0.743003, 31.984500>, <6.651090, -0.651388, 32.055700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.651090, -0.651388, 32.055700>, <6.577950, -0.743003, 31.984500>, <6.633730, -0.646414, 31.871800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.651090, -0.651388, 32.055700>, <6.633730, -0.646414, 31.871800>, <6.699340, -0.567585, 31.958000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.699340, -0.567585, 31.958000>, <6.633730, -0.646414, 31.871800>, <6.617260, -0.520572, 31.788200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.699340, -0.567585, 31.958000>, <6.617260, -0.520572, 31.788200>, <6.684750, -0.458085, 31.885600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.684750, -0.458085, 31.885600>, <6.617260, -0.520572, 31.788200>, <6.533560, -0.398391, 31.755900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.684750, -0.458085, 31.885600>, <6.533560, -0.398391, 31.755900>, <6.611730, -0.351626, 31.857600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.611730, -0.351626, 31.857600>, <6.533560, -0.398391, 31.755900>, <6.393570, -0.294338, 31.783600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.611730, -0.351626, 31.857600>, <6.393570, -0.294338, 31.783600>, <6.499440, -0.275924, 31.881400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.499440, -0.275924, 31.881400>, <6.393570, -0.294338, 31.783600>, <6.253300, -0.262456, 31.868200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.499440, -0.275924, 31.881400>, <6.253300, -0.262456, 31.868200>, <6.377040, -0.251035, 31.950800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.377040, -0.251035, 31.950800>, <6.253300, -0.262456, 31.868200>, <6.156590, -0.310225, 31.975500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.377040, -0.251035, 31.950800>, <6.156590, -0.310225, 31.975500>, <6.276890, -0.284215, 32.047100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.930310, -0.923272, 30.587800>, <5.829720, -0.882574, 30.672900>, <5.856880, -0.828982, 30.659700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.030310, -1.026010, 30.652600>, <5.930310, -0.923272, 30.587800>, <5.958190, -0.902325, 30.575400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.891090, -0.958463, 30.644600>, <5.846970, -0.912975, 30.676200>, <5.829720, -0.882574, 30.672900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.030310, -1.026010, 30.652600>, <5.984170, -1.045050, 30.675700>, <5.891090, -0.958463, 30.644600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.982680, -0.884613, 30.563500>, <5.958190, -0.902325, 30.575400>, <5.942170, -0.782591, 30.620800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.982680, -0.884613, 30.563500>, <5.999200, -0.790678, 30.595700>, <6.016400, -0.857556, 30.558900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.016400, -0.857556, 30.558900>, <6.076790, -0.925858, 30.612000>, <5.982680, -0.884613, 30.563500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.016400, -0.857556, 30.558900>, <6.055670, -0.823665, 30.585400>, <6.071180, -0.875337, 30.595100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.146680, -0.852507, 30.717700>, <6.122760, -0.768264, 30.694000>, <6.173900, -0.719091, 30.882300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.173900, -0.719091, 30.882300>, <6.075980, -0.632821, 31.104600>, <6.200760, -0.676906, 31.083600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.122760, -0.768264, 30.694000>, <6.026290, -0.730065, 30.714200>, <6.057490, -0.679009, 30.903900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.057490, -0.679009, 30.903900>, <5.973700, -0.624984, 31.140200>, <6.075980, -0.632821, 31.104600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.026290, -0.730065, 30.714200>, <5.940930, -0.712753, 30.741900>, <5.956520, -0.656515, 30.944500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.956520, -0.656515, 30.944500>, <5.857760, -0.656793, 31.197200>, <5.973700, -0.624984, 31.140200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.940930, -0.712753, 30.741900>, <5.863010, -0.741419, 30.781900>, <5.849390, -0.681889, 30.996900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.849390, -0.681889, 30.996900>, <5.800450, -0.724689, 31.253000>, <5.857760, -0.656793, 31.197200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.863010, -0.741419, 30.781900>, <5.811710, -0.776886, 30.812700>, <5.800140, -0.735285, 31.043600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.800140, -0.735285, 31.043600>, <5.767110, -0.811328, 31.300700>, <5.800450, -0.724689, 31.253000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.811710, -0.776886, 30.812700>, <5.773620, -0.845672, 30.862700>, <5.754770, -0.816685, 31.086200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.767110, -0.811328, 31.300700>, <5.754770, -0.816685, 31.086200>, <5.798680, -0.889225, 31.174000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.871650, -0.974801, 30.872600>, <5.873620, -0.957013, 31.207000>, <5.816540, -0.883154, 31.173500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.858840, -0.962871, 31.326300>, <5.860830, -0.968220, 31.207600>, <5.953390, -1.042640, 31.175200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.009070, -1.065640, 30.854900>, <6.020210, -1.065300, 31.087600>, <5.960240, -1.025530, 31.174600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.017130, -1.086090, 31.088200>, <6.069110, -1.045500, 31.264500>, <5.968470, -1.036400, 31.325200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.005540, -1.085630, 30.855400>, <6.053410, -1.045550, 30.825200>, <6.070220, -1.050420, 31.056200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.070220, -1.050420, 31.056200>, <6.151620, -0.974724, 31.214300>, <6.069110, -1.045500, 31.264500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.130200, -0.993078, 31.010500>, <6.201300, -0.909544, 31.161200>, <6.151620, -0.974724, 31.214300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.053410, -1.045550, 30.825200>, <6.098780, -0.997485, 30.788200>, <6.130200, -0.993078, 31.010500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.098780, -0.997485, 30.788200>, <6.130700, -0.929763, 30.752400>, <6.182910, -0.918088, 30.959500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.182910, -0.918088, 30.959500>, <6.221290, -0.801141, 31.112100>, <6.201300, -0.909544, 31.161200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.130700, -0.929763, 30.752400>, <6.146680, -0.852507, 30.717700>, <6.201860, -0.825147, 30.912300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.201860, -0.825147, 30.912300>, <6.200760, -0.676906, 31.083600>, <6.221290, -0.801141, 31.112100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.858840, -0.962871, 31.326300>, <5.968470, -1.036400, 31.325200>, <5.961590, -1.005470, 31.519100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.972230, -0.994034, 31.629400>, <5.961590, -1.005470, 31.519100>, <6.084950, -1.009120, 31.577600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.968470, -1.036400, 31.325200>, <6.069110, -1.045500, 31.264500>, <6.066720, -1.025290, 31.473000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.084950, -1.009120, 31.577600>, <6.066720, -1.025290, 31.473000>, <6.166190, -0.954960, 31.511400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.166190, -0.954960, 31.511400>, <6.148800, -0.963962, 31.418100>, <6.229430, -0.867959, 31.439100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.069110, -1.045500, 31.264500>, <6.151620, -0.974724, 31.214300>, <6.148800, -0.963962, 31.418100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.151620, -0.974724, 31.214300>, <6.201300, -0.909544, 31.161200>, <6.197880, -0.884500, 31.367300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229430, -0.867959, 31.439100>, <6.197880, -0.884500, 31.367300>, <6.240720, -0.763663, 31.375600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.201300, -0.909544, 31.161200>, <6.221290, -0.801141, 31.112100>, <6.231800, -0.771088, 31.302000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.240720, -0.763663, 31.375600>, <6.231800, -0.771088, 31.302000>, <6.202940, -0.671626, 31.349000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.221290, -0.801141, 31.112100>, <6.200760, -0.676906, 31.083600>, <6.214260, -0.663411, 31.271000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.202940, -0.671626, 31.349000>, <6.214260, -0.663411, 31.271000>, <6.096410, -0.623736, 31.375400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.767110, -0.811328, 31.300700>, <5.858840, -0.962871, 31.326300>, <5.868730, -0.950672, 31.544400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.878820, -0.933309, 31.647200>, <5.868730, -0.950672, 31.544400>, <5.972230, -0.994034, 31.629400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.800450, -0.724689, 31.253000>, <5.767110, -0.811328, 31.300700>, <5.802080, -0.813116, 31.520500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.827470, -0.798541, 31.616500>, <5.802080, -0.813116, 31.520500>, <5.878820, -0.933309, 31.647200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.857760, -0.656793, 31.197200>, <5.800450, -0.724689, 31.253000>, <5.806540, -0.722687, 31.478100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.832710, -0.695725, 31.571000>, <5.806540, -0.722687, 31.478100>, <5.827470, -0.798541, 31.616500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.200760, -0.676906, 31.083600>, <6.075980, -0.632821, 31.104600>, <6.090400, -0.616288, 31.294000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.096410, -0.623736, 31.375400>, <6.090400, -0.616288, 31.294000>, <5.996550, -0.611842, 31.425100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.075980, -0.632821, 31.104600>, <5.973700, -0.624984, 31.140200>, <5.975520, -0.615105, 31.356300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.996550, -0.611842, 31.425100>, <5.975520, -0.615105, 31.356300>, <5.901010, -0.633492, 31.491000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.973700, -0.624984, 31.140200>, <5.857760, -0.656793, 31.197200>, <5.875920, -0.646138, 31.418700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.901010, -0.633492, 31.491000>, <5.875920, -0.646138, 31.418700>, <5.832710, -0.695725, 31.571000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.090400, -0.616288, 31.294000>, <6.096410, -0.623736, 31.375400>, <6.214260, -0.663411, 31.271000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.096410, -0.623736, 31.375400>, <6.036900, -0.561258, 31.492000>, <6.141110, -0.572516, 31.436100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.975520, -0.615105, 31.356300>, <5.996550, -0.611842, 31.425100>, <6.090400, -0.616288, 31.294000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.996550, -0.611842, 31.425100>, <5.932930, -0.582332, 31.567100>, <6.036900, -0.561258, 31.492000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.875920, -0.646138, 31.418700>, <5.901010, -0.633492, 31.491000>, <5.975520, -0.615105, 31.356300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.901010, -0.633492, 31.491000>, <5.867840, -0.667850, 31.655800>, <5.932930, -0.582332, 31.567100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.806540, -0.722687, 31.478100>, <5.832710, -0.695725, 31.571000>, <5.875920, -0.646138, 31.418700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.832710, -0.695725, 31.571000>, <5.863640, -0.750962, 31.713400>, <5.867840, -0.667850, 31.655800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.802080, -0.813116, 31.520500>, <5.827470, -0.798541, 31.616500>, <5.806540, -0.722687, 31.478100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.827470, -0.798541, 31.616500>, <5.928530, -0.889962, 31.751300>, <5.863640, -0.750962, 31.713400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.868730, -0.950672, 31.544400>, <5.878820, -0.933309, 31.647200>, <5.802080, -0.813116, 31.520500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.878820, -0.933309, 31.647200>, <6.015410, -0.959303, 31.738400>, <5.928530, -0.889962, 31.751300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.961590, -1.005470, 31.519100>, <5.972230, -0.994034, 31.629400>, <5.868730, -0.950672, 31.544400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.972230, -0.994034, 31.629400>, <6.119790, -0.970525, 31.675600>, <6.015410, -0.959303, 31.738400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.066720, -1.025290, 31.473000>, <6.084950, -1.009120, 31.577600>, <5.961590, -1.005470, 31.519100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.084950, -1.009120, 31.577600>, <6.212220, -0.943574, 31.604000>, <6.119790, -0.970525, 31.675600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.148800, -0.963962, 31.418100>, <6.166190, -0.954960, 31.511400>, <6.066720, -1.025290, 31.473000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.166190, -0.954960, 31.511400>, <6.285650, -0.845757, 31.507300>, <6.212220, -0.943574, 31.604000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.197880, -0.884500, 31.367300>, <6.229430, -0.867959, 31.439100>, <6.148800, -0.963962, 31.418100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229430, -0.867959, 31.439100>, <6.280310, -0.740150, 31.441100>, <6.285650, -0.845757, 31.507300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231800, -0.771088, 31.302000>, <6.240720, -0.763663, 31.375600>, <6.197880, -0.884500, 31.367300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.240720, -0.763663, 31.375600>, <6.242860, -0.635320, 31.405900>, <6.280310, -0.740150, 31.441100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.214260, -0.663411, 31.271000>, <6.202940, -0.671626, 31.349000>, <6.231800, -0.771088, 31.302000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.202940, -0.671626, 31.349000>, <6.141110, -0.572516, 31.436100>, <6.242860, -0.635320, 31.405900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.798680, -0.889225, 31.174000>, <5.858840, -0.962871, 31.326300>, <5.767110, -0.811328, 31.300700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.816540, -0.883154, 31.173500>, <5.821070, -0.905164, 30.878800>, <5.871650, -0.974801, 30.872600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.953390, -1.042640, 31.175200>, <5.968470, -1.036400, 31.325200>, <5.858840, -0.962871, 31.326300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.960240, -1.025530, 31.174600>, <5.946970, -1.029410, 30.869700>, <6.009070, -1.065640, 30.854900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.821070, -0.905164, 30.878800>, <5.832160, -0.916301, 30.621300>, <5.842190, -0.951575, 30.586100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.816540, -0.883154, 31.173500>, <5.794000, -0.842587, 30.862200>, <5.821070, -0.905164, 30.878800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.958940, -1.046930, 30.624800>, <6.009070, -1.065640, 30.854900>, <5.946970, -1.029410, 30.869700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.960240, -1.025530, 31.174600>, <5.871650, -0.974801, 30.872600>, <5.946970, -1.029410, 30.869700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.842190, -0.951575, 30.586100>, <5.871650, -0.974801, 30.872600>, <5.821070, -0.905164, 30.878800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.891090, -0.958463, 30.644600>, <5.885920, -0.963616, 30.674600>, <5.846970, -0.912975, 30.676200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.984170, -1.045050, 30.675700>, <5.950690, -1.017590, 30.673500>, <5.891090, -0.958463, 30.644600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.871650, -0.974801, 30.872600>, <5.866620, -0.989838, 30.581200>, <5.926890, -1.024380, 30.597700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.846540, -0.946388, 30.587200>, <5.846970, -0.912975, 30.676200>, <5.885920, -0.963616, 30.674600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.870490, -0.984576, 30.579500>, <5.866620, -0.989838, 30.581200>, <5.842190, -0.951575, 30.586100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.794000, -0.842587, 30.862200>, <5.773620, -0.845672, 30.862700>, <5.829720, -0.882574, 30.672900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.837740, -0.912188, 30.617300>, <5.832160, -0.916301, 30.621300>, <5.794000, -0.842587, 30.862200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931270, -1.018530, 30.596700>, <5.950690, -1.017590, 30.673500>, <5.984170, -1.045050, 30.675700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.962870, -1.041030, 30.622800>, <5.958940, -1.046930, 30.624800>, <5.926890, -1.024380, 30.597700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.776840, -0.814977, 31.085700>, <5.754770, -0.816685, 31.086200>, <5.773620, -0.845672, 30.862700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.773620, -0.845672, 30.862700>, <5.794000, -0.842587, 30.862200>, <5.776840, -0.814977, 31.085700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.816540, -0.883154, 31.173500>, <5.798680, -0.889225, 31.174000>, <5.754770, -0.816685, 31.086200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.754770, -0.816685, 31.086200>, <5.776840, -0.814977, 31.085700>, <5.816540, -0.883154, 31.173500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.960240, -1.025530, 31.174600>, <5.953390, -1.042640, 31.175200>, <5.860830, -0.968220, 31.207600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.860830, -0.968220, 31.207600>, <5.873620, -0.957013, 31.207000>, <5.960240, -1.025530, 31.174600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.873620, -0.957013, 31.207000>, <5.860830, -0.968220, 31.207600>, <5.798680, -0.889225, 31.174000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.798680, -0.889225, 31.174000>, <5.816540, -0.883154, 31.173500>, <5.873620, -0.957013, 31.207000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.009070, -1.065640, 30.854900>, <6.005540, -1.085630, 30.855400>, <6.017130, -1.086090, 31.088200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.017130, -1.086090, 31.088200>, <6.020210, -1.065300, 31.087600>, <6.009070, -1.065640, 30.854900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.020210, -1.065300, 31.087600>, <6.017130, -1.086090, 31.088200>, <5.953390, -1.042640, 31.175200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.953390, -1.042640, 31.175200>, <5.960240, -1.025530, 31.174600>, <6.020210, -1.065300, 31.087600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.837740, -0.912188, 30.617300>, <5.829720, -0.882574, 30.672900>, <5.846970, -0.912975, 30.676200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.846540, -0.946388, 30.587200>, <5.842190, -0.951575, 30.586100>, <5.832160, -0.916301, 30.621300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.962870, -1.041030, 30.622800>, <5.984170, -1.045050, 30.675700>, <6.005540, -1.085630, 30.855400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.005540, -1.085630, 30.855400>, <6.009070, -1.065640, 30.854900>, <5.958940, -1.046930, 30.624800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.870490, -0.984576, 30.579500>, <5.885920, -0.963616, 30.674600>, <5.950690, -1.017590, 30.673500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931270, -1.018530, 30.596700>, <5.926890, -1.024380, 30.597700>, <5.866620, -0.989838, 30.581200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.829720, -0.882574, 30.672900>, <5.837740, -0.912188, 30.617300>, <5.794000, -0.842587, 30.862200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.837740, -0.912188, 30.617300>, <5.846970, -0.912975, 30.676200>, <5.846540, -0.946388, 30.587200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.846540, -0.946388, 30.587200>, <5.885920, -0.963616, 30.674600>, <5.870490, -0.984576, 30.579500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.846540, -0.946388, 30.587200>, <5.832160, -0.916301, 30.621300>, <5.837740, -0.912188, 30.617300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.870490, -0.984576, 30.579500>, <5.842190, -0.951575, 30.586100>, <5.846540, -0.946388, 30.587200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.870490, -0.984576, 30.579500>, <5.950690, -1.017590, 30.673500>, <5.931270, -1.018530, 30.596700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931270, -1.018530, 30.596700>, <5.984170, -1.045050, 30.675700>, <5.962870, -1.041030, 30.622800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931270, -1.018530, 30.596700>, <5.866620, -0.989838, 30.581200>, <5.870490, -0.984576, 30.579500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.962870, -1.041030, 30.622800>, <5.926890, -1.024380, 30.597700>, <5.931270, -1.018530, 30.596700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.958940, -1.046930, 30.624800>, <5.962870, -1.041030, 30.622800>, <6.005540, -1.085630, 30.855400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.242020, 1.172120, 30.821700>, <7.270090, 1.071890, 30.912900>, <7.219540, 1.086470, 30.809800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.072880, 1.116940, 30.574000>, <7.040590, 1.212270, 30.454800>, <7.107730, 1.199390, 30.577100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.219540, 1.086470, 30.809800>, <7.195590, 1.011690, 30.914300>, <7.143310, 1.026270, 30.823400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.004650, 1.060010, 30.587900>, <7.007160, 1.131020, 30.461000>, <7.072880, 1.116940, 30.574000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143310, 1.026270, 30.823400>, <7.090840, 0.988808, 30.950900>, <7.039630, 1.005230, 30.869700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.899220, 1.043530, 30.626200>, <6.937260, 1.074020, 30.489900>, <7.004650, 1.060010, 30.587900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.039630, 1.005230, 30.869700>, <6.998770, 1.011130, 31.005400>, <6.943960, 1.024710, 30.944600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.777270, 1.066840, 30.675000>, <6.843090, 1.058860, 30.532900>, <6.899220, 1.043530, 30.626200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.943960, 1.024710, 30.944600>, <6.937220, 1.070690, 31.066200>, <6.872560, 1.082940, 31.022200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.712060, 1.128120, 30.719400>, <6.751420, 1.086070, 30.577200>, <6.777270, 1.066840, 30.675000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.872560, 1.082940, 31.022200>, <6.920560, 1.151550, 31.123100>, <6.843160, 1.166640, 31.072300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.679650, 1.210390, 30.745200>, <6.688240, 1.145250, 30.617800>, <6.712060, 1.128120, 30.719400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.843160, 1.166640, 31.072300>, <6.970500, 1.244100, 31.155200>, <6.885720, 1.254410, 31.081200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.718440, 1.292360, 30.751900>, <6.669490, 1.226870, 30.640100>, <6.679650, 1.210390, 30.745200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.885720, 1.254410, 31.081200>, <7.041470, 1.303730, 31.153200>, <6.962280, 1.314970, 31.064100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.791690, 1.347940, 30.740300>, <6.697150, 1.307490, 30.634500>, <6.718440, 1.292360, 30.751900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.962280, 1.314970, 31.064100>, <7.143430, 1.326970, 31.117000>, <7.068690, 1.336960, 31.018800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.911490, 1.367040, 30.704500>, <6.768300, 1.362700, 30.605100>, <6.791690, 1.347940, 30.740300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068690, 1.336960, 31.018800>, <7.232940, 1.305510, 31.062500>, <7.176460, 1.318110, 30.942400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.027290, 1.347200, 30.649100>, <6.861530, 1.380840, 30.557800>, <6.911490, 1.367040, 30.704500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.176460, 1.318110, 30.942400>, <7.297580, 1.243380, 30.999000>, <7.227830, 1.257410, 30.867900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.088370, 1.283750, 30.605800>, <6.954470, 1.359760, 30.514300>, <7.027290, 1.347200, 30.649100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.227830, 1.257410, 30.867900>, <7.309160, 1.157720, 30.944100>, <7.242020, 1.172120, 30.821700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.107730, 1.199390, 30.577100>, <7.018640, 1.296060, 30.474800>, <7.088370, 1.283750, 30.605800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.217220, 1.171600, 31.206500>, <7.168260, 1.157100, 31.223100>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.168260, 1.157100, 31.223100>, <7.128830, 1.124240, 31.224400>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.128830, 1.124240, 31.224400>, <7.109460, 1.081970, 31.210100>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.109460, 1.081970, 31.210100>, <7.115360, 1.041640, 31.184100>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.115360, 1.041640, 31.184100>, <7.144950, 1.013960, 31.153200>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.144950, 1.013960, 31.153200>, <7.190310, 1.006200, 31.125800>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.190310, 1.006200, 31.125800>, <7.239260, 1.020410, 31.109200>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.239260, 1.020410, 31.109200>, <7.278710, 1.052880, 31.107800>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.278710, 1.052880, 31.107800>, <7.298070, 1.095070, 31.122100>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.298070, 1.095070, 31.122100>, <7.292160, 1.135690, 31.148200>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.292160, 1.135690, 31.148200>, <7.262570, 1.163750, 31.179100>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.262570, 1.163750, 31.179100>, <7.217220, 1.171600, 31.206500>, <7.215770, 1.076980, 31.185400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.194290, 1.263420, 31.183200>, <7.109500, 1.238230, 31.212000>, <7.217220, 1.171600, 31.206500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.109500, 1.238230, 31.212000>, <7.168260, 1.157100, 31.223100>, <7.217220, 1.171600, 31.206500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.109500, 1.238230, 31.212000>, <7.041180, 1.181350, 31.214300>, <7.168260, 1.157100, 31.223100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.041180, 1.181350, 31.214300>, <7.128830, 1.124240, 31.224400>, <7.168260, 1.157100, 31.223100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.041180, 1.181350, 31.214300>, <7.007650, 1.108440, 31.189600>, <7.128830, 1.124240, 31.224400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.007650, 1.108440, 31.189600>, <7.109460, 1.081970, 31.210100>, <7.128830, 1.124240, 31.224400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.007650, 1.108440, 31.189600>, <7.017870, 1.039130, 31.144400>, <7.109460, 1.081970, 31.210100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.017870, 1.039130, 31.144400>, <7.115360, 1.041640, 31.184100>, <7.109460, 1.081970, 31.210100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.017870, 1.039130, 31.144400>, <7.069120, 0.991666, 31.090900>, <7.115360, 1.041640, 31.184100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.069120, 0.991666, 31.090900>, <7.144950, 1.013960, 31.153200>, <7.115360, 1.041640, 31.184100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.069120, 0.991666, 31.090900>, <7.147660, 0.978359, 31.043400>, <7.144950, 1.013960, 31.153200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.147660, 0.978359, 31.043400>, <7.190310, 1.006200, 31.125800>, <7.144950, 1.013960, 31.153200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.147660, 0.978359, 31.043400>, <7.232460, 1.002670, 31.014700>, <7.190310, 1.006200, 31.125800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.232460, 1.002670, 31.014700>, <7.239260, 1.020410, 31.109200>, <7.190310, 1.006200, 31.125800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.232460, 1.002670, 31.014700>, <7.300770, 1.058410, 31.012400>, <7.239260, 1.020410, 31.109200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.300770, 1.058410, 31.012400>, <7.278710, 1.052880, 31.107800>, <7.239260, 1.020410, 31.109200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.300770, 1.058410, 31.012400>, <7.334310, 1.131060, 31.037100>, <7.278710, 1.052880, 31.107800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.334310, 1.131060, 31.037100>, <7.298070, 1.095070, 31.122100>, <7.278710, 1.052880, 31.107800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.334310, 1.131060, 31.037100>, <7.324080, 1.201250, 31.082300>, <7.298070, 1.095070, 31.122100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.324080, 1.201250, 31.082300>, <7.292160, 1.135690, 31.148200>, <7.298070, 1.095070, 31.122100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.324080, 1.201250, 31.082300>, <7.272830, 1.249850, 31.135700>, <7.292160, 1.135690, 31.148200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.272830, 1.249850, 31.135700>, <7.262570, 1.163750, 31.179100>, <7.292160, 1.135690, 31.148200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.272830, 1.249850, 31.135700>, <7.194290, 1.263420, 31.183200>, <7.262570, 1.163750, 31.179100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.194290, 1.263420, 31.183200>, <7.217220, 1.171600, 31.206500>, <7.262570, 1.163750, 31.179100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143430, 1.326970, 31.117000>, <7.041470, 1.303730, 31.153200>, <7.194290, 1.263420, 31.183200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.041470, 1.303730, 31.153200>, <7.109500, 1.238230, 31.212000>, <7.194290, 1.263420, 31.183200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.041470, 1.303730, 31.153200>, <6.970500, 1.244100, 31.155200>, <7.109500, 1.238230, 31.212000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.970500, 1.244100, 31.155200>, <7.041180, 1.181350, 31.214300>, <7.109500, 1.238230, 31.212000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.970500, 1.244100, 31.155200>, <6.920560, 1.151550, 31.123100>, <7.041180, 1.181350, 31.214300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.920560, 1.151550, 31.123100>, <7.007650, 1.108440, 31.189600>, <7.041180, 1.181350, 31.214300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.920560, 1.151550, 31.123100>, <6.937220, 1.070690, 31.066200>, <7.007650, 1.108440, 31.189600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.937220, 1.070690, 31.066200>, <7.017870, 1.039130, 31.144400>, <7.007650, 1.108440, 31.189600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.937220, 1.070690, 31.066200>, <6.998770, 1.011130, 31.005400>, <7.017870, 1.039130, 31.144400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998770, 1.011130, 31.005400>, <7.069120, 0.991666, 31.090900>, <7.017870, 1.039130, 31.144400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998770, 1.011130, 31.005400>, <7.090840, 0.988808, 30.950900>, <7.069120, 0.991666, 31.090900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.090840, 0.988808, 30.950900>, <7.147660, 0.978359, 31.043400>, <7.069120, 0.991666, 31.090900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.090840, 0.988808, 30.950900>, <7.195590, 1.011690, 30.914300>, <7.147660, 0.978359, 31.043400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.195590, 1.011690, 30.914300>, <7.232460, 1.002670, 31.014700>, <7.147660, 0.978359, 31.043400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.195590, 1.011690, 30.914300>, <7.270090, 1.071890, 30.912900>, <7.232460, 1.002670, 31.014700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.270090, 1.071890, 30.912900>, <7.300770, 1.058410, 31.012400>, <7.232460, 1.002670, 31.014700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.270090, 1.071890, 30.912900>, <7.309160, 1.157720, 30.944100>, <7.300770, 1.058410, 31.012400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.309160, 1.157720, 30.944100>, <7.334310, 1.131060, 31.037100>, <7.300770, 1.058410, 31.012400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.309160, 1.157720, 30.944100>, <7.297580, 1.243380, 30.999000>, <7.334310, 1.131060, 31.037100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.297580, 1.243380, 30.999000>, <7.324080, 1.201250, 31.082300>, <7.334310, 1.131060, 31.037100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.297580, 1.243380, 30.999000>, <7.232940, 1.305510, 31.062500>, <7.324080, 1.201250, 31.082300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.232940, 1.305510, 31.062500>, <7.272830, 1.249850, 31.135700>, <7.324080, 1.201250, 31.082300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.232940, 1.305510, 31.062500>, <7.143430, 1.326970, 31.117000>, <7.272830, 1.249850, 31.135700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143430, 1.326970, 31.117000>, <7.194290, 1.263420, 31.183200>, <7.272830, 1.249850, 31.135700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776450, 1.315920, 30.422100>, <6.819780, 1.302950, 30.398200>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819780, 1.302950, 30.398200>, <6.849290, 1.271750, 30.378900>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.849290, 1.271750, 30.378900>, <6.857050, 1.230690, 30.369600>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.857050, 1.230690, 30.369600>, <6.840980, 1.190820, 30.372600>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.840980, 1.190820, 30.372600>, <6.805390, 1.162810, 30.387100>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.805390, 1.162810, 30.387100>, <6.759810, 1.154130, 30.409300>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.759810, 1.154130, 30.409300>, <6.716470, 1.167080, 30.433300>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.716470, 1.167080, 30.433300>, <6.686960, 1.198180, 30.452500>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.686960, 1.198180, 30.452500>, <6.679210, 1.239150, 30.461900>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.679210, 1.239150, 30.461900>, <6.695270, 1.279030, 30.458900>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.695270, 1.279030, 30.458900>, <6.730870, 1.307150, 30.444300>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.730870, 1.307150, 30.444300>, <6.776450, 1.315920, 30.422100>, <6.755290, 1.237020, 30.395100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.817620, 1.370630, 30.483200>, <6.892700, 1.347990, 30.441800>, <6.776450, 1.315920, 30.422100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.892700, 1.347990, 30.441800>, <6.819780, 1.302950, 30.398200>, <6.776450, 1.315920, 30.422100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.892700, 1.347990, 30.441800>, <6.943800, 1.293440, 30.408500>, <6.819780, 1.302950, 30.398200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.943800, 1.293440, 30.408500>, <6.849290, 1.271750, 30.378900>, <6.819780, 1.302950, 30.398200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.943800, 1.293440, 30.408500>, <6.957230, 1.221710, 30.392300>, <6.849290, 1.271750, 30.378900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.957230, 1.221710, 30.392300>, <6.857050, 1.230690, 30.369600>, <6.849290, 1.271750, 30.378900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.957230, 1.221710, 30.392300>, <6.929400, 1.152110, 30.397500>, <6.857050, 1.230690, 30.369600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.929400, 1.152110, 30.397500>, <6.840980, 1.190820, 30.372600>, <6.857050, 1.230690, 30.369600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.929400, 1.152110, 30.397500>, <6.867750, 1.103290, 30.422700>, <6.840980, 1.190820, 30.372600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.867750, 1.103290, 30.422700>, <6.805390, 1.162810, 30.387100>, <6.840980, 1.190820, 30.372600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.867750, 1.103290, 30.422700>, <6.788820, 1.088190, 30.461200>, <6.805390, 1.162810, 30.387100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.788820, 1.088190, 30.461200>, <6.759810, 1.154130, 30.409300>, <6.805390, 1.162810, 30.387100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.788820, 1.088190, 30.461200>, <6.713740, 1.110770, 30.502600>, <6.759810, 1.154130, 30.409300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.713740, 1.110770, 30.502600>, <6.716470, 1.167080, 30.433300>, <6.759810, 1.154130, 30.409300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.713740, 1.110770, 30.502600>, <6.662640, 1.164990, 30.535900>, <6.716470, 1.167080, 30.433300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.662640, 1.164990, 30.535900>, <6.686960, 1.198180, 30.452500>, <6.716470, 1.167080, 30.433300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.662640, 1.164990, 30.535900>, <6.649200, 1.236460, 30.552100>, <6.686960, 1.198180, 30.452500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.649200, 1.236460, 30.552100>, <6.679210, 1.239150, 30.461900>, <6.686960, 1.198180, 30.452500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.649200, 1.236460, 30.552100>, <6.677030, 1.306120, 30.546900>, <6.679210, 1.239150, 30.461900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677030, 1.306120, 30.546900>, <6.695270, 1.279030, 30.458900>, <6.679210, 1.239150, 30.461900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677030, 1.306120, 30.546900>, <6.738680, 1.355270, 30.521700>, <6.695270, 1.279030, 30.458900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.738680, 1.355270, 30.521700>, <6.730870, 1.307150, 30.444300>, <6.695270, 1.279030, 30.458900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.738680, 1.355270, 30.521700>, <6.817620, 1.370630, 30.483200>, <6.730870, 1.307150, 30.444300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.817620, 1.370630, 30.483200>, <6.776450, 1.315920, 30.422100>, <6.730870, 1.307150, 30.444300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.861530, 1.380840, 30.557800>, <6.954470, 1.359760, 30.514300>, <6.817620, 1.370630, 30.483200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.954470, 1.359760, 30.514300>, <6.892700, 1.347990, 30.441800>, <6.817620, 1.370630, 30.483200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.954470, 1.359760, 30.514300>, <7.018640, 1.296060, 30.474800>, <6.892700, 1.347990, 30.441800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.018640, 1.296060, 30.474800>, <6.943800, 1.293440, 30.408500>, <6.892700, 1.347990, 30.441800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.018640, 1.296060, 30.474800>, <7.040590, 1.212270, 30.454800>, <6.943800, 1.293440, 30.408500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.040590, 1.212270, 30.454800>, <6.957230, 1.221710, 30.392300>, <6.943800, 1.293440, 30.408500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.040590, 1.212270, 30.454800>, <7.007160, 1.131020, 30.461000>, <6.957230, 1.221710, 30.392300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.007160, 1.131020, 30.461000>, <6.929400, 1.152110, 30.397500>, <6.957230, 1.221710, 30.392300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.007160, 1.131020, 30.461000>, <6.937260, 1.074020, 30.489900>, <6.929400, 1.152110, 30.397500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.937260, 1.074020, 30.489900>, <6.867750, 1.103290, 30.422700>, <6.929400, 1.152110, 30.397500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.937260, 1.074020, 30.489900>, <6.843090, 1.058860, 30.532900>, <6.867750, 1.103290, 30.422700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.843090, 1.058860, 30.532900>, <6.788820, 1.088190, 30.461200>, <6.867750, 1.103290, 30.422700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.843090, 1.058860, 30.532900>, <6.751420, 1.086070, 30.577200>, <6.788820, 1.088190, 30.461200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.751420, 1.086070, 30.577200>, <6.713740, 1.110770, 30.502600>, <6.788820, 1.088190, 30.461200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.751420, 1.086070, 30.577200>, <6.688240, 1.145250, 30.617800>, <6.713740, 1.110770, 30.502600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.688240, 1.145250, 30.617800>, <6.662640, 1.164990, 30.535900>, <6.713740, 1.110770, 30.502600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.688240, 1.145250, 30.617800>, <6.669490, 1.226870, 30.640100>, <6.662640, 1.164990, 30.535900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.669490, 1.226870, 30.640100>, <6.649200, 1.236460, 30.552100>, <6.662640, 1.164990, 30.535900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.669490, 1.226870, 30.640100>, <6.697150, 1.307490, 30.634500>, <6.649200, 1.236460, 30.552100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.697150, 1.307490, 30.634500>, <6.677030, 1.306120, 30.546900>, <6.649200, 1.236460, 30.552100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.697150, 1.307490, 30.634500>, <6.768300, 1.362700, 30.605100>, <6.677030, 1.306120, 30.546900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.768300, 1.362700, 30.605100>, <6.738680, 1.355270, 30.521700>, <6.677030, 1.306120, 30.546900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.768300, 1.362700, 30.605100>, <6.861530, 1.380840, 30.557800>, <6.738680, 1.355270, 30.521700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.861530, 1.380840, 30.557800>, <6.817620, 1.370630, 30.483200>, <6.738680, 1.355270, 30.521700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.718440, 1.292360, 30.751900>, <6.863780, 1.328420, 30.908200>, <6.791690, 1.347940, 30.740300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.068690, 1.336960, 31.018800>, <6.863780, 1.328420, 30.908200>, <6.962280, 1.314970, 31.064100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.791690, 1.347940, 30.740300>, <6.991610, 1.352360, 30.862900>, <6.911490, 1.367040, 30.704500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.176460, 1.318110, 30.942400>, <6.991610, 1.352360, 30.862900>, <7.068690, 1.336960, 31.018800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.911490, 1.367040, 30.704500>, <7.094260, 1.333370, 30.789500>, <7.027290, 1.347200, 30.649100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.227830, 1.257410, 30.867900>, <7.094260, 1.333370, 30.789500>, <7.176460, 1.318110, 30.942400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.991610, 1.352360, 30.862900>, <6.791690, 1.347940, 30.740300>, <6.863780, 1.328420, 30.908200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.791690, 1.347940, 30.740300>, <6.768300, 1.362700, 30.605100>, <6.697150, 1.307490, 30.634500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.094260, 1.333370, 30.789500>, <6.911490, 1.367040, 30.704500>, <6.991610, 1.352360, 30.862900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.911490, 1.367040, 30.704500>, <6.861530, 1.380840, 30.557800>, <6.768300, 1.362700, 30.605100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.158110, 1.270870, 30.736900>, <7.027290, 1.347200, 30.649100>, <7.094260, 1.333370, 30.789500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.027290, 1.347200, 30.649100>, <6.954470, 1.359760, 30.514300>, <6.861530, 1.380840, 30.557800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.771150, 1.269150, 30.932100>, <6.962280, 1.314970, 31.064100>, <6.863780, 1.328420, 30.908200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.041470, 1.303730, 31.153200>, <7.143430, 1.326970, 31.117000>, <6.962280, 1.314970, 31.064100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.863780, 1.328420, 30.908200>, <7.068690, 1.336960, 31.018800>, <6.991610, 1.352360, 30.862900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143430, 1.326970, 31.117000>, <7.232940, 1.305510, 31.062500>, <7.068690, 1.336960, 31.018800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.991610, 1.352360, 30.862900>, <7.176460, 1.318110, 30.942400>, <7.094260, 1.333370, 30.789500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.232940, 1.305510, 31.062500>, <7.297580, 1.243380, 30.999000>, <7.176460, 1.318110, 30.942400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.679650, 1.210390, 30.745200>, <6.771150, 1.269150, 30.932100>, <6.718440, 1.292360, 30.751900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.962280, 1.314970, 31.064100>, <6.771150, 1.269150, 30.932100>, <6.885720, 1.254410, 31.081200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.863780, 1.328420, 30.908200>, <6.718440, 1.292360, 30.751900>, <6.771150, 1.269150, 30.932100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.718440, 1.292360, 30.751900>, <6.697150, 1.307490, 30.634500>, <6.669490, 1.226870, 30.640100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.730410, 1.185620, 30.924600>, <6.885720, 1.254410, 31.081200>, <6.771150, 1.269150, 30.932100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.970500, 1.244100, 31.155200>, <7.041470, 1.303730, 31.153200>, <6.885720, 1.254410, 31.081200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.027290, 1.347200, 30.649100>, <7.158110, 1.270870, 30.736900>, <7.088370, 1.283750, 30.605800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.242020, 1.172120, 30.821700>, <7.158110, 1.270870, 30.736900>, <7.227830, 1.257410, 30.867900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.219540, 1.086470, 30.809800>, <7.174880, 1.186010, 30.699400>, <7.242020, 1.172120, 30.821700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.088370, 1.283750, 30.605800>, <7.174880, 1.186010, 30.699400>, <7.107730, 1.199390, 30.577100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.107730, 1.199390, 30.577100>, <7.144610, 1.102500, 30.686700>, <7.072880, 1.116940, 30.574000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143310, 1.026270, 30.823400>, <7.144610, 1.102500, 30.686700>, <7.219540, 1.086470, 30.809800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.094260, 1.333370, 30.789500>, <7.227830, 1.257410, 30.867900>, <7.158110, 1.270870, 30.736900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.297580, 1.243380, 30.999000>, <7.309160, 1.157720, 30.944100>, <7.227830, 1.257410, 30.867900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.158110, 1.270870, 30.736900>, <7.242020, 1.172120, 30.821700>, <7.174880, 1.186010, 30.699400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.309160, 1.157720, 30.944100>, <7.270090, 1.071890, 30.912900>, <7.242020, 1.172120, 30.821700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.174880, 1.186010, 30.699400>, <7.219540, 1.086470, 30.809800>, <7.144610, 1.102500, 30.686700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.270090, 1.071890, 30.912900>, <7.195590, 1.011690, 30.914300>, <7.219540, 1.086470, 30.809800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.174880, 1.186010, 30.699400>, <7.088370, 1.283750, 30.605800>, <7.158110, 1.270870, 30.736900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.088370, 1.283750, 30.605800>, <7.018640, 1.296060, 30.474800>, <6.954470, 1.359760, 30.514300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.144610, 1.102500, 30.686700>, <7.107730, 1.199390, 30.577100>, <7.174880, 1.186010, 30.699400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.107730, 1.199390, 30.577100>, <7.040590, 1.212270, 30.454800>, <7.018640, 1.296060, 30.474800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.066430, 1.043740, 30.702100>, <7.072880, 1.116940, 30.574000>, <7.144610, 1.102500, 30.686700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.072880, 1.116940, 30.574000>, <7.007160, 1.131020, 30.461000>, <7.040590, 1.212270, 30.454800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.072880, 1.116940, 30.574000>, <7.066430, 1.043740, 30.702100>, <7.004650, 1.060010, 30.587900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.039630, 1.005230, 30.869700>, <7.066430, 1.043740, 30.702100>, <7.143310, 1.026270, 30.823400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.004650, 1.060010, 30.587900>, <6.967760, 1.025560, 30.740100>, <6.899220, 1.043530, 30.626200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.943960, 1.024710, 30.944600>, <6.967760, 1.025560, 30.740100>, <7.039630, 1.005230, 30.869700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.899220, 1.043530, 30.626200>, <6.839720, 1.045710, 30.812100>, <6.777270, 1.066840, 30.675000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.872560, 1.082940, 31.022200>, <6.839720, 1.045710, 30.812100>, <6.943960, 1.024710, 30.944600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.777270, 1.066840, 30.675000>, <6.761160, 1.104330, 30.882800>, <6.712060, 1.128120, 30.719400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.843160, 1.166640, 31.072300>, <6.761160, 1.104330, 30.882800>, <6.872560, 1.082940, 31.022200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.144610, 1.102500, 30.686700>, <7.143310, 1.026270, 30.823400>, <7.066430, 1.043740, 30.702100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.195590, 1.011690, 30.914300>, <7.090840, 0.988808, 30.950900>, <7.143310, 1.026270, 30.823400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.066430, 1.043740, 30.702100>, <7.039630, 1.005230, 30.869700>, <6.967760, 1.025560, 30.740100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.090840, 0.988808, 30.950900>, <6.998770, 1.011130, 31.005400>, <7.039630, 1.005230, 30.869700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.967760, 1.025560, 30.740100>, <6.943960, 1.024710, 30.944600>, <6.839720, 1.045710, 30.812100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998770, 1.011130, 31.005400>, <6.937220, 1.070690, 31.066200>, <6.943960, 1.024710, 30.944600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.967760, 1.025560, 30.740100>, <7.004650, 1.060010, 30.587900>, <7.066430, 1.043740, 30.702100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.004650, 1.060010, 30.587900>, <6.937260, 1.074020, 30.489900>, <7.007160, 1.131020, 30.461000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.839720, 1.045710, 30.812100>, <6.899220, 1.043530, 30.626200>, <6.967760, 1.025560, 30.740100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.899220, 1.043530, 30.626200>, <6.843090, 1.058860, 30.532900>, <6.937260, 1.074020, 30.489900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.761160, 1.104330, 30.882800>, <6.777270, 1.066840, 30.675000>, <6.839720, 1.045710, 30.812100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.777270, 1.066840, 30.675000>, <6.751420, 1.086070, 30.577200>, <6.843090, 1.058860, 30.532900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.839720, 1.045710, 30.812100>, <6.872560, 1.082940, 31.022200>, <6.761160, 1.104330, 30.882800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.937220, 1.070690, 31.066200>, <6.920560, 1.151550, 31.123100>, <6.872560, 1.082940, 31.022200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.730410, 1.185620, 30.924600>, <6.712060, 1.128120, 30.719400>, <6.761160, 1.104330, 30.882800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.712060, 1.128120, 30.719400>, <6.688240, 1.145250, 30.617800>, <6.751420, 1.086070, 30.577200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.712060, 1.128120, 30.719400>, <6.730410, 1.185620, 30.924600>, <6.679650, 1.210390, 30.745200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.885720, 1.254410, 31.081200>, <6.730410, 1.185620, 30.924600>, <6.843160, 1.166640, 31.072300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.771150, 1.269150, 30.932100>, <6.679650, 1.210390, 30.745200>, <6.730410, 1.185620, 30.924600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.679650, 1.210390, 30.745200>, <6.669490, 1.226870, 30.640100>, <6.688240, 1.145250, 30.617800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.761160, 1.104330, 30.882800>, <6.843160, 1.166640, 31.072300>, <6.730410, 1.185620, 30.924600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.920560, 1.151550, 31.123100>, <6.970500, 1.244100, 31.155200>, <6.843160, 1.166640, 31.072300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.352950, 0.836864, 30.653600>, <7.424640, 0.801278, 30.801000>, <7.368960, 0.743113, 30.647000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.202950, 0.767017, 30.335800>, <7.123370, 0.780667, 30.184900>, <7.169800, 0.865318, 30.347100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.273120, 0.902528, 30.684200>, <7.357370, 0.880778, 30.831400>, <7.352950, 0.836864, 30.653600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.169800, 0.865318, 30.347100>, <7.091790, 0.875831, 30.207400>, <7.094180, 0.934647, 30.369900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.154100, 0.936021, 30.736800>, <7.244370, 0.915717, 30.879100>, <7.273120, 0.902528, 30.684200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.094180, 0.934647, 30.369900>, <7.014070, 0.942696, 30.247500>, <6.969910, 0.956525, 30.408900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034810, 0.913743, 30.806800>, <7.115400, 0.914865, 30.923900>, <7.154100, 0.936021, 30.736800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.969910, 0.956525, 30.408900>, <6.903000, 0.961117, 30.292600>, <6.821810, 0.932246, 30.449800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.931180, 0.839909, 30.860700>, <7.015510, 0.830511, 30.963000>, <7.034810, 0.913743, 30.806800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.821810, 0.932246, 30.449800>, <6.790560, 0.930268, 30.330100>, <6.737420, 0.859993, 30.482200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.876900, 0.740183, 30.882800>, <6.957030, 0.730982, 30.971600>, <6.931180, 0.839909, 30.860700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.737420, 0.859993, 30.482200>, <6.708780, 0.860885, 30.358400>, <6.690210, 0.764381, 30.491300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.915090, 0.635858, 30.872700>, <7.003320, 0.630464, 30.955800>, <6.876900, 0.740183, 30.882800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.690210, 0.764381, 30.491300>, <6.677820, 0.765328, 30.364500>, <6.728010, 0.666293, 30.484400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.995390, 0.563582, 30.839200>, <7.070430, 0.555826, 30.924500>, <6.915090, 0.635858, 30.872700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.728010, 0.666293, 30.484400>, <6.702610, 0.671960, 30.342500>, <6.809780, 0.598437, 30.465300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.114760, 0.535710, 30.783000>, <7.184950, 0.522610, 30.879500>, <6.995390, 0.563582, 30.839200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.809780, 0.598437, 30.465300>, <6.782040, 0.607894, 30.302300>, <6.950960, 0.571880, 30.430100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249280, 0.560825, 30.712700>, <7.300250, 0.543197, 30.837900>, <7.114760, 0.535710, 30.783000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.950960, 0.571880, 30.430100>, <6.891790, 0.586981, 30.251600>, <7.091500, 0.593318, 30.380300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.332520, 0.640266, 30.665600>, <7.398650, 0.613530, 30.803800>, <7.249280, 0.560825, 30.712700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.091500, 0.593318, 30.380300>, <7.005110, 0.609946, 30.213800>, <7.171090, 0.667412, 30.349100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.368960, 0.743113, 30.647000>, <7.443640, 0.717163, 30.792000>, <7.332520, 0.640266, 30.665600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.171090, 0.667412, 30.349100>, <7.088470, 0.683434, 30.187700>, <7.202950, 0.767017, 30.335800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.249190, 0.612413, 31.077300>, <7.303040, 0.592891, 31.054700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.213400, 0.653924, 31.093900>, <7.249190, 0.612413, 31.077300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.205250, 0.706343, 31.100100>, <7.213400, 0.653924, 31.093900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.226940, 0.755669, 31.094300>, <7.205250, 0.706343, 31.100100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.272660, 0.788718, 31.077900>, <7.226940, 0.755669, 31.094300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.330150, 0.796601, 31.055400>, <7.272660, 0.788718, 31.077900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.384000, 0.777143, 31.032800>, <7.330150, 0.796601, 31.055400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.419800, 0.735546, 31.016200>, <7.384000, 0.777143, 31.032800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.428370, 0.689584, 31.009800>, <7.419800, 0.735546, 31.016200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.406250, 0.633581, 31.015800>, <7.428370, 0.689584, 31.009800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.360530, 0.600623, 31.032200>, <7.406250, 0.633581, 31.015800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331340, 0.690984, 31.081700>, <7.303040, 0.592891, 31.054700>, <7.360530, 0.600623, 31.032200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.303040, 0.592891, 31.054700>, <7.159570, 0.563235, 31.020800>, <7.252850, 0.529607, 30.981700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.303040, 0.592891, 31.054700>, <7.249190, 0.612413, 31.077300>, <7.159570, 0.563235, 31.020800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249190, 0.612413, 31.077300>, <7.097580, 0.634608, 31.049600>, <7.159570, 0.563235, 31.020800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249190, 0.612413, 31.077300>, <7.213400, 0.653924, 31.093900>, <7.097580, 0.634608, 31.049600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.213400, 0.653924, 31.093900>, <7.083460, 0.724700, 31.060400>, <7.097580, 0.634608, 31.049600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.213400, 0.653924, 31.093900>, <7.205250, 0.706343, 31.100100>, <7.083460, 0.724700, 31.060400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205250, 0.706343, 31.100100>, <7.121030, 0.809537, 31.050300>, <7.083460, 0.724700, 31.060400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205250, 0.706343, 31.100100>, <7.226940, 0.755669, 31.094300>, <7.121030, 0.809537, 31.050300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.226940, 0.755669, 31.094300>, <7.200210, 0.866460, 31.021900>, <7.121030, 0.809537, 31.050300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.226940, 0.755669, 31.094300>, <7.272660, 0.788718, 31.077900>, <7.200210, 0.866460, 31.021900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.272660, 0.788718, 31.077900>, <7.299780, 0.880125, 30.983000>, <7.200210, 0.866460, 31.021900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.272660, 0.788718, 31.077900>, <7.330150, 0.796601, 31.055400>, <7.299780, 0.880125, 30.983000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.330150, 0.796601, 31.055400>, <7.393080, 0.846697, 30.943900>, <7.299780, 0.880125, 30.983000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.330150, 0.796601, 31.055400>, <7.384000, 0.777143, 31.032800>, <7.393080, 0.846697, 30.943900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.384000, 0.777143, 31.032800>, <7.455070, 0.775074, 30.915000>, <7.393080, 0.846697, 30.943900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.384000, 0.777143, 31.032800>, <7.419800, 0.735546, 31.016200>, <7.455070, 0.775074, 30.915000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.419800, 0.735546, 31.016200>, <7.469780, 0.692537, 30.904200>, <7.455070, 0.775074, 30.915000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.419800, 0.735546, 31.016200>, <7.428370, 0.689584, 31.009800>, <7.469780, 0.692537, 30.904200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.428370, 0.689584, 31.009800>, <7.431600, 0.599488, 30.914400>, <7.469780, 0.692537, 30.904200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.428370, 0.689584, 31.009800>, <7.406250, 0.633581, 31.015800>, <7.431600, 0.599488, 30.914400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.406250, 0.633581, 31.015800>, <7.352420, 0.542817, 30.942700>, <7.431600, 0.599488, 30.914400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.406250, 0.633581, 31.015800>, <7.360530, 0.600623, 31.032200>, <7.352420, 0.542817, 30.942700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.360530, 0.600623, 31.032200>, <7.252850, 0.529607, 30.981700>, <7.352420, 0.542817, 30.942700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.360530, 0.600623, 31.032200>, <7.303040, 0.592891, 31.054700>, <7.252850, 0.529607, 30.981700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.252850, 0.529607, 30.981700>, <7.070430, 0.555826, 30.924500>, <7.184950, 0.522610, 30.879500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.252850, 0.529607, 30.981700>, <7.159570, 0.563235, 31.020800>, <7.070430, 0.555826, 30.924500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.159570, 0.563235, 31.020800>, <7.003320, 0.630464, 30.955800>, <7.070430, 0.555826, 30.924500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.159570, 0.563235, 31.020800>, <7.097580, 0.634608, 31.049600>, <7.003320, 0.630464, 30.955800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.097580, 0.634608, 31.049600>, <6.957030, 0.730982, 30.971600>, <7.003320, 0.630464, 30.955800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.097580, 0.634608, 31.049600>, <7.083460, 0.724700, 31.060400>, <6.957030, 0.730982, 30.971600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.083460, 0.724700, 31.060400>, <7.015510, 0.830511, 30.963000>, <6.957030, 0.730982, 30.971600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.083460, 0.724700, 31.060400>, <7.121030, 0.809537, 31.050300>, <7.015510, 0.830511, 30.963000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.121030, 0.809537, 31.050300>, <7.115400, 0.914865, 30.923900>, <7.015510, 0.830511, 30.963000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.121030, 0.809537, 31.050300>, <7.200210, 0.866460, 31.021900>, <7.115400, 0.914865, 30.923900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.200210, 0.866460, 31.021900>, <7.244370, 0.915717, 30.879100>, <7.115400, 0.914865, 30.923900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.200210, 0.866460, 31.021900>, <7.299780, 0.880125, 30.983000>, <7.244370, 0.915717, 30.879100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.299780, 0.880125, 30.983000>, <7.357370, 0.880778, 30.831400>, <7.244370, 0.915717, 30.879100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.299780, 0.880125, 30.983000>, <7.393080, 0.846697, 30.943900>, <7.357370, 0.880778, 30.831400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.393080, 0.846697, 30.943900>, <7.424640, 0.801278, 30.801000>, <7.357370, 0.880778, 30.831400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.393080, 0.846697, 30.943900>, <7.455070, 0.775074, 30.915000>, <7.424640, 0.801278, 30.801000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.455070, 0.775074, 30.915000>, <7.443640, 0.717163, 30.792000>, <7.424640, 0.801278, 30.801000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.455070, 0.775074, 30.915000>, <7.469780, 0.692537, 30.904200>, <7.443640, 0.717163, 30.792000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.469780, 0.692537, 30.904200>, <7.398650, 0.613530, 30.803800>, <7.443640, 0.717163, 30.792000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.469780, 0.692537, 30.904200>, <7.431600, 0.599488, 30.914400>, <7.398650, 0.613530, 30.803800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.431600, 0.599488, 30.914400>, <7.300250, 0.543197, 30.837900>, <7.398650, 0.613530, 30.803800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.431600, 0.599488, 30.914400>, <7.352420, 0.542817, 30.942700>, <7.300250, 0.543197, 30.837900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.352420, 0.542817, 30.942700>, <7.184950, 0.522610, 30.879500>, <7.300250, 0.543197, 30.837900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.352420, 0.542817, 30.942700>, <7.252850, 0.529607, 30.981700>, <7.184950, 0.522610, 30.879500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.851970, 0.706645, 30.079200>, <6.798730, 0.691658, 30.100300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.890580, 0.742942, 30.066500>, <6.851970, 0.706645, 30.079200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.904180, 0.790847, 30.065600>, <6.890580, 0.742942, 30.066500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.889160, 0.837495, 30.076800>, <6.904180, 0.790847, 30.065600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.849520, 0.870333, 30.097000>, <6.889160, 0.837495, 30.076800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.795900, 0.880535, 30.120800>, <6.849520, 0.870333, 30.097000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.742650, 0.865396, 30.141800>, <6.795900, 0.880535, 30.120800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.704060, 0.829027, 30.154500>, <6.742650, 0.865396, 30.141800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.690450, 0.781197, 30.155400>, <6.704060, 0.829027, 30.154500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.705480, 0.734700, 30.144300>, <6.690450, 0.781197, 30.155400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.745110, 0.701935, 30.124100>, <6.705480, 0.734700, 30.144300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782080, 0.788216, 30.084900>, <6.798730, 0.691658, 30.100300>, <6.745110, 0.701935, 30.124100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.798730, 0.691658, 30.100300>, <6.933620, 0.641452, 30.126400>, <6.841390, 0.615398, 30.162900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.798730, 0.691658, 30.100300>, <6.851970, 0.706645, 30.079200>, <6.933620, 0.641452, 30.126400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.851970, 0.706645, 30.079200>, <7.000470, 0.704731, 30.104400>, <6.933620, 0.641452, 30.126400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.851970, 0.706645, 30.079200>, <6.890580, 0.742942, 30.066500>, <7.000470, 0.704731, 30.104400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.890580, 0.742942, 30.066500>, <7.024030, 0.788356, 30.102900>, <7.000470, 0.704731, 30.104400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.890580, 0.742942, 30.066500>, <6.904180, 0.790847, 30.065600>, <7.024030, 0.788356, 30.102900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.904180, 0.790847, 30.065600>, <6.998020, 0.869841, 30.122200>, <7.024030, 0.788356, 30.102900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.904180, 0.790847, 30.065600>, <6.889160, 0.837495, 30.076800>, <6.998020, 0.869841, 30.122200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.889160, 0.837495, 30.076800>, <6.929380, 0.927184, 30.157100>, <6.998020, 0.869841, 30.122200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.889160, 0.837495, 30.076800>, <6.849520, 0.870333, 30.097000>, <6.929380, 0.927184, 30.157100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.849520, 0.870333, 30.097000>, <6.836490, 0.944939, 30.198300>, <6.929380, 0.927184, 30.157100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.849520, 0.870333, 30.097000>, <6.795900, 0.880535, 30.120800>, <6.836490, 0.944939, 30.198300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.795900, 0.880535, 30.120800>, <6.744270, 0.918434, 30.234800>, <6.836490, 0.944939, 30.198300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.795900, 0.880535, 30.120800>, <6.742650, 0.865396, 30.141800>, <6.744270, 0.918434, 30.234800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.742650, 0.865396, 30.141800>, <6.677410, 0.854935, 30.256800>, <6.744270, 0.918434, 30.234800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.742650, 0.865396, 30.141800>, <6.704060, 0.829027, 30.154500>, <6.677410, 0.854935, 30.256800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.704060, 0.829027, 30.154500>, <6.653840, 0.771535, 30.258300>, <6.677410, 0.854935, 30.256800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.704060, 0.829027, 30.154500>, <6.690450, 0.781197, 30.155400>, <6.653840, 0.771535, 30.258300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.690450, 0.781197, 30.155400>, <6.679870, 0.690502, 30.239000>, <6.653840, 0.771535, 30.258300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.690450, 0.781197, 30.155400>, <6.705480, 0.734700, 30.144300>, <6.679870, 0.690502, 30.239000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.705480, 0.734700, 30.144300>, <6.748510, 0.633383, 30.204100>, <6.679870, 0.690502, 30.239000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.705480, 0.734700, 30.144300>, <6.745110, 0.701935, 30.124100>, <6.748510, 0.633383, 30.204100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.745110, 0.701935, 30.124100>, <6.841390, 0.615398, 30.162900>, <6.748510, 0.633383, 30.204100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.745110, 0.701935, 30.124100>, <6.798730, 0.691658, 30.100300>, <6.841390, 0.615398, 30.162900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.841390, 0.615398, 30.162900>, <7.005110, 0.609946, 30.213800>, <6.891790, 0.586981, 30.251600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.841390, 0.615398, 30.162900>, <6.933620, 0.641452, 30.126400>, <7.005110, 0.609946, 30.213800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.933620, 0.641452, 30.126400>, <7.088470, 0.683434, 30.187700>, <7.005110, 0.609946, 30.213800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.933620, 0.641452, 30.126400>, <7.000470, 0.704731, 30.104400>, <7.088470, 0.683434, 30.187700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.000470, 0.704731, 30.104400>, <7.123370, 0.780667, 30.184900>, <7.088470, 0.683434, 30.187700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.000470, 0.704731, 30.104400>, <7.024030, 0.788356, 30.102900>, <7.123370, 0.780667, 30.184900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.024030, 0.788356, 30.102900>, <7.091790, 0.875831, 30.207400>, <7.123370, 0.780667, 30.184900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.024030, 0.788356, 30.102900>, <6.998020, 0.869841, 30.122200>, <7.091790, 0.875831, 30.207400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998020, 0.869841, 30.122200>, <7.014070, 0.942696, 30.247500>, <7.091790, 0.875831, 30.207400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.998020, 0.869841, 30.122200>, <6.929380, 0.927184, 30.157100>, <7.014070, 0.942696, 30.247500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.929380, 0.927184, 30.157100>, <6.903000, 0.961117, 30.292600>, <7.014070, 0.942696, 30.247500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.929380, 0.927184, 30.157100>, <6.836490, 0.944939, 30.198300>, <6.903000, 0.961117, 30.292600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.836490, 0.944939, 30.198300>, <6.790560, 0.930268, 30.330100>, <6.903000, 0.961117, 30.292600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.836490, 0.944939, 30.198300>, <6.744270, 0.918434, 30.234800>, <6.790560, 0.930268, 30.330100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.744270, 0.918434, 30.234800>, <6.708780, 0.860885, 30.358400>, <6.790560, 0.930268, 30.330100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.744270, 0.918434, 30.234800>, <6.677410, 0.854935, 30.256800>, <6.708780, 0.860885, 30.358400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677410, 0.854935, 30.256800>, <6.677820, 0.765328, 30.364500>, <6.708780, 0.860885, 30.358400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677410, 0.854935, 30.256800>, <6.653840, 0.771535, 30.258300>, <6.677820, 0.765328, 30.364500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.653840, 0.771535, 30.258300>, <6.702610, 0.671960, 30.342500>, <6.677820, 0.765328, 30.364500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.653840, 0.771535, 30.258300>, <6.679870, 0.690502, 30.239000>, <6.702610, 0.671960, 30.342500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.679870, 0.690502, 30.239000>, <6.782040, 0.607894, 30.302300>, <6.702610, 0.671960, 30.342500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.679870, 0.690502, 30.239000>, <6.748510, 0.633383, 30.204100>, <6.782040, 0.607894, 30.302300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.748510, 0.633383, 30.204100>, <6.891790, 0.586981, 30.251600>, <6.782040, 0.607894, 30.302300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.748510, 0.633383, 30.204100>, <6.841390, 0.615398, 30.162900>, <6.891790, 0.586981, 30.251600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.809780, 0.598437, 30.465300>, <6.895540, 0.582447, 30.671600>, <6.728010, 0.666293, 30.484400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.995390, 0.563582, 30.839200>, <6.895540, 0.582447, 30.671600>, <7.114760, 0.535710, 30.783000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.950960, 0.571880, 30.430100>, <7.045940, 0.551250, 30.625100>, <6.809780, 0.598437, 30.465300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.114760, 0.535710, 30.783000>, <7.045940, 0.551250, 30.625100>, <7.249280, 0.560825, 30.712700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.091500, 0.593318, 30.380300>, <7.170920, 0.576379, 30.552900>, <6.950960, 0.571880, 30.430100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249280, 0.560825, 30.712700>, <7.170920, 0.576379, 30.552900>, <7.332520, 0.640266, 30.665600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.895540, 0.582447, 30.671600>, <6.809780, 0.598437, 30.465300>, <7.045940, 0.551250, 30.625100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.702610, 0.671960, 30.342500>, <6.782040, 0.607894, 30.302300>, <6.809780, 0.598437, 30.465300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.045940, 0.551250, 30.625100>, <6.950960, 0.571880, 30.430100>, <7.170920, 0.576379, 30.552900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782040, 0.607894, 30.302300>, <6.891790, 0.586981, 30.251600>, <6.950960, 0.571880, 30.430100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.170920, 0.576379, 30.552900>, <7.091500, 0.593318, 30.380300>, <7.253720, 0.650839, 30.510600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.891790, 0.586981, 30.251600>, <7.005110, 0.609946, 30.213800>, <7.091500, 0.593318, 30.380300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.895540, 0.582447, 30.671600>, <6.995390, 0.563582, 30.839200>, <6.790790, 0.654163, 30.703900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.995390, 0.563582, 30.839200>, <7.184950, 0.522610, 30.879500>, <7.070430, 0.555826, 30.924500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.045940, 0.551250, 30.625100>, <7.114760, 0.535710, 30.783000>, <6.895540, 0.582447, 30.671600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.114760, 0.535710, 30.783000>, <7.300250, 0.543197, 30.837900>, <7.184950, 0.522610, 30.879500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.170920, 0.576379, 30.552900>, <7.249280, 0.560825, 30.712700>, <7.045940, 0.551250, 30.625100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.249280, 0.560825, 30.712700>, <7.398650, 0.613530, 30.803800>, <7.300250, 0.543197, 30.837900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.728010, 0.666293, 30.484400>, <6.790790, 0.654163, 30.703900>, <6.690210, 0.764381, 30.491300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.915090, 0.635858, 30.872700>, <6.790790, 0.654163, 30.703900>, <6.995390, 0.563582, 30.839200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.790790, 0.654163, 30.703900>, <6.728010, 0.666293, 30.484400>, <6.895540, 0.582447, 30.671600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677820, 0.765328, 30.364500>, <6.702610, 0.671960, 30.342500>, <6.728010, 0.666293, 30.484400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.790790, 0.654163, 30.703900>, <6.915090, 0.635858, 30.872700>, <6.750670, 0.754397, 30.709400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.915090, 0.635858, 30.872700>, <7.070430, 0.555826, 30.924500>, <7.003320, 0.630464, 30.955800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.171090, 0.667412, 30.349100>, <7.253720, 0.650839, 30.510600>, <7.091500, 0.593318, 30.380300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.332520, 0.640266, 30.665600>, <7.253720, 0.650839, 30.510600>, <7.368960, 0.743113, 30.647000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.368960, 0.743113, 30.647000>, <7.282520, 0.752869, 30.486600>, <7.352950, 0.836864, 30.653600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.202950, 0.767017, 30.335800>, <7.282520, 0.752869, 30.486600>, <7.171090, 0.667412, 30.349100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.169800, 0.865318, 30.347100>, <7.254930, 0.853732, 30.487100>, <7.202950, 0.767017, 30.335800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.352950, 0.836864, 30.653600>, <7.254930, 0.853732, 30.487100>, <7.273120, 0.902528, 30.684200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.253720, 0.650839, 30.510600>, <7.332520, 0.640266, 30.665600>, <7.170920, 0.576379, 30.552900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.332520, 0.640266, 30.665600>, <7.443640, 0.717163, 30.792000>, <7.398650, 0.613530, 30.803800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.282520, 0.752869, 30.486600>, <7.368960, 0.743113, 30.647000>, <7.253720, 0.650839, 30.510600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.368960, 0.743113, 30.647000>, <7.424640, 0.801278, 30.801000>, <7.443640, 0.717163, 30.792000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.254930, 0.853732, 30.487100>, <7.352950, 0.836864, 30.653600>, <7.282520, 0.752869, 30.486600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.352950, 0.836864, 30.653600>, <7.357370, 0.880778, 30.831400>, <7.424640, 0.801278, 30.801000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.253720, 0.650839, 30.510600>, <7.171090, 0.667412, 30.349100>, <7.282520, 0.752869, 30.486600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.005110, 0.609946, 30.213800>, <7.088470, 0.683434, 30.187700>, <7.171090, 0.667412, 30.349100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.282520, 0.752869, 30.486600>, <7.202950, 0.767017, 30.335800>, <7.254930, 0.853732, 30.487100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.088470, 0.683434, 30.187700>, <7.123370, 0.780667, 30.184900>, <7.202950, 0.767017, 30.335800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.254930, 0.853732, 30.487100>, <7.169800, 0.865318, 30.347100>, <7.167560, 0.925868, 30.510900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.123370, 0.780667, 30.184900>, <7.091790, 0.875831, 30.207400>, <7.169800, 0.865318, 30.347100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.094180, 0.934647, 30.369900>, <7.167560, 0.925868, 30.510900>, <7.169800, 0.865318, 30.347100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.273120, 0.902528, 30.684200>, <7.167560, 0.925868, 30.510900>, <7.154100, 0.936021, 30.736800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.969910, 0.956525, 30.408900>, <7.051480, 0.949143, 30.550400>, <7.094180, 0.934647, 30.369900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.154100, 0.936021, 30.736800>, <7.051480, 0.949143, 30.550400>, <7.034810, 0.913743, 30.806800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.821810, 0.932246, 30.449800>, <6.896180, 0.924811, 30.618500>, <6.969910, 0.956525, 30.408900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034810, 0.913743, 30.806800>, <6.896180, 0.924811, 30.618500>, <6.931180, 0.839909, 30.860700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.737420, 0.859993, 30.482200>, <6.795890, 0.851955, 30.681000>, <6.821810, 0.932246, 30.449800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.931180, 0.839909, 30.860700>, <6.795890, 0.851955, 30.681000>, <6.876900, 0.740183, 30.882800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.167560, 0.925868, 30.510900>, <7.273120, 0.902528, 30.684200>, <7.254930, 0.853732, 30.487100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.273120, 0.902528, 30.684200>, <7.244370, 0.915717, 30.879100>, <7.357370, 0.880778, 30.831400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.051480, 0.949143, 30.550400>, <7.154100, 0.936021, 30.736800>, <7.167560, 0.925868, 30.510900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.154100, 0.936021, 30.736800>, <7.115400, 0.914865, 30.923900>, <7.244370, 0.915717, 30.879100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.896180, 0.924811, 30.618500>, <7.034810, 0.913743, 30.806800>, <7.051480, 0.949143, 30.550400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034810, 0.913743, 30.806800>, <7.015510, 0.830511, 30.963000>, <7.115400, 0.914865, 30.923900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.167560, 0.925868, 30.510900>, <7.094180, 0.934647, 30.369900>, <7.051480, 0.949143, 30.550400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.091790, 0.875831, 30.207400>, <7.014070, 0.942696, 30.247500>, <7.094180, 0.934647, 30.369900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.051480, 0.949143, 30.550400>, <6.969910, 0.956525, 30.408900>, <6.896180, 0.924811, 30.618500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.014070, 0.942696, 30.247500>, <6.903000, 0.961117, 30.292600>, <6.969910, 0.956525, 30.408900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.896180, 0.924811, 30.618500>, <6.821810, 0.932246, 30.449800>, <6.795890, 0.851955, 30.681000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.903000, 0.961117, 30.292600>, <6.790560, 0.930268, 30.330100>, <6.821810, 0.932246, 30.449800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.795890, 0.851955, 30.681000>, <6.931180, 0.839909, 30.860700>, <6.896180, 0.924811, 30.618500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.931180, 0.839909, 30.860700>, <6.957030, 0.730982, 30.971600>, <7.015510, 0.830511, 30.963000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.795890, 0.851955, 30.681000>, <6.737420, 0.859993, 30.482200>, <6.750670, 0.754397, 30.709400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.790560, 0.930268, 30.330100>, <6.708780, 0.860885, 30.358400>, <6.737420, 0.859993, 30.482200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.690210, 0.764381, 30.491300>, <6.750670, 0.754397, 30.709400>, <6.737420, 0.859993, 30.482200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.876900, 0.740183, 30.882800>, <6.750670, 0.754397, 30.709400>, <6.915090, 0.635858, 30.872700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.750670, 0.754397, 30.709400>, <6.690210, 0.764381, 30.491300>, <6.790790, 0.654163, 30.703900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.708780, 0.860885, 30.358400>, <6.677820, 0.765328, 30.364500>, <6.690210, 0.764381, 30.491300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.750670, 0.754397, 30.709400>, <6.876900, 0.740183, 30.882800>, <6.795890, 0.851955, 30.681000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.876900, 0.740183, 30.882800>, <7.003320, 0.630464, 30.955800>, <6.957030, 0.730982, 30.971600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.417000, 0.392028, 30.633000>, <7.490820, 0.365710, 30.801700>, <7.434370, 0.291731, 30.633800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.263060, 0.293434, 30.281600>, <7.180950, 0.297019, 30.110700>, <7.227350, 0.399349, 30.285200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331390, 0.463986, 30.660500>, <7.418550, 0.452263, 30.828000>, <7.417000, 0.392028, 30.633000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.227350, 0.399349, 30.285200>, <7.146720, 0.400562, 30.126800>, <7.146340, 0.474956, 30.303400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.203820, 0.503231, 30.714600>, <7.294930, 0.492432, 30.869800>, <7.331390, 0.463986, 30.660500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.146340, 0.474956, 30.303400>, <7.063180, 0.474879, 30.164600>, <7.013420, 0.500914, 30.343200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.075800, 0.484433, 30.792900>, <7.169340, 0.494569, 30.920900>, <7.203820, 0.503231, 30.714600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013420, 0.500914, 30.343200>, <6.944230, 0.497611, 30.211700>, <6.855250, 0.477609, 30.388800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.964840, 0.409548, 30.857700>, <7.050100, 0.407593, 30.967800>, <7.075800, 0.484433, 30.792900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.855250, 0.477609, 30.388800>, <6.824070, 0.467026, 30.254500>, <6.765130, 0.402395, 30.430000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.906980, 0.304736, 30.890000>, <6.983790, 0.302080, 30.990000>, <6.964840, 0.409548, 30.857700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.765130, 0.402395, 30.430000>, <6.736770, 0.394488, 30.291100>, <6.715020, 0.300455, 30.447800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.948040, 0.192831, 30.888200>, <7.027920, 0.194214, 30.983000>, <6.906980, 0.304736, 30.890000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.715020, 0.300455, 30.447800>, <6.704000, 0.292280, 30.306000>, <6.755610, 0.194847, 30.449400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034200, 0.113450, 30.858000>, <7.111320, 0.112443, 30.951500>, <6.948040, 0.192831, 30.888200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.755610, 0.194847, 30.449400>, <6.730980, 0.190431, 30.290000>, <6.843090, 0.120904, 30.435200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.162200, 0.079895, 30.799500>, <7.235230, 0.074104, 30.909100>, <7.034200, 0.113450, 30.858000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.843090, 0.120904, 30.435200>, <6.816340, 0.118875, 30.252000>, <6.993930, 0.090366, 30.400300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.306420, 0.101876, 30.720800>, <7.358540, 0.093382, 30.862600>, <7.162200, 0.079895, 30.799500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.993930, 0.090366, 30.400300>, <6.934000, 0.093068, 30.198900>, <7.144210, 0.110221, 30.344800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.395570, 0.183365, 30.662600>, <7.463610, 0.166119, 30.820100>, <7.306420, 0.101876, 30.720800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.144210, 0.110221, 30.344800>, <7.055130, 0.115419, 30.156300>, <7.229200, 0.187640, 30.304700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.434370, 0.291731, 30.633800>, <7.511400, 0.275674, 30.798900>, <7.395570, 0.183365, 30.662600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.229200, 0.187640, 30.304700>, <7.144040, 0.192764, 30.121800>, <7.263060, 0.293434, 30.281600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.299960, 0.186214, 31.123200>, <7.357680, 0.163951, 31.100400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.261500, 0.231457, 31.137900>, <7.299960, 0.186214, 31.123200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.252600, 0.287573, 31.140400>, <7.261500, 0.231457, 31.137900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.275650, 0.339558, 31.130100>, <7.252600, 0.287573, 31.140400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.324470, 0.373523, 31.109800>, <7.275650, 0.339558, 31.130100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.385980, 0.380353, 31.084900>, <7.324470, 0.373523, 31.109800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.443700, 0.358172, 31.062100>, <7.385980, 0.380353, 31.084900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.482150, 0.312903, 31.047400>, <7.443700, 0.358172, 31.062100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.491510, 0.263671, 31.044200>, <7.482150, 0.312903, 31.047400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.468010, 0.204602, 31.055200>, <7.491510, 0.263671, 31.044200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.419190, 0.170666, 31.075500>, <7.468010, 0.204602, 31.055200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.387060, 0.270463, 31.122900>, <7.357680, 0.163951, 31.100400>, <7.419190, 0.170666, 31.075500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.357680, 0.163951, 31.100400>, <7.205730, 0.128740, 31.063000>, <7.305700, 0.090335, 31.023500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.357680, 0.163951, 31.100400>, <7.299960, 0.186214, 31.123200>, <7.205730, 0.128740, 31.063000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.299960, 0.186214, 31.123200>, <7.139110, 0.206656, 31.088400>, <7.205730, 0.128740, 31.063000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.299960, 0.186214, 31.123200>, <7.261500, 0.231457, 31.137900>, <7.139110, 0.206656, 31.088400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.261500, 0.231457, 31.137900>, <7.123690, 0.303235, 31.092800>, <7.139110, 0.206656, 31.088400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.261500, 0.231457, 31.137900>, <7.252600, 0.287573, 31.140400>, <7.123690, 0.303235, 31.092800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.252600, 0.287573, 31.140400>, <7.163610, 0.392727, 31.075000>, <7.123690, 0.303235, 31.092800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.252600, 0.287573, 31.140400>, <7.275650, 0.339558, 31.130100>, <7.163610, 0.392727, 31.075000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.275650, 0.339558, 31.130100>, <7.248180, 0.451247, 31.039800>, <7.163610, 0.392727, 31.075000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.275650, 0.339558, 31.130100>, <7.324470, 0.373523, 31.109800>, <7.248180, 0.451247, 31.039800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.324470, 0.373523, 31.109800>, <7.354710, 0.463085, 30.996700>, <7.248180, 0.451247, 31.039800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.324470, 0.373523, 31.109800>, <7.385980, 0.380353, 31.084900>, <7.354710, 0.463085, 30.996700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.385980, 0.380353, 31.084900>, <7.454690, 0.424934, 30.957100>, <7.354710, 0.463085, 30.996700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.385980, 0.380353, 31.084900>, <7.443700, 0.358172, 31.062100>, <7.454690, 0.424934, 30.957100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.443700, 0.358172, 31.062100>, <7.521310, 0.346938, 30.931700>, <7.454690, 0.424934, 30.957100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.443700, 0.358172, 31.062100>, <7.482150, 0.312903, 31.047400>, <7.521310, 0.346938, 30.931700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.482150, 0.312903, 31.047400>, <7.537350, 0.258523, 30.926600>, <7.521310, 0.346938, 30.931700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.482150, 0.312903, 31.047400>, <7.491510, 0.263671, 31.044200>, <7.537350, 0.258523, 30.926600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.491510, 0.263671, 31.044200>, <7.496790, 0.160266, 30.945100>, <7.537350, 0.258523, 30.926600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.491510, 0.263671, 31.044200>, <7.468010, 0.204602, 31.055200>, <7.496790, 0.160266, 30.945100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.468010, 0.204602, 31.055200>, <7.412240, 0.101829, 30.980300>, <7.496790, 0.160266, 30.945100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.468010, 0.204602, 31.055200>, <7.419190, 0.170666, 31.075500>, <7.412240, 0.101829, 30.980300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.419190, 0.170666, 31.075500>, <7.305700, 0.090335, 31.023500>, <7.412240, 0.101829, 30.980300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.419190, 0.170666, 31.075500>, <7.357680, 0.163951, 31.100400>, <7.305700, 0.090335, 31.023500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.305700, 0.090335, 31.023500>, <7.111320, 0.112443, 30.951500>, <7.235230, 0.074104, 30.909100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.305700, 0.090335, 31.023500>, <7.205730, 0.128740, 31.063000>, <7.111320, 0.112443, 30.951500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205730, 0.128740, 31.063000>, <7.027920, 0.194214, 30.983000>, <7.111320, 0.112443, 30.951500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.205730, 0.128740, 31.063000>, <7.139110, 0.206656, 31.088400>, <7.027920, 0.194214, 30.983000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.139110, 0.206656, 31.088400>, <6.983790, 0.302080, 30.990000>, <7.027920, 0.194214, 30.983000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.139110, 0.206656, 31.088400>, <7.123690, 0.303235, 31.092800>, <6.983790, 0.302080, 30.990000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.123690, 0.303235, 31.092800>, <7.050100, 0.407593, 30.967800>, <6.983790, 0.302080, 30.990000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.123690, 0.303235, 31.092800>, <7.163610, 0.392727, 31.075000>, <7.050100, 0.407593, 30.967800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.163610, 0.392727, 31.075000>, <7.169340, 0.494569, 30.920900>, <7.050100, 0.407593, 30.967800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.163610, 0.392727, 31.075000>, <7.248180, 0.451247, 31.039800>, <7.169340, 0.494569, 30.920900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.248180, 0.451247, 31.039800>, <7.294930, 0.492432, 30.869800>, <7.169340, 0.494569, 30.920900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.248180, 0.451247, 31.039800>, <7.354710, 0.463085, 30.996700>, <7.294930, 0.492432, 30.869800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.354710, 0.463085, 30.996700>, <7.418550, 0.452263, 30.828000>, <7.294930, 0.492432, 30.869800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.354710, 0.463085, 30.996700>, <7.454690, 0.424934, 30.957100>, <7.418550, 0.452263, 30.828000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.454690, 0.424934, 30.957100>, <7.490820, 0.365710, 30.801700>, <7.418550, 0.452263, 30.828000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.454690, 0.424934, 30.957100>, <7.521310, 0.346938, 30.931700>, <7.490820, 0.365710, 30.801700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.521310, 0.346938, 30.931700>, <7.511400, 0.275674, 30.798900>, <7.490820, 0.365710, 30.801700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.521310, 0.346938, 30.931700>, <7.537350, 0.258523, 30.926600>, <7.511400, 0.275674, 30.798900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.537350, 0.258523, 30.926600>, <7.463610, 0.166119, 30.820100>, <7.511400, 0.275674, 30.798900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.537350, 0.258523, 30.926600>, <7.496790, 0.160266, 30.945100>, <7.463610, 0.166119, 30.820100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.496790, 0.160266, 30.945100>, <7.358540, 0.093382, 30.862600>, <7.463610, 0.166119, 30.820100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.496790, 0.160266, 30.945100>, <7.412240, 0.101829, 30.980300>, <7.358540, 0.093382, 30.862600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.412240, 0.101829, 30.980300>, <7.235230, 0.074104, 30.909100>, <7.358540, 0.093382, 30.862600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.412240, 0.101829, 30.980300>, <7.305700, 0.090335, 31.023500>, <7.235230, 0.074104, 30.909100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.894270, 0.209417, 29.995100>, <6.837320, 0.194624, 30.019200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.935450, 0.247691, 29.978300>, <6.894270, 0.209417, 29.995100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.949810, 0.299194, 29.973100>, <6.935450, 0.247691, 29.978300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.933510, 0.350098, 29.981200>, <6.949810, 0.299194, 29.973100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.890920, 0.386723, 30.000200>, <6.933510, 0.350098, 29.981200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.833450, 0.399249, 30.025000>, <6.890920, 0.386723, 30.000200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.776500, 0.384351, 30.049100>, <6.833450, 0.399249, 30.025000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.735330, 0.346059, 30.066000>, <6.776500, 0.384351, 30.049100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.720970, 0.294639, 30.071100>, <6.735330, 0.346059, 30.066000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.737260, 0.243840, 30.063100>, <6.720970, 0.294639, 30.071100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.779860, 0.207233, 30.044100>, <6.737260, 0.243840, 30.063100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.819610, 0.297487, 29.993000>, <6.837320, 0.194624, 30.019200>, <6.779860, 0.207233, 30.044100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.837320, 0.194624, 30.019200>, <6.980490, 0.142774, 30.054800>, <6.881840, 0.117046, 30.096600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.837320, 0.194624, 30.019200>, <6.894270, 0.209417, 29.995100>, <6.980490, 0.142774, 30.054800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.894270, 0.209417, 29.995100>, <7.051790, 0.209479, 30.025600>, <6.980490, 0.142774, 30.054800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.894270, 0.209417, 29.995100>, <6.935450, 0.247691, 29.978300>, <7.051790, 0.209479, 30.025600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.935450, 0.247691, 29.978300>, <7.076670, 0.299305, 30.016800>, <7.051790, 0.209479, 30.025600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.935450, 0.247691, 29.978300>, <6.949810, 0.299194, 29.973100>, <7.076670, 0.299305, 30.016800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.949810, 0.299194, 29.973100>, <7.048440, 0.388096, 30.030700>, <7.076670, 0.299305, 30.016800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.949810, 0.299194, 29.973100>, <6.933510, 0.350098, 29.981200>, <7.048440, 0.388096, 30.030700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.933510, 0.350098, 29.981200>, <6.974680, 0.451946, 30.063600>, <7.048440, 0.388096, 30.030700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.933510, 0.350098, 29.981200>, <6.890920, 0.386723, 30.000200>, <6.974680, 0.451946, 30.063600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.890920, 0.386723, 30.000200>, <6.875130, 0.473726, 30.106600>, <6.974680, 0.451946, 30.063600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.890920, 0.386723, 30.000200>, <6.833450, 0.399249, 30.025000>, <6.875130, 0.473726, 30.106600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.833450, 0.399249, 30.025000>, <6.776490, 0.447692, 30.148400>, <6.875130, 0.473726, 30.106600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.833450, 0.399249, 30.025000>, <6.776500, 0.384351, 30.049100>, <6.776490, 0.447692, 30.148400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776500, 0.384351, 30.049100>, <6.705170, 0.380932, 30.177600>, <6.776490, 0.447692, 30.148400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776500, 0.384351, 30.049100>, <6.735330, 0.346059, 30.066000>, <6.705170, 0.380932, 30.177600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.735330, 0.346059, 30.066000>, <6.680290, 0.291355, 30.186400>, <6.705170, 0.380932, 30.177600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.735330, 0.346059, 30.066000>, <6.720970, 0.294639, 30.071100>, <6.680290, 0.291355, 30.186400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.720970, 0.294639, 30.071100>, <6.708520, 0.202873, 30.172500>, <6.680290, 0.291355, 30.186400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.720970, 0.294639, 30.071100>, <6.737260, 0.243840, 30.063100>, <6.708520, 0.202873, 30.172500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.737260, 0.243840, 30.063100>, <6.782290, 0.139078, 30.139600>, <6.708520, 0.202873, 30.172500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.737260, 0.243840, 30.063100>, <6.779860, 0.207233, 30.044100>, <6.782290, 0.139078, 30.139600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.779860, 0.207233, 30.044100>, <6.881840, 0.117046, 30.096600>, <6.782290, 0.139078, 30.139600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.779860, 0.207233, 30.044100>, <6.837320, 0.194624, 30.019200>, <6.881840, 0.117046, 30.096600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.881840, 0.117046, 30.096600>, <7.055130, 0.115419, 30.156300>, <6.934000, 0.093068, 30.198900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.881840, 0.117046, 30.096600>, <6.980490, 0.142774, 30.054800>, <7.055130, 0.115419, 30.156300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.980490, 0.142774, 30.054800>, <7.144040, 0.192764, 30.121800>, <7.055130, 0.115419, 30.156300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.980490, 0.142774, 30.054800>, <7.051790, 0.209479, 30.025600>, <7.144040, 0.192764, 30.121800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.051790, 0.209479, 30.025600>, <7.180950, 0.297019, 30.110700>, <7.144040, 0.192764, 30.121800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.051790, 0.209479, 30.025600>, <7.076670, 0.299305, 30.016800>, <7.180950, 0.297019, 30.110700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.076670, 0.299305, 30.016800>, <7.146720, 0.400562, 30.126800>, <7.180950, 0.297019, 30.110700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.076670, 0.299305, 30.016800>, <7.048440, 0.388096, 30.030700>, <7.146720, 0.400562, 30.126800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.048440, 0.388096, 30.030700>, <7.063180, 0.474879, 30.164600>, <7.146720, 0.400562, 30.126800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.048440, 0.388096, 30.030700>, <6.974680, 0.451946, 30.063600>, <7.063180, 0.474879, 30.164600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.974680, 0.451946, 30.063600>, <6.944230, 0.497611, 30.211700>, <7.063180, 0.474879, 30.164600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.974680, 0.451946, 30.063600>, <6.875130, 0.473726, 30.106600>, <6.944230, 0.497611, 30.211700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.875130, 0.473726, 30.106600>, <6.824070, 0.467026, 30.254500>, <6.944230, 0.497611, 30.211700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.875130, 0.473726, 30.106600>, <6.776490, 0.447692, 30.148400>, <6.824070, 0.467026, 30.254500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776490, 0.447692, 30.148400>, <6.736770, 0.394488, 30.291100>, <6.824070, 0.467026, 30.254500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776490, 0.447692, 30.148400>, <6.705170, 0.380932, 30.177600>, <6.736770, 0.394488, 30.291100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.705170, 0.380932, 30.177600>, <6.704000, 0.292280, 30.306000>, <6.736770, 0.394488, 30.291100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.705170, 0.380932, 30.177600>, <6.680290, 0.291355, 30.186400>, <6.704000, 0.292280, 30.306000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.680290, 0.291355, 30.186400>, <6.730980, 0.190431, 30.290000>, <6.704000, 0.292280, 30.306000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.680290, 0.291355, 30.186400>, <6.708520, 0.202873, 30.172500>, <6.730980, 0.190431, 30.290000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.708520, 0.202873, 30.172500>, <6.816340, 0.118875, 30.252000>, <6.730980, 0.190431, 30.290000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.708520, 0.202873, 30.172500>, <6.782290, 0.139078, 30.139600>, <6.816340, 0.118875, 30.252000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782290, 0.139078, 30.139600>, <6.934000, 0.093068, 30.198900>, <6.816340, 0.118875, 30.252000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.782290, 0.139078, 30.139600>, <6.881840, 0.117046, 30.096600>, <6.934000, 0.093068, 30.198900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.843090, 0.120904, 30.435200>, <6.930810, 0.119903, 30.668000>, <6.755610, 0.194847, 30.449400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034200, 0.113450, 30.858000>, <6.930810, 0.119903, 30.668000>, <7.162200, 0.079895, 30.799500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.993930, 0.090366, 30.400300>, <7.091660, 0.083669, 30.621000>, <6.843090, 0.120904, 30.435200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.162200, 0.079895, 30.799500>, <7.091660, 0.083669, 30.621000>, <7.306420, 0.101876, 30.720800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.144210, 0.110221, 30.344800>, <7.225760, 0.105586, 30.540000>, <6.993930, 0.090366, 30.400300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.306420, 0.101876, 30.720800>, <7.225760, 0.105586, 30.540000>, <7.395570, 0.183365, 30.662600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.930810, 0.119903, 30.668000>, <6.843090, 0.120904, 30.435200>, <7.091660, 0.083669, 30.621000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.730980, 0.190431, 30.290000>, <6.816340, 0.118875, 30.252000>, <6.843090, 0.120904, 30.435200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.091660, 0.083669, 30.621000>, <6.993930, 0.090366, 30.400300>, <7.225760, 0.105586, 30.540000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.816340, 0.118875, 30.252000>, <6.934000, 0.093068, 30.198900>, <6.993930, 0.090366, 30.400300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.225760, 0.105586, 30.540000>, <7.144210, 0.110221, 30.344800>, <7.314370, 0.182352, 30.487500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.934000, 0.093068, 30.198900>, <7.055130, 0.115419, 30.156300>, <7.144210, 0.110221, 30.344800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.930810, 0.119903, 30.668000>, <7.034200, 0.113450, 30.858000>, <6.818650, 0.198655, 30.696300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034200, 0.113450, 30.858000>, <7.235230, 0.074104, 30.909100>, <7.111320, 0.112443, 30.951500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.091660, 0.083669, 30.621000>, <7.162200, 0.079895, 30.799500>, <6.930810, 0.119903, 30.668000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.162200, 0.079895, 30.799500>, <7.358540, 0.093382, 30.862600>, <7.235230, 0.074104, 30.909100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.225760, 0.105586, 30.540000>, <7.306420, 0.101876, 30.720800>, <7.091660, 0.083669, 30.621000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.306420, 0.101876, 30.720800>, <7.463610, 0.166119, 30.820100>, <7.358540, 0.093382, 30.862600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.755610, 0.194847, 30.449400>, <6.818650, 0.198655, 30.696300>, <6.715020, 0.300455, 30.447800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.948040, 0.192831, 30.888200>, <6.818650, 0.198655, 30.696300>, <7.034200, 0.113450, 30.858000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.818650, 0.198655, 30.696300>, <6.755610, 0.194847, 30.449400>, <6.930810, 0.119903, 30.668000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.704000, 0.292280, 30.306000>, <6.730980, 0.190431, 30.290000>, <6.755610, 0.194847, 30.449400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.818650, 0.198655, 30.696300>, <6.948040, 0.192831, 30.888200>, <6.775630, 0.306141, 30.693300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.948040, 0.192831, 30.888200>, <7.111320, 0.112443, 30.951500>, <7.027920, 0.194214, 30.983000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.229200, 0.187640, 30.304700>, <7.314370, 0.182352, 30.487500>, <7.144210, 0.110221, 30.344800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.395570, 0.183365, 30.662600>, <7.314370, 0.182352, 30.487500>, <7.434370, 0.291731, 30.633800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.434370, 0.291731, 30.633800>, <7.345150, 0.289682, 30.452500>, <7.417000, 0.392028, 30.633000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.263060, 0.293434, 30.281600>, <7.345150, 0.289682, 30.452500>, <7.229200, 0.187640, 30.304700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.227350, 0.399349, 30.285200>, <7.315530, 0.397324, 30.444000>, <7.263060, 0.293434, 30.281600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.417000, 0.392028, 30.633000>, <7.315530, 0.397324, 30.444000>, <7.331390, 0.463986, 30.660500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.314370, 0.182352, 30.487500>, <7.395570, 0.183365, 30.662600>, <7.225760, 0.105586, 30.540000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.395570, 0.183365, 30.662600>, <7.511400, 0.275674, 30.798900>, <7.463610, 0.166119, 30.820100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.345150, 0.289682, 30.452500>, <7.434370, 0.291731, 30.633800>, <7.314370, 0.182352, 30.487500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.434370, 0.291731, 30.633800>, <7.490820, 0.365710, 30.801700>, <7.511400, 0.275674, 30.798900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.315530, 0.397324, 30.444000>, <7.417000, 0.392028, 30.633000>, <7.345150, 0.289682, 30.452500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.417000, 0.392028, 30.633000>, <7.418550, 0.452263, 30.828000>, <7.490820, 0.365710, 30.801700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.314370, 0.182352, 30.487500>, <7.229200, 0.187640, 30.304700>, <7.345150, 0.289682, 30.452500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.055130, 0.115419, 30.156300>, <7.144040, 0.192764, 30.121800>, <7.229200, 0.187640, 30.304700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.345150, 0.289682, 30.452500>, <7.263060, 0.293434, 30.281600>, <7.315530, 0.397324, 30.444000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.144040, 0.192764, 30.121800>, <7.180950, 0.297019, 30.110700>, <7.263060, 0.293434, 30.281600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.315530, 0.397324, 30.444000>, <7.227350, 0.399349, 30.285200>, <7.222010, 0.475825, 30.463000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.180950, 0.297019, 30.110700>, <7.146720, 0.400562, 30.126800>, <7.227350, 0.399349, 30.285200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.146340, 0.474956, 30.303400>, <7.222010, 0.475825, 30.463000>, <7.227350, 0.399349, 30.285200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331390, 0.463986, 30.660500>, <7.222010, 0.475825, 30.463000>, <7.203820, 0.503231, 30.714600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013420, 0.500914, 30.343200>, <7.097790, 0.503292, 30.503500>, <7.146340, 0.474956, 30.303400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.203820, 0.503231, 30.714600>, <7.097790, 0.503292, 30.503500>, <7.075800, 0.484433, 30.792900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.855250, 0.477609, 30.388800>, <6.931490, 0.481935, 30.579300>, <7.013420, 0.500914, 30.343200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.075800, 0.484433, 30.792900>, <6.931490, 0.481935, 30.579300>, <6.964840, 0.409548, 30.857700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.765130, 0.402395, 30.430000>, <6.823950, 0.408454, 30.653900>, <6.855250, 0.477609, 30.388800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.964840, 0.409548, 30.857700>, <6.823950, 0.408454, 30.653900>, <6.906980, 0.304736, 30.890000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.222010, 0.475825, 30.463000>, <7.331390, 0.463986, 30.660500>, <7.315530, 0.397324, 30.444000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.331390, 0.463986, 30.660500>, <7.294930, 0.492432, 30.869800>, <7.418550, 0.452263, 30.828000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.097790, 0.503292, 30.503500>, <7.203820, 0.503231, 30.714600>, <7.222010, 0.475825, 30.463000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.203820, 0.503231, 30.714600>, <7.169340, 0.494569, 30.920900>, <7.294930, 0.492432, 30.869800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.931490, 0.481935, 30.579300>, <7.075800, 0.484433, 30.792900>, <7.097790, 0.503292, 30.503500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.075800, 0.484433, 30.792900>, <7.050100, 0.407593, 30.967800>, <7.169340, 0.494569, 30.920900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.222010, 0.475825, 30.463000>, <7.146340, 0.474956, 30.303400>, <7.097790, 0.503292, 30.503500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.146720, 0.400562, 30.126800>, <7.063180, 0.474879, 30.164600>, <7.146340, 0.474956, 30.303400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.097790, 0.503292, 30.503500>, <7.013420, 0.500914, 30.343200>, <6.931490, 0.481935, 30.579300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.063180, 0.474879, 30.164600>, <6.944230, 0.497611, 30.211700>, <7.013420, 0.500914, 30.343200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.931490, 0.481935, 30.579300>, <6.855250, 0.477609, 30.388800>, <6.823950, 0.408454, 30.653900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.944230, 0.497611, 30.211700>, <6.824070, 0.467026, 30.254500>, <6.855250, 0.477609, 30.388800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.823950, 0.408454, 30.653900>, <6.964840, 0.409548, 30.857700>, <6.931490, 0.481935, 30.579300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.964840, 0.409548, 30.857700>, <6.983790, 0.302080, 30.990000>, <7.050100, 0.407593, 30.967800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.823950, 0.408454, 30.653900>, <6.765130, 0.402395, 30.430000>, <6.775630, 0.306141, 30.693300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.824070, 0.467026, 30.254500>, <6.736770, 0.394488, 30.291100>, <6.765130, 0.402395, 30.430000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.715020, 0.300455, 30.447800>, <6.775630, 0.306141, 30.693300>, <6.765130, 0.402395, 30.430000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.906980, 0.304736, 30.890000>, <6.775630, 0.306141, 30.693300>, <6.948040, 0.192831, 30.888200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.775630, 0.306141, 30.693300>, <6.715020, 0.300455, 30.447800>, <6.818650, 0.198655, 30.696300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.736770, 0.394488, 30.291100>, <6.704000, 0.292280, 30.306000>, <6.715020, 0.300455, 30.447800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.775630, 0.306141, 30.693300>, <6.906980, 0.304736, 30.890000>, <6.823950, 0.408454, 30.653900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.906980, 0.304736, 30.890000>, <7.027920, 0.194214, 30.983000>, <6.983790, 0.302080, 30.990000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.242990, -0.117605, 30.750400>, <7.294150, -0.113892, 30.875200>, <7.262090, -0.222702, 30.758200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.124250, -0.226597, 30.461300>, <7.055330, -0.228607, 30.312800>, <7.089960, -0.124293, 30.462900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.157360, -0.040502, 30.765900>, <7.211530, -0.036583, 30.876500>, <7.242990, -0.117605, 30.750400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.089960, -0.124293, 30.462900>, <7.021900, -0.128885, 30.325400>, <7.013510, -0.052057, 30.479200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034220, -0.011064, 30.813500>, <7.090090, -0.005831, 30.908900>, <7.157360, -0.040502, 30.765900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013510, -0.052057, 30.479200>, <6.942310, -0.057804, 30.359100>, <6.888690, -0.028451, 30.517100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.915080, -0.033832, 30.891000>, <6.974670, -0.028362, 30.967000>, <7.034220, -0.011064, 30.813500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.888690, -0.028451, 30.517100>, <6.830140, -0.036910, 30.403200>, <6.740840, -0.052545, 30.562000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.821200, -0.105117, 30.970200>, <6.894910, -0.099196, 31.070500>, <6.915080, -0.033832, 30.891000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.740840, -0.052545, 30.562000>, <6.717620, -0.067150, 30.444800>, <6.656640, -0.124907, 30.602400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.796350, -0.207096, 31.018200>, <6.869460, -0.203140, 31.116800>, <6.821200, -0.105117, 30.970200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.656640, -0.124907, 30.602400>, <6.636200, -0.136727, 30.481100>, <6.630220, -0.222546, 30.621900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.842900, -0.315326, 31.016100>, <6.910750, -0.312673, 31.121400>, <6.796350, -0.207096, 31.018200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.630220, -0.222546, 30.621900>, <6.606410, -0.234050, 30.497500>, <6.668830, -0.323007, 30.624800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.921460, -0.391083, 30.992800>, <6.991480, -0.388796, 31.115300>, <6.842900, -0.315326, 31.016100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.668830, -0.323007, 30.624800>, <6.633130, -0.331123, 30.485200>, <6.758900, -0.393536, 30.611800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.032060, -0.420771, 30.958400>, <7.112880, -0.418962, 31.082200>, <6.921460, -0.391083, 30.992800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.758900, -0.393536, 30.611800>, <6.714380, -0.399627, 30.451200>, <6.872750, -0.422763, 30.577800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.165320, -0.400477, 30.879900>, <7.223210, -0.396145, 31.027800>, <7.032060, -0.420771, 30.958400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.872750, -0.422763, 30.577800>, <6.825620, -0.424814, 30.401900>, <7.013750, -0.403897, 30.524500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.235680, -0.326803, 30.802800>, <7.306950, -0.324663, 30.961700>, <7.165320, -0.400477, 30.879900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013750, -0.403897, 30.524500>, <6.939110, -0.403598, 30.360700>, <7.093150, -0.329086, 30.485000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.262090, -0.222702, 30.758200>, <7.331010, -0.220798, 30.906600>, <7.235680, -0.326803, 30.802800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.093150, -0.329086, 30.485000>, <7.021870, -0.329244, 30.326100>, <7.124250, -0.226597, 30.461300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.143440, -0.232972, 31.219300>, <7.200860, -0.251951, 31.202600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.099650, -0.192154, 31.220700>, <7.143440, -0.232972, 31.219300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.081200, -0.140446, 31.206400>, <7.099650, -0.192154, 31.220700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.093070, -0.091689, 31.180200>, <7.081200, -0.140446, 31.206400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.132060, -0.058959, 31.149100>, <7.093070, -0.091689, 31.180200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.187730, -0.051020, 31.121500>, <7.132060, -0.058959, 31.149100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.245150, -0.070005, 31.104800>, <7.187730, -0.051020, 31.121500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.288950, -0.110821, 31.103400>, <7.245150, -0.070005, 31.104800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.307390, -0.162531, 31.117800>, <7.288950, -0.110821, 31.103400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.295520, -0.211288, 31.144000>, <7.307390, -0.162531, 31.117800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.256530, -0.244018, 31.175000>, <7.295520, -0.211288, 31.144000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.207420, -0.140921, 31.186400>, <7.200860, -0.251951, 31.202600>, <7.256530, -0.244018, 31.175000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.200860, -0.251951, 31.202600>, <7.070340, -0.321505, 31.194700>, <7.169810, -0.354386, 31.165800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.200860, -0.251951, 31.202600>, <7.143440, -0.232972, 31.219300>, <7.070340, -0.321505, 31.194700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143440, -0.232972, 31.219300>, <6.994480, -0.250810, 31.197100>, <7.070340, -0.321505, 31.194700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.143440, -0.232972, 31.219300>, <7.099650, -0.192154, 31.220700>, <6.994480, -0.250810, 31.197100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.099650, -0.192154, 31.220700>, <6.962550, -0.161239, 31.172300>, <6.994480, -0.250810, 31.197100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.099650, -0.192154, 31.220700>, <7.081200, -0.140446, 31.206400>, <6.962550, -0.161239, 31.172300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.081200, -0.140446, 31.206400>, <6.983100, -0.076799, 31.126900>, <6.962550, -0.161239, 31.172300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.081200, -0.140446, 31.206400>, <7.093070, -0.091689, 31.180200>, <6.983100, -0.076799, 31.126900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.093070, -0.091689, 31.180200>, <7.050630, -0.020112, 31.073100>, <6.983100, -0.076799, 31.126900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.093070, -0.091689, 31.180200>, <7.132060, -0.058959, 31.149100>, <7.050630, -0.020112, 31.073100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.132060, -0.058959, 31.149100>, <7.147040, -0.006365, 31.025300>, <7.050630, -0.020112, 31.073100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.132060, -0.058959, 31.149100>, <7.187730, -0.051020, 31.121500>, <7.147040, -0.006365, 31.025300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.187730, -0.051020, 31.121500>, <7.246520, -0.039240, 30.996400>, <7.147040, -0.006365, 31.025300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.187730, -0.051020, 31.121500>, <7.245150, -0.070005, 31.104800>, <7.246520, -0.039240, 30.996400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.245150, -0.070005, 31.104800>, <7.322370, -0.109937, 30.994000>, <7.246520, -0.039240, 30.996400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.245150, -0.070005, 31.104800>, <7.288950, -0.110821, 31.103400>, <7.322370, -0.109937, 30.994000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.288950, -0.110821, 31.103400>, <7.354300, -0.199505, 31.018800>, <7.322370, -0.109937, 30.994000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.288950, -0.110821, 31.103400>, <7.307390, -0.162531, 31.117800>, <7.354300, -0.199505, 31.018800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.307390, -0.162531, 31.117800>, <7.333760, -0.283948, 31.064200>, <7.354300, -0.199505, 31.018800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.307390, -0.162531, 31.117800>, <7.295520, -0.211288, 31.144000>, <7.333760, -0.283948, 31.064200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.295520, -0.211288, 31.144000>, <7.266220, -0.340638, 31.118000>, <7.333760, -0.283948, 31.064200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.295520, -0.211288, 31.144000>, <7.256530, -0.244018, 31.175000>, <7.266220, -0.340638, 31.118000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.256530, -0.244018, 31.175000>, <7.169810, -0.354386, 31.165800>, <7.266220, -0.340638, 31.118000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.256530, -0.244018, 31.175000>, <7.200860, -0.251951, 31.202600>, <7.169810, -0.354386, 31.165800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.169810, -0.354386, 31.165800>, <6.991480, -0.388796, 31.115300>, <7.112880, -0.418962, 31.082200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.169810, -0.354386, 31.165800>, <7.070340, -0.321505, 31.194700>, <6.991480, -0.388796, 31.115300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.070340, -0.321505, 31.194700>, <6.910750, -0.312673, 31.121400>, <6.991480, -0.388796, 31.115300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.070340, -0.321505, 31.194700>, <6.994480, -0.250810, 31.197100>, <6.910750, -0.312673, 31.121400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994480, -0.250810, 31.197100>, <6.869460, -0.203140, 31.116800>, <6.910750, -0.312673, 31.121400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.994480, -0.250810, 31.197100>, <6.962550, -0.161239, 31.172300>, <6.869460, -0.203140, 31.116800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.962550, -0.161239, 31.172300>, <6.894910, -0.099196, 31.070500>, <6.869460, -0.203140, 31.116800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.962550, -0.161239, 31.172300>, <6.983100, -0.076799, 31.126900>, <6.894910, -0.099196, 31.070500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.983100, -0.076799, 31.126900>, <6.974670, -0.028362, 30.967000>, <6.894910, -0.099196, 31.070500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.983100, -0.076799, 31.126900>, <7.050630, -0.020112, 31.073100>, <6.974670, -0.028362, 30.967000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.050630, -0.020112, 31.073100>, <7.090090, -0.005831, 30.908900>, <6.974670, -0.028362, 30.967000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.050630, -0.020112, 31.073100>, <7.147040, -0.006365, 31.025300>, <7.090090, -0.005831, 30.908900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.147040, -0.006365, 31.025300>, <7.211530, -0.036583, 30.876500>, <7.090090, -0.005831, 30.908900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.147040, -0.006365, 31.025300>, <7.246520, -0.039240, 30.996400>, <7.211530, -0.036583, 30.876500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.246520, -0.039240, 30.996400>, <7.294150, -0.113892, 30.875200>, <7.211530, -0.036583, 30.876500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.246520, -0.039240, 30.996400>, <7.322370, -0.109937, 30.994000>, <7.294150, -0.113892, 30.875200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.322370, -0.109937, 30.994000>, <7.331010, -0.220798, 30.906600>, <7.294150, -0.113892, 30.875200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.322370, -0.109937, 30.994000>, <7.354300, -0.199505, 31.018800>, <7.331010, -0.220798, 30.906600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.354300, -0.199505, 31.018800>, <7.306950, -0.324663, 30.961700>, <7.331010, -0.220798, 30.906600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.354300, -0.199505, 31.018800>, <7.333760, -0.283948, 31.064200>, <7.306950, -0.324663, 30.961700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.333760, -0.283948, 31.064200>, <7.223210, -0.396145, 31.027800>, <7.306950, -0.324663, 30.961700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.333760, -0.283948, 31.064200>, <7.266220, -0.340638, 31.118000>, <7.223210, -0.396145, 31.027800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.266220, -0.340638, 31.118000>, <7.112880, -0.418962, 31.082200>, <7.223210, -0.396145, 31.027800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.266220, -0.340638, 31.118000>, <7.169810, -0.354386, 31.165800>, <7.112880, -0.418962, 31.082200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.796010, -0.318390, 30.220800>, <6.742530, -0.332400, 30.243800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.834340, -0.281923, 30.203900>, <6.796010, -0.318390, 30.220800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.847260, -0.232786, 30.197700>, <6.834340, -0.281923, 30.203900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.831310, -0.184275, 30.204000>, <6.847260, -0.232786, 30.197700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.790750, -0.149528, 30.220900>, <6.831310, -0.184275, 30.204000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.736450, -0.137832, 30.244000>, <6.790750, -0.149528, 30.220900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.682970, -0.152197, 30.267100>, <6.736450, -0.137832, 30.244000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.644640, -0.188632, 30.284000>, <6.682970, -0.152197, 30.267100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.631720, -0.237401, 30.290100>, <6.644640, -0.188632, 30.284000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.647680, -0.285559, 30.283900>, <6.631720, -0.237401, 30.290100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.688240, -0.320336, 30.266900>, <6.647680, -0.285559, 30.283900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.726090, -0.235455, 30.218700>, <6.742530, -0.332400, 30.243800>, <6.688240, -0.320336, 30.266900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.742530, -0.332400, 30.243800>, <6.873980, -0.380029, 30.272700>, <6.781350, -0.404322, 30.312700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.742530, -0.332400, 30.243800>, <6.796010, -0.318390, 30.220800>, <6.873980, -0.380029, 30.272700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.796010, -0.318390, 30.220800>, <6.940380, -0.316241, 30.243500>, <6.873980, -0.380029, 30.272700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.796010, -0.318390, 30.220800>, <6.834340, -0.281923, 30.203900>, <6.940380, -0.316241, 30.243500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.834340, -0.281923, 30.203900>, <6.962750, -0.230072, 30.232900>, <6.940380, -0.316241, 30.243500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.834340, -0.281923, 30.203900>, <6.847260, -0.232786, 30.197700>, <6.962750, -0.230072, 30.232900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.847260, -0.232786, 30.197700>, <6.935110, -0.145024, 30.243700>, <6.962750, -0.230072, 30.232900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.847260, -0.232786, 30.197700>, <6.831310, -0.184275, 30.204000>, <6.935110, -0.145024, 30.243700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.831310, -0.184275, 30.204000>, <6.864860, -0.084261, 30.273000>, <6.935110, -0.145024, 30.243700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.831310, -0.184275, 30.204000>, <6.790750, -0.149528, 30.220900>, <6.864860, -0.084261, 30.273000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.790750, -0.149528, 30.220900>, <6.770820, -0.064051, 30.313000>, <6.864860, -0.084261, 30.273000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.790750, -0.149528, 30.220900>, <6.736450, -0.137832, 30.244000>, <6.770820, -0.064051, 30.313000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.736450, -0.137832, 30.244000>, <6.678190, -0.089397, 30.353000>, <6.770820, -0.064051, 30.313000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.736450, -0.137832, 30.244000>, <6.682970, -0.152197, 30.267100>, <6.678190, -0.089397, 30.353000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.682970, -0.152197, 30.267100>, <6.611790, -0.153125, 30.382200>, <6.678190, -0.089397, 30.353000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.682970, -0.152197, 30.267100>, <6.644640, -0.188632, 30.284000>, <6.611790, -0.153125, 30.382200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.644640, -0.188632, 30.284000>, <6.589420, -0.238171, 30.392800>, <6.611790, -0.153125, 30.382200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.644640, -0.188632, 30.284000>, <6.631720, -0.237401, 30.290100>, <6.589420, -0.238171, 30.392800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.631720, -0.237401, 30.290100>, <6.617050, -0.322168, 30.382000>, <6.589420, -0.238171, 30.392800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.631720, -0.237401, 30.290100>, <6.647680, -0.285559, 30.283900>, <6.617050, -0.322168, 30.382000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.647680, -0.285559, 30.283900>, <6.687310, -0.382992, 30.352700>, <6.617050, -0.322168, 30.382000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.647680, -0.285559, 30.283900>, <6.688240, -0.320336, 30.266900>, <6.687310, -0.382992, 30.352700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.688240, -0.320336, 30.266900>, <6.781350, -0.404322, 30.312700>, <6.687310, -0.382992, 30.352700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.688240, -0.320336, 30.266900>, <6.742530, -0.332400, 30.243800>, <6.781350, -0.404322, 30.312700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.781350, -0.404322, 30.312700>, <6.939110, -0.403598, 30.360700>, <6.825620, -0.424814, 30.401900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.781350, -0.404322, 30.312700>, <6.873980, -0.380029, 30.272700>, <6.939110, -0.403598, 30.360700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.873980, -0.380029, 30.272700>, <7.021870, -0.329244, 30.326100>, <6.939110, -0.403598, 30.360700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.873980, -0.380029, 30.272700>, <6.940380, -0.316241, 30.243500>, <7.021870, -0.329244, 30.326100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.940380, -0.316241, 30.243500>, <7.055330, -0.228607, 30.312800>, <7.021870, -0.329244, 30.326100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.940380, -0.316241, 30.243500>, <6.962750, -0.230072, 30.232900>, <7.055330, -0.228607, 30.312800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.962750, -0.230072, 30.232900>, <7.021900, -0.128885, 30.325400>, <7.055330, -0.228607, 30.312800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.962750, -0.230072, 30.232900>, <6.935110, -0.145024, 30.243700>, <7.021900, -0.128885, 30.325400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.935110, -0.145024, 30.243700>, <6.942310, -0.057804, 30.359100>, <7.021900, -0.128885, 30.325400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.935110, -0.145024, 30.243700>, <6.864860, -0.084261, 30.273000>, <6.942310, -0.057804, 30.359100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.864860, -0.084261, 30.273000>, <6.830140, -0.036910, 30.403200>, <6.942310, -0.057804, 30.359100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.864860, -0.084261, 30.273000>, <6.770820, -0.064051, 30.313000>, <6.830140, -0.036910, 30.403200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.770820, -0.064051, 30.313000>, <6.717620, -0.067150, 30.444800>, <6.830140, -0.036910, 30.403200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.770820, -0.064051, 30.313000>, <6.678190, -0.089397, 30.353000>, <6.717620, -0.067150, 30.444800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.678190, -0.089397, 30.353000>, <6.636200, -0.136727, 30.481100>, <6.717620, -0.067150, 30.444800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.678190, -0.089397, 30.353000>, <6.611790, -0.153125, 30.382200>, <6.636200, -0.136727, 30.481100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.611790, -0.153125, 30.382200>, <6.606410, -0.234050, 30.497500>, <6.636200, -0.136727, 30.481100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.611790, -0.153125, 30.382200>, <6.589420, -0.238171, 30.392800>, <6.606410, -0.234050, 30.497500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.589420, -0.238171, 30.392800>, <6.633130, -0.331123, 30.485200>, <6.606410, -0.234050, 30.497500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.589420, -0.238171, 30.392800>, <6.617050, -0.322168, 30.382000>, <6.633130, -0.331123, 30.485200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.617050, -0.322168, 30.382000>, <6.714380, -0.399627, 30.451200>, <6.633130, -0.331123, 30.485200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.617050, -0.322168, 30.382000>, <6.687310, -0.382992, 30.352700>, <6.714380, -0.399627, 30.451200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.687310, -0.382992, 30.352700>, <6.825620, -0.424814, 30.401900>, <6.714380, -0.399627, 30.451200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.687310, -0.382992, 30.352700>, <6.781350, -0.404322, 30.312700>, <6.825620, -0.424814, 30.401900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.758900, -0.393536, 30.611800>, <6.826500, -0.388616, 30.814500>, <6.668830, -0.323007, 30.624800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.921460, -0.391083, 30.992800>, <6.826500, -0.388616, 30.814500>, <7.032060, -0.420771, 30.958400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.872750, -0.422763, 30.577800>, <6.954070, -0.423775, 30.769700>, <6.758900, -0.393536, 30.611800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.032060, -0.420771, 30.958400>, <6.954070, -0.423775, 30.769700>, <7.165320, -0.400477, 30.879900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013750, -0.403897, 30.524500>, <7.081150, -0.403413, 30.694300>, <6.872750, -0.422763, 30.577800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.165320, -0.400477, 30.879900>, <7.081150, -0.403413, 30.694300>, <7.235680, -0.326803, 30.802800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.826500, -0.388616, 30.814500>, <6.758900, -0.393536, 30.611800>, <6.954070, -0.423775, 30.769700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.633130, -0.331123, 30.485200>, <6.714380, -0.399627, 30.451200>, <6.758900, -0.393536, 30.611800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.954070, -0.423775, 30.769700>, <6.872750, -0.422763, 30.577800>, <7.081150, -0.403413, 30.694300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.714380, -0.399627, 30.451200>, <6.825620, -0.424814, 30.401900>, <6.872750, -0.422763, 30.577800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.081150, -0.403413, 30.694300>, <7.013750, -0.403897, 30.524500>, <7.164410, -0.328960, 30.644000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.825620, -0.424814, 30.401900>, <6.939110, -0.403598, 30.360700>, <7.013750, -0.403897, 30.524500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.826500, -0.388616, 30.814500>, <6.921460, -0.391083, 30.992800>, <6.740350, -0.312890, 30.836500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.921460, -0.391083, 30.992800>, <7.112880, -0.418962, 31.082200>, <6.991480, -0.388796, 31.115300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.954070, -0.423775, 30.769700>, <7.032060, -0.420771, 30.958400>, <6.826500, -0.388616, 30.814500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.032060, -0.420771, 30.958400>, <7.223210, -0.396145, 31.027800>, <7.112880, -0.418962, 31.082200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.081150, -0.403413, 30.694300>, <7.165320, -0.400477, 30.879900>, <6.954070, -0.423775, 30.769700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.165320, -0.400477, 30.879900>, <7.306950, -0.324663, 30.961700>, <7.223210, -0.396145, 31.027800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.668830, -0.323007, 30.624800>, <6.740350, -0.312890, 30.836500>, <6.630220, -0.222546, 30.621900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.842900, -0.315326, 31.016100>, <6.740350, -0.312890, 30.836500>, <6.921460, -0.391083, 30.992800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.740350, -0.312890, 30.836500>, <6.668830, -0.323007, 30.624800>, <6.826500, -0.388616, 30.814500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.606410, -0.234050, 30.497500>, <6.633130, -0.331123, 30.485200>, <6.668830, -0.323007, 30.624800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.740350, -0.312890, 30.836500>, <6.842900, -0.315326, 31.016100>, <6.699550, -0.209875, 30.836300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.842900, -0.315326, 31.016100>, <6.991480, -0.388796, 31.115300>, <6.910750, -0.312673, 31.121400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.093150, -0.329086, 30.485000>, <7.164410, -0.328960, 30.644000>, <7.013750, -0.403897, 30.524500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.235680, -0.326803, 30.802800>, <7.164410, -0.328960, 30.644000>, <7.262090, -0.222702, 30.758200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.262090, -0.222702, 30.758200>, <7.193180, -0.224609, 30.609700>, <7.242990, -0.117605, 30.750400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.124250, -0.226597, 30.461300>, <7.193180, -0.224609, 30.609700>, <7.093150, -0.329086, 30.485000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.089960, -0.124293, 30.462900>, <7.165010, -0.120195, 30.600400>, <7.124250, -0.226597, 30.461300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.242990, -0.117605, 30.750400>, <7.165010, -0.120195, 30.600400>, <7.157360, -0.040502, 30.765900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.164410, -0.328960, 30.644000>, <7.235680, -0.326803, 30.802800>, <7.081150, -0.403413, 30.694300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.235680, -0.326803, 30.802800>, <7.331010, -0.220798, 30.906600>, <7.306950, -0.324663, 30.961700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.193180, -0.224609, 30.609700>, <7.262090, -0.222702, 30.758200>, <7.164410, -0.328960, 30.644000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.262090, -0.222702, 30.758200>, <7.294150, -0.113892, 30.875200>, <7.331010, -0.220798, 30.906600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.165010, -0.120195, 30.600400>, <7.242990, -0.117605, 30.750400>, <7.193180, -0.224609, 30.609700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.242990, -0.117605, 30.750400>, <7.211530, -0.036583, 30.876500>, <7.294150, -0.113892, 30.875200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.164410, -0.328960, 30.644000>, <7.093150, -0.329086, 30.485000>, <7.193180, -0.224609, 30.609700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.939110, -0.403598, 30.360700>, <7.021870, -0.329244, 30.326100>, <7.093150, -0.329086, 30.485000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.193180, -0.224609, 30.609700>, <7.124250, -0.226597, 30.461300>, <7.165010, -0.120195, 30.600400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.021870, -0.329244, 30.326100>, <7.055330, -0.228607, 30.312800>, <7.124250, -0.226597, 30.461300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.165010, -0.120195, 30.600400>, <7.089960, -0.124293, 30.462900>, <7.076920, -0.044901, 30.617700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.055330, -0.228607, 30.312800>, <7.021900, -0.128885, 30.325400>, <7.089960, -0.124293, 30.462900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013510, -0.052057, 30.479200>, <7.076920, -0.044901, 30.617700>, <7.089960, -0.124293, 30.462900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.157360, -0.040502, 30.765900>, <7.076920, -0.044901, 30.617700>, <7.034220, -0.011064, 30.813500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.888690, -0.028451, 30.517100>, <6.960120, -0.019518, 30.656000>, <7.013510, -0.052057, 30.479200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034220, -0.011064, 30.813500>, <6.960120, -0.019518, 30.656000>, <6.915080, -0.033832, 30.891000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.740840, -0.052545, 30.562000>, <6.803480, -0.041180, 30.727600>, <6.888690, -0.028451, 30.517100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.915080, -0.033832, 30.891000>, <6.803480, -0.041180, 30.727600>, <6.821200, -0.105117, 30.970200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.656640, -0.124907, 30.602400>, <6.701770, -0.111735, 30.797900>, <6.740840, -0.052545, 30.562000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.821200, -0.105117, 30.970200>, <6.701770, -0.111735, 30.797900>, <6.796350, -0.207096, 31.018200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.076920, -0.044901, 30.617700>, <7.157360, -0.040502, 30.765900>, <7.165010, -0.120195, 30.600400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.157360, -0.040502, 30.765900>, <7.090090, -0.005831, 30.908900>, <7.211530, -0.036583, 30.876500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.960120, -0.019518, 30.656000>, <7.034220, -0.011064, 30.813500>, <7.076920, -0.044901, 30.617700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.034220, -0.011064, 30.813500>, <6.974670, -0.028362, 30.967000>, <7.090090, -0.005831, 30.908900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.803480, -0.041180, 30.727600>, <6.915080, -0.033832, 30.891000>, <6.960120, -0.019518, 30.656000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.915080, -0.033832, 30.891000>, <6.894910, -0.099196, 31.070500>, <6.974670, -0.028362, 30.967000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.076920, -0.044901, 30.617700>, <7.013510, -0.052057, 30.479200>, <6.960120, -0.019518, 30.656000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.021900, -0.128885, 30.325400>, <6.942310, -0.057804, 30.359100>, <7.013510, -0.052057, 30.479200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.960120, -0.019518, 30.656000>, <6.888690, -0.028451, 30.517100>, <6.803480, -0.041180, 30.727600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.942310, -0.057804, 30.359100>, <6.830140, -0.036910, 30.403200>, <6.888690, -0.028451, 30.517100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.803480, -0.041180, 30.727600>, <6.740840, -0.052545, 30.562000>, <6.701770, -0.111735, 30.797900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.830140, -0.036910, 30.403200>, <6.717620, -0.067150, 30.444800>, <6.740840, -0.052545, 30.562000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.701770, -0.111735, 30.797900>, <6.821200, -0.105117, 30.970200>, <6.803480, -0.041180, 30.727600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.821200, -0.105117, 30.970200>, <6.869460, -0.203140, 31.116800>, <6.894910, -0.099196, 31.070500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.701770, -0.111735, 30.797900>, <6.656640, -0.124907, 30.602400>, <6.699550, -0.209875, 30.836300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.717620, -0.067150, 30.444800>, <6.636200, -0.136727, 30.481100>, <6.656640, -0.124907, 30.602400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.630220, -0.222546, 30.621900>, <6.699550, -0.209875, 30.836300>, <6.656640, -0.124907, 30.602400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.796350, -0.207096, 31.018200>, <6.699550, -0.209875, 30.836300>, <6.842900, -0.315326, 31.016100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.699550, -0.209875, 30.836300>, <6.630220, -0.222546, 30.621900>, <6.740350, -0.312890, 30.836500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.636200, -0.136727, 30.481100>, <6.606410, -0.234050, 30.497500>, <6.630220, -0.222546, 30.621900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.699550, -0.209875, 30.836300>, <6.796350, -0.207096, 31.018200>, <6.701770, -0.111735, 30.797900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.796350, -0.207096, 31.018200>, <6.910750, -0.312673, 31.121400>, <6.869460, -0.203140, 31.116800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.861460, -0.149017, 30.133300>, <7.028210, -0.140442, 30.316500>, <6.889490, -0.240479, 30.120400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.627740, -0.247103, 29.866000>, <6.506860, -0.248940, 29.750100>, <6.601810, -0.162833, 29.880400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.787770, -0.084565, 30.171100>, <6.948370, -0.072177, 30.351400>, <6.861460, -0.149017, 30.133300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.601810, -0.162833, 29.880400>, <6.485160, -0.172407, 29.767200>, <6.534260, -0.102954, 29.921200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.683450, -0.062424, 30.225800>, <6.835970, -0.047800, 30.402100>, <6.787770, -0.084565, 30.171100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.534260, -0.102954, 29.921200>, <6.429910, -0.117062, 29.813800>, <6.438020, -0.083227, 29.979700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.574160, -0.088121, 30.286500>, <6.723520, -0.076027, 30.454200>, <6.683450, -0.062424, 30.225800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.438020, -0.083227, 29.979700>, <6.349830, -0.100598, 29.880100>, <6.342010, -0.107191, 30.039900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.492000, -0.152628, 30.331400>, <6.643420, -0.145949, 30.492500>, <6.574160, -0.088121, 30.286500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.342010, -0.107191, 30.039900>, <6.270270, -0.122012, 29.948500>, <6.274620, -0.167068, 30.082400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.444840, -0.241747, 30.358200>, <6.612660, -0.242653, 30.508800>, <6.492000, -0.152628, 30.331400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.274620, -0.167068, 30.082400>, <6.215580, -0.175933, 29.995200>, <6.237940, -0.249993, 30.108700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.472140, -0.331802, 30.342200>, <6.642690, -0.338771, 30.497300>, <6.444840, -0.241747, 30.358200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.237940, -0.249993, 30.108700>, <6.193210, -0.252657, 30.016400>, <6.257470, -0.332625, 30.091100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.542820, -0.395644, 30.304400>, <6.722270, -0.407097, 30.462500>, <6.472140, -0.331802, 30.342200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.257470, -0.332625, 30.091100>, <6.212190, -0.327931, 29.998700>, <6.315850, -0.390999, 30.055000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677240, -0.422542, 30.235900>, <6.834530, -0.433036, 30.411800>, <6.542820, -0.395644, 30.304400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.315850, -0.390999, 30.055000>, <6.269530, -0.382234, 29.952100>, <6.430420, -0.414458, 29.988600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.786050, -0.398628, 30.178300>, <6.947120, -0.406312, 30.359700>, <6.677240, -0.422542, 30.235900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.430420, -0.414458, 29.988600>, <6.349470, -0.401251, 29.885500>, <6.532080, -0.393264, 29.927000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.860690, -0.332521, 30.137500>, <7.027470, -0.336330, 30.321400>, <6.786050, -0.398628, 30.178300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.532080, -0.393264, 29.927000>, <6.426790, -0.382733, 29.817600>, <6.601020, -0.331858, 29.883800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.889490, -0.240479, 30.120400>, <7.058360, -0.238059, 30.305000>, <6.860690, -0.332521, 30.137500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.601020, -0.331858, 29.883800>, <6.484310, -0.325866, 29.769400>, <6.627740, -0.247103, 29.866000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.263210, -0.315891, 29.733900>, <6.224270, -0.326424, 29.766100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.291680, -0.288074, 29.710300>, <6.263210, -0.315891, 29.733900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.302050, -0.250421, 29.701700>, <6.291680, -0.288074, 29.710300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.291510, -0.213033, 29.710300>, <6.302050, -0.250421, 29.701700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.262900, -0.185943, 29.733900>, <6.291510, -0.213033, 29.710300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.223890, -0.176414, 29.766200>, <6.262900, -0.185943, 29.733900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.184940, -0.186986, 29.798400>, <6.223890, -0.176414, 29.766200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.156460, -0.214810, 29.821900>, <6.184940, -0.186986, 29.798400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.146100, -0.252429, 29.830600>, <6.156460, -0.214810, 29.821900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.156640, -0.289776, 29.821900>, <6.146100, -0.252429, 29.830600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.185260, -0.316860, 29.798300>, <6.156640, -0.289776, 29.821900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.205160, -0.251535, 29.748200>, <6.224270, -0.326424, 29.766100>, <6.185260, -0.316860, 29.798300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.224270, -0.326424, 29.766100>, <6.343570, -0.363881, 29.759400>, <6.276110, -0.382282, 29.815200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.224270, -0.326424, 29.766100>, <6.263210, -0.315891, 29.733900>, <6.343570, -0.363881, 29.759400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.263210, -0.315891, 29.733900>, <6.392890, -0.315231, 29.718600>, <6.343570, -0.363881, 29.759400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.263210, -0.315891, 29.733900>, <6.291680, -0.288074, 29.710300>, <6.392890, -0.315231, 29.718600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.291680, -0.288074, 29.710300>, <6.410820, -0.249356, 29.703600>, <6.392890, -0.315231, 29.718600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.291680, -0.288074, 29.710300>, <6.302050, -0.250421, 29.701700>, <6.410820, -0.249356, 29.703600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.302050, -0.250421, 29.701700>, <6.392560, -0.183946, 29.718600>, <6.410820, -0.249356, 29.703600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.302050, -0.250421, 29.701700>, <6.291510, -0.213033, 29.710300>, <6.392560, -0.183946, 29.718600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.291510, -0.213033, 29.710300>, <6.343020, -0.136575, 29.759400>, <6.392560, -0.183946, 29.718600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.291510, -0.213033, 29.710300>, <6.262900, -0.185943, 29.733900>, <6.343020, -0.136575, 29.759400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.262900, -0.185943, 29.733900>, <6.275450, -0.119942, 29.815300>, <6.343020, -0.136575, 29.759400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.262900, -0.185943, 29.733900>, <6.223890, -0.176414, 29.766200>, <6.275450, -0.119942, 29.815300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.223890, -0.176414, 29.766200>, <6.207980, -0.138467, 29.871000>, <6.275450, -0.119942, 29.815300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.223890, -0.176414, 29.766200>, <6.184940, -0.186986, 29.798400>, <6.207980, -0.138467, 29.871000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.184940, -0.186986, 29.798400>, <6.158670, -0.187139, 29.911900>, <6.207980, -0.138467, 29.871000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.184940, -0.186986, 29.798400>, <6.156460, -0.214810, 29.821900>, <6.158670, -0.187139, 29.911900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.156460, -0.214810, 29.821900>, <6.140710, -0.252908, 29.926800>, <6.158670, -0.187139, 29.911900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.156460, -0.214810, 29.821900>, <6.146100, -0.252429, 29.830600>, <6.140710, -0.252908, 29.926800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.146100, -0.252429, 29.830600>, <6.158990, -0.318194, 29.911800>, <6.140710, -0.252908, 29.926800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.146100, -0.252429, 29.830600>, <6.156640, -0.289776, 29.821900>, <6.158990, -0.318194, 29.911800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.156640, -0.289776, 29.821900>, <6.208550, -0.365544, 29.871000>, <6.158990, -0.318194, 29.911800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.156640, -0.289776, 29.821900>, <6.185260, -0.316860, 29.798300>, <6.208550, -0.365544, 29.871000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.185260, -0.316860, 29.798300>, <6.276110, -0.382282, 29.815200>, <6.208550, -0.365544, 29.871000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.185260, -0.316860, 29.798300>, <6.224270, -0.326424, 29.766100>, <6.276110, -0.382282, 29.815200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.276110, -0.382282, 29.815200>, <6.426790, -0.382733, 29.817600>, <6.349470, -0.401251, 29.885500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.276110, -0.382282, 29.815200>, <6.343570, -0.363881, 29.759400>, <6.426790, -0.382733, 29.817600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.343570, -0.363881, 29.759400>, <6.484310, -0.325866, 29.769400>, <6.426790, -0.382733, 29.817600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.343570, -0.363881, 29.759400>, <6.392890, -0.315231, 29.718600>, <6.484310, -0.325866, 29.769400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392890, -0.315231, 29.718600>, <6.506860, -0.248940, 29.750100>, <6.484310, -0.325866, 29.769400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392890, -0.315231, 29.718600>, <6.410820, -0.249356, 29.703600>, <6.506860, -0.248940, 29.750100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.410820, -0.249356, 29.703600>, <6.485160, -0.172407, 29.767200>, <6.506860, -0.248940, 29.750100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.410820, -0.249356, 29.703600>, <6.392560, -0.183946, 29.718600>, <6.485160, -0.172407, 29.767200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392560, -0.183946, 29.718600>, <6.429910, -0.117062, 29.813800>, <6.485160, -0.172407, 29.767200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392560, -0.183946, 29.718600>, <6.343020, -0.136575, 29.759400>, <6.429910, -0.117062, 29.813800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.343020, -0.136575, 29.759400>, <6.349830, -0.100598, 29.880100>, <6.429910, -0.117062, 29.813800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.343020, -0.136575, 29.759400>, <6.275450, -0.119942, 29.815300>, <6.349830, -0.100598, 29.880100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.275450, -0.119942, 29.815300>, <6.270270, -0.122012, 29.948500>, <6.349830, -0.100598, 29.880100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.275450, -0.119942, 29.815300>, <6.207980, -0.138467, 29.871000>, <6.270270, -0.122012, 29.948500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.207980, -0.138467, 29.871000>, <6.215580, -0.175933, 29.995200>, <6.270270, -0.122012, 29.948500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.207980, -0.138467, 29.871000>, <6.158670, -0.187139, 29.911900>, <6.215580, -0.175933, 29.995200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.158670, -0.187139, 29.911900>, <6.193210, -0.252657, 30.016400>, <6.215580, -0.175933, 29.995200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.158670, -0.187139, 29.911900>, <6.140710, -0.252908, 29.926800>, <6.193210, -0.252657, 30.016400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.140710, -0.252908, 29.926800>, <6.212190, -0.327931, 29.998700>, <6.193210, -0.252657, 30.016400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.140710, -0.252908, 29.926800>, <6.158990, -0.318194, 29.911800>, <6.212190, -0.327931, 29.998700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.158990, -0.318194, 29.911800>, <6.269530, -0.382234, 29.952100>, <6.212190, -0.327931, 29.998700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.158990, -0.318194, 29.911800>, <6.208550, -0.365544, 29.871000>, <6.269530, -0.382234, 29.952100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.208550, -0.365544, 29.871000>, <6.349470, -0.401251, 29.885500>, <6.269530, -0.382234, 29.952100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.208550, -0.365544, 29.871000>, <6.276110, -0.382282, 29.815200>, <6.349470, -0.401251, 29.885500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.215580, -0.175933, 29.995200>, <6.193210, -0.252657, 30.016400>, <6.237940, -0.249993, 30.108700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.444840, -0.241747, 30.358200>, <6.237940, -0.249993, 30.108700>, <6.472140, -0.331802, 30.342200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.193210, -0.252657, 30.016400>, <6.212190, -0.327931, 29.998700>, <6.257470, -0.332625, 30.091100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.472140, -0.331802, 30.342200>, <6.257470, -0.332625, 30.091100>, <6.542820, -0.395644, 30.304400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.270270, -0.122012, 29.948500>, <6.215580, -0.175933, 29.995200>, <6.274620, -0.167068, 30.082400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.492000, -0.152628, 30.331400>, <6.274620, -0.167068, 30.082400>, <6.444840, -0.241747, 30.358200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349830, -0.100598, 29.880100>, <6.270270, -0.122012, 29.948500>, <6.342010, -0.107191, 30.039900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.574160, -0.088121, 30.286500>, <6.342010, -0.107191, 30.039900>, <6.492000, -0.152628, 30.331400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212190, -0.327931, 29.998700>, <6.269530, -0.382234, 29.952100>, <6.315850, -0.390999, 30.055000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.542820, -0.395644, 30.304400>, <6.315850, -0.390999, 30.055000>, <6.677240, -0.422542, 30.235900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.269530, -0.382234, 29.952100>, <6.349470, -0.401251, 29.885500>, <6.430420, -0.414458, 29.988600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677240, -0.422542, 30.235900>, <6.430420, -0.414458, 29.988600>, <6.786050, -0.398628, 30.178300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349470, -0.401251, 29.885500>, <6.426790, -0.382733, 29.817600>, <6.532080, -0.393264, 29.927000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.786050, -0.398628, 30.178300>, <6.532080, -0.393264, 29.927000>, <6.860690, -0.332521, 30.137500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.426790, -0.382733, 29.817600>, <6.484310, -0.325866, 29.769400>, <6.601020, -0.331858, 29.883800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.860690, -0.332521, 30.137500>, <6.601020, -0.331858, 29.883800>, <6.889490, -0.240479, 30.120400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.429910, -0.117062, 29.813800>, <6.349830, -0.100598, 29.880100>, <6.438020, -0.083227, 29.979700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.683450, -0.062424, 30.225800>, <6.438020, -0.083227, 29.979700>, <6.574160, -0.088121, 30.286500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.485160, -0.172407, 29.767200>, <6.429910, -0.117062, 29.813800>, <6.534260, -0.102954, 29.921200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.787770, -0.084565, 30.171100>, <6.534260, -0.102954, 29.921200>, <6.683450, -0.062424, 30.225800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.506860, -0.248940, 29.750100>, <6.485160, -0.172407, 29.767200>, <6.601810, -0.162833, 29.880400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.861460, -0.149017, 30.133300>, <6.601810, -0.162833, 29.880400>, <6.787770, -0.084565, 30.171100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.889490, -0.240479, 30.120400>, <6.627740, -0.247103, 29.866000>, <6.861460, -0.149017, 30.133300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.484310, -0.325866, 29.769400>, <6.506860, -0.248940, 29.750100>, <6.627740, -0.247103, 29.866000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.601020, -0.331858, 29.883800>, <6.860690, -0.332521, 30.137500>, <6.532080, -0.393264, 29.927000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.860690, -0.332521, 30.137500>, <7.058360, -0.238059, 30.305000>, <7.027470, -0.336330, 30.321400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.627740, -0.247103, 29.866000>, <6.889490, -0.240479, 30.120400>, <6.601020, -0.331858, 29.883800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.889490, -0.240479, 30.120400>, <7.028210, -0.140442, 30.316500>, <7.058360, -0.238059, 30.305000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.601810, -0.162833, 29.880400>, <6.861460, -0.149017, 30.133300>, <6.627740, -0.247103, 29.866000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.861460, -0.149017, 30.133300>, <6.948370, -0.072177, 30.351400>, <7.028210, -0.140442, 30.316500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.532080, -0.393264, 29.927000>, <6.786050, -0.398628, 30.178300>, <6.430420, -0.414458, 29.988600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.786050, -0.398628, 30.178300>, <7.027470, -0.336330, 30.321400>, <6.947120, -0.406312, 30.359700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.430420, -0.414458, 29.988600>, <6.677240, -0.422542, 30.235900>, <6.315850, -0.390999, 30.055000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677240, -0.422542, 30.235900>, <6.947120, -0.406312, 30.359700>, <6.834530, -0.433036, 30.411800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.315850, -0.390999, 30.055000>, <6.542820, -0.395644, 30.304400>, <6.257470, -0.332625, 30.091100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.542820, -0.395644, 30.304400>, <6.834530, -0.433036, 30.411800>, <6.722270, -0.407097, 30.462500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.257470, -0.332625, 30.091100>, <6.472140, -0.331802, 30.342200>, <6.237940, -0.249993, 30.108700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.472140, -0.331802, 30.342200>, <6.722270, -0.407097, 30.462500>, <6.642690, -0.338771, 30.497300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.534260, -0.102954, 29.921200>, <6.787770, -0.084565, 30.171100>, <6.601810, -0.162833, 29.880400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.787770, -0.084565, 30.171100>, <6.835970, -0.047800, 30.402100>, <6.948370, -0.072177, 30.351400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.438020, -0.083227, 29.979700>, <6.683450, -0.062424, 30.225800>, <6.534260, -0.102954, 29.921200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.683450, -0.062424, 30.225800>, <6.723520, -0.076027, 30.454200>, <6.835970, -0.047800, 30.402100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.342010, -0.107191, 30.039900>, <6.574160, -0.088121, 30.286500>, <6.438020, -0.083227, 29.979700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.574160, -0.088121, 30.286500>, <6.643420, -0.145949, 30.492500>, <6.723520, -0.076027, 30.454200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.274620, -0.167068, 30.082400>, <6.492000, -0.152628, 30.331400>, <6.342010, -0.107191, 30.039900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.492000, -0.152628, 30.331400>, <6.612660, -0.242653, 30.508800>, <6.643420, -0.145949, 30.492500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.237940, -0.249993, 30.108700>, <6.444840, -0.241747, 30.358200>, <6.274620, -0.167068, 30.082400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.444840, -0.241747, 30.358200>, <6.642690, -0.338771, 30.497300>, <6.612660, -0.242653, 30.508800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.684040, -0.292580, 29.539600>, <5.718760, -0.314080, 29.607300>, <5.719600, -0.246074, 29.613500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.750480, -0.349984, 29.568300>, <5.718760, -0.314080, 29.607300>, <5.684040, -0.292580, 29.539600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.798470, -0.366232, 29.513900>, <5.750480, -0.349984, 29.568300>, <5.711000, -0.323084, 29.508900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.849320, -0.351482, 29.467600>, <5.798470, -0.366232, 29.513900>, <5.742720, -0.340191, 29.471400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.891520, -0.332872, 29.426400>, <5.849320, -0.351482, 29.467600>, <5.789410, -0.326776, 29.429400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.910420, -0.281460, 29.417300>, <5.889910, -0.328750, 29.432700>, <5.782020, -0.262841, 29.329100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.823250, -0.168858, 29.363800>, <5.916720, -0.149189, 29.430900>, <5.793840, -0.194702, 29.328400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.901200, -0.130430, 29.459500>, <5.919320, -0.146901, 29.424500>, <5.845460, -0.165581, 29.387600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.854690, -0.113936, 29.523000>, <5.901200, -0.130430, 29.459500>, <5.826680, -0.147489, 29.421100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.796920, -0.137716, 29.568000>, <5.854690, -0.113936, 29.523000>, <5.794470, -0.139640, 29.470500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.742220, -0.175776, 29.607400>, <5.796920, -0.137716, 29.568000>, <5.741380, -0.156372, 29.503900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.719600, -0.246074, 29.613500>, <5.742220, -0.175776, 29.607400>, <5.703260, -0.197149, 29.543100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.986170, -0.331300, 29.852100>, <6.208410, -0.328843, 29.982900>, <5.974750, -0.246496, 29.874000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.828770, -0.248143, 29.746800>, <5.719600, -0.246074, 29.613500>, <5.827340, -0.329449, 29.726600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.028880, -0.373827, 29.800500>, <6.263250, -0.380871, 29.937500>, <5.986170, -0.331300, 29.852100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.827340, -0.329449, 29.726600>, <5.718760, -0.314080, 29.607300>, <5.872550, -0.366366, 29.679800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.096470, -0.397765, 29.721700>, <6.341320, -0.399643, 29.873600>, <6.028880, -0.373827, 29.800500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.872550, -0.366366, 29.679800>, <5.750480, -0.349984, 29.568300>, <5.930940, -0.388363, 29.613500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.165010, -0.383970, 29.656500>, <6.419010, -0.377959, 29.809900>, <6.096470, -0.397765, 29.721700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.930940, -0.388363, 29.613500>, <5.798470, -0.366232, 29.513900>, <5.995220, -0.378290, 29.551000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.209050, -0.355752, 29.614100>, <6.477230, -0.324087, 29.764900>, <6.165010, -0.383970, 29.656500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.849320, -0.351482, 29.467600>, <5.891520, -0.332872, 29.426400>, <6.032240, -0.348228, 29.515500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.310080, -0.243634, 29.618200>, <6.499520, -0.249096, 29.750300>, <6.272860, -0.315772, 29.619000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.029400, -0.343196, 29.520800>, <5.889910, -0.328750, 29.432700>, <6.056240, -0.292898, 29.501900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231480, -0.143495, 29.608400>, <6.478910, -0.174815, 29.767900>, <6.289740, -0.189898, 29.618100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.075040, -0.237904, 29.490800>, <5.925990, -0.233806, 29.407700>, <6.069780, -0.185450, 29.500700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.203970, -0.108833, 29.651800>, <6.425600, -0.122764, 29.813700>, <6.231480, -0.143495, 29.608400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.062660, -0.139738, 29.509900>, <5.919320, -0.146901, 29.424500>, <6.046420, -0.109343, 29.548600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.150470, -0.089382, 29.724200>, <6.347500, -0.103922, 29.876200>, <6.203970, -0.108833, 29.651800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.046420, -0.109343, 29.548600>, <5.901200, -0.130430, 29.459500>, <5.995800, -0.087537, 29.626600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.073910, -0.113267, 29.807000>, <6.267590, -0.125362, 29.941900>, <6.150470, -0.089382, 29.724200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.995800, -0.087537, 29.626600>, <5.854690, -0.113936, 29.523000>, <5.921290, -0.113642, 29.676400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.003510, -0.161555, 29.859800>, <6.211580, -0.179591, 29.984600>, <6.073910, -0.113267, 29.807000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.921290, -0.113642, 29.676400>, <5.796920, -0.137716, 29.568000>, <5.852920, -0.164468, 29.736400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.974750, -0.246496, 29.874000>, <6.190110, -0.254676, 30.003200>, <6.003510, -0.161555, 29.859800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.852920, -0.164468, 29.736400>, <5.742220, -0.175776, 29.607400>, <5.828770, -0.248143, 29.746800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.872550, -0.366366, 29.679800>, <6.028880, -0.373827, 29.800500>, <5.827340, -0.329449, 29.726600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.028880, -0.373827, 29.800500>, <6.341320, -0.399643, 29.873600>, <6.263250, -0.380871, 29.937500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.930940, -0.388363, 29.613500>, <6.096470, -0.397765, 29.721700>, <5.872550, -0.366366, 29.679800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.096470, -0.397765, 29.721700>, <6.419010, -0.377959, 29.809900>, <6.341320, -0.399643, 29.873600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.995220, -0.378290, 29.551000>, <6.165010, -0.383970, 29.656500>, <5.930940, -0.388363, 29.613500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.165010, -0.383970, 29.656500>, <6.477230, -0.324087, 29.764900>, <6.419010, -0.377959, 29.809900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.827340, -0.329449, 29.726600>, <5.986170, -0.331300, 29.852100>, <5.828770, -0.248143, 29.746800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.986170, -0.331300, 29.852100>, <6.263250, -0.380871, 29.937500>, <6.208410, -0.328843, 29.982900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.974750, -0.246496, 29.874000>, <6.208410, -0.328843, 29.982900>, <6.190110, -0.254676, 30.003200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.828770, -0.248143, 29.746800>, <5.974750, -0.246496, 29.874000>, <5.852920, -0.164468, 29.736400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.209050, -0.355752, 29.614100>, <6.165010, -0.383970, 29.656500>, <5.995220, -0.378290, 29.551000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.477230, -0.324087, 29.764900>, <6.209050, -0.355752, 29.614100>, <6.272860, -0.315772, 29.619000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.075040, -0.237904, 29.490800>, <6.295650, -0.245351, 29.623100>, <6.261190, -0.312059, 29.625800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.499520, -0.249096, 29.750300>, <6.310080, -0.243634, 29.618200>, <6.289740, -0.189898, 29.618100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.058620, -0.145722, 29.515400>, <6.222200, -0.149331, 29.610600>, <6.275170, -0.193067, 29.623400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231480, -0.143495, 29.608400>, <6.425600, -0.122764, 29.813700>, <6.478910, -0.174815, 29.767900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.046420, -0.109343, 29.548600>, <6.203970, -0.108833, 29.651800>, <6.062660, -0.139738, 29.509900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.203970, -0.108833, 29.651800>, <6.347500, -0.103922, 29.876200>, <6.425600, -0.122764, 29.813700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.995800, -0.087537, 29.626600>, <6.150470, -0.089382, 29.724200>, <6.046420, -0.109343, 29.548600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.150470, -0.089382, 29.724200>, <6.267590, -0.125362, 29.941900>, <6.347500, -0.103922, 29.876200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.921290, -0.113642, 29.676400>, <6.073910, -0.113267, 29.807000>, <5.995800, -0.087537, 29.626600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.073910, -0.113267, 29.807000>, <6.211580, -0.179591, 29.984600>, <6.267590, -0.125362, 29.941900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.852920, -0.164468, 29.736400>, <6.003510, -0.161555, 29.859800>, <5.921290, -0.113642, 29.676400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.003510, -0.161555, 29.859800>, <6.190110, -0.254676, 30.003200>, <6.211580, -0.179591, 29.984600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814080, -0.232009, 29.375200>, <5.834530, -0.274619, 29.383300>, <5.822440, -0.305526, 29.388100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.784080, -0.225076, 29.315700>, <5.924570, -0.189243, 29.417100>, <5.925990, -0.233806, 29.407700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822440, -0.305526, 29.388100>, <5.789410, -0.326776, 29.429400>, <5.767470, -0.232714, 29.389500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.782020, -0.262841, 29.329100>, <5.784080, -0.225076, 29.315700>, <5.910420, -0.281460, 29.417300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.731220, -0.241904, 29.412400>, <5.794470, -0.139640, 29.470500>, <5.767470, -0.232714, 29.389500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.789410, -0.326776, 29.429400>, <5.822440, -0.305526, 29.388100>, <5.891520, -0.332872, 29.426400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.699620, -0.244521, 29.438300>, <5.741380, -0.156372, 29.503900>, <5.731220, -0.241904, 29.412400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.742720, -0.340191, 29.471400>, <5.789410, -0.326776, 29.429400>, <5.849320, -0.351482, 29.467600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.711000, -0.323084, 29.508900>, <5.684040, -0.292580, 29.539600>, <5.678630, -0.243399, 29.474400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.711000, -0.323084, 29.508900>, <5.742720, -0.340191, 29.471400>, <5.798470, -0.366232, 29.513900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.690360, -0.244814, 29.545500>, <5.703260, -0.197149, 29.543100>, <5.678630, -0.243399, 29.474400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.684040, -0.292580, 29.539600>, <5.711000, -0.323084, 29.508900>, <5.750480, -0.349984, 29.568300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.703260, -0.197149, 29.543100>, <5.741380, -0.156372, 29.503900>, <5.699620, -0.244521, 29.438300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.690360, -0.244814, 29.545500>, <5.684040, -0.292580, 29.539600>, <5.719600, -0.246074, 29.613500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.731220, -0.241904, 29.412400>, <5.742720, -0.340191, 29.471400>, <5.699620, -0.244521, 29.438300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.703260, -0.197149, 29.543100>, <5.690360, -0.244814, 29.545500>, <5.719600, -0.246074, 29.613500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.767470, -0.232714, 29.389500>, <5.789410, -0.326776, 29.429400>, <5.731220, -0.241904, 29.412400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.741380, -0.156372, 29.503900>, <5.703260, -0.197149, 29.543100>, <5.742220, -0.175776, 29.607400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.826680, -0.147489, 29.421100>, <5.814080, -0.232009, 29.375200>, <5.767470, -0.232714, 29.389500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.794470, -0.139640, 29.470500>, <5.741380, -0.156372, 29.503900>, <5.796920, -0.137716, 29.568000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814080, -0.232009, 29.375200>, <5.826680, -0.147489, 29.421100>, <5.845460, -0.165581, 29.387600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.826680, -0.147489, 29.421100>, <5.794470, -0.139640, 29.470500>, <5.854690, -0.113936, 29.523000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814080, -0.232009, 29.375200>, <5.845650, -0.196085, 29.382500>, <5.845950, -0.232287, 29.376700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.845460, -0.165581, 29.387600>, <5.826680, -0.147489, 29.421100>, <5.901200, -0.130430, 29.459500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.974750, -0.246496, 29.874000>, <5.828770, -0.248143, 29.746800>, <5.986170, -0.331300, 29.852100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.742220, -0.175776, 29.607400>, <5.719600, -0.246074, 29.613500>, <5.828770, -0.248143, 29.746800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.986170, -0.331300, 29.852100>, <5.827340, -0.329449, 29.726600>, <6.028880, -0.373827, 29.800500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.719600, -0.246074, 29.613500>, <5.718760, -0.314080, 29.607300>, <5.827340, -0.329449, 29.726600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.028880, -0.373827, 29.800500>, <5.872550, -0.366366, 29.679800>, <6.096470, -0.397765, 29.721700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.718760, -0.314080, 29.607300>, <5.750480, -0.349984, 29.568300>, <5.872550, -0.366366, 29.679800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.096470, -0.397765, 29.721700>, <5.930940, -0.388363, 29.613500>, <6.165010, -0.383970, 29.656500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.750480, -0.349984, 29.568300>, <5.798470, -0.366232, 29.513900>, <5.930940, -0.388363, 29.613500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.032240, -0.348228, 29.515500>, <5.995220, -0.378290, 29.551000>, <5.849320, -0.351482, 29.467600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.798470, -0.366232, 29.513900>, <5.849320, -0.351482, 29.467600>, <5.995220, -0.378290, 29.551000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.202960, -0.345968, 29.616800>, <6.029400, -0.343196, 29.520800>, <6.261190, -0.312059, 29.625800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.995220, -0.378290, 29.551000>, <6.032240, -0.348228, 29.515500>, <6.209050, -0.355752, 29.614100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.003510, -0.161555, 29.859800>, <5.852920, -0.164468, 29.736400>, <5.974750, -0.246496, 29.874000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.796920, -0.137716, 29.568000>, <5.742220, -0.175776, 29.607400>, <5.852920, -0.164468, 29.736400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.073910, -0.113267, 29.807000>, <5.921290, -0.113642, 29.676400>, <6.003510, -0.161555, 29.859800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.854690, -0.113936, 29.523000>, <5.796920, -0.137716, 29.568000>, <5.921290, -0.113642, 29.676400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.150470, -0.089382, 29.724200>, <5.995800, -0.087537, 29.626600>, <6.073910, -0.113267, 29.807000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.901200, -0.130430, 29.459500>, <5.854690, -0.113936, 29.523000>, <5.995800, -0.087537, 29.626600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.203970, -0.108833, 29.651800>, <6.046420, -0.109343, 29.548600>, <6.150470, -0.089382, 29.724200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.919320, -0.146901, 29.424500>, <5.901200, -0.130430, 29.459500>, <6.046420, -0.109343, 29.548600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231480, -0.143495, 29.608400>, <6.062660, -0.139738, 29.509900>, <6.203970, -0.108833, 29.651800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.924570, -0.189243, 29.417100>, <5.916720, -0.149189, 29.430900>, <6.058620, -0.145722, 29.515400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.295650, -0.245351, 29.623100>, <6.075040, -0.237904, 29.490800>, <6.275170, -0.193067, 29.623400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.910420, -0.281460, 29.417300>, <5.925990, -0.233806, 29.407700>, <6.075040, -0.237904, 29.490800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.678630, -0.243399, 29.474400>, <5.684040, -0.292580, 29.539600>, <5.690360, -0.244814, 29.545500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.711000, -0.323084, 29.508900>, <5.678630, -0.243399, 29.474400>, <5.699620, -0.244521, 29.438300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.742720, -0.340191, 29.471400>, <5.711000, -0.323084, 29.508900>, <5.699620, -0.244521, 29.438300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.699620, -0.244521, 29.438300>, <5.678630, -0.243399, 29.474400>, <5.703260, -0.197149, 29.543100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.789410, -0.326776, 29.429400>, <5.742720, -0.340191, 29.471400>, <5.731220, -0.241904, 29.412400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.731220, -0.241904, 29.412400>, <5.741380, -0.156372, 29.503900>, <5.794470, -0.139640, 29.470500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.767470, -0.232714, 29.389500>, <5.794470, -0.139640, 29.470500>, <5.826680, -0.147489, 29.421100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.767470, -0.232714, 29.389500>, <5.814080, -0.232009, 29.375200>, <5.822440, -0.305526, 29.388100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.272860, -0.315772, 29.619000>, <6.499520, -0.249096, 29.750300>, <6.477230, -0.324087, 29.764900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.261190, -0.312059, 29.625800>, <6.056240, -0.292898, 29.501900>, <6.075040, -0.237904, 29.490800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.289740, -0.189898, 29.618100>, <6.478910, -0.174815, 29.767900>, <6.499520, -0.249096, 29.750300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.275170, -0.193067, 29.623400>, <6.069780, -0.185450, 29.500700>, <6.058620, -0.145722, 29.515400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.069780, -0.185450, 29.500700>, <5.925990, -0.233806, 29.407700>, <5.924570, -0.189243, 29.417100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.275170, -0.193067, 29.623400>, <6.075040, -0.237904, 29.490800>, <6.069780, -0.185450, 29.500700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.924570, -0.189243, 29.417100>, <5.784080, -0.225076, 29.315700>, <5.793840, -0.194702, 29.328400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.924570, -0.189243, 29.417100>, <6.058620, -0.145722, 29.515400>, <6.069780, -0.185450, 29.500700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.793840, -0.194702, 29.328400>, <5.916720, -0.149189, 29.430900>, <5.924570, -0.189243, 29.417100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814080, -0.232009, 29.375200>, <5.845460, -0.165581, 29.387600>, <5.845650, -0.196085, 29.382500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814080, -0.232009, 29.375200>, <5.845950, -0.232287, 29.376700>, <5.834530, -0.274619, 29.383300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.792370, -0.290266, 29.359700>, <5.782020, -0.262841, 29.329100>, <5.889910, -0.328750, 29.432700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.784080, -0.225076, 29.315700>, <5.925990, -0.233806, 29.407700>, <5.910420, -0.281460, 29.417300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.910420, -0.281460, 29.417300>, <6.075040, -0.237904, 29.490800>, <6.056240, -0.292898, 29.501900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.056240, -0.292898, 29.501900>, <5.889910, -0.328750, 29.432700>, <5.910420, -0.281460, 29.417300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.261190, -0.312059, 29.625800>, <6.029400, -0.343196, 29.520800>, <6.056240, -0.292898, 29.501900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.819560, -0.168356, 29.364900>, <5.845460, -0.165581, 29.387600>, <5.919320, -0.146901, 29.424500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.919320, -0.146901, 29.424500>, <5.916720, -0.149189, 29.430900>, <5.823250, -0.168858, 29.363800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790810, -0.194725, 29.330300>, <5.845650, -0.196085, 29.382500>, <5.845460, -0.165581, 29.387600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.819560, -0.168356, 29.364900>, <5.823250, -0.168858, 29.363800>, <5.793840, -0.194702, 29.328400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.029400, -0.343196, 29.520800>, <6.032240, -0.348228, 29.515500>, <5.891520, -0.332872, 29.426400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.891520, -0.332872, 29.426400>, <5.889910, -0.328750, 29.432700>, <6.029400, -0.343196, 29.520800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.295650, -0.245351, 29.623100>, <6.310080, -0.243634, 29.618200>, <6.272860, -0.315772, 29.619000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.272860, -0.315772, 29.619000>, <6.261190, -0.312059, 29.625800>, <6.295650, -0.245351, 29.623100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.058620, -0.145722, 29.515400>, <6.062660, -0.139738, 29.509900>, <6.231480, -0.143495, 29.608400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231480, -0.143495, 29.608400>, <6.222200, -0.149331, 29.610600>, <6.058620, -0.145722, 29.515400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.222200, -0.149331, 29.610600>, <6.231480, -0.143495, 29.608400>, <6.289740, -0.189898, 29.618100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.289740, -0.189898, 29.618100>, <6.275170, -0.193067, 29.623400>, <6.222200, -0.149331, 29.610600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.779730, -0.262164, 29.329800>, <5.834530, -0.274619, 29.383300>, <5.845950, -0.232287, 29.376700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.783400, -0.225161, 29.317300>, <5.784080, -0.225076, 29.315700>, <5.782020, -0.262841, 29.329100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.202960, -0.345968, 29.616800>, <6.209050, -0.355752, 29.614100>, <6.032240, -0.348228, 29.515500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.032240, -0.348228, 29.515500>, <6.029400, -0.343196, 29.520800>, <6.202960, -0.345968, 29.616800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.261190, -0.312059, 29.625800>, <6.272860, -0.315772, 29.619000>, <6.209050, -0.355752, 29.614100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.209050, -0.355752, 29.614100>, <6.202960, -0.345968, 29.616800>, <6.261190, -0.312059, 29.625800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.916720, -0.149189, 29.430900>, <5.919320, -0.146901, 29.424500>, <6.062660, -0.139738, 29.509900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.062660, -0.139738, 29.509900>, <6.058620, -0.145722, 29.515400>, <5.916720, -0.149189, 29.430900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.275170, -0.193067, 29.623400>, <6.289740, -0.189898, 29.618100>, <6.310080, -0.243634, 29.618200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.310080, -0.243634, 29.618200>, <6.295650, -0.245351, 29.623100>, <6.275170, -0.193067, 29.623400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.783400, -0.225161, 29.317300>, <5.845950, -0.232287, 29.376700>, <5.845650, -0.196085, 29.382500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790810, -0.194725, 29.330300>, <5.793840, -0.194702, 29.328400>, <5.784080, -0.225076, 29.315700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790680, -0.288085, 29.360900>, <5.822440, -0.305526, 29.388100>, <5.834530, -0.274619, 29.383300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.779730, -0.262164, 29.329800>, <5.782020, -0.262841, 29.329100>, <5.792370, -0.290266, 29.359700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.889910, -0.328750, 29.432700>, <5.891520, -0.332872, 29.426400>, <5.822440, -0.305526, 29.388100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790680, -0.288085, 29.360900>, <5.792370, -0.290266, 29.359700>, <5.889910, -0.328750, 29.432700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790680, -0.288085, 29.360900>, <5.834530, -0.274619, 29.383300>, <5.779730, -0.262164, 29.329800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822440, -0.305526, 29.388100>, <5.790680, -0.288085, 29.360900>, <5.889910, -0.328750, 29.432700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.779730, -0.262164, 29.329800>, <5.845950, -0.232287, 29.376700>, <5.783400, -0.225161, 29.317300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.779730, -0.262164, 29.329800>, <5.792370, -0.290266, 29.359700>, <5.790680, -0.288085, 29.360900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.783400, -0.225161, 29.317300>, <5.782020, -0.262841, 29.329100>, <5.779730, -0.262164, 29.329800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.783400, -0.225161, 29.317300>, <5.845650, -0.196085, 29.382500>, <5.790810, -0.194725, 29.330300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790810, -0.194725, 29.330300>, <5.845460, -0.165581, 29.387600>, <5.819560, -0.168356, 29.364900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790810, -0.194725, 29.330300>, <5.784080, -0.225076, 29.315700>, <5.783400, -0.225161, 29.317300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.823250, -0.168858, 29.363800>, <5.819560, -0.168356, 29.364900>, <5.919320, -0.146901, 29.424500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.819560, -0.168356, 29.364900>, <5.793840, -0.194702, 29.328400>, <5.790810, -0.194725, 29.330300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.983890, 0.405215, 29.918300>, <7.157790, 0.407710, 30.123500>, <7.013550, 0.305919, 29.903200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.739390, 0.308629, 29.617600>, <6.612740, 0.311163, 29.487200>, <6.711860, 0.400057, 29.634200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.903410, 0.475272, 29.958100>, <7.070810, 0.482063, 30.159900>, <6.983890, 0.405215, 29.918300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.711860, 0.400057, 29.634200>, <6.589600, 0.394075, 29.506800>, <6.637880, 0.464995, 29.677300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.788510, 0.499473, 30.013900>, <6.947330, 0.508899, 30.211300>, <6.903410, 0.475272, 29.958100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.637880, 0.464995, 29.677300>, <6.528650, 0.453775, 29.556700>, <6.531550, 0.486368, 29.737600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.667350, 0.471715, 30.074900>, <6.823030, 0.478650, 30.262700>, <6.788510, 0.499473, 30.013900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.531550, 0.486368, 29.737600>, <6.439510, 0.471189, 29.625900>, <6.424830, 0.460309, 29.798700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.575670, 0.401850, 30.119000>, <6.733770, 0.403043, 30.299500>, <6.667350, 0.471715, 30.074900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.424830, 0.460309, 29.798700>, <6.350340, 0.447465, 29.696500>, <6.349330, 0.395316, 29.840700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.522310, 0.305223, 30.144000>, <6.698480, 0.298202, 30.313700>, <6.575670, 0.401850, 30.119000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349330, 0.395316, 29.840700>, <6.288530, 0.388645, 29.743700>, <6.307430, 0.305267, 29.865800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.551310, 0.207539, 30.125500>, <6.730180, 0.193794, 30.300000>, <6.522310, 0.305223, 30.144000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.307430, 0.305267, 29.865800>, <6.262420, 0.305240, 29.764000>, <6.328150, 0.215782, 29.845500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.628520, 0.138185, 30.085700>, <6.816880, 0.119379, 30.263600>, <6.551310, 0.207539, 30.125500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.328150, 0.215782, 29.845500>, <6.282660, 0.223748, 29.743700>, <6.392030, 0.152497, 29.807100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776530, 0.108724, 30.015800>, <6.940190, 0.090847, 30.212200>, <6.628520, 0.138185, 30.085700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392030, 0.152497, 29.807100>, <6.345890, 0.165146, 29.694000>, <6.518490, 0.127000, 29.738900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.897020, 0.134481, 29.958100>, <7.064610, 0.119466, 30.160700>, <6.776530, 0.108724, 30.015800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.518490, 0.127000, 29.738900>, <6.434840, 0.144970, 29.624300>, <6.631360, 0.150006, 29.676500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.980410, 0.206091, 29.918400>, <7.154150, 0.195137, 30.124000>, <6.897020, 0.134481, 29.958100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.631360, 0.150006, 29.676500>, <6.521530, 0.165575, 29.554100>, <6.708590, 0.216656, 29.633800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013550, 0.305919, 29.903200>, <7.189600, 0.301674, 30.109800>, <6.980410, 0.206091, 29.918400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.708590, 0.216656, 29.633800>, <6.586500, 0.227588, 29.505500>, <6.739390, 0.308629, 29.617600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.348280, 0.242441, 29.458800>, <6.304690, 0.230803, 29.492000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.380420, 0.272769, 29.435000>, <6.348280, 0.242441, 29.458800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.392510, 0.313667, 29.427000>, <6.380420, 0.272769, 29.435000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.381260, 0.354164, 29.436900>, <6.392510, 0.313667, 29.427000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.349700, 0.383391, 29.462000>, <6.381260, 0.354164, 29.436900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.306300, 0.393512, 29.495700>, <6.349700, 0.383391, 29.462000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.262690, 0.381831, 29.528900>, <6.306300, 0.393512, 29.495700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.230530, 0.351496, 29.552700>, <6.262690, 0.381831, 29.528900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.218450, 0.310635, 29.560700>, <6.230530, 0.351496, 29.552700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.229710, 0.270183, 29.550800>, <6.218450, 0.310635, 29.560700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.261280, 0.240963, 29.525700>, <6.229710, 0.270183, 29.550800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285670, 0.312735, 29.473700>, <6.304690, 0.230803, 29.492000>, <6.261280, 0.240963, 29.525700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.304690, 0.230803, 29.492000>, <6.433780, 0.188621, 29.488300>, <6.358250, 0.168291, 29.545800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.304690, 0.230803, 29.492000>, <6.348280, 0.242441, 29.458800>, <6.433780, 0.188621, 29.488300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.348280, 0.242441, 29.458800>, <6.489480, 0.241660, 29.447100>, <6.433780, 0.188621, 29.488300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.348280, 0.242441, 29.458800>, <6.380420, 0.272769, 29.435000>, <6.489480, 0.241660, 29.447100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.380420, 0.272769, 29.435000>, <6.510390, 0.313211, 29.433200>, <6.489480, 0.241660, 29.447100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.380420, 0.272769, 29.435000>, <6.392510, 0.313667, 29.427000>, <6.510390, 0.313211, 29.433200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392510, 0.313667, 29.427000>, <6.490910, 0.384060, 29.450400>, <6.510390, 0.313211, 29.433200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392510, 0.313667, 29.427000>, <6.381260, 0.354164, 29.436900>, <6.490910, 0.384060, 29.450400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.381260, 0.354164, 29.436900>, <6.436260, 0.435169, 29.494000>, <6.490910, 0.384060, 29.450400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.381260, 0.354164, 29.436900>, <6.349700, 0.383391, 29.462000>, <6.436260, 0.435169, 29.494000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349700, 0.383391, 29.462000>, <6.361090, 0.452839, 29.552300>, <6.436260, 0.435169, 29.494000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349700, 0.383391, 29.462000>, <6.306300, 0.393512, 29.495700>, <6.361090, 0.452839, 29.552300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.306300, 0.393512, 29.495700>, <6.285540, 0.432377, 29.609800>, <6.361090, 0.452839, 29.552300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.306300, 0.393512, 29.495700>, <6.262690, 0.381831, 29.528900>, <6.285540, 0.432377, 29.609800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.262690, 0.381831, 29.528900>, <6.229850, 0.379314, 29.651000>, <6.285540, 0.432377, 29.609800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.262690, 0.381831, 29.528900>, <6.230530, 0.351496, 29.552700>, <6.229850, 0.379314, 29.651000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.230530, 0.351496, 29.552700>, <6.208930, 0.307877, 29.664900>, <6.229850, 0.379314, 29.651000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.230530, 0.351496, 29.552700>, <6.218450, 0.310635, 29.560700>, <6.208930, 0.307877, 29.664900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.218450, 0.310635, 29.560700>, <6.228440, 0.237164, 29.647700>, <6.208930, 0.307877, 29.664900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.218450, 0.310635, 29.560700>, <6.229710, 0.270183, 29.550800>, <6.228440, 0.237164, 29.647700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229710, 0.270183, 29.550800>, <6.283080, 0.186075, 29.604100>, <6.228440, 0.237164, 29.647700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229710, 0.270183, 29.550800>, <6.261280, 0.240963, 29.525700>, <6.283080, 0.186075, 29.604100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.261280, 0.240963, 29.525700>, <6.358250, 0.168291, 29.545800>, <6.283080, 0.186075, 29.604100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.261280, 0.240963, 29.525700>, <6.304690, 0.230803, 29.492000>, <6.358250, 0.168291, 29.545800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.358250, 0.168291, 29.545800>, <6.521530, 0.165575, 29.554100>, <6.434840, 0.144970, 29.624300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.358250, 0.168291, 29.545800>, <6.433780, 0.188621, 29.488300>, <6.521530, 0.165575, 29.554100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.433780, 0.188621, 29.488300>, <6.586500, 0.227588, 29.505500>, <6.521530, 0.165575, 29.554100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.433780, 0.188621, 29.488300>, <6.489480, 0.241660, 29.447100>, <6.586500, 0.227588, 29.505500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.489480, 0.241660, 29.447100>, <6.612740, 0.311163, 29.487200>, <6.586500, 0.227588, 29.505500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.489480, 0.241660, 29.447100>, <6.510390, 0.313211, 29.433200>, <6.612740, 0.311163, 29.487200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.510390, 0.313211, 29.433200>, <6.589600, 0.394075, 29.506800>, <6.612740, 0.311163, 29.487200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.510390, 0.313211, 29.433200>, <6.490910, 0.384060, 29.450400>, <6.589600, 0.394075, 29.506800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.490910, 0.384060, 29.450400>, <6.528650, 0.453775, 29.556700>, <6.589600, 0.394075, 29.506800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.490910, 0.384060, 29.450400>, <6.436260, 0.435169, 29.494000>, <6.528650, 0.453775, 29.556700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.436260, 0.435169, 29.494000>, <6.439510, 0.471189, 29.625900>, <6.528650, 0.453775, 29.556700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.436260, 0.435169, 29.494000>, <6.361090, 0.452839, 29.552300>, <6.439510, 0.471189, 29.625900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.361090, 0.452839, 29.552300>, <6.350340, 0.447465, 29.696500>, <6.439510, 0.471189, 29.625900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.361090, 0.452839, 29.552300>, <6.285540, 0.432377, 29.609800>, <6.350340, 0.447465, 29.696500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285540, 0.432377, 29.609800>, <6.288530, 0.388645, 29.743700>, <6.350340, 0.447465, 29.696500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.285540, 0.432377, 29.609800>, <6.229850, 0.379314, 29.651000>, <6.288530, 0.388645, 29.743700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229850, 0.379314, 29.651000>, <6.262420, 0.305240, 29.764000>, <6.288530, 0.388645, 29.743700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229850, 0.379314, 29.651000>, <6.208930, 0.307877, 29.664900>, <6.262420, 0.305240, 29.764000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.208930, 0.307877, 29.664900>, <6.282660, 0.223748, 29.743700>, <6.262420, 0.305240, 29.764000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.208930, 0.307877, 29.664900>, <6.228440, 0.237164, 29.647700>, <6.282660, 0.223748, 29.743700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.228440, 0.237164, 29.647700>, <6.345890, 0.165146, 29.694000>, <6.282660, 0.223748, 29.743700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.228440, 0.237164, 29.647700>, <6.283080, 0.186075, 29.604100>, <6.345890, 0.165146, 29.694000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283080, 0.186075, 29.604100>, <6.434840, 0.144970, 29.624300>, <6.345890, 0.165146, 29.694000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283080, 0.186075, 29.604100>, <6.358250, 0.168291, 29.545800>, <6.434840, 0.144970, 29.624300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.288530, 0.388645, 29.743700>, <6.262420, 0.305240, 29.764000>, <6.307430, 0.305267, 29.865800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.522310, 0.305223, 30.144000>, <6.307430, 0.305267, 29.865800>, <6.551310, 0.207539, 30.125500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.262420, 0.305240, 29.764000>, <6.282660, 0.223748, 29.743700>, <6.328150, 0.215782, 29.845500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.551310, 0.207539, 30.125500>, <6.328150, 0.215782, 29.845500>, <6.628520, 0.138185, 30.085700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.350340, 0.447465, 29.696500>, <6.288530, 0.388645, 29.743700>, <6.349330, 0.395316, 29.840700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.575670, 0.401850, 30.119000>, <6.349330, 0.395316, 29.840700>, <6.522310, 0.305223, 30.144000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.439510, 0.471189, 29.625900>, <6.350340, 0.447465, 29.696500>, <6.424830, 0.460309, 29.798700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.667350, 0.471715, 30.074900>, <6.424830, 0.460309, 29.798700>, <6.575670, 0.401850, 30.119000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.282660, 0.223748, 29.743700>, <6.345890, 0.165146, 29.694000>, <6.392030, 0.152497, 29.807100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.628520, 0.138185, 30.085700>, <6.392030, 0.152497, 29.807100>, <6.776530, 0.108724, 30.015800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.345890, 0.165146, 29.694000>, <6.434840, 0.144970, 29.624300>, <6.518490, 0.127000, 29.738900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776530, 0.108724, 30.015800>, <6.518490, 0.127000, 29.738900>, <6.897020, 0.134481, 29.958100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.434840, 0.144970, 29.624300>, <6.521530, 0.165575, 29.554100>, <6.631360, 0.150006, 29.676500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.897020, 0.134481, 29.958100>, <6.631360, 0.150006, 29.676500>, <6.980410, 0.206091, 29.918400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.521530, 0.165575, 29.554100>, <6.586500, 0.227588, 29.505500>, <6.708590, 0.216656, 29.633800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.980410, 0.206091, 29.918400>, <6.708590, 0.216656, 29.633800>, <7.013550, 0.305919, 29.903200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.528650, 0.453775, 29.556700>, <6.439510, 0.471189, 29.625900>, <6.531550, 0.486368, 29.737600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.788510, 0.499473, 30.013900>, <6.531550, 0.486368, 29.737600>, <6.667350, 0.471715, 30.074900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.589600, 0.394075, 29.506800>, <6.528650, 0.453775, 29.556700>, <6.637880, 0.464995, 29.677300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.903410, 0.475272, 29.958100>, <6.637880, 0.464995, 29.677300>, <6.788510, 0.499473, 30.013900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.612740, 0.311163, 29.487200>, <6.589600, 0.394075, 29.506800>, <6.711860, 0.400057, 29.634200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.983890, 0.405215, 29.918300>, <6.711860, 0.400057, 29.634200>, <6.903410, 0.475272, 29.958100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013550, 0.305919, 29.903200>, <6.739390, 0.308629, 29.617600>, <6.983890, 0.405215, 29.918300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.586500, 0.227588, 29.505500>, <6.612740, 0.311163, 29.487200>, <6.739390, 0.308629, 29.617600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.708590, 0.216656, 29.633800>, <6.980410, 0.206091, 29.918400>, <6.631360, 0.150006, 29.676500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.980410, 0.206091, 29.918400>, <7.189600, 0.301674, 30.109800>, <7.154150, 0.195137, 30.124000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.739390, 0.308629, 29.617600>, <7.013550, 0.305919, 29.903200>, <6.708590, 0.216656, 29.633800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <7.013550, 0.305919, 29.903200>, <7.157790, 0.407710, 30.123500>, <7.189600, 0.301674, 30.109800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.711860, 0.400057, 29.634200>, <6.983890, 0.405215, 29.918300>, <6.739390, 0.308629, 29.617600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.983890, 0.405215, 29.918300>, <7.070810, 0.482063, 30.159900>, <7.157790, 0.407710, 30.123500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.631360, 0.150006, 29.676500>, <6.897020, 0.134481, 29.958100>, <6.518490, 0.127000, 29.738900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.897020, 0.134481, 29.958100>, <7.154150, 0.195137, 30.124000>, <7.064610, 0.119466, 30.160700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.518490, 0.127000, 29.738900>, <6.776530, 0.108724, 30.015800>, <6.392030, 0.152497, 29.807100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.776530, 0.108724, 30.015800>, <7.064610, 0.119466, 30.160700>, <6.940190, 0.090847, 30.212200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392030, 0.152497, 29.807100>, <6.628520, 0.138185, 30.085700>, <6.328150, 0.215782, 29.845500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.628520, 0.138185, 30.085700>, <6.940190, 0.090847, 30.212200>, <6.816880, 0.119379, 30.263600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.328150, 0.215782, 29.845500>, <6.551310, 0.207539, 30.125500>, <6.307430, 0.305267, 29.865800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.551310, 0.207539, 30.125500>, <6.816880, 0.119379, 30.263600>, <6.730180, 0.193794, 30.300000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.637880, 0.464995, 29.677300>, <6.903410, 0.475272, 29.958100>, <6.711860, 0.400057, 29.634200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.903410, 0.475272, 29.958100>, <6.947330, 0.508899, 30.211300>, <7.070810, 0.482063, 30.159900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.531550, 0.486368, 29.737600>, <6.788510, 0.499473, 30.013900>, <6.637880, 0.464995, 29.677300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.788510, 0.499473, 30.013900>, <6.823030, 0.478650, 30.262700>, <6.947330, 0.508899, 30.211300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.424830, 0.460309, 29.798700>, <6.667350, 0.471715, 30.074900>, <6.531550, 0.486368, 29.737600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.667350, 0.471715, 30.074900>, <6.733770, 0.403043, 30.299500>, <6.823030, 0.478650, 30.262700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349330, 0.395316, 29.840700>, <6.575670, 0.401850, 30.119000>, <6.424830, 0.460309, 29.798700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.575670, 0.401850, 30.119000>, <6.698480, 0.298202, 30.313700>, <6.733770, 0.403043, 30.299500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.307430, 0.305267, 29.865800>, <6.522310, 0.305223, 30.144000>, <6.349330, 0.395316, 29.840700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.522310, 0.305223, 30.144000>, <6.730180, 0.193794, 30.300000>, <6.698480, 0.298202, 30.313700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.712650, 0.281026, 29.287000>, <5.752500, 0.255524, 29.358500>, <5.754660, 0.329110, 29.367000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.784910, 0.217117, 29.314200>, <5.752500, 0.255524, 29.358500>, <5.712650, 0.281026, 29.287000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.834660, 0.200191, 29.253000>, <5.784910, 0.217117, 29.314200>, <5.740270, 0.248339, 29.251900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.888280, 0.216641, 29.201200>, <5.834660, 0.200191, 29.253000>, <5.773000, 0.230281, 29.209700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.932760, 0.237270, 29.155400>, <5.888280, 0.216641, 29.201200>, <5.822260, 0.245234, 29.162800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.953680, 0.292993, 29.146100>, <5.931320, 0.241605, 29.162400>, <5.811440, 0.317199, 29.055800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.858840, 0.417685, 29.094200>, <5.962990, 0.436024, 29.163900>, <5.825250, 0.390957, 29.056300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.947520, 0.455867, 29.195900>, <5.965600, 0.438629, 29.156900>, <5.883870, 0.420329, 29.119300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.899710, 0.472812, 29.267000>, <5.947520, 0.455867, 29.195900>, <5.865040, 0.439372, 29.156800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.838390, 0.446697, 29.317400>, <5.899710, 0.472812, 29.267000>, <5.832070, 0.447094, 29.211700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.779990, 0.405197, 29.361100>, <5.838390, 0.446697, 29.317400>, <5.775510, 0.428852, 29.249500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.754660, 0.329110, 29.367000>, <5.779990, 0.405197, 29.361100>, <5.735040, 0.384174, 29.292400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.051350, 0.226951, 29.613400>, <6.297240, 0.223221, 29.746800>, <6.041050, 0.318536, 29.639700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.877990, 0.321989, 29.507300>, <5.754660, 0.329110, 29.367000>, <5.874470, 0.234336, 29.483400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.095100, 0.181526, 29.554800>, <6.354240, 0.167162, 29.694300>, <6.051350, 0.226951, 29.613400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.874470, 0.234336, 29.483400>, <5.752500, 0.255524, 29.358500>, <5.921190, 0.194839, 29.430000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.165070, 0.156596, 29.466300>, <6.436210, 0.147316, 29.621600>, <6.095100, 0.181526, 29.554800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.921190, 0.194839, 29.430000>, <5.784910, 0.217117, 29.314200>, <5.981690, 0.171829, 29.355500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.237160, 0.172237, 29.393400>, <6.518390, 0.171347, 29.550200>, <6.165070, 0.156596, 29.466300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.981690, 0.171829, 29.355500>, <5.834660, 0.200191, 29.253000>, <6.049200, 0.183424, 29.285600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283740, 0.203293, 29.346400>, <6.580630, 0.230096, 29.500500>, <6.237160, 0.172237, 29.393400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.888280, 0.216641, 29.201200>, <5.932760, 0.237270, 29.155400>, <6.088450, 0.216406, 29.246400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.395100, 0.323377, 29.349800>, <6.605370, 0.311482, 29.485700>, <6.353700, 0.245641, 29.350300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.085640, 0.221770, 29.252300>, <5.931320, 0.241605, 29.162400>, <6.114790, 0.276421, 29.232100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.311010, 0.433332, 29.344700>, <6.584780, 0.391896, 29.507400>, <6.373840, 0.381948, 29.351800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.135570, 0.336082, 29.220700>, <5.970920, 0.344700, 29.136400>, <6.131030, 0.392801, 29.232900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283320, 0.470220, 29.393600>, <6.529460, 0.447942, 29.560300>, <6.311010, 0.433332, 29.344700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.124330, 0.442246, 29.244300>, <5.965600, 0.438629, 29.156900>, <6.108610, 0.474466, 29.287600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.228300, 0.490248, 29.474500>, <6.447400, 0.467900, 29.631500>, <6.283320, 0.470220, 29.393600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.108610, 0.474466, 29.287600>, <5.947520, 0.455867, 29.195900>, <6.056970, 0.496867, 29.374600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.148030, 0.463332, 29.566600>, <6.362900, 0.444113, 29.705200>, <6.228300, 0.490248, 29.474500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.056970, 0.496867, 29.374600>, <5.899710, 0.472812, 29.267000>, <5.977660, 0.468343, 29.430700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.072960, 0.410619, 29.625300>, <6.302960, 0.385012, 29.752300>, <6.148030, 0.463332, 29.566600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.977660, 0.468343, 29.430700>, <5.838390, 0.446697, 29.317400>, <5.905020, 0.412666, 29.497200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.041050, 0.318536, 29.639700>, <6.279260, 0.303404, 29.771500>, <6.072960, 0.410619, 29.625300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.905020, 0.412666, 29.497200>, <5.779990, 0.405197, 29.361100>, <5.877990, 0.321989, 29.507300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.921190, 0.194839, 29.430000>, <6.095100, 0.181526, 29.554800>, <5.874470, 0.234336, 29.483400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.095100, 0.181526, 29.554800>, <6.436210, 0.147316, 29.621600>, <6.354240, 0.167162, 29.694300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.981690, 0.171829, 29.355500>, <6.165070, 0.156596, 29.466300>, <5.921190, 0.194839, 29.430000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.165070, 0.156596, 29.466300>, <6.518390, 0.171347, 29.550200>, <6.436210, 0.147316, 29.621600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.049200, 0.183424, 29.285600>, <6.237160, 0.172237, 29.393400>, <5.981690, 0.171829, 29.355500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.237160, 0.172237, 29.393400>, <6.580630, 0.230096, 29.500500>, <6.518390, 0.171347, 29.550200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.874470, 0.234336, 29.483400>, <6.051350, 0.226951, 29.613400>, <5.877990, 0.321989, 29.507300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.051350, 0.226951, 29.613400>, <6.354240, 0.167162, 29.694300>, <6.297240, 0.223221, 29.746800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.041050, 0.318536, 29.639700>, <6.297240, 0.223221, 29.746800>, <6.279260, 0.303404, 29.771500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.877990, 0.321989, 29.507300>, <6.041050, 0.318536, 29.639700>, <5.905020, 0.412666, 29.497200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283740, 0.203293, 29.346400>, <6.237160, 0.172237, 29.393400>, <6.049200, 0.183424, 29.285600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.580630, 0.230096, 29.500500>, <6.283740, 0.203293, 29.346400>, <6.353700, 0.245641, 29.350300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.135570, 0.336082, 29.220700>, <6.379610, 0.321592, 29.355600>, <6.341360, 0.249659, 29.358200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.605370, 0.311482, 29.485700>, <6.395100, 0.323377, 29.349800>, <6.373840, 0.381948, 29.351800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.120070, 0.435673, 29.250300>, <6.300940, 0.427077, 29.347200>, <6.358200, 0.378582, 29.358000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.311010, 0.433332, 29.344700>, <6.529460, 0.447942, 29.560300>, <6.584780, 0.391896, 29.507400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.108610, 0.474466, 29.287600>, <6.283320, 0.470220, 29.393600>, <6.124330, 0.442246, 29.244300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283320, 0.470220, 29.393600>, <6.447400, 0.467900, 29.631500>, <6.529460, 0.447942, 29.560300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.056970, 0.496867, 29.374600>, <6.228300, 0.490248, 29.474500>, <6.108610, 0.474466, 29.287600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.228300, 0.490248, 29.474500>, <6.362900, 0.444113, 29.705200>, <6.447400, 0.467900, 29.631500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.977660, 0.468343, 29.430700>, <6.148030, 0.463332, 29.566600>, <6.056970, 0.496867, 29.374600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.148030, 0.463332, 29.566600>, <6.302960, 0.385012, 29.752300>, <6.362900, 0.444113, 29.705200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.905020, 0.412666, 29.497200>, <6.072960, 0.410619, 29.625300>, <5.977660, 0.468343, 29.430700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.072960, 0.410619, 29.625300>, <6.279260, 0.303404, 29.771500>, <6.302960, 0.385012, 29.752300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.848390, 0.349033, 29.105400>, <5.870240, 0.302328, 29.112400>, <5.856840, 0.268858, 29.117200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.813730, 0.358468, 29.042200>, <5.970390, 0.392819, 29.147700>, <5.970920, 0.344700, 29.136400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.856840, 0.268858, 29.117200>, <5.822260, 0.245234, 29.162800>, <5.798380, 0.348559, 29.122700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.811440, 0.317199, 29.055800>, <5.813730, 0.358468, 29.042200>, <5.953680, 0.292993, 29.146100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.759800, 0.338524, 29.148600>, <5.832070, 0.447094, 29.211700>, <5.798380, 0.348559, 29.122700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822260, 0.245234, 29.162800>, <5.856840, 0.268858, 29.117200>, <5.932760, 0.237270, 29.155400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.726460, 0.335477, 29.177800>, <5.775510, 0.428852, 29.249500>, <5.759800, 0.338524, 29.148600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.773000, 0.230281, 29.209700>, <5.822260, 0.245234, 29.162800>, <5.888280, 0.216641, 29.201200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.740270, 0.248339, 29.251900>, <5.712650, 0.281026, 29.287000>, <5.705070, 0.336081, 29.217800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.740270, 0.248339, 29.251900>, <5.773000, 0.230281, 29.209700>, <5.834660, 0.200191, 29.253000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.720430, 0.332595, 29.294300>, <5.735040, 0.384174, 29.292400>, <5.705070, 0.336081, 29.217800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.712650, 0.281026, 29.287000>, <5.740270, 0.248339, 29.251900>, <5.784910, 0.217117, 29.314200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.735040, 0.384174, 29.292400>, <5.775510, 0.428852, 29.249500>, <5.726460, 0.335477, 29.177800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.720430, 0.332595, 29.294300>, <5.712650, 0.281026, 29.287000>, <5.754660, 0.329110, 29.367000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.759800, 0.338524, 29.148600>, <5.773000, 0.230281, 29.209700>, <5.726460, 0.335477, 29.177800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.735040, 0.384174, 29.292400>, <5.720430, 0.332595, 29.294300>, <5.754660, 0.329110, 29.367000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.798380, 0.348559, 29.122700>, <5.822260, 0.245234, 29.162800>, <5.759800, 0.338524, 29.148600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.775510, 0.428852, 29.249500>, <5.735040, 0.384174, 29.292400>, <5.779990, 0.405197, 29.361100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.865040, 0.439372, 29.156800>, <5.848390, 0.349033, 29.105400>, <5.798380, 0.348559, 29.122700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.832070, 0.447094, 29.211700>, <5.775510, 0.428852, 29.249500>, <5.838390, 0.446697, 29.317400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.848390, 0.349033, 29.105400>, <5.865040, 0.439372, 29.156800>, <5.883870, 0.420329, 29.119300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.865040, 0.439372, 29.156800>, <5.832070, 0.447094, 29.211700>, <5.899710, 0.472812, 29.267000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.848390, 0.349033, 29.105400>, <5.883420, 0.387373, 29.113000>, <5.883000, 0.348246, 29.105800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.883870, 0.420329, 29.119300>, <5.865040, 0.439372, 29.156800>, <5.947520, 0.455867, 29.195900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.041050, 0.318536, 29.639700>, <5.877990, 0.321989, 29.507300>, <6.051350, 0.226951, 29.613400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.779990, 0.405197, 29.361100>, <5.754660, 0.329110, 29.367000>, <5.877990, 0.321989, 29.507300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.051350, 0.226951, 29.613400>, <5.874470, 0.234336, 29.483400>, <6.095100, 0.181526, 29.554800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.754660, 0.329110, 29.367000>, <5.752500, 0.255524, 29.358500>, <5.874470, 0.234336, 29.483400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.095100, 0.181526, 29.554800>, <5.921190, 0.194839, 29.430000>, <6.165070, 0.156596, 29.466300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.752500, 0.255524, 29.358500>, <5.784910, 0.217117, 29.314200>, <5.921190, 0.194839, 29.430000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.165070, 0.156596, 29.466300>, <5.981690, 0.171829, 29.355500>, <6.237160, 0.172237, 29.393400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.784910, 0.217117, 29.314200>, <5.834660, 0.200191, 29.253000>, <5.981690, 0.171829, 29.355500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.088450, 0.216406, 29.246400>, <6.049200, 0.183424, 29.285600>, <5.888280, 0.216641, 29.201200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.834660, 0.200191, 29.253000>, <5.888280, 0.216641, 29.201200>, <6.049200, 0.183424, 29.285600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277380, 0.213921, 29.349800>, <6.085640, 0.221770, 29.252300>, <6.341360, 0.249659, 29.358200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.049200, 0.183424, 29.285600>, <6.088450, 0.216406, 29.246400>, <6.283740, 0.203293, 29.346400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.072960, 0.410619, 29.625300>, <5.905020, 0.412666, 29.497200>, <6.041050, 0.318536, 29.639700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.838390, 0.446697, 29.317400>, <5.779990, 0.405197, 29.361100>, <5.905020, 0.412666, 29.497200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.148030, 0.463332, 29.566600>, <5.977660, 0.468343, 29.430700>, <6.072960, 0.410619, 29.625300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.899710, 0.472812, 29.267000>, <5.838390, 0.446697, 29.317400>, <5.977660, 0.468343, 29.430700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.228300, 0.490248, 29.474500>, <6.056970, 0.496867, 29.374600>, <6.148030, 0.463332, 29.566600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.947520, 0.455867, 29.195900>, <5.899710, 0.472812, 29.267000>, <6.056970, 0.496867, 29.374600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283320, 0.470220, 29.393600>, <6.108610, 0.474466, 29.287600>, <6.228300, 0.490248, 29.474500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.965600, 0.438629, 29.156900>, <5.947520, 0.455867, 29.195900>, <6.108610, 0.474466, 29.287600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.311010, 0.433332, 29.344700>, <6.124330, 0.442246, 29.244300>, <6.283320, 0.470220, 29.393600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.970390, 0.392819, 29.147700>, <5.962990, 0.436024, 29.163900>, <6.120070, 0.435673, 29.250300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.379610, 0.321592, 29.355600>, <6.135570, 0.336082, 29.220700>, <6.358200, 0.378582, 29.358000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.953680, 0.292993, 29.146100>, <5.970920, 0.344700, 29.136400>, <6.135570, 0.336082, 29.220700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.705070, 0.336081, 29.217800>, <5.712650, 0.281026, 29.287000>, <5.720430, 0.332595, 29.294300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.740270, 0.248339, 29.251900>, <5.705070, 0.336081, 29.217800>, <5.726460, 0.335477, 29.177800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.773000, 0.230281, 29.209700>, <5.740270, 0.248339, 29.251900>, <5.726460, 0.335477, 29.177800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.726460, 0.335477, 29.177800>, <5.705070, 0.336081, 29.217800>, <5.735040, 0.384174, 29.292400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822260, 0.245234, 29.162800>, <5.773000, 0.230281, 29.209700>, <5.759800, 0.338524, 29.148600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.759800, 0.338524, 29.148600>, <5.775510, 0.428852, 29.249500>, <5.832070, 0.447094, 29.211700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.798380, 0.348559, 29.122700>, <5.832070, 0.447094, 29.211700>, <5.865040, 0.439372, 29.156800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.798380, 0.348559, 29.122700>, <5.848390, 0.349033, 29.105400>, <5.856840, 0.268858, 29.117200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.353700, 0.245641, 29.350300>, <6.605370, 0.311482, 29.485700>, <6.580630, 0.230096, 29.500500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341360, 0.249659, 29.358200>, <6.114790, 0.276421, 29.232100>, <6.135570, 0.336082, 29.220700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.373840, 0.381948, 29.351800>, <6.584780, 0.391896, 29.507400>, <6.605370, 0.311482, 29.485700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.358200, 0.378582, 29.358000>, <6.131030, 0.392801, 29.232900>, <6.120070, 0.435673, 29.250300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.131030, 0.392801, 29.232900>, <5.970920, 0.344700, 29.136400>, <5.970390, 0.392819, 29.147700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.358200, 0.378582, 29.358000>, <6.135570, 0.336082, 29.220700>, <6.131030, 0.392801, 29.232900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.970390, 0.392819, 29.147700>, <5.813730, 0.358468, 29.042200>, <5.825250, 0.390957, 29.056300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.970390, 0.392819, 29.147700>, <6.120070, 0.435673, 29.250300>, <6.131030, 0.392801, 29.232900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.825250, 0.390957, 29.056300>, <5.962990, 0.436024, 29.163900>, <5.970390, 0.392819, 29.147700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.848390, 0.349033, 29.105400>, <5.883870, 0.420329, 29.119300>, <5.883420, 0.387373, 29.113000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.848390, 0.349033, 29.105400>, <5.883000, 0.348246, 29.105800>, <5.870240, 0.302328, 29.112400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.823400, 0.286541, 29.087900>, <5.811440, 0.317199, 29.055800>, <5.931320, 0.241605, 29.162400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.813730, 0.358468, 29.042200>, <5.970920, 0.344700, 29.136400>, <5.953680, 0.292993, 29.146100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.953680, 0.292993, 29.146100>, <6.135570, 0.336082, 29.220700>, <6.114790, 0.276421, 29.232100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.114790, 0.276421, 29.232100>, <5.931320, 0.241605, 29.162400>, <5.953680, 0.292993, 29.146100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341360, 0.249659, 29.358200>, <6.085640, 0.221770, 29.252300>, <6.114790, 0.276421, 29.232100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.854900, 0.418252, 29.095600>, <5.883870, 0.420329, 29.119300>, <5.965600, 0.438629, 29.156900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.965600, 0.438629, 29.156900>, <5.962990, 0.436024, 29.163900>, <5.858840, 0.417685, 29.094200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822020, 0.390927, 29.058400>, <5.883420, 0.387373, 29.113000>, <5.883870, 0.420329, 29.119300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.854900, 0.418252, 29.095600>, <5.858840, 0.417685, 29.094200>, <5.825250, 0.390957, 29.056300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.085640, 0.221770, 29.252300>, <6.088450, 0.216406, 29.246400>, <5.932760, 0.237270, 29.155400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.932760, 0.237270, 29.155400>, <5.931320, 0.241605, 29.162400>, <6.085640, 0.221770, 29.252300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.379610, 0.321592, 29.355600>, <6.395100, 0.323377, 29.349800>, <6.353700, 0.245641, 29.350300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.353700, 0.245641, 29.350300>, <6.341360, 0.249659, 29.358200>, <6.379610, 0.321592, 29.355600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.120070, 0.435673, 29.250300>, <6.124330, 0.442246, 29.244300>, <6.311010, 0.433332, 29.344700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.311010, 0.433332, 29.344700>, <6.300940, 0.427077, 29.347200>, <6.120070, 0.435673, 29.250300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.300940, 0.427077, 29.347200>, <6.311010, 0.433332, 29.344700>, <6.373840, 0.381948, 29.351800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.373840, 0.381948, 29.351800>, <6.358200, 0.378582, 29.358000>, <6.300940, 0.427077, 29.347200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.809010, 0.317948, 29.056700>, <5.870240, 0.302328, 29.112400>, <5.883000, 0.348246, 29.105800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.813060, 0.358344, 29.044000>, <5.813730, 0.358468, 29.042200>, <5.811440, 0.317199, 29.055800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277380, 0.213921, 29.349800>, <6.283740, 0.203293, 29.346400>, <6.088450, 0.216406, 29.246400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.088450, 0.216406, 29.246400>, <6.085640, 0.221770, 29.252300>, <6.277380, 0.213921, 29.349800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341360, 0.249659, 29.358200>, <6.353700, 0.245641, 29.350300>, <6.283740, 0.203293, 29.346400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.283740, 0.203293, 29.346400>, <6.277380, 0.213921, 29.349800>, <6.341360, 0.249659, 29.358200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.962990, 0.436024, 29.163900>, <5.965600, 0.438629, 29.156900>, <6.124330, 0.442246, 29.244300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.124330, 0.442246, 29.244300>, <6.120070, 0.435673, 29.250300>, <5.962990, 0.436024, 29.163900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.358200, 0.378582, 29.358000>, <6.373840, 0.381948, 29.351800>, <6.395100, 0.323377, 29.349800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.395100, 0.323377, 29.349800>, <6.379610, 0.321592, 29.355600>, <6.358200, 0.378582, 29.358000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.813060, 0.358344, 29.044000>, <5.883000, 0.348246, 29.105800>, <5.883420, 0.387373, 29.113000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822020, 0.390927, 29.058400>, <5.825250, 0.390957, 29.056300>, <5.813730, 0.358468, 29.042200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.821660, 0.288900, 29.089400>, <5.856840, 0.268858, 29.117200>, <5.870240, 0.302328, 29.112400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.809010, 0.317948, 29.056700>, <5.811440, 0.317199, 29.055800>, <5.823400, 0.286541, 29.087900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931320, 0.241605, 29.162400>, <5.932760, 0.237270, 29.155400>, <5.856840, 0.268858, 29.117200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.821660, 0.288900, 29.089400>, <5.823400, 0.286541, 29.087900>, <5.931320, 0.241605, 29.162400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.821660, 0.288900, 29.089400>, <5.870240, 0.302328, 29.112400>, <5.809010, 0.317948, 29.056700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.856840, 0.268858, 29.117200>, <5.821660, 0.288900, 29.089400>, <5.931320, 0.241605, 29.162400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.809010, 0.317948, 29.056700>, <5.883000, 0.348246, 29.105800>, <5.813060, 0.358344, 29.044000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.809010, 0.317948, 29.056700>, <5.823400, 0.286541, 29.087900>, <5.821660, 0.288900, 29.089400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.813060, 0.358344, 29.044000>, <5.811440, 0.317199, 29.055800>, <5.809010, 0.317948, 29.056700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.813060, 0.358344, 29.044000>, <5.883420, 0.387373, 29.113000>, <5.822020, 0.390927, 29.058400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822020, 0.390927, 29.058400>, <5.883870, 0.420329, 29.119300>, <5.854900, 0.418252, 29.095600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822020, 0.390927, 29.058400>, <5.813730, 0.358468, 29.042200>, <5.813060, 0.358344, 29.044000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.858840, 0.417685, 29.094200>, <5.854900, 0.418252, 29.095600>, <5.965600, 0.438629, 29.156900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.854900, 0.418252, 29.095600>, <5.825250, 0.390957, 29.056300>, <5.822020, 0.390927, 29.058400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.932470, 0.871385, 30.002900>, <7.095890, 0.864107, 30.189100>, <6.957770, 0.779904, 29.985300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.700810, 0.796289, 29.726500>, <6.582170, 0.804990, 29.608600>, <6.677350, 0.880443, 29.745200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.860200, 0.936044, 30.043000>, <7.017660, 0.932945, 30.226400>, <6.932470, 0.871385, 30.002900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677350, 0.880443, 29.745200>, <6.562630, 0.881127, 29.629600>, <6.611020, 0.940168, 29.788100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.755630, 0.958563, 30.097100>, <6.905170, 0.958183, 30.276600>, <6.860200, 0.936044, 30.043000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.611020, 0.940168, 29.788100>, <6.508320, 0.935587, 29.678400>, <6.514370, 0.959789, 29.846100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.644430, 0.933169, 30.154300>, <6.790890, 0.930851, 30.325000>, <6.755630, 0.958563, 30.097100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.514370, 0.959789, 29.846100>, <6.427570, 0.950975, 29.744200>, <6.416510, 0.935706, 29.903100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.559390, 0.869019, 30.194200>, <6.707860, 0.861603, 30.357900>, <6.644430, 0.933169, 30.154300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.416510, 0.935706, 29.903100>, <6.346070, 0.928432, 29.809800>, <6.346430, 0.875824, 29.941000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.508870, 0.780164, 30.215000>, <6.673670, 0.765214, 30.368200>, <6.559390, 0.869019, 30.194200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.346430, 0.875824, 29.941000>, <6.288790, 0.873832, 29.852500>, <6.306600, 0.792826, 29.961900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.533540, 0.690283, 30.194400>, <6.700790, 0.668936, 30.351800>, <6.508870, 0.780164, 30.215000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.306600, 0.792826, 29.961900>, <6.263550, 0.796832, 29.868900>, <6.323750, 0.710696, 29.940100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.602810, 0.626323, 30.154300>, <6.778770, 0.600045, 30.314500>, <6.533540, 0.690283, 30.194400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.323750, 0.710696, 29.940100>, <6.280420, 0.722072, 29.847300>, <6.380890, 0.652512, 29.901700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.737580, 0.598830, 30.086600>, <6.891070, 0.573253, 30.264300>, <6.602810, 0.626323, 30.154300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.380890, 0.652512, 29.901700>, <6.336850, 0.668580, 29.798700>, <6.495890, 0.628996, 29.836100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.848180, 0.622287, 30.032400>, <7.005430, 0.599073, 30.215800>, <6.737580, 0.598830, 30.086600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.495890, 0.628996, 29.836100>, <6.417380, 0.650661, 29.732500>, <6.599330, 0.650202, 29.777500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.925680, 0.688057, 29.996700>, <7.088720, 0.668379, 30.182900>, <6.848180, 0.622287, 30.032400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.599330, 0.650202, 29.777500>, <6.496530, 0.670367, 29.667100>, <6.671030, 0.711605, 29.739100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.957770, 0.779904, 29.985300>, <7.123090, 0.766333, 30.172700>, <6.925680, 0.688057, 29.996700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.671030, 0.711605, 29.739100>, <6.556770, 0.727895, 29.623200>, <6.700810, 0.796289, 29.726500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.336820, 0.747224, 29.584500>, <6.296960, 0.736206, 29.615400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.366620, 0.775352, 29.563000>, <6.336820, 0.747224, 29.584500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.378370, 0.813062, 29.556700>, <6.366620, 0.775352, 29.563000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.368880, 0.850239, 29.567300>, <6.378370, 0.813062, 29.556700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.340720, 0.876903, 29.591900>, <6.368880, 0.850239, 29.567300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.301440, 0.885909, 29.623900>, <6.340720, 0.876903, 29.591900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.261560, 0.874855, 29.654800>, <6.301440, 0.885909, 29.623900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.231750, 0.846722, 29.676300>, <6.261560, 0.874855, 29.654800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.220010, 0.809046, 29.682600>, <6.231750, 0.846722, 29.676300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.229500, 0.771909, 29.672000>, <6.220010, 0.809046, 29.682600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.257680, 0.745249, 29.647400>, <6.229500, 0.771909, 29.672000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280630, 0.812584, 29.601400>, <6.296960, 0.736206, 29.615400>, <6.257680, 0.745249, 29.647400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.296960, 0.736206, 29.615400>, <6.415080, 0.695221, 29.608600>, <6.346020, 0.675985, 29.662100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.296960, 0.736206, 29.615400>, <6.336820, 0.747224, 29.584500>, <6.415080, 0.695221, 29.608600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.336820, 0.747224, 29.584500>, <6.466720, 0.744410, 29.571400>, <6.415080, 0.695221, 29.608600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.336820, 0.747224, 29.584500>, <6.366620, 0.775352, 29.563000>, <6.466720, 0.744410, 29.571400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.366620, 0.775352, 29.563000>, <6.487060, 0.810386, 29.560600>, <6.466720, 0.744410, 29.571400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.366620, 0.775352, 29.563000>, <6.378370, 0.813062, 29.556700>, <6.487060, 0.810386, 29.560600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.378370, 0.813062, 29.556700>, <6.470650, 0.875427, 29.578900>, <6.487060, 0.810386, 29.560600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.378370, 0.813062, 29.556700>, <6.368880, 0.850239, 29.567300>, <6.470650, 0.875427, 29.578900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.368880, 0.850239, 29.567300>, <6.421890, 0.922064, 29.621500>, <6.470650, 0.875427, 29.578900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.368880, 0.850239, 29.567300>, <6.340720, 0.876903, 29.591900>, <6.421890, 0.922064, 29.621500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.340720, 0.876903, 29.591900>, <6.353860, 0.937791, 29.677000>, <6.421890, 0.922064, 29.621500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.340720, 0.876903, 29.591900>, <6.301440, 0.885909, 29.623900>, <6.353860, 0.937791, 29.677000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.301440, 0.885909, 29.623900>, <6.284770, 0.918432, 29.730500>, <6.353860, 0.937791, 29.677000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.301440, 0.885909, 29.623900>, <6.261560, 0.874855, 29.654800>, <6.284770, 0.918432, 29.730500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.261560, 0.874855, 29.654800>, <6.233140, 0.869219, 29.767700>, <6.284770, 0.918432, 29.730500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.261560, 0.874855, 29.654800>, <6.231750, 0.846722, 29.676300>, <6.233140, 0.869219, 29.767700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231750, 0.846722, 29.676300>, <6.212790, 0.803354, 29.778600>, <6.233140, 0.869219, 29.767700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.231750, 0.846722, 29.676300>, <6.220010, 0.809046, 29.682600>, <6.212790, 0.803354, 29.778600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.220010, 0.809046, 29.682600>, <6.229230, 0.738435, 29.760300>, <6.212790, 0.803354, 29.778600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.220010, 0.809046, 29.682600>, <6.229500, 0.771909, 29.672000>, <6.229230, 0.738435, 29.760300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229500, 0.771909, 29.672000>, <6.277980, 0.691816, 29.717600>, <6.229230, 0.738435, 29.760300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229500, 0.771909, 29.672000>, <6.257680, 0.745249, 29.647400>, <6.277980, 0.691816, 29.717600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.257680, 0.745249, 29.647400>, <6.346020, 0.675985, 29.662100>, <6.277980, 0.691816, 29.717600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.257680, 0.745249, 29.647400>, <6.296960, 0.736206, 29.615400>, <6.346020, 0.675985, 29.662100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.346020, 0.675985, 29.662100>, <6.496530, 0.670367, 29.667100>, <6.417380, 0.650661, 29.732500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.346020, 0.675985, 29.662100>, <6.415080, 0.695221, 29.608600>, <6.496530, 0.670367, 29.667100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.415080, 0.695221, 29.608600>, <6.556770, 0.727895, 29.623200>, <6.496530, 0.670367, 29.667100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.415080, 0.695221, 29.608600>, <6.466720, 0.744410, 29.571400>, <6.556770, 0.727895, 29.623200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.466720, 0.744410, 29.571400>, <6.582170, 0.804990, 29.608600>, <6.556770, 0.727895, 29.623200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.466720, 0.744410, 29.571400>, <6.487060, 0.810386, 29.560600>, <6.582170, 0.804990, 29.608600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.487060, 0.810386, 29.560600>, <6.562630, 0.881127, 29.629600>, <6.582170, 0.804990, 29.608600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.487060, 0.810386, 29.560600>, <6.470650, 0.875427, 29.578900>, <6.562630, 0.881127, 29.629600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.470650, 0.875427, 29.578900>, <6.508320, 0.935587, 29.678400>, <6.562630, 0.881127, 29.629600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.470650, 0.875427, 29.578900>, <6.421890, 0.922064, 29.621500>, <6.508320, 0.935587, 29.678400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.421890, 0.922064, 29.621500>, <6.427570, 0.950975, 29.744200>, <6.508320, 0.935587, 29.678400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.421890, 0.922064, 29.621500>, <6.353860, 0.937791, 29.677000>, <6.427570, 0.950975, 29.744200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.353860, 0.937791, 29.677000>, <6.346070, 0.928432, 29.809800>, <6.427570, 0.950975, 29.744200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.353860, 0.937791, 29.677000>, <6.284770, 0.918432, 29.730500>, <6.346070, 0.928432, 29.809800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.284770, 0.918432, 29.730500>, <6.288790, 0.873832, 29.852500>, <6.346070, 0.928432, 29.809800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.284770, 0.918432, 29.730500>, <6.233140, 0.869219, 29.767700>, <6.288790, 0.873832, 29.852500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.233140, 0.869219, 29.767700>, <6.263550, 0.796832, 29.868900>, <6.288790, 0.873832, 29.852500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.233140, 0.869219, 29.767700>, <6.212790, 0.803354, 29.778600>, <6.263550, 0.796832, 29.868900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212790, 0.803354, 29.778600>, <6.280420, 0.722072, 29.847300>, <6.263550, 0.796832, 29.868900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212790, 0.803354, 29.778600>, <6.229230, 0.738435, 29.760300>, <6.280420, 0.722072, 29.847300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229230, 0.738435, 29.760300>, <6.336850, 0.668580, 29.798700>, <6.280420, 0.722072, 29.847300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.229230, 0.738435, 29.760300>, <6.277980, 0.691816, 29.717600>, <6.336850, 0.668580, 29.798700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277980, 0.691816, 29.717600>, <6.417380, 0.650661, 29.732500>, <6.336850, 0.668580, 29.798700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277980, 0.691816, 29.717600>, <6.346020, 0.675985, 29.662100>, <6.417380, 0.650661, 29.732500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.288790, 0.873832, 29.852500>, <6.263550, 0.796832, 29.868900>, <6.306600, 0.792826, 29.961900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.508870, 0.780164, 30.215000>, <6.306600, 0.792826, 29.961900>, <6.533540, 0.690283, 30.194400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.263550, 0.796832, 29.868900>, <6.280420, 0.722072, 29.847300>, <6.323750, 0.710696, 29.940100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.533540, 0.690283, 30.194400>, <6.323750, 0.710696, 29.940100>, <6.602810, 0.626323, 30.154300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.346070, 0.928432, 29.809800>, <6.288790, 0.873832, 29.852500>, <6.346430, 0.875824, 29.941000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.559390, 0.869019, 30.194200>, <6.346430, 0.875824, 29.941000>, <6.508870, 0.780164, 30.215000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.427570, 0.950975, 29.744200>, <6.346070, 0.928432, 29.809800>, <6.416510, 0.935706, 29.903100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.644430, 0.933169, 30.154300>, <6.416510, 0.935706, 29.903100>, <6.559390, 0.869019, 30.194200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.280420, 0.722072, 29.847300>, <6.336850, 0.668580, 29.798700>, <6.380890, 0.652512, 29.901700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.602810, 0.626323, 30.154300>, <6.380890, 0.652512, 29.901700>, <6.737580, 0.598830, 30.086600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.336850, 0.668580, 29.798700>, <6.417380, 0.650661, 29.732500>, <6.495890, 0.628996, 29.836100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.737580, 0.598830, 30.086600>, <6.495890, 0.628996, 29.836100>, <6.848180, 0.622287, 30.032400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.417380, 0.650661, 29.732500>, <6.496530, 0.670367, 29.667100>, <6.599330, 0.650202, 29.777500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.848180, 0.622287, 30.032400>, <6.599330, 0.650202, 29.777500>, <6.925680, 0.688057, 29.996700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.496530, 0.670367, 29.667100>, <6.556770, 0.727895, 29.623200>, <6.671030, 0.711605, 29.739100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.925680, 0.688057, 29.996700>, <6.671030, 0.711605, 29.739100>, <6.957770, 0.779904, 29.985300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.508320, 0.935587, 29.678400>, <6.427570, 0.950975, 29.744200>, <6.514370, 0.959789, 29.846100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.755630, 0.958563, 30.097100>, <6.514370, 0.959789, 29.846100>, <6.644430, 0.933169, 30.154300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.562630, 0.881127, 29.629600>, <6.508320, 0.935587, 29.678400>, <6.611020, 0.940168, 29.788100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.860200, 0.936044, 30.043000>, <6.611020, 0.940168, 29.788100>, <6.755630, 0.958563, 30.097100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.582170, 0.804990, 29.608600>, <6.562630, 0.881127, 29.629600>, <6.677350, 0.880443, 29.745200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.932470, 0.871385, 30.002900>, <6.677350, 0.880443, 29.745200>, <6.860200, 0.936044, 30.043000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.957770, 0.779904, 29.985300>, <6.700810, 0.796289, 29.726500>, <6.932470, 0.871385, 30.002900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.556770, 0.727895, 29.623200>, <6.582170, 0.804990, 29.608600>, <6.700810, 0.796289, 29.726500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.671030, 0.711605, 29.739100>, <6.925680, 0.688057, 29.996700>, <6.599330, 0.650202, 29.777500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.925680, 0.688057, 29.996700>, <7.123090, 0.766333, 30.172700>, <7.088720, 0.668379, 30.182900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.700810, 0.796289, 29.726500>, <6.957770, 0.779904, 29.985300>, <6.671030, 0.711605, 29.739100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.957770, 0.779904, 29.985300>, <7.095890, 0.864107, 30.189100>, <7.123090, 0.766333, 30.172700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.677350, 0.880443, 29.745200>, <6.932470, 0.871385, 30.002900>, <6.700810, 0.796289, 29.726500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.932470, 0.871385, 30.002900>, <7.017660, 0.932945, 30.226400>, <7.095890, 0.864107, 30.189100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.599330, 0.650202, 29.777500>, <6.848180, 0.622287, 30.032400>, <6.495890, 0.628996, 29.836100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.848180, 0.622287, 30.032400>, <7.088720, 0.668379, 30.182900>, <7.005430, 0.599073, 30.215800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.495890, 0.628996, 29.836100>, <6.737580, 0.598830, 30.086600>, <6.380890, 0.652512, 29.901700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.737580, 0.598830, 30.086600>, <7.005430, 0.599073, 30.215800>, <6.891070, 0.573253, 30.264300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.380890, 0.652512, 29.901700>, <6.602810, 0.626323, 30.154300>, <6.323750, 0.710696, 29.940100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.602810, 0.626323, 30.154300>, <6.891070, 0.573253, 30.264300>, <6.778770, 0.600045, 30.314500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.323750, 0.710696, 29.940100>, <6.533540, 0.690283, 30.194400>, <6.306600, 0.792826, 29.961900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.533540, 0.690283, 30.194400>, <6.778770, 0.600045, 30.314500>, <6.700790, 0.668936, 30.351800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.611020, 0.940168, 29.788100>, <6.860200, 0.936044, 30.043000>, <6.677350, 0.880443, 29.745200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.860200, 0.936044, 30.043000>, <6.905170, 0.958183, 30.276600>, <7.017660, 0.932945, 30.226400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.514370, 0.959789, 29.846100>, <6.755630, 0.958563, 30.097100>, <6.611020, 0.940168, 29.788100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.755630, 0.958563, 30.097100>, <6.790890, 0.930851, 30.325000>, <6.905170, 0.958183, 30.276600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.416510, 0.935706, 29.903100>, <6.644430, 0.933169, 30.154300>, <6.514370, 0.959789, 29.846100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.644430, 0.933169, 30.154300>, <6.707860, 0.861603, 30.357900>, <6.790890, 0.930851, 30.325000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.346430, 0.875824, 29.941000>, <6.559390, 0.869019, 30.194200>, <6.416510, 0.935706, 29.903100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.559390, 0.869019, 30.194200>, <6.673670, 0.765214, 30.368200>, <6.707860, 0.861603, 30.357900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.306600, 0.792826, 29.961900>, <6.508870, 0.780164, 30.215000>, <6.346430, 0.875824, 29.941000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.508870, 0.780164, 30.215000>, <6.700790, 0.668936, 30.351800>, <6.673670, 0.765214, 30.368200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.763650, 0.800659, 29.381900>, <5.796350, 0.774259, 29.448800>, <5.799280, 0.841737, 29.458900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.827640, 0.739553, 29.408400>, <5.796350, 0.774259, 29.448800>, <5.763650, 0.800659, 29.381900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.876100, 0.724788, 29.354000>, <5.827640, 0.739553, 29.408400>, <5.790170, 0.771046, 29.349900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.928270, 0.740403, 29.309500>, <5.876100, 0.724788, 29.354000>, <5.822030, 0.755012, 29.312200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.971830, 0.759873, 29.270100>, <5.928270, 0.740403, 29.309500>, <5.869920, 0.769193, 29.271800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.992550, 0.811052, 29.264300>, <5.970230, 0.763687, 29.276600>, <5.866510, 0.838860, 29.175100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.910100, 0.929320, 29.215800>, <6.002870, 0.942066, 29.285500>, <5.880550, 0.906496, 29.178500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.987430, 0.959700, 29.314800>, <6.005670, 0.944619, 29.279300>, <5.931960, 0.930513, 29.240100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.940270, 0.974152, 29.378400>, <5.987430, 0.959700, 29.314800>, <5.913130, 0.947314, 29.274300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.880910, 0.949830, 29.421000>, <5.940270, 0.974152, 29.378400>, <5.880260, 0.953454, 29.323500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.824270, 0.911477, 29.457100>, <5.880910, 0.949830, 29.421000>, <5.826040, 0.936663, 29.354900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.799280, 0.841737, 29.458900>, <5.824270, 0.911477, 29.457100>, <5.785870, 0.895048, 29.391100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.058370, 0.734424, 29.696800>, <6.278050, 0.722129, 29.831300>, <6.049280, 0.818199, 29.723300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.905770, 0.828559, 29.593700>, <5.799280, 0.841737, 29.458900>, <5.902090, 0.748609, 29.568900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.100660, 0.693456, 29.643600>, <6.332030, 0.670921, 29.784000>, <6.058370, 0.734424, 29.696800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.902090, 0.748609, 29.568900>, <5.796350, 0.774259, 29.448800>, <5.946980, 0.712883, 29.520900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.168920, 0.671724, 29.564800>, <6.410650, 0.653165, 29.720500>, <6.100660, 0.693456, 29.643600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.946980, 0.712883, 29.520900>, <5.827640, 0.739553, 29.408400>, <6.005860, 0.692697, 29.454500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.239100, 0.686855, 29.501700>, <6.490200, 0.675776, 29.659500>, <6.168920, 0.671724, 29.564800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.005860, 0.692697, 29.454500>, <5.876100, 0.724788, 29.354000>, <6.071620, 0.704102, 29.393800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.284830, 0.715919, 29.461700>, <6.550980, 0.730112, 29.618600>, <6.239100, 0.686855, 29.501700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.928270, 0.740403, 29.309500>, <5.971830, 0.759873, 29.270100>, <6.110250, 0.734856, 29.360700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.389340, 0.824193, 29.473800>, <6.575960, 0.805014, 29.608600>, <6.349790, 0.753410, 29.469900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.107470, 0.739675, 29.366200>, <5.970230, 0.763687, 29.276600>, <6.136290, 0.790025, 29.350600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.314220, 0.927287, 29.468400>, <6.557430, 0.878840, 29.630000>, <6.370750, 0.878498, 29.476500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.157060, 0.844897, 29.343000>, <6.009830, 0.858618, 29.257700>, <6.153320, 0.896861, 29.355700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.287030, 0.960362, 29.513200>, <6.504980, 0.929991, 29.677800>, <6.314220, 0.927287, 29.468400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.147510, 0.942196, 29.367400>, <6.005670, 0.944619, 29.279300>, <6.131530, 0.970897, 29.407500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.232820, 0.977505, 29.585700>, <6.426350, 0.947898, 29.740000>, <6.287030, 0.960362, 29.513200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.131530, 0.970897, 29.407500>, <5.987430, 0.959700, 29.314800>, <6.080170, 0.989981, 29.485700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.153960, 0.951587, 29.665700>, <6.344550, 0.925490, 29.803000>, <6.232820, 0.977505, 29.585700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.080170, 0.989981, 29.485700>, <5.940270, 0.974152, 29.378400>, <6.003930, 0.963627, 29.532600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.081050, 0.902797, 29.714400>, <6.286010, 0.870860, 29.841500>, <6.153960, 0.951587, 29.665700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.003930, 0.963627, 29.532600>, <5.880910, 0.949830, 29.421000>, <5.932810, 0.911829, 29.588500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.049280, 0.818199, 29.723300>, <6.261770, 0.795605, 29.855500>, <6.081050, 0.902797, 29.714400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.932810, 0.911829, 29.588500>, <5.824270, 0.911477, 29.457100>, <5.905770, 0.828559, 29.593700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.946980, 0.712883, 29.520900>, <6.100660, 0.693456, 29.643600>, <5.902090, 0.748609, 29.568900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.100660, 0.693456, 29.643600>, <6.410650, 0.653165, 29.720500>, <6.332030, 0.670921, 29.784000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.005860, 0.692697, 29.454500>, <6.168920, 0.671724, 29.564800>, <5.946980, 0.712883, 29.520900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.168920, 0.671724, 29.564800>, <6.490200, 0.675776, 29.659500>, <6.410650, 0.653165, 29.720500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.071620, 0.704102, 29.393800>, <6.239100, 0.686855, 29.501700>, <6.005860, 0.692697, 29.454500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.239100, 0.686855, 29.501700>, <6.550980, 0.730112, 29.618600>, <6.490200, 0.675776, 29.659500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.902090, 0.748609, 29.568900>, <6.058370, 0.734424, 29.696800>, <5.905770, 0.828559, 29.593700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.058370, 0.734424, 29.696800>, <6.332030, 0.670921, 29.784000>, <6.278050, 0.722129, 29.831300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.049280, 0.818199, 29.723300>, <6.278050, 0.722129, 29.831300>, <6.261770, 0.795605, 29.855500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.905770, 0.828559, 29.593700>, <6.049280, 0.818199, 29.723300>, <5.932810, 0.911829, 29.588500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.284830, 0.715919, 29.461700>, <6.239100, 0.686855, 29.501700>, <6.071620, 0.704102, 29.393800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.550980, 0.730112, 29.618600>, <6.284830, 0.715919, 29.461700>, <6.349790, 0.753410, 29.469900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.157060, 0.844897, 29.343000>, <6.374760, 0.822684, 29.478400>, <6.338120, 0.757122, 29.476700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.575960, 0.805014, 29.608600>, <6.389340, 0.824193, 29.473800>, <6.370750, 0.878498, 29.476500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.143180, 0.936050, 29.372500>, <6.304720, 0.921651, 29.470100>, <6.355990, 0.875527, 29.481300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.314220, 0.927287, 29.468400>, <6.504980, 0.929991, 29.677800>, <6.557430, 0.878840, 29.630000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.131530, 0.970897, 29.407500>, <6.287030, 0.960362, 29.513200>, <6.147510, 0.942196, 29.367400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.287030, 0.960362, 29.513200>, <6.426350, 0.947898, 29.740000>, <6.504980, 0.929991, 29.677800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.080170, 0.989981, 29.485700>, <6.232820, 0.977505, 29.585700>, <6.131530, 0.970897, 29.407500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.232820, 0.977505, 29.585700>, <6.344550, 0.925490, 29.803000>, <6.426350, 0.947898, 29.740000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.003930, 0.963627, 29.532600>, <6.153960, 0.951587, 29.665700>, <6.080170, 0.989981, 29.485700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.153960, 0.951587, 29.665700>, <6.286010, 0.870860, 29.841500>, <6.344550, 0.925490, 29.803000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.932810, 0.911829, 29.588500>, <6.081050, 0.902797, 29.714400>, <6.003930, 0.963627, 29.532600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.081050, 0.902797, 29.714400>, <6.261770, 0.795605, 29.855500>, <6.286010, 0.870860, 29.841500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.898680, 0.865971, 29.223400>, <5.917580, 0.822314, 29.229500>, <5.904410, 0.791612, 29.232300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.870050, 0.877226, 29.163900>, <6.009670, 0.902608, 29.269600>, <6.009830, 0.858618, 29.257700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.904410, 0.791612, 29.232300>, <5.869920, 0.769193, 29.271800>, <5.851810, 0.866020, 29.236900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.866510, 0.838860, 29.175100>, <5.870050, 0.877226, 29.163900>, <5.992550, 0.811052, 29.264300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814850, 0.856777, 29.258600>, <5.880260, 0.953454, 29.323500>, <5.851810, 0.866020, 29.236900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869920, 0.769193, 29.271800>, <5.904410, 0.791612, 29.232300>, <5.971830, 0.759873, 29.270100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.782690, 0.853772, 29.283800>, <5.826040, 0.936663, 29.354900>, <5.814850, 0.856777, 29.258600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822030, 0.755012, 29.312200>, <5.869920, 0.769193, 29.271800>, <5.928270, 0.740403, 29.309500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790170, 0.771046, 29.349900>, <5.763650, 0.800659, 29.381900>, <5.761060, 0.853570, 29.319500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790170, 0.771046, 29.349900>, <5.822030, 0.755012, 29.312200>, <5.876100, 0.724788, 29.354000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.771400, 0.847783, 29.390600>, <5.785870, 0.895048, 29.391100>, <5.761060, 0.853570, 29.319500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.763650, 0.800659, 29.381900>, <5.790170, 0.771046, 29.349900>, <5.827640, 0.739553, 29.408400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.785870, 0.895048, 29.391100>, <5.826040, 0.936663, 29.354900>, <5.782690, 0.853772, 29.283800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.771400, 0.847783, 29.390600>, <5.763650, 0.800659, 29.381900>, <5.799280, 0.841737, 29.458900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814850, 0.856777, 29.258600>, <5.822030, 0.755012, 29.312200>, <5.782690, 0.853772, 29.283800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.785870, 0.895048, 29.391100>, <5.771400, 0.847783, 29.390600>, <5.799280, 0.841737, 29.458900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.851810, 0.866020, 29.236900>, <5.869920, 0.769193, 29.271800>, <5.814850, 0.856777, 29.258600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.826040, 0.936663, 29.354900>, <5.785870, 0.895048, 29.391100>, <5.824270, 0.911477, 29.457100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.913130, 0.947314, 29.274300>, <5.898680, 0.865971, 29.223400>, <5.851810, 0.866020, 29.236900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.880260, 0.953454, 29.323500>, <5.826040, 0.936663, 29.354900>, <5.880910, 0.949830, 29.421000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.898680, 0.865971, 29.223400>, <5.913130, 0.947314, 29.274300>, <5.931960, 0.930513, 29.240100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.913130, 0.947314, 29.274300>, <5.880260, 0.953454, 29.323500>, <5.940270, 0.974152, 29.378400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.898680, 0.865971, 29.223400>, <5.931250, 0.900356, 29.233300>, <5.930500, 0.864544, 29.225500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931960, 0.930513, 29.240100>, <5.913130, 0.947314, 29.274300>, <5.987430, 0.959700, 29.314800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.049280, 0.818199, 29.723300>, <5.905770, 0.828559, 29.593700>, <6.058370, 0.734424, 29.696800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.824270, 0.911477, 29.457100>, <5.799280, 0.841737, 29.458900>, <5.905770, 0.828559, 29.593700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.058370, 0.734424, 29.696800>, <5.902090, 0.748609, 29.568900>, <6.100660, 0.693456, 29.643600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.799280, 0.841737, 29.458900>, <5.796350, 0.774259, 29.448800>, <5.902090, 0.748609, 29.568900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.100660, 0.693456, 29.643600>, <5.946980, 0.712883, 29.520900>, <6.168920, 0.671724, 29.564800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.796350, 0.774259, 29.448800>, <5.827640, 0.739553, 29.408400>, <5.946980, 0.712883, 29.520900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.168920, 0.671724, 29.564800>, <6.005860, 0.692697, 29.454500>, <6.239100, 0.686855, 29.501700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.827640, 0.739553, 29.408400>, <5.876100, 0.724788, 29.354000>, <6.005860, 0.692697, 29.454500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.110250, 0.734856, 29.360700>, <6.071620, 0.704102, 29.393800>, <5.928270, 0.740403, 29.309500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.876100, 0.724788, 29.354000>, <5.928270, 0.740403, 29.309500>, <6.071620, 0.704102, 29.393800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.279000, 0.725733, 29.464800>, <6.107470, 0.739675, 29.366200>, <6.338120, 0.757122, 29.476700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.071620, 0.704102, 29.393800>, <6.110250, 0.734856, 29.360700>, <6.284830, 0.715919, 29.461700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.081050, 0.902797, 29.714400>, <5.932810, 0.911829, 29.588500>, <6.049280, 0.818199, 29.723300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.880910, 0.949830, 29.421000>, <5.824270, 0.911477, 29.457100>, <5.932810, 0.911829, 29.588500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.153960, 0.951587, 29.665700>, <6.003930, 0.963627, 29.532600>, <6.081050, 0.902797, 29.714400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.940270, 0.974152, 29.378400>, <5.880910, 0.949830, 29.421000>, <6.003930, 0.963627, 29.532600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.232820, 0.977505, 29.585700>, <6.080170, 0.989981, 29.485700>, <6.153960, 0.951587, 29.665700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.987430, 0.959700, 29.314800>, <5.940270, 0.974152, 29.378400>, <6.080170, 0.989981, 29.485700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.287030, 0.960362, 29.513200>, <6.131530, 0.970897, 29.407500>, <6.232820, 0.977505, 29.585700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.005670, 0.944619, 29.279300>, <5.987430, 0.959700, 29.314800>, <6.131530, 0.970897, 29.407500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.314220, 0.927287, 29.468400>, <6.147510, 0.942196, 29.367400>, <6.287030, 0.960362, 29.513200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.009670, 0.902608, 29.269600>, <6.002870, 0.942066, 29.285500>, <6.143180, 0.936050, 29.372500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.374760, 0.822684, 29.478400>, <6.157060, 0.844897, 29.343000>, <6.355990, 0.875527, 29.481300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.992550, 0.811052, 29.264300>, <6.009830, 0.858618, 29.257700>, <6.157060, 0.844897, 29.343000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.761060, 0.853570, 29.319500>, <5.763650, 0.800659, 29.381900>, <5.771400, 0.847783, 29.390600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.790170, 0.771046, 29.349900>, <5.761060, 0.853570, 29.319500>, <5.782690, 0.853772, 29.283800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.822030, 0.755012, 29.312200>, <5.790170, 0.771046, 29.349900>, <5.782690, 0.853772, 29.283800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.782690, 0.853772, 29.283800>, <5.761060, 0.853570, 29.319500>, <5.785870, 0.895048, 29.391100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869920, 0.769193, 29.271800>, <5.822030, 0.755012, 29.312200>, <5.814850, 0.856777, 29.258600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.814850, 0.856777, 29.258600>, <5.826040, 0.936663, 29.354900>, <5.880260, 0.953454, 29.323500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.851810, 0.866020, 29.236900>, <5.880260, 0.953454, 29.323500>, <5.913130, 0.947314, 29.274300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.851810, 0.866020, 29.236900>, <5.898680, 0.865971, 29.223400>, <5.904410, 0.791612, 29.232300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349790, 0.753410, 29.469900>, <6.575960, 0.805014, 29.608600>, <6.550980, 0.730112, 29.618600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.338120, 0.757122, 29.476700>, <6.136290, 0.790025, 29.350600>, <6.157060, 0.844897, 29.343000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.370750, 0.878498, 29.476500>, <6.557430, 0.878840, 29.630000>, <6.575960, 0.805014, 29.608600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.355990, 0.875527, 29.481300>, <6.153320, 0.896861, 29.355700>, <6.143180, 0.936050, 29.372500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.153320, 0.896861, 29.355700>, <6.009830, 0.858618, 29.257700>, <6.009670, 0.902608, 29.269600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.355990, 0.875527, 29.481300>, <6.157060, 0.844897, 29.343000>, <6.153320, 0.896861, 29.355700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.009670, 0.902608, 29.269600>, <5.870050, 0.877226, 29.163900>, <5.880550, 0.906496, 29.178500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.009670, 0.902608, 29.269600>, <6.143180, 0.936050, 29.372500>, <6.153320, 0.896861, 29.355700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.880550, 0.906496, 29.178500>, <6.002870, 0.942066, 29.285500>, <6.009670, 0.902608, 29.269600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.898680, 0.865971, 29.223400>, <5.931960, 0.930513, 29.240100>, <5.931250, 0.900356, 29.233300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.898680, 0.865971, 29.223400>, <5.930500, 0.864544, 29.225500>, <5.917580, 0.822314, 29.229500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.875390, 0.809434, 29.204300>, <5.866510, 0.838860, 29.175100>, <5.970230, 0.763687, 29.276600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.870050, 0.877226, 29.163900>, <6.009830, 0.858618, 29.257700>, <5.992550, 0.811052, 29.264300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.992550, 0.811052, 29.264300>, <6.157060, 0.844897, 29.343000>, <6.136290, 0.790025, 29.350600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.136290, 0.790025, 29.350600>, <5.970230, 0.763687, 29.276600>, <5.992550, 0.811052, 29.264300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.338120, 0.757122, 29.476700>, <6.107470, 0.739675, 29.366200>, <6.136290, 0.790025, 29.350600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.906410, 0.929881, 29.216800>, <5.931960, 0.930513, 29.240100>, <6.005670, 0.944619, 29.279300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.005670, 0.944619, 29.279300>, <6.002870, 0.942066, 29.285500>, <5.910100, 0.929320, 29.215800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.877480, 0.906470, 29.180300>, <5.931250, 0.900356, 29.233300>, <5.931960, 0.930513, 29.240100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.906410, 0.929881, 29.216800>, <5.910100, 0.929320, 29.215800>, <5.880550, 0.906496, 29.178500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.107470, 0.739675, 29.366200>, <6.110250, 0.734856, 29.360700>, <5.971830, 0.759873, 29.270100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.971830, 0.759873, 29.270100>, <5.970230, 0.763687, 29.276600>, <6.107470, 0.739675, 29.366200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.374760, 0.822684, 29.478400>, <6.389340, 0.824193, 29.473800>, <6.349790, 0.753410, 29.469900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.349790, 0.753410, 29.469900>, <6.338120, 0.757122, 29.476700>, <6.374760, 0.822684, 29.478400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.143180, 0.936050, 29.372500>, <6.147510, 0.942196, 29.367400>, <6.314220, 0.927287, 29.468400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.314220, 0.927287, 29.468400>, <6.304720, 0.921651, 29.470100>, <6.143180, 0.936050, 29.372500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.304720, 0.921651, 29.470100>, <6.314220, 0.927287, 29.468400>, <6.370750, 0.878498, 29.476500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.370750, 0.878498, 29.476500>, <6.355990, 0.875527, 29.481300>, <6.304720, 0.921651, 29.470100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.864240, 0.839572, 29.175800>, <5.917580, 0.822314, 29.229500>, <5.930500, 0.864544, 29.225500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869340, 0.877073, 29.165500>, <5.870050, 0.877226, 29.163900>, <5.866510, 0.838860, 29.175100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.279000, 0.725733, 29.464800>, <6.284830, 0.715919, 29.461700>, <6.110250, 0.734856, 29.360700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.110250, 0.734856, 29.360700>, <6.107470, 0.739675, 29.366200>, <6.279000, 0.725733, 29.464800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.338120, 0.757122, 29.476700>, <6.349790, 0.753410, 29.469900>, <6.284830, 0.715919, 29.461700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.284830, 0.715919, 29.461700>, <6.279000, 0.725733, 29.464800>, <6.338120, 0.757122, 29.476700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.002870, 0.942066, 29.285500>, <6.005670, 0.944619, 29.279300>, <6.147510, 0.942196, 29.367400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.147510, 0.942196, 29.367400>, <6.143180, 0.936050, 29.372500>, <6.002870, 0.942066, 29.285500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.355990, 0.875527, 29.481300>, <6.370750, 0.878498, 29.476500>, <6.389340, 0.824193, 29.473800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.389340, 0.824193, 29.473800>, <6.374760, 0.822684, 29.478400>, <6.355990, 0.875527, 29.481300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869340, 0.877073, 29.165500>, <5.930500, 0.864544, 29.225500>, <5.931250, 0.900356, 29.233300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.877480, 0.906470, 29.180300>, <5.880550, 0.906496, 29.178500>, <5.870050, 0.877226, 29.163900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.873750, 0.811597, 29.205600>, <5.904410, 0.791612, 29.232300>, <5.917580, 0.822314, 29.229500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.864240, 0.839572, 29.175800>, <5.866510, 0.838860, 29.175100>, <5.875390, 0.809434, 29.204300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.970230, 0.763687, 29.276600>, <5.971830, 0.759873, 29.270100>, <5.904410, 0.791612, 29.232300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.873750, 0.811597, 29.205600>, <5.875390, 0.809434, 29.204300>, <5.970230, 0.763687, 29.276600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.873750, 0.811597, 29.205600>, <5.917580, 0.822314, 29.229500>, <5.864240, 0.839572, 29.175800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.904410, 0.791612, 29.232300>, <5.873750, 0.811597, 29.205600>, <5.970230, 0.763687, 29.276600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.864240, 0.839572, 29.175800>, <5.930500, 0.864544, 29.225500>, <5.869340, 0.877073, 29.165500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.864240, 0.839572, 29.175800>, <5.875390, 0.809434, 29.204300>, <5.873750, 0.811597, 29.205600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869340, 0.877073, 29.165500>, <5.866510, 0.838860, 29.175100>, <5.864240, 0.839572, 29.175800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869340, 0.877073, 29.165500>, <5.931250, 0.900356, 29.233300>, <5.877480, 0.906470, 29.180300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.877480, 0.906470, 29.180300>, <5.931960, 0.930513, 29.240100>, <5.906410, 0.929881, 29.216800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.877480, 0.906470, 29.180300>, <5.870050, 0.877226, 29.163900>, <5.869340, 0.877073, 29.165500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.910100, 0.929320, 29.215800>, <5.906410, 0.929881, 29.216800>, <6.005670, 0.944619, 29.279300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.906410, 0.929881, 29.216800>, <5.880550, 0.906496, 29.178500>, <5.877480, 0.906470, 29.180300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.882650, 1.321640, 30.307200>, <7.023700, 1.309860, 30.467900>, <6.903480, 1.242680, 30.290200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.681750, 1.264810, 30.066900>, <6.579390, 1.275980, 29.965200>, <6.662440, 1.337400, 30.084700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.820920, 1.377530, 30.343100>, <6.956870, 1.369480, 30.501400>, <6.882650, 1.321640, 30.307200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.662440, 1.337400, 30.084700>, <6.563370, 1.341560, 29.984800>, <6.605790, 1.388900, 30.122900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.730820, 1.397100, 30.390200>, <6.859950, 1.391560, 30.545200>, <6.820920, 1.377530, 30.343100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.605790, 1.388900, 30.122900>, <6.517050, 1.388250, 30.028100>, <6.522490, 1.405800, 30.173300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.634440, 1.375300, 30.439100>, <6.760890, 1.368300, 30.586500>, <6.730820, 1.397100, 30.390200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.522490, 1.405800, 30.173300>, <6.447430, 1.401170, 30.085200>, <6.437650, 1.384990, 30.222200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.560230, 1.320070, 30.472300>, <6.688360, 1.308780, 30.613600>, <6.634440, 1.375300, 30.439100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.437650, 1.384990, 30.222200>, <6.376740, 1.381330, 30.141400>, <6.376410, 1.333320, 30.253700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.515580, 1.243480, 30.488500>, <6.657730, 1.225710, 30.620600>, <6.560230, 1.320070, 30.472300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.376410, 1.333320, 30.253700>, <6.326620, 1.333990, 30.177200>, <6.341040, 1.261670, 30.270100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.535880, 1.165970, 30.468900>, <6.680080, 1.142560, 30.604500>, <6.515580, 1.243480, 30.488500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341040, 1.261670, 30.270100>, <6.303940, 1.267440, 30.189900>, <6.354950, 1.190960, 30.249700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.595020, 1.110740, 30.433100>, <6.746680, 1.082910, 30.571000>, <6.535880, 1.165970, 30.468900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.354950, 1.190960, 30.249700>, <6.317670, 1.203090, 30.169700>, <6.403670, 1.140820, 30.215400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.711160, 1.086800, 30.374100>, <6.843420, 1.059480, 30.527100>, <6.595020, 1.110740, 30.433100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.403670, 1.140820, 30.215400>, <6.365850, 1.157200, 30.126700>, <6.502780, 1.120490, 30.158200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.807000, 1.106870, 30.327700>, <6.942530, 1.081450, 30.485700>, <6.711160, 1.086800, 30.374100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.502780, 1.120490, 30.158200>, <6.435230, 1.142120, 30.069200>, <6.592410, 1.138780, 30.108100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.874720, 1.163490, 30.298200>, <7.015290, 1.141000, 30.458700>, <6.807000, 1.106870, 30.327700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.592410, 1.138780, 30.108100>, <6.503870, 1.159520, 30.013000>, <6.655070, 1.191750, 30.076100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.903480, 1.242680, 30.290200>, <7.046090, 1.225420, 30.451800>, <6.874720, 1.163490, 30.298200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.655070, 1.191750, 30.076100>, <6.556570, 1.209380, 29.976300>, <6.681750, 1.264810, 30.066900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.366780, 1.229320, 29.943200>, <6.332210, 1.219650, 29.969700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.392850, 1.253700, 29.925200>, <6.366780, 1.229320, 29.943200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.403430, 1.286270, 29.920500>, <6.392850, 1.253700, 29.925200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.395650, 1.318290, 29.930400>, <6.403430, 1.286270, 29.920500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.371610, 1.341160, 29.952200>, <6.395650, 1.318290, 29.930400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.337760, 1.348750, 29.980000>, <6.371610, 1.341160, 29.952200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.303170, 1.339050, 30.006500>, <6.337760, 1.348750, 29.980000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.277090, 1.314660, 30.024500>, <6.303170, 1.339050, 30.006500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.266520, 1.282130, 30.029200>, <6.277090, 1.314660, 30.024500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.274300, 1.250140, 30.019300>, <6.266520, 1.282130, 30.029200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.298360, 1.227280, 29.997500>, <6.274300, 1.250140, 30.019300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.318960, 1.286090, 29.959100>, <6.332210, 1.219650, 29.969700>, <6.298360, 1.227280, 29.997500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.332210, 1.219650, 29.969700>, <6.433800, 1.183050, 29.963000>, <6.373890, 1.166170, 30.008900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.332210, 1.219650, 29.969700>, <6.366780, 1.229320, 29.943200>, <6.433800, 1.183050, 29.963000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.366780, 1.229320, 29.943200>, <6.478980, 1.225680, 29.931900>, <6.433800, 1.183050, 29.963000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.366780, 1.229320, 29.943200>, <6.392850, 1.253700, 29.925200>, <6.478980, 1.225680, 29.931900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392850, 1.253700, 29.925200>, <6.497300, 1.282660, 29.923800>, <6.478980, 1.225680, 29.931900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.392850, 1.253700, 29.925200>, <6.403430, 1.286270, 29.920500>, <6.497300, 1.282660, 29.923800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.403430, 1.286270, 29.920500>, <6.483860, 1.338660, 29.940900>, <6.497300, 1.282660, 29.923800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.403430, 1.286270, 29.920500>, <6.395650, 1.318290, 29.930400>, <6.483860, 1.338660, 29.940900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.395650, 1.318290, 29.930400>, <6.442240, 1.378660, 29.978700>, <6.483860, 1.338660, 29.940900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.395650, 1.318290, 29.930400>, <6.371610, 1.341160, 29.952200>, <6.442240, 1.378660, 29.978700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.371610, 1.341160, 29.952200>, <6.383620, 1.391930, 30.026900>, <6.442240, 1.378660, 29.978700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.371610, 1.341160, 29.952200>, <6.337760, 1.348750, 29.980000>, <6.383620, 1.391930, 30.026900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.337760, 1.348750, 29.980000>, <6.323700, 1.374940, 30.072700>, <6.383620, 1.391930, 30.026900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.337760, 1.348750, 29.980000>, <6.303170, 1.339050, 30.006500>, <6.323700, 1.374940, 30.072700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.303170, 1.339050, 30.006500>, <6.278520, 1.332290, 30.103800>, <6.323700, 1.374940, 30.072700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.303170, 1.339050, 30.006500>, <6.277090, 1.314660, 30.024500>, <6.278520, 1.332290, 30.103800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277090, 1.314660, 30.024500>, <6.260180, 1.275420, 30.111900>, <6.278520, 1.332290, 30.103800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277090, 1.314660, 30.024500>, <6.266520, 1.282130, 30.029200>, <6.260180, 1.275420, 30.111900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.266520, 1.282130, 30.029200>, <6.273660, 1.219510, 30.094800>, <6.260180, 1.275420, 30.111900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.266520, 1.282130, 30.029200>, <6.274300, 1.250140, 30.019300>, <6.273660, 1.219510, 30.094800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.274300, 1.250140, 30.019300>, <6.315270, 1.179530, 30.057100>, <6.273660, 1.219510, 30.094800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.274300, 1.250140, 30.019300>, <6.298360, 1.227280, 29.997500>, <6.315270, 1.179530, 30.057100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.298360, 1.227280, 29.997500>, <6.373890, 1.166170, 30.008900>, <6.315270, 1.179530, 30.057100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.298360, 1.227280, 29.997500>, <6.332210, 1.219650, 29.969700>, <6.373890, 1.166170, 30.008900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.373890, 1.166170, 30.008900>, <6.503870, 1.159520, 30.013000>, <6.435230, 1.142120, 30.069200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.373890, 1.166170, 30.008900>, <6.433800, 1.183050, 29.963000>, <6.503870, 1.159520, 30.013000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.433800, 1.183050, 29.963000>, <6.556570, 1.209380, 29.976300>, <6.503870, 1.159520, 30.013000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.433800, 1.183050, 29.963000>, <6.478980, 1.225680, 29.931900>, <6.556570, 1.209380, 29.976300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.478980, 1.225680, 29.931900>, <6.579390, 1.275980, 29.965200>, <6.556570, 1.209380, 29.976300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.478980, 1.225680, 29.931900>, <6.497300, 1.282660, 29.923800>, <6.579390, 1.275980, 29.965200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.497300, 1.282660, 29.923800>, <6.563370, 1.341560, 29.984800>, <6.579390, 1.275980, 29.965200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.497300, 1.282660, 29.923800>, <6.483860, 1.338660, 29.940900>, <6.563370, 1.341560, 29.984800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.483860, 1.338660, 29.940900>, <6.517050, 1.388250, 30.028100>, <6.563370, 1.341560, 29.984800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.483860, 1.338660, 29.940900>, <6.442240, 1.378660, 29.978700>, <6.517050, 1.388250, 30.028100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.442240, 1.378660, 29.978700>, <6.447430, 1.401170, 30.085200>, <6.517050, 1.388250, 30.028100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.442240, 1.378660, 29.978700>, <6.383620, 1.391930, 30.026900>, <6.447430, 1.401170, 30.085200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.383620, 1.391930, 30.026900>, <6.376740, 1.381330, 30.141400>, <6.447430, 1.401170, 30.085200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.383620, 1.391930, 30.026900>, <6.323700, 1.374940, 30.072700>, <6.376740, 1.381330, 30.141400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.323700, 1.374940, 30.072700>, <6.326620, 1.333990, 30.177200>, <6.376740, 1.381330, 30.141400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.323700, 1.374940, 30.072700>, <6.278520, 1.332290, 30.103800>, <6.326620, 1.333990, 30.177200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.278520, 1.332290, 30.103800>, <6.303940, 1.267440, 30.189900>, <6.326620, 1.333990, 30.177200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.278520, 1.332290, 30.103800>, <6.260180, 1.275420, 30.111900>, <6.303940, 1.267440, 30.189900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.260180, 1.275420, 30.111900>, <6.317670, 1.203090, 30.169700>, <6.303940, 1.267440, 30.189900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.260180, 1.275420, 30.111900>, <6.273660, 1.219510, 30.094800>, <6.317670, 1.203090, 30.169700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.273660, 1.219510, 30.094800>, <6.365850, 1.157200, 30.126700>, <6.317670, 1.203090, 30.169700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.273660, 1.219510, 30.094800>, <6.315270, 1.179530, 30.057100>, <6.365850, 1.157200, 30.126700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.315270, 1.179530, 30.057100>, <6.435230, 1.142120, 30.069200>, <6.365850, 1.157200, 30.126700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.315270, 1.179530, 30.057100>, <6.373890, 1.166170, 30.008900>, <6.435230, 1.142120, 30.069200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.326620, 1.333990, 30.177200>, <6.303940, 1.267440, 30.189900>, <6.341040, 1.261670, 30.270100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.515580, 1.243480, 30.488500>, <6.341040, 1.261670, 30.270100>, <6.535880, 1.165970, 30.468900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.303940, 1.267440, 30.189900>, <6.317670, 1.203090, 30.169700>, <6.354950, 1.190960, 30.249700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.535880, 1.165970, 30.468900>, <6.354950, 1.190960, 30.249700>, <6.595020, 1.110740, 30.433100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.376740, 1.381330, 30.141400>, <6.326620, 1.333990, 30.177200>, <6.376410, 1.333320, 30.253700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.560230, 1.320070, 30.472300>, <6.376410, 1.333320, 30.253700>, <6.515580, 1.243480, 30.488500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.447430, 1.401170, 30.085200>, <6.376740, 1.381330, 30.141400>, <6.437650, 1.384990, 30.222200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.634440, 1.375300, 30.439100>, <6.437650, 1.384990, 30.222200>, <6.560230, 1.320070, 30.472300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.317670, 1.203090, 30.169700>, <6.365850, 1.157200, 30.126700>, <6.403670, 1.140820, 30.215400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.595020, 1.110740, 30.433100>, <6.403670, 1.140820, 30.215400>, <6.711160, 1.086800, 30.374100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.365850, 1.157200, 30.126700>, <6.435230, 1.142120, 30.069200>, <6.502780, 1.120490, 30.158200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.711160, 1.086800, 30.374100>, <6.502780, 1.120490, 30.158200>, <6.807000, 1.106870, 30.327700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.435230, 1.142120, 30.069200>, <6.503870, 1.159520, 30.013000>, <6.592410, 1.138780, 30.108100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.807000, 1.106870, 30.327700>, <6.592410, 1.138780, 30.108100>, <6.874720, 1.163490, 30.298200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.503870, 1.159520, 30.013000>, <6.556570, 1.209380, 29.976300>, <6.655070, 1.191750, 30.076100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.874720, 1.163490, 30.298200>, <6.655070, 1.191750, 30.076100>, <6.903480, 1.242680, 30.290200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.517050, 1.388250, 30.028100>, <6.447430, 1.401170, 30.085200>, <6.522490, 1.405800, 30.173300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.730820, 1.397100, 30.390200>, <6.522490, 1.405800, 30.173300>, <6.634440, 1.375300, 30.439100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.563370, 1.341560, 29.984800>, <6.517050, 1.388250, 30.028100>, <6.605790, 1.388900, 30.122900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.820920, 1.377530, 30.343100>, <6.605790, 1.388900, 30.122900>, <6.730820, 1.397100, 30.390200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.579390, 1.275980, 29.965200>, <6.563370, 1.341560, 29.984800>, <6.662440, 1.337400, 30.084700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.882650, 1.321640, 30.307200>, <6.662440, 1.337400, 30.084700>, <6.820920, 1.377530, 30.343100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.903480, 1.242680, 30.290200>, <6.681750, 1.264810, 30.066900>, <6.882650, 1.321640, 30.307200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.556570, 1.209380, 29.976300>, <6.579390, 1.275980, 29.965200>, <6.681750, 1.264810, 30.066900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.655070, 1.191750, 30.076100>, <6.874720, 1.163490, 30.298200>, <6.592410, 1.138780, 30.108100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.874720, 1.163490, 30.298200>, <7.046090, 1.225420, 30.451800>, <7.015290, 1.141000, 30.458700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.681750, 1.264810, 30.066900>, <6.903480, 1.242680, 30.290200>, <6.655070, 1.191750, 30.076100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.903480, 1.242680, 30.290200>, <7.023700, 1.309860, 30.467900>, <7.046090, 1.225420, 30.451800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.662440, 1.337400, 30.084700>, <6.882650, 1.321640, 30.307200>, <6.681750, 1.264810, 30.066900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.882650, 1.321640, 30.307200>, <6.956870, 1.369480, 30.501400>, <7.023700, 1.309860, 30.467900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.592410, 1.138780, 30.108100>, <6.807000, 1.106870, 30.327700>, <6.502780, 1.120490, 30.158200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.807000, 1.106870, 30.327700>, <7.015290, 1.141000, 30.458700>, <6.942530, 1.081450, 30.485700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.502780, 1.120490, 30.158200>, <6.711160, 1.086800, 30.374100>, <6.403670, 1.140820, 30.215400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.711160, 1.086800, 30.374100>, <6.942530, 1.081450, 30.485700>, <6.843420, 1.059480, 30.527100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.403670, 1.140820, 30.215400>, <6.595020, 1.110740, 30.433100>, <6.354950, 1.190960, 30.249700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.595020, 1.110740, 30.433100>, <6.843420, 1.059480, 30.527100>, <6.746680, 1.082910, 30.571000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.354950, 1.190960, 30.249700>, <6.535880, 1.165970, 30.468900>, <6.341040, 1.261670, 30.270100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.535880, 1.165970, 30.468900>, <6.746680, 1.082910, 30.571000>, <6.680080, 1.142560, 30.604500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.605790, 1.388900, 30.122900>, <6.820920, 1.377530, 30.343100>, <6.662440, 1.337400, 30.084700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.820920, 1.377530, 30.343100>, <6.859950, 1.391560, 30.545200>, <6.956870, 1.369480, 30.501400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.522490, 1.405800, 30.173300>, <6.730820, 1.397100, 30.390200>, <6.605790, 1.388900, 30.122900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.730820, 1.397100, 30.390200>, <6.760890, 1.368300, 30.586500>, <6.859950, 1.391560, 30.545200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.437650, 1.384990, 30.222200>, <6.634440, 1.375300, 30.439100>, <6.522490, 1.405800, 30.173300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.634440, 1.375300, 30.439100>, <6.688360, 1.308780, 30.613600>, <6.760890, 1.368300, 30.586500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.376410, 1.333320, 30.253700>, <6.560230, 1.320070, 30.472300>, <6.437650, 1.384990, 30.222200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.560230, 1.320070, 30.472300>, <6.657730, 1.225710, 30.620600>, <6.688360, 1.308780, 30.613600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341040, 1.261670, 30.270100>, <6.515580, 1.243480, 30.488500>, <6.376410, 1.333320, 30.253700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.515580, 1.243480, 30.488500>, <6.680080, 1.142560, 30.604500>, <6.657730, 1.225710, 30.620600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.861600, 1.285020, 29.806200>, <5.892560, 1.260490, 29.861900>, <5.896190, 1.318530, 29.871900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.917410, 1.231120, 29.824900>, <5.892560, 1.260490, 29.861900>, <5.861600, 1.285020, 29.806200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.956650, 1.219140, 29.775400>, <5.917410, 1.231120, 29.824900>, <5.882770, 1.259910, 29.776800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.999820, 1.233150, 29.735000>, <5.956650, 1.219140, 29.775400>, <5.908410, 1.246610, 29.742400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.035820, 1.250450, 29.699500>, <5.999820, 1.233150, 29.735000>, <5.948070, 1.259320, 29.705700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.053930, 1.294600, 29.694600>, <6.034770, 1.253620, 29.705300>, <5.941460, 1.321620, 29.624000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.981750, 1.398500, 29.659000>, <6.065040, 1.407220, 29.715200>, <5.954360, 1.379850, 29.627700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.053200, 1.421950, 29.741600>, <6.067190, 1.409530, 29.709800>, <6.001710, 1.398820, 29.679100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.015500, 1.433450, 29.798900>, <6.053200, 1.421950, 29.741600>, <5.987160, 1.412750, 29.709700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.965960, 1.412020, 29.837800>, <6.015500, 1.433450, 29.798900>, <5.961060, 1.417270, 29.753800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.918330, 1.378590, 29.870700>, <5.965960, 1.412020, 29.837800>, <5.915530, 1.402550, 29.783000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.896190, 1.318530, 29.871900>, <5.918330, 1.378590, 29.870700>, <5.882090, 1.366160, 29.815100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.129370, 1.218500, 30.063200>, <6.324810, 1.203110, 30.169000>, <6.123510, 1.290360, 30.088200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.993980, 1.303330, 29.983100>, <5.896190, 1.318530, 29.871900>, <5.988930, 1.234840, 29.960200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.163070, 1.183910, 30.014500>, <6.368780, 1.159450, 30.124700>, <6.129370, 1.218500, 30.063200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.988930, 1.234840, 29.960200>, <5.892560, 1.260490, 29.861900>, <6.025160, 1.204650, 29.916000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.218230, 1.166270, 29.943000>, <6.433600, 1.144830, 30.066000>, <6.163070, 1.183910, 30.014500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.025160, 1.204650, 29.916000>, <5.917410, 1.231120, 29.824900>, <6.072800, 1.188150, 29.855600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.276100, 1.180110, 29.885700>, <6.499720, 1.165000, 30.010300>, <6.218230, 1.166270, 29.943000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.072800, 1.188150, 29.855600>, <5.956650, 1.219140, 29.775400>, <6.126930, 1.198760, 29.800500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.314040, 1.205690, 29.849700>, <6.550850, 1.212300, 29.973400>, <6.276100, 1.180110, 29.885700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.999820, 1.233150, 29.735000>, <6.035820, 1.250450, 29.699500>, <6.159070, 1.225710, 29.770900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.405790, 1.298060, 29.857800>, <6.572680, 1.277000, 29.965300>, <6.370830, 1.237350, 29.854700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.156970, 1.229780, 29.775800>, <6.034770, 1.253620, 29.705300>, <6.181620, 1.273360, 29.762200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341730, 1.387860, 29.858700>, <6.558350, 1.340460, 29.986200>, <6.390400, 1.345070, 29.862100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.199720, 1.320740, 29.755800>, <6.069010, 1.335680, 29.689200>, <6.197570, 1.365380, 29.768100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.320600, 1.415690, 29.899300>, <6.515720, 1.384050, 30.030800>, <6.341730, 1.387860, 29.858700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.193510, 1.404330, 29.779400>, <6.067190, 1.409530, 29.709800>, <6.181790, 1.428390, 29.815300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277220, 1.429390, 29.964600>, <6.450840, 1.398840, 30.088300>, <6.320600, 1.415690, 29.899300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.181790, 1.428390, 29.815300>, <6.053200, 1.421950, 29.741600>, <6.141150, 1.443620, 29.885400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212520, 1.405940, 30.036600>, <6.382870, 1.378810, 30.145900>, <6.277220, 1.429390, 29.964600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.141150, 1.443620, 29.885400>, <6.015500, 1.433450, 29.798900>, <6.077220, 1.420490, 29.928800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.151330, 1.363360, 30.080900>, <6.333560, 1.331290, 30.180600>, <6.212520, 1.405940, 30.036600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.077220, 1.420490, 29.928800>, <5.965960, 1.412020, 29.837800>, <6.017870, 1.375140, 29.979200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.123510, 1.290360, 30.088200>, <6.312560, 1.266190, 30.192200>, <6.151330, 1.363360, 30.080900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.017870, 1.375140, 29.979200>, <5.918330, 1.378590, 29.870700>, <5.993980, 1.303330, 29.983100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.025160, 1.204650, 29.916000>, <6.163070, 1.183910, 30.014500>, <5.988930, 1.234840, 29.960200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.163070, 1.183910, 30.014500>, <6.433600, 1.144830, 30.066000>, <6.368780, 1.159450, 30.124700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.072800, 1.188150, 29.855600>, <6.218230, 1.166270, 29.943000>, <6.025160, 1.204650, 29.916000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.218230, 1.166270, 29.943000>, <6.499720, 1.165000, 30.010300>, <6.433600, 1.144830, 30.066000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.126930, 1.198760, 29.800500>, <6.276100, 1.180110, 29.885700>, <6.072800, 1.188150, 29.855600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.276100, 1.180110, 29.885700>, <6.550850, 1.212300, 29.973400>, <6.499720, 1.165000, 30.010300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.988930, 1.234840, 29.960200>, <6.129370, 1.218500, 30.063200>, <5.993980, 1.303330, 29.983100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.129370, 1.218500, 30.063200>, <6.368780, 1.159450, 30.124700>, <6.324810, 1.203110, 30.169000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.123510, 1.290360, 30.088200>, <6.324810, 1.203110, 30.169000>, <6.312560, 1.266190, 30.192200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.993980, 1.303330, 29.983100>, <6.123510, 1.290360, 30.088200>, <6.017870, 1.375140, 29.979200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.314040, 1.205690, 29.849700>, <6.276100, 1.180110, 29.885700>, <6.126930, 1.198760, 29.800500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.550850, 1.212300, 29.973400>, <6.314040, 1.205690, 29.849700>, <6.370830, 1.237350, 29.854700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.199720, 1.320740, 29.755800>, <6.393420, 1.296780, 29.862400>, <6.361090, 1.240500, 29.861200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.572680, 1.277000, 29.965300>, <6.405790, 1.298060, 29.857800>, <6.390400, 1.345070, 29.862100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.189940, 1.398950, 29.783800>, <6.333550, 1.383040, 29.860500>, <6.377840, 1.342520, 29.866800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341730, 1.387860, 29.858700>, <6.515720, 1.384050, 30.030800>, <6.558350, 1.340460, 29.986200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.181790, 1.428390, 29.815300>, <6.320600, 1.415690, 29.899300>, <6.193510, 1.404330, 29.779400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.320600, 1.415690, 29.899300>, <6.450840, 1.398840, 30.088300>, <6.515720, 1.384050, 30.030800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.141150, 1.443620, 29.885400>, <6.277220, 1.429390, 29.964600>, <6.181790, 1.428390, 29.815300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277220, 1.429390, 29.964600>, <6.382870, 1.378810, 30.145900>, <6.450840, 1.398840, 30.088300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.077220, 1.420490, 29.928800>, <6.212520, 1.405940, 30.036600>, <6.141150, 1.443620, 29.885400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212520, 1.405940, 30.036600>, <6.333560, 1.331290, 30.180600>, <6.382870, 1.378810, 30.145900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.017870, 1.375140, 29.979200>, <6.151330, 1.363360, 30.080900>, <6.077220, 1.420490, 29.928800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.151330, 1.363360, 30.080900>, <6.312560, 1.266190, 30.192200>, <6.333560, 1.331290, 30.180600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.971630, 1.343710, 29.664800>, <5.987800, 1.305720, 29.668200>, <5.976260, 1.279250, 29.670600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.944370, 1.354970, 29.615000>, <6.069820, 1.373420, 29.700400>, <6.069010, 1.335680, 29.689200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.976260, 1.279250, 29.670600>, <5.948070, 1.259320, 29.705700>, <5.931800, 1.343860, 29.678500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.941460, 1.321620, 29.624000>, <5.944370, 1.354970, 29.615000>, <6.053930, 1.294600, 29.694600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.900790, 1.335720, 29.698700>, <5.961060, 1.417270, 29.753800>, <5.931800, 1.343860, 29.678500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.948070, 1.259320, 29.705700>, <5.976260, 1.279250, 29.670600>, <6.035820, 1.250450, 29.699500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.874150, 1.332850, 29.721800>, <5.915530, 1.402550, 29.783000>, <5.900790, 1.335720, 29.698700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.908410, 1.246610, 29.742400>, <5.948070, 1.259320, 29.705700>, <5.999820, 1.233150, 29.735000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.882770, 1.259910, 29.776800>, <5.861600, 1.285020, 29.806200>, <5.857090, 1.332090, 29.753600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.882770, 1.259910, 29.776800>, <5.908410, 1.246610, 29.742400>, <5.956650, 1.219140, 29.775400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869130, 1.325460, 29.814300>, <5.882090, 1.366160, 29.815100>, <5.857090, 1.332090, 29.753600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.861600, 1.285020, 29.806200>, <5.882770, 1.259910, 29.776800>, <5.917410, 1.231120, 29.824900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.882090, 1.366160, 29.815100>, <5.915530, 1.402550, 29.783000>, <5.874150, 1.332850, 29.721800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.869130, 1.325460, 29.814300>, <5.861600, 1.285020, 29.806200>, <5.896190, 1.318530, 29.871900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.900790, 1.335720, 29.698700>, <5.908410, 1.246610, 29.742400>, <5.874150, 1.332850, 29.721800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.882090, 1.366160, 29.815100>, <5.869130, 1.325460, 29.814300>, <5.896190, 1.318530, 29.871900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931800, 1.343860, 29.678500>, <5.948070, 1.259320, 29.705700>, <5.900790, 1.335720, 29.698700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.915530, 1.402550, 29.783000>, <5.882090, 1.366160, 29.815100>, <5.918330, 1.378590, 29.870700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.987160, 1.412750, 29.709700>, <5.971630, 1.343710, 29.664800>, <5.931800, 1.343860, 29.678500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.961060, 1.417270, 29.753800>, <5.915530, 1.402550, 29.783000>, <5.965960, 1.412020, 29.837800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.971630, 1.343710, 29.664800>, <5.987160, 1.412750, 29.709700>, <6.001710, 1.398820, 29.679100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.987160, 1.412750, 29.709700>, <5.961060, 1.417270, 29.753800>, <6.015500, 1.433450, 29.798900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.971630, 1.343710, 29.664800>, <6.000500, 1.372930, 29.672500>, <5.999160, 1.342170, 29.665100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.001710, 1.398820, 29.679100>, <5.987160, 1.412750, 29.709700>, <6.053200, 1.421950, 29.741600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.123510, 1.290360, 30.088200>, <5.993980, 1.303330, 29.983100>, <6.129370, 1.218500, 30.063200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.918330, 1.378590, 29.870700>, <5.896190, 1.318530, 29.871900>, <5.993980, 1.303330, 29.983100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.129370, 1.218500, 30.063200>, <5.988930, 1.234840, 29.960200>, <6.163070, 1.183910, 30.014500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.896190, 1.318530, 29.871900>, <5.892560, 1.260490, 29.861900>, <5.988930, 1.234840, 29.960200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.163070, 1.183910, 30.014500>, <6.025160, 1.204650, 29.916000>, <6.218230, 1.166270, 29.943000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.892560, 1.260490, 29.861900>, <5.917410, 1.231120, 29.824900>, <6.025160, 1.204650, 29.916000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.218230, 1.166270, 29.943000>, <6.072800, 1.188150, 29.855600>, <6.276100, 1.180110, 29.885700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.917410, 1.231120, 29.824900>, <5.956650, 1.219140, 29.775400>, <6.072800, 1.188150, 29.855600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.159070, 1.225710, 29.770900>, <6.126930, 1.198760, 29.800500>, <5.999820, 1.233150, 29.735000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.956650, 1.219140, 29.775400>, <5.999820, 1.233150, 29.735000>, <6.126930, 1.198760, 29.800500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.309250, 1.214150, 29.852900>, <6.156970, 1.229780, 29.775800>, <6.361090, 1.240500, 29.861200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.126930, 1.198760, 29.800500>, <6.159070, 1.225710, 29.770900>, <6.314040, 1.205690, 29.849700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.151330, 1.363360, 30.080900>, <6.017870, 1.375140, 29.979200>, <6.123510, 1.290360, 30.088200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.965960, 1.412020, 29.837800>, <5.918330, 1.378590, 29.870700>, <6.017870, 1.375140, 29.979200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.212520, 1.405940, 30.036600>, <6.077220, 1.420490, 29.928800>, <6.151330, 1.363360, 30.080900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.015500, 1.433450, 29.798900>, <5.965960, 1.412020, 29.837800>, <6.077220, 1.420490, 29.928800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.277220, 1.429390, 29.964600>, <6.141150, 1.443620, 29.885400>, <6.212520, 1.405940, 30.036600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.053200, 1.421950, 29.741600>, <6.015500, 1.433450, 29.798900>, <6.141150, 1.443620, 29.885400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.320600, 1.415690, 29.899300>, <6.181790, 1.428390, 29.815300>, <6.277220, 1.429390, 29.964600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.067190, 1.409530, 29.709800>, <6.053200, 1.421950, 29.741600>, <6.181790, 1.428390, 29.815300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341730, 1.387860, 29.858700>, <6.193510, 1.404330, 29.779400>, <6.320600, 1.415690, 29.899300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.069820, 1.373420, 29.700400>, <6.065040, 1.407220, 29.715200>, <6.189940, 1.398950, 29.783800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.393420, 1.296780, 29.862400>, <6.199720, 1.320740, 29.755800>, <6.377840, 1.342520, 29.866800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.053930, 1.294600, 29.694600>, <6.069010, 1.335680, 29.689200>, <6.199720, 1.320740, 29.755800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.857090, 1.332090, 29.753600>, <5.861600, 1.285020, 29.806200>, <5.869130, 1.325460, 29.814300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.882770, 1.259910, 29.776800>, <5.857090, 1.332090, 29.753600>, <5.874150, 1.332850, 29.721800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.908410, 1.246610, 29.742400>, <5.882770, 1.259910, 29.776800>, <5.874150, 1.332850, 29.721800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.874150, 1.332850, 29.721800>, <5.857090, 1.332090, 29.753600>, <5.882090, 1.366160, 29.815100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.948070, 1.259320, 29.705700>, <5.908410, 1.246610, 29.742400>, <5.900790, 1.335720, 29.698700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.900790, 1.335720, 29.698700>, <5.915530, 1.402550, 29.783000>, <5.961060, 1.417270, 29.753800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931800, 1.343860, 29.678500>, <5.961060, 1.417270, 29.753800>, <5.987160, 1.412750, 29.709700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.931800, 1.343860, 29.678500>, <5.971630, 1.343710, 29.664800>, <5.976260, 1.279250, 29.670600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.370830, 1.237350, 29.854700>, <6.572680, 1.277000, 29.965300>, <6.550850, 1.212300, 29.973400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.361090, 1.240500, 29.861200>, <6.181620, 1.273360, 29.762200>, <6.199720, 1.320740, 29.755800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.390400, 1.345070, 29.862100>, <6.558350, 1.340460, 29.986200>, <6.572680, 1.277000, 29.965300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.377840, 1.342520, 29.866800>, <6.197570, 1.365380, 29.768100>, <6.189940, 1.398950, 29.783800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.197570, 1.365380, 29.768100>, <6.069010, 1.335680, 29.689200>, <6.069820, 1.373420, 29.700400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.377840, 1.342520, 29.866800>, <6.199720, 1.320740, 29.755800>, <6.197570, 1.365380, 29.768100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.069820, 1.373420, 29.700400>, <5.944370, 1.354970, 29.615000>, <5.954360, 1.379850, 29.627700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.069820, 1.373420, 29.700400>, <6.189940, 1.398950, 29.783800>, <6.197570, 1.365380, 29.768100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.954360, 1.379850, 29.627700>, <6.065040, 1.407220, 29.715200>, <6.069820, 1.373420, 29.700400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.971630, 1.343710, 29.664800>, <6.001710, 1.398820, 29.679100>, <6.000500, 1.372930, 29.672500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.971630, 1.343710, 29.664800>, <5.999160, 1.342170, 29.665100>, <5.987800, 1.305720, 29.668200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.950140, 1.295490, 29.648100>, <5.941460, 1.321620, 29.624000>, <6.034770, 1.253620, 29.705300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.944370, 1.354970, 29.615000>, <6.069010, 1.335680, 29.689200>, <6.053930, 1.294600, 29.694600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.053930, 1.294600, 29.694600>, <6.199720, 1.320740, 29.755800>, <6.181620, 1.273360, 29.762200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.181620, 1.273360, 29.762200>, <6.034770, 1.253620, 29.705300>, <6.053930, 1.294600, 29.694600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.361090, 1.240500, 29.861200>, <6.156970, 1.229780, 29.775800>, <6.181620, 1.273360, 29.762200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.978620, 1.399000, 29.660100>, <6.001710, 1.398820, 29.679100>, <6.067190, 1.409530, 29.709800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.067190, 1.409530, 29.709800>, <6.065040, 1.407220, 29.715200>, <5.981750, 1.398500, 29.659000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.951790, 1.379810, 29.629400>, <6.000500, 1.372930, 29.672500>, <6.001710, 1.398820, 29.679100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.978620, 1.399000, 29.660100>, <5.981750, 1.398500, 29.659000>, <5.954360, 1.379850, 29.627700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.156970, 1.229780, 29.775800>, <6.159070, 1.225710, 29.770900>, <6.035820, 1.250450, 29.699500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.035820, 1.250450, 29.699500>, <6.034770, 1.253620, 29.705300>, <6.156970, 1.229780, 29.775800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.393420, 1.296780, 29.862400>, <6.405790, 1.298060, 29.857800>, <6.370830, 1.237350, 29.854700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.370830, 1.237350, 29.854700>, <6.361090, 1.240500, 29.861200>, <6.393420, 1.296780, 29.862400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.189940, 1.398950, 29.783800>, <6.193510, 1.404330, 29.779400>, <6.341730, 1.387860, 29.858700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.341730, 1.387860, 29.858700>, <6.333550, 1.383040, 29.860500>, <6.189940, 1.398950, 29.783800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.333550, 1.383040, 29.860500>, <6.341730, 1.387860, 29.858700>, <6.390400, 1.345070, 29.862100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.390400, 1.345070, 29.862100>, <6.377840, 1.342520, 29.866800>, <6.333550, 1.383040, 29.860500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.939530, 1.322240, 29.624700>, <5.987800, 1.305720, 29.668200>, <5.999160, 1.342170, 29.665100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.943840, 1.354800, 29.616400>, <5.944370, 1.354970, 29.615000>, <5.941460, 1.321620, 29.624000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.309250, 1.214150, 29.852900>, <6.314040, 1.205690, 29.849700>, <6.159070, 1.225710, 29.770900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.159070, 1.225710, 29.770900>, <6.156970, 1.229780, 29.775800>, <6.309250, 1.214150, 29.852900> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.361090, 1.240500, 29.861200>, <6.370830, 1.237350, 29.854700>, <6.314040, 1.205690, 29.849700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.314040, 1.205690, 29.849700>, <6.309250, 1.214150, 29.852900>, <6.361090, 1.240500, 29.861200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.065040, 1.407220, 29.715200>, <6.067190, 1.409530, 29.709800>, <6.193510, 1.404330, 29.779400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.193510, 1.404330, 29.779400>, <6.189940, 1.398950, 29.783800>, <6.065040, 1.407220, 29.715200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.377840, 1.342520, 29.866800>, <6.390400, 1.345070, 29.862100>, <6.405790, 1.298060, 29.857800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.405790, 1.298060, 29.857800>, <6.393420, 1.296780, 29.862400>, <6.377840, 1.342520, 29.866800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.943840, 1.354800, 29.616400>, <5.999160, 1.342170, 29.665100>, <6.000500, 1.372930, 29.672500> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.951790, 1.379810, 29.629400>, <5.954360, 1.379850, 29.627700>, <5.944370, 1.354970, 29.615000> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.948800, 1.297350, 29.649400>, <5.976260, 1.279250, 29.670600>, <5.987800, 1.305720, 29.668200> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.939530, 1.322240, 29.624700>, <5.941460, 1.321620, 29.624000>, <5.950140, 1.295490, 29.648100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <6.034770, 1.253620, 29.705300>, <6.035820, 1.250450, 29.699500>, <5.976260, 1.279250, 29.670600> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.948800, 1.297350, 29.649400>, <5.950140, 1.295490, 29.648100>, <6.034770, 1.253620, 29.705300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.948800, 1.297350, 29.649400>, <5.987800, 1.305720, 29.668200>, <5.939530, 1.322240, 29.624700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.976260, 1.279250, 29.670600>, <5.948800, 1.297350, 29.649400>, <6.034770, 1.253620, 29.705300> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.939530, 1.322240, 29.624700>, <5.999160, 1.342170, 29.665100>, <5.943840, 1.354800, 29.616400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.939530, 1.322240, 29.624700>, <5.950140, 1.295490, 29.648100>, <5.948800, 1.297350, 29.649400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.943840, 1.354800, 29.616400>, <5.941460, 1.321620, 29.624000>, <5.939530, 1.322240, 29.624700> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.943840, 1.354800, 29.616400>, <6.000500, 1.372930, 29.672500>, <5.951790, 1.379810, 29.629400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.951790, 1.379810, 29.629400>, <6.001710, 1.398820, 29.679100>, <5.978620, 1.399000, 29.660100> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.951790, 1.379810, 29.629400>, <5.944370, 1.354970, 29.615000>, <5.943840, 1.354800, 29.616400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.981750, 1.398500, 29.659000>, <5.978620, 1.399000, 29.660100>, <6.067190, 1.409530, 29.709800> }
    texture { 
      pigment { Jade} // alien hand
    }
  }

  object {
    triangle { <5.978620, 1.399000, 29.660100>, <5.954360, 1.379850, 29.627700>, <5.951790, 1.379810, 29.629400> }
    texture { 
      pigment { Jade} // alien hand
    }
  }


// The earth. The textures were taken off the povray tutorial.
  sphere {
	<5, .8, 32>, 1.5
        texture { LandArea }
        texture { OceanArea }
        texture { CloudArea }            
  }
                                              
  rotate 95*z
  rotate 5*x
  translate <0, -2, -26>

}


