#include "colors.inc"

#declare Half_Torus = difference {
  torus { 4,1
    sturm
    rotate x*-90  // so we can see it from the top
  }
  box { <-5, -5, -1>, <5, 0, 1> }
}

#declare Flip_It_Over = x*180

#declare Torus_Translate = 8

#declare Chain_Segment = cylinder { <0, 4, 0>, <0, -4, 0>, 1 }

#declare Link_Translate = Torus_Translate*2-2*y

#declare Chain_Gold = texture {
  pigment { Silver }
  finish {
    ambient .1
    diffuse .4
    reflection .25
    specular 1
    metallic
  }
}

#declare Link = union {
  object { Half_Torus
    translate y*Torus_Translate/2
  }
  object { Half_Torus
    rotate Flip_It_Over
    translate -y*Torus_Translate/2
  }
  object { Chain_Segment
    translate x*Torus_Translate/2
  }
  object { Chain_Segment
    translate -x*Torus_Translate/2
  }
   texture { Chain_Gold }
}

#declare Link_Pair = union {
  object { Link }
  object { Link translate y*Link_Translate rotate y*90 }
}

 #declare Chain = union {
  object { Link_Pair translate  y*Link_Translate*-10 }
  object { Link_Pair translate  y*Link_Translate*-8 }
  object { Link_Pair translate  y*Link_Translate*-6 }
  object { Link_Pair translate  y*Link_Translate*-4 }
  object { Link_Pair translate  y*Link_Translate*-2 }
  object { Link_Pair}
  object { Link_Pair translate  y*Link_Translate*2 }
  object { Link_Pair translate  y*Link_Translate*4 }
  object { Link_Pair translate  y*Link_Translate*6 }
  object { Link_Pair translate  y*Link_Translate*8 }
  object { Link_Pair translate  y*Link_Translate*10 }
  object { Link_Pair translate  y*Link_Translate*12 }
  object { Link_Pair translate  y*Link_Translate*14 }
  object { Link_Pair translate  y*Link_Translate*16}
  object { Link_Pair translate  y*Link_Translate*18 }
  object { Link_Pair translate  y*Link_Translate*20 }
  object { Link_Pair translate  y*Link_Translate*22 }
  object { Link_Pair translate  y*Link_Translate*24}
  object { Link_Pair translate  y*Link_Translate*26 }
  object { Link_Pair translate  y*Link_Translate*28 }
  object { Link_Pair translate  y*Link_Translate*30 }
  object { Link_Pair translate  y*Link_Translate*32}
  object { Link_Pair translate  y*Link_Translate*34 }
 }
